#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15898);
 script_version ("$Revision: 1.5 $");
 if ( NASL_LEVEL >= 2191 ){ script_cve_id("CAN-2004-1082", "CAN-2003-0020", "CAN-2003-0987", "CAN-2003-0174", "CAN-2004-0488", "CAN-2004-0492", "CAN-2004-0885", "CAN-2004-0940", "CAN-2004-1083", "CAN-2004-1084", "CAN-2004-0747", "CAN-2004-0786", "CAN-2004-0751", "CAN-2004-0748", "CAN-2004-1081", "CAN-2004-0803", "CAN-2004-0804", "CAN-2004-0886", "CAN-2004-1089", "CAN-2004-1085", "CAN-2004-0642", "CAN-2004-0643", "CAN-2004-0644", "CAN-2004-0772", "CAN-2004-1088", "CAN-2004-1086", "CAN-2004-1123", "CAN-2004-1121", "CAN-2004-1122", "CAN-2004-1087");
	script_bugtraq_id(9921, 9930, 9571, 11471, 11360, 10508, 11802);
	}
 name["english"] = "Security Update 2004-12-02";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Security Update 2004-12-02. This security
update contains a number of enhancements for the following programs :

- Apache
- Apache2
- AppKit
- Cyrus IMAP
- HIToolbox
- Kerberos
- Postfix
- PSNormalizer
- QuickTime Streaming Server
- Safari
- Terminal 

Solution : http://docs.info.apple.com/article.html?artnum=61798
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for Security Update 2004-12-02";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "MacOS X Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/MacOSX/packages");
 exit(0);
}


packages = get_kb_item("Host/MacOSX/packages");
if ( ! packages ) exit(0);

uname = get_kb_item("Host/uname");
# MacOS X 10.2.8, 10.3.6 only
if ( egrep(pattern:"Darwin.* (6\.8\.|7\.6\.)", string:uname) )
{
  if ( ! egrep(pattern:"^SecUpd(Srvr)?2004-12-02", string:packages) ) security_hole(0);
	else non_vuln = 1;
}
else if ( egrep(pattern:"Darwin.* (6\.9|[0-9][0-9]\.|7\.([7-9]|[0-9][0-9]\.|[8-9]\.))", string:uname) ) non_vuln = 1;

if ( non_vuln )
{
   set_kb_item(name:"CAN-2004-1082", value:TRUE);
   set_kb_item(name:"CAN-2003-0020", value:TRUE);
   set_kb_item(name:"CAN-2003-0987", value:TRUE);
   set_kb_item(name:"CAN-2004-0174", value:TRUE);
   set_kb_item(name:"CAN-2004-0488", value:TRUE);
   set_kb_item(name:"CAN-2004-0492", value:TRUE);
   set_kb_item(name:"CAN-2004-0885", value:TRUE);
   set_kb_item(name:"CAN-2004-0940", value:TRUE);
   set_kb_item(name:"CAN-2004-1083", value:TRUE);
   set_kb_item(name:"CAN-2004-1084", value:TRUE);
   set_kb_item(name:"CAN-2004-0747", value:TRUE);
   set_kb_item(name:"CAN-2004-0786", value:TRUE);
   set_kb_item(name:"CAN-2004-0751", value:TRUE);
   set_kb_item(name:"CAN-2004-0748", value:TRUE);
   set_kb_item(name:"CAN-2004-1081", value:TRUE);
   set_kb_item(name:"CAN-2004-0803", value:TRUE);
   set_kb_item(name:"CAN-2004-0804", value:TRUE);
   set_kb_item(name:"CAN-2004-0886", value:TRUE);
   set_kb_item(name:"CAN-2004-1089", value:TRUE);
   set_kb_item(name:"CAN-2004-1085", value:TRUE);
   set_kb_item(name:"CAN-2004-0642", value:TRUE);
   set_kb_item(name:"CAN-2004-0643", value:TRUE);
   set_kb_item(name:"CAN-2004-0644", value:TRUE);
   set_kb_item(name:"CAN-2004-0772", value:TRUE);
   set_kb_item(name:"CAN-2004-1088", value:TRUE);
   set_kb_item(name:"CAN-2004-1086", value:TRUE);
   set_kb_item(name:"CAN-2004-1123", value:TRUE);
   set_kb_item(name:"CAN-2004-1121", value:TRUE);
   set_kb_item(name:"CAN-2004-1122", value:TRUE);
   set_kb_item(name:"CAN-2004-1087", value:TRUE);
}
