#
# This script was written by Renaud Deraison
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(12642);
 script_bugtraq_id(10681);
 script_version("$Revision: 1.6 $");

 name["english"] = "Mozilla/Firefox code execution";

 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is using Mozilla and/or Firefox, an alternative web browser.

The remote version of this software contains a weakness which may allow an
attacker to execute arbitrary programs on the remote host.

Solution : See http://mozilla.org/security/shell.html
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the version of Mozilla/Firefox";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("netbios_name_get.nasl",
 		     "smb_login.nasl","smb_registry_access.nasl");
 script_require_keys("SMB/name", "SMB/login", "SMB/password",
		     "SMB/WindowsVersion",
		     "SMB/registry_access");

 script_require_ports(139, 445);
 exit(0);
}


include("smb_nt.inc");


moz = registry_get_sz(key:"SOFTWARE\mozilla.org\Mozilla", item:"CurrentVersion");
if ( moz )
{
  key = "SOFTWARE\mozilla.org\Mozilla\" + moz + "\Main";
  exist = registry_get_sz(key:key, item:"PathToExe");
  set_kb_item(name:"Mozilla/Version", value:moz);
  if ( exist && ereg(pattern:"^(0\.|1\.([0-6]\.|7\.0))", string:moz) ) 
  {
   security_hole(0);
   flag = 1;
  }
}


fox = registry_get_sz(key:"SOFTWARE\Mozilla\Mozilla Firefox", item:"CurrentVersion");
if (fox)
{
  set_kb_item(name:"Mozilla/Firefox/Version", value:fox);
  if (ereg(pattern:"0\.([0-8]\.|9\.[01][^0-9])", string:fox) )
     {
     if ( ! flag ) security_hole(0);
     }
}
else
{
 fox = registry_get_sz(key:"SOFTWARE\mozilla.org\Mozilla Firefox", item:"CurrentVersion");
 set_kb_item(name:"Mozilla/Firefox/Version", value:fox);
 if ( fox && ereg(pattern:"0\.([0-8]\.|9\.[01][^0-9])", string:fox) )
  {
   if ( ! flag ) security_hole(0);
  }
}

thunderbird = registry_get_sz(key:"SOFTWARE\Mozilla\Mozilla Thunderbird", item:"CurrentVersion");
if ( thunderbird )
{
 set_kb_item(name:"Mozilla/ThunderBird/Version", value:thunderbird);
}
