#
# (C) Tenable Network Security
#


if(description)
{
 script_id(12209);
 script_version("$Revision: 1.5 $");
 if(defined_func("script_xref"))script_xref(name:"IAVA", value:"2004-A-0006");

 name["english"] = "Microsoft Hotfix for KB835732 (SMB check)";

 script_name(english:name["english"]);

 desc["english"] = "
The remote host seems to be running a version of Microsoft OS 
which is vulnerable to several flaws, ranging from  denial of service
to remote code execution.  Microsoft has released a Hotfix (KB835732)
which addresses these issues.

Solution : Install the Windows cumulative update from Microsoft

See also : http://www.microsoft.com/technet/security/bulletin/ms04-011.mspx

Risk factor : High";


 script_description(english:desc["english"]);

 summary["english"] = "Checks for Microsoft Hotfix KB835732 by talking to the remote SMB service";

 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 script_dependencies("cifs445.nasl");
 script_require_ports(139,445);
 exit(0);
}

include("smb_nt.inc");
function smb_neg_prot_gssapi(soc)
{
 local_var neg_prot, r;
 
 neg_prot = raw_string
   	(
	 0x00, 0x00, 0x00, 0xA4, 0xFF, 0x53,
	 0x4D, 0x42, 0x72, 0x00, 0x00, 0x00, 0x00, 0x08,
	 0x01, 0xc8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	 0x4D, 0x0B, 0x00, 0x00, g_mlo, g_mhi, 0x00, 0x81,
	 0x00, 0x02
	 ) + "PC NETWORK PROGRAM 1.0" + raw_string(0x00, 0x02) +
	 "MICROSOFT NETWORKS 1.03" + raw_string(0x00, 0x02) + 
	 "MICROSOFT NETWORKS 3.0"  + raw_string(0x00, 0x02) + 
	 "LANMAN1.0" + raw_string(0x00, 0x02) + 
	 "LM1.2X002" + raw_string(0x00, 0x02) + 
	 "Samba" +     raw_string(0x00, 0x02) +
	 "NT LANMAN 1.0" + raw_string(0x00, 0x02) +
	 "NT LM 0.12" + raw_string(0x00);
	 
	 
 send(socket:soc, data:neg_prot);
 r = smb_recv(socket:soc, length:4000);
 return r;
}

function netbios(data)
{
 return raw_string(0,0,0,strlen(data) % 256) + data;
}

function smb(blob, suffix)
{
 local_var len, tot_len;
 len = strlen(blob);
 tot_len = len + strlen(suffix);

  

 return raw_string(0xff, 0x53, 
		   0x4d, 0x42, 0x73, 0x00, 0x00, 0x00, 0x00, 0x08,
		   0x01, 0xc8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		   0x00, 0x00, 0x00, 0x00, g_mlo, g_mhi, 0x0c, 0xff,
		   0x00, 0x00, 0x00, 0x01, 0x40, 0x02, 0x00, 0x01,
		   0x00, 0x00, 0x00, 0x00, 0x00, len,  0x00, 0x00,
		   0x00, 0x00, 0x00, 0x5c, 0x00, 0x00, 0x80, tot_len,
		   0x00 ) + blob + suffix;
}

function gssapi(data)
{
 return raw_string(0x60, 0x58,0x06,0xFF,0x06,0xFF,0x06,0x0F,0x05,0x0F,0x02,0xFF,0x06,0xFF,0xFF,0xFF,0xFF, 0x06,0x00,0x06,0x00,0x2A,0x00,0x00,0x00,0x0A,0x00,0x0A,0x00,0x20,0x00,0x00,0x00, 0x42,0x4C,0x49,0x4E,0x47,0x42,0x4C,0x49,0x4E,0x47,0x4D,0x53,0x48,0x4F,0x4D,0x45, 0x2A,0xFF,0x7F,0x74,0x6F,0xFF,0x0A,0x0B,0x9E,0xFF,0xE6,0x56,0x73,0x37,0x57,0x37, 0x0A,0x0B,0x0C);
}

port = int(get_kb_item("SMB/transport"));

if ( ! port ) 
{
 port = 445;
 soc  = 0;
 if ( get_port_state(port) )
 {
  soc = open_sock_tcp(port);
 }
 if ( ! soc )
 {
  port = 139;
  if ( ! get_port_state(port) ) exit(0);
 }
}





if ( ! soc ) soc = open_sock_tcp(port);
if ( ! soc ) exit(0);

if ( port == 139 )
{
  name = kb_smb_name();
  if ( ! name ) name = "*SMBSERVER";
  r = smb_session_request(soc:soc,  remote:name); 
  if (  ! r ) exit(0);
}


r = smb_neg_prot_gssapi(soc:soc);
if (! r) exit(0);

data = netbios(data:smb(blob: gssapi(), suffix:unicode(data:"Windows") + unicode(data:"Nessus") + raw_string(0,0)));



send (socket:soc, data:data);

result = smb_recv(socket:soc, length:4096);
if ( ! result ) exit(0);
if ( strlen(result) < 13 ) exit(0);


code = substr(result, 9,12);
# 0x160000c0 -> vulnerable
# 0x0d0000c0 -> patched

if ( "160000c0" >< hexstr(code) ) security_hole(port);

