#
# This script was written by Renaud Deraison
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(11329);

 script_version("$Revision: 1.42 $");

 name["english"] = "The remote host is infected by a virus";

 script_name(english:name["english"]);
 
 desc["english"] = "
This script checks for the presence of different virii on the remote
host, by using the SMB credentials you provide Nessus with.

- W32/Badtrans-B
- JS_GIGGER.A@mm
- W32/Vote-A
- CodeRed
- W32.Sircam.Worm@mm
- W32.HLLW.Fizzer@mm
- W32.Sobig.B@mm
- W32.Sobig.E@mm
- W32.Sobig.F@mm
- W32.Sobig.C@mm
- W32.Yaha.J@mm
- W32.mimail.a@mm
- W32.mimail.c@mm
- W32.mimail.e@mm
- W32.mimail.l@mm
- W32.mimail.p@mm
- W32.Welchia.Worm
- W32.Randex.Worm
- W32.Beagle.A
- W32.Novarg.A
- Vesser
- NetSky.C
- Doomran.a
- Beagle.m
- Beagle.j
- Agobot.FO
- NetSky.W
- Sasser
- W32.Wallon.A
- W32.MyDoom.M
- Hackarmy.i
- W32.Erkez.D/Zafi.d

	
Risk factor : High
Solution : See the URLs which will appear in the report";


 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the presence of different virii on the remote host";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2003 Renaud Deraison");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("netbios_name_get.nasl",
 		     "smb_login.nasl","smb_registry_access.nasl");
 script_require_keys("SMB/name", "SMB/login", "SMB/password",  "SMB/registry_access");

 script_require_ports(139, 445);
 exit(0);
}

include("smb_nt.inc");
if ( get_kb_item("SMB/samba") ) exit(0);

global_var handle;

x_name = kb_smb_name();
if(!x_name)exit(0);

_smb_port = kb_smb_transport();
if(!_smb_port)exit(0);

if(!get_port_state(_smb_port))return(FALSE);
login = kb_smb_login();
pass  = kb_smb_password();
domain = kb_smb_domain();

if(!login)login = "";
if(!pass) pass = "";

	  
soc = open_sock_tcp(_smb_port);
if(!soc)return(FALSE);

#
# Request the session
# 
r = smb_session_request(soc:soc,  remote:x_name);
if(!r) { close(soc); return(FALSE); }

#
# Negociate the protocol
#
prot = smb_neg_prot(soc:soc);
if(!prot){ close(soc); return(FALSE); }


#
# Set up our session
#
r = smb_session_setup(soc:soc, login:login, password:pass, domain:domain, prot:prot);
if(!r){ close(soc); return(FALSE); }
# and extract our uid
uid = session_extract_uid(reply:r);

#
# Connect to the remote IPC and extract the TID
# we are attributed
#      
r = smb_tconx(soc:soc, name:x_name, uid:uid, share:"IPC$");
# and extract our tree id
tid = tconx_extract_tid(reply:r);
if(!tid){ close(soc); return(FALSE); }

#
# Create a pipe to \winreg
#
r = smbntcreatex(soc:soc, uid:uid, tid:tid, name:"\winreg");
if(!r){ close(soc); return(FALSE);}
# and extract its ID
pipe = smbntcreatex_extract_pipe(reply:r);

#
# Setup things
#
r = pipe_accessible_registry(soc:soc, uid:uid, tid:tid, pipe:pipe);
if(!r){ close(soc); return(FALSE); }
handle = registry_open_hklm(soc:soc, uid:uid, tid:tid, pipe:pipe);


function check_reg(name, url, key, item, exp)
{
  local_var key_h, sz;

  key_h = registry_get_key(soc:soc, uid:uid, tid:tid, pipe:pipe, key:key, reply:handle);
  if(strlen(key_h) > 92)
  {
    sz =  registry_get_item_sz(soc:soc, uid:uid, tid:tid, pipe:pipe, item:item, reply:key_h);
    registry_close(soc:soc, uid:uid, tid:tid, pipe:pipe, reply:key_h); 
    if ( strlen(sz) <= 92 ) return 0;
    value = registry_decode_sz(data:sz);
    if ( ! value ) return 0;
  }
  else return 0;
  
 if(exp == NULL || tolower(exp) >< tolower(value))
 {
  report = string(
"The virus '", name, "' is present on the remote host\n",
"Solution : ", url, "\n",
"Risk factor : High");
 
  security_hole(port:kb_smb_transport(), data:report);
 }
}




i = 0;

# http://www.infos3000.com/infosvirus/badtransb.htm
name[i] 	= "W32/Badtrans-B";
url[i] 		= "http://securityresponse.symantec.com/avcenter/venc/data/w32.badtrans.b@mm.html";
key[i] 		= "Software\Microsoft\Windows\CurrentVersion\RunOnce";
item[i] 	= "kernel32";
exp[i]		= "kernel32.exe";

i++;

# http://www.infos3000.com/infosvirus/jsgiggera.htm
name[i] 	= "JS_GIGGER.A@mm";
url[i] 		= "http://securityresponse.symantec.com/avcenter/venc/data/js.gigger.a@mm.html";
key[i] 		= "Software\Microsoft\Windows\CurrentVersion\Run";
item[i] 	= "NAV DefAlert";
exp[i]		= NULL;

i ++;

# http://www.infos3000.com/infosvirus/vote%20a.htm
name[i]		= "W32/Vote-A";
url[i]		= "http://www.symantec.com/avcenter/venc/data/w32.vote.a@mm.html";
key[i]		= "Software\Microsoft\Windows\CurrentVersion\Run";
item[i]		= "Norton.Thar";
exp[i]		= "zacker.vbs";

i++ ;

# http://www.infos3000.com/infosvirus/codered.htm
name[i]		= "CodeRed";
url[i]		= "http://www.symantec.com/avcenter/venc/data/codered.worm.html";
key[i]		= "SYSTEM\CurrentControlSet\Services\W3SVC\Parameters";
item[i]		= "VirtualRootsVC";
exp[i]		= "c:\,,217";

i ++;

# http://www.infos3000.com/infosvirus/w32sircam.htm
name[i]		= "W32.Sircam.Worm@mm";
url[i]		= "http://www.symantec.com/avcenter/venc/data/w32.sircam.worm@mm.html";
key[i]		= "Software\Microsoft\Windows\CurrentVersion\RunServices";
item[i]		= "Driver32";
exp[i] 		= "scam32.exe";

i++;

name[i]  	= "W32.HLLW.Fizzer@mm";
url[i] 		= "http://securityresponse.symantec.com/avcenter/venc/data/w32.hllw.fizzer@mm.html";
key[i]		= "Software\Microsoft\Windows\CurrentVersion\Run";
item[i]		= "SystemInit";
exp[i]		= "iservc.exe";

i++;

name[i]  	= "W32.Sobig.B@mm";
url[i] 		= "http://securityresponse.symantec.com/avcenter/venc/data/w32.sobig.b@mm.html";
key[i]		= "Software\Microsoft\Windows\CurrentVersion\Run";
item[i]		= "SystemTray";
exp[i]		= "msccn32.exe";

i ++;

name[i]		= "W32.Sobig.E@mm";
url[i]		= "http://securityresponse.symantec.com/avcenter/venc/data/w32.sobig.e@mm.html";
key[i]		= "SOFTWARE\Microsoft\Windows\CurrentVersion\Run";
item[i]		= "SSK Service";
exp[i]		= "winssk32.exe";

i ++;

name[i]		= "W32.Sobig.F@mm";
url[i]		= "http://securityresponse.symantec.com/avcenter/venc/data/w32.sobig.f@mm.html";
key[i]		= "SOFTWARE\Microsoft\Windows\CurrentVersion\Run";
item[i]		= "TrayX";
exp[i]		= "winppr32.exe";

i ++;

name[i]		= "W32.Sobig.C@mm";
url[i]		= "http://securityresponse.symantec.com/avcenter/venc/data/w32.sobig.c@mm.html";
key[i]		= "SOFTWARE\Microsoft\Windows\CurrentVersion\Run";
item[i]		= "System MScvb";
exp[i]		= "mscvb32.exe";

i ++;

name[i] 	= "W32.Yaha.J@mm";
url[i] 		= "http://securityresponse.symantec.com/avcenter/venc/data/w32.yaha.j@mm.html";
key[i]		= "SOFTWARE\Microsoft\Windows\CurrentVersion\Run";
item[i]		= "winreg";
exp[i]		= "winReg.exe";


i++;

name[i] 	= "W32.mimail.a@mm";
url[i] 		= "http://securityresponse.symantec.com/avcenter/venc/data/w32.mimail.a@mm.html";
key[i]		= "SOFTWARE\Microsoft\Windows\CurrentVersion\Run";
item[i]		= "VideoDriver";
exp[i]		= "videodrv.exe";


i++;

name[i] 	= "W32.mimail.c@mm";
url[i] 		= "http://securityresponse.symantec.com/avcenter/venc/data/w32.mimail.c@mm.html";
key[i]		= "SOFTWARE\Microsoft\Windows\CurrentVersion\Run";
item[i]		= "NetWatch32";
exp[i]		= "netwatch.exe";

i++;

name[i] 	= "W32.mimail.e@mm";
url[i] 		= "http://securityresponse.symantec.com/avcenter/venc/data/w32.mimail.e@mm.html";
key[i]		= "SOFTWARE\Microsoft\Windows\CurrentVersion\Run";
item[i]		= "SystemLoad32";
exp[i]		= "sysload32.exe";

i++;
name[i] 	= "W32.mimail.l@mm";
url[i] 		= "http://securityresponse.symantec.com/avcenter/venc/data/w32.mimail.l@mm.html";
key[i]		= "SOFTWARE\Microsoft\Windows\CurrentVersion\Run";
item[i]		= "France";
exp[i]		= "svchost.exe";

i++;
name[i] 	= "W32.mimail.p@mm";
url[i] 		= "http://securityresponse.symantec.com/avcenter/venc/data/w32.mimail.p@mm.html";
key[i]		= "SOFTWARE\Microsoft\Windows\CurrentVersion\Run";
item[i]		= "WinMgr32";
exp[i]		= "winmgr32.exe";

i++;

name[i]        = "W32.Welchia.Worm";
url[i]         = "http://securityresponse.symantec.com/avcenter/venc/data/w32.welchia.worm.html";
key[i]         = "SYSTEM\CurrentControlSet\Services\RpcTftpd";
item[i]        = "ImagePath";
exp[i]         = "%System%\wins\svchost.exe";


i++;

name[i]        = "W32.Randex.Worm";
url[i]         = "http://securityresponse.symantec.com/avcenter/venc/data/w32.randex.b.html";
key[i]         = "SOFTWARE\Microsoft\Windows\CurrentVersion\Run";
item[i]        = "superslut";
exp[i]         = "msslut32.exe";

i++;

name[i]        = "W32.Randex.Worm";
url[i]         = "http://securityresponse.symantec.com/avcenter/venc/data/w32.randex.c.html";
key[i]         = "SOFTWARE\Microsoft\Windows\CurrentVersion\Run";
item[i]        = "Microsoft Netview";
exp[i]         = "gesfm32.exe";

i++;

name[i]        = "W32.Randex.Worm";
url[i]         = "http://securityresponse.symantec.com/avcenter/venc/data/w32.randex.d.html";
key[i]         = "SOFTWARE\Microsoft\Windows\CurrentVersion\Run";
item[i]        = "mssyslanhelper";
exp[i]         = "msmsgri32.exe";


i++;

name[i]        = "W32.Randex.Worm";
url[i]         = "http://securityresponse.symantec.com/avcenter/venc/data/w32.randex.d.html";
key[i]         = "SOFTWARE\Microsoft\Windows\CurrentVersion\Run";
item[i]        = "mslanhelper";
exp[i]         = "msmsgri32.exe";

i ++;
name[i]        = "W32.Beagle.A";
url[i]         = "http://securityresponse.symantec.com/avcenter/venc/data/w32.beagle.a@mm.html";
key[i]         = "SOFTWARE\Microsoft\Windows\CurrentVersion\Run";
item[i]        = "d3update.exe";
exp[i]         = "bbeagle.exe";

i ++;

name[i]        = "W32.Novarg.A";
url[i]         = "http://securityresponse.symantec.com/avcenter/venc/data/w32.novarg.a@mm.html";
key[i]         = "SOFTWARE\Microsoft\Windows\CurrentVersion\Run";
item[i]        = "TaskMon";
exp[i]         = "taskmon.exe";

i++;

name[i]       = "Vesser";
url[i]        = "http://www.f-secure.com/v-descs/vesser.shtml";
key[i]        = "SOFTWARE\Microsoft\Windows\CurrentVersion\Run";
item[i]       = "KernelFaultChk";
exp[i]        = "sms.exe";

i++;

name[i]       = "NetSky.C";
url[i]        = "http://securityresponse.symantec.com/avcenter/venc/data/w32.netsky.c@mm.html";
key[i]        = "SOFTWARE\Microsoft\Windows\CurrentVersion\Run";
item[i]       = "ICQ Net";
exp[i]        = "winlogon.exe";


i++;

name[i]      = "Doomran.a";
url[i]       = "http://es.trendmicro-europe.com/enterprise/security_info/ve_detail.php?Vname=WORM_DOOMRAN.A";
key[i]       = "SOFTWARE\Microsoft\Windows\CurrentVersion\Run";
item[i]      = "Antimydoom";
exp[i]       = "PACKAGE.EXE";

i++;

name[i]      = "Beagle.m";
url[i]       = "http://securityresponse.symantec.com/avcenter/venc/data/w32.beagle.m@mm.html";
key[i]       = "software\microsoft\windows\currentversion\run";
item[i]      = "winupd.exe";
exp[i]       = "winupd.exe";

i++;

name[i]      = "Beagle.j";
url[i]       = "http://securityresponse.symantec.com/avcenter/venc/data/w32.beagle.j@mm.html";
key[i]       = "software\microsoft\windows\currentversion\run";
item[i]      = "ssate.exe";
exp[i]       = "irun4.exe";

i++;

name[i]      = "Agobot.FO";
url[i]       = "http://www.f-secure.com/v-descs/agobot_fo.shtml";
key[i]       = "software\microsoft\windows\currentversion\run";
item[i]      = "nVidia Chip4";
exp[i]       = "nvchip4.exe";

i ++;
name[i]       = "NetSky.W";
url[i]        = "http://securityresponse.symantec.com/avcenter/venc/data/w32.netsky.w@mm.html";
key[i]        = "SOFTWARE\Microsoft\Windows\CurrentVersion\Run";
item[i]       = "NetDy";
exp[i]        = "VisualGuard.exe";


i++;
name[i]       = "Sasser";
url[i]        = "http://www.lurhq.com/sasser.html";
key[i]        = "SOFTWARE\Microsoft\Windows\CurrentVersion\Run";
item[i]       = "avserve.exe";
exp[i]        = "avserve.exe";

i++;
name[i]       = "W32.Wallon.A";
url[i]        = "http://securityresponse.symantec.com/avcenter/venc/data/w32.wallon.a@mm.html";
key[i]        = "SOFTWARE\Microsoft\Internet Explorer\Extensions\{FE5A1910-F121-11d2-BE9E-01C04A7936B1}";
item[i]       = "Icon";
exp[i]        = NULL;


i++;
name[i]       = "W32.MyDoom.M";
url[i]        = "http://us.mcafee.com/virusInfo/default.asp?id=description&virus_k=127033";
key[i]        = "SOFTWARE\Microsoft\Windows\CurrentVersion\Run";
item[i]       = "JavaVM";
exp[i]        = "JAVA.EXE";

i++;
name[i]       = "Hackarmy.i";
url[i]        = "http://www.zone-h.org/en/news/read/id=4404/";
key[i]        = "SOFTWARE\Microsoft\Windows\CurrentVersion\Run";
item[i]       = "putil";
exp[i]        = "%windir%";

# Submitted by Jeff Adams
i++;
name[i]       = "W32.Erkez.D/Zafi.D";
url[i]        = "http://securityresponse.symantec.com/avcenter/venc/data/w32.erkez.d@mm.html";
key[i]        = "SOFTWARE\Microsoft\Windows\CurrentVersion\Run";
item[i]       = "Wxp4";
exp[i]        = "Norton Update";

for(i=0;name[i];i++)
{
  check_reg(name:name[i], url:url[i], key:key[i], item:item[i], exp:exp[i]);
}



key   = "SOFTWARE\Microsoft\Windows NT\CurrentVersion";
item  = "SystemRoot";


key_h = registry_get_key(soc:soc, uid:uid, tid:tid, pipe:pipe, key:key, reply:r);
if(key_h)
 {
    sz =  registry_get_item_sz(soc:soc, uid:uid, tid:tid, pipe:pipe, item:item, reply:key_h);
    if ( ! sz ) return 0;
    rootfile = registry_decode_sz(data:sz);
 }
 
if ( ! rootfile ) exit(0);

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:rootfile);
file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1\system.ini", string:rootfile);


r = smb_tconx(soc:soc, name:x_name, uid:uid, share:share);
tid = tconx_extract_tid(reply:r);
if(!tid)exit(0);

fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
if(fid)
{
off = 0;
resp = ReadAndX(socket:soc, uid:uid, tid:tid, fid:fid, count:16384, off:off);
data = resp;
while(strlen(resp) >= 16383)
{
 off += strlen(resp);
 resp = ReadAndX(socket:soc, uid:uid, tid:tid, fid:fid, count:16384, off:off);
 data += resp;
 if(strlen(data) > 1024 * 1024)break;
}

if("shell=explorer.exe load.exe -dontrunold" >< data)
{
  report = string(
"The virus 'W32.Nimda.A@mm' is present on the remote host\n",
"Solution : http://www.symantec.com/avcenter/venc/data/w32.nimda.a@mm.html\n",
"Risk factor : High");
 
  security_hole(port:port, data:report);
 }
}
 
file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1\goner.scr", string:rootfile); 
fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
if(fid){
 report = string(
"The virus 'W32.Goner.A@mm' is present on the remote host\n",
"Solution : http://www.symantec.com/avcenter/venc/data/w32.goner.a@mm.html\n",
"Risk factor : High"); 
security_hole(port:port, data:report);
}

file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1\winxp.exe", string:rootfile); 
fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
if(fid){
 report = string(
"The virus 'W32.Bable.AG@mm' is present on the remote host\n",
"Solution : http://www.symantec.com/avcenter/venc/data/w32.beagle.ag@mm.html\n",
"Risk factor : High"); 
security_hole(port:port, data:report);
}



file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1\Swen1.dat", string:rootfile); 
fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
if(fid){
 report = string(
"The virus 'W32.Swen.A@mm' is present on the remote host\n",
"Solution : http://securityresponse.symantec.com/avcenter/venc/data/w32.swen.a@mm.html\n",
"Risk factor : High"); 
security_hole(port:port, data:report);
}
