#
# This script is (C) Tenable Network Security
#
#

if(description)
{
 script_id(15988);
 script_bugtraq_id(11984);
 script_version ("$Revision: 1.2 $");

 name["english"] = "WordPress Multiple Flaws (XSS, HTML Injection, SQL Injection)";

 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running WordPress BLOG, a web blog manager written
in PHP.

The remote version of this software is vulnerable to various flaws which
may allow an attacker to perform an HTML injection attack against the remote
host or to allow an attacker to execute arbitrary SQL statements against the
remote database.

Solution : Upgrade to WordPress 1.2.2
Risk factor : High";


 script_description(english:desc["english"]);
 summary["english"] = "Checks for the presence of WordPress";
 script_summary(english:summary["english"]);
 script_category(ACT_ATTACK);
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security",
		francais:"Ce script est Copyright (C) 2004 Tenable Network Security");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#


include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);



function check(loc)
{
  res = http_keepalive_send_recv(port:port, data:http_get(item:loc + "/index.php", port:port));
  if ( res == NULL ) exit(0);
  res = str_replace(find:'\n', replace:'', string:res);
  res = str_replace(find:'\r', replace:'', string:res);
  
  if ( "WordPress" >< res && egrep(pattern:'<meta name="generator" content="WordPress (0\\.|1\\.([01]|2[^0-9]|2\\.[01][^0-9]))"', string:res)) { security_warning(port); exit(0); }
}




foreach dir ( cgi_dirs() )
{
 check(loc:dir);
}
