#
# (C) Tenable Network Security
# 
# This script is released under the GPLv2
#

if(description)
{
 script_id(19506);
 script_version ("$Revision: 1.3 $");
 name["english"] = "Information about the scan";
 script_name(english:name["english"]);
 
 desc["english"] = "
This script displays, for each tested host, information about the scan itself:

 - The version of the plugin set
 - The type of plugin feed (Direct, Registered or GPL)
 - The version of the Nessus Engine
 - The port scanner(s) used
 - The port range scanned
 - The date of the scan
 - The duration of the scan

Risk factor : None";


 script_description(english:desc["english"]);
 
 summary["english"] = "Displays information about the scan";
 script_summary(english:summary["english"]);
 
 script_category(ACT_END);
 
 
 script_copyright(english:"This script is released under the GNU GPLv2");
 family["english"] = "General";
 script_family(english:family["english"]);
 exit(0);
}

include('plugin_feed_info.inc');
include('global_settings.inc');


# 
# If no plugin has shown anything, quietly exit
#
list = get_kb_list("Success/*");
if ( isnull(list) ) 
{
 list = get_kb_list("Ports/*");
 if ( isnull(list) ) exit(0);
}


if ( ! strlen(NESSUS_VERSION) )
	{
	if ( ! defined_func("pread") && NASL_LEVEL >= 2202 )
		version = "NeWT";
	else
		version = "Unknown (NASL_LEVEL=" + NASL_LEVEL + ")";
	}
 else
	version = NESSUS_VERSION;

report = 'Information about this scan : \n\n';
report += 'Nessus version : ' + version + '\n';

if ( PLUGIN_SET )
{
 report += 'Plugin feed version : ' + PLUGIN_SET     + '\n';
 report += 'Type of plugin feed : ' + PLUGIN_FEED    + '\n';
}

report += 'Scanner IP : ' + this_host()    + '\n';


list = get_kb_list("Host/scanners/*");
if ( ! isnull(list) )
{
 foreach item ( keys(list) )
 {
  item -= "Host/scanners/";
  scanners += item + ' ';
 }

 report += 'Port scanner(s) : ' + scanners + '\n';
}


range = get_preference("port_range");
if ( ! range ) range = "(?)";
report += 'Port range : ' + range + '\n';

report += 'Thorough tests : ';
if ( thorough_tests ) report += 'yes\n';
else report += 'no\n';

report += 'Experimental tests : ';
if ( experimental_scripts ) report += 'yes\n';
else report += 'no\n';

report += 'Paranoia level : ';
report += report_paranoia + '\n';

report += 'Report Verbosity : ';
report += report_verbosity + '\n';

report += 'Safe checks : ';
if ( safe_checks() ) report += 'yes\n';
else report += 'no\n';





start = get_kb_item("/tmp/start_time");



if ( start )
{
 time = localtime(start);
 if ( time["min"] < 10 ) zero = "0";
 else zero = NULL;

 report += 'Scan Start Date : ' + time["year"] + '/' + time["mon"] + '/' + time["mday"] + ' ' + time["hour"] + ':' + zero + time["min"] + '\n';
}



if ( ! start ) scan_duration = 'unknown (ping_host.nasl not launched?)';
else           scan_duration = string (unixtime() - start, " sec");
report += 'Scan duration : ' + scan_duration + '\n';






security_note(port:0, data:report);

