/**
 * @file
 *
 * Collectively assign unique filecodes for assert and debug to each source file.
 *
 * Publish values for decorated filenames, which can be used for
 * ASSERT and debug support using a preprocessor define like:
 * @n <tt> \#define FILECODE MY_C_FILENAME_FILECODE </tt> @n
 * This file serves as a reference for debugging to associate the code and filename.
 *
 * @xrefitem bom "File Content Label" "Release Content"
 * @e project:      AGESA
 * @e sub-project:  Include
 * @e \$Revision: 44323 $   @e \$Date: 2010-12-22 01:24:58 -0700 (Wed, 22 Dec 2010) $
 */
/*****************************************************************************
 *
 * Copyright (c) 2011, Advanced Micro Devices, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Advanced Micro Devices, Inc. nor the names of
 *       its contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL ADVANCED MICRO DEVICES, INC. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 ***************************************************************************/

#ifndef _FILECODE_H_
#define _FILECODE_H_

#define UNASSIGNED_FILE_FILECODE                                         (0xFFFF)

/// For debug use in any Platform's options C file.
/// Can be reused for platforms and image builds, since only one options file can be built.
#define PLATFORM_SPECIFIC_OPTIONS_FILECODE                               (0xBBBB)

#define PROC_GNB_GNBINITATEARLY_FILECODE                                (0xA001)
#define PROC_GNB_GNBINITATENV_FILECODE                                  (0xA002)
#define PROC_GNB_GNBINITATLATE_FILECODE                                 (0xA003)
#define PROC_GNB_GNBINITATMID_FILECODE                                  (0xA004)
#define PROC_GNB_GNBINITATPOST_FILECODE                                 (0xA005)
#define PROC_GNB_GNBINITATRESET_FILECODE                                (0xA006)
#define PROC_GNB_COMMON_CPUACCLIB_FILECODE                              (0xA010)
#define PROC_GNB_COMMON_GNBHEAPLIB_FILECODE                             (0xA011)
#define PROC_GNB_COMMON_GNBLIB_FILECODE                                 (0xA012)
#define PROC_GNB_COMMON_MEMACCLIB_FILECODE                              (0xA013)
#define PROC_GNB_COMMON_PCIACCLIB_FILECODE                              (0xA014)
#define PROC_GNB_COMMON_PCILIB_FILECODE                                 (0xA015)
#define PROC_GNB_COMMON_IOACCLIB_FILECODE                               (0xA016)
#define PROC_GNB_GFX_GFXCARDINFO_FILECODE                               (0xA020)
#define PROC_GNB_GFX_GFXCONFIGDATA_FILECODE                             (0xA021)
#define PROC_GNB_GFX_GFXGMCINIT_FILECODE                                (0xA022)
#define PROC_GNB_GFX_GFXINITATENVPOST_FILECODE                          (0xA023)
#define PROC_GNB_GFX_GFXINITATMIDPOST_FILECODE                          (0xA024)
#define PROC_GNB_GFX_GFXINITATPOST_FILECODE                             (0xA025)
#define PROC_GNB_GFX_GFXINTEGRATEDINFOTABLEINIT_FILECODE                (0xA026)
#define PROC_GNB_GFX_GFXREGISTERACC_FILECODE                            (0xA027)
#define PROC_GNB_GFX_GFXSTRAPSINIT_FILECODE                             (0xA028)
#define PROC_GNB_GFX_FAMILY_0X12_F12GFXSERVICES_FILECODE                (0xA029)
#define PROC_GNB_GFX_FAMILY_0X14_F14GFXSERVICES_FILECODE                (0xA02A)
#define PROC_GNB_NB_NBCONFIGDATA_FILECODE                               (0xA030)
#define PROC_GNB_NB_NBINIT_FILECODE                                     (0xA031)
#define PROC_GNB_NB_NBINITATEARLY_FILECODE                              (0xA032)
#define PROC_GNB_NB_NBINITATLATEPOST_FILECODE                           (0xA033)
#define PROC_GNB_NB_NBINITATRESET_FILECODE                              (0xA034)
#define PROC_GNB_NB_NBINITATENV_FILECODE                                (0xA035)
#define PROC_GNB_NB_NBSMULIB_FILECODE                                   (0xA036)
#define PROC_GNB_NB_NBSMUSERVICES_FILECODE                              (0xA037)
#define PROC_GNB_NB_FAMILY_0X12_F12NBSERVICES_FILECODE                  (0xA038)
#define PROC_GNB_NB_FAMILY_0X14_F14NBSERVICES_FILECODE                  (0xA039)
#define PROC_GNB_PCIE_PCIECONFIGDATA_FILECODE                           (0xA041)
#define PROC_GNB_PCIE_PCIEINIT_FILECODE                                 (0xA043)
#define PROC_GNB_PCIE_PCIEINITATEARLYPOST_FILECODE                      (0xA044)
#define PROC_GNB_PCIE_PCIEINITATLATEPOST_FILECODE                       (0xA045)
#define PROC_GNB_PCIE_PCIEINPUTPARSER_FILECODE                          (0xA046)
#define PROC_GNB_PCIE_PCIELATEINIT_FILECODE                             (0xA047)
#define PROC_GNB_PCIE_PCIEMAPTOPOLOGY_FILECODE                          (0xA048)
#define PROC_GNB_PCIE_PCIEPORTLATEINIT_FILECODE                         (0xA049)
#define PROC_GNB_PCIE_PCIEPIFSERVICES_FILECODE                          (0xA04A)
#define PROC_GNB_PCIE_PCIEPORTINIT_FILECODE                             (0xA04B)
#define PROC_GNB_PCIE_PCIEPORTREGACC_FILECODE                           (0xA04C)
#define PROC_GNB_PCIE_PCIETIMER_FILECODE                                (0xA04D)
#define PROC_GNB_PCIE_PCIETOPOLOGYSERVICES_FILECODE                     (0xA04E)
#define PROC_GNB_PCIE_PCIETRAINING_FILECODE                             (0xA04F)
#define PROC_GNB_PCIE_PCIEUTILITYLIB_FILECODE                           (0xA050)
#define PROC_GNB_PCIE_PCIEWRAPPERREGACC_FILECODE                        (0xA051)
#define PROC_GNB_PCIE_PCIEPOWERSAVINGFEATURES_FILECODE                  (0xA052)
#define PROC_GNB_PCIE_PCIESBLINK_FILECODE                               (0xA053)
#define PROC_GNB_PCIE_PCIEWORKAROUNDS_FILECODE                          (0xA054)
#define PROC_GNB_PCIE_FAMILY_0X12_F12PCIECOMPLEXCONFIG_FILECODE         (0xA060)
#define PROC_GNB_PCIE_FAMILY_0X12_F12PCIECOMPLEXSERVICES_FILECODE       (0xA061)
#define PROC_GNB_PCIE_FAMILY_0X12_F12PCIEPHYSERVICES_FILECODE           (0xA062)
#define PROC_GNB_PCIE_FAMILY_0X12_F12PCIEWRAPPERSERVICES_FILECODE       (0xA063)
#define PROC_GNB_PCIE_FAMILY_0X14_F14PCIECOMPLEXCONFIG_FILECODE         (0xA070)
#define PROC_GNB_PCIE_FAMILY_0X14_F14PCIECOMPLEXSERVICES_FILECODE       (0xA071)
#define PROC_GNB_PCIE_FAMILY_0X14_F14PCIEPHYSERVICES_FILECODE           (0xA072)
#define PROC_GNB_PCIE_FAMILY_0X14_F14PCIEWRAPPERSERVICES_FILECODE       (0xA073)
#define PROC_GNB_PCIE_FEATURE_PCIEASPM_FILECODE                         (0xA074)
#define PROC_GNB_PCIE_FEATURE_PCIEASPMEXITLATENCY_FILECODE              (0xA075)
#define PROC_GNB_GFX_GFXPOWERPLAYTABLE_FILECODE                         (0xA076)
#define PROC_GNB_GFX_GFXFUSETABLEINIT_FILECODE                          (0xA077)
#define PROC_GNB_NB_NBPOWERMGMT_FILECODE                                (0xA078)

#define PROC_RECOVERY_GNB_GNBRECOVERY_FILECODE                          (0xAE01)
#define PROC_RECOVERY_GNB_GFXRECOVERY_FILECODE                          (0xAE02)
#define PROC_RECOVERY_GNB_NBINITRECOVERY_FILECODE                       (0xAE03)

#define LIB_AMDLIB_FILECODE                                              (0xC001)

#define LEGACY_PROC_AGESACALLOUTS_FILECODE                               (0xC010)
#define LEGACY_PROC_HOBTRANSFER_FILECODE                                 (0xC011)
#define LEGACY_PROC_DISPATCHER_FILECODE                                  (0xC012)

#define UEFI_DXE_AMDAGESADXEDRIVER_AMDAGESADXEDRIVER_FILECODE            (0xC120)
#define UEFI_DXE_AMDAGESAS3DRIVER_AMDAGESAS3DRIVER_FILECODE              (0xC121)
#define UEFI_PEI_AMDINITPOSTPEIM_AMDINITPOSTPEIM_FILECODE                (0xC140)
#define UEFI_PEI_AMDPROCESSORINITPEIM_AMDPROCESSORINITPEIM_FILECODE      (0xC141)
#define UEFI_PEI_AMDRESETMANAGER_AMDRESETMANAGER_FILECODE                (0xC142)
#define UEFI_PROC_HOBTRANSFERUEFI_FILECODE                               (0xC162)

#define PROC_COMMON_AMDINITEARLY_FILECODE                                (0xC020)
#define PROC_COMMON_AMDINITENV_FILECODE                                  (0xC021)
#define PROC_COMMON_AMDINITLATE_FILECODE                                 (0xC022)
#define PROC_COMMON_AMDINITMID_FILECODE                                  (0xC023)
#define PROC_COMMON_AMDINITPOST_FILECODE                                 (0xC024)
#define PROC_COMMON_AMDINITRECOVERY_FILECODE                             (0xC025)
#define PROC_COMMON_AMDINITRESET_FILECODE                                (0xC026)
#define PROC_COMMON_AMDINITRESUME_FILECODE                               (0xC027)
#define PROC_COMMON_AMDS3LATERESTORE_FILECODE                            (0xC028)
#define PROC_COMMON_AMDS3SAVE_FILECODE                                   (0xC029)
#define PROC_COMMON_AMDLATERUNAPTASK_FILECODE                            (0xC02A)

#define PROC_COMMON_COMMONRETURNS_FILECODE                               (0xC0C0)
#define PROC_COMMON_CREATESTRUCT_FILECODE                                (0xC0D0)
#define PROC_COMMON_COMMONINITS_FILECODE                                 (0xC0F0)
#define PROC_COMMON_S3RESTORESTATE_FILECODE                              (0xC0F8)
#define PROC_COMMON_S3SAVESTATE_FILECODE                                 (0xC0F9)

#define PROC_CPU_CPUAPICUTILITIES_FILECODE                               (0xC401)
#define PROC_CPU_CPUBRANDID_FILECODE                                     (0xC402)
#define PROC_CPU_TABLE_FILECODE                                          (0xC403)
#define PROC_CPU_CPUEARLYINIT_FILECODE                                   (0xC405)
#define PROC_CPU_CPUEVENTLOG_FILECODE                                    (0xC406)
#define PROC_CPU_CPUFAMILYTRANSLATION_FILECODE                           (0xC407)
#define PROC_CPU_CPUGENERALSERVICES_FILECODE                             (0xC408)
#define PROC_CPU_CPUINITEARLYTABLE_FILECODE                              (0xC409)
#define PROC_CPU_CPULATEINIT_FILECODE                                    (0xC40A)
#define PROC_CPU_CPUMICROCODEPATCH_FILECODE                              (0xC40B)
#define PROC_CPU_CPUWARMRESET_FILECODE                                   (0xC40C)
#define PROC_CPU_HEAPMANAGER_FILECODE                                    (0xC40D)
#define PROC_CPU_CPUBIST_FILECODE                                        (0xC40E)

#define PROC_CPU_CPUPOSTINIT_FILECODE                                    (0xC420)
#define PROC_CPU_CPUPOWERMGMT_FILECODE                                   (0xC430)
#define PROC_CPU_CPUPOWERMGMTMULTISOCKET_FILECODE                        (0xC431)
#define PROC_CPU_CPUPOWERMGMTSINGLESOCKET_FILECODE                       (0xC432)
#define PROC_CPU_S3_FILECODE                                             (0xC460)

#define PROC_CPU_FAMILY_0X10_CPUCOMMONF10UTILITIES_FILECODE              (0xC801)
#define PROC_CPU_FAMILY_0X10_CPUF10BRANDID_FILECODE                      (0xC802)
#define PROC_CPU_FAMILY_0X10_CPUF10CACHEDEFAULTS_FILECODE                (0xC803)
#define PROC_CPU_FAMILY_0X10_CPUF10CACHEFLUSHONHALT_FILECODE             (0xC804)
#define PROC_CPU_FAMILY_0X10_CPUF10DMI_FILECODE                          (0xC805)
#define PROC_CPU_FAMILY_0X10_CPUF10EARLYINIT_FILECODE                    (0xC806)
#define PROC_CPU_FAMILY_0X10_CPUF10FEATURELEVELING_FILECODE              (0xC807)
#define PROC_CPU_FAMILY_0X10_CPUF10HTPHYTABLES_FILECODE                  (0xC808)
#define PROC_CPU_FAMILY_0X10_CPUF10MSRTABLES_FILECODE                    (0xC809)
#define PROC_CPU_FAMILY_0X10_CPUF10PCITABLES_FILECODE                    (0xC80A)
#define PROC_CPU_FAMILY_0X10_CPUF10POWERCHECK_FILECODE                   (0xC80B)
#define PROC_CPU_FAMILY_0X10_CPUF10POWERMGMTSYSTEMTABLES_FILECODE        (0xC80C)
#define PROC_CPU_FAMILY_0X10_CPUF10POWERPLANE_FILECODE                   (0xC80D)
#define PROC_CPU_FAMILY_0X10_CPUF10SOFTWARETHERMAL_FILECODE              (0xC80E)
#define PROC_CPU_FAMILY_0X10_CPUF10UTILITIES_FILECODE                    (0xC80F)
#define PROC_CPU_FAMILY_0X10_CPUF10WHEAINITDATATABLES_FILECODE           (0xC810)
#define PROC_CPU_FAMILY_0X10_CPUF10PSTATE_FILECODE                       (0xC827)
#define PROC_CPU_FAMILY_0X10_F10PMNBCOFVIDINIT_FILECODE                  (0xC811)
#define PROC_CPU_FAMILY_0X10_F10SINGLELINKPCITABLES_FILECODE             (0xC812)
#define PROC_CPU_FAMILY_0X10_F10MULTILINKPCITABLES_FILECODE              (0xC813)
#define PROC_CPU_FAMILY_0X10_F10PMNBPSTATEINIT_FILECODE                  (0xC814)
#define PROC_CPU_FAMILY_0X10_REVC_F10REVCUTILITIES_FILECODE              (0xC815)
#define PROC_CPU_FAMILY_0X10_REVC_F10REVCHWC1E_FILECODE                  (0xC816)
#define PROC_CPU_FAMILY_0X10_REVC_F10REVCPCITABLES_FILECODE              (0xC81A)
#define PROC_CPU_FAMILY_0X10_REVC_F10REVCMSRTABLES_FILECODE              (0xC81B)
#define PROC_CPU_FAMILY_0X10_REVC_F10REVCHTPHYTABLES_FILECODE            (0xC81C)
#define PROC_CPU_FAMILY_0X10_REVC_BL_F10BLHTPHYTABLES_FILECODE           (0xC820)
#define PROC_CPU_FAMILY_0X10_REVC_BL_F10BLLOGICALIDTABLES_FILECODE       (0xC821)
#define PROC_CPU_FAMILY_0X10_REVC_BL_F10BLMICROCODEPATCHTABLES_FILECODE  (0xC822)
#define PROC_CPU_FAMILY_0X10_REVC_BL_F10BLMSRTABLES_FILECODE             (0xC823)
#define PROC_CPU_FAMILY_0X10_REVC_BL_F10BLEQUIVALENCETABLE_FILECODE      (0xC824)
#define PROC_CPU_FAMILY_0X10_REVC_BL_F10BLPCITABLES_FILECODE             (0xC825)
#define PROC_CPU_FAMILY_0X10_REVC_BL_F10BLCACHEFLUSHONHALT_FILECODE      (0xC826)
#define PROC_CPU_FAMILY_0X10_REVC_DA_F10DAHTPHYTABLES_FILECODE           (0xC830)
#define PROC_CPU_FAMILY_0X10_REVC_DA_F10DALOGICALIDTABLES_FILECODE       (0xC831)
#define PROC_CPU_FAMILY_0X10_REVC_DA_F10DAMICROCODEPATCHTABLES_FILECODE  (0xC832)
#define PROC_CPU_FAMILY_0X10_REVC_DA_F10DAMSRTABLES_FILECODE             (0xC833)
#define PROC_CPU_FAMILY_0X10_REVC_DA_F10DAEQUIVALENCETABLE_FILECODE      (0xC834)
#define PROC_CPU_FAMILY_0X10_REVC_DA_F10DAPCITABLES_FILECODE             (0xC835)
#define PROC_CPU_FAMILY_0X10_REVC_DA_F10DACACHEFLUSHONHALT_FILECODE      (0xC836)
#define PROC_CPU_FAMILY_0X10_REVC_RB_F10RBHTPHYTABLES_FILECODE           (0xC850)
#define PROC_CPU_FAMILY_0X10_REVC_RB_F10RBLOGICALIDTABLES_FILECODE       (0xC851)
#define PROC_CPU_FAMILY_0X10_REVC_RB_F10RBMICROCODEPATCHTABLES_FILECODE  (0xC852)
#define PROC_CPU_FAMILY_0X10_REVC_RB_F10RBMSRTABLES_FILECODE             (0xC853)
#define PROC_CPU_FAMILY_0X10_REVC_RB_F10RBEQUIVALENCETABLE_FILECODE      (0xC854)
#define PROC_CPU_FAMILY_0X10_REVC_RB_F10RBPCITABLES_FILECODE             (0xC855)
#define PROC_CPU_FAMILY_0X10_REVD_F10REVDUTILITIES_FILECODE              (0xC817)
#define PROC_CPU_FAMILY_0X10_REVD_F10REVDMSGBASEDC1E_FILECODE            (0xC818)
#define PROC_CPU_FAMILY_0X10_REVD_F10REVDHTASSIST_FILECODE               (0xC819)
#define PROC_CPU_FAMILY_0X10_REVD_HY_F10HYHTPHYTABLES_FILECODE           (0xC840)
#define PROC_CPU_FAMILY_0X10_REVD_HY_F10HYINITEARLYTABLE_FILECODE        (0xC841)
#define PROC_CPU_FAMILY_0X10_REVD_HY_F10HYLOGICALIDTABLES_FILECODE       (0xC842)
#define PROC_CPU_FAMILY_0X10_REVD_HY_F10HYMICROCODEPATCHTABLES_FILECODE  (0xC843)
#define PROC_CPU_FAMILY_0X10_REVD_HY_F10HYMSRTABLES_FILECODE             (0xC844)
#define PROC_CPU_FAMILY_0X10_REVD_HY_F10HYEQUIVALENCETABLE_FILECODE      (0xC845)
#define PROC_CPU_FAMILY_0X10_REVD_HY_F10HYPCITABLES_FILECODE             (0xC846)
#define PROC_CPU_FAMILY_0X12_CPUCOMMONF12UTILITIES_FILECODE              (0XC901)
#define PROC_CPU_FAMILY_0X12_CPUF12BRANDID_FILECODE                      (0XC902)
#define PROC_CPU_FAMILY_0X12_CPUF12CACHEDEFAULTS_FILECODE                (0XC903)
#define PROC_CPU_FAMILY_0X12_CPUF12DMI_FILECODE                          (0XC904)
#define PROC_CPU_FAMILY_0X12_CPUF12MSRTABLES_FILECODE                    (0xC906)
#define PROC_CPU_FAMILY_0X12_CPUF12PCITABLES_FILECODE                    (0xC907)
#define PROC_CPU_FAMILY_0X12_CPUF12POWERCHECK_FILECODE                   (0XC908)
#define PROC_CPU_FAMILY_0X12_CPUF12POWERMGMTSYSTEMTABLES_FILECODE        (0XC909)
#define PROC_CPU_FAMILY_0X12_CPUF12POWERPLANE_FILECODE                   (0XC90A)
#define PROC_CPU_FAMILY_0X12_CPUF12SOFTWARETHERMAL_FILECODE              (0XC90B)
#define PROC_CPU_FAMILY_0X12_CPUF12UTILITIES_FILECODE                    (0XC90C)
#define PROC_CPU_FAMILY_0X12_CPUF12WHEAINITDATATABLES_FILECODE           (0XC90D)
#define PROC_CPU_FAMILY_0X12_CPUF12PSTATE_FILECODE                       (0XC90E)
#define PROC_CPU_FAMILY_0X12_F12C6STATE_FILECODE                         (0XC90F)
#define PROC_CPU_FAMILY_0X12_LN_F12LNLOGICALIDTABLES_FILECODE            (0xC921)
#define PROC_CPU_FAMILY_0X12_LN_F12LNMICROCODEPATCHTABLES_FILECODE       (0xC922)
#define PROC_CPU_FAMILY_0X12_LN_F12LNEQUIVALENCETABLE_FILECODE           (0xC923)
#define PROC_CPU_FAMILY_0X14_CPUCOMMONF14UTILITIES_FILECODE              (0XCA01)
#define PROC_CPU_FAMILY_0X14_CPUF14BRANDID_FILECODE                      (0XCA02)
#define PROC_CPU_FAMILY_0X14_CPUF14CACHEDEFAULTS_FILECODE                (0XCA03)
#define PROC_CPU_FAMILY_0X14_CPUF14DMI_FILECODE                          (0XCA04)
#define PROC_CPU_FAMILY_0X14_CPUF14MSRTABLES_FILECODE                    (0xCA06)
#define PROC_CPU_FAMILY_0X14_CPUF14PCITABLES_FILECODE                    (0xCA07)
#define PROC_CPU_FAMILY_0X14_CPUF14POWERCHECK_FILECODE                   (0XCA08)
#define PROC_CPU_FAMILY_0X14_CPUF14POWERMGMTSYSTEMTABLES_FILECODE        (0XCA09)
#define PROC_CPU_FAMILY_0X14_CPUF14POWERPLANE_FILECODE                   (0XCA0A)
#define PROC_CPU_FAMILY_0X14_CPUF14SOFTWARETHERMAL_FILECODE              (0XCA0B)
#define PROC_CPU_FAMILY_0X14_CPUF14UTILITIES_FILECODE                    (0XCA0C)
#define PROC_CPU_FAMILY_0X14_CPUF14WHEAINITDATATABLES_FILECODE           (0XCA0D)
#define PROC_CPU_FAMILY_0X14_CPUF14PSTATE_FILECODE                       (0XCA0E)
#define PROC_CPU_FAMILY_0X14_ON_F14ONLOGICALIDTABLES_FILECODE            (0xCA21)
#define PROC_CPU_FAMILY_0X14_ON_F14ONMICROCODEPATCHTABLES_FILECODE       (0xCA22)
#define PROC_CPU_FAMILY_0X14_ON_F14ONMSRTABLES_FILECODE                  (0xCA23)
#define PROC_CPU_FAMILY_0X14_ON_F14ONEQUIVALENCETABLE_FILECODE           (0xCA24)
#define PROC_CPU_FAMILY_0X14_ON_F14ONPCITABLES_FILECODE                  (0xCA25)

#define PROC_CPU_FEATURE_CPUCACHEFLUSHONHALT_FILECODE                    (0xDC01)
#define PROC_CPU_FEATURE_CPUCACHEINIT_FILECODE                           (0xDC02)
#define PROC_CPU_FEATURE_CPUDMI_FILECODE                                 (0xDC10)
#define PROC_CPU_FEATURE_CPUFEATURELEVELING_FILECODE                     (0xDC20)
#define PROC_CPU_FEATURE_CPUHTASSIST_FILECODE                            (0xDC30)
#define PROC_CPU_FEATURE_CPUPSTATEGATHER_FILECODE                        (0xDC41)
#define PROC_CPU_FEATURE_CPUPSTATELEVELING_FILECODE                      (0xDC42)
#define PROC_CPU_FEATURE_CPUPSTATETABLES_FILECODE                        (0xDC43)
#define PROC_CPU_FEATURE_CPUSLIT_FILECODE                                (0xDC50)
#define PROC_CPU_FEATURE_CPUSRAT_FILECODE                                (0xDC60)
#define PROC_CPU_FEATURE_CPUWHEA_FILECODE                                (0xDC70)
#define PROC_CPU_FEATURE_CPUHWC1E_FILECODE                               (0xDC80)
#define PROC_CPU_FEATURE_CPUC6STATE_FILECODE                             (0xDC81)
#define PROC_CPU_FEATURE_CPUFEATURES_FILECODE                            (0xDC90)
#define PROC_CPU_FEATURE_CPUMSGBASEDC1E_FILECODE                         (0xDCA0)
#define PROC_CPU_FEATURE_CPUCORELEVELING_FILECODE                        (0xDCB0)
#define PROC_CPU_FEATURE_PRESERVEMAILBOX_FILECODE                        (0xDCC0)

#define PROC_RECOVERY_CPU_CPURECOVERY_FILECODE                           (0xDE01)

#define PROC_HT_FEATURES_HTFEATSETS_FILECODE                             (0xE001)
#define PROC_HT_FEATURES_HTFEATDYNAMICDISCOVERY_FILECODE                 (0xE002)
#define PROC_HT_FEATURES_HTFEATGANGING_FILECODE                          (0xE003)
#define PROC_HT_FEATURES_HTFEATNONCOHERENT_FILECODE                      (0xE004)
#define PROC_HT_FEATURES_HTFEATOPTIMIZATION_FILECODE                     (0xE005)
#define PROC_HT_FEATURES_HTFEATROUTING_FILECODE                          (0xE006)
#define PROC_HT_FEATURES_HTFEATSUBLINKS_FILECODE                         (0xE007)
#define PROC_HT_FEATURES_HTFEATTRAFFICDISTRIBUTION_FILECODE              (0xE008)
#define PROC_HT_FEATURES_HTIDS_FILECODE                                  (0xE009)
#define PROC_HT_HTFEAT_FILECODE                                          (0xE021)
#define PROC_HT_HTINTERFACE_FILECODE                                     (0xE022)
#define PROC_HT_HTINTERFACECOHERENT_FILECODE                             (0xE023)
#define PROC_HT_HTINTERFACEGENERAL_FILECODE                              (0xE024)
#define PROC_HT_HTINTERFACENONCOHERENT_FILECODE                          (0xE025)
#define PROC_HT_HTMAIN_FILECODE                                          (0xE026)
#define PROC_HT_HTNOTIFY_FILECODE                                        (0xE027)
#define PROC_HT_HTGRAPH_HTGRAPH_FILECODE                                 (0xE028)
#define PROC_HT_HTNB_FILECODE                                            (0xE081)
#define PROC_HT_NBCOMMON_HTNBCOHERENT_FILECODE                           (0xE082)
#define PROC_HT_NBCOMMON_HTNBNONCOHERENT_FILECODE                        (0xE083)
#define PROC_HT_NBCOMMON_HTNBOPTIMIZATION_FILECODE                       (0xE084)
#define PROC_HT_NBCOMMON_HTNBUTILITIES_FILECODE                          (0xE085)
#define PROC_HT_FAM10_HTNBFAM10_FILECODE                                 (0xE0C1)
#define PROC_HT_FAM10_HTNBCOHERENTFAM10_FILECODE                         (0xE0C2)
#define PROC_HT_FAM10_HTNBNONCOHERENTFAM10_FILECODE                      (0xE0C3)
#define PROC_HT_FAM10_HTNBOPTIMIZATIONFAM10_FILECODE                     (0xE0C4)
#define PROC_HT_FAM10_HTNBSYSTEMFAM10_FILECODE                           (0xE0C5)
#define PROC_HT_FAM10_HTNBUTILITIESFAM10_FILECODE                        (0xE0C6)
#define PROC_HT_FAM12_HTNBFAM12_FILECODE                                 (0xE101)
#define PROC_HT_FAM12_HTNBUTILITIESFAM12_FILECODE                        (0xE102)
#define PROC_HT_FAM14_HTNBFAM14_FILECODE                                 (0xE141)
#define PROC_HT_FAM14_HTNBUTILITIESFAM14_FILECODE                        (0xE142)

#define PROC_RECOVERY_HT_HTINITRECOVERY_FILECODE                         (0xE302)
#define PROC_RECOVERY_HT_HTINITRESET_FILECODE                            (0xE301)

#define PROC_IDS_CONTROL_IDSCTRL_FILECODE                                (0xE801)
#define PROC_IDS_CONTROL_IDSLIB_FILECODE                                 (0xE802)
#define PROC_IDS_DEBUG_IDSDEBUG_FILECODE                                 (0xE803)
#define PROC_IDS_PERF_IDSPERF_FILECODE                                   (0xE804)
#define PROC_IDS_FAMILY_0X10_IDSF10ALLSERVICE_FILECODE                   (0xE805)
#define PROC_IDS_FAMILY_0X10_BL_IDSF10BLSERVICE_FILECODE                    (0xE806)
#define PROC_IDS_FAMILY_0X10_DA_IDSF10DASERVICE_FILECODE                    (0xE807)
#define PROC_IDS_FAMILY_0X10_HY_IDSF10HYSERVICE_FILECODE                    (0xE808)
#define PROC_IDS_FAMILY_0X10_RB_IDSF10RBSERVICE_FILECODE                    (0xE809)
#define PROC_IDS_FAMILY_0X12_IDSF12ALLSERVICE_FILECODE                   (0xE80A)
#define PROC_IDS_FAMILY_0X14_IDSF14ALLSERVICE_FILECODE                   (0xE80B)

#define PROC_MEM_ARDK_MA_FILECODE                                    (0xF001)
#define PROC_MEM_ARDK_DR_MARDR2_FILECODE                             (0xF002)
#define PROC_MEM_ARDK_DR_MARDR3_FILECODE                             (0xF003)
#define PROC_MEM_ARDK_HY_MARHY3_FILECODE                             (0xF004)
#define PROC_MEM_ARDK_LN_MASLN3_FILECODE                             (0xF005)
#define PROC_MEM_ARDK_DR_MAUDR3_FILECODE                             (0xF006)
#define PROC_MEM_ARDK_HY_MAUHY3_FILECODE                             (0xF007)
#define PROC_MEM_ARDK_LN_MAULN3_FILECODE                             (0xF008)
#define PROC_MEM_ARDK_DA_MAUDA3_FILECODE                             (0xF009)
#define PROC_MEM_ARDK_DA_MASDA2_FILECODE                             (0xF00A)
#define PROC_MEM_ARDK_DA_MASDA3_FILECODE                             (0xF00B)
#define PROC_MEM_ARDK_NI_MASNI3_FILECODE                             (0xF00C)
#define PROC_MEM_ARDK_C32_MARC32_3_FILECODE                          (0xF00D)
#define PROC_MEM_ARDK_C32_MAUC32_3_FILECODE                          (0xF00E)
#define PROC_MEM_ARDK_NI_MAUNI3_FILECODE                             (0xF00F)
#define PROC_MEM_ARDK_ON_MASON3_FILECODE                             (0xF010)
#define PROC_MEM_ARDK_ON_MAUON3_FILECODE                             (0xF011)

#define PROC_MEM_FEAT_CHINTLV_MFCHI_FILECODE                         (0xF081)
#define PROC_MEM_FEAT_CSINTLV_MFCSI_FILECODE                         (0xF082)
#define PROC_MEM_FEAT_ECC_MFECC_FILECODE                             (0xF083)
#define PROC_MEM_FEAT_ECC_MFEMP_FILECODE                             (0xF085)
#define PROC_MEM_FEAT_EXCLUDIMM_MFDIMMEXCLUD_FILECODE                (0xF086)
#define PROC_MEM_FEAT_IDENDIMM_MFIDENDIMM_FILECODE                   (0xF088)
#define PROC_MEM_FEAT_INTLVRN_MFINTLVRN_FILECODE                     (0xF089)
#define PROC_MEM_FEAT_LVDDR3_MFLVDDR3_FILECODE                       (0xF08A)
#define PROC_MEM_FEAT_MEMCLR_MFMEMCLR_FILECODE                       (0xF08B)
#define PROC_MEM_FEAT_NDINTLV_MFNDI_FILECODE                         (0xF08C)
#define PROC_MEM_FEAT_ODTHERMAL_MFODTHERMAL_FILECODE                 (0xF08D)
#define PROC_MEM_FEAT_OLSPARE_MFSPR_FILECODE                         (0xF08E)
#define PROC_MEM_FEAT_PARTRN_MFPARALLELTRAINING_FILECODE             (0xF08F)
#define PROC_MEM_FEAT_PARTRN_MFSTANDARDTRAINING_FILECODE             (0xF091)
#define PROC_MEM_FEAT_S3_MFS3_FILECODE                               (0xF092)
#define PROC_MEM_FEAT_TABLE_MFTDS_FILECODE                           (0xF093)

#define PROC_MEM_MAIN_MDEF_FILECODE                                  (0xF101)
#define PROC_MEM_MAIN_MINIT_FILECODE                                 (0xF102)
#define PROC_MEM_MAIN_MM_FILECODE                                    (0xF103)
#define PROC_MEM_FEAT_DMI_MFDMI_FILECODE                             (0xF104)
#define PROC_MEM_MAIN_MMECC_FILECODE                                 (0xF105)
#define PROC_MEM_MAIN_MMEXCLUDEDIMM_FILECODE                         (0xF106)
#define PROC_MEM_MAIN_DR_MMFLOWDR_FILECODE                              (0xF107)
#define PROC_MEM_MAIN_HY_MMFLOWHY_FILECODE                              (0xF108)
#define PROC_MEM_MAIN_LN_MMFLOWLN_FILECODE                              (0xF109)
#define PROC_MEM_MAIN_ON_MMFLOWON_FILECODE                              (0xF10A)
#define PROC_MEM_MAIN_MMNODEINTERLEAVE_FILECODE                      (0xF10B)
#define PROC_MEM_MAIN_MMONLINESPARE_FILECODE                         (0xF10C)
#define PROC_MEM_MAIN_MMPARALLELTRAINING_FILECODE                    (0xF10D)
#define PROC_MEM_MAIN_MMSTANDARDTRAINING_FILECODE                    (0xF10E)
#define PROC_MEM_MAIN_MUC_FILECODE                                   (0xF10F)
#define PROC_MEM_MAIN_MMMEMCLR_FILECODE                              (0xF110)
#define PROC_MEM_MAIN_DA_MMFLOWDA_FILECODE                              (0xF111)
#define PROC_MEM_MAIN_MMFLOW_FILECODE                                (0xF112)
#define PROC_MEM_MAIN_MERRHDL_FILECODE                               (0xF113)
#define PROC_MEM_MAIN_C32_MMFLOWC32_FILECODE                             (0xF114)
#define PROC_MEM_MAIN_MMLVDDR3_FILECODE                              (0xF115)
#define PROC_MEM_MAIN_MMUMAALLOC_FILECODE                            (0xF116)
#define PROC_MEM_MAIN_MMMEMRESTORE_FILECODE                          (0xF117)
#define PROC_MEM_MAIN_MMCONDITIONALPSO_FILECODE                      (0xF118)

#define PROC_MEM_NB_DR_MNDR_FILECODE                                 (0XF213)
#define PROC_MEM_NB_DR_MNFLOWDR_FILECODE                             (0XF214)
#define PROC_MEM_NB_DR_MNIDENDIMMDR_FILECODE                         (0XF216)
#define PROC_MEM_NB_DR_MNMCTDR_FILECODE                              (0XF217)
#define PROC_MEM_NB_DR_MNDCTDR_FILECODE                              (0XF218)
#define PROC_MEM_NB_DR_MNOTDR_FILECODE                               (0XF219)
#define PROC_MEM_NB_DR_MNPARTRAINDR_FILECODE                         (0XF21A)
#define PROC_MEM_NB_DR_MNPROTODR_FILECODE                            (0XF21C)
#define PROC_MEM_NB_DR_MNS3DR_FILECODE                               (0XF21D)
#define PROC_MEM_NB_DR_MNREGDR_FILECODE                              (0XF21E)
#define PROC_MEM_NB_HY_MNFLOWHY_FILECODE                             (0XF233)
#define PROC_MEM_NB_HY_MNHY_FILECODE                                 (0XF235)
#define PROC_MEM_NB_HY_MNIDENDIMMHY_FILECODE                         (0XF236)
#define PROC_MEM_NB_HY_MNMCTHY_FILECODE                              (0XF237)
#define PROC_MEM_NB_HY_MNDCTHY_FILECODE                              (0XF238)
#define PROC_MEM_NB_HY_MNOTHY_FILECODE                               (0XF239)
#define PROC_MEM_NB_HY_MNPARTRAINHY_FILECODE                         (0XF23A)
#define PROC_MEM_NB_HY_MNPHYHY_FILECODE                              (0XF23B)
#define PROC_MEM_NB_HY_MNPROTOHY_FILECODE                            (0XF23C)
#define PROC_MEM_NB_HY_MNS3HY_FILECODE                               (0XF23D)
#define PROC_MEM_NB_HY_MNREGHY_FILECODE                              (0XF23E)
#define PROC_MEM_NB_ON_MNON_FILECODE                                 (0xF240)
#define PROC_MEM_NB_ON_MNREGON_FILECODE                              (0xF241)
#define PROC_MEM_NB_ON_MNDCTON_FILECODE                              (0xF242)
#define PROC_MEM_NB_ON_MNIDENDIMMON_FILECODE                         (0xF244)
#define PROC_MEM_NB_ON_MNMCTON_FILECODE                              (0xF245)
#define PROC_MEM_NB_ON_MNOTON_FILECODE                               (0xF246)
#define PROC_MEM_NB_ON_MNPHYON_FILECODE                              (0xF247)
#define PROC_MEM_NB_ON_MNS3ON_FILECODE                               (0xF248)
#define PROC_MEM_NB_ON_MNFLOWON_FILECODE                             (0xF249)
#define PROC_MEM_NB_LN_MNDCTLN_FILECODE                              (0XF252)
#define PROC_MEM_NB_LN_MNFLOWLN_FILECODE                             (0XF253)
#define PROC_MEM_NB_LN_MNIDENDIMMLN_FILECODE                         (0XF254)
#define PROC_MEM_NB_LN_MNMCTLN_FILECODE                              (0XF255)
#define PROC_MEM_NB_LN_MNOTLN_FILECODE                               (0XF256)
#define PROC_MEM_NB_LN_MNPHYLN_FILECODE                              (0XF257)
#define PROC_MEM_NB_LN_MNPROTOLN_FILECODE                            (0XF258)
#define PROC_MEM_NB_LN_MNLN_FILECODE                                 (0XF259)
#define PROC_MEM_NB_LN_MNS3LN_FILECODE                               (0XF25A)
#define PROC_MEM_NB_LN_MNREGLN_FILECODE                              (0XF25B)
#define PROC_MEM_NB_DA_MNDA_FILECODE                                 (0XF260)
#define PROC_MEM_NB_DA_MNFLOWDA_FILECODE                             (0XF261)
#define PROC_MEM_NB_DA_MNIDENDIMMDA_FILECODE                         (0XF263)
#define PROC_MEM_NB_DA_MNMCTDA_FILECODE                              (0XF264)
#define PROC_MEM_NB_DA_MNDCTDA_FILECODE                              (0XF265)
#define PROC_MEM_NB_DA_MNOTDA_FILECODE                               (0XF266)
#define PROC_MEM_NB_DA_MNPARTRAINDA_FILECODE                         (0XF267)
#define PROC_MEM_NB_DA_MNPROTODA_FILECODE                            (0XF269)
#define PROC_MEM_NB_DA_MNS3DA_FILECODE                               (0XF26A)
#define PROC_MEM_NB_DA_MNREGDA_FILECODE                              (0XF26B)
#define PROC_MEM_NB_C32_MNC32_FILECODE                               (0XF26C)
#define PROC_MEM_NB_C32_MNDCTC32_FILECODE                            (0XF26D)
#define PROC_MEM_NB_C32_MNFLOWC32_FILECODE                           (0XF26E)
#define PROC_MEM_NB_C32_MNIDENDIMMC32_FILECODE                       (0XF26F)
#define PROC_MEM_NB_C32_MNMCTC32_FILECODE                            (0XF270)
#define PROC_MEM_NB_C32_MNOTC32_FILECODE                             (0XF271)
#define PROC_MEM_NB_C32_MNPARTRAINC32_FILECODE                       (0XF272)
#define PROC_MEM_NB_C32_MNPHYC32_FILECODE                            (0XF273)
#define PROC_MEM_NB_C32_MNPROTOC32_FILECODE                          (0XF274)
#define PROC_MEM_NB_C32_MNS3C32_FILECODE                             (0XF275)
#define PROC_MEM_NB_C32_MNREGC32_FILECODE                            (0XF277)
#define PROC_MEM_NB_MN_FILECODE                                      (0XF27C)
#define PROC_MEM_NB_MNDCT_FILECODE                                   (0XF27D)
#define PROC_MEM_NB_MNPHY_FILECODE                                   (0XF27E)
#define PROC_MEM_NB_MNMCT_FILECODE                                   (0XF27F)
#define PROC_MEM_NB_MNS3_FILECODE                                    (0XF280)
#define PROC_MEM_NB_MNFLOW_FILECODE                                  (0XF281)
#define PROC_MEM_NB_MNFEAT_FILECODE                                  (0XF282)
#define PROC_MEM_NB_MNTRAIN2_FILECODE                                (0XF283)
#define PROC_MEM_NB_MNTRAIN3_FILECODE                                (0XF284)
#define PROC_MEM_NB_MNREG_FILECODE                                   (0XF285)
#define PROC_MEM_NB_NI_MNNI_FILECODE                                 (0XF286)
#define PROC_MEM_NB_NI_MNS3NI_FILECODE                               (0XF287)

#define PROC_MEM_PS_MP_FILECODE                                      (0XF401)
#define PROC_MEM_PS_DR_MPRDR3_FILECODE                               (0XF402)
#define PROC_MEM_PS_HY_MPRHY3_FILECODE                               (0XF403)
#define PROC_MEM_PS_LN_MPRLN3_FILECODE                               (0XF404)
#define PROC_MEM_PS_DR_MPSDR3_FILECODE                               (0XF405)
#define PROC_MEM_PS_HY_MPSHY3_FILECODE                               (0XF406)
#define PROC_MEM_PS_LN_MPSLN3_FILECODE                               (0XF407)
#define PROC_MEM_PS_DR_MPUDR3_FILECODE                               (0XF408)
#define PROC_MEM_PS_HY_MPUHY3_FILECODE                               (0XF409)
#define PROC_MEM_PS_LN_MPULN3_FILECODE                               (0XF40A)
#define PROC_MEM_PS_DA_MPUDA3_FILECODE                               (0XF40B)
#define PROC_MEM_PS_DA_MPSDA2_FILECODE                               (0XF40C)
#define PROC_MEM_PS_DA_MPSDA3_FILECODE                               (0XF40D)
#define PROC_MEM_PS_DR_MPRDR2_FILECODE                               (0XF40E)
#define PROC_MEM_PS_DR_MPUDR2_FILECODE                               (0XF40F)
#define PROC_MEM_PS_C32_MPRC32_3_FILECODE                            (0XF410)
#define PROC_MEM_PS_C32_MPUC32_3_FILECODE                            (0XF411)
#define PROC_MEM_PS_NI_MPSNI3_FILECODE                               (0XF412)
#define PROC_MEM_PS_NI_MPUNI3_FILECODE                               (0XF413)
#define PROC_MEM_PS_ON_MPSON3_FILECODE                               (0XF414)
#define PROC_MEM_PS_ON_MPUON3_FILECODE                               (0XF415)

#define PROC_MEM_TECH_MT_FILECODE                                    (0XF501)
#define PROC_MEM_TECH_MTHDI_FILECODE                                 (0XF502)
#define PROC_MEM_TECH_MTTDIMBT_FILECODE                              (0XF504)
#define PROC_MEM_TECH_MTTECC_FILECODE                                (0XF505)
#define PROC_MEM_TECH_MTTHRC_FILECODE                                (0XF506)
#define PROC_MEM_TECH_MTTML_FILECODE                                 (0XF507)
#define PROC_MEM_TECH_MTTOPTSRC_FILECODE                             (0XF509)
#define PROC_MEM_TECH_MTTSRC_FILECODE                                (0XF50B)
#define PROC_MEM_TECH_MTTEDGEDETECT_FILECODE                         (0XF50C)
#define PROC_MEM_TECH_DDR2_MT2_FILECODE                              (0XF541)
#define PROC_MEM_TECH_DDR2_MTOT2_FILECODE                            (0XF543)
#define PROC_MEM_TECH_DDR2_MTSPD2_FILECODE                           (0XF544)
#define PROC_MEM_TECH_DDR3_MT3_FILECODE                              (0XF581)
#define PROC_MEM_TECH_DDR3_MTOT3_FILECODE                            (0XF583)
#define PROC_MEM_TECH_DDR3_MTRCI3_FILECODE                           (0XF584)
#define PROC_MEM_TECH_DDR3_MTSDI3_FILECODE                           (0XF585)
#define PROC_MEM_TECH_DDR3_MTSPD3_FILECODE                           (0XF586)
#define PROC_MEM_TECH_DDR3_MTTWL3_FILECODE                           (0XF587)
#define PROC_MEM_TECH_DDR3_MTTECC3_FILECODE                          (0XF588)

#define PROC_RECOVERY_MEM_MRDEF_FILECODE                             (0XF801)
#define PROC_RECOVERY_MEM_MRINIT_FILECODE                            (0XF802)
#define PROC_RECOVERY_MEM_MRM_FILECODE                               (0XF803)
#define PROC_RECOVERY_MEM_MRUC_FILECODE                              (0XF804)
#define PROC_RECOVERY_MEM_NB_DR_MRNDR_FILECODE                       (0XF812)
#define PROC_RECOVERY_MEM_NB_DR_MRNMCTDR_FILECODE                    (0XF813)
#define PROC_RECOVERY_MEM_NB_HY_MRNDCTHY_FILECODE                    (0XF821)
#define PROC_RECOVERY_MEM_NB_HY_MRNHY_FILECODE                       (0XF822)
#define PROC_RECOVERY_MEM_NB_HY_MRNMCTHY_FILECODE                    (0XF823)
#define PROC_RECOVERY_MEM_NB_HY_MRNPROTOHY_FILECODE                  (0XF825)
#define PROC_RECOVERY_MEM_NB_LN_MRNDCTLN_FILECODE                    (0XF831)
#define PROC_RECOVERY_MEM_NB_LN_MRNMCTLN_FILECODE                    (0XF832)
#define PROC_RECOVERY_MEM_NB_LN_MRNLN_FILECODE                       (0XF833)
#define PROC_RECOVERY_MEM_NB_DA_MRNDA_FILECODE                       (0XF842)
#define PROC_RECOVERY_MEM_NB_DA_MRNMCTDA_FILECODE                    (0XF843)
#define PROC_RECOVERY_MEM_NB_NI_MRNNI_FILECODE                       (0XF845)
#define PROC_RECOVERY_MEM_NB_C32_MRNC32_FILECODE                     (0XF851)
#define PROC_RECOVERY_MEM_NB_C32_MRNMCTC32_FILECODE                  (0XF852)
#define PROC_RECOVERY_MEM_NB_C32_MRNPROTOC32_FILECODE                (0XF853)
#define PROC_RECOVERY_MEM_NB_ON_MRNDCTON_FILECODE                    (0xF861)
#define PROC_RECOVERY_MEM_NB_ON_MRNMCTON_FILECODE                    (0xF862)
#define PROC_RECOVERY_MEM_NB_ON_MRNON_FILECODE                       (0xF863)
#define PROC_RECOVERY_MEM_TECH_MRTTPOS_FILECODE                      (0XF8C1)
#define PROC_RECOVERY_MEM_TECH_MRTTSRC_FILECODE                      (0XF8C2)
#define PROC_RECOVERY_MEM_TECH_DDR3_MRT3_FILECODE                    (0XF8C3)
#define PROC_RECOVERY_MEM_TECH_DDR3_MRTRCI3_FILECODE                 (0XF8C4)
#define PROC_RECOVERY_MEM_TECH_DDR3_MRTSDI3_FILECODE                 (0XF8C5)
#define PROC_RECOVERY_MEM_TECH_DDR3_MRTSPD3_FILECODE                 (0XF8C6)
#define PROC_RECOVERY_MEM_TECH_DDR3_MRTTWL3_FILECODE                 (0XF8C7)
#define PROC_RECOVERY_MEM_NB_MRN_FILECODE                            (0XF8C8)
#define PROC_RECOVERY_MEM_NB_MRNDCT_FILECODE                         (0XF8C9)
#define PROC_RECOVERY_MEM_NB_MRNMCT_FILECODE                         (0XF8CA)
#define PROC_RECOVERY_MEM_NB_MRNTRAIN3_FILECODE                      (0XF8CB)

#endif // _FILECODE_H_
