/* $NoKeywords:$ */
/**
 * @file
 *
 * AMD Family_15 Models 0x00 - 0x0F Power Management related initialization table
 *
 * @xrefitem bom "File Content Label" "Release Content"
 * @e project:      AGESA
 * @e sub-project:  CPU/Family/0x15/OR
 * @e \$Revision: 55600 $   @e \$Date: 2011-06-23 12:39:18 -0600 (Thu, 23 Jun 2011) $
 *
 */
/*
 ******************************************************************************
 *
 * Copyright (C) 2012 Advanced Micro Devices, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Advanced Micro Devices, Inc. nor the names of
 *       its contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL ADVANCED MICRO DEVICES, INC. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
 */

/*----------------------------------------------------------------------------------------
 *                             M O D U L E S    U S E D
 *----------------------------------------------------------------------------------------
 */
#include "AGESA.h"
#include "Ids.h"
#include "cpuRegisters.h"
#include "cpuApicUtilities.h"
#include "cpuFamilyTranslation.h"
#include "cpuPowerMgmtSystemTables.h"
#include "cpuF15OrCoreAfterReset.h"
#include "cpuF15OrNbAfterReset.h"
#include "cpuF15OrSoftwareThermal.h"
#include "F15OrPowerPlane.h"
#include "cpuF15PowerCheck.h"
#include "F15OrPmNbCofVidInit.h"
#include "F15OrUtilities.h"

#include "Filecode.h"
CODE_GROUP (G2_PEI)
RDATA_GROUP (G2_PEI)

#define FILECODE PROC_CPU_FAMILY_0X15_OR_F15ORPOWERMGMTSYSTEMTABLES_FILECODE

/*----------------------------------------------------------------------------------------
 *                   D E F I N I T I O N S    A N D    M A C R O S
 *----------------------------------------------------------------------------------------
 */

/*----------------------------------------------------------------------------------------
 *                  T Y P E D E F S     A N D     S T R U C T U R E S
 *----------------------------------------------------------------------------------------
 */

/*----------------------------------------------------------------------------------------
 *           P R O T O T Y P E S     O F     L O C A L     F U N C T I O N S
 *----------------------------------------------------------------------------------------
 */
VOID
GetF15OrSysPmTable (
  IN       CPU_SPECIFIC_SERVICES *FamilySpecificServices,
     OUT   CONST VOID **SysPmTblPtr,
     OUT   UINT8 *NumberOfElements,
  IN       AMD_CONFIG_PARAMS *StdHeader
  );

/*----------------------------------------------------------------------------------------
 *                          E X P O R T E D    F U N C T I O N S
 *----------------------------------------------------------------------------------------
 */

/*  Family 15h Only Table */
/* ---------------------- */
CONST SYS_PM_TBL_STEP ROMDATA CpuF15OrSysPmTableArray[] =
{

  IDS_INITIAL_F15_OR_PM_STEP

  // Step 1 - Configure F3x[84:80].  Handled by PCI register table.
  // Step 2 - Power Plane Initialization
  //   Execute both cold & warm
  {
    0,                                                // ExeFlags
    F15OrPmPwrPlaneInit                               // Function Pointer
  },

  // Step x - Disable NB Pstate, if required
  //   Execute both cold & warm
  {
    0,                                                // ExeFlags
    F15OrNbPstateDis                                  // Function Pointer
  },

  // Step 3 - Configure Northbridge COF and VID.
  //   Execute only after warm reset
  {
    PM_EXEFLAGS_WARM_ONLY,                            // ExeFlags
    F15OrPmNbCofVidInit                               // Function Pointer
  },

  // Step 4 - Core Minimum P-state Transition Sequence After Warm Reset
  //   Execute only after warm reset
  {
    PM_EXEFLAGS_WARM_ONLY,                            // ExeFlags
    F15OrPmCoreAfterReset                             // Function Pointer
  },

  // Step 5 - NB COF and VID Transition Sequence After Warm Reset
  //   Execute only after warm reset
  {
    PM_EXEFLAGS_WARM_ONLY,                            // ExeFlags
    F15OrPmNbAfterReset                               // Function Pointer
  },

  // Step 6 - Power Check
  //   Execute only after warm reset
  {
    PM_EXEFLAGS_WARM_ONLY,                            // ExeFlags
    F15PmPwrCheck                                     // Function Pointer
  },

  // Step 7 - Software Thermal Control Init
  //   Execute only after warm reset
  {
    PM_EXEFLAGS_WARM_ONLY,                            // ExeFlags
    F15OrPmThermalInit                                // Function Pointer
  }
};


/*---------------------------------------------------------------------------------------*/
/**
 *  Returns the appropriate table of steps to perform to initialize the power management
 *  subsystem.
 *
 *  @CpuServiceMethod{::F_CPU_GET_FAMILY_SPECIFIC_ARRAY}.
 *
 *  @param[in]   FamilySpecificServices   The current Family Specific Services.
 *  @param[out]  SysPmTblPtr              Points to the first entry in the table.
 *  @param[out]  NumberOfElements         Number of valid entries in the table.
 *  @param[in]   StdHeader                Header for library and services.
 *
 */
VOID
GetF15OrSysPmTable (
  IN       CPU_SPECIFIC_SERVICES *FamilySpecificServices,
     OUT   CONST VOID **SysPmTblPtr,
     OUT   UINT8 *NumberOfElements,
  IN       AMD_CONFIG_PARAMS *StdHeader
  )
{
  *NumberOfElements = (sizeof (CpuF15OrSysPmTableArray) / sizeof (SYS_PM_TBL_STEP));
  *SysPmTblPtr = CpuF15OrSysPmTableArray;
}
