# Inoffical Documentation of Intel MCHBAR register space.

The MCHBAR can be enabled by using register 0x48 of PCI(0:0:0) device.

This documentation is incomplete and might be incorrect.
Please handle with care !

**MCHBAR + 0x4**

*Width:* 64 Bit

*Desc:*  Lane training result Register,  Channel 0,  lane 0

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|       0:63| Training result, each bit corresponds to one of the 64 settings  |
|           | of IO delay                                                      |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x10**

*Width:* 32 Bit

*Desc:*  Read delay settings, Rank 0 Register,  Channel 0,  lane 0

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                    IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       6:11|                      DQS phase shift on rising edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
|      16:18|                                                 IO delay in DCKs |
+-----------+------------------------------------------------------------------+
|      20:25|                     DQS phase shift on falling edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x14**

*Width:* 32 Bit

*Desc:* Read delay settings, Rank 1 Register,  Channel 0,  lane 0

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                    IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       6:11|                      DQS phase shift on rising edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
|      16:18|                                                 IO delay in DCKs |
+-----------+------------------------------------------------------------------+
|      20:25|                     DQS phase shift on falling edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x18**

*Width:* 32 Bit

*Desc:* Read delay settings, Rank 2 Register,  Channel 0,  lane 0

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                    IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       6:11|                      DQS phase shift on rising edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
|      16:18|                                                 IO delay in DCKs |
+-----------+------------------------------------------------------------------+
|      20:25|                     DQS phase shift on falling edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x1c**

*Width:* 32 Bit

*Desc:*  Read delay settings, Rank 3 Register,  Channel 0,  lane 0

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                    IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       6:11|                      DQS phase shift on rising edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
|      16:18|                                                 IO delay in DCKs |
+-----------+------------------------------------------------------------------+
|      20:25|                     DQS phase shift on falling edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x20**

*Width:* 24 Bit

*Desc:*  Write delay settings, Rank 0 Register,  Channel 0,  lane 0

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                 DQ IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       8:13|                                DQS IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|      15:17|                                       DQS IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
|        20 |                                        DQ IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x24**

*Width:* 24 Bit

*Desc:*  Write delay settings, Rank 1 Register,  Channel 0,  lane 0

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                 DQ IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       8:13|                                DQS IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|      15:17|                                       DQS IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
|        20 |                                        DQ IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x28**

*Width:* 24 Bit

*Desc:*  Write delay settings, Rank 2 Register,  Channel 0,  lane 0

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                 DQ IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       8:13|                                DQS IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|      15:17|                                       DQS IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
|        20 |                                        DQ IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x2c**

*Width:* 24 Bit

*Desc:*  Write delay settings, Rank 3 Register,  Channel 0,  lane 0

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                 DQ IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       8:13|                                DQS IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|      15:17|                                       DQS IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
|        20 |                                        DQ IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x204**

*Width:* 64 Bit

*Desc:*  Lane training result Register,  Channel 0,  lane 1

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|       0:63|  Training result, each bit corresponds to one of the 64 settings |
|           |  of IO delay                                                     |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x210**

*Width:* 32 Bit

*Desc:*  Read delay settings, Rank 0 Register,  Channel 0,  lane 1

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                    IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       6:11|                      DQS phase shift on rising edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
|      16:18|                                                 IO delay in DCKs |
+-----------+------------------------------------------------------------------+
|      20:25|                     DQS phase shift on falling edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x214**

*Width:* 32 Bit

*Desc:* Read delay settings, Rank 1 Register,  Channel 0,  lane 1

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                    IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       6:11|                      DQS phase shift on rising edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
|      16:18|                                                 IO delay in DCKs |
+-----------+------------------------------------------------------------------+
|      20:25|                     DQS phase shift on falling edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x218**

*Width:* 32 Bit

*Desc:* Read delay settings, Rank 2 Register,  Channel 0,  lane 1

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                    IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       6:11|                      DQS phase shift on rising edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
|      16:18|                                                 IO delay in DCKs |
+-----------+------------------------------------------------------------------+
|      20:25|                     DQS phase shift on falling edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x21c**

*Width:* 32 Bit

*Desc:*  Read delay settings, Rank 3 Register,  Channel 0,  lane 1

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                    IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       6:11|                      DQS phase shift on rising edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
|      16:18|                                                 IO delay in DCKs |
+-----------+------------------------------------------------------------------+
|      20:25|                     DQS phase shift on falling edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x220**

*Width:* 24 Bit

*Desc:*  Write delay settings, Rank 0 Register,  Channel 0,  lane 1

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                 DQ IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       8:13|                                DQS IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|      15:17|                                       DQS IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
|        20 |                                        DQ IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x224**

*Width:* 24 Bit

*Desc:*  Write delay settings, Rank 1 Register,  Channel 0,  lane 1

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                 DQ IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       8:13|                                DQS IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|      15:17|                                       DQS IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
|        20 |                                        DQ IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x228**

*Width:* 24 Bit

*Desc:*  Write delay settings, Rank 2 Register,  Channel 0,  lane 1

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                 DQ IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       8:13|                                DQS IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|      15:17|                                       DQS IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
|        20 |                                        DQ IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x22c**

*Width:* 24 Bit

*Desc:*  Write delay settings, Rank 3 Register,  Channel 0,  lane 1

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                 DQ IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       8:13|                                DQS IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|      15:17|                                       DQS IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
|        20 |                                        DQ IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x404**

*Width:* 64 Bit

*Desc:*  Lane training result Register,  Channel 0,  lane 2

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|       0:63|  Training result, each bit corresponds to one of the 64 settings |
|           |  of IO delay                                                     |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x410**

*Width:* 32 Bit

*Desc:*  Read delay settings, Rank 0 Register,  Channel 0,  lane 2

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                    IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       6:11|                      DQS phase shift on rising edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
|      16:18|                                                 IO delay in DCKs |
+-----------+------------------------------------------------------------------+
|      20:25|                     DQS phase shift on falling edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x414**

*Width:* 32 Bit

*Desc:* Read delay settings, Rank 1 Register,  Channel 0,  lane 2

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                    IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       6:11|                      DQS phase shift on rising edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
|      16:18|                                                 IO delay in DCKs |
+-----------+------------------------------------------------------------------+
|      20:25|                     DQS phase shift on falling edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x418**

*Width:* 32 Bit

*Desc:* Read delay settings, Rank 2 Register,  Channel 0,  lane 2

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                    IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       6:11|                      DQS phase shift on rising edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
|      16:18|                                                 IO delay in DCKs |
+-----------+------------------------------------------------------------------+
|      20:25|                     DQS phase shift on falling edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x41c**

*Width:* 32 Bit

*Desc:*  Read delay settings, Rank 3 Register,  Channel 0,  lane 2

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                    IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       6:11|                      DQS phase shift on rising edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
|      16:18|                                                 IO delay in DCKs |
+-----------+------------------------------------------------------------------+
|      20:25|                     DQS phase shift on falling edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x420**

*Width:* 24 Bit

*Desc:*  Write delay settings, Rank 0 Register,  Channel 0,  lane 2

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                 DQ IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       8:13|                                DQS IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|      15:17|                                       DQS IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
|        20 |                                        DQ IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x424**

*Width:* 24 Bit

*Desc:*  Write delay settings, Rank 1 Register,  Channel 0,  lane 2

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                 DQ IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       8:13|                                DQS IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|      15:17|                                       DQS IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
|        20 |                                        DQ IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x428**

*Width:* 24 Bit

*Desc:*  Write delay settings, Rank 2 Register,  Channel 0,  lane 2

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                 DQ IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       8:13|                                DQS IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|      15:17|                                       DQS IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
|        20 |                                        DQ IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x42c**

*Width:* 24 Bit

*Desc:*  Write delay settings, Rank 3 Register,  Channel 0,  lane 2

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                 DQ IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       8:13|                                DQS IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|      15:17|                                       DQS IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
|        20 |                                        DQ IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x604**

*Width:* 64 Bit

*Desc:*  Lane training result Register,  Channel 0,  lane 3

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|       0:63|  Training result, each bit corresponds to one of the 64 settings |
|           |  of IO delay                                                     |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x610**

*Width:* 32 Bit

*Desc:*  Read delay settings, Rank 0 Register,  Channel 0,  lane 3

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                    IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       6:11|                      DQS phase shift on rising edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
|      16:18|                                                 IO delay in DCKs |
+-----------+------------------------------------------------------------------+
|      20:25|                     DQS phase shift on falling edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x614**

*Width:* 32 Bit

*Desc:* Read delay settings, Rank 1 Register,  Channel 0,  lane 3

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                    IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       6:11|                      DQS phase shift on rising edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
|      16:18|                                                 IO delay in DCKs |
+-----------+------------------------------------------------------------------+
|      20:25|                     DQS phase shift on falling edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x618**

*Width:* 32 Bit

*Desc:* Read delay settings, Rank 2 Register,  Channel 0,  lane 3

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                    IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       6:11|                      DQS phase shift on rising edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
|      16:18|                                                 IO delay in DCKs |
+-----------+------------------------------------------------------------------+
|      20:25|                     DQS phase shift on falling edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x61c**

*Width:* 32 Bit

*Desc:*  Read delay settings, Rank 3 Register,  Channel 0,  lane 3

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                    IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       6:11|                      DQS phase shift on rising edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
|      16:18|                                                 IO delay in DCKs |
+-----------+------------------------------------------------------------------+
|      20:25|                     DQS phase shift on falling edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x620**

*Width:* 24 Bit

*Desc:*  Write delay settings, Rank 0 Register,  Channel 0,  lane 3

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                 DQ IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       8:13|                                DQS IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|      15:17|                                       DQS IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
|        20 |                                        DQ IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x624**

*Width:* 24 Bit

*Desc:*  Write delay settings, Rank 1 Register,  Channel 0,  lane 3

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                 DQ IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       8:13|                                DQS IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|      15:17|                                       DQS IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
|        20 |                                        DQ IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x628**

*Width:* 24 Bit

*Desc:*  Write delay settings, Rank 2 Register,  Channel 0,  lane 3

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                 DQ IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       8:13|                                DQS IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|      15:17|                                       DQS IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
|        20 |                                        DQ IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x62c**

*Width:* 24 Bit

*Desc:*  Write delay settings, Rank 3 Register,  Channel 0,  lane 3

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                 DQ IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       8:13|                                DQS IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|      15:17|                                       DQS IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
|        20 |                                        DQ IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x804**

*Width:* 64 Bit

*Desc:*  Lane training result Register,  Channel 0,  lane 4

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|       0:63|  Training result, each bit corresponds to one of the 64 settings |
|           |  of IO delay                                                     |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x810**

*Width:* 32 Bit

*Desc:*  Read delay settings, Rank 0 Register,  Channel 0,  lane 4

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                    IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       6:11|                      DQS phase shift on rising edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
|      16:18|                                                 IO delay in DCKs |
+-----------+------------------------------------------------------------------+
|      20:25|                     DQS phase shift on falling edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x814**

*Width:* 32 Bit

*Desc:* Read delay settings, Rank 1 Register,  Channel 0,  lane 4

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                    IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       6:11|                      DQS phase shift on rising edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
|      16:18|                                                 IO delay in DCKs |
+-----------+------------------------------------------------------------------+
|      20:25|                     DQS phase shift on falling edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x818**

*Width:* 32 Bit

*Desc:* Read delay settings, Rank 2 Register,  Channel 0,  lane 4

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                    IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       6:11|                      DQS phase shift on rising edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
|      16:18|                                                 IO delay in DCKs |
+-----------+------------------------------------------------------------------+
|      20:25|                     DQS phase shift on falling edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x81c**

*Width:* 32 Bit

*Desc:*  Read delay settings, Rank 3 Register,  Channel 0,  lane 4

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                    IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       6:11|                      DQS phase shift on rising edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
|      16:18|                                                 IO delay in DCKs |
+-----------+------------------------------------------------------------------+
|      20:25|                     DQS phase shift on falling edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x820**

*Width:* 24 Bit

*Desc:*  Write delay settings, Rank 0 Register,  Channel 0,  lane 4

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                 DQ IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       8:13|                                DQS IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|      15:17|                                       DQS IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
|        20 |                                        DQ IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x824**

*Width:* 24 Bit

*Desc:*  Write delay settings, Rank 1 Register,  Channel 0,  lane 4

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                 DQ IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       8:13|                                DQS IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|      15:17|                                       DQS IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
|        20 |                                        DQ IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x828**

*Width:* 24 Bit

*Desc:*  Write delay settings, Rank 2 Register,  Channel 0,  lane 4

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                 DQ IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       8:13|                                DQS IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|      15:17|                                       DQS IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
|        20 |                                        DQ IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x82c**

*Width:* 24 Bit

*Desc:*  Write delay settings, Rank 3 Register,  Channel 0,  lane 4

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                 DQ IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       8:13|                                DQS IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|      15:17|                                       DQS IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
|        20 |                                        DQ IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0xa04**

*Width:* 64 Bit

*Desc:*  Lane training result Register,  Channel 0,  lane 5

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|       0:63|  Training result, each bit corresponds to one of the 64 settings |
|           |  of IO delay                                                     |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0xa10**

*Width:* 32 Bit

*Desc:*  Read delay settings, Rank 0 Register,  Channel 0,  lane 5

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                    IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       6:11|                      DQS phase shift on rising edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
|      16:18|                                                 IO delay in DCKs |
+-----------+------------------------------------------------------------------+
|      20:25|                     DQS phase shift on falling edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0xa14**

*Width:* 32 Bit

*Desc:* Read delay settings, Rank 1 Register,  Channel 0,  lane 5

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                    IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       6:11|                      DQS phase shift on rising edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
|      16:18|                                                 IO delay in DCKs |
+-----------+------------------------------------------------------------------+
|      20:25|                     DQS phase shift on falling edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0xa18**

*Width:* 32 Bit

*Desc:* Read delay settings, Rank 2 Register,  Channel 0,  lane 5

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                    IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       6:11|                      DQS phase shift on rising edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
|      16:18|                                                 IO delay in DCKs |
+-----------+------------------------------------------------------------------+
|      20:25|                     DQS phase shift on falling edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0xa1c**

*Width:* 32 Bit

*Desc:*  Read delay settings, Rank 3 Register,  Channel 0,  lane 5

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                    IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       6:11|                      DQS phase shift on rising edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
|      16:18|                                                 IO delay in DCKs |
+-----------+------------------------------------------------------------------+
|      20:25|                     DQS phase shift on falling edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0xa20**

*Width:* 24 Bit

*Desc:*  Write delay settings, Rank 0 Register,  Channel 0,  lane 5

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                 DQ IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       8:13|                                DQS IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|      15:17|                                       DQS IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
|        20 |                                        DQ IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0xa24**

*Width:* 24 Bit

*Desc:*  Write delay settings, Rank 1 Register,  Channel 0,  lane 5

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                 DQ IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       8:13|                                DQS IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|      15:17|                                       DQS IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
|        20 |                                        DQ IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0xa28**

*Width:* 24 Bit

*Desc:*  Write delay settings, Rank 2 Register,  Channel 0,  lane 5

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                 DQ IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       8:13|                                DQS IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|      15:17|                                       DQS IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
|        20 |                                        DQ IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0xa2c**

*Width:* 24 Bit

*Desc:*  Write delay settings, Rank 3 Register,  Channel 0,  lane 5

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                 DQ IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       8:13|                                DQS IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|      15:17|                                       DQS IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
|        20 |                                        DQ IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0xc04**

*Width:* 64 Bit

*Desc:*  Lane training result Register,  Channel 0,  lane 6

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|       0:63|  Training result, each bit corresponds to one of the 64 settings |
|           |  of IO delay                                                     |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0xc10**

*Width:* 32 Bit

*Desc:*  Read delay settings, Rank 0 Register,  Channel 0,  lane 6

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                    IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       6:11|                      DQS phase shift on rising edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
|      16:18|                                                 IO delay in DCKs |
+-----------+------------------------------------------------------------------+
|      20:25|                     DQS phase shift on falling edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0xc14**

*Width:* 32 Bit

*Desc:* Read delay settings, Rank 1 Register,  Channel 0,  lane 6

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                    IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       6:11|                      DQS phase shift on rising edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
|      16:18|                                                 IO delay in DCKs |
+-----------+------------------------------------------------------------------+
|      20:25|                     DQS phase shift on falling edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
|        0:5|                                      Rank 0 CLK phase shift, low |
+-----------+------------------------------------------------------------------+
|       6:11|                                      Rank 1 CLK phase shift, low |
+-----------+------------------------------------------------------------------+
|      12:17|                                      Rank 2 CLK phase shift, low |
+-----------+------------------------------------------------------------------+
|      18:23|                                      Rank 3 CLK phase shift, low |
+-----------+------------------------------------------------------------------+
|      24:27|                             Rankmap to enable clock crossover on |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0xc18**

*Width:* 32 Bit

*Desc:* Read delay settings, Rank 2 Register,  Channel 0,  lane 6

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                    IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       6:11|                      DQS phase shift on rising edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
|      16:18|                                                 IO delay in DCKs |
+-----------+------------------------------------------------------------------+
|      20:25|                     DQS phase shift on falling edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
|         0 |                                     Rank 0 CLK phase shift, high |
+-----------+------------------------------------------------------------------+
|         1 |                                     Rank 1 CLK phase shift, high |
+-----------+------------------------------------------------------------------+
|         2 |                                     Rank 2 CLK phase shift, high |
+-----------+------------------------------------------------------------------+
|         3 |                                     Rank 3 CLK phase shift, high |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0xc1c**

*Width:* 32 Bit

*Desc:*  Read delay settings, Rank 3 Register,  Channel 0,  lane 6

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                    IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       6:11|                      DQS phase shift on rising edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
|      16:18|                                                 IO delay in DCKs |
+-----------+------------------------------------------------------------------+
|      20:25|                     DQS phase shift on falling edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0xc20**

*Width:* 24 Bit

*Desc:*  Write delay settings, Rank 0 Register,  Channel 0,  lane 6

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                 DQ IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       8:13|                                DQS IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|      15:17|                                       DQS IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
|        20 |                                        DQ IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0xc24**

*Width:* 24 Bit

*Desc:*  Write delay settings, Rank 1 Register,  Channel 0,  lane 6

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                 DQ IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       8:13|                                DQS IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|      15:17|                                       DQS IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
|        20 |                                        DQ IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0xc28**

*Width:* 24 Bit

*Desc:*  Write delay settings, Rank 2 Register,  Channel 0,  lane 6

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                 DQ IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       8:13|                                DQS IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|      15:17|                                       DQS IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
|        20 |                                        DQ IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0xc2c**

*Width:* 24 Bit

*Desc:*  Write delay settings, Rank 3 Register,  Channel 0,  lane 6

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                 DQ IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       8:13|                                DQS IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|      15:17|                                       DQS IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
|        20 |                                        DQ IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0xe04**

*Width:* 64 Bit

*Desc:*  Lane training result Register,  Channel 0,  lane 7

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|       0:63|  Training result, each bit corresponds to one of the 64 settings |
|           |  of IO delay                                                     |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0xe10**

*Width:* 32 Bit

*Desc:*  Read delay settings, Rank 0 Register,  Channel 0,  lane 7

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                    IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       6:11|                      DQS phase shift on rising edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
|      16:18|                                                 IO delay in DCKs |
+-----------+------------------------------------------------------------------+
|      20:25|                     DQS phase shift on falling edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0xe14**

*Width:* 32 Bit

*Desc:* Read delay settings, Rank 1 Register,  Channel 0,  lane 7

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                    IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       6:11|                      DQS phase shift on rising edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
|      16:18|                                                 IO delay in DCKs |
+-----------+------------------------------------------------------------------+
|      20:25|                     DQS phase shift on falling edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0xe18**

*Width:* 32 Bit

*Desc:* Read delay settings, Rank 2 Register,  Channel 0,  lane 7

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                    IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       6:11|                      DQS phase shift on rising edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
|      16:18|                                                 IO delay in DCKs |
+-----------+------------------------------------------------------------------+
|      20:25|                     DQS phase shift on falling edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0xe1c**

*Width:* 32 Bit

*Desc:*  Read delay settings, Rank 3 Register,  Channel 0,  lane 7

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                    IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       6:11|                      DQS phase shift on rising edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
|      16:18|                                                 IO delay in DCKs |
+-----------+------------------------------------------------------------------+
|      20:25|                     DQS phase shift on falling edge in 1/64 DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0xe20**

*Width:* 24 Bit

*Desc:*  Write delay settings, Rank 0 Register,  Channel 0,  lane 7

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                 DQ IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       8:13|                                DQS IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|      15:17|                                       DQS IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
|        20 |                                        DQ IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0xe24**

*Width:* 24 Bit

*Desc:*  Write delay settings, Rank 1 Register,  Channel 0,  lane 7

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                 DQ IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       8:13|                                DQS IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|      15:17|                                       DQS IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
|        20 |                                        DQ IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0xe28**

*Width:* 24 Bit

*Desc:*  Write delay settings, Rank 2 Register,  Channel 0,  lane 7

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                 DQ IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       8:13|                                DQS IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|      15:17|                                       DQS IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
|        20 |                                        DQ IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0xe2c**

*Width:* 24 Bit

*Desc:*  Write delay settings, Rank 3 Register,  Channel 0,  lane 7

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                 DQ IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|       8:13|                                DQS IO phase shift in 1/64th DCKs |
+-----------+------------------------------------------------------------------+
|      15:17|                                       DQS IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
|        20 |                                        DQ IO phase shift in DCKs |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x1810**

*Width:* 32 Bit

*Desc:*  COMP1 Register,  Channel 0

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|       9:11|                                                              ODT |
+-----------+------------------------------------------------------------------+
|      21:23|                                                     CLK drive up |
+-----------+------------------------------------------------------------------+
|      27:29|                                                    CTRL drive up |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x320c**

*Width:* 32 Bit

*Desc:*  Command crossover enable Register,  Channel 0

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:5|                                                   CLK phase, low |
+-----------+------------------------------------------------------------------+
|        12 |                                                  CLK phase, high |
+-----------+------------------------------------------------------------------+
|        14 |                                                  Enable hardware |
+-----------+------------------------------------------------------------------+
|        17 |                                                 Enable on slot 1 |
+-----------+------------------------------------------------------------------+
|        27 |                                                 Enable on slot 2 |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x3714**

*Width:* 32 Bit

*Desc:*  COMP2 Register

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|       0:31|                                                      COMP2 value |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x4000**

*Width:* 24 Bit

*Desc:*  TC_DBP - Timing of DDR - Bin Parameter Register,  Channel 0

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:3|                                                             tRCD |
+-----------+------------------------------------------------------------------+
|        4:7|                                                              tRP |
+-----------+------------------------------------------------------------------+
|       8:11|                                                              CAS |
+-----------+------------------------------------------------------------------+
|      12:15|                                                              CWL |
+-----------+------------------------------------------------------------------+
|      16:19|                                                             tRAS |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x4004**

*Width:* 32 Bit

*Desc:*  TC_RAP - Timing of DDR - Regular Access Parameters Register,  Channel 0

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:3|                                                             tRRD |
+-----------+------------------------------------------------------------------+
|        4:7|                                                             tRTP |
+-----------+------------------------------------------------------------------+
|       8:11|                                                              CKE |
+-----------+------------------------------------------------------------------+
|      12:15|                                                              WTR |
+-----------+------------------------------------------------------------------+
|      16:19|                                                             tFAW |
+-----------+------------------------------------------------------------------+
|      24:27|                                                              tWR |
+-----------+------------------------------------------------------------------+
|        29 |  Command 3-state options                                         |
|           |                                                                  |
|           | - 0: Drive when channel is active, tri-state when inactive,      |
|           |                                                                  |
|           | - 1: Always drive command bus                                    |
|           |                                                                  |
+-----------+------------------------------------------------------------------+
|      30:31|  CMD stretch,                                                    |
|           |                                                                  |
|           | - 00b: 1N,                                                       |
|           |                                                                  |
|           | - 10b: 2N,                                                       |
|           |                                                                  |
|           | - 11b: 3N                                                        |
|           |                                                                  |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x400c**

*Width:* 24 Bit

*Desc:*  OTHP ODT control Register,  Channel 0

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:3|                                                         tXPDLL ? |
+-----------+------------------------------------------------------------------+
|        5:7|                                                            tXP ? |
+-----------+------------------------------------------------------------------+
|      16:17|                                                      ODT stretch |
+-----------+------------------------------------------------------------------+
|      18:19|                                                      ODT stretch |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x401c**

*Width:* 16 Bit

*Desc:*  OTHP Workaround (Sandy Bridge only) Register,  Channel 0

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|      12:13|                                                      ODT stretch |
+-----------+------------------------------------------------------------------+
|      14:15|                                                      ODT stretch |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x4024**

*Width:* 32 Bit

*Desc:*  Rounttrip time Register,  Channel 0

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:7|                                                RTT Rank 0 DIMM 0 |
+-----------+------------------------------------------------------------------+
|       8:15|                                                RTT Rank 1 DIMM 0 |
+-----------+------------------------------------------------------------------+
|      16:23|                                                RTT Rank 0 DIMM 1 |
+-----------+------------------------------------------------------------------+
|      24:31|                                                RTT Rank 1 DIMM 1 |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x4028**

*Width:* 24 Bit

*Desc:*  SC_IO_LATENCY Register,  Channel 0

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:3|                                         IO latency Rank 0 DIMM 0 |
+-----------+------------------------------------------------------------------+
|        4:7|                                         IO latency Rank 1 DIMM 0 |
+-----------+------------------------------------------------------------------+
|       8:11|                                         IO latency Rank 0 DIMM 1 |
+-----------+------------------------------------------------------------------+
|      12:15|                                         IO latency Rank 1 DIMM 1 |
+-----------+------------------------------------------------------------------+
|      16:21|                                   Rount trip  - I/O compensation |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x4200**

*Width:* 32 Bit

*Desc:*  RAM training queue, address Register,  Channel 0,  queue idx 0

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|       0:15|                                                          Address |
+-----------+------------------------------------------------------------------+
|      20:22|                                                     Bank address |
+-----------+------------------------------------------------------------------+
|      24:25|                                                         Slotrank |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x4204**

*Width:* 32 Bit

*Desc:*  RAM training queue, address Register,  Channel 0,  queue idx 1

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|       0:15|                                                          Address |
+-----------+------------------------------------------------------------------+
|      20:22|                                                     Bank address |
+-----------+------------------------------------------------------------------+
|      24:25|                                                         Slotrank |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x4208**

*Width:* 32 Bit

*Desc:*  RAM training queue, address Register,  Channel 0,  queue idx 2

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|       0:15|                                                          Address |
+-----------+------------------------------------------------------------------+
|      20:22|                                                     Bank address |
+-----------+------------------------------------------------------------------+
|      24:25|                                                         Slotrank |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x420c**

*Width:* 32 Bit

*Desc:*  RAM training queue, address Register,  Channel 0,  queue idx 3

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|       0:15|                                                          Address |
+-----------+------------------------------------------------------------------+
|      20:22|                                                     Bank address |
+-----------+------------------------------------------------------------------+
|      24:25|                                                         Slotrank |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x4220**

*Width:* 8 Bit

*Desc:*  RAM training queue, command IO Register,  Channel 0,  queue idx 0

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|         0 |                                                             !RAS |
+-----------+------------------------------------------------------------------+
|         1 |                                                             !CAS |
+-----------+------------------------------------------------------------------+
|         2 |                                                              !WE |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x4224**

*Width:* 8 Bit

*Desc:*  RAM training queue, command IO Register,  Channel 0,  queue idx 1

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|         0 |                                                             !RAS |
+-----------+------------------------------------------------------------------+
|         1 |                                                             !CAS |
+-----------+------------------------------------------------------------------+
|         2 |                                                              !WE |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x4228**

*Width:* 8 Bit

*Desc:*  RAM training queue, command IO Register,  Channel 0,  queue idx 2

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|         0 |                                                             !RAS |
+-----------+------------------------------------------------------------------+
|         1 |                                                             !CAS |
+-----------+------------------------------------------------------------------+
|         2 |                                                              !WE |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x422c**

*Width:* 8 Bit

*Desc:*  RAM training queue, command IO Register,  Channel 0,  queue idx 3

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|         0 |                                                             !RAS |
+-----------+------------------------------------------------------------------+
|         1 |                                                             !CAS |
+-----------+------------------------------------------------------------------+
|         2 |                                                              !WE |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x4230**

*Width:* 32 Bit

*Desc:*  RAM training queue, cooldown Register,  Channel 0,  queue idx 0

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|      16:31|                               Clock cycles to wait after command |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x4234**

*Width:* 32 Bit

*Desc:*  RAM training queue, cooldown Register,  Channel 0,  queue idx 1

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|      16:31|                               Clock cycles to wait after command |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x4238**

*Width:* 32 Bit

*Desc:*  RAM training queue, cooldown Register,  Channel 0,  queue idx 2

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|      16:31|                               Clock cycles to wait after command |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x423c**

*Width:* 32 Bit

*Desc:*  RAM training queue, cooldown Register,  Channel 0,  queue idx 3

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|      16:31|                               Clock cycles to wait after command |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x4284**

*Width:* 24 Bit

*Desc:*  RAM training queue, cooldown Register,  Channel 0

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|         0 |                               Start executing DRAM command queue |
+-----------+------------------------------------------------------------------+
|      16:19|                              (Number of queued commands - 1) * 4 |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x4298**

*Width:* 40 Bit

*Desc:*  TC - Refresh parameters Register,  Channel 0

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|       0:15|             tREFI, average period between refresh in DCLK cycles |
+-----------+------------------------------------------------------------------+
|      16:24|  tRFC, Time of refresh, from beginning of refresh until next ACT |
|           |  or refresh is allowed in DCLK cycles                            |
+-----------+------------------------------------------------------------------+
|      25:32|  tREFIx9, Maximum time allowed between refreshes to a rank.      |
|           |  Should be programmed to 8.9 * tREFI / 1024                      |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x42a4**

*Width:* 32 Bit

*Desc:*  SRFTP Register,  Channel 0

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|       0:11|                                                           tXSDLL |
+-----------+------------------------------------------------------------------+
|      12:15|                                                       tXS_offset |
+-----------+------------------------------------------------------------------+
|      16:25|                                                          tZQOPER |
+-----------+------------------------------------------------------------------+
|      28:31|                                                             tMOD |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x4c20**

*Width:* 32 Bit

*Desc:*  Scheduler parameters Register

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|       0:31|                                             scheduler parameters |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x4cb0**

*Width:* 16 Bit

*Desc:*  PM - Power-down configuration, Broadcast Register

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:7|  PDWN_idle_counter, This defines the rank indle period in DCLK   |
|           |  cycles that causes power-down entrance. The minimum value       |
|           |  should be greater then or equal to the worst roundtrip time     |
|           |  plus burst length.                                              |
+-----------+------------------------------------------------------------------+
|       8:10|  PDWN_mode, selects the mode of power-down:                      |
|           |                                                                  |
|           | - 0x0: No power down,                                            |
|           |                                                                  |
|           | - 0x1: APD,                                                      |
|           |                                                                  |
|           | - 0x2: PPD,                                                      |
|           |                                                                  |
|           | - 0x3: APD+PPD,                                                  |
|           |                                                                  |
|           | - 0x4: Reserved,                                                 |
|           |                                                                  |
|           | - 0x5: Reserved,                                                 |
|           |                                                                  |
|           | - 0x6: PPD-DLLoff,                                               |
|           |                                                                  |
|           | - 0x7: APD+PPD+DLLof                                             |
|           |                                                                  |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x4e80**

*Width:* 32 Bit

*Desc:*  Power mode preset Register

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|       0:31|                                                Power mode preset |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x4e94**

*Width:* 16 Bit

*Desc:*  TC - Refresh parameters Register

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:7|  OREF_RI, Rank idle period that defines an oppertunity for       |
|           |  refresh                                                         |
+-----------+------------------------------------------------------------------+
|       8:11|  Refresh_HP_WM, tREFI count level that turns the refresh         |
|           |  priority to high                                                |
+-----------+------------------------------------------------------------------+
|      12:15|  Refresh_panic_WM, tREFI count level in which the refresh        |
|           |  priority is panic                                               |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x4e98**

*Width:* 40 Bit

*Desc:*  TC - Refresh parameters Register

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|       0:15|             tREFI, average period between refresh in DCLK cycles |
+-----------+------------------------------------------------------------------+
|      16:24|  tRFC, Time of refresh, from beginning of refresh until next ACT |
|           |  or refresh is allowed in DCLK cycles                            |
+-----------+------------------------------------------------------------------+
|      25:32|  tREFIx9, Maximum time allowed between refreshes to a rank.      |
|           |  Should be programmed to 8.9 * tREFI / 1024                      |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x5000**

*Width:* 8 Bit

*Desc:*  Global channel size control Register

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:1|  CH_A, defines the largest channel.                              |
|           |                                                                  |
|           | - 00b: Channel 0,                                                |
|           |                                                                  |
|           | - 01b: Channel 1,                                                |
|           |                                                                  |
|           | - 10b: Channel 2                                                 |
|           |                                                                  |
+-----------+------------------------------------------------------------------+
|        2:3|  CH_B, defines the mid-size channel.                             |
|           |                                                                  |
|           | - 00b: Channel 0,                                                |
|           |                                                                  |
|           | - 01b: Channel 1,                                                |
|           |                                                                  |
|           | - 10b: Channel 2                                                 |
|           |                                                                  |
+-----------+------------------------------------------------------------------+
|        2:3|  CH_C, defines the smallest channel.                             |
|           |                                                                  |
|           | - 00b: Channel 0,                                                |
|           |                                                                  |
|           | - 01b: Channel 1,                                                |
|           |                                                                  |
|           | - 10b: Channel 2, CH_C is 10 if only 2 channels are supported    |
|           |                                                                  |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x5004**

*Width:* 32 Bit

*Desc:*  Address Decode Register,  Channel 0

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:7|                                   DIMMA size in 256 MB multiples |
+-----------+------------------------------------------------------------------+
|        16 |  DIMM A select (DAS) Slot to DIMM mapping,                       |
|           |                                                                  |
|           | - 0: DIMMA, DIMMB,                                               |
|           |                                                                  |
|           | - 1: DIMMB, DIMMA                                                |
|           |                                                                  |
+-----------+------------------------------------------------------------------+
|        17 |                                           DIMM A number of ranks |
+-----------+------------------------------------------------------------------+
|        19 |                                       DIMM A DRAM width x8 / x16 |
+-----------+------------------------------------------------------------------+
|       8:15|                                  DIMM B size in 256 MB multiples |
+-----------+------------------------------------------------------------------+
|        18 |                                           DIMM B number of ranks |
+-----------+------------------------------------------------------------------+
|        20 |                                    DIMM B DRAM width in 8x / x16 |
+-----------+------------------------------------------------------------------+
|        21 |                                           Rank interleave enable |
+-----------+------------------------------------------------------------------+
|        22 |                                       Enhanced interleave enable |
+-----------+------------------------------------------------------------------+
|        26 |                                High order Rank interleave enable |
+-----------+------------------------------------------------------------------+
|      27:29|  High Order Rank interleave Address. Selects on of address bits  |
|           |  20-27 to use for high rank interleave                           |
+-----------+------------------------------------------------------------------+
|      24:25|  ECC,                                                            |
|           |                                                                  |
|           | - 00b: No ECC active,                                            |
|           |                                                                  |
|           | - 01b: ECC is active on IO,                                      |
|           |                                                                  |
|           | - 11b: ECC is active on both IO and ECC logic                    |
|           |                                                                  |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x5030**

*Width:* 8 Bit

*Desc:*  Global DDR3 control Register

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|         1 |                                                        DDR reset |
+-----------+------------------------------------------------------------------+
|         2 |                                                      DCLK enable |
+-----------+------------------------------------------------------------------+
|         5 |                                                         IO reset |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x5034**

*Width:* 32 Bit

*Desc:*  Version Register

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|       0:31|                                                      MRC version |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x5060**

*Width:* 16 Bit

*Desc:*  PM - Self refresh config Register

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|       0:15|  Idle_timer, The value is used when the SREF_enable field is set |
|           |  and defines the # of cycles that there should not be any        |
|           |  transaction in order to enter self-refresh.                     |
+-----------+------------------------------------------------------------------+
|        16 |  SR_Enable, enable self-refresh mechanism. Clear SREF_en and     |
|           |  SREF_exit first.                                                |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x5084**

*Width:* 24 Bit

*Desc:*  RCOMP status Register

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        16 |                                                             Busy |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x5090**

*Width:* 32 Bit

*Desc:*  ECC - Address compare for ECC error injection Register

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|       0:31|        Inject error when ECC_Inj_Addr_Compare[31:0] = ADDR[37:6] |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x5094**

*Width:* 32 Bit

*Desc:*  ECC - Address mask for ECC error injection Register

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|       0:31|                   Inject error when ECC_inj_Addr_Compare[31:0] = |
|           |                                                                  |
|           |  ADDR[37:6] && ECC_Inj_Addr_Mask[31:0]                           |
|           |                                                                  |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x5e00**

*Width:* 32 Bit

*Desc:*  MC_BIOS_REQ Register

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:7|                Selected multiplier: 100Mhz [7,12], 133Mhz [3,19] |
+-----------+------------------------------------------------------------------+
|         8 | - 1: 100Mhz reference clock (Ivy Bridge only)                    |
|           |                                                                  |
|           | - 0: 133Mhz reference clock                                      |
|           |                                                                  |
+-----------+------------------------------------------------------------------+
|        31 |                                                         PLL busy |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x5e04**

*Width:* 8 Bit

*Desc:*  MC_BIOS_DATA Register

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|        0:7|  Active multiplier:                                              |
|           |                                                                  |
|           | - 100Mhz [7,12],                                                 |
|           |                                                                  |
|           | - 133Mhz [3,19]                                                  |
|           |                                                                  |
+-----------+------------------------------------------------------------------+
```

**MCHBAR + 0x5f08**

*Width:* 16 Bit

*Desc:*  RCOMP control Register

```eval_rst
+-----------+------------------------------------------------------------------+
| Bit       | Description                                                      |
+===========+==================================================================+
|         8 |                                                      Force RCOMP |
+-----------+------------------------------------------------------------------+
```
