/* $NoKeywords:$ */
/**
 * @file
 *
 * Collectively assign unique filecodes for assert and debug to each source file.
 *
 * Publish values for decorated filenames, which can be used for
 * ASSERT and debug support using a preprocessor define like:
 * @n <tt> \#define FILECODE MY_C_FILENAME_FILECODE </tt> @n
 * This file serves as a reference for debugging to associate the code and filename.
 *
 * @xrefitem bom "File Content Label" "Release Content"
 * @e project:      AGESA
 * @e sub-project:  Include
 * @e \$Revision: 284995 $   @e \$Date: 2014-02-17 11:17:41 -0600 (Mon, 17 Feb 2014) $
 */
/*****************************************************************************
 *
 * Copyright (c) 2008 - 2014, Advanced Micro Devices, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Advanced Micro Devices, Inc. nor the names of
 *       its contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL ADVANCED MICRO DEVICES, INC. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ***************************************************************************/

#ifndef _FILECODE_H_
#define _FILECODE_H_

#define UNASSIGNED_FILE_FILECODE                                         (0xFFFF)

/// For debug use in any Platform's options C file.
/// Can be reused for platforms and image builds, since only one options file can be built.
#define PLATFORM_SPECIFIC_OPTIONS_FILECODE                               (0xBBBB)


#define PROC_GNB_COMMON_GNBLIBFEATURES_FILECODE                          (0xA001)
#define PROC_GNB_GNBINITATEARLY_FILECODE                                 (0xA017)
#define PROC_GNB_GNBINITATENV_FILECODE                                   (0xA020)
#define PROC_GNB_GNBINITATLATE_FILECODE                                  (0xA021)
#define PROC_GNB_GNBINITATMID_FILECODE                                   (0xA022)
#define PROC_GNB_GNBINITATPOST_FILECODE                                  (0xA023)
#define PROC_GNB_GNBINITATRESET_FILECODE                                 (0xA024)
#define PROC_GNB_MODULES_GNBCOMMONLIB_GNBLIB_FILECODE                    (0xA025)
#define PROC_GNB_MODULES_GNBCOMMONLIB_GNBLIBCPUACC_FILECODE              (0xA026)
#define PROC_GNB_MODULES_GNBCOMMONLIB_GNBLIBHEAP_FILECODE                (0xA027)
#define PROC_GNB_MODULES_GNBCOMMONLIB_GNBLIBIOACC_FILECODE               (0xA028)
#define PROC_GNB_MODULES_GNBCOMMONLIB_GNBLIBMEMACC_FILECODE              (0xA029)
#define PROC_GNB_MODULES_GNBCOMMONLIB_GNBLIBPCI_FILECODE                 (0xA02A)
#define PROC_GNB_MODULES_GNBCOMMONLIB_GNBLIBPCIACC_FILECODE              (0xA030)
#define PROC_GNB_MODULES_GNBGFXINITLIBV1_GFXCARDINFO_FILECODE            (0xA031)
#define PROC_GNB_MODULES_GNBGFXINITLIBV1_GFXENUMCONNECTORS_FILECODE      (0xA032)
#define PROC_GNB_MODULES_GNBGFXINITLIBV1_GFXPOWERPLAYTABLE_FILECODE      (0xA033)
#define PROC_GNB_MODULES_GNBNBINITLIBV1_GNBNBINITLIBV1_FILECODE          (0xA034)
#define PROC_GNB_MODULES_GNBPCIEALIBV1_PCIEALIB_FILECODE                 (0xA035)
#define PROC_GNB_MODULES_GNBPCIECONFIG_PCIECONFIGDATA_FILECODE           (0xA036)
#define PROC_GNB_MODULES_GNBPCIECONFIG_PCIECONFIGLIB_FILECODE            (0xA037)
#define PROC_GNB_MODULES_GNBPCIECONFIG_PCIEINPUTPARSER_FILECODE          (0xA038)
#define PROC_GNB_MODULES_GNBPCIECONFIG_PCIEMAPTOPOLOGY_FILECODE          (0xA039)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIEASPMBLACKLIST_FILECODE     (0xA03B)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIEASPMEXITLATENCY_FILECODE   (0xA03C)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIEPHYSERVICES_FILECODE       (0xA03D)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIEPIFSERVICES_FILECODE       (0xA03E)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIEPORTREGACC_FILECODE        (0xA03F)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIEPORTSERVICES_FILECODE      (0xA041)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIEPOWERMGMT_FILECODE         (0xA043)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIESILICONSERVICES_FILECODE   (0xA045)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIETIMER_FILECODE             (0xA046)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIETOPOLOGYSERVICES_FILECODE  (0xA047)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIEUTILITYLIB_FILECODE        (0xA048)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIEWRAPPERREGACC_FILECODE     (0xA049)
#define PROC_GNB_MODULES_GNBPCIETRAININGV1_PCIETRAINING_FILECODE         (0xA04A)
#define PROC_GNB_MODULES_GNBPCIETRAININGV1_PCIEWORKAROUNDS_FILECODE      (0xA04B)
#define PROC_GNB_MODULES_GNBPCIECOMMCLKCFG_PCIECOMMCLKCFG_FILECODE       (0xA04C)

#define PROC_GNB_MODULES_GNBGFXCONFIG_GFXCONFIGENV_FILECODE              (0xA08E)
#define PROC_GNB_MODULES_GNBGFXCONFIG_GFXCONFIGPOST_FILECODE             (0xA08F)
#define PROC_GNB_MODULES_GNBTABLE_GNBTABLE_FILECODE                      (0xA090)
#define PROC_GNB_MODULES_GNBGFXINITLIBV1_GNBGFXINITLIBV1_FILECODE        (0xA091)
#define PROC_GNB_MODULES_GNBINITTN_GFXENVINITTN_FILECODE                 (0xA092)
#define PROC_GNB_MODULES_GNBGFXCONFIG_GFXCONFIGLIB_FILECODE              (0xA093)
#define PROC_GNB_MODULES_GNBINITTN_GFXGMCINITTN_FILECODE                 (0xA094)
#define PROC_GNB_MODULES_GNBINITTN_GFXINTEGRATEDINFOTABLETN_FILECODE     (0xA095)
#define PROC_GNB_MODULES_GNBINITTN_GFXLIBTN_FILECODE                     (0xA096)
#define PROC_GNB_MODULES_GNBINITTN_GFXMIDINITTN_FILECODE                 (0xA097)
#define PROC_GNB_MODULES_GNBINITTN_GNBPOSTINITTN_FILECODE                (0xA098)
#define PROC_GNB_MODULES_GNBINITTN_GNBEARLYINITTN_FILECODE               (0xA09A)
#define PROC_GNB_MODULES_GNBINITTN_GNBENVINITTN_FILECODE                 (0xA09B)
#define PROC_GNB_MODULES_GNBINITTN_GNBFUSETABLETN_FILECODE               (0xA09C)
#define PROC_GNB_MODULES_GNBINITTN_GNBMIDINITTN_FILECODE                 (0xA09D)
#define PROC_GNB_MODULES_GNBINITTN_GFXPOSTINITTN_FILECODE                (0xA09E)
#define PROC_GNB_MODULES_GNBINITTN_GNBREGISTERACCTN_FILECODE             (0xA09F)
#define PROC_GNB_MODULES_GNBINITTN_PCIECONFIGTN_FILECODE                 (0xA0A0)
#define PROC_GNB_MODULES_GNBINITTN_PCIEEARLYINITTN_FILECODE              (0xA0A1)
#define PROC_GNB_MODULES_GNBINITTN_PCIEENVINITTN_FILECODE                (0xA0A2)
#define PROC_GNB_MODULES_GNBINITTN_PCIELIBTN_FILECODE                    (0xA0A3)
#define PROC_GNB_MODULES_GNBINITTN_PCIEMIDINITTN_FILECODE                (0xA0A4)
#define PROC_GNB_MODULES_GNBINITTN_PCIEPOSTINITTN_FILECODE               (0xA0A5)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV4_PCIEWRAPPERSERVICESV4_FILECODE (0xA0A6)
#define PROC_GNB_MODULES_GNBIOMMUIVRS_GNBIOMMUIVRS_FILECODE              (0xA0A7)
#define PROC_GNB_MODULES_GNBIVRSLIB_GNBIVRSLIB_FILECODE                  (0xA0A8)
#define PROC_GNB_MODULES_GNBNBINITLIBV4_GNBNBINITLIBV4_FILECODE          (0xA0A9)
#define PROC_GNB_MODULES_GNBFAMTRANSLATION_GNBPCIETRANSLATION_FILECODE   (0xA0AA)
#define PROC_GNB_MODULES_GNBINITTN_GNBIOMMUIVRSTN_FILECODE               (0xA0AB)

#define PROC_GNB_MODULES_GNBINITTN_PCIEPOWERGATETN_FILECODE              (0xA0B8)
#define PROC_GNB_MODULES_GNBINITTN_PCIEALIBTNFS1_FILECODE                (0xA0B9)
#define PROC_GNB_MODULES_GNBSBLIB_GNBSBPCIE_FILECODE                     (0xA0BA)
#define PROC_GNB_MODULES_GNBSBLIB_GNBSBLIB_FILECODE                      (0xA0BB)
#define PROC_GNB_MODULES_GNBSBIOMMULIB_GNBSBIOMMULIB_FILECODE            (0xA0BC)
#define PROC_GNB_MODULES_GNBCOMMONLIB_GNBTIMERLIB_FILECODE               (0xA0BD)
#define PROC_GNB_MODULES_GNBSSOCKETLIB_GNBSSOCKETLIB_FILECODE            (0xA0BF)
#define PROC_GNB_MODULES_GNBPCIECONFIG_GNBHANDLELIB_FILECODE             (0xA0C0)
#define PROC_GNB_MODULES_GNBINITTN_GNBBAPMCOEFFCALCTN_FILECODE           (0xA0C1)
#define PROC_GNB_MODULES_GNBPCIEASPM_PCIEASPM_FILECODE                   (0xA0C2)

#define PROC_GNB_MODULES_GNBPCIEINITLIBV5_PCIEASPMEXITLATENCYV5_FILECODE (0xA0C5)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV5_PCIEPIFSERVICESV5_FILECODE     (0xA0C6)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV5_PCIEPORTSERVICESV5_FILECODE    (0xA0C7)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV5_PCIEPOWERMGMTV5_FILECODE       (0xA0C8)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV5_PCIESILICONSERVICESV5_FILECODE (0xA0C9)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV5_PCIEWRAPPERSERVICESV5_FILECODE (0xA0CA)
#define PROC_GNB_MODULES_GNBNBINITLIBV5_GNBNBINITLIBV5_FILECODE          (0xA0CB)

#define PROC_GNB_MODULES_GNBFAMTRANSLATION_GNBTRANSLATION_FILECODE       (0xA0DB)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV4_PCIEPOWERMGMTV4_FILECODE       (0xA0DC)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV4_PCIEPORTSERVICESV4_FILECODE    (0xA0DD)

#define PROC_GNB_MODULES_GNBINITTN_PCIEALIBTNFM2_FILECODE                (0xA0DF)
#define PROC_GNB_MODULES_GNBGFXCONFIG_GFXCONFIGMID_FILECODE              (0xA0E0)

#define PROC_GNB_MODULES_GNBIOAPIC_GNBIOAPIC_FILECODE                    (0xA0EE)

#define PROC_GNB_MODULES_GNBPCIEMAXPAYLOAD_PCIEMAXPAYLOAD_FILECODE       (0xA0F4)
#define PROC_GNB_MODULES_GNBPCIECLKPM_PCIECLKPM_FILECODE                 (0xA0F5)

#define PROC_GNB_MODULES_GNBPCIEINITLIBV5_PCIETOPOLOGYSERVICESV5_FILECODE (0xA100)
#define PROC_GNB_MODULES_GNBPCIETRAININGV2_PCIETRAININGV2_FILECODE        (0xA101)
#define PROC_GNB_MODULES_GNBPCIETRAININGV2_PCIEWORKAROUNDSV2_FILECODE     (0xA102)

#define PROC_RECOVERY_GNB_GNBRECOVERY_FILECODE                           (0xAE01)
#define PROC_RECOVERY_GNB_NBINITRECOVERY_FILECODE                        (0xAE02)
#define PROC_GNB_GNBINITATS3SAVE_FILECODE                                (0xAE03)
#define PROC_GNB_MODULES_GNBSVIEW_GNBSVIEW_FILECODE                      (0xAE04)

#define PROC_GNB_MODULES_GNBINITKV_GFXENVINITKV_FILECODE                 (0xAE05)
#define PROC_GNB_MODULES_GNBINITKV_GFXINTEGRATEDINFOTABLEKV_FILECODE     (0xAE06)
#define PROC_GNB_MODULES_GNBINITKV_GFXMIDINITKV_FILECODE                 (0xAE07)
#define PROC_GNB_MODULES_GNBINITKV_GFXPOSTINITKV_FILECODE                (0xAE08)
#define PROC_GNB_MODULES_GNBINITKV_GNBEARLYINITKV_FILECODE               (0xAE09)
#define PROC_GNB_MODULES_GNBINITKV_GNBENVINITKV_FILECODE                 (0xAE0A)
#define PROC_GNB_MODULES_GNBINITKV_GNBIOMMUIVRSKV_FILECODE               (0xAE0B)
#define PROC_GNB_MODULES_GNBINITKV_GNBMIDINITKV_FILECODE                 (0xAE0C)
#define PROC_GNB_MODULES_GNBINITKV_GNBPOSTINITKV_FILECODE                (0xAE0D)
#define PROC_GNB_MODULES_GNBINITKV_GNBREGISTERACCKV_FILECODE             (0xAE0E)
#define PROC_GNB_MODULES_GNBINITKV_PCIECOMPLEXDATAKV_FILECODE            (0xAE0F)
#define PROC_GNB_MODULES_GNBINITKV_PCIECONFIGKV_FILECODE                 (0xAE10)
#define PROC_GNB_MODULES_GNBINITKV_PCIEEARLYINITKV_FILECODE              (0xAE11)
#define PROC_GNB_MODULES_GNBINITKV_PCIEENVINITKV_FILECODE                (0xAE12)
#define PROC_GNB_MODULES_GNBINITKV_PCIELIBKV_FILECODE                    (0xAE13)
#define PROC_GNB_MODULES_GNBINITKV_PCIEMIDINITKV_FILECODE                (0xAE14)
#define PROC_GNB_MODULES_GNBINITKV_PCIEPOSTINITKV_FILECODE               (0xAE15)
#define PROC_GNB_MODULES_GNBINITKV_GFXLIBKV_FILECODE                     (0xAE16)
#define PROC_GNB_MODULES_GNBIOMMUSCRATCH_GNBIOMMUSCRATCH_FILECODE        (0xAE18)
#define PROC_GNB_MODULES_GNBINITKV_GFXGMCINITKV_FILECODE                 (0xAE19)
#define PROC_GNB_MODULES_GNBSMULIBV7_GNBSMUINITLIBV7_FILECODE            (0xAE1A)
#define PROC_GNB_MODULES_GNBINITKV_GNBSMUBIOSTABLEKV_FILECODE            (0xAE1B)
#define PROC_GNB_MODULES_GNBINITKV_PCIEPOWERGATEKV_FILECODE              (0xAE1C)

#define PROC_GNB_MODULES_GNBPCIEALIBV2_PCIEALIBV2_FILECODE               (0xAE33)
#define PROC_GNB_MODULES_GNBINITKV_ALIBKVD_FILECODE                      (0xAE34)
#define PROC_GNB_MODULES_GNBINITKV_ALIBKVM_FILECODE                      (0xAE35)
#define PROC_GNB_MODULES_GNBINITKV_GNBFUSETABLEKV_FILECODE               (0xAE39)
#define PROC_GNB_MODULES_GNBURALIBV1_GNBURALIBV1_FILECODE                (0xAE3A)
#define PROC_GNB_MODULES_GNBINITKV_GNBURAKV_FILECODE                     (0xAE3B)
#define PROC_GNB_MODULES_GNBINITKV_GNBURATOKENMAPKV_FILECODE             (0xAE3C)
#define PROC_GNB_MODULES_GNBGFXINTTABLEV3_GFXLIBV3_FILECODE              (0xAE41)
#define PROC_GNB_MODULES_GNBGFXINTTABLEV3_GFXINTEGRATEDINFOTABLE_FILECODE (0xAE42)
#define PROC_GNB_MODULES_GNBGFXINTTABLEV3_GFXPWRPLAYTABLE_FILECODE       (0xAE43)
#define PROC_GNB_MODULES_GNBSCSLIBV1_GNBSCSLIBV1_FILECODE                (0xAE44)

// FCH
#define PROC_FCH_AZALIA_AZALIARESET_FILECODE                             (0xB001)
#define PROC_FCH_AZALIA_AZALIAENV_FILECODE                               (0xB002)
#define PROC_FCH_AZALIA_AZALIAMID_FILECODE                               (0xB003)
#define PROC_FCH_AZALIA_AZALIALATE_FILECODE                              (0xB004)
#define PROC_FCH_COMMON_ACPILIB_FILECODE                                 (0xB010)
#define PROC_FCH_COMMON_FCHLIB_FILECODE                                  (0xB011)
#define PROC_FCH_COMMON_FCHCOMMON_FILECODE                               (0xB012)
#define PROC_FCH_COMMON_FCHCOMMONSMM_FILECODE                            (0xB013)
#define PROC_FCH_COMMON_MEMLIB_FILECODE                                  (0xB014)
#define PROC_FCH_COMMON_PCILIB_FILECODE                                  (0xB015)
#define PROC_FCH_COMMON_FCHPELIB_FILECODE                                (0xB016)
#define PROC_FCH_GEC_GECRESET_FILECODE                                   (0xB020)
#define PROC_FCH_GEC_GECENV_FILECODE                                     (0xB021)
#define PROC_FCH_GEC_GECMID_FILECODE                                     (0xB022)
#define PROC_FCH_GEC_GECLATE_FILECODE                                    (0xB023)
#define PROC_FCH_GEC_FAMILY_HUDSON2_HUDSON2GECSERVICE_FILECODE           (0xB024)
#define PROC_FCH_GEC_FAMILY_HUDSON2_HUDSON2GECENVSERVICE_FILECODE        (0xB025)
#define PROC_FCH_HWACPI_HWACPIRESET_FILECODE                             (0xB030)
#define PROC_FCH_HWACPI_HWACPIENV_FILECODE                               (0xB031)
#define PROC_FCH_HWACPI_HWACPIMID_FILECODE                               (0xB032)
#define PROC_FCH_HWACPI_HWACPILATE_FILECODE                              (0xB033)
#define PROC_FCH_HWACPI_FAMILY_HUDSON2_HUDSON2HWACPIENVSERVICE_FILECODE  (0xB034)
#define PROC_FCH_HWACPI_FAMILY_HUDSON2_HUDSON2HWACPIMIDSERVICE_FILECODE  (0xB035)
#define PROC_FCH_HWACPI_FAMILY_HUDSON2_HUDSON2HWACPILATESERVICE_FILECODE (0xB036)
#define PROC_FCH_HWACPI_FAMILY_HUDSON2_HUDSON2SSSERVICE_FILECODE         (0xB037)
#define PROC_FCH_HWM_HWMRESET_FILECODE                                   (0xB050)
#define PROC_FCH_HWM_HWMENV_FILECODE                                     (0xB051)
#define PROC_FCH_HWM_HWMMID_FILECODE                                     (0xB052)
#define PROC_FCH_HWM_HWMLATE_FILECODE                                    (0xB053)
#define PROC_FCH_HWM_FAMILY_HUDSON2_HUDSON2HWMENVSERVICE_FILECODE        (0xB054)
#define PROC_FCH_HWM_FAMILY_HUDSON2_HUDSON2HWMMIDSERVICE_FILECODE        (0xB055)
#define PROC_FCH_HWM_FAMILY_HUDSON2_HUDSON2HWMLATESERVICE_FILECODE       (0xB056)
#define PROC_FCH_IMC_IMCENV_FILECODE                                     (0xB060)
#define PROC_FCH_IMC_IMCMID_FILECODE                                     (0xB061)
#define PROC_FCH_IMC_IMCLATE_FILECODE                                    (0xB062)
#define PROC_FCH_IMC_IMCLIB_FILECODE                                     (0xB063)
#define PROC_FCH_IMC_IMCRESET_FILECODE                                   (0xB064)
#define PROC_FCH_IMC_FCHECENV_FILECODE                                   (0xB065)
#define PROC_FCH_IMC_FCHECMID_FILECODE                                   (0xB066)
#define PROC_FCH_IMC_FCHECLATE_FILECODE                                  (0xB067)
#define PROC_FCH_IMC_FCHECRESET_FILECODE                                 (0xB068)
#define PROC_FCH_IMC_FAMILY_HUDSON2_HUDSON2IMCSERVICE_FILECODE           (0xB069)
#define PROC_FCH_IDE_IDEENV_FILECODE                                     (0xB06D)
#define PROC_FCH_IDE_IDEMID_FILECODE                                     (0xB06E)
#define PROC_FCH_IDE_IDELATE_FILECODE                                    (0xB06F)
#define PROC_FCH_INTERFACE_INITRESETDEF_FILECODE                         (0xB070)
#define PROC_FCH_INTERFACE_INITENVDEF_FILECODE                           (0xB071)
#define PROC_FCH_INTERFACE_FCHINITRESET_FILECODE                         (0xB072)
#define PROC_FCH_INTERFACE_FCHINITENV_FILECODE                           (0xB073)
#define PROC_FCH_INTERFACE_FCHINITLATE_FILECODE                          (0xB074)
#define PROC_FCH_INTERFACE_FCHINITMID_FILECODE                           (0xB075)
#define PROC_FCH_INTERFACE_FCHINITS3_FILECODE                            (0xB076)
#define PROC_FCH_INTERFACE_FCHTASKLAUNCHER_FILECODE                      (0xB077)
#define PROC_FCH_IR_IRENV_FILECODE                                       (0xB080)
#define PROC_FCH_IR_IRMID_FILECODE                                       (0xB081)
#define PROC_FCH_IR_IRLATE_FILECODE                                      (0xB082)
#define PROC_FCH_PCIB_PCIBRESET_FILECODE                                 (0xB090)
#define PROC_FCH_PCIB_PCIBENV_FILECODE                                   (0xB091)
#define PROC_FCH_PCIB_PCIBMID_FILECODE                                   (0xB092)
#define PROC_FCH_PCIB_PCIBLATE_FILECODE                                  (0xB093)
#define PROC_FCH_PCIE_ABRESET_FILECODE                                   (0xB0A0)
#define PROC_FCH_PCIE_ABENV_FILECODE                                     (0xB0A1)
#define PROC_FCH_PCIE_ABMID_FILECODE                                     (0xB0A2)
#define PROC_FCH_PCIE_ABLATE_FILECODE                                    (0xB0A3)
#define PROC_FCH_PCIE_GPPHP_FILECODE                                     (0xB0A4)
#define PROC_FCH_PCIE_GPPLIB_FILECODE                                    (0xB0A5)
#define PROC_FCH_PCIE_GPPRESET_FILECODE                                  (0xB0A6)
#define PROC_FCH_PCIE_GPPENV_FILECODE                                    (0xB0A7)
#define PROC_FCH_PCIE_GPPMID_FILECODE                                    (0xB0A8)
#define PROC_FCH_PCIE_GPPLATE_FILECODE                                   (0xB0A9)
#define PROC_FCH_PCIE_PCIERESET_FILECODE                                 (0xB0AA)
#define PROC_FCH_PCIE_PCIEENV_FILECODE                                   (0xB0AB)
#define PROC_FCH_PCIE_PCIEMID_FILECODE                                   (0xB0AC)
#define PROC_FCH_PCIE_PCIELATE_FILECODE                                  (0xB0AD)
#define PROC_FCH_PCIE_FAMILY_HUDSON2_HUDSON2ABRESETSERVICE_FILECODE      (0xB0AE)
#define PROC_FCH_PCIE_FAMILY_HUDSON2_HUDSON2ABENVSERVICE_FILECODE        (0xB0AF)
#define PROC_FCH_PCIE_FAMILY_HUDSON2_HUDSON2ABSERVICE_FILECODE           (0xB0B0)
#define PROC_FCH_PCIE_FAMILY_HUDSON2_HUDSON2GPPRESETSERVICE_FILECODE     (0xB0B1)
#define PROC_FCH_PCIE_FAMILY_HUDSON2_HUDSON2GPPSERVICE_FILECODE          (0xB0B2)
#define PROC_FCH_PCIE_FAMILY_HUDSON2_HUDSON2PCIEENVSERVICE_FILECODE      (0xB0B3)
#define PROC_FCH_PCIE_FAMILY_HUDSON2_HUDSON2PCIESERVICE_FILECODE         (0xB0B4)
#define PROC_FCH_SATA_AHCIENV_FILECODE                                   (0xB0C0)
#define PROC_FCH_SATA_AHCIMID_FILECODE                                   (0xB0C1)
#define PROC_FCH_SATA_AHCILATE_FILECODE                                  (0xB0C2)
#define PROC_FCH_SATA_AHCILIB_FILECODE                                   (0xB0C3)
#define PROC_FCH_SATA_IDE2AHCIENV_FILECODE                               (0xB0C4)
#define PROC_FCH_SATA_IDE2AHCIMID_FILECODE                               (0xB0C5)
#define PROC_FCH_SATA_IDE2AHCILATE_FILECODE                              (0xB0C6)
#define PROC_FCH_SATA_IDE2AHCILIB_FILECODE                               (0xB0C7)
#define PROC_FCH_SATA_RAIDENV_FILECODE                                   (0xB0C8)
#define PROC_FCH_SATA_RAIDMID_FILECODE                                   (0xB0C9)
#define PROC_FCH_SATA_RAIDLATE_FILECODE                                  (0xB0CA)
#define PROC_FCH_SATA_RAIDLIB_FILECODE                                   (0xB0CB)
#define PROC_FCH_SATA_SATAENV_FILECODE                                   (0xB0CC)
#define PROC_FCH_SATA_SATAENVLIB_FILECODE                                (0xB0CD)
#define PROC_FCH_SATA_SATAIDEENV_FILECODE                                (0xB0CE)
#define PROC_FCH_SATA_SATAIDEMID_FILECODE                                (0xB0CF)
#define PROC_FCH_SATA_SATAIDELATE_FILECODE                               (0xB0D0)
#define PROC_FCH_SATA_SATAIDELIB_FILECODE                                (0xB0D1)
#define PROC_FCH_SATA_SATAMID_FILECODE                                   (0xB0D2)
#define PROC_FCH_SATA_SATALATE_FILECODE                                  (0xB0D3)
#define PROC_FCH_SATA_SATALIB_FILECODE                                   (0xB0D4)
#define PROC_FCH_SATA_SATARESET_FILECODE                                 (0xB0D5)
#define PROC_FCH_SATA_FAMILY_HUDSON2_HUDSON2SATARESETSERVICE_FILECODE    (0xB0D6)
#define PROC_FCH_SATA_FAMILY_HUDSON2_HUDSON2SATAENVSERVICE_FILECODE      (0xB0D7)
#define PROC_FCH_SATA_FAMILY_HUDSON2_HUDSON2SATASERVICE_FILECODE         (0xB0D8)
#define PROC_FCH_SD_SDENV_FILECODE                                       (0xB0E0)
#define PROC_FCH_SD_SDMID_FILECODE                                       (0xB0E1)
#define PROC_FCH_SD_SDLATE_FILECODE                                      (0xB0E2)
#define PROC_FCH_SD_FAMILY_HUDSON2_HUDSON2SDSERVICE_FILECODE             (0xB0E3)
#define PROC_FCH_SD_FAMILY_HUDSON2_HUDSON2SDRESETSERVICE_FILECODE        (0xB0E4)
#define PROC_FCH_SD_FAMILY_HUDSON2_HUDSON2SDENVSERVICE_FILECODE          (0xB0E5)
#define PROC_FCH_SPI_LPCRESET_FILECODE                                   (0xB0F0)
#define PROC_FCH_SPI_LPCENV_FILECODE                                     (0xB0F1)
#define PROC_FCH_SPI_LPCMID_FILECODE                                     (0xB0F2)
#define PROC_FCH_SPI_LPCLATE_FILECODE                                    (0xB0F3)
#define PROC_FCH_SPI_SPIRESET_FILECODE                                   (0xB0F4)
#define PROC_FCH_SPI_SPIENV_FILECODE                                     (0xB0F5)
#define PROC_FCH_SPI_SPIMID_FILECODE                                     (0xB0F6)
#define PROC_FCH_SPI_SPILATE_FILECODE                                    (0xB0F7)
#define PROC_FCH_SPI_FAMILY_HUDSON2_HUDSON2LPCENVSERVICE_FILECODE        (0xB0F8)
#define PROC_FCH_SPI_FAMILY_HUDSON2_HUDSON2LPCRESETSERVICE_FILECODE      (0xB0F9)
#define PROC_FCH_USB_EHCIRESET_FILECODE                                  (0xB100)
#define PROC_FCH_USB_EHCIENV_FILECODE                                    (0xB101)
#define PROC_FCH_USB_EHCIMID_FILECODE                                    (0xB102)
#define PROC_FCH_USB_EHCILATE_FILECODE                                   (0xB103)
#define PROC_FCH_USB_OHCIRESET_FILECODE                                  (0xB104)
#define PROC_FCH_USB_OHCIENV_FILECODE                                    (0xB105)
#define PROC_FCH_USB_OHCIMID_FILECODE                                    (0xB106)
#define PROC_FCH_USB_OHCILATE_FILECODE                                   (0xB107)
#define PROC_FCH_USB_USBRESET_FILECODE                                   (0xB108)
#define PROC_FCH_USB_USBENV_FILECODE                                     (0xB109)
#define PROC_FCH_USB_USBMID_FILECODE                                     (0xB10A)
#define PROC_FCH_USB_USBLATE_FILECODE                                    (0xB10B)
#define PROC_FCH_USB_XHCIRESET_FILECODE                                  (0xB10C)
#define PROC_FCH_USB_XHCIENV_FILECODE                                    (0xB10D)
#define PROC_FCH_USB_XHCIMID_FILECODE                                    (0xB10E)
#define PROC_FCH_USB_XHCILATE_FILECODE                                   (0xB10F)
#define PROC_FCH_USB_FAMILY_HUDSON2_HUDSON2EHCIENVSERVICE_FILECODE       (0xB110)
#define PROC_FCH_USB_FAMILY_HUDSON2_HUDSON2EHCIMIDSERVICE_FILECODE       (0xB111)
#define PROC_FCH_USB_FAMILY_HUDSON2_HUDSON2EHCILATESERVICE_FILECODE      (0xB112)
#define PROC_FCH_USB_FAMILY_HUDSON2_HUDSON2OHCIENVSERVICE_FILECODE       (0xB113)
#define PROC_FCH_USB_FAMILY_HUDSON2_HUDSON2OHCIMIDSERVICE_FILECODE       (0xB114)
#define PROC_FCH_USB_FAMILY_HUDSON2_HUDSON2OHCILATESERVICE_FILECODE      (0xB115)
#define PROC_FCH_USB_FAMILY_HUDSON2_HUDSON2XHCIRESETSERVICE_FILECODE     (0xB116)
#define PROC_FCH_USB_FAMILY_HUDSON2_HUDSON2XHCIENVSERVICE_FILECODE       (0xB117)
#define PROC_FCH_USB_FAMILY_HUDSON2_HUDSON2XHCIMIDSERVICE_FILECODE       (0xB118)
#define PROC_FCH_USB_FAMILY_HUDSON2_HUDSON2XHCILATESERVICE_FILECODE      (0xB119)
#define PROC_FCH_USB_XHCIRECOVERY_FILECODE                               (0xB12E)
#define PROC_FCH_PCIE_GPPPORTINIT_FILECODE                               (0xB12F)
#define PROC_FCH_SPI_FAMILY_YUBA_YUBALPCRESETSERVICE_FILECODE            (0xB160)
#define UEFI_DXE_FCHDXE_FCHDXE_FILECODE                                  (0xB200)
#define UEFI_DXE_FCHDXE_USBOC_FILECODE                                   (0xB201)
#define UEFI_DXE_FCHDXEAUX_DXEGPIO_FILECODE                              (0xB202)
#define UEFI_DXE_FCHDXEAUX_DXEGPIOREAD_FILECODE                          (0xB203)
#define UEFI_DXE_FCHDXELPCCLKRUN_FCHDXELPCCLKRUN_FILECODE                (0xB204)
#define UEFI_DXE_AMDFCHWHEA_AMDFCHWHEA_FILECODE                          (0xB210)
#define UEFI_DXE_AMDFCHWHEA_AMDFCHWHEAEINJ_FILECODE                      (0xB211)
#define UEFI_DXE_AMDFCHWHEA_AMDFCHWHEAHEST_FILECODE                      (0xB212)
#define UEFI_DXE_FCHDXEAUX_DXEDISUSBPORT_FILECODE                        (0xB213)
#define UEFI_DXE_FCHDXEAUX_DXEBOOTTIMER_FILECODE                         (0xB214)
#define UEFI_DXE_FCHDXEAUX_DXEESATAPORT_FILECODE                         (0xB215)
#define UEFI_DXE_AMDFCHHWM_AMDFCHHWM_FILECODE                            (0xB216)
#define UEFI_DXE_AMDIGPUVGACONTROLDXE_AMDIGPUVGACONTROLDXE_FILECODE      (0xB218)
#define UEFI_DXE_CF9RESET_CF9RESET_FILECODE                              (0xB220)
#define UEFI_DXE_CF9RESET_IA32_IA32CF9RESET_FILECODE                     (0xB221)
#define UEFI_DXE_CF9RESET_X64_X64CF9RESET_FILECODE                       (0xB222)
#define UEFI_DXE_FCHDXEMMIO_FCHDXEMMIO_FILECODE                          (0xB223)
#define UEFI_DXE_LEGACYINTERRUPT_LEGACYINTERRUPT_FILECODE                (0xB230)
#define UEFI_DXE_FCHACPICS_FCHACPICS_FILECODE                            (0xB231)
#define UEFI_DXE_FCHACPICS_FCHACPICSAML_FILECODE                         (0xB232)
#define UEFI_DXE_FCHACPICS_FCHACPICSCONTROL_FILECODE                     (0xB233)
#define UEFI_DXE_FCHACPICS_FUNCTIONS_POWERBUTTON_POWERBUTTON_FILECODE    (0xB234)
#define UEFI_DXE_FCHACPICS_FUNCTIONS_SMBUSNFC_SMBUSNFC_FILECODE          (0xB235)
#define UEFI_DXE_SMMCONTROL_SMMCONTROL_FILECODE                          (0xB240)
#define UEFI_SMM_FCHSMMLIB_FCHDXECOMMON_FILECODE                         (0xB250)
#define UEFI_SMM_FCHSMMLIB_FCHSMMLIB_FILECODE                            (0xB251)
#define UEFI_DXE_FCHDXELIB_FCHDXELIB_FILECODE                            (0xB252)
#define UEFI_PEI_FCHPEI_FCHPEI_FILECODE                                  (0xB260)
#define UEFI_PEI_FCHPEI_FCHRESET_FILECODE                                (0xB261)
#define UEFI_PEI_FCHPEI_FCHSTALL_FILECODE                                (0xB262)
#define UEFI_DXE_FCHDXEAUX_FCHDXEAUX_FILECODE                            (0xB263)
#define UEFI_PEI_FCHPEIAUX_FCHPEIAUX_FILECODE                            (0xB264)
#define UEFI_PEI_FCHPEILIB_FCHPEILIB_FILECODE                            (0xB265)
#define UEFI_PEI_FCHPEILIB_LIBAMDPEI_FILECODE                            (0xB266)
#define UEFI_PEI_FCHPEIAUX_PEIGPIO_FILECODE                              (0xB267)
#define UEFI_PEI_FCHPEIAUX_PEIGPIOREAD_FILECODE                          (0xB268)
#define UEFI_PEI_FCHPEIAUX_PEIDISUSBPORT_FILECODE                        (0xB269)
#define UEFI_PEI_FCHPEIAUX_PEIBOOTTIMER_FILECODE                         (0xB26A)
#define UEFI_PEI_FCHPEIAUX_PEIOSCOUTCLOCK_FILECODE                       (0xB26B)
#define UEFI_PEI_FCHPEI_FCHEHCIRECOVERY_FILECODE                         (0xB280)
#define UEFI_PEI_FCHPEI_FCHSATARECOVERY_FILECODE                         (0xB281)
#define UEFI_PEI_FCHPEI_FCHXHCIRECOVERY_FILECODE                         (0xB282)
#define UEFI_PEI_FCHPEI_FCHGPPRECOVERY_FILECODE                          (0xB283)
#define UEFI_PEI_SMBUS_SMBUS_FILECODE                                    (0xB28A)
#define UEFI_SMM_FCHSMM_FCHSMM_FILECODE                                  (0xB290)
#define UEFI_SMM_FCHSMMCOMPLEMENT_SDIOPOWER_SDIOPOWER_FILECODE                   (0xB291)
#define UEFI_SMM_FCHSMMCOMPLEMENT_USB3PORTPROTECTWA_USB3PORTPROTECTWA_FILECODE   (0xB292)
#define UEFI_SMM_FCHSMM_GPESMI_FILECODE                                  (0xB293)
#define UEFI_SMM_FCHSMM_IOTRAPSMI_FILECODE                               (0xB294)
#define UEFI_SMM_FCHSMM_MISCSMI_FILECODE                                 (0xB295)
#define UEFI_SMM_FCHSMM_PERIODICTIMERSMI_FILECODE                        (0xB296)
#define UEFI_SMM_FCHSMM_POWERBUTTONSMI_FILECODE                          (0xB297)
#define UEFI_SMM_FCHSMM_SWSMI_FILECODE                                   (0xB298)
#define UEFI_SMM_FCHSMM_SXSMI_FILECODE                                   (0xB299)
#define UEFI_SMM_FCHSMMCOMPLEMENT_IMCCONTROL_IMCCONTROL_FILECODE         (0xB29A)
#define UEFI_SMM_FCHSMMCOMPLEMENT_IMCCONTROL_IMCCONTROLLIB_FILECODE      (0xB29B)
#define UEFI_SMM_FCHSMMCOMPLEMENT_USB3PORTPROTECTWA_LIBAMDSMMLIB_FILECODE        (0xB29C)
#define UEFI_SMM_FCHSMMCOMPLEMENT_FCHPCIEWAKEWA_FCHPCIEWAKEWA_FILECODE        (0xB29D)
#define UEFI_SMM_FCHSMMCOMPLEMENT_SDCLKDRIVINGLOWWA_SDCLKDRIVINGLOWWA_FILECODE   (0xB29E)
#define UEFI_SMM_FCHSMMCOMPLEMENT_FCHSDVOLTAGESWITCH_FCHSDVOLTAGESWITCH_FILECODE (0xB29F)
#define UEFI_DXE_SMBUS_SMBUSLIGHT_FILECODE                               (0xB2A0)
#define UEFI_SMM_FCHSMMCOMPLEMENT_FCHIMCSPIWA_FCHIMCSPIWA_FILECODE       (0xB2A1)
#define UEFI_SMM_FCHSMMCOMPLEMENT_FCHXHCD3WA_FCHXHCD3WA_FILECODE         (0xB2A2)
#define UEFI_SMM_FCHSMMDISPATCHER_FCHSMMDISPATCHER_FILECODE              (0xB2B0)
#define UEFI_SMM_FCHSMMDISPATCHER_FCHSMMGPEDISPATCHER_FCHSMMGPEDISPATCHER_FILECODE        (0xB2B1)
#define UEFI_SMM_FCHSMMDISPATCHER_FCHSMMIOTRAPDISPATCHER_FCHSMMIOTRAPDISPATCHER_FILECODE  (0xB2B2)
#define UEFI_SMM_FCHSMMDISPATCHER_FCHSMMMISCDISPATCHER_FCHSMMMISCDISPATCHER_FILECODE      (0xB2B3)
#define UEFI_SMM_FCHSMMDISPATCHER_FCHSMMPERIODICALDISPATCHER_FCHSMMPERIODICALDISPATCHER_FILECODE (0xB2B4)
#define UEFI_SMM_FCHSMMDISPATCHER_FCHSMMPWRBTNDISPATCHER_FCHSMMPWRBTNDISPATCHER_FILECODE  (0xB2B5)
#define UEFI_SMM_FCHSMMDISPATCHER_FCHSMMSWDISPATCHER_FCHSMMSWDISPATCHER_FILECODE          (0xB2B6)
#define UEFI_SMM_FCHSMMDISPATCHER_FCHSMMSXDISPATCHER_FCHSMMSXDISPATCHER_FILECODE          (0xB2B7)
#define UEFI_SMM_FCHSMMDISPATCHER_FCHSMMUSBDISPATCHER_FCHSMMUSBDISPATCHER_FILECODE        (0xB2B8)
#define PROC_FCH_PCIE_GPPALLINONE_FILECODE                               (0xB2C0)
#define UEFI_SMM_MEMSMMLIB_MEMSMMLIB_FILECODE                             (0xB2C1)
#define UEFI_SMM_MEMSMMLIB_KV_DRAMMAPKV_FILECODE                          (0xB2C3)

#define LIB_AMDLIB_FILECODE                                              (0xC001)

#define LEGACY_PROC_AGESACALLOUTS_FILECODE                               (0xC010)
#define LEGACY_PROC_HOBTRANSFER_FILECODE                                 (0xC011)
#define LEGACY_PROC_DISPATCHER_FILECODE                                  (0xC012)

#define UEFI_DXE_AMDAGESADXEDRIVER_AMDAGESADXEDRIVER_FILECODE            (0xC120)

#define UEFI_PEI_AMDINITPOSTPEIM_AMDINITPOSTPEIM_FILECODE                (0xC140)
#define UEFI_PEI_AMDPROCESSORINITPEIM_AMDPROCESSORINITPEIM_FILECODE      (0xC141)
#define UEFI_PEI_AMDRESETMANAGER_AMDRESETMANAGER_FILECODE                (0xC142)
#define UEFI_PROC_COMMON_HOBTRANSFERUEFI_FILECODE                        (0xC160)
#define UEFI_PROC_DXE_HOBTRANSFERUEFIDXE_FILECODE                        (0xC161)
#define UEFI_PROC_PEI_HOBTRANSFERUEFIPEI_FILECODE                        (0xC162)

#define PROC_COMMON_AMDINITEARLY_FILECODE                                (0xC020)
#define PROC_COMMON_AMDINITENV_FILECODE                                  (0xC021)
#define PROC_COMMON_AMDINITLATE_FILECODE                                 (0xC022)
#define PROC_COMMON_AMDINITMID_FILECODE                                  (0xC023)
#define PROC_COMMON_AMDINITPOST_FILECODE                                 (0xC024)
#define PROC_COMMON_AMDINITRECOVERY_FILECODE                             (0xC025)
#define PROC_COMMON_AMDINITRESET_FILECODE                                (0xC026)
#define PROC_COMMON_AMDINITRESUME_FILECODE                               (0xC027)
#define PROC_COMMON_AMDS3LATERESTORE_FILECODE                            (0xC028)
#define PROC_COMMON_AMDS3SAVE_FILECODE                                   (0xC029)
#define PROC_COMMON_AMDLATERUNAPTASK_FILECODE                            (0xC02A)
#define PROC_COMMON_AMDS3FINALRESTORE_FILECODE                           (0xC02B)

#define PROC_COMMON_COMMONRETURNS_FILECODE                               (0xC0C0)
#define PROC_COMMON_CREATESTRUCT_FILECODE                                (0xC0D0)
#define PROC_COMMON_COMMONINITS_FILECODE                                 (0xC0F0)
#define PROC_COMMON_S3RESTORESTATE_FILECODE                              (0xC0F8)
#define PROC_COMMON_S3SAVESTATE_FILECODE                                 (0xC0F9)

#define PROC_CPU_CPUAPICUTILITIES_FILECODE                               (0xC401)
#define PROC_CPU_TABLE_FILECODE                                          (0xC403)
#define PROC_CPU_CPUEARLYINIT_FILECODE                                   (0xC405)
#define PROC_CPU_CPUEVENTLOG_FILECODE                                    (0xC406)
#define PROC_CPU_CPUFAMILYTRANSLATION_FILECODE                           (0xC407)
#define PROC_CPU_CPUGENERALSERVICES_FILECODE                             (0xC408)
#define PROC_CPU_CPULATEINIT_FILECODE                                    (0xC40A)
#define PROC_CPU_CPUMICROCODEPATCH_FILECODE                              (0xC40B)
#define PROC_CPU_CPUWARMRESET_FILECODE                                   (0xC40C)
#define PROC_CPU_HEAPMANAGER_FILECODE                                    (0xC40D)
#define PROC_CPU_CPUBIST_FILECODE                                        (0xC40E)
#define PROC_CPU_MMIOMAPMANAGER_FILECODE                                 (0xC40F)

#define PROC_CPU_CPUPOSTINIT_FILECODE                                    (0xC420)
#define PROC_CPU_CPUPOWERMGMT_FILECODE                                   (0xC430)
#define PROC_CPU_CPUPOWERMGMTMULTISOCKET_FILECODE                        (0xC431)
#define PROC_CPU_CPUPOWERMGMTSINGLESOCKET_FILECODE                       (0xC432)
#define PROC_CPU_S3_FILECODE                                             (0xC460)

// Family 15h
#define PROC_CPU_FAMILY_0X15_CPUCOMMONF15UTILITIES_FILECODE              (0xCB01)
#define PROC_CPU_FAMILY_0X15_CPUF15BRANDID_FILECODE                      (0xCB02)
#define PROC_CPU_FAMILY_0X15_CPUF15CACHEDEFAULTS_FILECODE                (0xCB03)
#define PROC_CPU_FAMILY_0X15_CPUF15DMI_FILECODE                          (0xCB04)
#define PROC_CPU_FAMILY_0X15_CPUF15MSRTABLES_FILECODE                    (0xCB05)
#define PROC_CPU_FAMILY_0X15_CPUF15PCITABLES_FILECODE                    (0xCB06)
#define PROC_CPU_FAMILY_0X15_CPUF15POWERCHECK_FILECODE                   (0xCB07)
#define PROC_CPU_FAMILY_0X15_CPUF15UTILITIES_FILECODE                    (0xCB08)
#define PROC_CPU_FAMILY_0X15_CPUF15WHEAINITDATATABLES_FILECODE           (0xCB09)
#define PROC_CPU_FAMILY_0X15_CPUF15APM_FILECODE                          (0xCB0A)
#define PROC_CPU_FAMILY_0X15_CPUF15CRAT_FILECODE                         (0xCB0B)
#define PROC_CPU_FAMILY_0X15_CPUF15MMIOMAP_FILECODE                      (0xCB0C)
#define PROC_CPU_FAMILY_0X15_CPUF15PREFETCHMODE_FILECODE                 (0xCB0D)

#define PROC_CPU_FAMILY_0X15_TN_CPUF15TNCOREAFTERRESET_FILECODE          (0xCB50)
#define PROC_CPU_FAMILY_0X15_TN_CPUF15TNDMI_FILECODE                     (0xCB51)
#define PROC_CPU_FAMILY_0X15_TN_CPUF15TNNBAFTERRESET_FILECODE            (0xCB52)
#define PROC_CPU_FAMILY_0X15_TN_CPUF15TNPSTATE_FILECODE                  (0xCB53)
#define PROC_CPU_FAMILY_0X15_TN_F15TNLOGICALIDTABLES_FILECODE            (0xCB54)
#define PROC_CPU_FAMILY_0X15_TN_F15TNMICROCODEPATCHTABLES_FILECODE       (0xCB55)
#define PROC_CPU_FAMILY_0X15_TN_F15TNMSRTABLES_FILECODE                  (0xCB56)
#define PROC_CPU_FAMILY_0X15_TN_F15TNSHAREDMSRTABLE_FILECODE             (0xCB57)
#define PROC_CPU_FAMILY_0X15_TN_F15TNEQUIVALENCETABLE_FILECODE           (0xCB58)
#define PROC_CPU_FAMILY_0X15_TN_F15TNPCITABLES_FILECODE                  (0xCB59)
#define PROC_CPU_FAMILY_0X15_TN_F15TNPOWERMGMTSYSTEMTABLES_FILECODE      (0xCB5A)
#define PROC_CPU_FAMILY_0X15_TN_F15TNPOWERPLANE_FILECODE                 (0xCB5B)
#define PROC_CPU_FAMILY_0X15_TN_F15TNUTILITIES_FILECODE                  (0xCB5C)
#define PROC_CPU_FAMILY_0X15_TN_F15TNC6STATE_FILECODE                    (0xCB5D)
#define PROC_CPU_FAMILY_0X15_TN_F15TNCPB_FILECODE                        (0xCB5E)
#define PROC_CPU_FAMILY_0X15_TN_F15TNIOCSTATE_FILECODE                   (0xCB5F)
#define PROC_CPU_FAMILY_0X15_TN_CPUF15TNCACHEFLUSHONHALT_FILECODE        (0xCB60)
#define PROC_CPU_FAMILY_0X15_TN_F15TNINITEARLYTABLE_FILECODE             (0xCB62)
#define PROC_CPU_FAMILY_0X15_TN_F15TNEARLYSAMPLES_FILECODE               (0xCB63)
#define PROC_CPU_FAMILY_0X15_TN_CPUF15TNPOWERCHECK_FILECODE              (0xCB64)
#define PROC_CPU_FAMILY_0X15_TN_CPUF15TNPSI_FILECODE                     (0xCB65)
#define PROC_CPU_FAMILY_0X15_TN_CPUF15TNHTC_FILECODE                     (0xCB66)

#define PROC_CPU_FAMILY_0X15_KV_CPUF15KVCOREAFTERRESET_FILECODE          (0xCBE0)
#define PROC_CPU_FAMILY_0X15_KV_CPUF15KVDMI_FILECODE                     (0xCBE1)
#define PROC_CPU_FAMILY_0X15_KV_CPUF15KVNBAFTERRESET_FILECODE            (0xCBE2)
#define PROC_CPU_FAMILY_0X15_KV_CPUF15KVPSTATE_FILECODE                  (0xCBE3)
#define PROC_CPU_FAMILY_0X15_KV_CPUF15KVLOGICALIDTABLES_FILECODE         (0xCBE4)
#define PROC_CPU_FAMILY_0X15_KV_CPUF15KVMICROCODEPATCHTABLES_FILECODE    (0xCBE5)
#define PROC_CPU_FAMILY_0X15_KV_CPUF15KVMSRTABLES_FILECODE               (0xCBE6)
#define PROC_CPU_FAMILY_0X15_KV_CPUF15KVSHAREDMSRTABLE_FILECODE          (0xCBE7)
#define PROC_CPU_FAMILY_0X15_KV_CPUF15KVEQUIVALENCETABLE_FILECODE        (0xCBE8)
#define PROC_CPU_FAMILY_0X15_KV_CPUF15KVPCITABLES_FILECODE               (0xCBE9)
#define PROC_CPU_FAMILY_0X15_KV_CPUF15KVPOWERMGMTSYSTEMTABLES_FILECODE   (0xCBEA)
#define PROC_CPU_FAMILY_0X15_KV_CPUF15KVBRANDID_FILECODE                 (0xCBEB)
#define PROC_CPU_FAMILY_0X15_KV_CPUF15KVUTILITIES_FILECODE               (0xCBEC)
#define PROC_CPU_FAMILY_0X15_KV_CPUF15KVC6STATE_FILECODE                 (0xCBED)
#define PROC_CPU_FAMILY_0X15_KV_CPUF15KVCPB_FILECODE                     (0xCBEE)
#define PROC_CPU_FAMILY_0X15_KV_CPUF15KVIOCSTATE_FILECODE                (0xCBEF)
#define PROC_CPU_FAMILY_0X15_KV_CPUF15KVCACHEFLUSHONHALT_FILECODE        (0xCBF0)
#define PROC_CPU_FAMILY_0X15_KV_CPUF15KVHTC_FILECODE                     (0xCBF1)
#define PROC_CPU_FAMILY_0X15_KV_CPUF15KVINITEARLYTABLE_FILECODE          (0xCBF2)
#define PROC_CPU_FAMILY_0X15_KV_CPUF15KVEARLYSAMPLES_FILECODE            (0xCBF3)
#define PROC_CPU_FAMILY_0X15_KV_CPUF15KVPOWERCHECK_FILECODE              (0xCBF4)
#define PROC_CPU_FAMILY_0X15_KV_CPUF15KVPSI_FILECODE                     (0xCBF5)
#define PROC_CPU_FAMILY_0X15_KV_CPUF15KVSCS_FILECODE                     (0xCBF6)
#define PROC_CPU_FAMILY_0X15_KV_CPUF15KVCC6EXITCONTROL_FILECODE          (0xCBF7)

#define PROC_CPU_FEATURE_CPUCACHEFLUSHONHALT_FILECODE                    (0xDC01)
#define PROC_CPU_FEATURE_CPUCACHEINIT_FILECODE                           (0xDC02)
#define PROC_CPU_FEATURE_CPUDMI_FILECODE                                 (0xDC10)
#define PROC_CPU_FEATURE_CPUPSTATEGATHER_FILECODE                        (0xDC41)
#define PROC_CPU_FEATURE_CPUPSTATELEVELING_FILECODE                      (0xDC42)
#define PROC_CPU_FEATURE_CPUPSTATETABLES_FILECODE                        (0xDC43)
#define PROC_CPU_FEATURE_CPUSLIT_FILECODE                                (0xDC50)
#define PROC_CPU_FEATURE_CPUSRAT_FILECODE                                (0xDC60)
#define PROC_CPU_FEATURE_CPUWHEA_FILECODE                                (0xDC70)
#define PROC_CPU_FEATURE_CPUC6STATE_FILECODE                             (0xDC82)
#define PROC_CPU_FEATURE_CPUCPB_FILECODE                                 (0xDC83)
#define PROC_CPU_FEATURE_CPULOWPWRPSTATE_FILECODE                        (0xDC84)
#define PROC_CPU_FEATURE_CPUIOCSTATE_FILECODE                            (0xDC85)
#define PROC_CPU_FEATURE_CPUAPM_FILECODE                                 (0xDC86)
#define PROC_CPU_FEATURE_CPUFEATURES_FILECODE                            (0xDC90)
#define PROC_CPU_FEATURE_CPUCORELEVELING_FILECODE                        (0xDCB0)
#define PROC_CPU_FEATURE_CPUPSI_FILECODE                                 (0xDCC0)
#define PROC_CPU_FEATURE_CPUHTC_FILECODE                                 (0xDCC1)
#define PROC_CPU_FEATURE_CPUCRAT_FILECODE                                (0xDCD0)
#define PROC_CPU_FEATURE_CPUCDIT_FILECODE                                (0xDCD1)
#define PROC_CPU_FEATURE_CPUPREFETCHMODE_FILECODE                        (0xDCD3)
#define PROC_CPU_FEATURE_CPUSCS_FILECODE                                 (0xDCD4)
#define PROC_CPU_FEATURE_CPUCC6EXITCONTROL_FILECODE                      (0xDCD5)

#define PROC_RECOVERY_CPU_CPURECOVERY_FILECODE                           (0xDE01)

#define PROC_TOPOLOGY_TOPOMAIN_FILECODE                                  (0xE001)
#define PROC_TOPOLOGY_TOPONB_FILECODE                                    (0xE002)
#define PROC_TOPOLOGY_FAM15_TOPONBFAM15_FILECODE                         (0xE087)
#define PROC_TOPOLOGY_FAM15_TOPONBUTILITIESFAM15_FILECODE                (0xE088)
#define PROC_TOPOLOGY_FAM16_TOPONBFAM16_FILECODE                         (0xE097)
#define PROC_TOPOLOGY_FAM16_TOPONBUTILITIESFAM16_FILECODE                (0xE098)

#define PROC_RECOVERY_TOPOLOGY_TOPOINITRECOVERY_FILECODE                 (0xE0FF)

#define PROC_IDS_CONTROL_IDSCTRL_FILECODE                                (0xE801)
#define PROC_IDS_LIBRARY_IDSLIB_FILECODE                                 (0xE802)
#define PROC_IDS_DEBUG_IDSDEBUG_FILECODE                                 (0xE803)
#define PROC_IDS_PERF_IDSPERF_FILECODE                                   (0xE804)
#define PROC_IDS_FAMILY_0X15_IDSF15ALLSERVICE_FILECODE                   (0xE80C)
#define PROC_IDS_FAMILY_0X15_TN_IDSF15TNALLSERVICE_FILECODE              (0xE80F)
#define PROC_IDS_LIBRARY_IDSREGACC_FILECODE                              (0xE810)
#define PROC_IDS_DEBUG_IDSDPHDTOUT_FILECODE                              (0xE811)
#define PROC_IDS_DEBUG_IDSDEBUGPRINT_FILECODE                            (0xE812)
#define PROC_IDS_DEBUG_IDSDPSERIAL_FILECODE                              (0xE813)
#define PROC_IDS_DEBUG_IDSDPREDIRECTIO_FILECODE                          (0xE814)
#define PROC_IDS_DEBUG_IDSDPRAM_FILECODE                                 (0xE815)

#define PROC_IDS_DEBUG_IDSIDTTABLE_FILECODE                              (0xE81E)
#define PROC_IDS_CONTROL_IDSNVTOCMOS_FILECODE                            (0xE81F)
#define PROC_IDS_FAMILY_0X15_KV_IDSF15KVALLSERVICE_FILECODE              (0xE820)

///0xE820 ~ 0xE840 is reserved for ids extend module

#define PROC_MEM_ARDK_MA_FILECODE                                    (0xF001)

#define PROC_MEM_FEAT_CHINTLV_MFCHI_FILECODE                         (0xF081)
#define PROC_MEM_FEAT_CSINTLV_MFCSI_FILECODE                         (0xF082)
#define PROC_MEM_FEAT_ECC_MFECC_FILECODE                             (0xF083)
#define PROC_MEM_FEAT_ECC_MFEMP_FILECODE                             (0xF085)
#define PROC_MEM_FEAT_EXCLUDIMM_MFDIMMEXCLUD_FILECODE                (0xF086)
#define PROC_MEM_FEAT_IDENDIMM_MFIDENDIMM_FILECODE                   (0xF088)
#define PROC_MEM_FEAT_INTLVRN_MFINTLVRN_FILECODE                     (0xF089)
#define PROC_MEM_FEAT_LVDDR3_MFLVDDR3_FILECODE                       (0xF08A)
#define PROC_MEM_FEAT_MEMCLR_MFMEMCLR_FILECODE                       (0xF08B)
#define PROC_MEM_FEAT_NDINTLV_MFNDI_FILECODE                         (0xF08C)
#define PROC_MEM_FEAT_ODTHERMAL_MFODTHERMAL_FILECODE                 (0xF08D)
#define PROC_MEM_FEAT_OLSPARE_MFSPR_FILECODE                         (0xF08E)
#define PROC_MEM_FEAT_PARTRN_MFPARALLELTRAINING_FILECODE             (0xF08F)
#define PROC_MEM_FEAT_PARTRN_MFSTANDARDTRAINING_FILECODE             (0xF091)
#define PROC_MEM_FEAT_S3_MFS3_FILECODE                               (0xF092)
#define PROC_MEM_FEAT_TABLE_MFTDS_FILECODE                           (0xF093)
#define PROC_MEM_FEAT_CHINTLV_MFMCHI_FILECODE                        (0xF094)
#define PROC_MEM_FEAT_CRAT_MFCRAT_FILECODE                           (0xF095)
#define PROC_MEM_FEAT_AMP_MFAMP_FILECODE                             (0xF096)
#define PROC_MEM_FEAT_DATAEYE_MF2DDATAEYE_FILECODE                   (0xF097)
#define PROC_MEM_FEAT_RDWR2DTRAINING_MFWRDAT2DTRAINING_FILECODE         (0xF098)
#define PROC_MEM_FEAT_RDWR2DTRAINING_MFRDWR2DEYERIMSEARCH_FILECODE      (0xF099)
#define PROC_MEM_FEAT_RDWR2DTRAINING_MFRDDQS2DTRAINING_FILECODE         (0xF09A)
#define PROC_MEM_FEAT_RDWR2DTRAINING_MFRDWR2DTRAINING_FILECODE          (0xF09B)
#define PROC_MEM_FEAT_RDWR2DTRAINING_MFRDWR2DPATTERNGENERATION_FILECODE (0xF09C)
#define PROC_MEM_FEAT_AGGRESSOR_MFAGGRESSOR_FILECODE                    (0xF09F)
#define PROC_MEM_FEAT_DLLPDBYPASS_MFDLLPDBYPASS_FILECODE                (0xF0A0)

#define PROC_MEM_MAIN_MDEF_FILECODE                                  (0xF101)
#define PROC_MEM_MAIN_MINIT_FILECODE                                 (0xF102)
#define PROC_MEM_MAIN_MM_FILECODE                                    (0xF103)
#define PROC_MEM_FEAT_DMI_MFDMI_FILECODE                             (0xF104)
#define PROC_MEM_MAIN_MMECC_FILECODE                                 (0xF105)
#define PROC_MEM_MAIN_MMEXCLUDEDIMM_FILECODE                         (0xF106)
#define PROC_MEM_MAIN_MMNODEINTERLEAVE_FILECODE                      (0xF10B)
#define PROC_MEM_MAIN_MMONLINESPARE_FILECODE                         (0xF10C)
#define PROC_MEM_MAIN_MMPARALLELTRAINING_FILECODE                    (0xF10D)
#define PROC_MEM_MAIN_MMSTANDARDTRAINING_FILECODE                    (0xF10E)
#define PROC_MEM_MAIN_MUC_FILECODE                                   (0xF10F)
#define PROC_MEM_MAIN_MMMEMCLR_FILECODE                              (0xF110)
#define PROC_MEM_MAIN_MMFLOW_FILECODE                                (0xF112)
#define PROC_MEM_MAIN_MERRHDL_FILECODE                               (0xF113)
#define PROC_MEM_MAIN_MMLVDDR3_FILECODE                              (0xF115)
#define PROC_MEM_MAIN_MMUMAALLOC_FILECODE                            (0xF116)
#define PROC_MEM_MAIN_MMMEMRESTORE_FILECODE                          (0xF117)
#define PROC_MEM_MAIN_MMCONDITIONALPSO_FILECODE                      (0xF118)
#define PROC_MEM_MAIN_MMAGGRESSOR_FILECODE                           (0xF119)
#define PROC_MEM_MAIN_TN_MMFLOWTN_FILECODE                           (0xF11C)
#define PROC_MEM_MAIN_KV_MMFLOWD3KV_FILECODE                         (0xF122)

#define PROC_MEM_NB_MN_FILECODE                                      (0XF27C)
#define PROC_MEM_NB_MNDCT_FILECODE                                   (0XF27D)
#define PROC_MEM_NB_MNPHY_FILECODE                                   (0XF27E)
#define PROC_MEM_NB_MNMCT_FILECODE                                   (0XF27F)
#define PROC_MEM_NB_MNS3_FILECODE                                    (0XF280)
#define PROC_MEM_NB_MNFLOW_FILECODE                                  (0XF281)
#define PROC_MEM_NB_MNFEAT_FILECODE                                  (0XF282)
#define PROC_MEM_NB_MNTRAIN3_FILECODE                                (0XF284)
#define PROC_MEM_NB_MNREG_FILECODE                                   (0XF285)
#define PROC_MEM_NB_TN_MNREGTN_FILECODE                              (0XF29B)
#define PROC_MEM_NB_TN_MNTN_FILECODE                                 (0XF29C)
#define PROC_MEM_NB_TN_MNMCTTN_FILECODE                              (0XF29D)
#define PROC_MEM_NB_TN_MNOTTN_FILECODE                               (0XF29E)
#define PROC_MEM_NB_TN_MNDCTTN_FILECODE                              (0XF29F)
#define PROC_MEM_NB_TN_MNPHYTN_FILECODE                              (0XF2A0)
#define PROC_MEM_NB_TN_MNS3TN_FILECODE                               (0XF2A1)
#define PROC_MEM_NB_TN_MNIDENDIMMTN_FILECODE                         (0XF2A2)
#define PROC_MEM_NB_TN_MNFLOWTN_FILECODE                             (0XF2A3)
#define PROC_MEM_NB_TN_MNPROTOTN_FILECODE                            (0XF2A4)
#define PROC_MEM_NB_KV_MNKV_FILECODE                                 (0xF2AF)
#define PROC_MEM_NB_KV_MNMCTKV_FILECODE                              (0xF2B0)
#define PROC_MEM_NB_KV_MNDCTKV_FILECODE                              (0xF2B1)
#define PROC_MEM_NB_KV_MNPHYKV_FILECODE                              (0xF2B2)
#define PROC_MEM_NB_KV_MNS3KV_FILECODE                               (0xF2B3)
#define PROC_MEM_NB_KV_MNIDENDIMMKV_FILECODE                         (0xF2B4)
#define PROC_MEM_NB_KV_MNPROTOKV_FILECODE                            (0xF2B5)
#define PROC_MEM_NB_KV_MNREGKV_FILECODE                              (0xF2B6)
#define PROC_MEM_NB_MNPMU_FILECODE                                   (0xF2B7)
#define PROC_MEM_NB_KV_MNPMUKV_FILECODE                              (0XF2C2)
#define PROC_MEM_NB_KV_MNPMUSRAMMSGBLOCKKV_FILECODE                  (0XF2D7)

#define PROC_MEM_PS_MP_FILECODE                                      (0XF401)
#define PROC_MEM_PS_MPRTT_FILECODE                                   (0XF422)
#define PROC_MEM_PS_MPMAXFREQ_FILECODE                               (0XF423)
#define PROC_MEM_PS_MPODTPAT_FILECODE                                (0XF424)
#define PROC_MEM_PS_MPSAO_FILECODE                                   (0XF425)
#define PROC_MEM_PS_MPMR0_FILECODE                                   (0XF426)
#define PROC_MEM_PS_MPRC2IBT_FILECODE                                (0XF427)
#define PROC_MEM_PS_MPRC10OPSPD_FILECODE                             (0XF428)
#define PROC_MEM_PS_MPLRIBT_FILECODE                                 (0XF429)
#define PROC_MEM_PS_MPLRNPR_FILECODE                                 (0XF42A)
#define PROC_MEM_PS_MPLRNLR_FILECODE                                 (0XF42B)
#define PROC_MEM_PS_TN_MPSTN3_FILECODE                               (0XF42D)
#define PROC_MEM_PS_TN_MPTN3_FILECODE                                (0XF42E)
#define PROC_MEM_PS_TN_MPUTN3_FILECODE                               (0XF42F)
#define PROC_MEM_PS_TN_FM2_MPUTNFM2_FILECODE                         (0XF430)
#define PROC_MEM_PS_TN_FP2_MPSTNFP2_FILECODE                         (0XF431)
#define PROC_MEM_PS_TN_FS1_MPSTNFS1_FILECODE                         (0XF432)
#define PROC_MEM_PS_MPS2D_FILECODE                                   (0XF436)
#define PROC_MEM_PS_MPSEEDS_FILECODE                                 (0XF437)
#define PROC_MEM_PS_MPCADCFG_FILECODE                                (0XF43C)
#define PROC_MEM_PS_MPDATACFG_FILECODE                               (0XF43D)
#define PROC_MEM_PS_KV_MPKV3_FILECODE                                (0XF43E)
#define PROC_MEM_PS_KV_MPSKV3_FILECODE                               (0XF43F)
#define PROC_MEM_PS_KV_MPUKV3_FILECODE                               (0XF440)

#define PROC_MEM_TECH_MT_FILECODE                                    (0XF501)
#define PROC_MEM_TECH_MTHDI_FILECODE                                 (0XF502)
#define PROC_MEM_TECH_MTTDIMBT_FILECODE                              (0XF504)
#define PROC_MEM_TECH_MTTECC_FILECODE                                (0XF505)
#define PROC_MEM_TECH_MTTHRC_FILECODE                                (0XF506)
#define PROC_MEM_TECH_MTTML_FILECODE                                 (0XF507)
#define PROC_MEM_TECH_MTTOPTSRC_FILECODE                             (0XF509)
#define PROC_MEM_TECH_MTTSRC_FILECODE                                (0XF50B)
#define PROC_MEM_TECH_MTTEDGEDETECT_FILECODE                         (0XF50C)
#define PROC_MEM_TECH_DDR3_MT3_FILECODE                              (0XF581)
#define PROC_MEM_TECH_DDR3_MTOT3_FILECODE                            (0XF583)
#define PROC_MEM_TECH_DDR3_MTRCI3_FILECODE                           (0XF584)
#define PROC_MEM_TECH_DDR3_MTSDI3_FILECODE                           (0XF585)
#define PROC_MEM_TECH_DDR3_MTSPD3_FILECODE                           (0XF586)
#define PROC_MEM_TECH_DDR3_MTTWL3_FILECODE                           (0XF587)
#define PROC_MEM_TECH_DDR3_MTTECC3_FILECODE                          (0XF588)
#define PROC_MEM_TECH_DDR3_MTLRDIMM3_FILECODE                        (0XF589)
#define PROC_MEM_TECH_MTTHRCSEEDTRAIN_FILECODE                       (0XF58A)
#define PROC_MEM_TECH_MTTRDDQS2DTRAINING_FILECODE                    (0XF58B)
#define PROC_MEM_TECH_MTTRDDQS2DEYERIMSEARCH_FILECODE                (0XF58C)
#define PROC_MEM_TECH_GDDR5_MNSPDG5_FILECODE                         (0XF58E)
#define PROC_MEM_TECH_GDDR5_MNDCTG5_FILECODE                         (0xF58F)

#define PROC_RECOVERY_MEM_MRDEF_FILECODE                             (0XF801)
#define PROC_RECOVERY_MEM_MRINIT_FILECODE                            (0XF802)
#define PROC_RECOVERY_MEM_MRM_FILECODE                               (0XF803)
#define PROC_RECOVERY_MEM_MRUC_FILECODE                              (0XF804)
#define PROC_RECOVERY_MEM_TECH_MRTTPOS_FILECODE                      (0XF8C1)
#define PROC_RECOVERY_MEM_TECH_MRTTSRC_FILECODE                      (0XF8C2)
#define PROC_RECOVERY_MEM_TECH_DDR3_MRT3_FILECODE                    (0XF8C3)
#define PROC_RECOVERY_MEM_TECH_DDR3_MRTRCI3_FILECODE                 (0XF8C4)
#define PROC_RECOVERY_MEM_TECH_DDR3_MRTSDI3_FILECODE                 (0XF8C5)
#define PROC_RECOVERY_MEM_TECH_DDR3_MRTSPD3_FILECODE                 (0XF8C6)
#define PROC_RECOVERY_MEM_TECH_DDR3_MRTTWL3_FILECODE                 (0XF8C7)
#define PROC_RECOVERY_MEM_NB_MRN_FILECODE                            (0XF8C8)
#define PROC_RECOVERY_MEM_NB_MRNDCT_FILECODE                         (0XF8C9)
#define PROC_RECOVERY_MEM_NB_MRNMCT_FILECODE                         (0XF8CA)
#define PROC_RECOVERY_MEM_NB_MRNTRAIN3_FILECODE                      (0XF8CB)
#define PROC_RECOVERY_MEM_TECH_MRTTHRC_FILECODE                      (0XF8CC)
#define PROC_RECOVERY_MEM_PS_MRP_FILECODE                            (0XF8E0)
#define PROC_RECOVERY_MEM_PS_MRPRTT_FILECODE                         (0XF8E1)
#define PROC_RECOVERY_MEM_PS_MRPODTPAT_FILECODE                      (0XF8E2)
#define PROC_RECOVERY_MEM_PS_MRPSAO_FILECODE                         (0XF8E3)
#define PROC_RECOVERY_MEM_PS_MRPMR0_FILECODE                         (0XF8E4)
#define PROC_RECOVERY_MEM_PS_MRPRC2IBT_FILECODE                      (0XF8E5)
#define PROC_RECOVERY_MEM_PS_MRPRC10OPSPD_FILECODE                   (0XF8E6)
#define PROC_RECOVERY_MEM_PS_MRPLRIBT_FILECODE                       (0XF8E7)
#define PROC_RECOVERY_MEM_PS_MRPLRNPR_FILECODE                       (0XF8E8)
#define PROC_RECOVERY_MEM_PS_MRPLRNLR_FILECODE                       (0XF8E9)
#define PROC_RECOVERY_MEM_NB_TN_MRNDCTTN_FILECODE                    (0XF8F3)
#define PROC_RECOVERY_MEM_NB_TN_MRNTN_FILECODE                       (0XF8F4)
#define PROC_RECOVERY_MEM_NB_TN_MRNMCTTN_FILECODE                    (0XF8F5)
#define PROC_RECOVERY_MEM_NB_TN_MRNPROTOTN_FILECODE                  (0XF8F6)
#define PROC_RECOVERY_MEM_PS_TN_MRPSTN3_FILECODE                     (0XF8F7)
#define PROC_RECOVERY_MEM_PS_TN_MRPTN3_FILECODE                      (0XF8F8)
#define PROC_RECOVERY_MEM_PS_TN_MRPUTN3_FILECODE                     (0XF8F9)
#define PROC_RECOVERY_MEM_TECH_MRTTHRCSEEDTRAIN_FILECODE             (0XF8FA)

//Psp
#define UEFI_PSP_DRIVERS_ITPMDXE_ITPMDXE_FILECODE                    (0xFA00)
#define UEFI_PSP_DRIVERS_ITPMPEI_ITPMPEI_FILECODE                    (0xFA01)
#define UEFI_PSP_DRIVERS_ITPMSMM_ITPMPSPCOMMAND_FILECODE             (0xFA02)
#define UEFI_PSP_DRIVERS_ITPMSMM_ITPMSMM_FILECODE                    (0xFA03)
#define UEFI_PSP_DRIVERS_PSPPEI_PSPPEI_FILECODE                      (0xFA04)
#define UEFI_PSP_DRIVERS_PSPSMM_PSPRESUMEHANDLING_FILECODE           (0xFA05)
#define UEFI_PSP_DRIVERS_PSPSMM_PSPRESUMESERVICES_FILECODE           (0xFA06)
#define UEFI_PSP_DRIVERS_PSPSMM_PSPSMM_FILECODE                      (0xFA07)
#define UEFI_PSP_LIBRARY_PSPBASELIB_PSPBASELIB_FILECODE              (0xFA08)
#define UEFI_PSP_LIBRARY_PSPMBOX_PSPMBOX_FILECODE                    (0xFA09)
#define UEFI_PSP_LIBRARY_SMMLOAD_SMMLOAD_FILECODE                    (0xFA0A)
#define UEFI_PSP_DRIVERS_PSPDXE_PSPDXE_FILECODE                      (0xFA0B)
#define UEFI_PSP_LIBRARY_PSPFTPMLIB_PSPFTPMLIB_FILECODE              (0xFA0C)
#define UEFI_PSP_LIBRARY_CCPSHALIB_CCPSHALIB_FILECODE                (0xFA0D)

#endif // _FILECODE_H_
