/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef _SOC_ALDERLAKE_GPIO_H_
#define _SOC_ALDERLAKE_GPIO_H_

#include <soc/gpio_defs.h>
#include <intelblocks/gpio.h>

#if CONFIG(SOC_INTEL_ALDERLAKE_PCH_N)
#define CROS_GPIO_NAME		"INTC1057"
#define CROS_GPIO_DEVICE_NAME	"INTC1057:00"
#else
#define CROS_GPIO_NAME		"INTC1055"
#define CROS_GPIO_DEVICE_NAME	"INTC1055:00"
#endif

/* Enable GPIO community power management configuration */
#define MISCCFG_GPIO_PM_CONFIG_BITS (MISCCFG_GPVNNREQEN | \
	MISCCFG_GPPGCBDPCGEN | MISCCFG_GPSIDEDPCGEN | \
	MISCCFG_GPRCOMPCDLCGEN | MISCCFG_GPRTCDLCGEN | MISCCFG_GSXSLCGEN \
	| MISCCFG_GPDPCGEN | MISCCFG_GPDLCGEN)

#endif
