/** @file

Copyright (c) 2022, Intel Corporation. All rights reserved.<BR>

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice, this
  list of conditions and the following disclaimer in the documentation and/or
  other materials provided with the distribution.
* Neither the name of Intel Corporation nor the names of its contributors may
  be used to endorse or promote products derived from this software without
  specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  THE POSSIBILITY OF SUCH DAMAGE.

  This file is automatically generated. Please do NOT modify !!!

**/

#ifndef __FSPMUPD_H__
#define __FSPMUPD_H__

#include <FspUpd.h>

#pragma pack(1)


#include <MemInfoHob.h>

///
/// The ChipsetInit Info structure provides the information of ME ChipsetInit CRC and BIOS ChipsetInit CRC.
///
typedef struct {
  UINT8             Revision;         ///< Chipset Init Info Revision
  UINT8             Rsvd[3];          ///< Reserved
  UINT16            MeChipInitCrc;    ///< 16 bit CRC value of MeChipInit Table
  UINT16            BiosChipInitCrc;  ///< 16 bit CRC value of PchChipInit Table
} CHIPSET_INIT_INFO;


/** Fsp M Configuration
**/
typedef struct {

/** Offset 0x0040 - Platform Reserved Memory Size
  The minimum platform memory size required to pass control into DXE
**/
  UINT64                      PlatformMemorySize;

/** Offset 0x0048 - SPD Data Length
  Length of SPD Data
  0x100:256 Bytes, 0x200:512 Bytes, 0x400:1024 Bytes
**/
  UINT16                      MemorySpdDataLen;

/** Offset 0x004A - Enable above 4GB MMIO resource support
  Enable/disable above 4GB MMIO resource support
  $EN_DIS
**/
  UINT8                       EnableAbove4GBMmio;

/** Offset 0x004B - Enable/Disable CrashLog Device 10
  Enable(Default): Enable CPU CrashLog Device 10, Disable: Disable CPU CrashLog
  $EN_DIS
**/
  UINT8                       CpuCrashLogDevice;

/** Offset 0x004C - Memory SPD Pointer Controller 0 Channel 0 Dimm 0
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr000;

/** Offset 0x0050 - Memory SPD Pointer Controller 0 Channel 0 Dimm 1
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr001;

/** Offset 0x0054 - Memory SPD Pointer Controller 0 Channel 1 Dimm 0
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr010;

/** Offset 0x0058 - Memory SPD Pointer Controller 0 Channel 1 Dimm 1
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr011;

/** Offset 0x005C - Memory SPD Pointer Controller 0 Channel 2 Dimm 0
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr020;

/** Offset 0x0060 - Memory SPD Pointer Controller 0 Channel 2 Dimm 1
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr021;

/** Offset 0x0064 - Memory SPD Pointer Controller 0 Channel 3 Dimm 0
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr030;

/** Offset 0x0068 - Memory SPD Pointer Controller 0 Channel 3 Dimm 1
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr031;

/** Offset 0x006C - Memory SPD Pointer Controller 1 Channel 0 Dimm 0
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr100;

/** Offset 0x0070 - Memory SPD Pointer Controller 1 Channel 0 Dimm 1
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr101;

/** Offset 0x0074 - Memory SPD Pointer Controller 1 Channel 1 Dimm 0
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr110;

/** Offset 0x0078 - Memory SPD Pointer Controller 1 Channel 1 Dimm 1
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr111;

/** Offset 0x007C - Memory SPD Pointer Controller 1 Channel 2 Dimm 0
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr120;

/** Offset 0x0080 - Memory SPD Pointer Controller 1 Channel 2 Dimm 1
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr121;

/** Offset 0x0084 - Memory SPD Pointer Controller 1 Channel 3 Dimm 0
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr130;

/** Offset 0x0088 - Memory SPD Pointer Controller 1 Channel 3 Dimm 1
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr131;

/** Offset 0x008C - RcompResistor settings
  Indicates  RcompResistor settings: Board-dependent
**/
  UINT16                      RcompResistor;

/** Offset 0x008E - RcompTarget settings
  RcompTarget settings: board-dependent
**/
  UINT16                      RcompTarget[5];

/** Offset 0x0098 - Dqs Map CPU to DRAM MC 0 CH 0
  Set Dqs mapping relationship between CPU and DRAM, Channel 0: board-dependent
**/
  UINT8                       DqsMapCpu2DramMc0Ch0[2];

/** Offset 0x009A - Dqs Map CPU to DRAM MC 0 CH 1
  Set Dqs mapping relationship between CPU and DRAM, Channel 1: board-dependent
**/
  UINT8                       DqsMapCpu2DramMc0Ch1[2];

/** Offset 0x009C - Dqs Map CPU to DRAM MC 0 CH 2
  Set Dqs mapping relationship between CPU and DRAM, Channel 2: board-dependent
**/
  UINT8                       DqsMapCpu2DramMc0Ch2[2];

/** Offset 0x009E - Dqs Map CPU to DRAM MC 0 CH 3
  Set Dqs mapping relationship between CPU and DRAM, Channel 3: board-dependent
**/
  UINT8                       DqsMapCpu2DramMc0Ch3[2];

/** Offset 0x00A0 - Dqs Map CPU to DRAM MC 1 CH 0
  Set Dqs mapping relationship between CPU and DRAM, Channel 0: board-dependent
**/
  UINT8                       DqsMapCpu2DramMc1Ch0[2];

/** Offset 0x00A2 - Dqs Map CPU to DRAM MC 1 CH 1
  Set Dqs mapping relationship between CPU and DRAM, Channel 1: board-dependent
**/
  UINT8                       DqsMapCpu2DramMc1Ch1[2];

/** Offset 0x00A4 - Dqs Map CPU to DRAM MC 1 CH 2
  Set Dqs mapping relationship between CPU and DRAM, Channel 2: board-dependent
**/
  UINT8                       DqsMapCpu2DramMc1Ch2[2];

/** Offset 0x00A6 - Dqs Map CPU to DRAM MC 1 CH 3
  Set Dqs mapping relationship between CPU and DRAM, Channel 3: board-dependent
**/
  UINT8                       DqsMapCpu2DramMc1Ch3[2];

/** Offset 0x00A8 - Dq Map CPU to DRAM MC 0 CH 0
  Set Dq mapping relationship between CPU and DRAM, Channel 0: board-dependent
**/
  UINT8                       DqMapCpu2DramMc0Ch0[16];

/** Offset 0x00B8 - Dq Map CPU to DRAM MC 0 CH 1
  Set Dq mapping relationship between CPU and DRAM, Channel 1: board-dependent
**/
  UINT8                       DqMapCpu2DramMc0Ch1[16];

/** Offset 0x00C8 - Dq Map CPU to DRAM MC 0 CH 2
  Set Dq mapping relationship between CPU and DRAM, Channel 2: board-dependet
**/
  UINT8                       DqMapCpu2DramMc0Ch2[16];

/** Offset 0x00D8 - Dq Map CPU to DRAM MC 0 CH 3
  Set Dq mapping relationship between CPU and DRAM, Channel 3: board-dependent
**/
  UINT8                       DqMapCpu2DramMc0Ch3[16];

/** Offset 0x00E8 - Dq Map CPU to DRAM MC 1 CH 0
  Set Dq mapping relationship between CPU and DRAM, Channel 0: board-dependent
**/
  UINT8                       DqMapCpu2DramMc1Ch0[16];

/** Offset 0x00F8 - Dq Map CPU to DRAM MC 1 CH 1
  Set Dq mapping relationship between CPU and DRAM, Channel 1: board-dependent
**/
  UINT8                       DqMapCpu2DramMc1Ch1[16];

/** Offset 0x0108 - Dq Map CPU to DRAM MC 1 CH 2
  Set Dq mapping relationship between CPU and DRAM, Channel 2: board-dependent
**/
  UINT8                       DqMapCpu2DramMc1Ch2[16];

/** Offset 0x0118 - Dq Map CPU to DRAM MC 1 CH 3
  Set Dq mapping relationship between CPU and DRAM, Channel 3: board-dependent
**/
  UINT8                       DqMapCpu2DramMc1Ch3[16];

/** Offset 0x0128 - Dqs Pins Interleaved Setting
  Indicates DqPinsInterleaved setting: board-dependent
  $EN_DIS
**/
  UINT8                       DqPinsInterleaved;

/** Offset 0x0129 - Smram Mask
  The SMM Regions AB-SEG and/or H-SEG reserved
  0: Neither, 1:AB-SEG, 2:H-SEG, 3: Both
**/
  UINT8                       SmramMask;

/** Offset 0x012A - Ibecc
  Enable/Disable Ibecc
  $EN_DIS
**/
  UINT8                       Ibecc;

/** Offset 0x012B - IbeccOperationMode
  In-Band ECC Operation Mode
  0:Protect base on address range, 1:Non-protected, 2:All protected
**/
  UINT8                       IbeccOperationMode;

/** Offset 0x012C - IbeccProtectedRangeEnable
  In-Band ECC Protected Region Enable
  $EN_DIS
**/
  UINT8                       IbeccProtectedRangeEnable[8];

/** Offset 0x0134 - IbeccProtectedRangeBase
  IBECC Protected Region Base
**/
  UINT32                      IbeccProtectedRangeBase[8];

/** Offset 0x0154 - IbeccProtectedRangeMask
  IBECC Protected Region Mask
**/
  UINT32                      IbeccProtectedRangeMask[8];

/** Offset 0x0174 - MRC Fast Boot
  Enables/Disable the MRC fast path thru the MRC
  $EN_DIS
**/
  UINT8                       MrcFastBoot;

/** Offset 0x0175 - Rank Margin Tool per Task
  This option enables the user to execute Rank Margin Tool per major training step
  in the MRC.
  $EN_DIS
**/
  UINT8                       RmtPerTask;

/** Offset 0x0176 - Training Trace
  This option enables the trained state tracing feature in MRC.  This feature will
  print out the key training parameters state across major training steps.
  $EN_DIS
**/
  UINT8                       TrainTrace;

/** Offset 0x0177
**/
  UINT8                       UnusedUpdSpace0;

/** Offset 0x0178 - Tseg Size
  Size of SMRAM memory reserved. 0x400000 for Release build and 0x1000000 for Debug build
  0x0400000:4MB, 0x01000000:16MB
**/
  UINT32                      TsegSize;

/** Offset 0x017C - MMIO Size
  Size of MMIO space reserved for devices. 0(Default)=Auto, non-Zero=size in MB
**/
  UINT16                      MmioSize;

/** Offset 0x017E - Probeless Trace
  Probeless Trace: 0=Disabled, 1=Enable. Enabling Probeless Trace will reserve 128MB.
  This also requires IED to be enabled.
  $EN_DIS
**/
  UINT8                       ProbelessTrace;

/** Offset 0x017F - Enable SMBus
  Enable/disable SMBus controller.
  $EN_DIS
**/
  UINT8                       SmbusEnable;

/** Offset 0x0180 - Spd Address Tabl
  Specify SPD Address table for CH0D0/CH0D1/CH1D0&CH1D1. MemorySpdPtr will be used
  if SPD Address is 00
**/
  UINT8                       SpdAddressTable[16];

/** Offset 0x0190 - Platform Debug Consent
  Enabled(All Probes+TraceHub) supports all probes with TraceHub enabled and blocks
  s0ix\n
  \n
  Enabled(Low Power) does not support DCI OOB 4-wire and Tracehub is powergated by
  default, s0ix is viable\n
  \n
  Manual:user needs to configure Advanced Debug Settings manually, aimed at advanced users
  0:Disabled, 2:Enabled (All Probes+TraceHub), 6:Enable (Low Power), 7:Manual
**/
  UINT8                       PlatformDebugConsent;

/** Offset 0x0191 - DCI Enable
  Determine if to enable DCI debug from host
  $EN_DIS
**/
  UINT8                       DciEn;

/** Offset 0x0192 - DCI DbC Mode
  Disabled: Clear both USB2/3DBCEN; USB2: set USB2DBCEN; USB3: set USB3DBCEN; Both:
  Set both USB2/3DBCEN; No Change: Comply with HW value
  0:Disabled, 1:USB2 DbC, 2:USB3 DbC, 3:Both, 4:No Change
**/
  UINT8                       DciDbcMode;

/** Offset 0x0193 - Enable DCI ModPHY Power Gate
  DEPRECATED
  $EN_DIS
**/
  UINT8                       DciModphyPg;

/** Offset 0x0194 - USB3 Type-C UFP2DFP Kernel/Platform Debug Support
  This BIOS option enables kernel and platform debug for USB3 interface over a UFP
  Type-C receptacle, select 'No Change' will do nothing to UFP2DFP setting.
  0:Disabled, 1:Enabled, 2:No Change
**/
  UINT8                       DciUsb3TypecUfpDbg;

/** Offset 0x0195 - PCH Trace Hub Mode
  Select 'Host Debugger' if Trace Hub is used with host debugger tool or 'Target Debugger'
  if Trace Hub is used by target debugger software or 'Disable' trace hub functionality.
  0: Disable, 1: Target Debugger Mode, 2: Host Debugger Mode
**/
  UINT8                       PchTraceHubMode;

/** Offset 0x0196 - PCH Trace Hub Memory Region 0 buffer Size
  Specify size of Pch trace memory region 0 buffer, the size can be 0, 1MB, 8MB, 64MB,
  128MB, 256MB, 512MB
  0:0, 1:1MB, 2:8MB, 3:64MB, 4:128MB, 5:256MB, 6:512MB
**/
  UINT8                       PchTraceHubMemReg0Size;

/** Offset 0x0197 - PCH Trace Hub Memory Region 1 buffer Size
  Specify size of Pch trace memory region 1 buffer, the size can be 0, 1MB, 8MB, 64MB,
  128MB, 256MB, 512MB
  0:0, 1:1MB, 2:8MB, 3:64MB, 4:128MB, 5:256MB, 6:512MB
**/
  UINT8                       PchTraceHubMemReg1Size;

/** Offset 0x0198 - HD Audio DMIC Link Clock Select
  Determines DMIC<N> Clock Source. 0: Both, 1: ClkA, 2: ClkB
  0: Both, 1: ClkA, 2: ClkB
**/
  UINT8                       PchHdaAudioLinkDmicClockSelect[2];

/** Offset 0x019A - PchPreMemRsvd
  Reserved for PCH Pre-Mem Reserved
  $EN_DIS
**/
  UINT8                       PchPreMemRsvd[5];

/** Offset 0x019F - State of X2APIC_OPT_OUT bit in the DMAR table
  0=Disable/Clear, 1=Enable/Set
  $EN_DIS
**/
  UINT8                       X2ApicOptOut;

/** Offset 0x01A0 - State of DMA_CONTROL_GUARANTEE bit in the DMAR table
  0=Disable/Clear, 1=Enable/Set
  $EN_DIS
**/
  UINT8                       DmaControlGuarantee;

/** Offset 0x01A1
**/
  UINT8                       UnusedUpdSpace1[3];

/** Offset 0x01A4 - Base addresses for VT-d function MMIO access
  Base addresses for VT-d MMIO access per VT-d engine
**/
  UINT32                      VtdBaseAddress[9];

/** Offset 0x01C8 - Disable VT-d
  0=Enable/FALSE(VT-d enabled), 1=Disable/TRUE (VT-d disabled)
  $EN_DIS
**/
  UINT8                       VtdDisable;

/** Offset 0x01C9 - Vtd Programming for Igd
  1=Enable/TRUE (Igd VT-d Bar programming enabled), 0=Disable/FLASE (Igd VT-d Bar
  programming disabled)
  $EN_DIS
**/
  UINT8                       VtdIgdEnable;

/** Offset 0x01CA - Vtd Programming for Ipu
  1=Enable/TRUE (Ipu VT-d Bar programming enabled), 0=Disable/FLASE (Ipu VT-d Bar
  programming disabled)
  $EN_DIS
**/
  UINT8                       VtdIpuEnable;

/** Offset 0x01CB - Vtd Programming for Iop
  1=Enable/TRUE (Iop VT-d Bar programming enabled), 0=Disable/FLASE (Iop VT-d Bar
  programming disabled)
  $EN_DIS
**/
  UINT8                       VtdIopEnable;

/** Offset 0x01CC - Vtd Programming for ITbt
  DEPRECATED
  $EN_DIS
**/
  UINT8                       VtdItbtEnable;

/** Offset 0x01CD - Internal Graphics Pre-allocated Memory
  Size of memory preallocated for internal graphics.
  0x00:0MB, 0x01:32MB, 0x02:64MB, 0x03:96MB, 0x04:128MB, 0x05:160MB, 0xF0:4MB, 0xF1:8MB,
  0xF2:12MB, 0xF3:16MB, 0xF4:20MB, 0xF5:24MB, 0xF6:28MB, 0xF7:32MB, 0xF8:36MB, 0xF9:40MB,
  0xFA:44MB, 0xFB:48MB, 0xFC:52MB, 0xFD:56MB, 0xFE:60MB
**/
  UINT8                       IgdDvmt50PreAlloc;

/** Offset 0x01CE - Internal Graphics
  Enable/disable internal graphics.
  $EN_DIS
**/
  UINT8                       InternalGfx;

/** Offset 0x01CF - Aperture Size
  Select the Aperture Size.
  0:128 MB, 1:256 MB, 3:512 MB, 7:1024 MB, 15: 2048 MB, 31: 4096 MB
**/
  UINT8                       ApertureSize;

/** Offset 0x01D0 - Board Type
  MrcBoardType, Options are 0:Mobile, 1:Desktop1Dpc, 2:Desktop2DpcDaisyChain, 3:Desktop2DpcTeeTopologyAsymmetrical,
  4:Desktop2DpcTeeTopology, 5:UltMobile, 7:UP Server
  0:Mobile, 1:Desktop1Dpc, 2:Desktop2DpcDaisyChain, 3:Desktop2DpcTeeTopologyAsymmetrical,
  4:Desktop2DpcTeeTopology, 5:UltMobile, 7:UP Server
**/
  UINT8                       UserBd;

/** Offset 0x01D1
**/
  UINT8                       UnusedUpdSpace2;

/** Offset 0x01D2 - DDR Frequency Limit
  Maximum Memory Frequency Selections in Mhz. Options are 1067, 1333, 1600, 1867,
  2133, 2400, 2667, 2933 and 0 for Auto.
  1067:1067, 1333:1333, 1600:1600, 1867:1867, 2133:2133, 2400:2400, 2667:2667, 2933:2933, 0:Auto
**/
  UINT16                      DdrFreqLimit;

/** Offset 0x01D4 - SA GV
  System Agent dynamic frequency support and when enabled memory will be training
  at four different frequencies.
  0:Disabled, 1:FixedPoint0, 2:FixedPoint1, 3:FixedPoint2, 4:FixedPoint3, 5:Enabled
**/
  UINT8                       SaGv;

/** Offset 0x01D5 - Memory Test on Warm Boot
  Run Base Memory Test on Warm Boot
  0:Disable, 1:Enable
**/
  UINT8                       MemTestOnWarmBoot;

/** Offset 0x01D6 - DDR Speed Control
  DDR Frequency and Gear control for all SAGV points.
  0:Auto, 1:Manual
**/
  UINT8                       DdrSpeedControl;

/** Offset 0x01D7 - Rank Margin Tool
  Enable/disable Rank Margin Tool.
  $EN_DIS
**/
  UINT8                       RMT;

/** Offset 0x01D8 - Controller 0 Channel 0 DIMM Control
  Enable / Disable DIMMs on Controller 0 Channel 0
  $EN_DIS
**/
  UINT8                       DisableMc0Ch0;

/** Offset 0x01D9 - Controller 0 Channel 1 DIMM Control
  Enable / Disable DIMMs on Controller 0 Channel 1
  $EN_DIS
**/
  UINT8                       DisableMc0Ch1;

/** Offset 0x01DA - Controller 0 Channel 2 DIMM Control
  Enable / Disable DIMMs on Controller 0 Channel 2
  $EN_DIS
**/
  UINT8                       DisableMc0Ch2;

/** Offset 0x01DB - Controller 0 Channel 3 DIMM Control
  Enable / Disable DIMMs on Controller 0 Channel 3
  $EN_DIS
**/
  UINT8                       DisableMc0Ch3;

/** Offset 0x01DC - Controller 1 Channel 0 DIMM Control
  Enable / Disable DIMMs on Controller 1 Channel 0
  $EN_DIS
**/
  UINT8                       DisableMc1Ch0;

/** Offset 0x01DD - Controller 1 Channel 1 DIMM Control
  Enable / Disable DIMMs on Controller 1 Channel 1
  $EN_DIS
**/
  UINT8                       DisableMc1Ch1;

/** Offset 0x01DE - Controller 1 Channel 2 DIMM Control
  Enable / Disable DIMMs on Controller 1 Channel 2
  $EN_DIS
**/
  UINT8                       DisableMc1Ch2;

/** Offset 0x01DF - Controller 1 Channel 3 DIMM Control
  Enable / Disable DIMMs on Controller 1 Channel 3
  $EN_DIS
**/
  UINT8                       DisableMc1Ch3;

/** Offset 0x01E0 - Scrambler Support
  This option enables data scrambling in memory.
  $EN_DIS
**/
  UINT8                       ScramblerSupport;

/** Offset 0x01E1 - SPD Profile Selected
  Select DIMM timing profile. Options are 0:Default SPD Profile, 1:Custom Profile,
  2:XMP Profile 1, 3:XMP Profile 2, 4:XMP Profile 3, 5:XMP User Profile 4, 6:XMP
  User Profile 5
  0:Default SPD Profile, 1:Custom Profile, 2:XMP Profile 1, 3:XMP Profile 2, 4:XMP
  Profile 3, 5:XMP User Profile 4, 6:XMP User Profile 5
**/
  UINT8                       SpdProfileSelected;

/** Offset 0x01E2 - Memory Reference Clock
  100MHz, 133MHz.
  0:133MHz, 1:100MHz
**/
  UINT8                       RefClk;

/** Offset 0x01E3
**/
  UINT8                       UnusedUpdSpace3;

/** Offset 0x01E4 - Memory Voltage
  DRAM voltage (Vdd) (supply voltage for input buffers and core logic of the DRAM
  chips) in millivolts from 0 - default to 1435mv.
**/
  UINT16                      VddVoltage;

/** Offset 0x01E6 - Memory Ratio
  Automatic or the frequency will equal ratio times reference clock. Set to Auto to
  recalculate memory timings listed below.
  0:Auto, 4:4, 5:5, 6:6, 7:7, 8:8, 9:9, 10:10, 11:11, 12:12, 13:13, 14:14, 15:15
**/
  UINT8                       Ratio;

/** Offset 0x01E7 - tCL
  CAS Latency, 0: AUTO, max: 31. Only used if FspmUpd->FspmConfig.SpdProfileSelected
  == 1 (Custom Profile).
**/
  UINT8                       tCL;

/** Offset 0x01E8 - tCWL
  Min CAS Write Latency Delay Time, 0: AUTO, max: 34. Only used if FspmUpd->FspmConfig.SpdProfileSelected
  == 1 (Custom Profile).
**/
  UINT8                       tCWL;

/** Offset 0x01E9
**/
  UINT8                       UnusedUpdSpace4;

/** Offset 0x01EA - tFAW
  Min Four Activate Window Delay Time, 0: AUTO, max: 63. Only used if FspmUpd->FspmConfig.SpdProfileSelected
  == 1 (Custom Profile).
**/
  UINT16                      tFAW;

/** Offset 0x01EC - tRAS
  RAS Active Time, 0: AUTO, max: 64. Only used if FspmUpd->FspmConfig.SpdProfileSelected
  == 1 (Custom Profile).
**/
  UINT16                      tRAS;

/** Offset 0x01EE - tRCD/tRP
  RAS to CAS delay time and Row Precharge delay time, 0: AUTO, max: 63. Only used
  if FspmUpd->FspmConfig.SpdProfileSelected == 1 (Custom Profile).
**/
  UINT8                       tRCDtRP;

/** Offset 0x01EF
**/
  UINT8                       UnusedUpdSpace5;

/** Offset 0x01F0 - tREFI
  Refresh Interval, 0: AUTO, max: 65535. Only used if FspmUpd->FspmConfig.SpdProfileSelected
  == 1 (Custom Profile).
**/
  UINT16                      tREFI;

/** Offset 0x01F2 - tRFC
  Min Refresh Recovery Delay Time, 0: AUTO, max: 1023. Only used if FspmUpd->FspmConfig.SpdProfileSelected
  == 1 (Custom Profile).
**/
  UINT16                      tRFC;

/** Offset 0x01F4 - tRRD
  Min Row Active to Row Active Delay Time, 0: AUTO, max: 15. Only used if FspmUpd->FspmConfig.SpdProfileSelected
  == 1 (Custom Profile).
**/
  UINT8                       tRRD;

/** Offset 0x01F5 - tRTP
  Min Internal Read to Precharge Command Delay Time, 0: AUTO, max: 15. DDR4 legal
  values: 5, 6, 7, 8, 9, 10, 12. Only used if FspmUpd->FspmConfig.SpdProfileSelected
  == 1 (Custom Profile).
**/
  UINT8                       tRTP;

/** Offset 0x01F6 - tWR
  Min Write Recovery Time, 0: AUTO, legal values: 5, 6, 7, 8, 10, 12, 14, 16, 18,
  20, 24, 30, 34, 40. Only used if FspmUpd->FspmConfig.SpdProfileSelected == 1 (Custom Profile).
  0:Auto, 5:5, 6:6, 7:7, 8:8, 10:10, 12:12, 14:14, 16:16, 18:18, 20:20, 24:24, 30:30,
  34:34, 40:40
**/
  UINT8                       tWR;

/** Offset 0x01F7 - tWTR
  Min Internal Write to Read Command Delay Time, 0: AUTO, max: 28. Only used if FspmUpd->FspmConfig.SpdProfileSelected
  == 1 (Custom Profile).
**/
  UINT8                       tWTR;

/** Offset 0x01F8 - NMode
  System command rate, range 0-2, 0 means auto, 1 = 1N, 2 = 2N
**/
  UINT8                       NModeSupport;

/** Offset 0x01F9 - Enable Intel HD Audio (Azalia)
  0: Disable, 1: Enable (Default) Azalia controller
  $EN_DIS
**/
  UINT8                       PchHdaEnable;

/** Offset 0x01FA - Enable PCH ISH Controller
  0: Disable, 1: Enable (Default) ISH Controller
  $EN_DIS
**/
  UINT8                       PchIshEnable;

/** Offset 0x01FB - CPU Trace Hub Mode
  Select 'Host Debugger' if Trace Hub is used with host debugger tool or 'Target Debugger'
  if Trace Hub is used by target debugger software or 'Disable' trace hub functionality.
  0: Disable, 1:Target Debugger Mode, 2:Host Debugger Mode
**/
  UINT8                       CpuTraceHubMode;

/** Offset 0x01FC - CPU Trace Hub Memory Region 0
  CPU Trace Hub Memory Region 0, The avaliable memory size is : 0MB, 1MB, 8MB, 64MB,
  128MB, 256MB, 512MB
  0:0, 1:1MB, 2:8MB, 3:64MB, 4:128MB, 5:256MB, 6:512MB
**/
  UINT8                       CpuTraceHubMemReg0Size;

/** Offset 0x01FD - CPU Trace Hub Memory Region 1
  CPU Trace Hub Memory Region 1. The avaliable memory size is : 0MB, 1MB, 8MB, 64MB,
  128MB, 256MB, 512MB
  0:0, 1:1MB, 2:8MB, 3:64MB, 4:128MB, 5:256MB, 6:512MB
**/
  UINT8                       CpuTraceHubMemReg1Size;

/** Offset 0x01FE - SAGV Gear Ratio
  Gear Selection for SAGV points. 0 - Auto, 1-1 Gear 1, 2-Gear 2
**/
  UINT8                       SaGvGear[4];

/** Offset 0x0202 - SAGV Frequency
  SAGV Frequency per point in Mhz. 0 for Auto and a ratio of 133/100MHz: 1333/1300.
**/
  UINT16                      SaGvFreq[4];

/** Offset 0x020A - SAGV Disabled Gear Ratio
  Gear Selection for SAGV Disabled. 0 - Auto, 1-1 Gear 1, 2-Gear 2
**/
  UINT8                       GearRatio;

/** Offset 0x020B - HECI Timeouts
  0: Disable, 1: Enable (Default) timeout check for HECI
  $EN_DIS
**/
  UINT8                       HeciTimeouts;

/** Offset 0x020C - HECI1 BAR address
  BAR address of HECI1
**/
  UINT32                      Heci1BarAddress;

/** Offset 0x0210 - HECI2 BAR address
  BAR address of HECI2
**/
  UINT32                      Heci2BarAddress;

/** Offset 0x0214 - HECI3 BAR address
  BAR address of HECI3
**/
  UINT32                      Heci3BarAddress;

/** Offset 0x0218 - HG dGPU Power Delay
  HG dGPU delay interval after power enabling: 0=Minimal, 1000=Maximum, default is
  300=300 microseconds
**/
  UINT16                      HgDelayAfterPwrEn;

/** Offset 0x021A - HG dGPU Reset Delay
  HG dGPU delay interval for Reset complete: 0=Minimal, 1000=Maximum, default is 100=100
  microseconds
**/
  UINT16                      HgDelayAfterHoldReset;

/** Offset 0x021C - MMIO size adjustment for AUTO mode
  Positive number means increasing MMIO size, Negative value means decreasing MMIO
  size: 0 (Default)=no change to AUTO mode MMIO size
**/
  UINT16                      MmioSizeAdjustment;

/** Offset 0x021E - PCIe ASPM programming will happen in relation to the Oprom
  Select when PCIe ASPM programming will happen in relation to the Oprom. Before(0x0)(Default):
  Do PCIe ASPM programming before Oprom, After(0x1): Do PCIe ASPM programming after
  Oprom, requires an SMI handler to save/restore ASPM settings during S3 resume
  0:Before, 1:After
**/
  UINT8                       InitPcieAspmAfterOprom;

/** Offset 0x021F - Selection of the primary display device
  0=iGFX, 1=PEG, 2=PCIe Graphics on PCH, 3(Default)=AUTO, 4=Hybrid Graphics
  0:iGFX, 1:PEG, 2:PCIe Graphics on PCH, 3:AUTO, 4:Hybrid Graphics
**/
  UINT8                       PrimaryDisplay;

/** Offset 0x0220 - Selection of PSMI Region size
  0=32MB, 1=288MB, 2=544MB, 3=800MB, 4=1024MB Default is 0
  0:32MB, 1:288MB, 2:544MB, 3:800MB, 4:1024MB
**/
  UINT8                       PsmiRegionSize;

/** Offset 0x0221
**/
  UINT8                       UnusedUpdSpace6[3];

/** Offset 0x0224 - Temporary MMIO address for GMADR
  Obsolete field now and it has been extended to 64 bit address, used GmAdr64
**/
  UINT32                      GmAdr;

/** Offset 0x0228 - Temporary MMIO address for GTTMMADR
  The reference code will use this as Temporary MMIO address space to access GTTMMADR
  Registers.Platform should provide conflict free Temporary MMIO Range: GttMmAdr
  to (GttMmAdr + 2MB MMIO + 6MB Reserved + GttSize). Default is (GmAdr - (2MB MMIO
  + 6MB Reserved + GttSize)) to (GmAdr - 0x1) (Where GttSize = 8MB)
**/
  UINT32                      GttMmAdr;

/** Offset 0x022C - Selection of iGFX GTT Memory size
  1=2MB, 2=4MB, 3=8MB, Default is 3
  1:2MB, 2:4MB, 3:8MB
**/
  UINT16                      GttSize;

/** Offset 0x022E - Hybrid Graphics GPIO information for PEG 0
  Hybrid Graphics GPIO information for PEG 0, for Reset, power and wake GPIOs
**/
  UINT8                       CpuPcie0Rtd3Gpio[24];

/** Offset 0x0246 - Enable/Disable MRC TXT dependency
  When enabled MRC execution will wait for TXT initialization to be done first. Disabled(0x0)(Default):
  MRC will not wait for TXT initialization, Enabled(0x1): MRC will wait for TXT initialization
  $EN_DIS
**/
  UINT8                       TxtImplemented;

/** Offset 0x0247 - Enable/Disable SA OcSupport
  Enable: Enable SA OcSupport, Disable(Default): Disable SA OcSupport
  $EN_DIS
**/
  UINT8                       SaOcSupport;

/** Offset 0x0248 - GT slice Voltage Mode
  0(Default): Adaptive, 1: Override
  0: Adaptive, 1: Override
**/
  UINT8                       GtVoltageMode;

/** Offset 0x0249 - Maximum GTs turbo ratio override
  0(Default)=Minimal/Auto, 60=Maximum
**/
  UINT8                       GtMaxOcRatio;

/** Offset 0x024A - The voltage offset applied to GT slice
  0(Default)=Minimal, 1000=Maximum
**/
  UINT16                      GtVoltageOffset;

/** Offset 0x024C - The GT slice voltage override which is applied to the entire range of GT frequencies
  0(Default)=Minimal, 2000=Maximum
**/
  UINT16                      GtVoltageOverride;

/** Offset 0x024E - adaptive voltage applied during turbo frequencies
  0(Default)=Minimal, 2000=Maximum
**/
  UINT16                      GtExtraTurboVoltage;

/** Offset 0x0250 - voltage offset applied to the SA
  0(Default)=Minimal, 1000=Maximum
**/
  UINT16                      SaVoltageOffset;

/** Offset 0x0252 - PCIe root port Function number for Hybrid Graphics dGPU
  Root port Index number to indicate which PCIe root port has dGPU
**/
  UINT8                       RootPortIndex;

/** Offset 0x0253 - Realtime Memory Timing
  0(Default): Disabled, 1: Enabled. When enabled, it will allow the system to perform
  realtime memory timing changes after MRC_DONE.
  0: Disabled, 1: Enabled
**/
  UINT8                       RealtimeMemoryTiming;

/** Offset 0x0254 - iTBT PCIe Multiple Segment setting
  DEPRECATED
  $EN_DIS
**/
  UINT8                       PcieMultipleSegmentEnabled;

/** Offset 0x0255 - Enable/Disable SA IPU
  Enable(Default): Enable SA IPU, Disable: Disable SA IPU
  $EN_DIS
**/
  UINT8                       SaIpuEnable;

/** Offset 0x0256 - Lane Used of CSI port
   Lane Used of each CSI port
   1:x1, 2:x2, 3:x3, 4:x4, 8:x8
**/
  UINT8                       IpuLaneUsed[8];

/** Offset 0x025E - Lane Used of CSI port
   Speed of each CSI port
  0:Sensor default, 1:<416Mbps, 2:<1.5Gbps, 3:<2Gbps, 4:<2.5Gbps, 5:<4Gbps, 6:>4Gbps
**/
  UINT8                       CsiSpeed[8];

/** Offset 0x0266 - IMGU CLKOUT Configuration
  The configuration of IMGU CLKOUT, 0: Disable;<b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       ImguClkOutEn[6];

/** Offset 0x026C - Enable PCIE RP Mask
  Enable/disable PCIE Root Ports. 0: disable, 1: enable. One bit for each port, bit0
  for port1, bit1 for port2, and so on.
**/
  UINT32                      CpuPcieRpEnableMask;

/** Offset 0x0270 - Assertion on Link Down GPIOs
  GPIO Assertion on Link Down. Disabled(0x0)(Default): Disable assertion on Link Down
  GPIOs, Enabled(0x1): Enable assertion on Link Down GPIOs
  0:Disable, 1:Enable
**/
  UINT8                       CpuPcieRpLinkDownGpios;

/** Offset 0x0271 - Enable ClockReq Messaging
  ClockReq Messaging. Disabled(0x0): Disable ClockReq Messaging, Enabled(0x1)(Default):
  Enable ClockReq Messaging
  0:Disable, 1:Enable
**/
  UINT8                       CpuPcieRpClockReqMsgEnable[3];

/** Offset 0x0274 - PCIE RP Pcie Speed
  Determines each PCIE Port speed capability. 0: Auto; 1: Gen1; 2: Gen2; 3: Gen3;
  4: Gen4 (see: CPU_PCIE_SPEED).
**/
  UINT8                       CpuPcieRpPcieSpeed[4];

/** Offset 0x0278 - Selection of PSMI Support On/Off
  0(Default) = FALSE, 1 = TRUE. When TRUE, it will allow the PSMI Support
  $EN_DIS
**/
  UINT8                       GtPsmiSupport;

/** Offset 0x0279 - Program GPIOs for LFP on DDI port-A device
  0=Disabled,1(Default)=eDP, 2=MIPI DSI
  0:Disabled, 1:eDP, 2:MIPI DSI
**/
  UINT8                       DdiPortAConfig;

/** Offset 0x027A - Program GPIOs for LFP on DDI port-B device
  0(Default)=Disabled,1=eDP, 2=MIPI DSI
  0:Disabled, 1:eDP, 2:MIPI DSI
**/
  UINT8                       DdiPortBConfig;

/** Offset 0x027B - Enable or disable HPD of DDI port A
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       DdiPortAHpd;

/** Offset 0x027C - Enable or disable HPD of DDI port B
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       DdiPortBHpd;

/** Offset 0x027D - Enable or disable HPD of DDI port C
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       DdiPortCHpd;

/** Offset 0x027E - Enable or disable HPD of DDI port 1
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       DdiPort1Hpd;

/** Offset 0x027F - Enable or disable HPD of DDI port 2
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       DdiPort2Hpd;

/** Offset 0x0280 - Enable or disable HPD of DDI port 3
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       DdiPort3Hpd;

/** Offset 0x0281 - Enable or disable HPD of DDI port 4
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       DdiPort4Hpd;

/** Offset 0x0282 - Enable or disable DDC of DDI port A
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       DdiPortADdc;

/** Offset 0x0283 - Enable or disable DDC of DDI port B
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       DdiPortBDdc;

/** Offset 0x0284 - Enable or disable DDC of DDI port C
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       DdiPortCDdc;

/** Offset 0x0285 - Enable DDC setting of DDI Port 1
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       DdiPort1Ddc;

/** Offset 0x0286 - Enable DDC setting of DDI Port 2
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       DdiPort2Ddc;

/** Offset 0x0287 - Enable DDC setting of DDI Port 3
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       DdiPort3Ddc;

/** Offset 0x0288 - Enable DDC setting of DDI Port 4
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       DdiPort4Ddc;

/** Offset 0x0289
**/
  UINT8                       UnusedUpdSpace7[7];

/** Offset 0x0290 - Temporary MMIO address for GMADR
  The reference code will use this as Temporary MMIO address space to access GMADR
  Registers.Platform should provide conflict free Temporary MMIO Range: GmAdr to
  (GmAdr + ApertureSize). Default is (PciExpressBaseAddress - ApertureSize) to (PciExpressBaseAddress
  - 0x1) (Where ApertureSize = 256MB, 512MB, 1024MB , 2048MB and 4096MB)
**/
  UINT64                      GmAdr64;

/** Offset 0x0298 - Per-core HT Disable
  Defines the per-core HT disable mask where: 1 - Disable selected logical core HT,
  0 - is ignored. Input is in HEX and each bit maps to a logical core. Ex. A value
  of '1F' would disable HT for cores 4,3,2,1 and 0. Default is 0, all cores have
  HT enabled. Range is 0 - 0x7F for max 8 cores. You can only disable up to MAX_CORE_COUNT - 1.
**/
  UINT16                      PerCoreHtDisable;

/** Offset 0x029A - SA/Uncore voltage mode
  SA/Uncore voltage mode; <b>0: Adaptive</b>; 1: Override.
  $EN_DIS
**/
  UINT8                       SaVoltageMode;

/** Offset 0x029B
**/
  UINT8                       UnusedUpdSpace8;

/** Offset 0x029C - SA/Uncore Voltage Override
  The SA/Uncore voltage override applicable when SA/Uncore voltage mode is in Override
  mode. Valid Range 0 to 2000
**/
  UINT16                      SaVoltageOverride;

/** Offset 0x029E - SA/Uncore Extra Turbo voltage
  Extra Turbo voltage applicable when SA/Uncore voltage mode is in Adaptive mode.
  Valid Range 0 to 2000
**/
  UINT16                      SaExtraTurboVoltage;

/** Offset 0x02A0 - Thermal Velocity Boost Ratio clipping
  0(Default): Disabled, 1: Enabled. This service controls Core frequency reduction
  caused by high package temperatures for processors that implement the Intel Thermal
  Velocity Boost (TVB) feature
  0: Disabled, 1: Enabled
**/
  UINT8                       TvbRatioClipping;

/** Offset 0x02A1 - Thermal Velocity Boost voltage optimization
  0: Disabled, 1: Enabled(Default). This service controls thermal based voltage optimizations
  for processors that implement the Intel Thermal Velocity Boost (TVB) feature.
  0: Disabled, 1: Enabled
**/
  UINT8                       TvbVoltageOptimization;

/** Offset 0x02A2 - Enable/Disable Display Audio Link in Pre-OS
  0(Default)= Disable, 1 = Enable
  0: Disabled, 1: Enabled
**/
  UINT8                       DisplayAudioLink;

/** Offset 0x02A3
**/
  UINT8                       UnusedUpdSpace9;

/** Offset 0x02A4 - Memory VDDQ Voltage
  DRAM voltage (Vddq) (supply voltage for DQ/DQS of the DRAM chips) in millivolts
  from 0 - default to 1435mv.
**/
  UINT16                      VddqVoltage;

/** Offset 0x02A6 - Memory VPP Voltage
  DRAM voltage (Vpp) (supply voltage for VPP of the DRAM chips) in millivolts from
  0 - default to 2135mv.
**/
  UINT16                      VppVoltage;

/** Offset 0x02A8 - CPU PCIe New FOM
  Enable/Disable NewFom for DEKEL Programming. 0: Disable(Default); 1: Enable
  $EN_DIS
**/
  UINT8                       CpuPcieNewFom[4];

/** Offset 0x02AC - DMI DEKEL New FOM
  Enable/Disable NewFom for DEKEL Programming. 0: Disable(Default); 1: Enable
  $EN_DIS
**/
  UINT8                       DmiNewFom;

/** Offset 0x02AD - Dynamic Memory Boost
  0(Default): Disable, 1: Enable. When enabled, MRC will train the Default SPD Profile,
  and also the profile selected by SpdProfileSelected, to allow automatic switching
  during runtime. Only valid if SpdProfileSelected is an XMP Profile, otherwise ignored.
  $EN_DIS
**/
  UINT8                       DynamicMemoryBoost;

/** Offset 0x02AE - Hybrid Graphics Support
  0(Default): PEG10, 1: PEG60, 2:PEG62. Help to select Hybrid Graphics Support on Peg Port
**/
  UINT8                       HgSupport;

/** Offset 0x02AF - Realtime Memory Frequency
  0(Default): Disabled, 1: Enabled. Ignored unless SpdProfileSelected is an XMP Profile.
  If enabled, MRC will train the Default SPD Profile, and also the selected XMP Profile,
  to allow manually triggered switching between frequencies at runtime.
  $EN_DIS
**/
  UINT8                       RealtimeMemoryFrequency;

/** Offset 0x02B0 - SaPreMemProductionRsvd
  Reserved for SA Pre-Mem Production
  $EN_DIS
**/
  UINT8                       SaPreMemProductionRsvd[97];

/** Offset 0x0311 - Enable Gt CLOS
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       GtClosEnable;

/** Offset 0x0312 - DMI Max Link Speed
  Auto (Default)(0x0): Maximum possible link speed, Gen1(0x1): Limit Link to Gen1
  Speed, Gen2(0x2): Limit Link to Gen2 Speed, Gen3(0x3):Limit Link to Gen3 Speed
  0:Auto, 1:Gen1, 2:Gen2, 3:Gen3
**/
  UINT8                       DmiMaxLinkSpeed;

/** Offset 0x0313 - DMI Equalization Phase 2
  DMI Equalization Phase 2. (0x0): Disable phase 2, (0x1): Enable phase 2, (0x2)(Default):
  AUTO - Use the current default method
  0:Disable phase2, 1:Enable phase2, 2:Auto
**/
  UINT8                       DmiGen3EqPh2Enable;

/** Offset 0x0314 - DMI Gen3 Equalization Phase3
  DMI Gen3 Equalization Phase3. Auto(0x0)(Default): Use the current default method,
  HwEq(0x1): Use Adaptive Hardware Equalization, SwEq(0x2): Use Adaptive Software
  Equalization (Implemented in BIOS Reference Code), Static(0x3): Use the Static
  EQs provided in DmiGen3EndPointPreset array for Phase1 AND Phase3 (Instead of just
  Phase1), Disabled(0x4): Bypass Equalization Phase 3
  0:Auto, 1:HwEq, 2:SwEq, 3:StaticEq, 4:BypassPhase3
**/
  UINT8                       DmiGen3EqPh3Method;

/** Offset 0x0315 - Enable/Disable DMI GEN3 Static EQ Phase1 programming
  Program DMI Gen3 EQ Phase1 Static Presets. Disabled(0x0): Disable EQ Phase1 Static
  Presets Programming, Enabled(0x1)(Default): Enable  EQ Phase1 Static Presets Programming
  $EN_DIS
**/
  UINT8                       DmiGen3ProgramStaticEq;

/** Offset 0x0316 - DeEmphasis control for DMI
  DeEmphasis control for DMI. 0=-6dB, 1(Default)=-3.5 dB
  0: -6dB, 1: -3.5dB
**/
  UINT8                       DmiDeEmphasis;

/** Offset 0x0317 - DMI Gen3 Root port preset values per lane
  Used for programming DMI Gen3 preset values per lane. Range: 0-9, 8 is default for each lane
**/
  UINT8                       DmiGen3RootPortPreset[8];

/** Offset 0x031F - DMI Gen3 End port preset values per lane
  Used for programming DMI Gen3 preset values per lane. Range: 0-9, 7 is default for each lane
**/
  UINT8                       DmiGen3EndPointPreset[8];

/** Offset 0x0327 - DMI Gen3 End port Hint values per lane
  Used for programming DMI Gen3 Hint values per lane. Range: 0-6, 2 is default for each lane
**/
  UINT8                       DmiGen3EndPointHint[8];

/** Offset 0x032F - DMI Gen3 RxCTLEp per-Bundle control
  Range: 0-15, 0 is default for each bundle, must be specified based upon platform design
**/
  UINT8                       DmiGen3RxCtlePeaking[4];

/** Offset 0x0333 - DMI ASPM Configuration:{Combo
  Set ASPM Configuration
  0:Disabled, 1:L0s, 2:L1, 3:L1L0s
**/
  UINT8                       DmiAspm;

/** Offset 0x0334 - Enable/Disable DMI GEN3 Hardware Eq
  Enable/Disable DMI GEN3 Hardware Eq. Disabled(0x0)(Default): Disable Hardware Eq,
  Enabled(0x1): Enable  EQ Phase1 Static Presets Programming
  $EN_DIS
**/
  UINT8                       DmiHweq;

/** Offset 0x0335 - Enable/Disable CPU DMI GEN3 Phase 23 Bypass
  CPU DMI GEN3 Phase 23 Bypass. Disabled(0x0)(Default): Disable Phase 23 Bypass, Enabled(0x1):
  Enable  Phase 23 Bypass
  $EN_DIS
**/
  UINT8                       Gen3EqPhase23Bypass;

/** Offset 0x0336 - Enable/Disable CPU DMI GEN3 Phase 3 Bypass
  CPU DMI GEN3 Phase 3 Bypass. Disabled(0x0)(Default): Disable Phase 3 Bypass, Enabled(0x1):
  Enable  Phase 3 Bypass
  $EN_DIS
**/
  UINT8                       Gen3EqPhase3Bypass;

/** Offset 0x0337 - Enable/Disable CPU DMI Gen3 EQ Local Transmitter Coefficient Override Enable
  Program Gen3 EQ Local Transmitter Coefficient Override. Disabled(0x0)(Default):
  Disable Local Transmitter Coefficient Override, Enabled(0x1): Enable  Local Transmitter
  Coefficient Override
  $EN_DIS
**/
  UINT8                       Gen3LtcoEnable;

/** Offset 0x0338 - Enable/Disable CPU DMI Gen3 EQ Remote Transmitter Coefficient/Preset Override Enable
  Program Remote Transmitter Coefficient/Preset Override. Disabled(0x0)(Default):
  Disable Remote Transmitter Coefficient/Preset Override, Enabled(0x1): Enable  Remote
  Transmitter Coefficient/Preset Override
  $EN_DIS
**/
  UINT8                       Gen3RtcoRtpoEnable;

/** Offset 0x0339 - DMI Gen3 Transmitter Pre-Cursor Coefficient
  Used for programming DMI Gen3 Transmitter Pre-Cursor Coefficient . Range: 0-10,
  2 is default for each lane
**/
  UINT8                       DmiGen3Ltcpre[8];

/** Offset 0x0341 - DMI Gen3 Transmitter Post-Cursor Coefficient
  Used for programming Transmitter Post-Cursor Coefficient. Range: 0-9, 2 is default
  for each lane
**/
  UINT8                       DmiGen3Ltcpo[8];

/** Offset 0x0349 - PCIE Hw Eq Gen3 CoeffList Cm
  CPU_PCIE_EQ_PARAM. Coefficient C-1.
**/
  UINT8                       CpuDmiHwEqGen3CoeffListCm[8];

/** Offset 0x0351 - PCIE Hw Eq Gen3 CoeffList Cp
  CPU_PCIE_EQ_PARAM. Coefficient C+1.
**/
  UINT8                       CpuDmiHwEqGen3CoeffListCp[8];

/** Offset 0x0359 - Enable/Disable DMI GEN3 DmiGen3DsPresetEnable
  Enable/Disable DMI GEN3 DmiGen3DsPreset. Auto(0x0)(Default): DmiGen3DsPresetEnable,
  Manual(0x1): Enable DmiGen3DsPresetEnable
  $EN_DIS
**/
  UINT8                       DmiGen3DsPresetEnable;

/** Offset 0x035A - DMI Gen3 Root port preset Rx values per lane
  Used for programming DMI Gen3 preset values per lane. Range: 0-10, 1 is default
  for each lane
**/
  UINT8                       DmiGen3DsPortRxPreset[8];

/** Offset 0x0362 - DMI Gen3 Root port preset Tx values per lane
  Used for programming DMI Gen3 preset values per lane. Range: 0-10, 7 is default
  for each lane
**/
  UINT8                       DmiGen3DsPortTxPreset[8];

/** Offset 0x036A - Enable/Disable DMI GEN3 DmiGen3UsPresetEnable
  Enable/Disable DMI GEN3 DmiGen3UsPreset. Auto(0x0)(Default): DmiGen3UsPresetEnable,
  Manual(0x1): Enable DmiGen3UsPresetEnable
  $EN_DIS
**/
  UINT8                       DmiGen3UsPresetEnable;

/** Offset 0x036B - DMI Gen3 Root port preset Rx values per lane
  Used for programming DMI Gen3 preset values per lane. Range: 0-10, 7 is default
  for each lane
**/
  UINT8                       DmiGen3UsPortRxPreset[8];

/** Offset 0x0373 - DMI Gen3 Root port preset Tx values per lane
  Used for programming DMI Gen3 preset values per lane. Range: 0-10, 7 is default
  for each lane
**/
  UINT8                       DmiGen3UsPortTxPreset[8];

/** Offset 0x037B - DMI Hw Eq Gen4 CoeffList Cm
  CPU_PCIE_EQ_PARAM. Coefficient C-1.
**/
  UINT8                       CpuDmiHwEqGen4CoeffListCm[8];

/** Offset 0x0383 - DMI Hw Eq Gen4 CoeffList Cp
  CPU_PCIE_EQ_PARAM. Coefficient C+1.
**/
  UINT8                       CpuDmiHwEqGen4CoeffListCp[8];

/** Offset 0x038B - Enable/Disable CPU DMI GEN4 Phase 23 Bypass
  CPU DMI GEN4 Phase 23 Bypass. Disabled(0x0)(Default): Disable Phase 23 Bypass, Enabled(0x1):
  Enable  Phase 23 Bypass
  $EN_DIS
**/
  UINT8                       Gen4EqPhase23Bypass;

/** Offset 0x038C - Enable/Disable CPU DMI GEN4 Phase 3 Bypass
  CPU DMI GEN3 Phase 4 Bypass. Disabled(0x0)(Default): Disable Phase 3 Bypass, Enabled(0x1):
  Enable  Phase 3 Bypass
  $EN_DIS
**/
  UINT8                       Gen4EqPhase3Bypass;

/** Offset 0x038D - Enable/Disable DMI GEN4 DmiGen4DsPresetEnable
  Enable/Disable DMI GEN4 DmiGen4DsPreset. Auto(0x0)(Default): DmiGen4DsPresetEnable,
  Manual(0x1): Enable DmiGen4DsPresetEnable
  $EN_DIS
**/
  UINT8                       DmiGen4DsPresetEnable;

/** Offset 0x038E - DMI Gen4 Root port preset Tx values per lane
  Used for programming DMI Gen4 preset values per lane. Range: 0-10, 7 is default
  for each lane
**/
  UINT8                       DmiGen4DsPortTxPreset[8];

/** Offset 0x0396 - Enable/Disable CPU DMI Gen4 EQ Remote Transmitter Coefficient/Preset Override Enable
  Program Remote Transmitter Coefficient/Preset Override. Disabled(0x0)(Default):
  Disable Remote Transmitter Coefficient/Preset Override, Enabled(0x1): Enable  Remote
  Transmitter Coefficient/Preset Override
  $EN_DIS
**/
  UINT8                       Gen4RtcoRtpoEnable;

/** Offset 0x0397 - Enable/Disable CPU DMI Gen4 EQ Local Transmitter Coefficient Override Enable
  Program Gen3 EQ Local Transmitter Coefficient Override. Disabled(0x0)(Default):
  Disable Local Transmitter Coefficient Override, Enabled(0x1): Enable  Local Transmitter
  Coefficient Override
  $EN_DIS
**/
  UINT8                       Gen4LtcoEnable;

/** Offset 0x0398 - DMI Gen4 Transmitter Pre-Cursor Coefficient
  Used for programming DMI Gen4 Transmitter Pre-Cursor Coefficient . Range: 0-10,
  7 is default for each lane
**/
  UINT8                       DmiGen4Ltcpre[8];

/** Offset 0x03A0 - DMI Gen4 Transmitter Post-Cursor Coefficient
  Used for programming DMI Gen4 Transmitter Post-Cursor Coefficient. Range: 0-9, 7
  is default for each lane
**/
  UINT8                       DmiGen4Ltcpo[8];

/** Offset 0x03A8 - Enable/Disable DMI GEN4 DmiGen4UsPresetEnable
  Enable/Disable DMI GEN4 DmiGen4UsPreset. Auto(0x0)(Default): DmiGen4UsPresetEnable,
  Manual(0x1): Enable DmiGen4UsPresetEnable
  $EN_DIS
**/
  UINT8                       DmiGen4UsPresetEnable;

/** Offset 0x03A9 - DMI Gen4 Root port preset Tx values per lane
  Used for programming DMI Gen4 preset values per lane. Range: 0-10, 1 is default
  for each lane
**/
  UINT8                       DmiGen4UsPortTxPreset[8];

/** Offset 0x03B1 - DMI ASPM Control Configuration:{Combo
  Set ASPM Control configuration
  0:Disabled, 1:L0s, 2:L1, 3:L1L0s
**/
  UINT8                       DmiAspmCtrl;

/** Offset 0x03B2 - DMI ASPM L1 exit Latency
  Range: 0-7, 4 is default L1 exit Latency
**/
  UINT8                       DmiAspmL1ExitLatency;

/** Offset 0x03B3 - BIST on Reset
  Enable or Disable BIST on Reset; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       BistOnReset;

/** Offset 0x03B4 - Skip Stop PBET Timer Enable/Disable
  Skip Stop PBET Timer; <b>0: Disable</b>; 1: Enable
  $EN_DIS
**/
  UINT8                       SkipStopPbet;

/** Offset 0x03B5 - C6DRAM power gating feature
  This policy indicates whether or not BIOS should allocate PRMRR memory for C6DRAM
  power gating feature.- 0: Don't allocate any PRMRR memory for C6DRAM power gating
  feature.- <b>1: Allocate PRMRR memory for C6DRAM power gating feature</b>.
  $EN_DIS
**/
  UINT8                       EnableC6Dram;

/** Offset 0x03B6 - Over clocking support
  Over clocking support; <b>0: Disable</b>; 1: Enable
  $EN_DIS
**/
  UINT8                       OcSupport;

/** Offset 0x03B7 - Over clocking Lock
  Over clocking Lock Enable/Disable; 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       OcLock;

/** Offset 0x03B8 - Maximum Core Turbo Ratio Override
  Maximum core turbo ratio override allows to increase CPU core frequency beyond the
  fused max turbo ratio limit. <b>0: Hardware defaults.</b> Range: 0-85
**/
  UINT8                       CoreMaxOcRatio;

/** Offset 0x03B9 - Core voltage mode
  Core voltage mode; <b>0: Adaptive</b>; 1: Override.
  $EN_DIS
**/
  UINT8                       CoreVoltageMode;

/** Offset 0x03BA - Maximum clr turbo ratio override
  Maximum clr turbo ratio override allows to increase CPU clr frequency beyond the
  fused max turbo ratio limit. <b>0: Hardware defaults.</b>  Range: 0-85
**/
  UINT8                       RingMaxOcRatio;

/** Offset 0x03BB - Hyper Threading Enable/Disable
  Enable or Disable Hyper Threading; 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       HyperThreading;

/** Offset 0x03BC - Enable or Disable CPU Ratio Override
  Enable or Disable CPU Ratio Override; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       CpuRatioOverride;

/** Offset 0x03BD - CPU ratio value
  CPU ratio value. Valid Range 0 to 63
**/
  UINT8                       CpuRatio;

/** Offset 0x03BE - Boot frequency
  Sets the boot frequency starting from reset vector.- 0: Maximum battery performance.
  1: Maximum non-turbo performance. <b>2: Turbo performance </b>
  0:0, 1:1, 2:2
**/
  UINT8                       BootFrequency;

/** Offset 0x03BF - Number of active big cores
  Number of active big cores(Depends on Number of big cores). Default 0xFF means to
  active all system supported big cores. <b>0xFF: Active all big cores</b>; 0: Disable
  all big cores; 1: 1; 2: 2; 3: 3;
  0:Disable all big cores, 1:1, 2:2, 3:3, 0xFF:Active all big cores
**/
  UINT8                       ActiveCoreCount;

/** Offset 0x03C0 - Processor Early Power On Configuration FCLK setting
  <b>0: 800 MHz (ULT/ULX)</b>. <b>1: 1 GHz (DT/Halo)</b>. Not supported on ULT/ULX.-
  2: 400 MHz. - 3: Reserved
  0:800 MHz, 1: 1 GHz, 2: 400 MHz, 3: Reserved
**/
  UINT8                       FClkFrequency;

/** Offset 0x03C1 - Set JTAG power in C10 and deeper power states
  False: JTAG is power gated in C10 state. True: keeps the JTAG power up during C10
  and deeper power states for debug purpose. <b>0: False</b>; 1: True.
  0: False, 1: True
**/
  UINT8                       JtagC10PowerGateDisable;

/** Offset 0x03C2 - Enable or Disable VMX
  Enable or Disable VMX; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       VmxEnable;

/** Offset 0x03C3 - AVX2 Ratio Offset
  0(Default)= No Offset. Range 0 - 31. Specifies number of bins to decrease AVX ratio
  vs. Core Ratio. Uses Mailbox MSR 0x150, cmd 0x1B.
**/
  UINT8                       Avx2RatioOffset;

/** Offset 0x03C4 - AVX3 Ratio Offset
  DEPRECATED
**/
  UINT8                       Avx3RatioOffset;

/** Offset 0x03C5 - BCLK Adaptive Voltage Enable
  When enabled, the CPU V/F curves are aware of BCLK frequency when calculated. </b>0:
  Disable;<b> 1: Enable
  $EN_DIS
**/
  UINT8                       BclkAdaptiveVoltage;

/** Offset 0x03C6 - core voltage override
  The core voltage override which is applied to the entire range of cpu core frequencies.
  Valid Range 0 to 2000
**/
  UINT16                      CoreVoltageOverride;

/** Offset 0x03C8 - Core Turbo voltage Adaptive
  Extra Turbo voltage applied to the cpu core when the cpu is operating in turbo mode.
  Valid Range 0 to 2000
**/
  UINT16                      CoreVoltageAdaptive;

/** Offset 0x03CA - Core Turbo voltage Offset
  The voltage offset applied to the core while operating in turbo mode.Valid Range 0 to 1000
**/
  UINT16                      CoreVoltageOffset;

/** Offset 0x03CC - Core PLL voltage offset
  Core PLL voltage offset. <b>0: No offset</b>. Range 0-15
**/
  UINT8                       CorePllVoltageOffset;

/** Offset 0x03CD - Atom Core PLL voltage offset
  Atom Core PLL voltage offset. <b>0: No offset</b>. Range 0-15
**/
  UINT8                       AtomPllVoltageOffset;

/** Offset 0x03CE - Ring Downbin
  Ring Downbin enable/disable. When enabled, CPU will ensure the ring ratio is always
  lower than the core ratio.0: Disable; <b>1: Enable.</b>
  $EN_DIS
**/
  UINT8                       RingDownBin;

/** Offset 0x03CF - Ring voltage mode
  Ring voltage mode; <b>0: Adaptive</b>; 1: Override.
  $EN_DIS
**/
  UINT8                       RingVoltageMode;

/** Offset 0x03D0 - TjMax Offset
  TjMax offset.Specified value here is clipped by pCode (125 - TjMax Offset) to support
  TjMax in the range of 62 to 115 deg Celsius. Valid Range 10 - 63
**/
  UINT8                       TjMaxOffset;

/** Offset 0x03D1
**/
  UINT8                       UnusedUpdSpace10;

/** Offset 0x03D2 - Ring voltage override
  The ring voltage override which is applied to the entire range of cpu ring frequencies.
  Valid Range 0 to 2000
**/
  UINT16                      RingVoltageOverride;

/** Offset 0x03D4 - Ring Turbo voltage Adaptive
  Extra Turbo voltage applied to the cpu ring when the cpu is operating in turbo mode.
  Valid Range 0 to 2000
**/
  UINT16                      RingVoltageAdaptive;

/** Offset 0x03D6 - Ring Turbo voltage Offset
  The voltage offset applied to the ring while operating in turbo mode. Valid Range 0 to 1000
**/
  UINT16                      RingVoltageOffset;

/** Offset 0x03D8 - Enable or Disable TME
  Enable or Disable TME; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       TmeEnable;

/** Offset 0x03D9 - Enable CPU CrashLog
  Enable or Disable CPU CrashLog; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       CpuCrashLogEnable;

/** Offset 0x03DA - CPU Run Control
  Enable, Disable or Do not configure CPU Run Control; 0: Disable; 1: Enable ; <b>2:
  No Change</b>
  0:Disabled, 1:Enabled, 2:No Change
**/
  UINT8                       DebugInterfaceEnable;

/** Offset 0x03DB - CPU Run Control Lock
  Lock or Unlock CPU Run Control; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       DebugInterfaceLockEnable;

/** Offset 0x03DC - Atom L2 voltage mode
  Atom L2 voltage mode; <b>0: Adaptive</b>; 1: Override.
  $EN_DIS
**/
  UINT8                       AtomL2VoltageMode;

/** Offset 0x03DD
**/
  UINT8                       UnusedUpdSpace11;

/** Offset 0x03DE - Atom L2 Voltage Override
  The atom L2 voltage override which is applied to the entire range of atom L2 frequencies.
  Valid Range 0 to 2000
**/
  UINT16                      AtomL2VoltageOverride;

/** Offset 0x03E0 - Atom L2 Turbo voltage Adaptive
  Extra Turbo voltage applied to the atom L2 when the atom L2 is operating in turbo
  mode. Valid Range 0 to 2000
**/
  UINT16                      AtomL2VoltageAdaptive;

/** Offset 0x03E2 - Atom L2 Turbo voltage Offset
  The voltage offset applied to the atom while operating in turbo mode.Valid Range 0 to 1000
**/
  UINT16                      AtomL2VoltageOffset;

/** Offset 0x03E4 - Per-Atom-Cluster VF Offset
  Array used to specifies the selected Atom Core Cluster Offset Voltage. This voltage
  is specified in millivolts.
**/
  UINT16                      PerAtomClusterVoltageOffset[4];

/** Offset 0x03EC - Per-Atom-Cluster VF Offset Prefix
  Sets the PerAtomClusterVoltageOffset value as positive or negative for the selected
  Core; <b>0: Positive </b>; 1: Negative.
**/
  UINT8                       PerAtomClusterVoltageOffsetPrefix[4];

/** Offset 0x03F0 - Enable IA CEP
  Control for enabling/disabling IA CEP (Current Excursion Protection)). <b>1: Enable</b>;
  0: Disable
  $EN_DIS
**/
  UINT8                       IaCepEnable;

/** Offset 0x03F1 - Enable GT CEP
  Control for enabling/disabling GT CEP (Current Excursion Protection)). <b>1: Enable</b>;
  0: Disable
  $EN_DIS
**/
  UINT8                       GtCepEnable;

/** Offset 0x03F2 - Enable CPU DLVR bypass mode support
  Control for enabling/disabling CPU DLVR bypass mode). <b>0: Disable</b>; 1: Enable
  $EN_DIS
**/
  UINT8                       DlvrBypassModeEnable;

/** Offset 0x03F3 - Number of active small cores
  Number of active small cores(Depends on Number of small cores). Default 0xFF means
  to active all system supported small cores. <b>0xFF: Active all small cores</b>;
  0: Disable all small cores; 1: 1; 2: 2; 3: 3;
  0:Disable all small cores, 1:1, 2:2, 3:3, 0xFF:Active all small cores
**/
  UINT8                       ActiveSmallCoreCount;

/** Offset 0x03F4 - Core VF Point Offset Mode
  Selects Core Voltage & Frequency Offset mode between Legacy and Selection modes.
  In Legacy Mode, setting a global offset for the entire VF curve. In Selection Mode,
  setting a selected VF point; <b>0: Legacy</b>; 1: Selection.
  0:Legacy, 1:Selection
**/
  UINT8                       CoreVfPointOffsetMode;

/** Offset 0x03F5
**/
  UINT8                       UnusedUpdSpace12[1];

/** Offset 0x03F6 - Core VF Point Offset
  Array used to specifies the Core Voltage Offset applied to the each selected VF
  Point. This voltage is specified in millivolts.
**/
  UINT16                      CoreVfPointOffset[15];

/** Offset 0x0414 - Core VF Point Offset Prefix
  Sets the CoreVfPointOffset value as positive or negative for corresponding core
  VF Point; <b>0: Positive </b>; 1: Negative.
  0:Positive, 1:Negative
**/
  UINT8                       CoreVfPointOffsetPrefix[15];

/** Offset 0x0423 - Core VF Point Ratio
  Array for the each selected Core VF Point to display the ration.
**/
  UINT8                       CoreVfPointRatio[15];

/** Offset 0x0432 - Core VF Point Count
  Number of supported Core Voltage & Frequency Point Offset
**/
  UINT8                       CoreVfPointCount;

/** Offset 0x0433 - Core VF Configuration Scope
  Alows both all-core VF curve or per-core VF curve configuration; <b>0: All-core</b>;
  1: Per-core.
  0:All-core, 1:Per-core
**/
  UINT8                       CoreVfConfigScope;

/** Offset 0x0434 - Per-core VF Offset
  Array used to specifies the selected Core Offset Voltage. This voltage is specified
  in millivolts.
**/
  UINT16                      PerCoreVoltageOffset[8];

/** Offset 0x0444 - Per-core VF Offset Prefix
  Sets the PerCoreVoltageOffset value as positive or negative for the selected Core;
  <b>0: Positive </b>; 1: Negative.
**/
  UINT8                       PerCoreVoltageOffsetPrefix[8];

/** Offset 0x044C - Per Core Max Ratio override
  Enable or disable Per Core PState OC supported by writing OCMB 0x1D to program new
  favored core ratio to each Core. <b>0: Disable</b>, 1: enable
  $EN_DIS
**/
  UINT8                       PerCoreRatioOverride;

/** Offset 0x044D - Per Core Current Max Ratio
  Array for the Per Core Max Ratio
**/
  UINT8                       PerCoreRatio[8];

/** Offset 0x0455 - Atom Cluster Max Ratio
  Array for Atom Cluster Max Ratio, 4 ATOM cores are in the same Cluster and their
  max core ratio will be aligned.
**/
  UINT8                       AtomClusterRatio[4];

/** Offset 0x0459 - Core Ratio Extension Mode
  Enable or disable Core Ratio above 85 Extension Mode by writing BIOS MB 0x37 to
  enable FULL_RANGE_MULTIPLIER_UNLOCK_EN. <b>0: Disable</b>, 1: enable
  $EN_DIS
**/
  UINT8                       CoreRatioExtensionMode;

/** Offset 0x045A - Pvd Ratio Threshold
  Select PVD Ratio Threshold Value from Range 1 to 40. 0 - Auto/Default.
**/
  UINT8                       PvdRatioThreshold;

/** Offset 0x045B - Support Unlimited ICCMAX
  DEPRECATED
  $EN_DIS
**/
  UINT8                       UnlimitedIccMax;

/** Offset 0x045C - Enable CPU CrashLog GPRs dump
  Enable or Disable CPU CrashLog GPRs dump; <b>0: Disable</b>; 1: Enable; 2: Only
  disable Smm GPRs dump
  0:Disabled, 1:Enabled, 2:Only Smm GPRs Disabled
**/
  UINT8                       CrashLogGprs;

/** Offset 0x045D - Ring VF Point Offset Mode
  Selects Ring Voltage & Frequency Offset mode between Legacy and Selection modes.
  In Legacy Mode, setting a global offset for the entire VF curve. In Selection Mode,
  setting a selected VF point; <b>0: Legacy</b>; 1: Selection.
  0:Legacy, 1:Selection
**/
  UINT8                       RingVfPointOffsetMode;

/** Offset 0x045E - Ring VF Point Offset
  Array used to specifies the Ring Voltage Offset applied to the each selected VF
  Point. This voltage is specified in millivolts.
**/
  UINT16                      RingVfPointOffset[15];

/** Offset 0x047C - Ring VF Point Offset Prefix
  Sets the RingVfPointOffset value as positive or negative for corresponding core
  VF Point; <b>0: Positive </b>; 1: Negative.
**/
  UINT8                       RingVfPointOffsetPrefix[15];

/** Offset 0x048B - Ring VF Point Ratio
  Array for the each selected Ring VF Point to display the ration.
**/
  UINT8                       RingVfPointRatio[15];

/** Offset 0x049A - Ring VF Point Count
  Number of supported Ring Voltage & Frequency Point Offset
**/
  UINT8                       RingVfPointCount;

/** Offset 0x049B - BCLK Frequency Source
  Clock source of BCLK OC frequency, <b>1:CPU BCLK</b>, 2:PCH BCLK, 3:External CLK
  1:CPU BCLK, 2:PCH BCLK, 3:External CLK
**/
  UINT8                       BclkSource;

/** Offset 0x049C - GPIO Override
  Gpio Override Level - FSP will not configure any GPIOs and rely on GPIO setings
  before moved to FSP. Available configurations 0: Disable; 1: Level 1 - Skips GPIO
  configuration in PEI/FSPM/FSPT phase;2: Level 2 - Reserved for future use
**/
  UINT8                       GpioOverride;

/** Offset 0x049D
**/
  UINT8                       UnusedUpdSpace13[3];

/** Offset 0x04A0 - CPU BCLK OC Frequency
  CPU BCLK OC Frequency in 10KHz units increasing. Value 9800 (10KHz) = 98MHz <b>0
  - Auto</b>. Range is 8000-50000 (10KHz).
**/
  UINT32                      CpuBclkOcFrequency;

/** Offset 0x04A4 - Bitmask of disable cores
  Core mask is a bitwise indication of which core should be disabled. <b>0x00=Default</b>;
  Bit 0 - core 0, bit 7 - core 7.
**/
  UINT32                      DisablePerCoreMask;

/** Offset 0x04A8 - Bitmask of disable atoms
  DEPRECATED
**/
  UINT32                      DisablePerAtomMask;

/** Offset 0x04AC - Sa PLL Frequency
  Configure Sa PLL Frequency. <b>0: 3200MHz </b>, 1: 1600MHz
  0: 3200MHz, 1: 1600MHz
**/
  UINT8                       SaPllFreqOverride;

/** Offset 0x04AD - Skip override boot mode When Fw Update.
  When set to TRUE and boot mode is BOOT_ON_FLASH_UPDATE, skip setting boot mode to
  BOOT_WITH_FULL_CONFIGURATION in PEI memory init.
  $EN_DIS
**/
  UINT8                       SiSkipOverrideBootModeWhenFwUpdate;

/** Offset 0x04AE - TSC HW Fixup disable
  TSC HW Fixup disable during TSC copy from PMA to APIC. <b>0: Enable</b>; 1: Disable
  0:Enable, 1:Disable
**/
  UINT8                       TscDisableHwFixup;

/** Offset 0x04AF - Support IA Unlimited ICCMAX
  Support IA Unlimited ICCMAX up to maximum value 512A; <b>0: Disabled</b>; 1: Enabled.
  $EN_DIS
**/
  UINT8                       IaIccUnlimitedMode;

/** Offset 0x04B0 - IA ICCMAX
  IA ICCMAX value is represented in 1/4 A increments. A value of 400 = 100A. <b>4
  </b>. Range is 4-2047.
**/
  UINT16                      IaIccMax;

/** Offset 0x04B2 - Support GT Unlimited ICCMAX
  Support GT Unlimited ICCMAX up to maximum value 512A; <b>0: Disabled</b>; 1: Enabled.
  $EN_DIS
**/
  UINT8                       GtIccUnlimitedMode;

/** Offset 0x04B3
**/
  UINT8                       UnusedUpdSpace14;

/** Offset 0x04B4 - GT ICCMAX
  GT ICCMAX value is represented in 1/4 A increments. A value of 400 = 100A. <b>4
  </b>. Range is 4-2047.
**/
  UINT16                      GtIccMax;

/** Offset 0x04B6 - TVB Down Bins for Temp Threshold 0
  Down Bins (delta) for Temperature Threshold 0. When running above Temperature Threshold
  0, the ratio will be clipped by MAX_RATIO[n]-This value, when TVB ratio clipping
  is enabled. Default is 1.
**/
  UINT8                       TvbDownBinsTempThreshold0;

/** Offset 0x04B7 - TVB Temperature Threshold 0
  TVB Temp (degrees C) - Temperature Threshold 0. Running ABOVE this temperature will
  clip delta Down Bins for Threshold 0 from the resolved OC Ratio, when TVB ratio
  clipping is enabled. Default is 70.
**/
  UINT8                       TvbTempThreshold0;

/** Offset 0x04B8 - TVB Temperature Threshold 1
  TVB Temp (degrees C) - Temperature Threshold 1. Running ABOVE this temperature will
  clip delta Down Bins for Threshold 1 from the resolved OC Ratio, when TVB ratio
  clipping is enabled. Default is 100.
**/
  UINT8                       TvbTempThreshold1;

/** Offset 0x04B9 - TVB Down Bins for Temp Threshold 1
  Down Bins (delta) for Temperature Threshold 1. When running above Temperature Threshold
  1, the ratio will be clipped by MAX_RATIO[n]-Down Bin Threshold 1-This value, when
  TVB ratio clipping is enabled. Default is 2.
**/
  UINT8                       TvbDownBinsTempThreshold1;

/** Offset 0x04BA - FLL Overclock Mode Enable
  Select FLL Mode Value from 0 to 3. 0x0 = no overclocking, 0x1 = ratio overclocking
  with nominal (0.5-1x) reference clock frequency, 0x2 = BCLK overclocking with elevated
  (1-3x) reference clock frequency, 0x3 = BCLK overclocking with extreme elevated
  (3-5x) reference clock frequency and ratio limited to 63.
  $EN_DIS
**/
  UINT8                       FllOcModeEn;

/** Offset 0x04BB - FLL Overclock Mode
  Select FLL Mode Value from 0 to 3. 0x0 = no overclocking, 0x1 = ratio overclocking
  with nominal (0.5-1x) reference clock frequency, 0x2 = BCLK overclocking with elevated
  (1-3x) reference clock frequency, 0x3 = BCLK overclocking with extreme elevated
  (3-5x) reference clock frequency and ratio limited to 63.
**/
  UINT8                       FllOverclockMode;

/** Offset 0x04BC - Configuration for boot TDP selection
  Configuration for boot TDP selection; <b>0: TDP Nominal</b>; 1: TDP Down; 2: TDP
  Up;0xFF : Deactivate
**/
  UINT8                       ConfigTdpLevel;

/** Offset 0x04BD
**/
  UINT8                       UnusedUpdSpace15[3];

/** Offset 0x04C0 - Short term Power Limit value for custom cTDP level 1
  Short term Power Limit value for custom cTDP level 1. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 4095875 in Step size of 125
**/
  UINT32                      CustomPowerLimit1;

/** Offset 0x04C4 - Enhanced Thermal Turbo Mode
  When eTVB mode is enabled user will be clipped when temperatures reach 70C <b>0:
  Disabled</b>; 1: Enabled.
  $EN_DIS
**/
  UINT8                       Etvb;

/** Offset 0x04C5 - ReservedCpuPreMem
  Reserved for Cpu Pre-Mem
  $EN_DIS
**/
  UINT8                       ReservedCpuPreMem[7];

/** Offset 0x04CC - BiosGuard
  Enable/Disable. 0: Disable, Enable/Disable BIOS Guard feature, 1: enable
  $EN_DIS
**/
  UINT8                       BiosGuard;

/** Offset 0x04CD
**/
  UINT8                       BiosGuardToolsInterface;

/** Offset 0x04CE - Txt
  Enable/Disable. 0: Disable, Enable/Disable Txt feature, 1: enable
  $EN_DIS
**/
  UINT8                       Txt;

/** Offset 0x04CF
**/
  UINT8                       UnusedUpdSpace16;

/** Offset 0x04D0 - PrmrrSize
  Enable/Disable. 0: Disable, define default value of PrmrrSize , 1: enable
**/
  UINT32                      PrmrrSize;

/** Offset 0x04D4 - SinitMemorySize
  Enable/Disable. 0: Disable, define default value of SinitMemorySize , 1: enable
**/
  UINT32                      SinitMemorySize;

/** Offset 0x04D8 - TxtDprMemoryBase
  Enable/Disable. 0: Disable, define default value of TxtDprMemoryBase , 1: enable
**/
  UINT64                      TxtDprMemoryBase;

/** Offset 0x04E0 - TxtHeapMemorySize
  Enable/Disable. 0: Disable, define default value of TxtHeapMemorySize , 1: enable
**/
  UINT32                      TxtHeapMemorySize;

/** Offset 0x04E4 - TxtDprMemorySize
  Enable/Disable. 0: Disable, define default value of TxtDprMemorySize , 1: enable
**/
  UINT32                      TxtDprMemorySize;

/** Offset 0x04E8 - BiosAcmBase
  Enable/Disable. 0: Disable, define default value of BiosAcmBase , 1: enable
**/
  UINT32                      BiosAcmBase;

/** Offset 0x04EC - BiosAcmSize
  Enable/Disable. 0: Disable, define default value of BiosAcmSize , 1: enable
**/
  UINT32                      BiosAcmSize;

/** Offset 0x04F0 - ApStartupBase
  Enable/Disable. 0: Disable, define default value of BiosAcmBase , 1: enable
**/
  UINT32                      ApStartupBase;

/** Offset 0x04F4 - TgaSize
  Enable/Disable. 0: Disable, define default value of TgaSize , 1: enable
**/
  UINT32                      TgaSize;

/** Offset 0x04F8 - TxtLcpPdBase
  Enable/Disable. 0: Disable, define default value of TxtLcpPdBase , 1: enable
**/
  UINT64                      TxtLcpPdBase;

/** Offset 0x0500 - TxtLcpPdSize
  Enable/Disable. 0: Disable, define default value of TxtLcpPdSize , 1: enable
**/
  UINT64                      TxtLcpPdSize;

/** Offset 0x0508 - IsTPMPresence
  IsTPMPresence default values
**/
  UINT8                       IsTPMPresence;

/** Offset 0x0509 - ReservedSecurityPreMem
  Reserved for Security Pre-Mem
  $EN_DIS
**/
  UINT8                       ReservedSecurityPreMem[32];

/** Offset 0x0529 - Enable PCH HSIO PCIE Rx Set Ctle
  Enable PCH PCIe Gen 3 Set CTLE Value.
**/
  UINT8                       PchPcieHsioRxSetCtleEnable[28];

/** Offset 0x0545 - PCH HSIO PCIE Rx Set Ctle Value
  PCH PCIe Gen 3 Set CTLE Value.
**/
  UINT8                       PchPcieHsioRxSetCtle[28];

/** Offset 0x0561 - Enble PCH HSIO PCIE TX Gen 1 Downscale Amplitude Adjustment value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchPcieHsioTxGen1DownscaleAmpEnable[28];

/** Offset 0x057D - PCH HSIO PCIE Gen 2 TX Output Downscale Amplitude Adjustment value
  PCH PCIe Gen 2 TX Output Downscale Amplitude Adjustment value.
**/
  UINT8                       PchPcieHsioTxGen1DownscaleAmp[28];

/** Offset 0x0599 - Enable PCH HSIO PCIE TX Gen 2 Downscale Amplitude Adjustment value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchPcieHsioTxGen2DownscaleAmpEnable[28];

/** Offset 0x05B5 - PCH HSIO PCIE Gen 2 TX Output Downscale Amplitude Adjustment value
  PCH PCIe Gen 2 TX Output Downscale Amplitude Adjustment value.
**/
  UINT8                       PchPcieHsioTxGen2DownscaleAmp[28];

/** Offset 0x05D1 - Enable PCH HSIO PCIE TX Gen 3 Downscale Amplitude Adjustment value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchPcieHsioTxGen3DownscaleAmpEnable[28];

/** Offset 0x05ED - PCH HSIO PCIE Gen 3 TX Output Downscale Amplitude Adjustment value
  PCH PCIe Gen 3 TX Output Downscale Amplitude Adjustment value.
**/
  UINT8                       PchPcieHsioTxGen3DownscaleAmp[28];

/** Offset 0x0609 - Enable PCH HSIO PCIE Gen 1 TX Output De-Emphasis Adjustment Setting value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchPcieHsioTxGen1DeEmphEnable[28];

/** Offset 0x0625 - PCH HSIO PCIE Gen 1 TX Output De-Emphasis Adjustment value
  PCH PCIe Gen 1 TX Output De-Emphasis Adjustment Setting.
**/
  UINT8                       PchPcieHsioTxGen1DeEmph[28];

/** Offset 0x0641 - Enable PCH HSIO PCIE Gen 2 TX Output -3.5dB De-Emphasis Adjustment Setting value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchPcieHsioTxGen2DeEmph3p5Enable[28];

/** Offset 0x065D - PCH HSIO PCIE Gen 2 TX Output -3.5dB De-Emphasis Adjustment value
  PCH PCIe Gen 2 TX Output -3.5dB De-Emphasis Adjustment Setting.
**/
  UINT8                       PchPcieHsioTxGen2DeEmph3p5[28];

/** Offset 0x0679 - Enable PCH HSIO PCIE Gen 2 TX Output -6.0dB De-Emphasis Adjustment Setting value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchPcieHsioTxGen2DeEmph6p0Enable[28];

/** Offset 0x0695 - PCH HSIO PCIE Gen 2 TX Output -6.0dB De-Emphasis Adjustment value
  PCH PCIe Gen 2 TX Output -6.0dB De-Emphasis Adjustment Setting.
**/
  UINT8                       PchPcieHsioTxGen2DeEmph6p0[28];

/** Offset 0x06B1 - Enable PCH HSIO SATA Receiver Equalization Boost Magnitude Adjustment Value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioRxGen1EqBoostMagEnable[8];

/** Offset 0x06B9 - PCH HSIO SATA 1.5 Gb/s Receiver Equalization Boost Magnitude Adjustment value
  PCH HSIO SATA 1.5 Gb/s Receiver Equalization Boost Magnitude Adjustment value.
**/
  UINT8                       PchSataHsioRxGen1EqBoostMag[8];

/** Offset 0x06C1 - Enable PCH HSIO SATA Receiver Equalization Boost Magnitude Adjustment Value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioRxGen2EqBoostMagEnable[8];

/** Offset 0x06C9 - PCH HSIO SATA 3.0 Gb/s Receiver Equalization Boost Magnitude Adjustment value
  PCH HSIO SATA 3.0 Gb/s Receiver Equalization Boost Magnitude Adjustment value.
**/
  UINT8                       PchSataHsioRxGen2EqBoostMag[8];

/** Offset 0x06D1 - Enable PCH HSIO SATA Receiver Equalization Boost Magnitude Adjustment Value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioRxGen3EqBoostMagEnable[8];

/** Offset 0x06D9 - PCH HSIO SATA 6.0 Gb/s Receiver Equalization Boost Magnitude Adjustment value
  PCH HSIO SATA 6.0 Gb/s Receiver Equalization Boost Magnitude Adjustment value.
**/
  UINT8                       PchSataHsioRxGen3EqBoostMag[8];

/** Offset 0x06E1 - Enable PCH HSIO SATA 1.5 Gb/s TX Output Downscale Amplitude Adjustment value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioTxGen1DownscaleAmpEnable[8];

/** Offset 0x06E9 - PCH HSIO SATA 1.5 Gb/s TX Output Downscale Amplitude Adjustment value
  PCH HSIO SATA 1.5 Gb/s TX Output Downscale Amplitude Adjustment value.
**/
  UINT8                       PchSataHsioTxGen1DownscaleAmp[8];

/** Offset 0x06F1 - Enable PCH HSIO SATA 3.0 Gb/s TX Output Downscale Amplitude Adjustment value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioTxGen2DownscaleAmpEnable[8];

/** Offset 0x06F9 - PCH HSIO SATA 3.0 Gb/s TX Output Downscale Amplitude Adjustment value
  PCH HSIO SATA 3.0 Gb/s TX Output Downscale Amplitude Adjustment value.
**/
  UINT8                       PchSataHsioTxGen2DownscaleAmp[8];

/** Offset 0x0701 - Enable PCH HSIO SATA 6.0 Gb/s TX Output Downscale Amplitude Adjustment value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioTxGen3DownscaleAmpEnable[8];

/** Offset 0x0709 - PCH HSIO SATA 6.0 Gb/s TX Output Downscale Amplitude Adjustment value
  PCH HSIO SATA 6.0 Gb/s TX Output Downscale Amplitude Adjustment value.
**/
  UINT8                       PchSataHsioTxGen3DownscaleAmp[8];

/** Offset 0x0711 - Enable PCH HSIO SATA 1.5 Gb/s TX Output De-Emphasis Adjustment Setting value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioTxGen1DeEmphEnable[8];

/** Offset 0x0719 - PCH HSIO SATA 1.5 Gb/s TX Output De-Emphasis Adjustment Setting
  PCH HSIO SATA 1.5 Gb/s TX Output De-Emphasis Adjustment Setting.
**/
  UINT8                       PchSataHsioTxGen1DeEmph[8];

/** Offset 0x0721 - Enable PCH HSIO SATA 3.0 Gb/s TX Output De-Emphasis Adjustment Setting value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioTxGen2DeEmphEnable[8];

/** Offset 0x0729 - PCH HSIO SATA 3.0 Gb/s TX Output De-Emphasis Adjustment Setting
  PCH HSIO SATA 3.0 Gb/s TX Output De-Emphasis Adjustment Setting.
**/
  UINT8                       PchSataHsioTxGen2DeEmph[8];

/** Offset 0x0731 - Enable PCH HSIO SATA 6.0 Gb/s TX Output De-Emphasis Adjustment Setting value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioTxGen3DeEmphEnable[8];

/** Offset 0x0739 - PCH HSIO SATA 6.0 Gb/s TX Output De-Emphasis Adjustment Setting
  PCH HSIO SATA 6.0 Gb/s TX Output De-Emphasis Adjustment Setting.
**/
  UINT8                       PchSataHsioTxGen3DeEmph[8];

/** Offset 0x0741 - PCH LPC Enhanced Port 80 Decoding
  Original LPC only decodes one byte of port 80h.
  $EN_DIS
**/
  UINT8                       PchLpcEnhancePort8xhDecoding;

/** Offset 0x0742 - PCH Port80 Route
  Control where the Port 80h cycles are sent, 0: LPC; 1: PCI.
  0:LPC, 1:PCI
**/
  UINT8                       PchPort80Route;

/** Offset 0x0743 - Enable SMBus ARP support
  Enable SMBus ARP support.
  $EN_DIS
**/
  UINT8                       SmbusArpEnable;

/** Offset 0x0744 - Number of RsvdSmbusAddressTable.
  The number of elements in the RsvdSmbusAddressTable.
**/
  UINT8                       PchNumRsvdSmbusAddresses;

/** Offset 0x0745
**/
  UINT8                       UnusedUpdSpace17;

/** Offset 0x0746 - SMBUS Base Address
  SMBUS Base Address (IO space).
**/
  UINT16                      PchSmbusIoBase;

/** Offset 0x0748 - Enable SMBus Alert Pin
  Enable SMBus Alert Pin.
  $EN_DIS
**/
  UINT8                       PchSmbAlertEnable;

/** Offset 0x0749 - Usage type for ClkSrc
  0-23: PCH rootport, 0x40-0x43: PEG port, 0x70:LAN, 0x80: unspecified but in use
  (free running), 0xFF: not used
**/
  UINT8                       PcieClkSrcUsage[18];

/** Offset 0x075B
**/
  UINT8                       PcieClkSrcUsageRsvd[14];

/** Offset 0x0769 - ClkReq-to-ClkSrc mapping
  Number of ClkReq signal assigned to ClkSrc
**/
  UINT8                       PcieClkSrcClkReq[18];

/** Offset 0x077B
**/
  UINT8                       PcieClkSrcClkReqRsvd[14];

/** Offset 0x0789
**/
  UINT8                       UnusedUpdSpace18[3];

/** Offset 0x078C - Clk Req GPIO Pin
  Select Clk Req Pin. Refer to GPIO_*_MUXING_SRC_CLKREQ_x* for possible values.
**/
  UINT32                      PcieClkReqGpioMux[18];

/** Offset 0x07D4 - Point of RsvdSmbusAddressTable
  Array of addresses reserved for non-ARP-capable SMBus devices.
**/
  UINT32                      RsvdSmbusAddressTablePtr;

/** Offset 0x07D8 - Enable PCIE RP Mask
  Enable/disable PCIE Root Ports. 0: disable, 1: enable. One bit for each port, bit0
  for port1, bit1 for port2, and so on.
**/
  UINT32                      PcieRpEnableMask;

/** Offset 0x07DC - VC Type
  Virtual Channel Type Select: 0: VC0, 1: VC1.
  0: VC0, 1: VC1
**/
  UINT8                       PchHdaVcType;

/** Offset 0x07DD - Universal Audio Architecture compliance for DSP enabled system
  0: Not-UAA Compliant (Intel SST driver supported only), 1: UAA Compliant (HDA Inbox
  driver or SST driver supported).
  $EN_DIS
**/
  UINT8                       PchHdaDspUaaCompliance;

/** Offset 0x07DE - Enable HD Audio Link
  Enable/disable HD Audio Link. Muxed with SSP0/SSP1/SNDW1.
  $EN_DIS
**/
  UINT8                       PchHdaAudioLinkHdaEnable;

/** Offset 0x07DF - Enable HDA SDI lanes
  Enable/disable HDA SDI lanes.
**/
  UINT8                       PchHdaSdiEnable[2];

/** Offset 0x07E1 - HDA Power/Clock Gating (PGD/CGD)
  Enable/Disable HD Audio Power and Clock Gating(POR: Enable). 0: PLATFORM_POR, 1:
  FORCE_ENABLE, 2: FORCE_DISABLE.
  0: POR, 1: Force Enable, 2: Force Disable
**/
  UINT8                       PchHdaTestPowerClockGating;

/** Offset 0x07E2 - Enable HD Audio DMIC_N Link
  Enable/disable HD Audio DMIC1 link. Muxed with SNDW3.
**/
  UINT8                       PchHdaAudioLinkDmicEnable[2];

/** Offset 0x07E4 - DMIC<N> ClkA Pin Muxing (N - DMIC number)
  Determines DMIC<N> ClkA Pin muxing. See  GPIO_*_MUXING_DMIC<N>_CLKA_*
**/
  UINT32                      PchHdaAudioLinkDmicClkAPinMux[2];

/** Offset 0x07EC - DMIC<N> ClkB Pin Muxing
  Determines DMIC<N> ClkA Pin muxing. See GPIO_*_MUXING_DMIC<N>_CLKB_*
**/
  UINT32                      PchHdaAudioLinkDmicClkBPinMux[2];

/** Offset 0x07F4 - Enable HD Audio DSP
  Enable/disable HD Audio DSP feature.
  $EN_DIS
**/
  UINT8                       PchHdaDspEnable;

/** Offset 0x07F5
**/
  UINT8                       UnusedUpdSpace19[3];

/** Offset 0x07F8 - DMIC<N> Data Pin Muxing
  Determines DMIC<N> Data Pin muxing. See GPIO_*_MUXING_DMIC<N>_DATA_*
**/
  UINT32                      PchHdaAudioLinkDmicDataPinMux[2];

/** Offset 0x0800 - Enable HD Audio SSP0 Link
  Enable/disable HD Audio SSP_N/I2S link. Muxed with HDA. N-number 0-5
**/
  UINT8                       PchHdaAudioLinkSspEnable[6];

/** Offset 0x0806 - Enable HD Audio SoundWire#N Link
  Enable/disable HD Audio SNDW#N link. Muxed with HDA.
**/
  UINT8                       PchHdaAudioLinkSndwEnable[4];

/** Offset 0x080A - iDisp-Link Frequency
  iDisp-Link Freq (PCH_HDAUDIO_LINK_FREQUENCY enum): 4: 96MHz, 3: 48MHz.
  4: 96MHz, 3: 48MHz
**/
  UINT8                       PchHdaIDispLinkFrequency;

/** Offset 0x080B - iDisp-Link T-mode
  iDisp-Link T-Mode (PCH_HDAUDIO_IDISP_TMODE enum): 0: 2T, 2: 4T, 3: 8T, 4: 16T
  0: 2T, 2: 4T, 3: 8T, 4: 16T
**/
  UINT8                       PchHdaIDispLinkTmode;

/** Offset 0x080C - iDisplay Audio Codec disconnection
  0: Not disconnected, enumerable, 1: Disconnected SDI, not enumerable.
  $EN_DIS
**/
  UINT8                       PchHdaIDispCodecDisconnect;

/** Offset 0x080D - CNVi DDR RFI Mitigation
  Enable/Disable DDR RFI Mitigation. Default is ENABLE. 0: DISABLE, 1: ENABLE
  $EN_DIS
**/
  UINT8                       CnviDdrRfim;

/** Offset 0x080E - Debug Interfaces
  Debug Interfaces. BIT0-RAM, BIT1-UART, BIT3-USB3, BIT4-Serial IO, BIT5-TraceHub,
  BIT2 - Not used.
**/
  UINT8                       PcdDebugInterfaceFlags;

/** Offset 0x080F - Serial Io Uart Debug Controller Number
  Select SerialIo Uart Controller for debug. Note: If UART0 is selected as CNVi BT
  Core interface, it cannot be used for debug purpose.
  0:SerialIoUart0, 1:SerialIoUart1, 2:SerialIoUart2
**/
  UINT8                       SerialIoUartDebugControllerNumber;

/** Offset 0x0810 - Serial Io Uart Debug Auto Flow
  Enables UART hardware flow control, CTS and RTS lines.
  $EN_DIS
**/
  UINT8                       SerialIoUartDebugAutoFlow;

/** Offset 0x0811
**/
  UINT8                       UnusedUpdSpace20[3];

/** Offset 0x0814 - Serial Io Uart Debug BaudRate
  Set default BaudRate Supported from 0 - default to 6000000. Recommended values 9600,
  19200, 57600, 115200, 460800, 921600, 1500000, 1843200, 3000000, 3686400, 6000000
**/
  UINT32                      SerialIoUartDebugBaudRate;

/** Offset 0x0818 - Serial Io Uart Debug Parity
  Set default Parity.
  0: DefaultParity, 1: NoParity, 2: EvenParity, 3: OddParity
**/
  UINT8                       SerialIoUartDebugParity;

/** Offset 0x0819 - Serial Io Uart Debug Stop Bits
  Set default stop bits.
  0: DefaultStopBits, 1: OneStopBit, 2: OneFiveStopBits, 3: TwoStopBits
**/
  UINT8                       SerialIoUartDebugStopBits;

/** Offset 0x081A - Serial Io Uart Debug Data Bits
  Set default word length. 0: Default, 5,6,7,8
  5:5BITS, 6:6BITS, 7:7BITS, 8:8BITS
**/
  UINT8                       SerialIoUartDebugDataBits;

/** Offset 0x081B
**/
  UINT8                       UnusedUpdSpace21;

/** Offset 0x081C - Serial Io Uart Debug Mmio Base
  Select SerialIo Uart default MMIO resource in SEC/PEI phase when PcdSerialIoUartMode
  = SerialIoUartPci.
**/
  UINT32                      SerialIoUartDebugMmioBase;

/** Offset 0x0820 - ISA Serial Base selection
  Select ISA Serial Base address. Default is 0x3F8.
  0:0x3F8, 1:0x2F8
**/
  UINT8                       PcdIsaSerialUartBase;

/** Offset 0x0821 - GT PLL voltage offset
  Core PLL voltage offset. <b>0: No offset</b>. Range 0-15
**/
  UINT8                       GtPllVoltageOffset;

/** Offset 0x0822 - Ring PLL voltage offset
  Core PLL voltage offset. <b>0: No offset</b>. Range 0-15
**/
  UINT8                       RingPllVoltageOffset;

/** Offset 0x0823 - System Agent PLL voltage offset
  Core PLL voltage offset. <b>0: No offset</b>. Range 0-15
**/
  UINT8                       SaPllVoltageOffset;

/** Offset 0x0824 - Memory Controller PLL voltage offset
  Core PLL voltage offset. <b>0: No offset</b>. Range 0-15
**/
  UINT8                       McPllVoltageOffset;

/** Offset 0x0825 - MRC Safe Config
  Enables/Disable MRC Safe Config
  $EN_DIS
**/
  UINT8                       MrcSafeConfig;

/** Offset 0x0826 - TCSS Thunderbolt PCIE Root Port 0 Enable
  Set TCSS Thunderbolt PCIE Root Port 0. 0:Disabled  1:Enabled
  $EN_DIS
**/
  UINT8                       TcssItbtPcie0En;

/** Offset 0x0827 - TCSS Thunderbolt PCIE Root Port 1 Enable
  Set TCSS Thunderbolt PCIE Root Port 1. 0:Disabled  1:Enabled
  $EN_DIS
**/
  UINT8                       TcssItbtPcie1En;

/** Offset 0x0828 - TCSS Thunderbolt PCIE Root Port 2 Enable
  Set TCSS Thunderbolt PCIE Root Port 2. 0:Disabled  1:Enabled
  $EN_DIS
**/
  UINT8                       TcssItbtPcie2En;

/** Offset 0x0829 - TCSS Thunderbolt PCIE Root Port 3 Enable
  Set TCSS Thunderbolt PCIE Root Port 3. 0:Disabled  1:Enabled
  $EN_DIS
**/
  UINT8                       TcssItbtPcie3En;

/** Offset 0x082A - TCSS USB HOST (xHCI) Enable
  Set TCSS XHCI. 0:Disabled  1:Enabled - Must be enabled if xDCI is enabled below
  $EN_DIS
**/
  UINT8                       TcssXhciEn;

/** Offset 0x082B - TCSS USB DEVICE (xDCI) Enable
  Set TCSS XDCI. 0:Disabled  1:Enabled - xHCI must be enabled if xDCI is enabled
  $EN_DIS
**/
  UINT8                       TcssXdciEn;

/** Offset 0x082C - TCSS DMA0 Enable
  Set TCSS DMA0. 0:Disabled  1:Enabled
  $EN_DIS
**/
  UINT8                       TcssDma0En;

/** Offset 0x082D - TCSS DMA1 Enable
  Set TCSS DMA1. 0:Disabled  1:Enabled
  $EN_DIS
**/
  UINT8                       TcssDma1En;

/** Offset 0x082E - PcdSerialDebugBaudRate
  Baud Rate for Serial Debug Messages. 3:9600, 4:19200, 6:56700, 7:115200.
  3:9600, 4:19200, 6:56700, 7:115200
**/
  UINT8                       PcdSerialDebugBaudRate;

/** Offset 0x082F - HobBufferSize
  Size to set HOB Buffer. 0:Default, 1: 1 Byte, 2: 1 KB, 3: Max value(assuming 63KB
  total HOB size).
  0:Default, 1: 1 Byte, 2: 1 KB, 3: Max value
**/
  UINT8                       HobBufferSize;

/** Offset 0x0830 - Early Command Training
  Enables/Disable Early Command Training
  $EN_DIS
**/
  UINT8                       ECT;

/** Offset 0x0831 - SenseAmp Offset Training
  Enables/Disable SenseAmp Offset Training
  $EN_DIS
**/
  UINT8                       SOT;

/** Offset 0x0832 - Early ReadMPR Timing Centering 2D
  Enables/Disable Early ReadMPR Timing Centering 2D
  $EN_DIS
**/
  UINT8                       ERDMPRTC2D;

/** Offset 0x0833 - Read MPR Training
  Enables/Disable Read MPR Training
  $EN_DIS
**/
  UINT8                       RDMPRT;

/** Offset 0x0834 - Receive Enable Training
  Enables/Disable Receive Enable Training
  $EN_DIS
**/
  UINT8                       RCVET;

/** Offset 0x0835 - Jedec Write Leveling
  Enables/Disable Jedec Write Leveling
  $EN_DIS
**/
  UINT8                       JWRL;

/** Offset 0x0836 - Early Write Time Centering 2D
  Enables/Disable Early Write Time Centering 2D
  $EN_DIS
**/
  UINT8                       EWRTC2D;

/** Offset 0x0837 - Early Read Time Centering 2D
  Enables/Disable Early Read Time Centering 2D
  $EN_DIS
**/
  UINT8                       ERDTC2D;

/** Offset 0x0838 - Write Timing Centering 1D
  Enables/Disable Write Timing Centering 1D
  $EN_DIS
**/
  UINT8                       WRTC1D;

/** Offset 0x0839 - Write Voltage Centering 1D
  Enables/Disable Write Voltage Centering 1D
  $EN_DIS
**/
  UINT8                       WRVC1D;

/** Offset 0x083A - Read Timing Centering 1D
  Enables/Disable Read Timing Centering 1D
  $EN_DIS
**/
  UINT8                       RDTC1D;

/** Offset 0x083B - Dimm ODT Training
  Enables/Disable Dimm ODT Training
  $EN_DIS
**/
  UINT8                       DIMMODTT;

/** Offset 0x083C - DIMM RON Training
  Enables/Disable DIMM RON Training
  $EN_DIS
**/
  UINT8                       DIMMRONT;

/** Offset 0x083D - Write Drive Strength/Equalization 2D
  Enables/Disable Write Drive Strength/Equalization 2D
  $EN_DIS
**/
  UINT8                       WRDSEQT;

/** Offset 0x083E - Write Slew Rate Training
  Enables/Disable Write Slew Rate Training
  $EN_DIS
**/
  UINT8                       WRSRT;

/** Offset 0x083F - Read ODT Training
  Enables/Disable Read ODT Training
  $EN_DIS
**/
  UINT8                       RDODTT;

/** Offset 0x0840 - Read Equalization Training
  Enables/Disable Read Equalization Training
  $EN_DIS
**/
  UINT8                       RDEQT;

/** Offset 0x0841 - Read Amplifier Training
  Enables/Disable Read Amplifier Training
  $EN_DIS
**/
  UINT8                       RDAPT;

/** Offset 0x0842 - Write Timing Centering 2D
  Enables/Disable Write Timing Centering 2D
  $EN_DIS
**/
  UINT8                       WRTC2D;

/** Offset 0x0843 - Read Timing Centering 2D
  Enables/Disable Read Timing Centering 2D
  $EN_DIS
**/
  UINT8                       RDTC2D;

/** Offset 0x0844 - Write Voltage Centering 2D
  Enables/Disable Write Voltage Centering 2D
  $EN_DIS
**/
  UINT8                       WRVC2D;

/** Offset 0x0845 - Read Voltage Centering 2D
  Enables/Disable Read Voltage Centering 2D
  $EN_DIS
**/
  UINT8                       RDVC2D;

/** Offset 0x0846 - Command Voltage Centering
  Enables/Disable Command Voltage Centering
  $EN_DIS
**/
  UINT8                       CMDVC;

/** Offset 0x0847 - Late Command Training
  Enables/Disable Late Command Training
  $EN_DIS
**/
  UINT8                       LCT;

/** Offset 0x0848 - Round Trip Latency Training
  Enables/Disable Round Trip Latency Training
  $EN_DIS
**/
  UINT8                       RTL;

/** Offset 0x0849 - Turn Around Timing Training
  Enables/Disable Turn Around Timing Training
  $EN_DIS
**/
  UINT8                       TAT;

/** Offset 0x084A - Memory Test
  Enables/Disable Memory Test
  $EN_DIS
**/
  UINT8                       MEMTST;

/** Offset 0x084B - DIMM SPD Alias Test
  Enables/Disable DIMM SPD Alias Test
  $EN_DIS
**/
  UINT8                       ALIASCHK;

/** Offset 0x084C - Receive Enable Centering 1D
  Enables/Disable Receive Enable Centering 1D
  $EN_DIS
**/
  UINT8                       RCVENC1D;

/** Offset 0x084D - Retrain Margin Check
  Enables/Disable Retrain Margin Check
  $EN_DIS
**/
  UINT8                       RMC;

/** Offset 0x084E - Write Drive Strength Up/Dn independently
  Enables/Disable Write Drive Strength Up/Dn independently
  $EN_DIS
**/
  UINT8                       WRDSUDT;

/** Offset 0x084F - ECC Support
  Enables/Disable ECC Support
  $EN_DIS
**/
  UINT8                       EccSupport;

/** Offset 0x0850 - Memory Remap
  Enables/Disable Memory Remap
  $EN_DIS
**/
  UINT8                       RemapEnable;

/** Offset 0x0851 - Rank Interleave support
  Enables/Disable Rank Interleave support. NOTE: RI and HORI can not be enabled at
  the same time.
  $EN_DIS
**/
  UINT8                       RankInterleave;

/** Offset 0x0852 - Enhanced Interleave support
  Enables/Disable Enhanced Interleave support
  $EN_DIS
**/
  UINT8                       EnhancedInterleave;

/** Offset 0x0853 - Ch Hash Support
  Enable/Disable Channel Hash Support. NOTE: ONLY if Memory interleaved Mode
  $EN_DIS
**/
  UINT8                       ChHashEnable;

/** Offset 0x0854 - Ch Hash Settings Override
  Channel Hash Settings Override
  $EN_DIS
**/
  UINT8                       ChHashOverride;

/** Offset 0x0855 - Extern Therm Status
  Enables/Disable Extern Therm Status
  $EN_DIS
**/
  UINT8                       EnableExtts;

/** Offset 0x0856 - DDR PowerDown and idle counter
  Enables/Disable DDR PowerDown and idle counter(For LPDDR Only)
  $EN_DIS
**/
  UINT8                       EnablePwrDn;

/** Offset 0x0857 - DDR PowerDown and idle counter
  Enables/Disable DDR PowerDown and idle counter(For LPDDR Only)
  $EN_DIS
**/
  UINT8                       EnablePwrDnLpddr;

/** Offset 0x0858 - SelfRefresh Enable
  Enables/Disable SelfRefresh Enable
  $EN_DIS
**/
  UINT8                       SrefCfgEna;

/** Offset 0x0859 - Throttler CKEMin Defeature
  Enables/Disable Throttler CKEMin Defeature(For LPDDR Only)
  $EN_DIS
**/
  UINT8                       ThrtCkeMinDefeatLpddr;

/** Offset 0x085A - Throttler CKEMin Defeature
  Enables/Disable Throttler CKEMin Defeature
  $EN_DIS
**/
  UINT8                       ThrtCkeMinDefeat;

/** Offset 0x085B - Row Hammer Select
  Row Hammer Select
  0:Disable, 1:RFM, 2:pTRR
**/
  UINT8                       RhSelect;

/** Offset 0x085C - Exit On Failure (MRC)
  Enables/Disable Exit On Failure (MRC)
  $EN_DIS
**/
  UINT8                       ExitOnFailure;

/** Offset 0x085D - New Features 1 - MRC
  New Feature Enabling 1, <b>0:Disable</b>, 1:Enable
  0:Disable, 1:Enable
**/
  UINT8                       NewFeatureEnable1;

/** Offset 0x085E - New Features 2 - MRC
  New Feature Enabling 2, <b>0:Disable</b>, 1:Enable
  0:Disable, 1:Enable
**/
  UINT8                       NewFeatureEnable2;

/** Offset 0x085F - Duty Cycle Correction Training
  Enable/Disable Duty Cycle Correction Training
  $EN_DIS
**/
  UINT8                       DCC;

/** Offset 0x0860 - Read Voltage Centering 1D
  Enable/Disable Read Voltage Centering 1D
  $EN_DIS
**/
  UINT8                       RDVC1D;

/** Offset 0x0861 - TxDqTCO Comp Training
  Enable/Disable TxDqTCO Comp Training
  $EN_DIS
**/
  UINT8                       TXTCO;

/** Offset 0x0862 - ClkTCO Comp Training
  Enable/Disable ClkTCO Comp Training
  $EN_DIS
**/
  UINT8                       CLKTCO;

/** Offset 0x0863 - CMD Slew Rate Training
  Enable/Disable CMD Slew Rate Training
  $EN_DIS
**/
  UINT8                       CMDSR;

/** Offset 0x0864 - CMD Drive Strength and Tx Equalization
  Enable/Disable CMD Drive Strength and Tx Equalization
  $EN_DIS
**/
  UINT8                       CMDDSEQ;

/** Offset 0x0865 - DIMM CA ODT Training
  Enable/Disable DIMM CA ODT Training
  $EN_DIS
**/
  UINT8                       DIMMODTCA;

/** Offset 0x0866 - TxDqsTCO Comp Training
  Enable/Disable TxDqsTCO Comp Training
  $EN_DIS
**/
  UINT8                       TXTCODQS;

/** Offset 0x0867 - CMD/CTL Drive Strength Up/Dn 2D
  Enable/Disable CMD/CTL Drive Strength Up/Dn 2D
  $EN_DIS
**/
  UINT8                       CMDDRUD;

/** Offset 0x0868 - VccDLL Bypass Training
  Enable/Disable VccDLL Bypass Training
  $EN_DIS
**/
  UINT8                       VCCDLLBP;

/** Offset 0x0869 - PanicVttDnLp Training
  Enable/Disable PanicVttDnLp Training
  $EN_DIS
**/
  UINT8                       PVTTDNLP;

/** Offset 0x086A - Read Vref Decap Training*
  Enable/Disable Read Vref Decap Training*
  $EN_DIS
**/
  UINT8                       RDVREFDC;

/** Offset 0x086B - Vddq Training
  Enable/Disable Vddq Training
  $EN_DIS
**/
  UINT8                       VDDQT;

/** Offset 0x086C - Rank Margin Tool Per Bit
  Enable/Disable Rank Margin Tool Per Bit
  $EN_DIS
**/
  UINT8                       RMTBIT;

/** Offset 0x086D - ECC DFT feature
  Enables/Disable ECC DFT feature
  $EN_DIS
**/
  UINT8                       EccDftEn;

/** Offset 0x086E - Write0 feature
  Enables/Disable Write0 feature
  $EN_DIS
**/
  UINT8                       Write0;

/** Offset 0x086F - Select if CLK0 is shared between Rank0 and Rank1 in DDR4 DDP
  Select if CLK0 is shared between Rank0 and Rank1 in DDR4 DDP
  $EN_DIS
**/
  UINT8                       Ddr4DdpSharedClock;

/** Offset 0x0870 - Select if ZQ pin is shared between Rank0 and Rank1 in DDR4 DDP
  ESelect if ZQ pin is shared between Rank0 and Rank1 in DDR4 DDP
  $EN_DIS
**/
  UINT8                       Ddr4DdpSharedZq;

/** Offset 0x0871 - Ch Hash Interleaved Bit
  Select the BIT to be used for Channel Interleaved mode. NOTE: BIT7 will interlave
  the channels at a 2 cacheline granularity, BIT8 at 4 and BIT9 at 8. Default is BIT8
  0:BIT6, 1:BIT7, 2:BIT8, 3:BIT9, 4:BIT10, 5:BIT11, 6:BIT12, 7:BIT13
**/
  UINT8                       ChHashInterleaveBit;

/** Offset 0x0872 - Ch Hash Mask
  Set the BIT(s) to be included in the XOR function. NOTE BIT mask corresponds to
  BITS [19:6] Default is 0x30CC
**/
  UINT16                      ChHashMask;

/** Offset 0x0874 - Base reference clock value
  Base reference clock value, in Hertz(Default is 100Hz)
  100000000:100Hz, 125000000:125Hz, 167000000:167Hz, 250000000:250Hz
**/
  UINT32                      BClkFrequency;

/** Offset 0x0878 - EPG DIMM Idd3N
  Active standby current (Idd3N) in milliamps from datasheet. Must be calculated on
  a per DIMM basis. Default is 26
**/
  UINT16                      Idd3n;

/** Offset 0x087A - EPG DIMM Idd3P
  Active power-down current (Idd3P) in milliamps from datasheet. Must be calculated
  on a per DIMM basis. Default is 11
**/
  UINT16                      Idd3p;

/** Offset 0x087C - CMD Normalization
  Enable/Disable CMD Normalization
  $EN_DIS
**/
  UINT8                       CMDNORM;

/** Offset 0x087D - Early DQ Write Drive Strength and Equalization Training
  Enable/Disable Early DQ Write Drive Strength and Equalization Training
  $EN_DIS
**/
  UINT8                       EWRDSEQ;

/** Offset 0x087E - MC_REFRESH_2X_MODE
  DEPRECATED
  $EN_DIS
**/
  UINT8                       McRefresh2X;

/** Offset 0x087F - Idle Energy Mc0Ch0Dimm0
  Idle Energy Consumed for 1 clk w/dimm idle/cke on, range[63;0],(10= Def)
**/
  UINT8                       IdleEnergyMc0Ch0Dimm0;

/** Offset 0x0880 - Idle Energy Mc0Ch0Dimm1
  Idle Energy Consumed for 1 clk w/dimm idle/cke on, range[63;0],(10= Def)
**/
  UINT8                       IdleEnergyMc0Ch0Dimm1;

/** Offset 0x0881 - Idle Energy Mc0Ch1Dimm0
  Idle Energy Consumed for 1 clk w/dimm idle/cke on, range[63;0],(10= Def)
**/
  UINT8                       IdleEnergyMc0Ch1Dimm0;

/** Offset 0x0882 - Idle Energy Mc0Ch1Dimm1
  Idle Energy Consumed for 1 clk w/dimm idle/cke on, range[63;0],(10= Def)
**/
  UINT8                       IdleEnergyMc0Ch1Dimm1;

/** Offset 0x0883 - Idle Energy Mc1Ch0Dimm0
  Idle Energy Consumed for 1 clk w/dimm idle/cke on, range[63;0],(10= Def)
**/
  UINT8                       IdleEnergyMc1Ch0Dimm0;

/** Offset 0x0884 - Idle Energy Mc1Ch0Dimm1
  Idle Energy Consumed for 1 clk w/dimm idle/cke on, range[63;0],(10= Def)
**/
  UINT8                       IdleEnergyMc1Ch0Dimm1;

/** Offset 0x0885 - Idle Energy Mc1Ch1Dimm0
  Idle Energy Consumed for 1 clk w/dimm idle/cke on, range[63;0],(10= Def)
**/
  UINT8                       IdleEnergyMc1Ch1Dimm0;

/** Offset 0x0886 - Idle Energy Mc1Ch1Dimm1
  Idle Energy Consumed for 1 clk w/dimm idle/cke on, range[63;0],(10= Def)
**/
  UINT8                       IdleEnergyMc1Ch1Dimm1;

/** Offset 0x0887 - PowerDown Energy Mc0Ch0Dimm0
  PowerDown Energy Consumed w/dimm idle/cke off, range[63;0],(6= Def)
**/
  UINT8                       PdEnergyMc0Ch0Dimm0;

/** Offset 0x0888 - PowerDown Energy Mc0Ch0Dimm1
  PowerDown Energy Consumed w/dimm idle/cke off, range[63;0],(6= Def)
**/
  UINT8                       PdEnergyMc0Ch0Dimm1;

/** Offset 0x0889 - PowerDown Energy Mc0Ch1Dimm0
  PowerDown Energy Consumed w/dimm idle/cke off, range[63;0],(6= Def)
**/
  UINT8                       PdEnergyMc0Ch1Dimm0;

/** Offset 0x088A - PowerDown Energy Mc0Ch1Dimm1
  PowerDown Energy Consumed w/dimm idle/cke off, range[63;0],(6= Def)
**/
  UINT8                       PdEnergyMc0Ch1Dimm1;

/** Offset 0x088B - PowerDown Energy Mc1Ch0Dimm0
  PowerDown Energy Consumed w/dimm idle/cke off, range[63;0],(6= Def)
**/
  UINT8                       PdEnergyMc1Ch0Dimm0;

/** Offset 0x088C - PowerDown Energy Mc1Ch0Dimm1
  PowerDown Energy Consumed w/dimm idle/cke off, range[63;0],(6= Def)
**/
  UINT8                       PdEnergyMc1Ch0Dimm1;

/** Offset 0x088D - PowerDown Energy Mc1Ch1Dimm0
  PowerDown Energy Consumed w/dimm idle/cke off, range[63;0],(6= Def)
**/
  UINT8                       PdEnergyMc1Ch1Dimm0;

/** Offset 0x088E - PowerDown Energy Mc1Ch1Dimm1
  PowerDown Energy Consumed w/dimm idle/cke off, range[63;0],(6= Def)
**/
  UINT8                       PdEnergyMc1Ch1Dimm1;

/** Offset 0x088F - Activate Energy Mc0Ch0Dimm0
  Activate Energy Contribution, range[255;0],(172= Def)
**/
  UINT8                       ActEnergyMc0Ch0Dimm0;

/** Offset 0x0890 - Activate Energy Mc0Ch0Dimm1
  Activate Energy Contribution, range[255;0],(172= Def)
**/
  UINT8                       ActEnergyMc0Ch0Dimm1;

/** Offset 0x0891 - Activate Energy Mc0Ch1Dimm0
  Activate Energy Contribution, range[255;0],(172= Def)
**/
  UINT8                       ActEnergyMc0Ch1Dimm0;

/** Offset 0x0892 - Activate Energy Mc0Ch1Dimm1
  Activate Energy Contribution, range[255;0],(172= Def)
**/
  UINT8                       ActEnergyMc0Ch1Dimm1;

/** Offset 0x0893 - Activate Energy Mc1Ch0Dimm0
  Activate Energy Contribution, range[255;0],(172= Def)
**/
  UINT8                       ActEnergyMc1Ch0Dimm0;

/** Offset 0x0894 - Activate Energy Mc1Ch0Dimm1
  Activate Energy Contribution, range[255;0],(172= Def)
**/
  UINT8                       ActEnergyMc1Ch0Dimm1;

/** Offset 0x0895 - Activate Energy Mc1Ch1Dimm0
  Activate Energy Contribution, range[255;0],(172= Def)
**/
  UINT8                       ActEnergyMc1Ch1Dimm0;

/** Offset 0x0896 - Activate Energy Mc1Ch1Dimm1
  Activate Energy Contribution, range[255;0],(172= Def)
**/
  UINT8                       ActEnergyMc1Ch1Dimm1;

/** Offset 0x0897 - Read Energy Mc0Ch0Dimm0
  Read Energy Contribution, range[255;0],(212= Def)
**/
  UINT8                       RdEnergyMc0Ch0Dimm0;

/** Offset 0x0898 - Read Energy Mc0Ch0Dimm1
  Read Energy Contribution, range[255;0],(212= Def)
**/
  UINT8                       RdEnergyMc0Ch0Dimm1;

/** Offset 0x0899 - Read Energy Mc0Ch1Dimm0
  Read Energy Contribution, range[255;0],(212= Def)
**/
  UINT8                       RdEnergyMc0Ch1Dimm0;

/** Offset 0x089A - Read Energy Mc0Ch1Dimm1
  Read Energy Contribution, range[255;0],(212= Def)
**/
  UINT8                       RdEnergyMc0Ch1Dimm1;

/** Offset 0x089B - Read Energy Mc1Ch0Dimm0
  Read Energy Contribution, range[255;0],(212= Def)
**/
  UINT8                       RdEnergyMc1Ch0Dimm0;

/** Offset 0x089C - Read Energy Mc1Ch0Dimm1
  Read Energy Contribution, range[255;0],(212= Def)
**/
  UINT8                       RdEnergyMc1Ch0Dimm1;

/** Offset 0x089D - Read Energy Mc1Ch1Dimm0
  Read Energy Contribution, range[255;0],(212= Def)
**/
  UINT8                       RdEnergyMc1Ch1Dimm0;

/** Offset 0x089E - Read Energy Mc1Ch1Dimm1
  Read Energy Contribution, range[255;0],(212= Def)
**/
  UINT8                       RdEnergyMc1Ch1Dimm1;

/** Offset 0x089F - Write Energy Mc0Ch0Dimm0
  Write Energy Contribution, range[255;0],(221= Def)
**/
  UINT8                       WrEnergyMc0Ch0Dimm0;

/** Offset 0x08A0 - Write Energy Mc0Ch0Dimm1
  Write Energy Contribution, range[255;0],(221= Def)
**/
  UINT8                       WrEnergyMc0Ch0Dimm1;

/** Offset 0x08A1 - Write Energy Mc0Ch1Dimm0
  Write Energy Contribution, range[255;0],(221= Def)
**/
  UINT8                       WrEnergyMc0Ch1Dimm0;

/** Offset 0x08A2 - Write Energy Mc0Ch1Dimm1
  Write Energy Contribution, range[255;0],(221= Def)
**/
  UINT8                       WrEnergyMc0Ch1Dimm1;

/** Offset 0x08A3 - Write Energy Mc1Ch0Dimm0
  Write Energy Contribution, range[255;0],(221= Def)
**/
  UINT8                       WrEnergyMc1Ch0Dimm0;

/** Offset 0x08A4 - Write Energy Mc1Ch0Dimm1
  Write Energy Contribution, range[255;0],(221= Def)
**/
  UINT8                       WrEnergyMc1Ch0Dimm1;

/** Offset 0x08A5 - Write Energy Mc1Ch1Dimm0
  Write Energy Contribution, range[255;0],(221= Def)
**/
  UINT8                       WrEnergyMc1Ch1Dimm0;

/** Offset 0x08A6 - Write Energy Mc1Ch1Dimm1
  Write Energy Contribution, range[255;0],(221= Def)
**/
  UINT8                       WrEnergyMc1Ch1Dimm1;

/** Offset 0x08A7 - Throttler CKEMin Timer
  Timer value for CKEMin, range[255;0]. Req'd min of SC_ROUND_T + BYTE_LENGTH (4).
  Dfault is 0x00
**/
  UINT8                       ThrtCkeMinTmr;

/** Offset 0x08A8 - Allow Opp Ref Below Write Threhold
  Allow opportunistic refreshes while we don't exit power down.
  $EN_DIS
**/
  UINT8                       AllowOppRefBelowWriteThrehold;

/** Offset 0x08A9 - Write Threshold
  Number of writes that can be accumulated while CKE is low before CKE is asserted.
**/
  UINT8                       WriteThreshold;

/** Offset 0x08AA - Rapl Power Floor Ch0
  Power budget ,range[255;0],(0= 5.3W Def)
**/
  UINT8                       RaplPwrFlCh0;

/** Offset 0x08AB - Rapl Power Floor Ch1
  Power budget ,range[255;0],(0= 5.3W Def)
**/
  UINT8                       RaplPwrFlCh1;

/** Offset 0x08AC - Command Rate Support
  CMD Rate and Limit Support Option. NOTE: ONLY supported in 1N Mode, Default is 3 CMDs
  0:Disable, 5:2 CMDS, 7:3 CMDS, 9:4 CMDS, 11:5 CMDS, 13:6 CMDS, 15:7 CMDS
**/
  UINT8                       EnCmdRate;

/** Offset 0x08AD - REFRESH_2X_MODE
  0- (Default)Disabled 1-iMC enables 2xRef when Warm and Hot 2- iMC enables 2xRef when Hot
  0:Disable, 1:Enabled for WARM or HOT, 2:Enabled HOT only
**/
  UINT8                       Refresh2X;

/** Offset 0x08AE - Energy Performance Gain
  Enable/disable(default) Energy Performance Gain.
  $EN_DIS
**/
  UINT8                       EpgEnable;

/** Offset 0x08AF - RH pTRR LFSR0 Mask
  Row Hammer pTRR LFSR0 Mask, 1/2^(value)
**/
  UINT8                       Lfsr0Mask;

/** Offset 0x08B0 - User Manual Threshold
  Disabled: Predefined threshold will be used.\n
  Enabled: User Input will be used.
  $EN_DIS
**/
  UINT8                       UserThresholdEnable;

/** Offset 0x08B1 - User Manual Budget
  Disabled: Configuration of memories will defined the Budget value.\n
  Enabled: User Input will be used.
  $EN_DIS
**/
  UINT8                       UserBudgetEnable;

/** Offset 0x08B2 - Power Down Mode
  This option controls command bus tristating during idle periods
  0x0:No Power Down, 0x1:APD, 0x6:PPD DLL OFF, 0xFF:Auto
**/
  UINT8                       PowerDownMode;

/** Offset 0x08B3 - Pwr Down Idle Timer
  The minimum value should = to the worst case Roundtrip delay + Burst_Length. 0 means
  AUTO: 64 for ULX/ULT, 128 for DT/Halo
**/
  UINT8                       PwdwnIdleCounter;

/** Offset 0x08B4 - Page Close Idle Timeout
  This option controls Page Close Idle Timeout
  0:Enabled, 1:Disabled
**/
  UINT8                       DisPgCloseIdleTimeout;

/** Offset 0x08B5 - Bitmask of ranks that have CA bus terminated
  Offset 225 LPDDR4: Bitmask of ranks that have CA bus terminated. <b>0x01=Default,
  Rank0 is terminating and Rank1 is non-terminating</b>
**/
  UINT8                       CmdRanksTerminated;

/** Offset 0x08B6 - PcdSerialDebugLevel
  Serial Debug Message Level. 0:Disable, 1:Error Only, 2:Error & Warnings, 3:Load,
  Error, Warnings & Info, 4:Load, Error, Warnings, Info & Event, 5:Load, Error, Warnings,
  Info & Verbose.
  0:Disable, 1:Error Only, 2:Error and Warnings, 3:Load Error Warnings and Info, 4:Load
  Error Warnings and Info & Event, 5:Load Error Warnings Info and Verbose
**/
  UINT8                       PcdSerialDebugLevel;

/** Offset 0x08B7 - Safe Mode Support
  This option configures the varous items in the IO and MC to be more conservative.(def=Disable)
  $EN_DIS
**/
  UINT8                       SafeMode;

/** Offset 0x08B8 - Ask MRC to clear memory content
  Ask MRC to clear memory content <b>0: Do not Clear Memory;</b> 1: Clear Memory.
  $EN_DIS
**/
  UINT8                       CleanMemory;

/** Offset 0x08B9 - LpDdrDqDqsReTraining
  Enable/Disable TxDqDqs ReTraining for LP4/5 and DDR5
  $EN_DIS
**/
  UINT8                       LpDdrDqDqsReTraining;

/** Offset 0x08BA - TCSS USB Port Enable
  Bitmap for per port enabling
**/
  UINT8                       UsbTcPortEnPreMem;

/** Offset 0x08BB
**/
  UINT8                       UnusedUpdSpace22;

/** Offset 0x08BC - Post Code Output Port
  This option configures Post Code Output Port
**/
  UINT16                      PostCodeOutputPort;

/** Offset 0x08BE - RMTLoopCount
  Specifies the Loop Count to be used during Rank Margin Tool Testing. 0 - AUTO
**/
  UINT8                       RMTLoopCount;

/** Offset 0x08BF - Enable/Disable SA CRID
  Enable: SA CRID, Disable (Default): SA CRID
  $EN_DIS
**/
  UINT8                       CridEnable;

/** Offset 0x08C0 - WRC Feature
  Enable/Disable WRC (Write Cache) feature of IOP. When feature is enabled, supports
  IO devices allocating onto the ring and into LLC. WRC is fused on by default.
  $EN_DIS
**/
  UINT8                       WrcFeatureEnable;

/** Offset 0x08C1
**/
  UINT8                       UnusedUpdSpace23[3];

/** Offset 0x08C4 - BCLK RFI Frequency
  Bclk RFI Frequency for each SAGV point in Hz units. 98000000Hz = 98MHz <b>0 - No
  RFI Tuning</b>. Range is 98Mhz-100Mhz.
**/
  UINT32                      BclkRfiFreq[4];

/** Offset 0x08D4 - Size of PCIe IMR.
  Size of PCIe IMR in megabytes
**/
  UINT16                      PcieImrSize;

/** Offset 0x08D6 - Enable PCIe IMR
  0: Disable(AUTO), 1: Enable
  $EN_DIS
**/
  UINT8                       PcieImrEnabled;

/** Offset 0x08D7 - Enable PCIe IMR
  1: PCH PCIE, 2: SA PCIE. If PCIeImrEnabled is TRUE then this will use to select
  the Root port location from PCH PCIe or SA PCIe
  $EN_DIS
**/
  UINT8                       PcieImrRpLocation;

/** Offset 0x08D8 - Root port number for IMR.
  Root port number for IMR.If PCieImrRpLocation is PCH PCIe then select root port
  from 0 to 23 and if it is SA PCIe then select root port from 0 to 3
**/
  UINT8                       PcieImrRpSelection;

/** Offset 0x08D9 - SerialDebugMrcLevel
  MRC Serial Debug Message Level. 0:Disable, 1:Error Only, 2:Error & Warnings, 3:Load,
  Error, Warnings & Info, 4:Load, Error, Warnings, Info & Event, 5:Load, Error, Warnings,
  Info & Verbose.
  0:Disable, 1:Error Only, 2:Error and Warnings, 3:Load Error Warnings and Info, 4:Load
  Error Warnings and Info & Event, 5:Load Error Warnings Info and Verbose
**/
  UINT8                       SerialDebugMrcLevel;

/** Offset 0x08DA - Ddr4OneDpc
  DDR4 1DPC performance feature for 2R DIMMs. Can be enabled on DIMM0 or DIMM1 only,
  or on both (default)
  0: Disabled, 1: Enabled on DIMM0 only, 2: Enabled on DIMM1 only, 3: Enabled
**/
  UINT8                       Ddr4OneDpc;

/** Offset 0x08DB - RH pTRR LFSR1 Mask
  Row Hammer pTRR LFSR1 Mask, 1/2^(value)
**/
  UINT8                       Lfsr1Mask;

/** Offset 0x08DC - LPDDR ODT RttWr
  Initial RttWr for LP4/5 in Ohms. 0x0 - Auto
**/
  UINT8                       LpddrRttWr;

/** Offset 0x08DD - LPDDR ODT RttCa
  Initial RttCa for LP4/5 in Ohms. 0x0 - Auto
**/
  UINT8                       LpddrRttCa;

/** Offset 0x08DE - REFRESH_PANIC_WM
  DEPRECATED
**/
  UINT8                       RefreshPanicWm;

/** Offset 0x08DF - REFRESH_HP_WM
  DEPRECATED
**/
  UINT8                       RefreshHpWm;

/** Offset 0x08E0 - Command Pins Mapping
  BitMask where bits [3:0] are Controller 0 Channel [3:0] and bits [7:4] are Controller
  1 Channel [3:0]. 0 = CCC pin mapping is Ascending, 1 = CCC pin mapping is Descending.
**/
  UINT8                       Lp5CccConfig;

/** Offset 0x08E1 - Command Pins Mirrored
  BitMask where bits [3:0] are Controller 0 Channel [3:0] and bits [7:4] are Controller
  1 Channel [3:0]. 0 = No Command Mirror and 1 = Command Mirror.
**/
  UINT8                       CmdMirror;

/** Offset 0x08E2 - DIMM DFE Training
  Enable/Disable DIMM DFE Training
  $EN_DIS
**/
  UINT8                       DIMMDFE;

/** Offset 0x08E3 - Extended Bank Hashing
  Enable/Disable Extended Bank Hashing
  $EN_DIS
**/
  UINT8                       ExtendedBankHashing;

/** Offset 0x08E4 - Refresh Watermarks
  Refresh Watermarks: 0-Low, 1-High (default)
  0:Set Refresh Watermarks to Low, 1:Set Refresh Watermarks to High (Default)
**/
  UINT8                       RefreshWm;

/** Offset 0x08E5 - MC_REFRESH_RATE
  Type of Refresh Rate used to prevent Row Hammer. Default is NORMAL Refresh
  0:NORMAL Refresh, 1:1x Refresh, 2:2x Refresh, 3:4x Refresh
**/
  UINT8                       McRefreshRate;

/** Offset 0x08E6 - Periodic DCC
  Enable/Disable Periodic DCC; default: Disabled
  $EN_DIS
**/
  UINT8                       PeriodicDcc;

/** Offset 0x08E7 - LpMode
  LpMode feature
  0: Auto (default), 1: Enabled, 2: Disabled, 3: Reserved
**/
  UINT8                       LpMode;

/** Offset 0x08E8 - TX DQS DCC Training
  Enable/Disable TX DQS DCC Training
  $EN_DIS
**/
  UINT8                       TXDQSDCC;

/** Offset 0x08E9 - DRAM DCA Training
  Enable/Disable DRAM DCA Training
  $EN_DIS
**/
  UINT8                       DRAMDCA;

/** Offset 0x08EA - EARLY DIMM DFE Training
  Enable/Disable EARLY DIMM DFE Training
  $EN_DIS
**/
  UINT8                       EARLYDIMMDFE;

/** Offset 0x08EB - Skip external display device scanning
  Enable: Do not scan for external display device, Disable (Default): Scan external
  display devices
  $EN_DIS
**/
  UINT8                       SkipExtGfxScan;

/** Offset 0x08EC - Generate BIOS Data ACPI Table
  Enable: Generate BDAT for MRC RMT or SA PCIe data. Disable (Default): Do not generate it
  $EN_DIS
**/
  UINT8                       BdatEnable;

/** Offset 0x08ED - Lock PCU Thermal Management registers
  Lock PCU Thermal Management registers. Enable(Default)=1, Disable=0
  $EN_DIS
**/
  UINT8                       LockPTMregs;

/** Offset 0x08EE - Rsvd
  Disable(0x0)(Default): Normal Operation - RxCTLE adaptive behavior enabled, Enable(0x1):
  Override RxCTLE - Disable RxCTLE adaptive behavior to keep the configured RxCTLE
  peak values unmodified
  $EN_DIS
**/
  UINT8                       PegGen3Rsvd;

/** Offset 0x08EF - Panel Power Enable
  Control for enabling/disabling VDD force bit (Required only for early enabling of
  eDP panel). 0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       PanelPowerEnable;

/** Offset 0x08F0 - BdatTestType
  Indicates the type of Memory Training data to populate into the BDAT ACPI table.
  0:RMT per Rank, 1:RMT per Bit, 2:Margin2D
**/
  UINT8                       BdatTestType;

/** Offset 0x08F1
**/
  UINT8                       UnusedUpdSpace24[3];

/** Offset 0x08F4 - PMR Size
  Size of PMR memory buffer. 0x400000 for normal boot and 0x200000 for S3 boot
**/
  UINT32                      DmaBufferSize;

/** Offset 0x08F8 - VT-d/IOMMU Boot Policy
  BIT0: Enable IOMMU during boot, BIT1: Enable IOMMU when transfer control to OS
**/
  UINT8                       PreBootDmaMask;

/** Offset 0x08F9
**/
  UINT8                       UnusedUpdSpace25;

/** Offset 0x08FA - Delta T12 Power Cycle Delay required in ms
  Select the value for delay required. 0= No delay, 0xFFFF(Default) = Auto calculate
  T12 Delay to max 500ms
  0 : No Delay, 0xFFFF : Auto Calulate T12 Delay
**/
  UINT16                      DeltaT12PowerCycleDelay;

/** Offset 0x08FC - Reuse Adl DDR5 Board or not
  Indicate whether adl ddr5 board is reused.
  0 : no, 1 : yes
**/
  UINT8                       ReuseAdlSDdr5Board;

/** Offset 0x08FD - Oem T12 Delay Override
  Oem T12 Delay Override. 0(Default)=Disable  1=Enable
  $EN_DIS
**/
  UINT8                       OemT12DelayOverride;

/** Offset 0x08FE - SaPreMemTestRsvd
  Reserved for SA Pre-Mem Test
  $EN_DIS
**/
  UINT8                       SaPreMemTestRsvd[89];

/** Offset 0x0957
**/
  UINT8                       UnusedUpdSpace26;

/** Offset 0x0958 - TotalFlashSize
  Enable/Disable. 0: Disable, define default value of TotalFlashSize , 1: enable
**/
  UINT16                      TotalFlashSize;

/** Offset 0x095A - BiosSize
  The size of the BIOS region of the IFWI. Used if FspmUpd->FspmConfig.BiosGuard !=
  0. If BiosGuard is enabled, MRC will increase the size of the DPR (DMA Protected
  Range) so that a BIOS Update Script can be stored in the DPR.
**/
  UINT16                      BiosSize;

/** Offset 0x095C - SecurityTestRsvd
  Reserved for SA Pre-Mem Test
  $EN_DIS
**/
  UINT8                       SecurityTestRsvd[12];

/** Offset 0x0968 - Smbus dynamic power gating
  Disable or Enable Smbus dynamic power gating.
  $EN_DIS
**/
  UINT8                       SmbusDynamicPowerGating;

/** Offset 0x0969 - Disable and Lock Watch Dog Register
  Set 1 to clear WDT status, then disable and lock WDT registers.
  $EN_DIS
**/
  UINT8                       WdtDisableAndLock;

/** Offset 0x096A - SMBUS SPD Write Disable
  Set/Clear Smbus SPD Write Disable. 0: leave SPD Write Disable bit; 1: set SPD Write
  Disable bit. For security recommendations, SPD write disable bit must be set.
  $EN_DIS
**/
  UINT8                       SmbusSpdWriteDisable;

/** Offset 0x096B - Force ME DID Init Status
  Test, 0: disable, 1: Success, 2: No Memory in Channels, 3: Memory Init Error, Set
  ME DID init stat value
  $EN_DIS
**/
  UINT8                       DidInitStat;

/** Offset 0x096C - CPU Replaced Polling Disable
  Test, 0: disable, 1: enable, Setting this option disables CPU replacement polling loop
  $EN_DIS
**/
  UINT8                       DisableCpuReplacedPolling;

/** Offset 0x096D - Check HECI message before send
  Test, 0: disable, 1: enable, Enable/Disable message check.
  $EN_DIS
**/
  UINT8                       DisableMessageCheck;

/** Offset 0x096E - Skip MBP HOB
  Test, 0: disable, 1: enable, Enable/Disable MOB HOB.
  $EN_DIS
**/
  UINT8                       SkipMbpHob;

/** Offset 0x096F - HECI2 Interface Communication
  Test, 0: disable, 1: enable, Adds or Removes HECI2 Device from PCI space.
  $EN_DIS
**/
  UINT8                       HeciCommunication2;

/** Offset 0x0970 - Enable KT device
  Test, 0: disable, 1: enable, Enable or Disable KT device.
  $EN_DIS
**/
  UINT8                       KtDeviceEnable;

/** Offset 0x0971 - Skip CPU replacement check
  Test, 0: disable, 1: enable, Setting this option to skip CPU replacement check
  $EN_DIS
**/
  UINT8                       SkipCpuReplacementCheck;

/** Offset 0x0972
**/
  UINT8                       UnusedUpdSpace27[2];

/** Offset 0x0974 - Hybrid Graphics GPIO information for PEG 1
  Hybrid Graphics GPIO information for PEG 1, for Reset, power and wake GPIOs
**/
  UINT32                      CpuPcie1Rtd3Gpio[24];

/** Offset 0x09D4 - Hybrid Graphics GPIO information for PEG 2
  Hybrid Graphics GPIO information for PEG 2, for Reset, power and wake GPIOs
**/
  UINT32                      CpuPcie2Rtd3Gpio[24];

/** Offset 0x0A34 - Hybrid Graphics GPIO information for PEG 3
  Hybrid Graphics GPIO information for PEG 3, for Reset, power and wake GPIOs
**/
  UINT32                      CpuPcie3Rtd3Gpio[24];

/** Offset 0x0A94 - Avx2 Voltage Guardband Scaling Factor
  AVX2 Voltage Guardband Scale factor applied to AVX2 workloads. Range is 0-200 in
  1/100 units, where a value of 125 would apply a 1.25 scale factor.
**/
  UINT8                       Avx2VoltageScaleFactor;

/** Offset 0x0A95 - Avx512 Voltage Guardband Scaling Factor
  DEPRECATED
**/
  UINT8                       Avx512VoltageScaleFactor;

/** Offset 0x0A96 - Serial Io Uart Debug Mode
  Select SerialIo Uart Controller mode
  0:SerialIoUartDisabled, 1:SerialIoUartPci, 2:SerialIoUartHidden, 3:SerialIoUartCom,
  4:SerialIoUartSkipInit
**/
  UINT8                       SerialIoUartDebugMode;

/** Offset 0x0A97
**/
  UINT8                       UnusedUpdSpace28;

/** Offset 0x0A98 - SerialIoUartDebugRxPinMux - FSPT
  Select RX pin muxing for SerialIo UART used for debug
**/
  UINT32                      SerialIoUartDebugRxPinMux;

/** Offset 0x0A9C - SerialIoUartDebugTxPinMux - FSPM
  Select TX pin muxing for SerialIo UART used for debug
**/
  UINT32                      SerialIoUartDebugTxPinMux;

/** Offset 0x0AA0 - SerialIoUartDebugRtsPinMux - FSPM
  Select SerialIo Uart used for debug Rts pin muxing. Refer to GPIO_*_MUXING_SERIALIO_UARTx_RTS*
  for possible values.
**/
  UINT32                      SerialIoUartDebugRtsPinMux;

/** Offset 0x0AA4 - SerialIoUartDebugCtsPinMux - FSPM
  Select SerialIo Uart used for debug Cts pin muxing. Refer to GPIO_*_MUXING_SERIALIO_UARTx_CTS*
  for possible values.
**/
  UINT32                      SerialIoUartDebugCtsPinMux;

/** Offset 0x0AA8 - Iotg Pll SscEn
  Enable or disable CPU SSC. 0: Disable, <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       IotgPllSscEn;

/** Offset 0x0AA9
**/
  UINT8                       UnusedUpdSpace29[3];

/** Offset 0x0AAC - Tcc Cache Config File Base Address
  Tcc (Time Coordinated Computing) Cache Config File File Base Address
**/
  UINT32                      TccCacheCfgBasePreMem;

/** Offset 0x0AB0 - Tcc Cache Config File Size
  Tcc (Time Coordinated Computing) Cache Config File Size
**/
  UINT32                      TccCacheCfgSizePreMem;

/** Offset 0x0AB4 - Tcc Stream Config File Base Address
  Tcc (Time Coordinated Computing) Stream Config File Base Address
**/
  UINT32                      TccStreamCfgBasePreMem;

/** Offset 0x0AB8 - Tcc Stream Config File Size
  Tcc (Time Coordinated Computing) Stream Config File Size
**/
  UINT32                      TccStreamCfgSizePreMem;

/** Offset 0x0ABC - Software SRAM enable/disable
  Enable will allocate part of LLC as SSRAM. If Cache Configuration Subregion is available,
  it will allocate base off Cache Configuration Subregion
  $EN_DIS
**/
  UINT8                       SoftwareSramEnPreMem;

/** Offset 0x0ABD - Data Streams Optimizer enable/disable
  Enable will utilize DSO Subregion to tune system.
  $EN_DIS
**/
  UINT8                       DsoTuningEnPreMem;

/** Offset 0x0ABE - TCC Error Log enable/disable
  Enable will log errors from TCC Flow.
  $EN_DIS
**/
  UINT8                       TccErrorLogEnPreMem;

/** Offset 0x0ABF - Enable/Disable MC Starv2Med Priority on New Request
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       DisableStarv2medPrioOnNewReq;

/** Offset 0x0AC0 - Ppr Enable Type
  Enable Soft or Hard PPR <b>0:Disable</b>, 2:Hard PPR
  0:Disable, 2:Hard PPR
**/
  UINT8                       PprEnable;

/** Offset 0x0AC1 - Margin Limit Check
  Margin Limit Check. Choose level of margin check
  0:Disable, 1:L1, 2:L2, 3:Both
**/
  UINT8                       MarginLimitCheck;

/** Offset 0x0AC2 - Margin Limit L2
  % of L1 check for margin limit check
**/
  UINT16                      MarginLimitL2;

/** Offset 0x0AC4 - DEKEL CDR Relock
  Enable/Disable CDR Relock. 0: Disable(Default); 1: Enable
**/
  UINT8                       CpuPcieRpCdrRelock[4];

/** Offset 0x0AC8 - DMI DEKEL CDR Relock
  Enable/Disable CPU DMI CDR Relock. 0: Disable(Default); 1: Enable
  $EN_DIS
**/
  UINT8                       DmiCdrRelock;

/** Offset 0x0AC9 - IbeccErrInjControl
  IBECC Error Injection Control
  0: No Error Injection, 1:Inject Correctable Error Address match, 3:Inject Correctable
  Error on insertion counter, 5: Inject Uncorrectable Error Address match, 7:Inject
  Uncorrectable Error on insertion counter
**/
  UINT8                       IbeccErrInjControl;

/** Offset 0x0ACA
**/
  UINT8                       UnusedUpdSpace30[6];

/** Offset 0x0AD0 - IbeccErrInjAddress
  Address to match against for ECC error injection
**/
  UINT64                      IbeccErrInjAddress;

/** Offset 0x0AD8 - IbeccErrInjMask
  Mask to match against for ECC error injection
**/
  UINT64                      IbeccErrInjMask;

/** Offset 0x0AE0 - IbeccErrInjCount
  Number of transactions between ECC error injection
**/
  UINT32                      IbeccErrInjCount;

/** Offset 0x0AE4 - Pointer EnableDmaBuffer
  Pointer of EnableDmaBuffer Callback Function.
**/
  UINT8                       EnableDmaBuffer[8];

/** Offset 0x0AEC - PLL Max Banding Ratio
  DEPRECATED
**/
  UINT8                       PllMaxBandingRatio;

/** Offset 0x0AED
**/
  UINT8                       UnusedUpdSpace31[3];

/** Offset 0x0AF0 - Debug Value
  Debug Value
**/
  UINT32                      DebugValue;

/** Offset 0x0AF4 - Pre-Mem GPIO table address
  AlderLake S needs to assert PCIe SLOT RTD3 and PEG reset pins in early PreMem phase.
  0: Skip FSP PCIe pins programming. Refer to mAdlSPcieRstPinGpioTable[] in GpioSampleDef.h.
**/
  UINT32                      BoardGpioTablePreMemAddress;

/** Offset 0x0AF8
**/
  UINT8                       TccStreamCfgStatusPreMem;

/** Offset 0x0AF9
**/
  UINT8                       UnusedUpdSpace32;

/** Offset 0x0AFA - tRFCpb
  Min Internal per bank refresh recovery delay time, 0: AUTO, max: 0xFFFF. Only used
  if FspmUpd->FspmConfig.SpdProfileSelected == 1 (Custom Profile).
**/
  UINT16                      tRFCpb;

/** Offset 0x0AFC - tRFC2
  Min Internal refresh recovery delay time, 0: AUTO, max: 0xFFFF. Only used if FspmUpd->FspmConfig.SpdProfileSelected
  == 1 (Custom Profile).
**/
  UINT16                      tRFC2;

/** Offset 0x0AFE - tRFC4
  Min Internal refresh recovery delay time, 0: AUTO, max: 0xFFFF. Only used if FspmUpd->FspmConfig.SpdProfileSelected
  == 1 (Custom Profile).
**/
  UINT16                      tRFC4;

/** Offset 0x0B00 - tRRD_L
  Min Internal row active to row active delay time for same bank groups, 0: AUTO,
  max: 80. Only used if FspmUpd->FspmConfig.SpdProfileSelected == 1 (Custom Profile).
**/
  UINT8                       tRRD_L;

/** Offset 0x0B01 - tRRD_S
  Min Internal row active to row active delay time for different bank groups, 0: AUTO,
  max: 80. Only used if FspmUpd->FspmConfig.SpdProfileSelected == 1 (Custom Profile).
**/
  UINT8                       tRRD_S;

/** Offset 0x0B02 - tWTR_L
  Min Internal write to read command delay time for same bank groups, 0: AUTO, max:
  127. Only used if FspmUpd->FspmConfig.SpdProfileSelected == 1 (Custom Profile).
**/
  UINT8                       tWTR_L;

/** Offset 0x0B03 - tCCD_L
  Min Internal CAS-to-CAS delay for same bank group, 0: AUTO, max: 80. Only used if
  FspmUpd->FspmConfig.SpdProfileSelected == 1 (Custom Profile).
**/
  UINT8                       tCCD_L;

/** Offset 0x0B04 - tWTR_S
  Min Internal write to read command delay time for different bank groups, 0: AUTO,
  max: 50. Only used if FspmUpd->FspmConfig.SpdProfileSelected == 1 (Custom Profile).
**/
  UINT8                       tWTR_S;

/** Offset 0x0B05
**/
  UINT8                       UnusedUpdSpace33[3];

/** Offset 0x0B08 - EccErrInjAddress
  Address to match against for ECC error injection
**/
  UINT64                      EccErrInjAddress;

/** Offset 0x0B10 - EccErrInjMask
  Mask to match against for ECC error injection
**/
  UINT64                      EccErrInjMask;

/** Offset 0x0B18 - EccErrInjCount
  Number of transactions between ECC error injection
**/
  UINT32                      EccErrInjCount;

/** Offset 0x0B1C - Frequency Limit for 2DPC Mixed or non-POR Config
  Frequency Limit for 2DPC Mixed or non-POR Config. 0: Auto (default), otherwise a
  frequency in MT/s
**/
  UINT16                      FreqLimitMixedConfig;

/** Offset 0x0B1E - First Dimm BitMask
  Defines which DIMM should be populated first on a 2DPC board. Bit0: MC0 DIMM0, Bit1:
  MC0 DIMM1, Bit2: MC1 DIMM0, Bit3: MC1 DIMM1. For each MC, the first DIMM to be
  populated should be set to '1'
**/
  UINT8                       FirstDimmBitMask;

/** Offset 0x0B1F - SAGV Switch Factor IA DDR BW
  SAGV Switch Factor IA DDR BW: IA DDR load percentage when system switch to high
  SAGV point from 1 to 50%.
**/
  UINT8                       SagvSwitchFactorIA;

/** Offset 0x0B20 - SAGV Switch Factor GT DDR BW
  SAGV Switch Factor GT DDR BW: GT DDR load percentage when system switch to high
  SAGV point from 1 to 50%.
**/
  UINT8                       SagvSwitchFactorGT;

/** Offset 0x0B21 - SAGV Switch Factor IO DDR BW
  SAGV Switch Factor IO DDR BW: IO DDR load percentage when system switch to high
  SAGV point from 1 to 50%.
**/
  UINT8                       SagvSwitchFactorIO;

/** Offset 0x0B22 - SAGV Switch Factor IA and GT Stall
  SAGV Switch Factor IA and GT Stall: IA and GT percentage when system switch to high
  SAGV point from 1 to 50%.
**/
  UINT8                       SagvSwitchFactorStall;

/** Offset 0x0B23 - Threshold For Switch Down
  SAGV heuristics down control: Duration in ms of low activity after which SAGV will
  switch down, from 1 to 50ms.
**/
  UINT8                       SagvHeuristicsDownControl;

/** Offset 0x0B24 - Threshold For Switch Up
  SAGV heuristics up control: Duration in ms of low activity after which SAGV will
  switch up, from 1 to 50ms.
**/
  UINT8                       SagvHeuristicsUpControl;

/** Offset 0x0B25
**/
  UINT8                       UnusedUpdSpace34;

/** Offset 0x0B26 - Frequency Limit for Mixed 2DPC DDR5 1 Rank 8GB and 8GB
  Frequency Limit for 2DPC Mixed or non-POR Config. 0: Auto, otherwise a frequency
  in MT/s, default is 2000
**/
  UINT16                      FreqLimitMixedConfig_1R1R_8GB;

/** Offset 0x0B28 - Frequency Limit for Mixed 2DPC DDR5 1 Rank 16GB and 16GB
  Frequency Limit for 2DPC Mixed or non-POR Config. 0: Auto, otherwise a frequency
  in MT/s, default is 2000
**/
  UINT16                      FreqLimitMixedConfig_1R1R_16GB;

/** Offset 0x0B2A - Frequency Limit for Mixed 2DPC DDR5 1 Rank 8GB and 16GB
  Frequency Limit for 2DPC Mixed or non-POR Config. 0: Auto, otherwise a frequency
  in MT/s, default is 2000
**/
  UINT16                      FreqLimitMixedConfig_1R1R_8GB_16GB;

/** Offset 0x0B2C - Frequency Limit for Mixed 2DPC DDR5 2 Rank
  Frequency Limit for 2DPC Mixed or non-POR Config. 0: Auto, otherwise a frequency
  in MT/s, default is 2000
**/
  UINT16                      FreqLimitMixedConfig_2R2R;

/** Offset 0x0B2E - DMI Hw Eq Gen3 CoeffList Cm
  PCH_DMI_EQ_PARAM. Coefficient C-1.
**/
  UINT8                       PchDmiHwEqGen3CoeffListCm[8];

/** Offset 0x0B36 - DMI Hw Eq Gen3 CoeffList Cp
  PCH_DMI_EQ_PARAM. Coefficient C+1.
**/
  UINT8                       PchDmiHwEqGen3CoeffListCp[8];

/** Offset 0x0B3E -  LCT Command eyewidth
   LCT Command eyewidth. 0: Auto, otherwise eyewidth , default is 96
**/
  UINT16                      LctCmdEyeWidth;

/** Offset 0x0B40 - For LPDDR Only: Throttler CKEMin Timer
  For LPDDR Only: Timer value for CKEMin, range[255;0]. Reqd min of SC_ROUND_T + BYTE_LENGTH
  (4). Dfault is 0x00
**/
  UINT8                       ThrtCkeMinTmrLpddr;

/** Offset 0x0B41 - First ECC Dimm BitMask
  Defines which ECC DIMM should be populated first on a 2DPC board. Bit0: MC0 DIMM0,
  Bit1: MC0 DIMM1, Bit2: MC1 DIMM0, Bit3: MC1 DIMM1. For each MC, the first DIMM
  to be populated should be set to '1'
**/
  UINT8                       FirstDimmBitMaskEcc;

/** Offset 0x0B42 -  LP5 Bank Mode
  LP5 Bank Mode. 0: Auto, 1: 8 Bank Mode, 2: 16 Bank Mode, 3: BG Mode, default is 0
  0:Auto, 1:8 Bank Mode, 2:16 Bank Mode, 3:BG Mode
**/
  UINT8                       Lp5BankMode;

/** Offset 0x0B43 - Write DS Training
  Enable/Disable Write DS Training
  $EN_DIS
**/
  UINT8                       WRDS;

/** Offset 0x0B44
**/
  UINT8                       UnusedUpdSpace35[5];

/** Offset 0x0B49
**/
  UINT8                       ReservedFspmUpd2[7];
} FSP_M_CONFIG;

/** Fsp M UPD Configuration
**/
typedef struct {

/** Offset 0x0000
**/
  FSP_UPD_HEADER              FspUpdHeader;

/** Offset 0x0020
**/
  FSPM_ARCH_UPD               FspmArchUpd;

/** Offset 0x0040
**/
  FSP_M_CONFIG                FspmConfig;

/** Offset 0x0B50
**/
  UINT8                       UnusedUpdSpace36[6];

/** Offset 0x0B56
**/
  UINT16                      UpdTerminator;
} FSPM_UPD;

#pragma pack()

#endif
