/** @file

Copyright (c) 2019, Intel Corporation. All rights reserved.<BR>

  SPDX-License-Identifier: BSD-2-Clause-Patent

  This file is automatically generated. Please do NOT modify !!!

**/

#ifndef __FSPTUPD_H__
#define __FSPTUPD_H__

#include <FspUpd.h>

#pragma pack(1)


/** Fsp T Core UPD
**/
typedef struct {

/** Offset 0x0020
**/
  UINT32                      MicrocodeRegionBase;

/** Offset 0x0024
**/
  UINT32                      MicrocodeRegionSize;

/** Offset 0x0028
**/
  UINT32                      CodeRegionBase;

/** Offset 0x002C
**/
  UINT32                      CodeRegionSize;

/** Offset 0x0030
**/
  UINT8                       Reserved[16];
} FSPT_CORE_UPD;

/** Fsp T Configuration
**/
typedef struct {

/** Offset 0x0040 - PcdSerialIoUartDebugEnable
  Enable SerialIo Uart debug library with/without initializing SerialIo Uart device in FSP.
  0:Disable, 1:Enable and Initialize, 2:Enable without Initializing
**/
  UINT8                       PcdSerialIoUartDebugEnable;

/** Offset 0x0041 - PcdSerialIoUartNumber - FSPT
  Select SerialIo Uart Controller for debug. Note: If UART0 is selected as CNVi BT
  Core interface, it cannot be used for debug purpose.
  0:SerialIoUart0, 1:SerialIoUart1, 2:SerialIoUart2
**/
  UINT8                       PcdSerialIoUartNumber;

/** Offset 0x0042 - PcdSerialIoUartMode - FSPT
  Select SerialIo Uart Controller mode
  0:SerialIoUartDisabled, 1:SerialIoUartPci, 2:SerialIoUartHidden, 3:SerialIoUartCom,
  4:SerialIoUartSkipInit
**/
  UINT8                       PcdSerialIoUartMode;

/** Offset 0x0043
**/
  UINT8                       UnusedUpdSpace0;

/** Offset 0x0044 - PcdSerialIoUartBaudRate - FSPT
  Set default BaudRate Supported from 0 - default to 6000000
**/
  UINT32                      PcdSerialIoUartBaudRate;

/** Offset 0x0048 - Pci Express Base Address
  Base address to be programmed for Pci Express
**/
  UINT64                      PcdPciExpressBaseAddress;

/** Offset 0x0050 - Pci Express Region Length
  Region Length to be programmed for Pci Express
**/
  UINT32                      PcdPciExpressRegionLength;

/** Offset 0x0054 - PcdSerialIoUartParity - FSPT
  Set default Parity.
  0: DefaultParity, 1: NoParity, 2: EvenParity, 3: OddParity
**/
  UINT8                       PcdSerialIoUartParity;

/** Offset 0x0055 - PcdSerialIoUartDataBits - FSPT
  Set default word length. 0: Default, 5,6,7,8
**/
  UINT8                       PcdSerialIoUartDataBits;

/** Offset 0x0056 - PcdSerialIoUartStopBits - FSPT
  Set default stop bits.
  0: DefaultStopBits, 1: OneStopBit, 2: OneFiveStopBits, 3: TwoStopBits
**/
  UINT8                       PcdSerialIoUartStopBits;

/** Offset 0x0057 - PcdSerialIoUartAutoFlow - FSPT
  Enables UART hardware flow control, CTS and RTS lines.
  0: Disable, 1:Enable
**/
  UINT8                       PcdSerialIoUartAutoFlow;

/** Offset 0x0058 - PcdSerialIoUartPinMux - FSPT
  Applies only to UART0 muxed with CNVI <b> 0 = GPIO C8 to C11 </b> 1 = GPIO F5 -
  F7 (PCH LP) J5 - J7 (PCH H)
  0: GPIO C8 to C11, 1: GPIO F5 - F7 (PCH LP) J5 - J7 (PCH H)
**/
  UINT8                       PcdSerialIoUartPinMux;

/** Offset 0x0059 - PcdLpcUartDebugEnable
  Enable to initialize LPC Uart device in FSP.
  0:Disable, 1:Enable
**/
  UINT8                       PcdLpcUartDebugEnable;

/** Offset 0x005A - Debug Interfaces
  Debug Interfaces. BIT0-RAM, BIT1-UART, BIT3-USB3, BIT4-Serial IO, BIT5-TraceHub,
  BIT2 - Not used.
**/
  UINT8                       PcdDebugInterfaceFlags;

/** Offset 0x005B - PcdSerialDebugLevel
  Serial Debug Message Level. 0:Disable, 1:Error Only, 2:Error & Warnings, 3:Load,
  Error, Warnings & Info, 4:Load, Error, Warnings, Info & Event, 5:Load, Error, Warnings,
  Info & Verbose.
  0:Disable, 1:Error Only, 2:Error and Warnings, 3:Load Error Warnings and Info, 4:Load
  Error Warnings and Info, 5:Load Error Warnings Info and Verbose
**/
  UINT8                       PcdSerialDebugLevel;

/** Offset 0x005C - ISA Serial Base selection
  Select ISA Serial Base address. Default is 0x3F8.
  0:0x3F8, 1:0x2F8
**/
  UINT8                       PcdIsaSerialUartBase;

/** Offset 0x005D
**/
  UINT8                       UnusedUpdSpace1[7];

/** Offset 0x0064
**/
  UINT8                       ReservedFsptUpd1[20];
} FSP_T_CONFIG;

/** Fsp T UPD Configuration
**/
typedef struct {

/** Offset 0x0000
**/
  FSP_UPD_HEADER              FspUpdHeader;

/** Offset 0x0020
**/
  FSPT_CORE_UPD               FsptCoreUpd;

/** Offset 0x0040
**/
  FSP_T_CONFIG                FsptConfig;

/** Offset 0x0078
**/
  UINT8                       UnusedUpdSpace2[6];

/** Offset 0x007E
**/
  UINT16                      UpdTerminator;
} FSPT_UPD;

#pragma pack()

#endif
