;; backend.scm - Base class for package-format-specific code.
;; Written by Tom Tromey <tromey@cygnus.com>

(use-modules (ice-9 slib))
(require 'yasos)

(define (make-backend package-name)
  (let (
	;; List of all install directories.
	(directory-list '())
	)

    (object
     ;; Return name of package.
     ((get-name)
      package-name)

     ;; FILE is the name of a file we depend on.  This method turns this
     ;; into an actual dependency and adds it to the dependency list.
     ((add-file-dependency file)
      (error "Operation not supported: add-file-dependency"))

     ;; Add an install directory.  Directory is relative to the root
     ;; directory.
     ((add-install-directory directory)
      (set! directory-list (cons directory directory-list)))

     ;; Add an install file.  FILE is relative to the root directory.
     ((add-install-file file)
      (error "Operation not supported: add-install-file"))

     ;; Add a command to be run before installation.
     ((add-pre-install-command text)
      (error "Operation not supported: add-pre-install-command"))

     ;; Add a command to be run after installation.
     ((add-post-install-command text)
      (error "Operation not supported: add-post-install-command"))

     ;; Add a command to be run before deinstallation.
     ((add-pre-uninstall-command text)
      (error "Operation not supported: add-pre-uninstall-command"))

     ;; Add a command to be run after deinstallation.
     ((add-post-uninstall-command text)
      (error "Operation not supported: add-post-uninstall-command"))

     ;; Set some metadata.  This is rather free-form.  Some keys will be
     ;; predefined, but we don't know them yet.
     ((set-metadata key value)
      (error "Operation not supported: set-metadata"))

     ;; This throws an error if something, like a piece of metadata, is
     ;; missing.
     ((check)
      (error "Operation not supported: check"))

     ;; This creates the package and throws an error if something goes
     ;; wrong.
     ((create-package)
      (error "Operation not supported: create-package"))

     ;; The following methods are `protected' and should only be used
     ;; by subclasses.

     ;; Return list of install directories in topological order.
     ((list-install-directories)
      (error "Operation not supported: list-install-directories")))))