;; main.scm - Main program for autopackage.
;; Written by Tom Tromey <tromey@cygnus.com>

(define (help)
  ;; FIXME
  '())

(define (version)
  ;; FIXME.
  '())

;; Process a single sub-package.
(define (process-sub-package type package-name)
  (let ((package (make-package type package)))
    ;; Install the subpackage.
    (install-subpackage package)

    ;; Extract dependency information.
    (extract-dependencies package)

    ;; Uninstall package.
    (uninstall-subpackage package)

    ;; Finish.
    (check package)
    (create-package package)
    ))

(define (parse-options)
  (let ((opt-alist (getopt-long (command-line)
				'(version (single-char ?v))
				'(help (single-char ?h))
				'(backend (single-char ?b)
					  (value #t)
					  (predicate is-backend-name?)
					  (required? #t)))))

    ;; Some special options which exit.
    (if (assq 'version opt-alist)
	(version)
	(if (assq 'help opt-alist)
	    (help)))

    ;; Optionally configure the tree.
    (if (FIXME: configure-tree?)
	(configure-tree configure-options))

    ;; Create a new package object for each package.
    (if (null? package-list)
	(set! package-list (default-package-list)))
    (for-each (lambda (package-name)
		(process-sub-package type package-name)))))

(parse-options)
