/* This file is automatically generated by aarch64-gen.  Do not edit!  */
/* Copyright (C) 2012-2020 Free Software Foundation, Inc.
   Contributed by ARM Ltd.

   This file is part of the GNU opcodes library.

   This library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   It is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING3. If not,
   see <http://www.gnu.org/licenses/>.  */

#include "sysdep.h"
#include "aarch64-dis.h"

/* Called by aarch64_opcode_lookup.  */

static int
aarch64_opcode_lookup_1 (uint32_t word)
{
  if (((word >> 26) & 0x1) == 0)
    {
      if (((word >> 25) & 0x1) == 0)
        {
          if (((word >> 27) & 0x1) == 0)
            {
              if (((word >> 24) & 0x1) == 0)
                {
                  if (((word >> 28) & 0x1) == 0)
                    {
                      /* 33222222222211111111110000000000
                         10987654321098765432109876543210
                         xxx00000xxxxxxxxxxxxxxxxxxxxxxxx
                         udf.  */
                      return 754;
                    }
                  else
                    {
                      if (((word >> 31) & 0x1) == 0)
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             0xx10000xxxxxxxxxxxxxxxxxxxxxxxx
                             adr.  */
                          return 1187;
                        }
                      else
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             1xx10000xxxxxxxxxxxxxxxxxxxxxxxx
                             adrp.  */
                          return 1188;
                        }
                    }
                }
              else
                {
                  if (((word >> 29) & 0x1) == 0)
                    {
                      if (((word >> 30) & 0x1) == 0)
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             x00x0001xxxxxxxxxxxxxxxxxxxxxxxx
                             add.  */
                          return 12;
                        }
                      else
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             x10x0001xxxxxxxxxxxxxxxxxxxxxxxx
                             sub.  */
                          return 16;
                        }
                    }
                  else
                    {
                      if (((word >> 30) & 0x1) == 0)
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             x01x0001xxxxxxxxxxxxxxxxxxxxxxxx
                             adds.  */
                          return 14;
                        }
                      else
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             x11x0001xxxxxxxxxxxxxxxxxxxxxxxx
                             subs.  */
                          return 17;
                        }
                    }
                }
            }
          else
            {
              if (((word >> 28) & 0x1) == 0)
                {
                  if (((word >> 22) & 0x1) == 0)
                    {
                      if (((word >> 23) & 0x1) == 0)
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 15) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0000100x000xxxxx0xxxxxxxxxxxxxxx
                                                 stxrb.  */
                                              return 937;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0100100x000xxxxx0xxxxxxxxxxxxxxx
                                                 stxrh.  */
                                              return 943;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             1x00100x000xxxxx0xxxxxxxxxxxxxxx
                                             stxr.  */
                                          return 949;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             0x00100x001xxxxx0xxxxxxxxxxxxxxx
                                             casp.  */
                                          return 1022;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             1x00100x001xxxxx0xxxxxxxxxxxxxxx
                                             stxp.  */
                                          return 951;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0000100x000xxxxx1xxxxxxxxxxxxxxx
                                                 stlxrb.  */
                                              return 938;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0100100x000xxxxx1xxxxxxxxxxxxxxx
                                                 stlxrh.  */
                                              return 944;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             1x00100x000xxxxx1xxxxxxxxxxxxxxx
                                             stlxr.  */
                                          return 950;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             0x00100x001xxxxx1xxxxxxxxxxxxxxx
                                             caspl.  */
                                          return 1024;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             1x00100x001xxxxx1xxxxxxxxxxxxxxx
                                             stlxp.  */
                                          return 952;
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     x010100x00xxxxxxxxxxxxxxxxxxxxxx
                                     stnp.  */
                                  return 971;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     x110100x00xxxxxxxxxxxxxxxxxxxxxx
                                     stgp.  */
                                  return 980;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 15) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             0x00100x100xxxxx0xxxxxxxxxxxxxxx
                                             stllrb.  */
                                          return 969;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             1x00100x100xxxxx0xxxxxxxxxxxxxxx
                                             stllr.  */
                                          return 968;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0000100x101xxxxx0xxxxxxxxxxxxxxx
                                                 casb.  */
                                              return 1010;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0100100x101xxxxx0xxxxxxxxxxxxxxx
                                                 cash.  */
                                              return 1011;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             1x00100x101xxxxx0xxxxxxxxxxxxxxx
                                             cas.  */
                                          return 1012;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0000100x100xxxxx1xxxxxxxxxxxxxxx
                                                 stlrb.  */
                                              return 941;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0100100x100xxxxx1xxxxxxxxxxxxxxx
                                                 stlrh.  */
                                              return 947;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             1x00100x100xxxxx1xxxxxxxxxxxxxxx
                                             stlr.  */
                                          return 957;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0000100x101xxxxx1xxxxxxxxxxxxxxx
                                                 caslb.  */
                                              return 1014;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0100100x101xxxxx1xxxxxxxxxxxxxxx
                                                 caslh.  */
                                              return 1017;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             1x00100x101xxxxx1xxxxxxxxxxxxxxx
                                             casl.  */
                                          return 1020;
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     x010100x10xxxxxxxxxxxxxxxxxxxxxx
                                     stp.  */
                                  return 981;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     x110100x10xxxxxxxxxxxxxxxxxxxxxx
                                     stgp.  */
                                  return 986;
                                }
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 23) & 0x1) == 0)
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 15) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0000100x010xxxxx0xxxxxxxxxxxxxxx
                                                 ldxrb.  */
                                              return 939;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0100100x010xxxxx0xxxxxxxxxxxxxxx
                                                 ldxrh.  */
                                              return 945;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             1x00100x010xxxxx0xxxxxxxxxxxxxxx
                                             ldxr.  */
                                          return 953;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             0x00100x011xxxxx0xxxxxxxxxxxxxxx
                                             caspa.  */
                                          return 1023;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             1x00100x011xxxxx0xxxxxxxxxxxxxxx
                                             ldxp.  */
                                          return 955;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0000100x010xxxxx1xxxxxxxxxxxxxxx
                                                 ldaxrb.  */
                                              return 940;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0100100x010xxxxx1xxxxxxxxxxxxxxx
                                                 ldaxrh.  */
                                              return 946;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             1x00100x010xxxxx1xxxxxxxxxxxxxxx
                                             ldaxr.  */
                                          return 954;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             0x00100x011xxxxx1xxxxxxxxxxxxxxx
                                             caspal.  */
                                          return 1025;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             1x00100x011xxxxx1xxxxxxxxxxxxxxx
                                             ldaxp.  */
                                          return 956;
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     x010100x01xxxxxxxxxxxxxxxxxxxxxx
                                     ldnp.  */
                                  return 972;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     x110100x01xxxxxxxxxxxxxxxxxxxxxx
                                     ldpsw.  */
                                  return 979;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 15) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0000100x110xxxxx0xxxxxxxxxxxxxxx
                                                 ldlarb.  */
                                              return 966;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0100100x110xxxxx0xxxxxxxxxxxxxxx
                                                 ldlarh.  */
                                              return 967;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             1x00100x110xxxxx0xxxxxxxxxxxxxxx
                                             ldlar.  */
                                          return 965;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0000100x111xxxxx0xxxxxxxxxxxxxxx
                                                 casab.  */
                                              return 1013;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0100100x111xxxxx0xxxxxxxxxxxxxxx
                                                 casah.  */
                                              return 1016;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             1x00100x111xxxxx0xxxxxxxxxxxxxxx
                                             casa.  */
                                          return 1019;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0000100x110xxxxx1xxxxxxxxxxxxxxx
                                                 ldarb.  */
                                              return 942;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0100100x110xxxxx1xxxxxxxxxxxxxxx
                                                 ldarh.  */
                                              return 948;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             1x00100x110xxxxx1xxxxxxxxxxxxxxx
                                             ldar.  */
                                          return 958;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0000100x111xxxxx1xxxxxxxxxxxxxxx
                                                 casalb.  */
                                              return 1015;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 0100100x111xxxxx1xxxxxxxxxxxxxxx
                                                 casalh.  */
                                              return 1018;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             1x00100x111xxxxx1xxxxxxxxxxxxxxx
                                             casal.  */
                                          return 1021;
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     x010100x11xxxxxxxxxxxxxxxxxxxxxx
                                     ldp.  */
                                  return 982;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     x110100x11xxxxxxxxxxxxxxxxxxxxxx
                                     ldpsw.  */
                                  return 985;
                                }
                            }
                        }
                    }
                }
              else
                {
                  if (((word >> 24) & 0x1) == 0)
                    {
                      if (((word >> 29) & 0x1) == 0)
                        {
                          if (((word >> 31) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 0x011000xxxxxxxxxxxxxxxxxxxxxxxx
                                 ldr.  */
                              return 987;
                            }
                          else
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     10011000xxxxxxxxxxxxxxxxxxxxxxxx
                                     ldrsw.  */
                                  return 989;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     11011000xxxxxxxxxxxxxxxxxxxxxxxx
                                     prfm.  */
                                  return 990;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 10) & 0x1) == 0)
                            {
                              if (((word >> 11) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 23) & 0x1) == 0)
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         00111000000xxxxxxxxx00xxxxxxxxxx
                                                         sturb.  */
                                                      return 922;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         01111000000xxxxxxxxx00xxxxxxxxxx
                                                         sturh.  */
                                                      return 927;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     1x111000000xxxxxxxxx00xxxxxxxxxx
                                                     stur.  */
                                                  return 930;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         00111000010xxxxxxxxx00xxxxxxxxxx
                                                         ldurb.  */
                                                      return 923;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         01111000010xxxxxxxxx00xxxxxxxxxx
                                                         ldurh.  */
                                                      return 928;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     1x111000010xxxxxxxxx00xxxxxxxxxx
                                                     ldur.  */
                                                  return 931;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001110001x0xxxxxxxxx00xxxxxxxxxx
                                                     ldursb.  */
                                                  return 924;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     101110001x0xxxxxxxxx00xxxxxxxxxx
                                                     ldursw.  */
                                                  return 932;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     011110001x0xxxxxxxxx00xxxxxxxxxx
                                                     ldursh.  */
                                                  return 929;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     111110001x0xxxxxxxxx00xxxxxxxxxx
                                                     prfum.  */
                                                  return 933;
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  if (((word >> 15) & 0x1) == 0)
                                                    {
                                                      if (((word >> 22) & 0x1) == 0)
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         00111000001xxxxx000000xxxxxxxxxx
                                                                         ldaddb.  */
                                                                      return 1038;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         01111000001xxxxx000000xxxxxxxxxx
                                                                         ldaddh.  */
                                                                      return 1039;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     1x111000001xxxxx000000xxxxxxxxxx
                                                                     ldadd.  */
                                                                  return 1040;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         00111000101xxxxx000000xxxxxxxxxx
                                                                         ldaddab.  */
                                                                      return 1041;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         01111000101xxxxx000000xxxxxxxxxx
                                                                         ldaddah.  */
                                                                      return 1044;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     1x111000101xxxxx000000xxxxxxxxxx
                                                                     ldadda.  */
                                                                  return 1047;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         00111000011xxxxx000000xxxxxxxxxx
                                                                         ldaddlb.  */
                                                                      return 1042;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         01111000011xxxxx000000xxxxxxxxxx
                                                                         ldaddlh.  */
                                                                      return 1045;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     1x111000011xxxxx000000xxxxxxxxxx
                                                                     ldaddl.  */
                                                                  return 1048;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         00111000111xxxxx000000xxxxxxxxxx
                                                                         ldaddalb.  */
                                                                      return 1043;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         01111000111xxxxx000000xxxxxxxxxx
                                                                         ldaddalh.  */
                                                                      return 1046;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     1x111000111xxxxx000000xxxxxxxxxx
                                                                     ldaddal.  */
                                                                  return 1049;
                                                                }
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 22) & 0x1) == 0)
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         00111000001xxxxx100000xxxxxxxxxx
                                                                         swpb.  */
                                                                      return 1026;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         01111000001xxxxx100000xxxxxxxxxx
                                                                         swph.  */
                                                                      return 1027;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     1x111000001xxxxx100000xxxxxxxxxx
                                                                     swp.  */
                                                                  return 1028;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         00111000101xxxxx100000xxxxxxxxxx
                                                                         swpab.  */
                                                                      return 1029;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         01111000101xxxxx100000xxxxxxxxxx
                                                                         swpah.  */
                                                                      return 1032;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     1x111000101xxxxx100000xxxxxxxxxx
                                                                     swpa.  */
                                                                  return 1035;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         00111000011xxxxx100000xxxxxxxxxx
                                                                         swplb.  */
                                                                      return 1030;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         01111000011xxxxx100000xxxxxxxxxx
                                                                         swplh.  */
                                                                      return 1033;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     1x111000011xxxxx100000xxxxxxxxxx
                                                                     swpl.  */
                                                                  return 1036;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         00111000111xxxxx100000xxxxxxxxxx
                                                                         swpalb.  */
                                                                      return 1031;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         01111000111xxxxx100000xxxxxxxxxx
                                                                         swpalh.  */
                                                                      return 1034;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     1x111000111xxxxx100000xxxxxxxxxx
                                                                     swpal.  */
                                                                  return 1037;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 15) & 0x1) == 0)
                                                    {
                                                      if (((word >> 22) & 0x1) == 0)
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         00111000001xxxxx010000xxxxxxxxxx
                                                                         ldsmaxb.  */
                                                                      return 1086;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         01111000001xxxxx010000xxxxxxxxxx
                                                                         ldsmaxh.  */
                                                                      return 1087;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     1x111000001xxxxx010000xxxxxxxxxx
                                                                     ldsmax.  */
                                                                  return 1088;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         00111000101xxxxx010000xxxxxxxxxx
                                                                         ldsmaxab.  */
                                                                      return 1089;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         01111000101xxxxx010000xxxxxxxxxx
                                                                         ldsmaxah.  */
                                                                      return 1092;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     1x111000101xxxxx010000xxxxxxxxxx
                                                                     ldsmaxa.  */
                                                                  return 1095;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         00111000011xxxxx010000xxxxxxxxxx
                                                                         ldsmaxlb.  */
                                                                      return 1090;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         01111000011xxxxx010000xxxxxxxxxx
                                                                         ldsmaxlh.  */
                                                                      return 1093;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     1x111000011xxxxx010000xxxxxxxxxx
                                                                     ldsmaxl.  */
                                                                  return 1096;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         00111000111xxxxx010000xxxxxxxxxx
                                                                         ldsmaxalb.  */
                                                                      return 1091;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         01111000111xxxxx010000xxxxxxxxxx
                                                                         ldsmaxalh.  */
                                                                      return 1094;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     1x111000111xxxxx010000xxxxxxxxxx
                                                                     ldsmaxal.  */
                                                                  return 1097;
                                                                }
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 31) & 0x1) == 0)
                                                        {
                                                          if (((word >> 30) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 00111000xx1xxxxx110000xxxxxxxxxx
                                                                 ldaprb.  */
                                                              return 959;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 01111000xx1xxxxx110000xxxxxxxxxx
                                                                 ldaprh.  */
                                                              return 960;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             1x111000xx1xxxxx110000xxxxxxxxxx
                                                             ldapr.  */
                                                          return 961;
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000001xxxxxx01000xxxxxxxxxx
                                                                     ldeorb.  */
                                                                  return 1062;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000001xxxxxx01000xxxxxxxxxx
                                                                     ldeorh.  */
                                                                  return 1063;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000001xxxxxx01000xxxxxxxxxx
                                                                 ldeor.  */
                                                              return 1064;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000101xxxxxx01000xxxxxxxxxx
                                                                     ldeorab.  */
                                                                  return 1065;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000101xxxxxx01000xxxxxxxxxx
                                                                     ldeorah.  */
                                                                  return 1068;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000101xxxxxx01000xxxxxxxxxx
                                                                 ldeora.  */
                                                              return 1071;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000011xxxxxx01000xxxxxxxxxx
                                                                     ldeorlb.  */
                                                                  return 1066;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000011xxxxxx01000xxxxxxxxxx
                                                                     ldeorlh.  */
                                                                  return 1069;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000011xxxxxx01000xxxxxxxxxx
                                                                 ldeorl.  */
                                                              return 1072;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000111xxxxxx01000xxxxxxxxxx
                                                                     ldeoralb.  */
                                                                  return 1067;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000111xxxxxx01000xxxxxxxxxx
                                                                     ldeoralh.  */
                                                                  return 1070;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000111xxxxxx01000xxxxxxxxxx
                                                                 ldeoral.  */
                                                              return 1073;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000001xxxxxx11000xxxxxxxxxx
                                                                     ldumaxb.  */
                                                                  return 1110;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000001xxxxxx11000xxxxxxxxxx
                                                                     ldumaxh.  */
                                                                  return 1111;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000001xxxxxx11000xxxxxxxxxx
                                                                 ldumax.  */
                                                              return 1112;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000101xxxxxx11000xxxxxxxxxx
                                                                     ldumaxab.  */
                                                                  return 1113;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000101xxxxxx11000xxxxxxxxxx
                                                                     ldumaxah.  */
                                                                  return 1116;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000101xxxxxx11000xxxxxxxxxx
                                                                 ldumaxa.  */
                                                              return 1119;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000011xxxxxx11000xxxxxxxxxx
                                                                     ldumaxlb.  */
                                                                  return 1114;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000011xxxxxx11000xxxxxxxxxx
                                                                     ldumaxlh.  */
                                                                  return 1117;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000011xxxxxx11000xxxxxxxxxx
                                                                 ldumaxl.  */
                                                              return 1120;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000111xxxxxx11000xxxxxxxxxx
                                                                     ldumaxalb.  */
                                                                  return 1115;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000111xxxxxx11000xxxxxxxxxx
                                                                     ldumaxalh.  */
                                                                  return 1118;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000111xxxxxx11000xxxxxxxxxx
                                                                 ldumaxal.  */
                                                              return 1121;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000001xxxxxx00100xxxxxxxxxx
                                                                     ldclrb.  */
                                                                  return 1050;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000001xxxxxx00100xxxxxxxxxx
                                                                     ldclrh.  */
                                                                  return 1051;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000001xxxxxx00100xxxxxxxxxx
                                                                 ldclr.  */
                                                              return 1052;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000101xxxxxx00100xxxxxxxxxx
                                                                     ldclrab.  */
                                                                  return 1053;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000101xxxxxx00100xxxxxxxxxx
                                                                     ldclrah.  */
                                                                  return 1056;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000101xxxxxx00100xxxxxxxxxx
                                                                 ldclra.  */
                                                              return 1059;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000011xxxxxx00100xxxxxxxxxx
                                                                     ldclrlb.  */
                                                                  return 1054;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000011xxxxxx00100xxxxxxxxxx
                                                                     ldclrlh.  */
                                                                  return 1057;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000011xxxxxx00100xxxxxxxxxx
                                                                 ldclrl.  */
                                                              return 1060;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000111xxxxxx00100xxxxxxxxxx
                                                                     ldclralb.  */
                                                                  return 1055;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000111xxxxxx00100xxxxxxxxxx
                                                                     ldclralh.  */
                                                                  return 1058;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000111xxxxxx00100xxxxxxxxxx
                                                                 ldclral.  */
                                                              return 1061;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000001xxxxxx10100xxxxxxxxxx
                                                                     ldsminb.  */
                                                                  return 1098;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000001xxxxxx10100xxxxxxxxxx
                                                                     ldsminh.  */
                                                                  return 1099;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000001xxxxxx10100xxxxxxxxxx
                                                                 ldsmin.  */
                                                              return 1100;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000101xxxxxx10100xxxxxxxxxx
                                                                     ldsminab.  */
                                                                  return 1101;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000101xxxxxx10100xxxxxxxxxx
                                                                     ldsminah.  */
                                                                  return 1104;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000101xxxxxx10100xxxxxxxxxx
                                                                 ldsmina.  */
                                                              return 1107;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000011xxxxxx10100xxxxxxxxxx
                                                                     ldsminlb.  */
                                                                  return 1102;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000011xxxxxx10100xxxxxxxxxx
                                                                     ldsminlh.  */
                                                                  return 1105;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000011xxxxxx10100xxxxxxxxxx
                                                                 ldsminl.  */
                                                              return 1108;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000111xxxxxx10100xxxxxxxxxx
                                                                     ldsminalb.  */
                                                                  return 1103;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000111xxxxxx10100xxxxxxxxxx
                                                                     ldsminalh.  */
                                                                  return 1106;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000111xxxxxx10100xxxxxxxxxx
                                                                 ldsminal.  */
                                                              return 1109;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000001xxxxxx01100xxxxxxxxxx
                                                                     ldsetb.  */
                                                                  return 1074;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000001xxxxxx01100xxxxxxxxxx
                                                                     ldseth.  */
                                                                  return 1075;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000001xxxxxx01100xxxxxxxxxx
                                                                 ldset.  */
                                                              return 1076;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000101xxxxxx01100xxxxxxxxxx
                                                                     ldsetab.  */
                                                                  return 1077;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000101xxxxxx01100xxxxxxxxxx
                                                                     ldsetah.  */
                                                                  return 1080;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000101xxxxxx01100xxxxxxxxxx
                                                                 ldseta.  */
                                                              return 1083;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000011xxxxxx01100xxxxxxxxxx
                                                                     ldsetlb.  */
                                                                  return 1078;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000011xxxxxx01100xxxxxxxxxx
                                                                     ldsetlh.  */
                                                                  return 1081;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000011xxxxxx01100xxxxxxxxxx
                                                                 ldsetl.  */
                                                              return 1084;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000111xxxxxx01100xxxxxxxxxx
                                                                     ldsetalb.  */
                                                                  return 1079;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000111xxxxxx01100xxxxxxxxxx
                                                                     ldsetalh.  */
                                                                  return 1082;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000111xxxxxx01100xxxxxxxxxx
                                                                 ldsetal.  */
                                                              return 1085;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000001xxxxxx11100xxxxxxxxxx
                                                                     lduminb.  */
                                                                  return 1122;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000001xxxxxx11100xxxxxxxxxx
                                                                     lduminh.  */
                                                                  return 1123;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000001xxxxxx11100xxxxxxxxxx
                                                                 ldumin.  */
                                                              return 1124;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000101xxxxxx11100xxxxxxxxxx
                                                                     lduminab.  */
                                                                  return 1125;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000101xxxxxx11100xxxxxxxxxx
                                                                     lduminah.  */
                                                                  return 1128;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000101xxxxxx11100xxxxxxxxxx
                                                                 ldumina.  */
                                                              return 1131;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000011xxxxxx11100xxxxxxxxxx
                                                                     lduminlb.  */
                                                                  return 1126;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000011xxxxxx11100xxxxxxxxxx
                                                                     lduminlh.  */
                                                                  return 1129;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000011xxxxxx11100xxxxxxxxxx
                                                                 lduminl.  */
                                                              return 1132;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     00111000111xxxxxx11100xxxxxxxxxx
                                                                     lduminalb.  */
                                                                  return 1127;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01111000111xxxxxx11100xxxxxxxxxx
                                                                     lduminalh.  */
                                                                  return 1130;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 1x111000111xxxxxx11100xxxxxxxxxx
                                                                 lduminal.  */
                                                              return 1133;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 23) & 0x1) == 0)
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         00111000000xxxxxxxxx10xxxxxxxxxx
                                                         sttrb.  */
                                                      return 913;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         01111000000xxxxxxxxx10xxxxxxxxxx
                                                         sttrh.  */
                                                      return 916;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     1x111000000xxxxxxxxx10xxxxxxxxxx
                                                     sttr.  */
                                                  return 919;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         00111000010xxxxxxxxx10xxxxxxxxxx
                                                         ldtrb.  */
                                                      return 914;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         01111000010xxxxxxxxx10xxxxxxxxxx
                                                         ldtrh.  */
                                                      return 917;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     1x111000010xxxxxxxxx10xxxxxxxxxx
                                                     ldtr.  */
                                                  return 920;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001110001x0xxxxxxxxx10xxxxxxxxxx
                                                     ldtrsb.  */
                                                  return 915;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     101110001x0xxxxxxxxx10xxxxxxxxxx
                                                     ldtrsw.  */
                                                  return 921;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x11110001x0xxxxxxxxx10xxxxxxxxxx
                                                 ldtrsh.  */
                                              return 918;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 23) & 0x1) == 0)
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         00111000001xxxxxxxxx10xxxxxxxxxx
                                                         strb.  */
                                                      return 901;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         01111000001xxxxxxxxx10xxxxxxxxxx
                                                         strh.  */
                                                      return 906;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     1x111000001xxxxxxxxx10xxxxxxxxxx
                                                     str.  */
                                                  return 909;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         00111000011xxxxxxxxx10xxxxxxxxxx
                                                         ldrb.  */
                                                      return 902;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         01111000011xxxxxxxxx10xxxxxxxxxx
                                                         ldrh.  */
                                                      return 907;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     1x111000011xxxxxxxxx10xxxxxxxxxx
                                                     ldr.  */
                                                  return 910;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001110001x1xxxxxxxxx10xxxxxxxxxx
                                                     ldrsb.  */
                                                  return 903;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     101110001x1xxxxxxxxx10xxxxxxxxxx
                                                     ldrsw.  */
                                                  return 911;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     011110001x1xxxxxxxxx10xxxxxxxxxx
                                                     ldrsh.  */
                                                  return 908;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     111110001x1xxxxxxxxx10xxxxxxxxxx
                                                     prfm.  */
                                                  return 912;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 21) & 0x1) == 0)
                                {
                                  if (((word >> 23) & 0x1) == 0)
                                    {
                                      if (((word >> 22) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     00111000000xxxxxxxxxx1xxxxxxxxxx
                                                     strb.  */
                                                  return 870;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     01111000000xxxxxxxxxx1xxxxxxxxxx
                                                     strh.  */
                                                  return 875;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 1x111000000xxxxxxxxxx1xxxxxxxxxx
                                                 str.  */
                                              return 878;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     00111000010xxxxxxxxxx1xxxxxxxxxx
                                                     ldrb.  */
                                                  return 871;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     01111000010xxxxxxxxxx1xxxxxxxxxx
                                                     ldrh.  */
                                                  return 876;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 1x111000010xxxxxxxxxx1xxxxxxxxxx
                                                 ldr.  */
                                              return 879;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 001110001x0xxxxxxxxxx1xxxxxxxxxx
                                                 ldrsb.  */
                                              return 872;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 101110001x0xxxxxxxxxx1xxxxxxxxxx
                                                 ldrsw.  */
                                              return 880;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             x11110001x0xxxxxxxxxx1xxxxxxxxxx
                                             ldrsh.  */
                                          return 877;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 23) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xx1110000x1xxxxxxxxxx1xxxxxxxxxx
                                         ldraa.  */
                                      return 935;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xx1110001x1xxxxxxxxxx1xxxxxxxxxx
                                         ldrab.  */
                                      return 936;
                                    }
                                }
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 23) & 0x1) == 0)
                        {
                          if (((word >> 22) & 0x1) == 0)
                            {
                              if (((word >> 29) & 0x1) == 0)
                                {
                                  if (((word >> 10) & 0x1) == 0)
                                    {
                                      if (((word >> 11) & 0x1) == 0)
                                        {
                                          if (((word >> 21) & 0x1) == 0)
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  if (((word >> 31) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         00011001000xxxxxxxxx00xxxxxxxxxx
                                                         stlurb.  */
                                                      return 2380;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         10011001000xxxxxxxxx00xxxxxxxxxx
                                                         stlur.  */
                                                      return 2388;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 31) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         01011001000xxxxxxxxx00xxxxxxxxxx
                                                         stlurh.  */
                                                      return 2384;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         11011001000xxxxxxxxx00xxxxxxxxxx
                                                         stlur.  */
                                                      return 2391;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xx011001001xxxxxxxxx00xxxxxxxxxx
                                                 stzgm.  */
                                              return 964;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xx01100100xxxxxxxxxx10xxxxxxxxxx
                                             stg.  */
                                          return 881;
                                        }
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xx01100100xxxxxxxxxxx1xxxxxxxxxx
                                         stg.  */
                                      return 885;
                                    }
                                }
                              else
                                {
                                  if (((word >> 31) & 0x1) == 0)
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             0011100100xxxxxxxxxxxxxxxxxxxxxx
                                             strb.  */
                                          return 889;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             0111100100xxxxxxxxxxxxxxxxxxxxxx
                                             strh.  */
                                          return 894;
                                        }
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         1x11100100xxxxxxxxxxxxxxxxxxxxxx
                                         str.  */
                                      return 897;
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 29) & 0x1) == 0)
                                {
                                  if (((word >> 10) & 0x1) == 0)
                                    {
                                      if (((word >> 11) & 0x1) == 0)
                                        {
                                          if (((word >> 21) & 0x1) == 0)
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  if (((word >> 31) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         00011001010xxxxxxxxx00xxxxxxxxxx
                                                         ldapurb.  */
                                                      return 2381;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         10011001010xxxxxxxxx00xxxxxxxxxx
                                                         ldapur.  */
                                                      return 2389;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 31) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         01011001010xxxxxxxxx00xxxxxxxxxx
                                                         ldapurh.  */
                                                      return 2385;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         11011001010xxxxxxxxx00xxxxxxxxxx
                                                         ldapur.  */
                                                      return 2392;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xx011001011xxxxxxxxx00xxxxxxxxxx
                                                 ldg.  */
                                              return 934;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xx01100101xxxxxxxxxx10xxxxxxxxxx
                                             stzg.  */
                                          return 882;
                                        }
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xx01100101xxxxxxxxxxx1xxxxxxxxxx
                                         stzg.  */
                                      return 886;
                                    }
                                }
                              else
                                {
                                  if (((word >> 31) & 0x1) == 0)
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             0011100101xxxxxxxxxxxxxxxxxxxxxx
                                             ldrb.  */
                                          return 890;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             0111100101xxxxxxxxxxxxxxxxxxxxxx
                                             ldrh.  */
                                          return 895;
                                        }
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         1x11100101xxxxxxxxxxxxxxxxxxxxxx
                                         ldr.  */
                                      return 898;
                                    }
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 10) & 0x1) == 0)
                                {
                                  if (((word >> 11) & 0x1) == 0)
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  if (((word >> 31) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         00011001100xxxxxxxxx00xxxxxxxxxx
                                                         ldapursb.  */
                                                      return 2383;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         10011001100xxxxxxxxx00xxxxxxxxxx
                                                         ldapursw.  */
                                                      return 2390;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x1011001100xxxxxxxxx00xxxxxxxxxx
                                                     ldapursh.  */
                                                  return 2387;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x0011001110xxxxxxxxx00xxxxxxxxxx
                                                     ldapursb.  */
                                                  return 2382;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x1011001110xxxxxxxxx00xxxxxxxxxx
                                                     ldapursh.  */
                                                  return 2386;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xx011001101xxxxxxxxx00xxxxxxxxxx
                                                 stgm.  */
                                              return 963;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xx011001111xxxxxxxxx00xxxxxxxxxx
                                                 ldgm.  */
                                              return 962;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 22) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xx01100110xxxxxxxxxx10xxxxxxxxxx
                                             st2g.  */
                                          return 883;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xx01100111xxxxxxxxxx10xxxxxxxxxx
                                             stz2g.  */
                                          return 884;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 22) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xx01100110xxxxxxxxxxx1xxxxxxxxxx
                                         st2g.  */
                                      return 887;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xx01100111xxxxxxxxxxx1xxxxxxxxxx
                                         stz2g.  */
                                      return 888;
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  if (((word >> 31) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         001110011xxxxxxxxxxxxxxxxxxxxxxx
                                         ldrsb.  */
                                      return 891;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         101110011xxxxxxxxxxxxxxxxxxxxxxx
                                         ldrsw.  */
                                      return 899;
                                    }
                                }
                              else
                                {
                                  if (((word >> 31) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         011110011xxxxxxxxxxxxxxxxxxxxxxx
                                         ldrsh.  */
                                      return 896;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         111110011xxxxxxxxxxxxxxxxxxxxxxx
                                         prfm.  */
                                      return 900;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
      else
        {
          if (((word >> 24) & 0x1) == 0)
            {
              if (((word >> 27) & 0x1) == 0)
                {
                  if (((word >> 23) & 0x1) == 0)
                    {
                      if (((word >> 29) & 0x1) == 0)
                        {
                          if (((word >> 30) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 x00x00100xxxxxxxxxxxxxxxxxxxxxxx
                                 and.  */
                              return 991;
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 x10x00100xxxxxxxxxxxxxxxxxxxxxxx
                                 eor.  */
                              return 995;
                            }
                        }
                      else
                        {
                          if (((word >> 30) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 x01x00100xxxxxxxxxxxxxxxxxxxxxxx
                                 orr.  */
                              return 993;
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 x11x00100xxxxxxxxxxxxxxxxxxxxxxx
                                 ands.  */
                              return 996;
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 29) & 0x1) == 0)
                        {
                          if (((word >> 30) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 x00x00101xxxxxxxxxxxxxxxxxxxxxxx
                                 movn.  */
                              return 1182;
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 x10x00101xxxxxxxxxxxxxxxxxxxxxxx
                                 movz.  */
                              return 1184;
                            }
                        }
                      else
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xx1x00101xxxxxxxxxxxxxxxxxxxxxxx
                             movk.  */
                          return 1186;
                        }
                    }
                }
              else
                {
                  if (((word >> 21) & 0x1) == 0)
                    {
                      if (((word >> 28) & 0x1) == 0)
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     x0001010xx0xxxxxxxxxxxxxxxxxxxxx
                                     and.  */
                                  return 998;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     x1001010xx0xxxxxxxxxxxxxxxxxxxxx
                                     eor.  */
                                  return 1005;
                                }
                            }
                          else
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     x0101010xx0xxxxxxxxxxxxxxxxxxxxx
                                     orr.  */
                                  return 1000;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     x1101010xx0xxxxxxxxxxxxxxxxxxxxx
                                     ands.  */
                                  return 1007;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 10) & 0x1) == 0)
                            {
                              if (((word >> 11) & 0x1) == 0)
                                {
                                  if (((word >> 22) & 0x1) == 0)
                                    {
                                      if (((word >> 23) & 0x1) == 0)
                                        {
                                          if (((word >> 29) & 0x1) == 0)
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x0011010000xxxxxxxxx00xxxxxxxxxx
                                                     adc.  */
                                                  return 0;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x1011010000xxxxxxxxx00xxxxxxxxxx
                                                     sbc.  */
                                                  return 2;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x0111010000xxxxxxxxx00xxxxxxxxxx
                                                     adcs.  */
                                                  return 1;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x1111010000xxxxxxxxx00xxxxxxxxxx
                                                     sbcs.  */
                                                  return 4;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x0x11010100xxxxxxxxx00xxxxxxxxxx
                                                 csel.  */
                                              return 662;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x1x11010100xxxxxxxxx00xxxxxxxxxx
                                                 csinv.  */
                                              return 666;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 23) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x0x11010010xxxxxxxxx00xxxxxxxxxx
                                                 ccmn.  */
                                              return 660;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x1x11010010xxxxxxxxx00xxxxxxxxxx
                                                 ccmp.  */
                                              return 661;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 12) & 0x1) == 0)
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  if (((word >> 14) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          if (((word >> 30) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 x0011010110xxxxxx00000xxxxxxxxxx
                                                                 subp.  */
                                                              return 721;
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 16) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     x1011010110xxxx0x00000xxxxxxxxxx
                                                                     rbit.  */
                                                                  return 685;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     x1011010110xxxx1x00000xxxxxxxxxx
                                                                     pacia.  */
                                                                  return 693;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xx111010110xxxxxx00000xxxxxxxxxx
                                                             subps.  */
                                                          return 722;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x0x11010110xxxxxx10000xxxxxxxxxx
                                                             crc32b.  */
                                                          return 727;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x1x11010110xxxxxx10000xxxxxxxxxx
                                                             xpaci.  */
                                                          return 709;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x0x11010110xxxxxxx1000xxxxxxxxxx
                                                         lslv.  */
                                                      return 713;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x1x11010110xxxxxxx1000xxxxxxxxxx
                                                         paciza.  */
                                                      return 701;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  if (((word >> 14) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x0x11010110xxxxxx00100xxxxxxxxxx
                                                             irg.  */
                                                          return 724;
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 16) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 x1x11010110xxxx0x00100xxxxxxxxxx
                                                                 clz.  */
                                                              return 690;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 x1x11010110xxxx1x00100xxxxxxxxxx
                                                                 autia.  */
                                                              return 697;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxx11010110xxxxxx10100xxxxxxxxxx
                                                         crc32cb.  */
                                                      return 731;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x0x11010110xxxxxxx1100xxxxxxxxxx
                                                         pacga.  */
                                                      return 726;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x1x11010110xxxxxxx1100xxxxxxxxxx
                                                         autiza.  */
                                                      return 705;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 22) & 0x1) == 0)
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxx11010x00xxxxxx0xx10xxxxxxxxxx
                                             setf8.  */
                                          return 2378;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxx11010x00xxxxxx1xx10xxxxxxxxxx
                                             setf16.  */
                                          return 2379;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 23) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x0x11010010xxxxxxxxx10xxxxxxxxxx
                                                 ccmn.  */
                                              return 658;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x1x11010010xxxxxxxxx10xxxxxxxxxx
                                                 ccmp.  */
                                              return 659;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 12) & 0x1) == 0)
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  if (((word >> 14) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x0x11010110xxxxxx00010xxxxxxxxxx
                                                             udiv.  */
                                                          return 711;
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 16) & 0x1) == 0)
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     01x11010110xxxx0x00010xxxxxxxxxx
                                                                     rev.  */
                                                                  return 687;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     11x11010110xxxx0x00010xxxxxxxxxx
                                                                     rev32.  */
                                                                  return 692;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 x1x11010110xxxx1x00010xxxxxxxxxx
                                                                 pacda.  */
                                                              return 695;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxx11010110xxxxxx10010xxxxxxxxxx
                                                         crc32w.  */
                                                      return 729;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x0x11010110xxxxxxx1010xxxxxxxxxx
                                                         asrv.  */
                                                      return 717;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x1x11010110xxxxxxx1010xxxxxxxxxx
                                                         pacdza.  */
                                                      return 703;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  if (((word >> 14) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxx11010110xxxxxx00110xxxxxxxxxx
                                                         autda.  */
                                                      return 699;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxx11010110xxxxxx10110xxxxxxxxxx
                                                         crc32cw.  */
                                                      return 733;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxx11010110xxxxxxx1110xxxxxxxxxx
                                                     autdza.  */
                                                  return 707;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 11) & 0x1) == 0)
                                {
                                  if (((word >> 22) & 0x1) == 0)
                                    {
                                      if (((word >> 23) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxx11010000xxxxxxxxx01xxxxxxxxxx
                                             rmif.  */
                                          return 2377;
                                        }
                                      else
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x0x11010100xxxxxxxxx01xxxxxxxxxx
                                                 csinc.  */
                                              return 663;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x1x11010100xxxxxxxxx01xxxxxxxxxx
                                                 csneg.  */
                                              return 669;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  if (((word >> 16) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxx11010x10xxxx0x00001xxxxxxxxxx
                                                         rev16.  */
                                                      return 686;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxx11010x10xxxx1x00001xxxxxxxxxx
                                                         pacib.  */
                                                      return 694;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x0x11010x10xxxxxx10001xxxxxxxxxx
                                                         crc32h.  */
                                                      return 728;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x1x11010x10xxxxxx10001xxxxxxxxxx
                                                         xpacd.  */
                                                      return 710;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x0x11010x10xxxxxxx1001xxxxxxxxxx
                                                     lsrv.  */
                                                  return 715;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x1x11010x10xxxxxxx1001xxxxxxxxxx
                                                     pacizb.  */
                                                  return 702;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x0x11010x10xxxxxx00101xxxxxxxxxx
                                                         gmi.  */
                                                      return 725;
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 16) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x1x11010x10xxxx0x00101xxxxxxxxxx
                                                             cls.  */
                                                          return 691;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x1x11010x10xxxx1x00101xxxxxxxxxx
                                                             autib.  */
                                                          return 698;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxx11010x10xxxxxx10101xxxxxxxxxx
                                                     crc32ch.  */
                                                  return 732;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxx11010x10xxxxxxx1101xxxxxxxxxx
                                                 autizb.  */
                                              return 706;
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 12) & 0x1) == 0)
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x0x11010xx0xxxxxx00011xxxxxxxxxx
                                                     sdiv.  */
                                                  return 712;
                                                }
                                              else
                                                {
                                                  if (((word >> 16) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x1x11010xx0xxxx0x00011xxxxxxxxxx
                                                         rev.  */
                                                      return 688;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x1x11010xx0xxxx1x00011xxxxxxxxxx
                                                         pacdb.  */
                                                      return 696;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxx11010xx0xxxxxx10011xxxxxxxxxx
                                                 crc32x.  */
                                              return 730;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x0x11010xx0xxxxxxx1011xxxxxxxxxx
                                                 rorv.  */
                                              return 719;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x1x11010xx0xxxxxxx1011xxxxxxxxxx
                                                 pacdzb.  */
                                              return 704;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxx11010xx0xxxxxx00111xxxxxxxxxx
                                                 autdb.  */
                                              return 700;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxx11010xx0xxxxxx10111xxxxxxxxxx
                                                 crc32cx.  */
                                              return 734;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxx11010xx0xxxxxxx1111xxxxxxxxxx
                                             autdzb.  */
                                          return 708;
                                        }
                                    }
                                }
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 29) & 0x1) == 0)
                        {
                          if (((word >> 30) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 x00x1010xx1xxxxxxxxxxxxxxxxxxxxx
                                 bic.  */
                              return 999;
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 x10x1010xx1xxxxxxxxxxxxxxxxxxxxx
                                 eon.  */
                              return 1006;
                            }
                        }
                      else
                        {
                          if (((word >> 30) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 x01x1010xx1xxxxxxxxxxxxxxxxxxxxx
                                 orn.  */
                              return 1003;
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 x11x1010xx1xxxxxxxxxxxxxxxxxxxxx
                                 bics.  */
                              return 1009;
                            }
                        }
                    }
                }
            }
          else
            {
              if (((word >> 27) & 0x1) == 0)
                {
                  if (((word >> 23) & 0x1) == 0)
                    {
                      if (((word >> 29) & 0x1) == 0)
                        {
                          if (((word >> 30) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 x00x00110xxxxxxxxxxxxxxxxxxxxxxx
                                 sbfm.  */
                              return 618;
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 x10x00110xxxxxxxxxxxxxxxxxxxxxxx
                                 ubfm.  */
                              return 629;
                            }
                        }
                      else
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xx1x00110xxxxxxxxxxxxxxxxxxxxxxx
                             bfm.  */
                          return 625;
                        }
                    }
                  else
                    {
                      /* 33222222222211111111110000000000
                         10987654321098765432109876543210
                         xxxx00111xxxxxxxxxxxxxxxxxxxxxxx
                         extr.  */
                      return 758;
                    }
                }
              else
                {
                  if (((word >> 21) & 0x1) == 0)
                    {
                      if (((word >> 28) & 0x1) == 0)
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     x0001011xx0xxxxxxxxxxxxxxxxxxxxx
                                     add.  */
                                  return 21;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     x1001011xx0xxxxxxxxxxxxxxxxxxxxx
                                     sub.  */
                                  return 24;
                                }
                            }
                          else
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     x0101011xx0xxxxxxxxxxxxxxxxxxxxx
                                     adds.  */
                                  return 22;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     x1101011xx0xxxxxxxxxxxxxxxxxxxxx
                                     subs.  */
                                  return 26;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 15) & 0x1) == 0)
                            {
                              if (((word >> 22) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxx11011x00xxxxx0xxxxxxxxxxxxxxx
                                     madd.  */
                                  return 735;
                                }
                              else
                                {
                                  if (((word >> 23) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxx11011010xxxxx0xxxxxxxxxxxxxxx
                                         smulh.  */
                                      return 743;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxx11011110xxxxx0xxxxxxxxxxxxxxx
                                         umulh.  */
                                      return 748;
                                    }
                                }
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxx11011xx0xxxxx1xxxxxxxxxxxxxxx
                                 msub.  */
                              return 737;
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 23) & 0x1) == 0)
                        {
                          if (((word >> 28) & 0x1) == 0)
                            {
                              if (((word >> 29) & 0x1) == 0)
                                {
                                  if (((word >> 30) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         x00010110x1xxxxxxxxxxxxxxxxxxxxx
                                         add.  */
                                      return 6;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         x10010110x1xxxxxxxxxxxxxxxxxxxxx
                                         sub.  */
                                      return 9;
                                    }
                                }
                              else
                                {
                                  if (((word >> 30) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         x01010110x1xxxxxxxxxxxxxxxxxxxxx
                                         adds.  */
                                      return 7;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         x11010110x1xxxxxxxxxxxxxxxxxxxxx
                                         subs.  */
                                      return 10;
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 15) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxx110110x1xxxxx0xxxxxxxxxxxxxxx
                                     smaddl.  */
                                  return 739;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxx110110x1xxxxx1xxxxxxxxxxxxxxx
                                     smsubl.  */
                                  return 741;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 15) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxx10111x1xxxxx0xxxxxxxxxxxxxxx
                                 umaddl.  */
                              return 744;
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxx10111x1xxxxx1xxxxxxxxxxxxxxx
                                 umsubl.  */
                              return 746;
                            }
                        }
                    }
                }
            }
        }
    }
  else
    {
      if (((word >> 27) & 0x1) == 0)
        {
          if (((word >> 28) & 0x1) == 0)
            {
              if (((word >> 24) & 0x1) == 0)
                {
                  if (((word >> 29) & 0x1) == 0)
                    {
                      if (((word >> 13) & 0x1) == 0)
                        {
                          if (((word >> 14) & 0x1) == 0)
                            {
                              if (((word >> 15) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 16) & 0x1) == 0)
                                                {
                                                  if (((word >> 17) & 0x1) == 0)
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx000000000xxxxxxxxxxxxx
                                                                     add.  */
                                                                  return 1279;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx010000000xxxxxxxxxxxxx
                                                                     mul.  */
                                                                  return 1748;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx001000000xxxxxxxxxxxxx
                                                                     smax.  */
                                                                  return 1827;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx011000000xxxxxxxxxxxxx
                                                                     orr.  */
                                                                  return 1759;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x0100000xxxxxxxxxxxxx
                                                                 sdiv.  */
                                                              return 1818;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x1100000xxxxxxxxxxxxx
                                                                 sabd.  */
                                                              return 1809;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x0010000xxxxxxxxxxxxx
                                                                 smulh.  */
                                                              return 1832;
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx001010000xxxxxxxxxxxxx
                                                                     smin.  */
                                                                  return 1830;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx011010000xxxxxxxxxxxxx
                                                                     and.  */
                                                                  return 1287;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx0xx110000xxxxxxxxxxxxx
                                                             sdivr.  */
                                                          return 1819;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 17) & 0x1) == 0)
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x0001000xxxxxxxxxxxxx
                                                                 sub.  */
                                                              return 1948;
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx001001000xxxxxxxxxxxxx
                                                                     umax.  */
                                                                  return 1976;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx011001000xxxxxxxxxxxxx
                                                                     eor.  */
                                                                  return 1374;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x0101000xxxxxxxxxxxxx
                                                                 udiv.  */
                                                              return 1970;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x1101000xxxxxxxxxxxxx
                                                                 uabd.  */
                                                              return 1961;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx000011000xxxxxxxxxxxxx
                                                                     subr.  */
                                                                  return 1950;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx010011000xxxxxxxxxxxxx
                                                                     umulh.  */
                                                                  return 1981;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx001011000xxxxxxxxxxxxx
                                                                     umin.  */
                                                                  return 1979;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx011011000xxxxxxxxxxxxx
                                                                     bic.  */
                                                                  return 1299;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx0xx111000xxxxxxxxxxxxx
                                                             udivr.  */
                                                          return 1971;
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x00x0xxxxx000xxxxxxxxxxxxx
                                                     ld1sb.  */
                                                  return 1561;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x01x0xxxxx000xxxxxxxxxxxxx
                                                     ld1sh.  */
                                                  return 1572;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 12) & 0x1) == 0)
                                                {
                                                  if (((word >> 10) & 0x1) == 0)
                                                    {
                                                      if (((word >> 11) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x0xx0xxxxx000000xxxxxxxxxx
                                                             sdot.  */
                                                          return 1820;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x0xx0xxxxx000010xxxxxxxxxx
                                                             sqdmlalbt.  */
                                                          return 2170;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 11) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x0xx0xxxxx000001xxxxxxxxxx
                                                             udot.  */
                                                          return 1972;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x0xx0xxxxx000011xxxxxxxxxx
                                                             sqdmlslbt.  */
                                                          return 2177;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     010001x0xx0xxxxx0001xxxxxxxxxxxx
                                                     cdot.  */
                                                  return 2059;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     110001x00x0xxxxx000xxxxxxxxxxxxx
                                                     ld1sb.  */
                                                  return 1565;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     110001x01x0xxxxx000xxxxxxxxxxxxx
                                                     ld1sh.  */
                                                  return 1576;
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 10) & 0x1) == 0)
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx1xxxxx000000xxxxxxxxxx
                                                             add.  */
                                                          return 1277;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx1xxxxx000100xxxxxxxxxx
                                                             sqadd.  */
                                                          return 1834;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x0xx1xxxxx000x10xxxxxxxxxx
                                                         sqsub.  */
                                                      return 1864;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx1xxxxx000001xxxxxxxxxx
                                                             sub.  */
                                                          return 1946;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx1xxxxx000101xxxxxxxxxx
                                                             uqadd.  */
                                                          return 1982;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x0xx1xxxxx000x11xxxxxxxxxx
                                                         uqsub.  */
                                                      return 2012;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x00x1xxxxx000xxxxxxxxxxxxx
                                                     prfb.  */
                                                  return 1767;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x01x1xxxxx000xxxxxxxxxxxxx
                                                     ld1sh.  */
                                                  return 1573;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 10) & 0x1) == 0)
                                                    {
                                                      if (((word >> 11) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x00x1xxxxx000x00xxxxxxxxxx
                                                             sqrdmlah.  */
                                                          return 2195;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x00x1xxxxx000x10xxxxxxxxxx
                                                             mla.  */
                                                          return 2102;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 11) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x00x1xxxxx000x01xxxxxxxxxx
                                                             sqrdmlsh.  */
                                                          return 2199;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x00x1xxxxx000x11xxxxxxxxxx
                                                             mls.  */
                                                          return 2105;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     110001x00x1xxxxx000xxxxxxxxxxxxx
                                                     prfb.  */
                                                  return 1768;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 10) & 0x1) == 0)
                                                    {
                                                      if (((word >> 11) & 0x1) == 0)
                                                        {
                                                          if (((word >> 12) & 0x1) == 0)
                                                            {
                                                              if (((word >> 22) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     010001x0101xxxxx000000xxxxxxxxxx
                                                                     sdot.  */
                                                                  return 1821;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     010001x0111xxxxx000000xxxxxxxxxx
                                                                     sdot.  */
                                                                  return 1822;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 22) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     010001x0101xxxxx000100xxxxxxxxxx
                                                                     sqrdmlah.  */
                                                                  return 2196;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     010001x0111xxxxx000100xxxxxxxxxx
                                                                     sqrdmlah.  */
                                                                  return 2197;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 12) & 0x1) == 0)
                                                            {
                                                              if (((word >> 22) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     010001x0101xxxxx000010xxxxxxxxxx
                                                                     mla.  */
                                                                  return 2103;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     010001x0111xxxxx000010xxxxxxxxxx
                                                                     mla.  */
                                                                  return 2104;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x01x1xxxxx000110xxxxxxxxxx
                                                                 usdot.  */
                                                              return 2397;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 11) & 0x1) == 0)
                                                        {
                                                          if (((word >> 12) & 0x1) == 0)
                                                            {
                                                              if (((word >> 22) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     010001x0101xxxxx000001xxxxxxxxxx
                                                                     udot.  */
                                                                  return 1973;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     010001x0111xxxxx000001xxxxxxxxxx
                                                                     udot.  */
                                                                  return 1974;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 22) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     010001x0101xxxxx000101xxxxxxxxxx
                                                                     sqrdmlsh.  */
                                                                  return 2200;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     010001x0111xxxxx000101xxxxxxxxxx
                                                                     sqrdmlsh.  */
                                                                  return 2201;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 12) & 0x1) == 0)
                                                            {
                                                              if (((word >> 22) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     010001x0101xxxxx000011xxxxxxxxxx
                                                                     mls.  */
                                                                  return 2106;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     010001x0111xxxxx000011xxxxxxxxxx
                                                                     mls.  */
                                                                  return 2107;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x01x1xxxxx000111xxxxxxxxxx
                                                                 sudot.  */
                                                              return 2398;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     110001x01x1xxxxx000xxxxxxxxxxxxx
                                                     ld1sh.  */
                                                  return 1577;
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 31) & 0x1) == 0)
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          if (((word >> 16) & 0x1) == 0)
                                            {
                                              if (((word >> 17) & 0x1) == 0)
                                                {
                                                  if (((word >> 18) & 0x1) == 0)
                                                    {
                                                      if (((word >> 19) & 0x1) == 0)
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 0x0001x0xx000000100xxxxxxxxxxxxx
                                                                 asr.  */
                                                              return 1295;
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx010000100xxxxxxxxxxxxx
                                                                     asr.  */
                                                                  return 1293;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     010001x0xx010000100xxxxxxxxxxxxx
                                                                     shadd.  */
                                                                  return 2136;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 0x0001x0xx001000100xxxxxxxxxxxxx
                                                                 sqshl.  */
                                                              return 2214;
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx011000100xxxxxxxxxxxxx
                                                                     asr.  */
                                                                  return 1294;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     010001x0xx011000100xxxxxxxxxxxxx
                                                                     sqadd.  */
                                                                  return 2165;
                                                                }
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 19) & 0x1) == 0)
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 0x0001x0xx000100100xxxxxxxxxxxxx
                                                                 asrd.  */
                                                              return 1296;
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx010100100xxxxxxxxxxxxx
                                                                     asrr.  */
                                                                  return 1297;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     010001x0xx010100100xxxxxxxxxxxxx
                                                                     srhadd.  */
                                                                  return 2227;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx001100100xxxxxxxxxxxxx
                                                                     srshr.  */
                                                                  return 2231;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     010001x0xx001100100xxxxxxxxxxxxx
                                                                     sqshlr.  */
                                                                  return 2215;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 0x0001x0xx011100100xxxxxxxxxxxxx
                                                                 suqadd.  */
                                                              return 2251;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 18) & 0x1) == 0)
                                                    {
                                                      if (((word >> 19) & 0x1) == 0)
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 0x0001x0xx000010100xxxxxxxxxxxxx
                                                                 srshl.  */
                                                              return 2229;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 0x0001x0xx010010100xxxxxxxxxxxxx
                                                                 shsub.  */
                                                              return 2139;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 0x0001x0xx001010100xxxxxxxxxxxxx
                                                                 sqrshl.  */
                                                              return 2207;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 0x0001x0xx011010100xxxxxxxxxxxxx
                                                                 sqsub.  */
                                                              return 2221;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 19) & 0x1) == 0)
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx000110100xxxxxxxxxxxxx
                                                                     sqshl.  */
                                                                  return 2213;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     010001x0xx000110100xxxxxxxxxxxxx
                                                                     srshlr.  */
                                                                  return 2230;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 0x0001x0xx010110100xxxxxxxxxxxxx
                                                                 shsubr.  */
                                                              return 2140;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 0x0001x0xx001110100xxxxxxxxxxxxx
                                                                 sqrshlr.  */
                                                              return 2208;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 0x0001x0xx011110100xxxxxxxxxxxxx
                                                                 sqsubr.  */
                                                              return 2222;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 17) & 0x1) == 0)
                                                {
                                                  if (((word >> 18) & 0x1) == 0)
                                                    {
                                                      if (((word >> 19) & 0x1) == 0)
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 0x0001x0xx000001100xxxxxxxxxxxxx
                                                                 lsr.  */
                                                              return 1739;
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx010001100xxxxxxxxxxxxx
                                                                     lsr.  */
                                                                  return 1737;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     010001x0xx010001100xxxxxxxxxxxxx
                                                                     uhadd.  */
                                                                  return 2264;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 0x0001x0xx001001100xxxxxxxxxxxxx
                                                                 uqshl.  */
                                                              return 2294;
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx011001100xxxxxxxxxxxxx
                                                                     lsr.  */
                                                                  return 1738;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     010001x0xx011001100xxxxxxxxxxxxx
                                                                     uqadd.  */
                                                                  return 2288;
                                                                }
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 19) & 0x1) == 0)
                                                        {
                                                          if (((word >> 30) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x0101100xxxxxxxxxxxxx
                                                                 lsrr.  */
                                                              return 1740;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0xx0x0101100xxxxxxxxxxxxx
                                                                 urhadd.  */
                                                              return 2303;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx001101100xxxxxxxxxxxxx
                                                                     urshr.  */
                                                                  return 2306;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     010001x0xx001101100xxxxxxxxxxxxx
                                                                     uqshlr.  */
                                                                  return 2295;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 0x0001x0xx011101100xxxxxxxxxxxxx
                                                                 usqadd.  */
                                                              return 2311;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 18) & 0x1) == 0)
                                                    {
                                                      if (((word >> 19) & 0x1) == 0)
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx000011100xxxxxxxxxxxxx
                                                                     lsl.  */
                                                                  return 1733;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     010001x0xx000011100xxxxxxxxxxxxx
                                                                     urshl.  */
                                                                  return 2304;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx010011100xxxxxxxxxxxxx
                                                                     lsl.  */
                                                                  return 1731;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     010001x0xx010011100xxxxxxxxxxxxx
                                                                     uhsub.  */
                                                                  return 2265;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 0x0001x0xx001011100xxxxxxxxxxxxx
                                                                 uqrshl.  */
                                                              return 2289;
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx011011100xxxxxxxxxxxxx
                                                                     lsl.  */
                                                                  return 1732;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     010001x0xx011011100xxxxxxxxxxxxx
                                                                     uqsub.  */
                                                                  return 2298;
                                                                }
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 19) & 0x1) == 0)
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx000111100xxxxxxxxxxxxx
                                                                     uqshl.  */
                                                                  return 2293;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     010001x0xx000111100xxxxxxxxxxxxx
                                                                     urshlr.  */
                                                                  return 2305;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx010111100xxxxxxxxxxxxx
                                                                     lslr.  */
                                                                  return 1734;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     010001x0xx010111100xxxxxxxxxxxxx
                                                                     uhsubr.  */
                                                                  return 2266;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0xx001111100xxxxxxxxxxxxx
                                                                     sqshlu.  */
                                                                  return 2216;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     010001x0xx001111100xxxxxxxxxxxxx
                                                                     uqrshlr.  */
                                                                  return 2290;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 0x0001x0xx011111100xxxxxxxxxxxxx
                                                                 uqsubr.  */
                                                              return 2299;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 10) & 0x1) == 0)
                                            {
                                              if (((word >> 12) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x0xx1xxxxx1000x0xxxxxxxxxx
                                                         asr.  */
                                                      return 1291;
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 22) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x0x01xxxxx1000x0xxxxxxxxxx
                                                             smlalb.  */
                                                          return 2144;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x0x11xxxxx1000x0xxxxxxxxxx
                                                             smlalb.  */
                                                          return 2145;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x0xx1xxxxx1001x0xxxxxxxxxx
                                                         asr.  */
                                                      return 1292;
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 22) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x0x01xxxxx1001x0xxxxxxxxxx
                                                             umlalb.  */
                                                          return 2269;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x0x11xxxxx1001x0xxxxxxxxxx
                                                             umlalb.  */
                                                          return 2270;
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 12) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      if (((word >> 11) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx1xxxxx100001xxxxxxxxxx
                                                             lsr.  */
                                                          return 1735;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx1xxxxx100011xxxxxxxxxx
                                                             lsl.  */
                                                          return 1729;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 22) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x0x01xxxxx1000x1xxxxxxxxxx
                                                             smlalt.  */
                                                          return 2147;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x0x11xxxxx1000x1xxxxxxxxxx
                                                             smlalt.  */
                                                          return 2148;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      if (((word >> 11) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx1xxxxx100101xxxxxxxxxx
                                                             lsr.  */
                                                          return 1736;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx1xxxxx100111xxxxxxxxxx
                                                             lsl.  */
                                                          return 1730;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 22) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x0x01xxxxx1001x1xxxxxxxxxx
                                                             umlalt.  */
                                                          return 2272;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x0x11xxxxx1001x1xxxxxxxxxx
                                                             umlalt.  */
                                                          return 2273;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 22) & 0x1) == 0)
                                        {
                                          if (((word >> 21) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     1x0001x0000xxxxx100xxxxxxxxxxxxx
                                                     ldnt1sb.  */
                                                  return 2096;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     1x0001x0100xxxxx100xxxxxxxxxxxxx
                                                     ldnt1sh.  */
                                                  return 2097;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         100001x0001xxxxx100xxxxxxxxxxxxx
                                                         ld1sb.  */
                                                      return 1567;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         110001x0001xxxxx100xxxxxxxxxxxxx
                                                         ld1sb.  */
                                                      return 1571;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         100001x0101xxxxx100xxxxxxxxxxxxx
                                                         ld1sh.  */
                                                      return 1580;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         110001x0101xxxxx100xxxxxxxxxxxxx
                                                         ld1sh.  */
                                                      return 1583;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x001xxxxxx100xxxxxxxxxxxxx
                                                     ld1rb.  */
                                                  return 1537;
                                                }
                                              else
                                                {
                                                  if (((word >> 21) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         110001x0010xxxxx100xxxxxxxxxxxxx
                                                         ld1sb.  */
                                                      return 1566;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         110001x0011xxxxx100xxxxxxxxxxxxx
                                                         prfb.  */
                                                      return 1769;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x011xxxxxx100xxxxxxxxxxxxx
                                                     ld1rsw.  */
                                                  return 1558;
                                                }
                                              else
                                                {
                                                  if (((word >> 21) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         110001x0110xxxxx100xxxxxxxxxxxxx
                                                         ld1sh.  */
                                                      return 1578;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         110001x0111xxxxx100xxxxxxxxxxxxx
                                                         ld1sh.  */
                                                      return 1579;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 15) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 000001x0xx0xxxxx010xxxxxxxxxxxxx
                                                 mla.  */
                                              return 1742;
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x00x0xxxxx010xxxxxxxxxxxxx
                                                     ld1b.  */
                                                  return 1503;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x01x0xxxxx010xxxxxxxxxxxxx
                                                     ld1h.  */
                                                  return 1523;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 10) & 0x1) == 0)
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x0xx0xxxxx010000xxxxxxxxxx
                                                             smlalb.  */
                                                          return 2146;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x0xx0xxxxx010100xxxxxxxxxx
                                                             smlslb.  */
                                                          return 2152;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x0xx0xxxxx010010xxxxxxxxxx
                                                             umlalb.  */
                                                          return 2271;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x0xx0xxxxx010110xxxxxxxxxx
                                                             umlslb.  */
                                                          return 2277;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x0xx0xxxxx010001xxxxxxxxxx
                                                             smlalt.  */
                                                          return 2149;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x0xx0xxxxx010101xxxxxxxxxx
                                                             smlslt.  */
                                                          return 2155;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x0xx0xxxxx010011xxxxxxxxxx
                                                             umlalt.  */
                                                          return 2274;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x0xx0xxxxx010111xxxxxxxxxx
                                                             umlslt.  */
                                                          return 2280;
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     110001x00x0xxxxx010xxxxxxxxxxxxx
                                                     ld1b.  */
                                                  return 1508;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     110001x01x0xxxxx010xxxxxxxxxxxxx
                                                     ld1h.  */
                                                  return 1528;
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 11) & 0x1) == 0)
                                                {
                                                  if (((word >> 12) & 0x1) == 0)
                                                    {
                                                      if (((word >> 10) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx1xxxxx010000xxxxxxxxxx
                                                             index.  */
                                                          return 1494;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx1xxxxx010001xxxxxxxxxx
                                                             index.  */
                                                          return 1495;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 22) & 0x1) == 0)
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0001xxxxx01010xxxxxxxxxxx
                                                                 addvl.  */
                                                              return 1281;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0101xxxxx01010xxxxxxxxxxx
                                                                 rdvl.  */
                                                              return 1803;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0x11xxxxx01010xxxxxxxxxxx
                                                             addpl.  */
                                                          return 1280;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 10) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x0xx1xxxxx010x10xxxxxxxxxx
                                                         index.  */
                                                      return 1496;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x0xx1xxxxx010x11xxxxxxxxxx
                                                         index.  */
                                                      return 1493;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x00x1xxxxx010xxxxxxxxxxxxx
                                                     prfw.  */
                                                  return 1787;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x01x1xxxxx010xxxxxxxxxxxxx
                                                     ld1h.  */
                                                  return 1524;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x00x1xxxxx010xxxxxxxxxxxxx
                                                 prfw.  */
                                              return 1789;
                                            }
                                          else
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         010001x0101xxxxx010xxxxxxxxxxxxx
                                                         cdot.  */
                                                      return 2061;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         010001x0111xxxxx010xxxxxxxxxxxxx
                                                         cdot.  */
                                                      return 2060;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     110001x01x1xxxxx010xxxxxxxxxxxxx
                                                     ld1h.  */
                                                  return 1529;
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 30) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 21) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 000001x0xx0xxxxx110xxxxxxxxxxxxx
                                                 mad.  */
                                              return 1741;
                                            }
                                          else
                                            {
                                              if (((word >> 10) & 0x1) == 0)
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 20) & 0x1) == 0)
                                                        {
                                                          if (((word >> 22) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0x010xxxx110x00xxxxxxxxxx
                                                                 sqincw.  */
                                                              return 1861;
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 23) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x00110xxxx110x00xxxxxxxxxx
                                                                     sqinch.  */
                                                                  return 1855;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x01110xxxx110x00xxxxxxxxxx
                                                                     sqincd.  */
                                                                  return 1852;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 22) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0x011xxxx110x00xxxxxxxxxx
                                                                 incw.  */
                                                              return 1491;
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 23) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x00111xxxx110x00xxxxxxxxxx
                                                                     inch.  */
                                                                  return 1487;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x01111xxxx110x00xxxxxxxxxx
                                                                     incd.  */
                                                                  return 1485;
                                                                }
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 22) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0x01xxxxx110x10xxxxxxxxxx
                                                             sqdecw.  */
                                                          return 1847;
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0011xxxxx110x10xxxxxxxxxx
                                                                 sqdech.  */
                                                              return 1841;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0111xxxxx110x10xxxxxxxxxx
                                                                 sqdecd.  */
                                                              return 1838;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 20) & 0x1) == 0)
                                                        {
                                                          if (((word >> 22) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0x010xxxx110x01xxxxxxxxxx
                                                                 uqincw.  */
                                                              return 2009;
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 23) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x00110xxxx110x01xxxxxxxxxx
                                                                     uqinch.  */
                                                                  return 2003;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x01110xxxx110x01xxxxxxxxxx
                                                                     uqincd.  */
                                                                  return 2000;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 22) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0x011xxxx110x01xxxxxxxxxx
                                                                 decw.  */
                                                              return 1366;
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 23) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x00111xxxx110x01xxxxxxxxxx
                                                                     dech.  */
                                                                  return 1362;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x01111xxxx110x01xxxxxxxxxx
                                                                     decd.  */
                                                                  return 1360;
                                                                }
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 22) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0x01xxxxx110x11xxxxxxxxxx
                                                             uqdecw.  */
                                                          return 1995;
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0011xxxxx110x11xxxxxxxxxx
                                                                 uqdech.  */
                                                              return 1989;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0111xxxxx110x11xxxxxxxxxx
                                                                 uqdecd.  */
                                                              return 1986;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 21) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         100001x0000xxxxx110xxxxxxxxxxxxx
                                                         prfb.  */
                                                      return 1766;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         100001x0100xxxxx110xxxxxxxxxxxxx
                                                         prfh.  */
                                                      return 1781;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         100001x0001xxxxx110xxxxxxxxxxxxx
                                                         ld1b.  */
                                                      return 1510;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         100001x0101xxxxx110xxxxxxxxxxxxx
                                                         ld1h.  */
                                                      return 1532;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x001xxxxxx110xxxxxxxxxxxxx
                                                     ld1rb.  */
                                                  return 1539;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x011xxxxxx110xxxxxxxxxxxxx
                                                     ld1rh.  */
                                                  return 1543;
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x0000xxxxx110xxxxxxxxxxxxx
                                                     ldnt1b.  */
                                                  return 2092;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x0100xxxxx110xxxxxxxxxxxxx
                                                     ldnt1h.  */
                                                  return 2095;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x0010xxxxx110xxxxxxxxxxxxx
                                                     ld1b.  */
                                                  return 1509;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x0110xxxxx110xxxxxxxxxxxxx
                                                     ld1h.  */
                                                  return 1530;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x0001xxxxx110xxxxxxxxxxxxx
                                                     ld1b.  */
                                                  return 1515;
                                                }
                                              else
                                                {
                                                  if (((word >> 31) & 0x1) == 0)
                                                    {
                                                      if (((word >> 10) & 0x1) == 0)
                                                        {
                                                          if (((word >> 12) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0101xxxxx1100x0xxxxxxxxxx
                                                                 smullb.  */
                                                              return 2157;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0101xxxxx1101x0xxxxxxxxxx
                                                                 umullb.  */
                                                              return 2282;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 12) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0101xxxxx1100x1xxxxxxxxxx
                                                                 smullt.  */
                                                              return 2160;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0101xxxxx1101x1xxxxxxxxxx
                                                                 umullt.  */
                                                              return 2285;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         110001x0101xxxxx110xxxxxxxxxxxxx
                                                         ld1h.  */
                                                      return 1536;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x0011xxxxx110xxxxxxxxxxxxx
                                                     prfw.  */
                                                  return 1790;
                                                }
                                              else
                                                {
                                                  if (((word >> 31) & 0x1) == 0)
                                                    {
                                                      if (((word >> 10) & 0x1) == 0)
                                                        {
                                                          if (((word >> 12) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0111xxxxx1100x0xxxxxxxxxx
                                                                 smullb.  */
                                                              return 2158;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0111xxxxx1101x0xxxxxxxxxx
                                                                 umullb.  */
                                                              return 2283;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 12) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0111xxxxx1100x1xxxxxxxxxx
                                                                 smullt.  */
                                                              return 2161;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0111xxxxx1101x1xxxxxxxxxx
                                                                 umullt.  */
                                                              return 2286;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         110001x0111xxxxx110xxxxxxxxxxxxx
                                                         ld1h.  */
                                                      return 1531;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 14) & 0x1) == 0)
                            {
                              if (((word >> 15) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 17) & 0x1) == 0)
                                                {
                                                  if (((word >> 19) & 0x1) == 0)
                                                    {
                                                      if (((word >> 20) & 0x1) == 0)
                                                        {
                                                          if (((word >> 16) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx000x00001xxxxxxxxxxxxx
                                                                 saddv.  */
                                                              return 1810;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx000x01001xxxxxxxxxxxxx
                                                                 uaddv.  */
                                                              return 1962;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx010x0x001xxxxxxxxxxxxx
                                                             movprfx.  */
                                                          return 1745;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 16) & 0x1) == 0)
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx001x00001xxxxxxxxxxxxx
                                                                 smaxv.  */
                                                              return 1828;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx011x00001xxxxxxxxxxxxx
                                                                 orv.  */
                                                              return 1762;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx001x01001xxxxxxxxxxxxx
                                                                 umaxv.  */
                                                              return 1977;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx011x01001xxxxxxxxxxxxx
                                                                 eorv.  */
                                                              return 1377;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 16) & 0x1) == 0)
                                                    {
                                                      if (((word >> 20) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx00xx10001xxxxxxxxxxxxx
                                                             sminv.  */
                                                          return 1831;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx01xx10001xxxxxxxxxxxxx
                                                             andv.  */
                                                          return 1290;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x0xx0xxx11001xxxxxxxxxxxxx
                                                         uminv.  */
                                                      return 1980;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x00x0xxxxx001xxxxxxxxxxxxx
                                                     ldff1sb.  */
                                                  return 1661;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x01x0xxxxx001xxxxxxxxxxxxx
                                                     ldff1sh.  */
                                                  return 1672;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 12) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     010001x0xx0xxxxx0010xxxxxxxxxxxx
                                                     cmla.  */
                                                  return 2062;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     010001x0xx0xxxxx0011xxxxxxxxxxxx
                                                     sqrdcmlah.  */
                                                  return 2194;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     110001x00x0xxxxx001xxxxxxxxxxxxx
                                                     ldff1sb.  */
                                                  return 1668;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     110001x01x0xxxxx001xxxxxxxxxxxxx
                                                     ldff1sh.  */
                                                  return 1678;
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 10) & 0x1) == 0)
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 22) & 0x1) == 0)
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0001xxxxx001x00xxxxxxxxxx
                                                                 and.  */
                                                              return 1285;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0101xxxxx001x00xxxxxxxxxx
                                                                 eor.  */
                                                              return 1372;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0011xxxxx001x00xxxxxxxxxx
                                                                 orr.  */
                                                              return 1757;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0111xxxxx001x00xxxxxxxxxx
                                                                 bic.  */
                                                              return 1298;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 22) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0x01xxxxx001x10xxxxxxxxxx
                                                             eor3.  */
                                                          return 2065;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0x11xxxxx001x10xxxxxxxxxx
                                                             bcax.  */
                                                          return 2054;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x0xx1xxxxx001x01xxxxxxxxxx
                                                         xar.  */
                                                      return 2327;
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 22) & 0x1) == 0)
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0001xxxxx001x11xxxxxxxxxx
                                                                 bsl.  */
                                                              return 2055;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0101xxxxx001x11xxxxxxxxxx
                                                                 bsl2n.  */
                                                              return 2057;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0011xxxxx001x11xxxxxxxxxx
                                                                 bsl1n.  */
                                                              return 2056;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0111xxxxx001x11xxxxxxxxxx
                                                                 nbsl.  */
                                                              return 2112;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x00x1xxxxx001xxxxxxxxxxxxx
                                                     prfh.  */
                                                  return 1780;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x01x1xxxxx001xxxxxxxxxxxxx
                                                     ldff1sh.  */
                                                  return 1673;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x00x1xxxxx001xxxxxxxxxxxxx
                                                 prfh.  */
                                              return 1782;
                                            }
                                          else
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 10) & 0x1) == 0)
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          if (((word >> 22) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0101xxxxx0010x0xxxxxxxxxx
                                                                 sqdmlalb.  */
                                                              return 2167;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0111xxxxx0010x0xxxxxxxxxx
                                                                 sqdmlalb.  */
                                                              return 2168;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 22) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0101xxxxx0011x0xxxxxxxxxx
                                                                 sqdmlslb.  */
                                                              return 2174;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0111xxxxx0011x0xxxxxxxxxx
                                                                 sqdmlslb.  */
                                                              return 2175;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          if (((word >> 22) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0101xxxxx0010x1xxxxxxxxxx
                                                                 sqdmlalt.  */
                                                              return 2171;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0111xxxxx0010x1xxxxxxxxxx
                                                                 sqdmlalt.  */
                                                              return 2172;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 22) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0101xxxxx0011x1xxxxxxxxxx
                                                                 sqdmlslt.  */
                                                              return 2178;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0111xxxxx0011x1xxxxxxxxxx
                                                                 sqdmlslt.  */
                                                              return 2179;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     110001x01x1xxxxx001xxxxxxxxxxxxx
                                                     ldff1sh.  */
                                                  return 1679;
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 30) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 21) & 0x1) == 0)
                                            {
                                              if (((word >> 16) & 0x1) == 0)
                                                {
                                                  if (((word >> 17) & 0x1) == 0)
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x0000101xxxxxxxxxxxxx
                                                                 sxtb.  */
                                                              return 1953;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x1000101xxxxxxxxxxxxx
                                                                 cls.  */
                                                              return 1318;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x0100101xxxxxxxxxxxxx
                                                                 sxtw.  */
                                                              return 1955;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x1100101xxxxxxxxxxxxx
                                                                 fabs.  */
                                                              return 1380;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x0010101xxxxxxxxxxxxx
                                                                 sxth.  */
                                                              return 1954;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x1010101xxxxxxxxxxxxx
                                                                 cnt.  */
                                                              return 1347;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x0110101xxxxxxxxxxxxx
                                                                 abs.  */
                                                              return 1276;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x1110101xxxxxxxxxxxxx
                                                                 not.  */
                                                              return 1754;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 17) & 0x1) == 0)
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x0001101xxxxxxxxxxxxx
                                                                 uxtb.  */
                                                              return 2016;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x1001101xxxxxxxxxxxxx
                                                                 clz.  */
                                                              return 1319;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x0101101xxxxxxxxxxxxx
                                                                 uxtw.  */
                                                              return 2018;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x1101101xxxxxxxxxxxxx
                                                                 fneg.  */
                                                              return 1457;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x0011101xxxxxxxxxxxxx
                                                                 uxth.  */
                                                              return 2017;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x0xx0x1011101xxxxxxxxxxxxx
                                                                 cnot.  */
                                                              return 1346;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx0xx111101xxxxxxxxxxxxx
                                                             neg.  */
                                                          return 1751;
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 12) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      if (((word >> 22) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0001xxxxx1010xxxxxxxxxxxx
                                                             adr.  */
                                                          return 1282;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0011xxxxx1010xxxxxxxxxxxx
                                                             adr.  */
                                                          return 1283;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x01x1xxxxx1010xxxxxxxxxxxx
                                                         adr.  */
                                                      return 1284;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 10) & 0x1) == 0)
                                                    {
                                                      if (((word >> 11) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx1xxxxx101100xxxxxxxxxx
                                                             ftssel.  */
                                                          return 1483;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx1xxxxx101110xxxxxxxxxx
                                                             fexpa.  */
                                                          return 1427;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x0xx1xxxxx1011x1xxxxxxxxxx
                                                         movprfx.  */
                                                      return 1744;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 21) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         100001x0000xxxxx101xxxxxxxxxxxxx
                                                         ldnt1b.  */
                                                      return 2091;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         100001x0100xxxxx101xxxxxxxxxxxxx
                                                         ldnt1h.  */
                                                      return 2094;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         100001x0001xxxxx101xxxxxxxxxxxxx
                                                         ldff1sb.  */
                                                      return 1670;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         100001x0101xxxxx101xxxxxxxxxxxxx
                                                         ldff1sh.  */
                                                      return 1682;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x001xxxxxx101xxxxxxxxxxxxx
                                                     ld1rb.  */
                                                  return 1538;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x011xxxxxx101xxxxxxxxxxxxx
                                                     ld1rh.  */
                                                  return 1542;
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 16) & 0x1) == 0)
                                                {
                                                  if (((word >> 17) & 0x1) == 0)
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0xx0x0000101xxxxxxxxxxxxx
                                                                 urecpe.  */
                                                              return 2302;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0xx0x1000101xxxxxxxxxxxxx
                                                                 sqabs.  */
                                                              return 2164;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0xx00x100101xxxxxxxxxxxxx
                                                                 sadalp.  */
                                                              return 2128;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0xx01x100101xxxxxxxxxxxxx
                                                                 smaxp.  */
                                                              return 2142;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         010001x0xx0xxx10101xxxxxxxxxxxxx
                                                         sminp.  */
                                                      return 2143;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 17) & 0x1) == 0)
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     010001x0xx000001101xxxxxxxxxxxxx
                                                                     ursqrte.  */
                                                                  return 2307;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     010001x0xx010001101xxxxxxxxxxxxx
                                                                     addp.  */
                                                                  return 2053;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0xx0x1001101xxxxxxxxxxxxx
                                                                 sqneg.  */
                                                              return 2191;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0xx00x101101xxxxxxxxxxxxx
                                                                 uadalp.  */
                                                              return 2259;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0xx01x101101xxxxxxxxxxxxx
                                                                 umaxp.  */
                                                              return 2267;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         010001x0xx0xxx11101xxxxxxxxxxxxx
                                                         uminp.  */
                                                      return 2268;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     110001x00x0xxxxx101xxxxxxxxxxxxx
                                                     ldff1sb.  */
                                                  return 1669;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     110001x01x0xxxxx101xxxxxxxxxxxxx
                                                     ldff1sh.  */
                                                  return 1680;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x0001xxxxx101xxxxxxxxxxxxx
                                                     ldff1sb.  */
                                                  return 1671;
                                                }
                                              else
                                                {
                                                  if (((word >> 31) & 0x1) == 0)
                                                    {
                                                      if (((word >> 10) & 0x1) == 0)
                                                        {
                                                          if (((word >> 12) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0101xxxxx1010x0xxxxxxxxxx
                                                                 smlslb.  */
                                                              return 2150;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0101xxxxx1011x0xxxxxxxxxx
                                                                 umlslb.  */
                                                              return 2275;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 12) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0101xxxxx1010x1xxxxxxxxxx
                                                                 smlslt.  */
                                                              return 2153;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0101xxxxx1011x1xxxxxxxxxx
                                                                 umlslt.  */
                                                              return 2278;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         110001x0101xxxxx101xxxxxxxxxxxxx
                                                         ldff1sh.  */
                                                      return 1683;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x0011xxxxx101xxxxxxxxxxxxx
                                                     prfh.  */
                                                  return 1783;
                                                }
                                              else
                                                {
                                                  if (((word >> 31) & 0x1) == 0)
                                                    {
                                                      if (((word >> 10) & 0x1) == 0)
                                                        {
                                                          if (((word >> 12) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0111xxxxx1010x0xxxxxxxxxx
                                                                 smlslb.  */
                                                              return 2151;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0111xxxxx1011x0xxxxxxxxxx
                                                                 umlslb.  */
                                                              return 2276;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 12) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0111xxxxx1010x1xxxxxxxxxx
                                                                 smlslt.  */
                                                              return 2154;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0111xxxxx1011x1xxxxxxxxxx
                                                                 umlslt.  */
                                                              return 2279;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         110001x0111xxxxx101xxxxxxxxxxxxx
                                                         ldff1sh.  */
                                                      return 1681;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 15) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 000001x0xx0xxxxx011xxxxxxxxxxxxx
                                                 mls.  */
                                              return 1743;
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x00x0xxxxx011xxxxxxxxxxxxx
                                                     ldff1b.  */
                                                  return 1627;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x01x0xxxxx011xxxxxxxxxxxxx
                                                     ldff1h.  */
                                                  return 1647;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 10) & 0x1) == 0)
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x0xx0xxxxx011000xxxxxxxxxx
                                                             sqdmlalb.  */
                                                          return 2169;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x0xx0xxxxx011100xxxxxxxxxx
                                                             sqrdmlah.  */
                                                          return 2198;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x0xx0xxxxx011010xxxxxxxxxx
                                                             sqdmlslb.  */
                                                          return 2176;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x0xx0xxxxx011110xxxxxxxxxx
                                                             usdot.  */
                                                          return 2396;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x0xx0xxxxx011001xxxxxxxxxx
                                                             sqdmlalt.  */
                                                          return 2173;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x0xx0xxxxx011101xxxxxxxxxx
                                                             sqrdmlsh.  */
                                                          return 2202;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         010001x0xx0xxxxx011x11xxxxxxxxxx
                                                         sqdmlslt.  */
                                                      return 2180;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     110001x00x0xxxxx011xxxxxxxxxxxxx
                                                     ldff1b.  */
                                                  return 1636;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     110001x01x0xxxxx011xxxxxxxxxxxxx
                                                     ldff1h.  */
                                                  return 1655;
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 10) & 0x1) == 0)
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx1xxxxx011000xxxxxxxxxx
                                                             mul.  */
                                                          return 2111;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx1xxxxx011100xxxxxxxxxx
                                                             sqdmulh.  */
                                                          return 2184;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x0xx1xxxxx011x10xxxxxxxxxx
                                                         smulh.  */
                                                      return 2156;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx1xxxxx011001xxxxxxxxxx
                                                             pmul.  */
                                                          return 2114;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x0xx1xxxxx011101xxxxxxxxxx
                                                             sqrdmulh.  */
                                                          return 2206;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x0xx1xxxxx011x11xxxxxxxxxx
                                                         umulh.  */
                                                      return 2281;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x00x1xxxxx011xxxxxxxxxxxxx
                                                     prfd.  */
                                                  return 1773;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x01x1xxxxx011xxxxxxxxxxxxx
                                                     ldff1h.  */
                                                  return 1648;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x00x1xxxxx011xxxxxxxxxxxxx
                                                 prfd.  */
                                              return 1775;
                                            }
                                          else
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 12) & 0x1) == 0)
                                                    {
                                                      if (((word >> 22) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x0101xxxxx0110xxxxxxxxxxxx
                                                             cmla.  */
                                                          return 2063;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x0111xxxxx0110xxxxxxxxxxxx
                                                             cmla.  */
                                                          return 2064;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 22) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x0101xxxxx0111xxxxxxxxxxxx
                                                             sqrdcmlah.  */
                                                          return 2192;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x0111xxxxx0111xxxxxxxxxxxx
                                                             sqrdcmlah.  */
                                                          return 2193;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     110001x01x1xxxxx011xxxxxxxxxxxxx
                                                     ldff1h.  */
                                                  return 1656;
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 30) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 21) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 000001x0xx0xxxxx111xxxxxxxxxxxxx
                                                 msb.  */
                                              return 1746;
                                            }
                                          else
                                            {
                                              if (((word >> 10) & 0x1) == 0)
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              if (((word >> 22) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 23) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x00010xxxx111000xxxxxxxxxx
                                                                         cntb.  */
                                                                      return 1348;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x01010xxxx111000xxxxxxxxxx
                                                                         cntw.  */
                                                                      return 1352;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 23) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x00110xxxx111000xxxxxxxxxx
                                                                         cnth.  */
                                                                      return 1350;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x01110xxxx111000xxxxxxxxxx
                                                                         cntd.  */
                                                                      return 1349;
                                                                    }
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 22) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 23) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x00011xxxx111000xxxxxxxxxx
                                                                         incb.  */
                                                                      return 1484;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x01011xxxx111000xxxxxxxxxx
                                                                         incw.  */
                                                                      return 1492;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 23) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x00111xxxx111000xxxxxxxxxx
                                                                         inch.  */
                                                                      return 1488;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x01111xxxx111000xxxxxxxxxx
                                                                         incd.  */
                                                                      return 1486;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              if (((word >> 22) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 23) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x00010xxxx111100xxxxxxxxxx
                                                                         sqincb.  */
                                                                      return 1851;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x01010xxxx111100xxxxxxxxxx
                                                                         sqincw.  */
                                                                      return 1863;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 23) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x00110xxxx111100xxxxxxxxxx
                                                                         sqinch.  */
                                                                      return 1857;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x01110xxxx111100xxxxxxxxxx
                                                                         sqincd.  */
                                                                      return 1854;
                                                                    }
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 22) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 23) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x00011xxxx111100xxxxxxxxxx
                                                                         sqincb.  */
                                                                      return 1850;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x01011xxxx111100xxxxxxxxxx
                                                                         sqincw.  */
                                                                      return 1862;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 23) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x00111xxxx111100xxxxxxxxxx
                                                                         sqinch.  */
                                                                      return 1856;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x01111xxxx111100xxxxxxxxxx
                                                                         sqincd.  */
                                                                      return 1853;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 20) & 0x1) == 0)
                                                        {
                                                          if (((word >> 22) & 0x1) == 0)
                                                            {
                                                              if (((word >> 23) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x00010xxxx111x10xxxxxxxxxx
                                                                     sqdecb.  */
                                                                  return 1837;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x01010xxxx111x10xxxxxxxxxx
                                                                     sqdecw.  */
                                                                  return 1849;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 23) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x00110xxxx111x10xxxxxxxxxx
                                                                     sqdech.  */
                                                                  return 1843;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x01110xxxx111x10xxxxxxxxxx
                                                                     sqdecd.  */
                                                                  return 1840;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 22) & 0x1) == 0)
                                                            {
                                                              if (((word >> 23) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x00011xxxx111x10xxxxxxxxxx
                                                                     sqdecb.  */
                                                                  return 1836;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x01011xxxx111x10xxxxxxxxxx
                                                                     sqdecw.  */
                                                                  return 1848;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 23) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x00111xxxx111x10xxxxxxxxxx
                                                                     sqdech.  */
                                                                  return 1842;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x01111xxxx111x10xxxxxxxxxx
                                                                     sqdecd.  */
                                                                  return 1839;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          if (((word >> 22) & 0x1) == 0)
                                                            {
                                                              if (((word >> 23) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0001xxxxx111001xxxxxxxxxx
                                                                     decb.  */
                                                                  return 1359;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0101xxxxx111001xxxxxxxxxx
                                                                     decw.  */
                                                                  return 1367;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 23) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0011xxxxx111001xxxxxxxxxx
                                                                     dech.  */
                                                                  return 1363;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x0111xxxxx111001xxxxxxxxxx
                                                                     decd.  */
                                                                  return 1361;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              if (((word >> 22) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 23) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x00010xxxx111101xxxxxxxxxx
                                                                         uqincb.  */
                                                                      return 1998;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x01010xxxx111101xxxxxxxxxx
                                                                         uqincw.  */
                                                                      return 2010;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 23) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x00110xxxx111101xxxxxxxxxx
                                                                         uqinch.  */
                                                                      return 2004;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x01110xxxx111101xxxxxxxxxx
                                                                         uqincd.  */
                                                                      return 2001;
                                                                    }
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 22) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 23) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x00011xxxx111101xxxxxxxxxx
                                                                         uqincb.  */
                                                                      return 1999;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x01011xxxx111101xxxxxxxxxx
                                                                         uqincw.  */
                                                                      return 2011;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 23) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x00111xxxx111101xxxxxxxxxx
                                                                         uqinch.  */
                                                                      return 2005;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x01111xxxx111101xxxxxxxxxx
                                                                         uqincd.  */
                                                                      return 2002;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 20) & 0x1) == 0)
                                                        {
                                                          if (((word >> 22) & 0x1) == 0)
                                                            {
                                                              if (((word >> 23) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x00010xxxx111x11xxxxxxxxxx
                                                                     uqdecb.  */
                                                                  return 1984;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x01010xxxx111x11xxxxxxxxxx
                                                                     uqdecw.  */
                                                                  return 1996;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 23) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x00110xxxx111x11xxxxxxxxxx
                                                                     uqdech.  */
                                                                  return 1990;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x01110xxxx111x11xxxxxxxxxx
                                                                     uqdecd.  */
                                                                  return 1987;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 22) & 0x1) == 0)
                                                            {
                                                              if (((word >> 23) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x00011xxxx111x11xxxxxxxxxx
                                                                     uqdecb.  */
                                                                  return 1985;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x01011xxxx111x11xxxxxxxxxx
                                                                     uqdecw.  */
                                                                  return 1997;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 23) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x00111xxxx111x11xxxxxxxxxx
                                                                     uqdech.  */
                                                                  return 1991;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x01111xxxx111x11xxxxxxxxxx
                                                                     uqdecd.  */
                                                                  return 1988;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 21) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         100001x0000xxxxx111xxxxxxxxxxxxx
                                                         prfb.  */
                                                      return 1770;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         100001x0100xxxxx111xxxxxxxxxxxxx
                                                         prfh.  */
                                                      return 1784;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         100001x0001xxxxx111xxxxxxxxxxxxx
                                                         ldff1b.  */
                                                      return 1638;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         100001x0101xxxxx111xxxxxxxxxxxxx
                                                         ldff1h.  */
                                                      return 1659;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x001xxxxxx111xxxxxxxxxxxxx
                                                     ld1rb.  */
                                                  return 1540;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x011xxxxxx111xxxxxxxxxxxxx
                                                     ld1rh.  */
                                                  return 1544;
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x0000xxxxx111xxxxxxxxxxxxx
                                                     prfb.  */
                                                  return 1772;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x0100xxxxx111xxxxxxxxxxxxx
                                                     prfh.  */
                                                  return 1786;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x0010xxxxx111xxxxxxxxxxxxx
                                                     ldff1b.  */
                                                  return 1637;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x0110xxxxx111xxxxxxxxxxxxx
                                                     ldff1h.  */
                                                  return 1657;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 10) & 0x1) == 0)
                                                    {
                                                      if (((word >> 11) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x00x1xxxxx111x00xxxxxxxxxx
                                                             sqdmulh.  */
                                                          return 2181;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x00x1xxxxx111x10xxxxxxxxxx
                                                             mul.  */
                                                          return 2108;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         010001x00x1xxxxx111xx1xxxxxxxxxx
                                                         sqrdmulh.  */
                                                      return 2203;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         110001x0001xxxxx111xxxxxxxxxxxxx
                                                         ldff1b.  */
                                                      return 1639;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         110001x0011xxxxx111xxxxxxxxxxxxx
                                                         prfd.  */
                                                      return 1776;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 31) & 0x1) == 0)
                                                    {
                                                      if (((word >> 10) & 0x1) == 0)
                                                        {
                                                          if (((word >> 12) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0101xxxxx1110x0xxxxxxxxxx
                                                                 sqdmullb.  */
                                                              return 2185;
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 11) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     010001x0101xxxxx111100xxxxxxxxxx
                                                                     sqdmulh.  */
                                                                  return 2182;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     010001x0101xxxxx111110xxxxxxxxxx
                                                                     mul.  */
                                                                  return 2109;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 12) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0101xxxxx1110x1xxxxxxxxxx
                                                                 sqdmullt.  */
                                                              return 2188;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0101xxxxx1111x1xxxxxxxxxx
                                                                 sqrdmulh.  */
                                                              return 2204;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         110001x0101xxxxx111xxxxxxxxxxxxx
                                                         ldff1h.  */
                                                      return 1660;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 31) & 0x1) == 0)
                                                    {
                                                      if (((word >> 10) & 0x1) == 0)
                                                        {
                                                          if (((word >> 12) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0111xxxxx1110x0xxxxxxxxxx
                                                                 sqdmullb.  */
                                                              return 2186;
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 11) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     010001x0111xxxxx111100xxxxxxxxxx
                                                                     sqdmulh.  */
                                                                  return 2183;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     010001x0111xxxxx111110xxxxxxxxxx
                                                                     mul.  */
                                                                  return 2110;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 12) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0111xxxxx1110x1xxxxxxxxxx
                                                                 sqdmullt.  */
                                                              return 2189;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x0111xxxxx1111x1xxxxxxxxxx
                                                                 sqrdmulh.  */
                                                              return 2205;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         110001x0111xxxxx111xxxxxxxxxxxxx
                                                         ldff1h.  */
                                                      return 1658;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 21) & 0x1) == 0)
                        {
                          if (((word >> 15) & 0x1) == 0)
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 4) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x0xx0xxxxx000xxxxxxxx0xxxx
                                                     cmphs.  */
                                                  return 1332;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x0xx0xxxxx000xxxxxxxx1xxxx
                                                     cmphi.  */
                                                  return 1329;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     101001x00x0xxxxx000xxxxxxxxxxxxx
                                                     ld1rqb.  */
                                                  return 1546;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     101001x01x0xxxxx000xxxxxxxxxxxxx
                                                     ld1rqh.  */
                                                  return 1550;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 4) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x0xx0xxxxx010xxxxxxxx0xxxx
                                                     cmpge.  */
                                                  return 1323;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x0xx0xxxxx010xxxxxxxx1xxxx
                                                     cmpgt.  */
                                                  return 1326;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0000xxxxx010xxxxxxxxxxxxx
                                                         ld1b.  */
                                                      return 1504;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0100xxxxx010xxxxxxxxxxxxx
                                                         ld1sw.  */
                                                      return 1584;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0010xxxxx010xxxxxxxxxxxxx
                                                         ld1b.  */
                                                      return 1506;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0110xxxxx010xxxxxxxxxxxxx
                                                         ld1h.  */
                                                      return 1526;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 4) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x0xx0xxxxx001xxxxxxxx0xxxx
                                                     cmpeq.  */
                                                  return 1320;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x0xx0xxxxx001xxxxxxxx1xxxx
                                                     cmpne.  */
                                                  return 1343;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     101001x00x0xxxxx001xxxxxxxxxxxxx
                                                     ld1rqb.  */
                                                  return 1545;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     101001x01x0xxxxx001xxxxxxxxxxxxx
                                                     ld1rqh.  */
                                                  return 1549;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 4) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x0xx0xxxxx011xxxxxxxx0xxxx
                                                     cmplt.  */
                                                  return 1341;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x0xx0xxxxx011xxxxxxxx1xxxx
                                                     cmple.  */
                                                  return 1335;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0000xxxxx011xxxxxxxxxxxxx
                                                         ldff1b.  */
                                                      return 1628;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0100xxxxx011xxxxxxxxxxxxx
                                                         ldff1sw.  */
                                                      return 1684;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0010xxxxx011xxxxxxxxxxxxx
                                                         ldff1b.  */
                                                      return 1632;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0110xxxxx011xxxxxxxxxxxxx
                                                         ldff1h.  */
                                                      return 1651;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 31) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         011001x0xx0xxxxx0xxxxxxxxxxxxxxx
                                         fcmla.  */
                                      return 1389;
                                    }
                                  else
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 111001x0x00xxxxx0x0xxxxxxxxxxxxx
                                                 st1b.  */
                                              return 1866;
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     111001x0010xxxxx0x0xxxxxxxxxxxxx
                                                     st1b.  */
                                                  return 1870;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     111001x0110xxxxx0x0xxxxxxxxxxxxx
                                                     st1h.  */
                                                  return 1891;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x0000xxxxx001xxxxxxxxxxxxx
                                                         stnt1b.  */
                                                      return 2243;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x0100xxxxx001xxxxxxxxxxxxx
                                                         stnt1h.  */
                                                      return 2246;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x0010xxxxx001xxxxxxxxxxxxx
                                                         stnt1b.  */
                                                      return 2242;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x0110xxxxx001xxxxxxxxxxxxx
                                                         stnt1h.  */
                                                      return 2245;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x0000xxxxx011xxxxxxxxxxxxx
                                                         stnt1b.  */
                                                      return 1936;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x0100xxxxx011xxxxxxxxxxxxx
                                                         stnt1h.  */
                                                      return 1940;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x0010xxxxx011xxxxxxxxxxxxx
                                                         st3b.  */
                                                      return 1920;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x0110xxxxx011xxxxxxxxxxxxx
                                                         st3h.  */
                                                      return 1924;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 13) & 0x1) == 0)
                                {
                                  if (((word >> 30) & 0x1) == 0)
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 4) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x01001x0xx0xxxxx100xxxxxxxx0xxxx
                                                 cmpge.  */
                                              return 1324;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x01001x0xx0xxxxx100xxxxxxxx1xxxx
                                                 cmpgt.  */
                                              return 1327;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 4) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x0xx0xxxxx110xxxxxxxx0xxxx
                                                     cmphs.  */
                                                  return 1333;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x0xx0xxxxx110xxxxxxxx1xxxx
                                                     cmphi.  */
                                                  return 1330;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0000xxxxx110xxxxxxxxxxxxx
                                                         ldnt1b.  */
                                                      return 1719;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0100xxxxx110xxxxxxxxxxxxx
                                                         ldnt1h.  */
                                                      return 1723;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0010xxxxx110xxxxxxxxxxxxx
                                                         ld3b.  */
                                                      return 1611;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0110xxxxx110xxxxxxxxxxxxx
                                                         ld3h.  */
                                                      return 1615;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 17) & 0x1) == 0)
                                            {
                                              if (((word >> 18) & 0x1) == 0)
                                                {
                                                  if (((word >> 20) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         011001x0xx00x00x1x0xxxxxxxxxxxxx
                                                         fcadd.  */
                                                      return 1388;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         011001x0xx01x00x1x0xxxxxxxxxxxxx
                                                         faddp.  */
                                                      return 2069;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 16) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         011001x0xx0xx1001x0xxxxxxxxxxxxx
                                                         fmaxnmp.  */
                                                      return 2077;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         011001x0xx0xx1011x0xxxxxxxxxxxxx
                                                         fminnmp.  */
                                                      return 2079;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 16) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     011001x0xx0xxx101x0xxxxxxxxxxxxx
                                                     fmaxp.  */
                                                  return 2078;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     011001x0xx0xxx111x0xxxxxxxxxxxxx
                                                     fminp.  */
                                                  return 2080;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     111001x0000xxxxx1x0xxxxxxxxxxxxx
                                                     st1b.  */
                                                  return 1867;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     111001x0100xxxxx1x0xxxxxxxxxxxxx
                                                     st1h.  */
                                                  return 1886;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     111001x0010xxxxx1x0xxxxxxxxxxxxx
                                                     st1b.  */
                                                  return 1871;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     111001x0110xxxxx1x0xxxxxxxxxxxxx
                                                     st1h.  */
                                                  return 1892;
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 14) & 0x1) == 0)
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 4) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x0xx0xxxxx101xxxxxxxx0xxxx
                                                     cmpeq.  */
                                                  return 1321;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x0xx0xxxxx101xxxxxxxx1xxxx
                                                     cmpne.  */
                                                  return 1344;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 20) & 0x1) == 0)
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             101001x00000xxxx101xxxxxxxxxxxxx
                                                             ld1b.  */
                                                          return 1511;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             101001x01000xxxx101xxxxxxxxxxxxx
                                                             ld1sw.  */
                                                          return 1589;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             101001x00100xxxx101xxxxxxxxxxxxx
                                                             ld1b.  */
                                                          return 1513;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             101001x01100xxxx101xxxxxxxxxxxxx
                                                             ld1h.  */
                                                          return 1534;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             101001x00001xxxx101xxxxxxxxxxxxx
                                                             ldnf1b.  */
                                                          return 1703;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             101001x01001xxxx101xxxxxxxxxxxxx
                                                             ldnf1sw.  */
                                                          return 1716;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             101001x00101xxxx101xxxxxxxxxxxxx
                                                             ldnf1b.  */
                                                          return 1705;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             101001x01101xxxx101xxxxxxxxxxxxx
                                                             ldnf1h.  */
                                                          return 1709;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  if (((word >> 31) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         011001x0000xxxxx101xxxxxxxxxxxxx
                                                         fcvtxnt.  */
                                                      return 2075;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x0000xxxxx101xxxxxxxxxxxxx
                                                         st1b.  */
                                                      return 1868;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 31) & 0x1) == 0)
                                                    {
                                                      if (((word >> 16) & 0x1) == 0)
                                                        {
                                                          if (((word >> 17) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 011001x0100xxx00101xxxxxxxxxxxxx
                                                                 fcvtnt.  */
                                                              return 2072;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 011001x0100xxx10101xxxxxxxxxxxxx
                                                                 bfcvtnt.  */
                                                              return 2425;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             011001x0100xxxx1101xxxxxxxxxxxxx
                                                             fcvtlt.  */
                                                          return 2070;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x0100xxxxx101xxxxxxxxxxxxx
                                                         st1h.  */
                                                      return 1887;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x11001x0010xxxxx101xxxxxxxxxxxxx
                                                     st1b.  */
                                                  return 1875;
                                                }
                                              else
                                                {
                                                  if (((word >> 31) & 0x1) == 0)
                                                    {
                                                      if (((word >> 16) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             011001x0110xxxx0101xxxxxxxxxxxxx
                                                             fcvtnt.  */
                                                          return 2073;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             011001x0110xxxx1101xxxxxxxxxxxxx
                                                             fcvtlt.  */
                                                          return 2071;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x0110xxxxx101xxxxxxxxxxxxx
                                                         st1h.  */
                                                      return 1896;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 4) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x0xx0xxxxx111xxxxxxxx0xxxx
                                                     cmplo.  */
                                                  return 1337;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x0xx0xxxxx111xxxxxxxx1xxxx
                                                     cmpls.  */
                                                  return 1339;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0000xxxxx111xxxxxxxxxxxxx
                                                         ldnt1b.  */
                                                      return 1720;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0100xxxxx111xxxxxxxxxxxxx
                                                         ldnt1h.  */
                                                      return 1724;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0010xxxxx111xxxxxxxxxxxxx
                                                         ld3b.  */
                                                      return 1612;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0110xxxxx111xxxxxxxxxxxxx
                                                         ld3h.  */
                                                      return 1616;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 20) & 0x1) == 0)
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x11001x0x000xxxx111xxxxxxxxxxxxx
                                                     st1b.  */
                                                  return 1873;
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x11001x00100xxxx111xxxxxxxxxxxxx
                                                         st1b.  */
                                                      return 1876;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x11001x01100xxxx111xxxxxxxxxxxxx
                                                         st1h.  */
                                                      return 1897;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x11001x00001xxxx111xxxxxxxxxxxxx
                                                         stnt1b.  */
                                                      return 1937;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x11001x01001xxxx111xxxxxxxxxxxxx
                                                         stnt1h.  */
                                                      return 1941;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x11001x00101xxxx111xxxxxxxxxxxxx
                                                         st3b.  */
                                                      return 1921;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x11001x01101xxxx111xxxxxxxxxxxxx
                                                         st3h.  */
                                                      return 1925;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 13) & 0x1) == 0)
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  if (((word >> 31) & 0x1) == 0)
                                    {
                                      if (((word >> 4) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             001001x0xx1xxxxxxx0xxxxxxxx0xxxx
                                             cmphs.  */
                                          return 1334;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             001001x0xx1xxxxxxx0xxxxxxxx1xxxx
                                             cmphi.  */
                                          return 1331;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 101001x00x1xxxxxx00xxxxxxxxxxxxx
                                                 ld1rob.  */
                                              return 2401;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 101001x01x1xxxxxx00xxxxxxxxxxxxx
                                                 ld1roh.  */
                                              return 2402;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0001xxxxx010xxxxxxxxxxxxx
                                                         ld1b.  */
                                                      return 1505;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0101xxxxx010xxxxxxxxxxxxx
                                                         ld1h.  */
                                                      return 1525;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0011xxxxx010xxxxxxxxxxxxx
                                                         ld1b.  */
                                                      return 1507;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0111xxxxx010xxxxxxxxxxxxx
                                                         ld1h.  */
                                                      return 1527;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0001xxxxx110xxxxxxxxxxxxx
                                                         ld2b.  */
                                                      return 1603;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0101xxxxx110xxxxxxxxxxxxx
                                                         ld2h.  */
                                                      return 1607;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0011xxxxx110xxxxxxxxxxxxx
                                                         ld4b.  */
                                                      return 1619;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0111xxxxx110xxxxxxxxxxxxx
                                                         ld4h.  */
                                                      return 1623;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 15) & 0x1) == 0)
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 12) & 0x1) == 0)
                                            {
                                              if (((word >> 10) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x11001x00x1xxxxx0000x0xxxxxxxxxx
                                                         fmla.  */
                                                      return 1442;
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 22) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x11001x0101xxxxx0000x0xxxxxxxxxx
                                                             fmla.  */
                                                          return 1443;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x11001x0111xxxxx0000x0xxxxxxxxxx
                                                             fmla.  */
                                                          return 1444;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x11001x00x1xxxxx0000x1xxxxxxxxxx
                                                         fmls.  */
                                                      return 1446;
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 22) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x11001x0101xxxxx0000x1xxxxxxxxxx
                                                             fmls.  */
                                                          return 1447;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             x11001x0111xxxxx0000x1xxxxxxxxxx
                                                             fmls.  */
                                                          return 1448;
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x11001x0x01xxxxx0001xxxxxxxxxxxx
                                                     fcmla.  */
                                                  return 1390;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x11001x0x11xxxxx0001xxxxxxxxxxxx
                                                     fcmla.  */
                                                  return 1391;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x11001x0001xxxxx010xxxxxxxxxxxxx
                                                     st1b.  */
                                                  return 1869;
                                                }
                                              else
                                                {
                                                  if (((word >> 31) & 0x1) == 0)
                                                    {
                                                      if (((word >> 10) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             011001x0101xxxxx010xx0xxxxxxxxxx
                                                             fmlalb.  */
                                                          return 2081;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             011001x0101xxxxx010xx1xxxxxxxxxx
                                                             fmlalt.  */
                                                          return 2083;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x0101xxxxx010xxxxxxxxxxxxx
                                                         st1h.  */
                                                      return 1888;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  if (((word >> 31) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         011001x0011xxxxx010xxxxxxxxxxxxx
                                                         bfdot.  */
                                                      return 2422;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x0011xxxxx010xxxxxxxxxxxxx
                                                         st1b.  */
                                                      return 1872;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 31) & 0x1) == 0)
                                                    {
                                                      if (((word >> 10) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             011001x0111xxxxx010xx0xxxxxxxxxx
                                                             bfmlalb.  */
                                                          return 2429;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             011001x0111xxxxx010xx1xxxxxxxxxx
                                                             bfmlalt.  */
                                                          return 2428;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x0111xxxxx010xxxxxxxxxxxxx
                                                         st1h.  */
                                                      return 1893;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 22) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 10) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     011001x0x01xxxxx1x0xx0xxxxxxxxxx
                                                     fmlalb.  */
                                                  return 2082;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     011001x0x01xxxxx1x0xx1xxxxxxxxxx
                                                     fmlalt.  */
                                                  return 2084;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 111001x0x01xxxxx1x0xxxxxxxxxxxxx
                                                 st1h.  */
                                              return 1889;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x11001x0011xxxxx1x0xxxxxxxxxxxxx
                                                 bfdot.  */
                                              return 2421;
                                            }
                                          else
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 10) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         011001x0111xxxxx1x0xx0xxxxxxxxxx
                                                         bfmlalb.  */
                                                      return 2427;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         011001x0111xxxxx1x0xx1xxxxxxxxxx
                                                         bfmlalt.  */
                                                      return 2426;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     111001x0111xxxxx1x0xxxxxxxxxxxxx
                                                     st1h.  */
                                                  return 1894;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  if (((word >> 31) & 0x1) == 0)
                                    {
                                      if (((word >> 4) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             001001x0xx1xxxxxxx1xxxxxxxx0xxxx
                                             cmplo.  */
                                          return 1338;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             001001x0xx1xxxxxxx1xxxxxxxx1xxxx
                                             cmpls.  */
                                          return 1340;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     101001x00x1xxxxx001xxxxxxxxxxxxx
                                                     ld1rob.  */
                                                  return 2405;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     101001x01x1xxxxx001xxxxxxxxxxxxx
                                                     ld1roh.  */
                                                  return 2406;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 20) & 0x1) == 0)
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             101001x00010xxxx101xxxxxxxxxxxxx
                                                             ld1b.  */
                                                          return 1512;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             101001x01010xxxx101xxxxxxxxxxxxx
                                                             ld1h.  */
                                                          return 1533;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             101001x00110xxxx101xxxxxxxxxxxxx
                                                             ld1b.  */
                                                          return 1514;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             101001x01110xxxx101xxxxxxxxxxxxx
                                                             ld1h.  */
                                                          return 1535;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             101001x00011xxxx101xxxxxxxxxxxxx
                                                             ldnf1b.  */
                                                          return 1704;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             101001x01011xxxx101xxxxxxxxxxxxx
                                                             ldnf1h.  */
                                                          return 1708;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             101001x00111xxxx101xxxxxxxxxxxxx
                                                             ldnf1b.  */
                                                          return 1706;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             101001x01111xxxx101xxxxxxxxxxxxx
                                                             ldnf1h.  */
                                                          return 1710;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0001xxxxx011xxxxxxxxxxxxx
                                                         ldff1b.  */
                                                      return 1630;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0101xxxxx011xxxxxxxxxxxxx
                                                         ldff1h.  */
                                                      return 1649;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0011xxxxx011xxxxxxxxxxxxx
                                                         ldff1b.  */
                                                      return 1634;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0111xxxxx011xxxxxxxxxxxxx
                                                         ldff1h.  */
                                                      return 1653;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0001xxxxx111xxxxxxxxxxxxx
                                                         ld2b.  */
                                                      return 1604;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0101xxxxx111xxxxxxxxxxxxx
                                                         ld2h.  */
                                                      return 1608;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0011xxxxx111xxxxxxxxxxxxx
                                                         ld4b.  */
                                                      return 1620;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x0111xxxxx111xxxxxxxxxxxxx
                                                         ld4h.  */
                                                      return 1624;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 14) & 0x1) == 0)
                                    {
                                      if (((word >> 15) & 0x1) == 0)
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x11001x00x1xxxxx001xxxxxxxxxxxxx
                                                 fmul.  */
                                              return 1453;
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x11001x0101xxxxx001xxxxxxxxxxxxx
                                                     fmul.  */
                                                  return 1454;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x11001x0111xxxxx001xxxxxxxxxxxxx
                                                     fmul.  */
                                                  return 1455;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 10) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         011001x0x01xxxxx101xx0xxxxxxxxxx
                                                         fmlslb.  */
                                                      return 2086;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         011001x0x01xxxxx101xx1xxxxxxxxxx
                                                         fmlslt.  */
                                                      return 2088;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     111001x0x01xxxxx101xxxxxxxxxxxxx
                                                     st1h.  */
                                                  return 1890;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x11001x0011xxxxx101xxxxxxxxxxxxx
                                                     st1b.  */
                                                  return 1877;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x11001x0111xxxxx101xxxxxxxxxxxxx
                                                     st1h.  */
                                                  return 1898;
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 15) & 0x1) == 0)
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x11001x0001xxxxx011xxxxxxxxxxxxx
                                                     st2b.  */
                                                  return 1912;
                                                }
                                              else
                                                {
                                                  if (((word >> 31) & 0x1) == 0)
                                                    {
                                                      if (((word >> 10) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             011001x0101xxxxx011xx0xxxxxxxxxx
                                                             fmlslb.  */
                                                          return 2085;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             011001x0101xxxxx011xx1xxxxxxxxxx
                                                             fmlslt.  */
                                                          return 2087;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x0101xxxxx011xxxxxxxxxxxxx
                                                         st2h.  */
                                                      return 1916;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x11001x0011xxxxx011xxxxxxxxxxxxx
                                                     st4b.  */
                                                  return 1928;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x11001x0111xxxxx011xxxxxxxxxxxxx
                                                     st4h.  */
                                                  return 1932;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  if (((word >> 20) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x11001x00010xxxx111xxxxxxxxxxxxx
                                                         st1b.  */
                                                      return 1874;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x11001x00011xxxx111xxxxxxxxxxxxx
                                                         st2b.  */
                                                      return 1913;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 31) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         011001x0101xxxxx111xxxxxxxxxxxxx
                                                         fmmla.  */
                                                      return 2399;
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 20) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             111001x01010xxxx111xxxxxxxxxxxxx
                                                             st1h.  */
                                                          return 1895;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             111001x01011xxxx111xxxxxxxxxxxxx
                                                             st2h.  */
                                                          return 1917;
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  if (((word >> 31) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         011001x0011xxxxx111xxxxxxxxxxxxx
                                                         bfmmla.  */
                                                      return 2423;
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 20) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             111001x00110xxxx111xxxxxxxxxxxxx
                                                             st1b.  */
                                                          return 1878;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             111001x00111xxxx111xxxxxxxxxxxxx
                                                             st4b.  */
                                                          return 1929;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 31) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         011001x0111xxxxx111xxxxxxxxxxxxx
                                                         fmmla.  */
                                                      return 2400;
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 20) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             111001x01110xxxx111xxxxxxxxxxxxx
                                                             st1h.  */
                                                          return 1899;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             111001x01111xxxx111xxxxxxxxxxxxx
                                                             st4h.  */
                                                          return 1933;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
              else
                {
                  if (((word >> 29) & 0x1) == 0)
                    {
                      if (((word >> 30) & 0x1) == 0)
                        {
                          if (((word >> 31) & 0x1) == 0)
                            {
                              if (((word >> 21) & 0x1) == 0)
                                {
                                  if (((word >> 20) & 0x1) == 0)
                                    {
                                      if (((word >> 22) & 0x1) == 0)
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 000001x10000xxxxxxxxxxxxxxxxxxxx
                                                 orr.  */
                                              return 1758;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 000001x11000xxxxxxxxxxxxxxxxxxxx
                                                 and.  */
                                              return 1286;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 000001x10100xxxxxxxxxxxxxxxxxxxx
                                                 eor.  */
                                              return 1373;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 000001x11100xxxxxxxxxxxxxxxxxxxx
                                                 dupm.  */
                                              return 1371;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 15) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             000001x1xx01xxxx0xxxxxxxxxxxxxxx
                                             cpy.  */
                                          return 1356;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             000001x1xx01xxxx1xxxxxxxxxxxxxxx
                                             fcpy.  */
                                          return 1403;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 14) & 0x1) == 0)
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x1001xxxxx000xxxxxxxxxxxxx
                                                         ext.  */
                                                      return 1378;
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 10) & 0x1) == 0)
                                                        {
                                                          if (((word >> 11) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x1101xxxxx000x00xxxxxxxxxx
                                                                 zip1.  */
                                                              return 2409;
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 12) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x1101xxxxx000010xxxxxxxxxx
                                                                     uzp1.  */
                                                                  return 2411;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x1101xxxxx000110xxxxxxxxxx
                                                                     trn1.  */
                                                                  return 2413;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 11) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x1101xxxxx000x01xxxxxxxxxx
                                                                 zip2.  */
                                                              return 2410;
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 12) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x1101xxxxx000011xxxxxxxxxx
                                                                     uzp2.  */
                                                                  return 2412;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x1101xxxxx000111xxxxxxxxxx
                                                                     trn2.  */
                                                                  return 2414;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     000001x1x11xxxxx000xxxxxxxxxxxxx
                                                     ext.  */
                                                  return 2068;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 16) & 0x1) == 0)
                                                {
                                                  if (((word >> 17) & 0x1) == 0)
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x1xx1x0000100xxxxxxxxxxxxx
                                                                 cpy.  */
                                                              return 1354;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x1xx1x1000100xxxxxxxxxxxxx
                                                                 clasta.  */
                                                              return 1312;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x1xx1x0100100xxxxxxxxxxxxx
                                                                 revb.  */
                                                              return 1806;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x1xx1x1100100xxxxxxxxxxxxx
                                                                 splice.  */
                                                              return 1833;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x1xx1x0010100xxxxxxxxxxxxx
                                                                 lasta.  */
                                                              return 1500;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x1xx1x1010100xxxxxxxxxxxxx
                                                                 clasta.  */
                                                              return 1313;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x1xx1xx110100xxxxxxxxxxxxx
                                                             revw.  */
                                                          return 1808;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 17) & 0x1) == 0)
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x1xx1x0001100xxxxxxxxxxxxx
                                                                 compact.  */
                                                              return 1353;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x1xx1x1001100xxxxxxxxxxxxx
                                                                 clastb.  */
                                                              return 1315;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x1xx1x0101100xxxxxxxxxxxxx
                                                                 revh.  */
                                                              return 1807;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x1xx1x1101100xxxxxxxxxxxxx
                                                                 splice.  */
                                                              return 2163;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x1xx1x0011100xxxxxxxxxxxxx
                                                                 lastb.  */
                                                              return 1502;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x1xx1x1011100xxxxxxxxxxxxx
                                                                 clastb.  */
                                                              return 1316;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x1xx1xx111100xxxxxxxxxxxxx
                                                             rbit.  */
                                                          return 1799;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 10) & 0x1) == 0)
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x1xx1xxxxx001000xxxxxxxxxx
                                                             dup.  */
                                                          return 1369;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x1xx1xxxxx001100xxxxxxxxxx
                                                             tbl.  */
                                                          return 1956;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x1xx1xxxxx001010xxxxxxxxxx
                                                             tbl.  */
                                                          return 2252;
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 16) & 0x1) == 0)
                                                            {
                                                              if (((word >> 17) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 18) & 0x1) == 0)
                                                                    {
                                                                      if (((word >> 19) & 0x1) == 0)
                                                                        {
                                                                          if (((word >> 20) & 0x1) == 0)
                                                                            {
                                                                              /* 33222222222211111111110000000000
                                                                                 10987654321098765432109876543210
                                                                                 000001x1xx100000001110xxxxxxxxxx
                                                                                 dup.  */
                                                                              return 1368;
                                                                            }
                                                                          else
                                                                            {
                                                                              /* 33222222222211111111110000000000
                                                                                 10987654321098765432109876543210
                                                                                 000001x1xx110000001110xxxxxxxxxx
                                                                                 sunpklo.  */
                                                                              return 1952;
                                                                            }
                                                                        }
                                                                      else
                                                                        {
                                                                          /* 33222222222211111111110000000000
                                                                             10987654321098765432109876543210
                                                                             000001x1xx1x1000001110xxxxxxxxxx
                                                                             rev.  */
                                                                          return 1805;
                                                                        }
                                                                    }
                                                                  else
                                                                    {
                                                                      if (((word >> 20) & 0x1) == 0)
                                                                        {
                                                                          /* 33222222222211111111110000000000
                                                                             10987654321098765432109876543210
                                                                             000001x1xx10x100001110xxxxxxxxxx
                                                                             insr.  */
                                                                          return 1497;
                                                                        }
                                                                      else
                                                                        {
                                                                          /* 33222222222211111111110000000000
                                                                             10987654321098765432109876543210
                                                                             000001x1xx11x100001110xxxxxxxxxx
                                                                             insr.  */
                                                                          return 1498;
                                                                        }
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x1xx1xxx10001110xxxxxxxxxx
                                                                     uunpklo.  */
                                                                  return 2015;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 17) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x1xx1xxx01001110xxxxxxxxxx
                                                                     sunpkhi.  */
                                                                  return 1951;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x1xx1xxx11001110xxxxxxxxxx
                                                                     uunpkhi.  */
                                                                  return 2014;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     000001x1xx1xxxxx001xx1xxxxxxxxxx
                                                     tbx.  */
                                                  return 2253;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 16) & 0x1) == 0)
                                                {
                                                  if (((word >> 19) & 0x1) == 0)
                                                    {
                                                      if (((word >> 20) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x1xx100xx0101xxxxxxxxxxxxx
                                                             lasta.  */
                                                          return 1499;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x1xx110xx0101xxxxxxxxxxxxx
                                                             clasta.  */
                                                          return 1314;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x1xx1x1xx0101xxxxxxxxxxxxx
                                                         cpy.  */
                                                      return 1355;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 20) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x1xx10xxx1101xxxxxxxxxxxxx
                                                         lastb.  */
                                                      return 1501;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x1xx11xxx1101xxxxxxxxxxxxx
                                                         clastb.  */
                                                      return 1317;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 15) & 0x1) == 0)
                                        {
                                          if (((word >> 10) & 0x1) == 0)
                                            {
                                              if (((word >> 11) & 0x1) == 0)
                                                {
                                                  if (((word >> 12) & 0x1) == 0)
                                                    {
                                                      if (((word >> 13) & 0x1) == 0)
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 000001x1xx10xxxx010000xxxxxxxxxx
                                                                 zip1.  */
                                                              return 2032;
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 16) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 18) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x1xx11x0x0010000xxxxxxxxxx
                                                                         punpklo.  */
                                                                      return 1798;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         000001x1xx11x1x0010000xxxxxxxxxx
                                                                         rev.  */
                                                                      return 1804;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     000001x1xx11xxx1010000xxxxxxxxxx
                                                                     punpkhi.  */
                                                                  return 1797;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x1xx1xxxxx011000xxxxxxxxxx
                                                             zip1.  */
                                                          return 2033;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 13) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x1xx1xxxxx010100xxxxxxxxxx
                                                             trn1.  */
                                                          return 1957;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x1xx1xxxxx011100xxxxxxxxxx
                                                             trn1.  */
                                                          return 1958;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 13) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x1xx1xxxxx010x10xxxxxxxxxx
                                                         uzp1.  */
                                                      return 2019;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x1xx1xxxxx011x10xxxxxxxxxx
                                                         uzp1.  */
                                                      return 2020;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 11) & 0x1) == 0)
                                                {
                                                  if (((word >> 12) & 0x1) == 0)
                                                    {
                                                      if (((word >> 13) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x1xx1xxxxx010001xxxxxxxxxx
                                                             zip2.  */
                                                          return 2034;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x1xx1xxxxx011001xxxxxxxxxx
                                                             zip2.  */
                                                          return 2035;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 13) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x1xx1xxxxx010101xxxxxxxxxx
                                                             trn2.  */
                                                          return 1959;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             000001x1xx1xxxxx011101xxxxxxxxxx
                                                             trn2.  */
                                                          return 1960;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 13) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x1xx1xxxxx010x11xxxxxxxxxx
                                                         uzp2.  */
                                                      return 2021;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         000001x1xx1xxxxx011x11xxxxxxxxxx
                                                         uzp2.  */
                                                      return 2022;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             000001x1xx1xxxxx11xxxxxxxxxxxxxx
                                             sel.  */
                                          return 1823;
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 13) & 0x1) == 0)
                                {
                                  if (((word >> 14) & 0x1) == 0)
                                    {
                                      if (((word >> 15) & 0x1) == 0)
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 100001x1x0xxxxxx000xxxxxxxxxxxxx
                                                 ldr.  */
                                              return 1727;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 100001x1x1xxxxxx000xxxxxxxxxxxxx
                                                 prfb.  */
                                              return 1771;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 100001x10xxxxxxx100xxxxxxxxxxxxx
                                                 ld1rsh.  */
                                              return 1556;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 100001x11xxxxxxx100xxxxxxxxxxxxx
                                                 ld1rsb.  */
                                              return 1553;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 15) & 0x1) == 0)
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              if (((word >> 21) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x10x0xxxxx010xxxxxxxxxxxxx
                                                     ld1w.  */
                                                  return 1591;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x10x1xxxxx010xxxxxxxxxxxxx
                                                     ld1w.  */
                                                  return 1592;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x110xxxxxx010xxxxxxxxxxxxx
                                                     ldr.  */
                                                  return 1728;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x111xxxxxx010xxxxxxxxxxxxx
                                                     prfw.  */
                                                  return 1792;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 21) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         100001x1000xxxxx110xxxxxxxxxxxxx
                                                         prfw.  */
                                                      return 1788;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         100001x1100xxxxx110xxxxxxxxxxxxx
                                                         prfd.  */
                                                      return 1774;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x1x01xxxxx110xxxxxxxxxxxxx
                                                     ld1w.  */
                                                  return 1599;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x101xxxxxx110xxxxxxxxxxxxx
                                                     ld1rw.  */
                                                  return 1559;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x111xxxxxx110xxxxxxxxxxxxx
                                                     ld1rsb.  */
                                                  return 1555;
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 14) & 0x1) == 0)
                                    {
                                      if (((word >> 15) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             100001x1xxxxxxxx001xxxxxxxxxxxxx
                                             prfh.  */
                                          return 1785;
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 100001x1x0xxxxxx101xxxxxxxxxxxxx
                                                 ldnt1w.  */
                                              return 2099;
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x101xxxxxx101xxxxxxxxxxxxx
                                                     ld1rsh.  */
                                                  return 1557;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x111xxxxxx101xxxxxxxxxxxxx
                                                     ld1rsb.  */
                                                  return 1554;
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 15) & 0x1) == 0)
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              if (((word >> 21) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x10x0xxxxx011xxxxxxxxxxxxx
                                                     ldff1w.  */
                                                  return 1691;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x10x1xxxxx011xxxxxxxxxxxxx
                                                     ldff1w.  */
                                                  return 1692;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 100001x11xxxxxxx011xxxxxxxxxxxxx
                                                 prfd.  */
                                              return 1778;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 21) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         100001x1000xxxxx111xxxxxxxxxxxxx
                                                         prfw.  */
                                                      return 1791;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         100001x1100xxxxx111xxxxxxxxxxxxx
                                                         prfd.  */
                                                      return 1777;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x1x01xxxxx111xxxxxxxxxxxxx
                                                     ldff1w.  */
                                                  return 1701;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x101xxxxxx111xxxxxxxxxxxxx
                                                     ld1rw.  */
                                                  return 1560;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     100001x111xxxxxx111xxxxxxxxxxxxx
                                                     ld1rd.  */
                                                  return 1541;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 13) & 0x1) == 0)
                            {
                              if (((word >> 14) & 0x1) == 0)
                                {
                                  if (((word >> 15) & 0x1) == 0)
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 10) & 0x1) == 0)
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx000000xxxxxxxxxx
                                                             saddlb.  */
                                                          return 2129;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx000100xxxxxxxxxx
                                                             ssublb.  */
                                                          return 2236;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx000010xxxxxxxxxx
                                                             uaddlb.  */
                                                          return 2260;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx000110xxxxxxxxxx
                                                             usublb.  */
                                                          return 2313;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx000001xxxxxxxxxx
                                                             saddlt.  */
                                                          return 2131;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx000101xxxxxxxxxx
                                                             ssublt.  */
                                                          return 2238;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx000011xxxxxxxxxx
                                                             uaddlt.  */
                                                          return 2261;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx000111xxxxxxxxxx
                                                             usublt.  */
                                                          return 2314;
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 110001x1xx0xxxxx000xxxxxxxxxxxxx
                                                 ld1sw.  */
                                              return 1585;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 10) & 0x1) == 0)
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx1xxxxx000000xxxxxxxxxx
                                                             sqshrunb.  */
                                                          return 2219;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx1xxxxx000100xxxxxxxxxx
                                                             shrnb.  */
                                                          return 2137;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx1xxxxx000010xxxxxxxxxx
                                                             sqrshrunb.  */
                                                          return 2211;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx1xxxxx000110xxxxxxxxxx
                                                             rshrnb.  */
                                                          return 2119;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx1xxxxx000001xxxxxxxxxx
                                                             sqshrunt.  */
                                                          return 2220;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx1xxxxx000101xxxxxxxxxx
                                                             shrnt.  */
                                                          return 2138;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx1xxxxx000011xxxxxxxxxx
                                                             sqrshrunt.  */
                                                          return 2212;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx1xxxxx000111xxxxxxxxxx
                                                             rshrnt.  */
                                                          return 2120;
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 110001x1xx1xxxxx000xxxxxxxxxxxxx
                                                 ld1sw.  */
                                              return 1586;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 10) & 0x1) == 0)
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx100000xxxxxxxxxx
                                                             saddlbt.  */
                                                          return 2130;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx100100xxxxxxxxxx
                                                             eorbt.  */
                                                          return 2066;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx100010xxxxxxxxxx
                                                             ssublbt.  */
                                                          return 2237;
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 22) & 0x1) == 0)
                                                            {
                                                              if (((word >> 23) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     010001x1000xxxxx100110xxxxxxxxxx
                                                                     smmla.  */
                                                                  return 2393;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     010001x1100xxxxx100110xxxxxxxxxx
                                                                     usmmla.  */
                                                                  return 2395;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x1x10xxxxx100110xxxxxxxxxx
                                                                 ummla.  */
                                                              return 2394;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         010001x1xx0xxxxx100x01xxxxxxxxxx
                                                         eortb.  */
                                                      return 2067;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         010001x1xx0xxxxx100x11xxxxxxxxxx
                                                         ssubltb.  */
                                                      return 2239;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     110001x1x00xxxxx100xxxxxxxxxxxxx
                                                     ldnt1sw.  */
                                                  return 2098;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     110001x1x10xxxxx100xxxxxxxxxxxxx
                                                     ld1sw.  */
                                                  return 1587;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 4) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     010001x1xx1xxxxx100xxxxxxxx0xxxx
                                                     match.  */
                                                  return 2101;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     010001x1xx1xxxxx100xxxxxxxx1xxxx
                                                     nmatch.  */
                                                  return 2113;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     110001x1x01xxxxx100xxxxxxxxxxxxx
                                                     ld1sw.  */
                                                  return 1590;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     110001x1x11xxxxx100xxxxxxxxxxxxx
                                                     ld1sw.  */
                                                  return 1588;
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 15) & 0x1) == 0)
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 10) & 0x1) == 0)
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx010000xxxxxxxxxx
                                                             saddwb.  */
                                                          return 2132;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx010100xxxxxxxxxx
                                                             ssubwb.  */
                                                          return 2240;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx010010xxxxxxxxxx
                                                             uaddwb.  */
                                                          return 2262;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx010110xxxxxxxxxx
                                                             usubwb.  */
                                                          return 2315;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx010001xxxxxxxxxx
                                                             saddwt.  */
                                                          return 2133;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx010101xxxxxxxxxx
                                                             ssubwt.  */
                                                          return 2241;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx010011xxxxxxxxxx
                                                             uaddwt.  */
                                                          return 2263;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx010111xxxxxxxxxx
                                                             usubwt.  */
                                                          return 2316;
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     110001x10x0xxxxx010xxxxxxxxxxxxx
                                                     ld1w.  */
                                                  return 1595;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     110001x11x0xxxxx010xxxxxxxxxxxxx
                                                     ld1d.  */
                                                  return 1517;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 10) & 0x1) == 0)
                                                    {
                                                      if (((word >> 11) & 0x1) == 0)
                                                        {
                                                          if (((word >> 12) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x10x1xxxxx010000xxxxxxxxxx
                                                                 sqxtnb.  */
                                                              return 2223;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x10x1xxxxx010100xxxxxxxxxx
                                                                 sqxtunb.  */
                                                              return 2225;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x10x1xxxxx010x10xxxxxxxxxx
                                                             uqxtnb.  */
                                                          return 2300;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 11) & 0x1) == 0)
                                                        {
                                                          if (((word >> 12) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x10x1xxxxx010001xxxxxxxxxx
                                                                 sqxtnt.  */
                                                              return 2224;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x10x1xxxxx010101xxxxxxxxxx
                                                                 sqxtunt.  */
                                                              return 2226;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x10x1xxxxx010x11xxxxxxxxxx
                                                             uqxtnt.  */
                                                          return 2301;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     110001x10x1xxxxx010xxxxxxxxxxxxx
                                                     ld1w.  */
                                                  return 1596;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x11x1xxxxx010xxxxxxxxxxxxx
                                                 ld1d.  */
                                              return 1518;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 11) & 0x1) == 0)
                                                {
                                                  if (((word >> 10) & 0x1) == 0)
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx110000xxxxxxxxxx
                                                             sabalb.  */
                                                          return 2124;
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x10x0xxxxx110100xxxxxxxxxx
                                                                 adclb.  */
                                                              return 2049;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x11x0xxxxx110100xxxxxxxxxx
                                                                 sbclb.  */
                                                              return 2134;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx110001xxxxxxxxxx
                                                             sabalt.  */
                                                          return 2125;
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x10x0xxxxx110101xxxxxxxxxx
                                                                 adclt.  */
                                                              return 2050;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x11x0xxxxx110101xxxxxxxxxx
                                                                 sbclt.  */
                                                              return 2135;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 12) & 0x1) == 0)
                                                    {
                                                      if (((word >> 10) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx110010xxxxxxxxxx
                                                             uabalb.  */
                                                          return 2255;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx110011xxxxxxxxxx
                                                             uabalt.  */
                                                          return 2256;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 16) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxx011011xxxxxxxxxxx
                                                             cadd.  */
                                                          return 2058;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxx111011xxxxxxxxxxx
                                                             sqcadd.  */
                                                          return 2166;
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         110001x1000xxxxx110xxxxxxxxxxxxx
                                                         ldnt1w.  */
                                                      return 2100;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         110001x1100xxxxx110xxxxxxxxxxxxx
                                                         ldnt1d.  */
                                                      return 2093;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         110001x1010xxxxx110xxxxxxxxxxxxx
                                                         ld1w.  */
                                                      return 1597;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         110001x1110xxxxx110xxxxxxxxxxxxx
                                                         ld1d.  */
                                                      return 1519;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x1001xxxxx110xxxxxxxxxxxxx
                                                     ld1w.  */
                                                  return 1602;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x1011xxxxx110xxxxxxxxxxxxx
                                                     ld1w.  */
                                                  return 1598;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     010001x11x1xxxxx110xxxxxxxxxxxxx
                                                     histcnt.  */
                                                  return 2089;
                                                }
                                              else
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         110001x1101xxxxx110xxxxxxxxxxxxx
                                                         ld1d.  */
                                                      return 1522;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         110001x1111xxxxx110xxxxxxxxxxxxx
                                                         ld1d.  */
                                                      return 1520;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 14) & 0x1) == 0)
                                {
                                  if (((word >> 15) & 0x1) == 0)
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 10) & 0x1) == 0)
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         010001x1xx0xxxxx001x00xxxxxxxxxx
                                                         sabdlb.  */
                                                      return 2126;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         010001x1xx0xxxxx001x10xxxxxxxxxx
                                                         uabdlb.  */
                                                      return 2257;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         010001x1xx0xxxxx001x01xxxxxxxxxx
                                                         sabdlt.  */
                                                      return 2127;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         010001x1xx0xxxxx001x11xxxxxxxxxx
                                                         uabdlt.  */
                                                      return 2258;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 110001x1xx0xxxxx001xxxxxxxxxxxxx
                                                 ldff1sw.  */
                                              return 1686;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 10) & 0x1) == 0)
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx1xxxxx001000xxxxxxxxxx
                                                             sqshrnb.  */
                                                          return 2217;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx1xxxxx001100xxxxxxxxxx
                                                             uqshrnb.  */
                                                          return 2296;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx1xxxxx001010xxxxxxxxxx
                                                             sqrshrnb.  */
                                                          return 2209;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx1xxxxx001110xxxxxxxxxx
                                                             uqrshrnb.  */
                                                          return 2291;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx1xxxxx001001xxxxxxxxxx
                                                             sqshrnt.  */
                                                          return 2218;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx1xxxxx001101xxxxxxxxxx
                                                             uqshrnt.  */
                                                          return 2297;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx1xxxxx001011xxxxxxxxxx
                                                             sqrshrnt.  */
                                                          return 2210;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx1xxxxx001111xxxxxxxxxx
                                                             uqrshrnt.  */
                                                          return 2292;
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 110001x1xx1xxxxx001xxxxxxxxxxxxx
                                                 ldff1sw.  */
                                              return 1687;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 10) & 0x1) == 0)
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx101000xxxxxxxxxx
                                                             sshllb.  */
                                                          return 2233;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx101100xxxxxxxxxx
                                                             bext.  */
                                                          return 2338;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx101010xxxxxxxxxx
                                                             ushllb.  */
                                                          return 2309;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx101110xxxxxxxxxx
                                                             bgrp.  */
                                                          return 2339;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx101001xxxxxxxxxx
                                                             sshllt.  */
                                                          return 2234;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx101101xxxxxxxxxx
                                                             bdep.  */
                                                          return 2337;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         010001x1xx0xxxxx101x11xxxxxxxxxx
                                                         ushllt.  */
                                                      return 2310;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 110001x1xx0xxxxx101xxxxxxxxxxxxx
                                                 ldff1sw.  */
                                              return 1688;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     010001x1x01xxxxx101xxxxxxxxxxxxx
                                                     histseg.  */
                                                  return 2090;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     110001x1x01xxxxx101xxxxxxxxxxxxx
                                                     ldff1sw.  */
                                                  return 1690;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x10001x1x11xxxxx101xxxxxxxxxxxxx
                                                 ldff1sw.  */
                                              return 1689;
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 15) & 0x1) == 0)
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 10) & 0x1) == 0)
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx011000xxxxxxxxxx
                                                             sqdmullb.  */
                                                          return 2187;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx011100xxxxxxxxxx
                                                             smullb.  */
                                                          return 2159;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          if (((word >> 22) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x1x00xxxxx011010xxxxxxxxxx
                                                                 pmullb.  */
                                                              return 2334;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x1x10xxxxx011010xxxxxxxxxx
                                                                 pmullb.  */
                                                              return 2115;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx011110xxxxxxxxxx
                                                             umullb.  */
                                                          return 2284;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx011001xxxxxxxxxx
                                                             sqdmullt.  */
                                                          return 2190;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx011101xxxxxxxxxx
                                                             smullt.  */
                                                          return 2162;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          if (((word >> 22) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x1x00xxxxx011011xxxxxxxxxx
                                                                 pmullt.  */
                                                              return 2335;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x1x10xxxxx011011xxxxxxxxxx
                                                                 pmullt.  */
                                                              return 2116;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx011111xxxxxxxxxx
                                                             umullt.  */
                                                          return 2287;
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     110001x10x0xxxxx011xxxxxxxxxxxxx
                                                     ldff1w.  */
                                                  return 1697;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     110001x11x0xxxxx011xxxxxxxxxxxxx
                                                     ldff1d.  */
                                                  return 1642;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 10) & 0x1) == 0)
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx1xxxxx011000xxxxxxxxxx
                                                             addhnb.  */
                                                          return 2051;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx1xxxxx011100xxxxxxxxxx
                                                             subhnb.  */
                                                          return 2249;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx1xxxxx011010xxxxxxxxxx
                                                             raddhnb.  */
                                                          return 2117;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx1xxxxx011110xxxxxxxxxx
                                                             rsubhnb.  */
                                                          return 2121;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx1xxxxx011001xxxxxxxxxx
                                                             addhnt.  */
                                                          return 2052;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx1xxxxx011101xxxxxxxxxx
                                                             subhnt.  */
                                                          return 2250;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx1xxxxx011011xxxxxxxxxx
                                                             raddhnt.  */
                                                          return 2118;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx1xxxxx011111xxxxxxxxxx
                                                             rsubhnt.  */
                                                          return 2122;
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     110001x10x1xxxxx011xxxxxxxxxxxxx
                                                     ldff1w.  */
                                                  return 1698;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     110001x11x1xxxxx011xxxxxxxxxxxxx
                                                     ldff1d.  */
                                                  return 1643;
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 10) & 0x1) == 0)
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx111000xxxxxxxxxx
                                                             ssra.  */
                                                          return 2235;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx111100xxxxxxxxxx
                                                             sri.  */
                                                          return 2228;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx111010xxxxxxxxxx
                                                             srsra.  */
                                                          return 2232;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx111110xxxxxxxxxx
                                                             saba.  */
                                                          return 2123;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx111001xxxxxxxxxx
                                                             usra.  */
                                                          return 2312;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx111101xxxxxxxxxx
                                                             sli.  */
                                                          return 2141;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx111011xxxxxxxxxx
                                                             ursra.  */
                                                          return 2308;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             010001x1xx0xxxxx111111xxxxxxxxxx
                                                             uaba.  */
                                                          return 2254;
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         110001x1000xxxxx111xxxxxxxxxxxxx
                                                         prfw.  */
                                                      return 1793;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         110001x1100xxxxx111xxxxxxxxxxxxx
                                                         prfd.  */
                                                      return 1779;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         110001x1010xxxxx111xxxxxxxxxxxxx
                                                         ldff1w.  */
                                                      return 1699;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         110001x1110xxxxx111xxxxxxxxxxxxx
                                                         ldff1d.  */
                                                      return 1644;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  if (((word >> 31) & 0x1) == 0)
                                                    {
                                                      if (((word >> 10) & 0x1) == 0)
                                                        {
                                                          if (((word >> 12) & 0x1) == 0)
                                                            {
                                                              if (((word >> 16) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 17) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         010001x1001xxx001110x0xxxxxxxxxx
                                                                         aesmc.  */
                                                                      return 2333;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         010001x1001xxx101110x0xxxxxxxxxx
                                                                         aese.  */
                                                                      return 2331;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     010001x1001xxxx11110x0xxxxxxxxxx
                                                                     sm4e.  */
                                                                  return 2328;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x1001xxxxx1111x0xxxxxxxxxx
                                                                 sm4ekey.  */
                                                              return 2329;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 12) & 0x1) == 0)
                                                            {
                                                              if (((word >> 17) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     010001x1001xxx0x1110x1xxxxxxxxxx
                                                                     aesimc.  */
                                                                  return 2332;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     010001x1001xxx1x1110x1xxxxxxxxxx
                                                                     aesd.  */
                                                                  return 2330;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 010001x1001xxxxx1111x1xxxxxxxxxx
                                                                 rax1.  */
                                                              return 2336;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         110001x1001xxxxx111xxxxxxxxxxxxx
                                                         ldff1w.  */
                                                      return 1702;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x1101xxxxx111xxxxxxxxxxxxx
                                                     ldff1d.  */
                                                  return 1646;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x1011xxxxx111xxxxxxxxxxxxx
                                                     ldff1w.  */
                                                  return 1700;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x10001x1111xxxxx111xxxxxxxxxxxxx
                                                     ldff1d.  */
                                                  return 1645;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 15) & 0x1) == 0)
                        {
                          if (((word >> 14) & 0x1) == 0)
                            {
                              if (((word >> 13) & 0x1) == 0)
                                {
                                  if (((word >> 30) & 0x1) == 0)
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 4) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x1xx0xxxxx000xxxxxxxx0xxxx
                                                     cmpge.  */
                                                  return 1325;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x1xx0xxxxx000xxxxxxxx1xxxx
                                                     cmpgt.  */
                                                  return 1328;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     101001x10x0xxxxx000xxxxxxxxxxxxx
                                                     ld1rqw.  */
                                                  return 1552;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     101001x11x0xxxxx000xxxxxxxxxxxxx
                                                     ld1rqd.  */
                                                  return 1548;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 4) & 0x1) == 0)
                                                {
                                                  if (((word >> 10) & 0x1) == 0)
                                                    {
                                                      if (((word >> 11) & 0x1) == 0)
                                                        {
                                                          if (((word >> 12) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x1xx1xxxxx000000xxxxx0xxxx
                                                                 whilege.  */
                                                              return 2317;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x1xx1xxxxx000100xxxxx0xxxx
                                                                 whilege.  */
                                                              return 2318;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 12) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x1xx1xxxxx000010xxxxx0xxxx
                                                                 whilehs.  */
                                                              return 2323;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x1xx1xxxxx000110xxxxx0xxxx
                                                                 whilehs.  */
                                                              return 2324;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 11) & 0x1) == 0)
                                                        {
                                                          if (((word >> 12) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x1xx1xxxxx000001xxxxx0xxxx
                                                                 whilelt.  */
                                                              return 2029;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x1xx1xxxxx000101xxxxx0xxxx
                                                                 whilelt.  */
                                                              return 2030;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 12) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x1xx1xxxxx000011xxxxx0xxxx
                                                                 whilelo.  */
                                                              return 2025;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x1xx1xxxxx000111xxxxx0xxxx
                                                                 whilelo.  */
                                                              return 2026;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 10) & 0x1) == 0)
                                                    {
                                                      if (((word >> 11) & 0x1) == 0)
                                                        {
                                                          if (((word >> 12) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x1xx1xxxxx000000xxxxx1xxxx
                                                                 whilegt.  */
                                                              return 2319;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x1xx1xxxxx000100xxxxx1xxxx
                                                                 whilegt.  */
                                                              return 2320;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 12) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x1xx1xxxxx000010xxxxx1xxxx
                                                                 whilehi.  */
                                                              return 2321;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x1xx1xxxxx000110xxxxx1xxxx
                                                                 whilehi.  */
                                                              return 2322;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 11) & 0x1) == 0)
                                                        {
                                                          if (((word >> 12) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x1xx1xxxxx000001xxxxx1xxxx
                                                                 whilele.  */
                                                              return 2023;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x1xx1xxxxx000101xxxxx1xxxx
                                                                 whilele.  */
                                                              return 2024;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 12) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x1xx1xxxxx000011xxxxx1xxxx
                                                                 whilels.  */
                                                              return 2027;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x1xx1xxxxx000111xxxxx1xxxx
                                                                 whilels.  */
                                                              return 2028;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     101001x10x1xxxxx000xxxxxxxxxxxxx
                                                     ld1row.  */
                                                  return 2403;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     101001x11x1xxxxx000xxxxxxxxxxxxx
                                                     ld1rod.  */
                                                  return 2404;
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 21) & 0x1) == 0)
                                            {
                                              if (((word >> 10) & 0x1) == 0)
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         011001x1xx0xxxxx000x00xxxxxxxxxx
                                                         fadd.  */
                                                      return 1383;
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             011001x1xx0xxxxx000010xxxxxxxxxx
                                                             fmul.  */
                                                          return 1450;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             011001x1xx0xxxxx000110xxxxxxxxxx
                                                             frecps.  */
                                                          return 1463;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 11) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         011001x1xx0xxxxx000x01xxxxxxxxxx
                                                         fsub.  */
                                                      return 1476;
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 12) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             011001x1xx0xxxxx000011xxxxxxxxxx
                                                             ftsmul.  */
                                                          return 1482;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             011001x1xx0xxxxx000111xxxxxxxxxx
                                                             frsqrts.  */
                                                          return 1473;
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 011001x1xx1xxxxx000xxxxxxxxxxxxx
                                                 fmla.  */
                                              return 1441;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             111001x1xxxxxxxx000xxxxxxxxxxxxx
                                             str.  */
                                          return 1944;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 4) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x1xx0xxxxx001xxxxxxxx0xxxx
                                                     cmplt.  */
                                                  return 1342;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x1xx0xxxxx001xxxxxxxx1xxxx
                                                     cmple.  */
                                                  return 1336;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     101001x10x0xxxxx001xxxxxxxxxxxxx
                                                     ld1rqw.  */
                                                  return 1551;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     101001x11x0xxxxx001xxxxxxxxxxxxx
                                                     ld1rqd.  */
                                                  return 1547;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 16) & 0x1) == 0)
                                                {
                                                  if (((word >> 17) & 0x1) == 0)
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx000000001xxxxxxxxxxxxx
                                                                     faddv.  */
                                                                  return 1387;
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 4) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         011001x1xx010000001xxxxxxxx0xxxx
                                                                         fcmge.  */
                                                                      return 1394;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         011001x1xx010000001xxxxxxxx1xxxx
                                                                         fcmgt.  */
                                                                      return 1396;
                                                                    }
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 011001x1xx0x1000001xxxxxxxxxxxxx
                                                                 fadda.  */
                                                              return 1386;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             011001x1xx0xx100001xxxxxxxxxxxxx
                                                             fmaxnmv.  */
                                                          return 1433;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             011001x1xx0xx010001xxxxxxxxxxxxx
                                                             fcmeq.  */
                                                          return 1392;
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 011001x1xx0x0110001xxxxxxxxxxxxx
                                                                 fmaxv.  */
                                                              return 1434;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 011001x1xx0x1110001xxxxxxxxxxxxx
                                                                 frecpe.  */
                                                              return 1462;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 17) & 0x1) == 0)
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          if (((word >> 4) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 011001x1xx0xx001001xxxxxxxx0xxxx
                                                                 fcmlt.  */
                                                              return 1399;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 011001x1xx0xx001001xxxxxxxx1xxxx
                                                                 fcmle.  */
                                                              return 1398;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             011001x1xx0xx101001xxxxxxxxxxxxx
                                                             fminnmv.  */
                                                          return 1439;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             011001x1xx0xx011001xxxxxxxxxxxxx
                                                             fcmne.  */
                                                          return 1400;
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 011001x1xx0x0111001xxxxxxxxxxxxx
                                                                 fminv.  */
                                                              return 1440;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 011001x1xx0x1111001xxxxxxxxxxxxx
                                                                 frsqrte.  */
                                                              return 1472;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x1000xxxxx001xxxxxxxxxxxxx
                                                         stnt1w.  */
                                                      return 2248;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x1100xxxxx001xxxxxxxxxxxxx
                                                         stnt1d.  */
                                                      return 2244;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     111001x1x10xxxxx001xxxxxxxxxxxxx
                                                     stnt1w.  */
                                                  return 2247;
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 4) & 0x1) == 0)
                                                {
                                                  if (((word >> 12) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         001001x1xx1xxxxx0010xxxxxxx0xxxx
                                                         ctermeq.  */
                                                      return 1357;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         001001x1xx1xxxxx0011xxxxxxx0xxxx
                                                         whilewr.  */
                                                      return 2326;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 12) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         001001x1xx1xxxxx0010xxxxxxx1xxxx
                                                         ctermne.  */
                                                      return 1358;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         001001x1xx1xxxxx0011xxxxxxx1xxxx
                                                         whilerw.  */
                                                      return 2325;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     101001x10x1xxxxx001xxxxxxxxxxxxx
                                                     ld1row.  */
                                                  return 2407;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     101001x11x1xxxxx001xxxxxxxxxxxxx
                                                     ld1rod.  */
                                                  return 2408;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             x11001x1xx1xxxxx001xxxxxxxxxxxxx
                                             fmls.  */
                                          return 1445;
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 22) & 0x1) == 0)
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 9) & 0x1) == 0)
                                                    {
                                                      if (((word >> 20) & 0x1) == 0)
                                                        {
                                                          if (((word >> 4) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x10000xxxx01xxxx0xxxx0xxxx
                                                                 and.  */
                                                              return 1288;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x10000xxxx01xxxx0xxxx1xxxx
                                                                 bic.  */
                                                              return 1300;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x100010xxx01xxxx0xxxxxxxxx
                                                                 brka.  */
                                                              return 1302;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x100011xxx01xxxx0xxxxxxxxx
                                                                 brkn.  */
                                                              return 1306;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 4) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             001001x1000xxxxx01xxxx1xxxx0xxxx
                                                             eor.  */
                                                          return 1375;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             001001x1000xxxxx01xxxx1xxxx1xxxx
                                                             sel.  */
                                                          return 1824;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 13) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1000xxxxx010xxxxxxxxxxxxx
                                                         ld1sh.  */
                                                      return 1574;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1000xxxxx011xxxxxxxxxxxxx
                                                         ldff1sh.  */
                                                      return 1674;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 9) & 0x1) == 0)
                                                    {
                                                      if (((word >> 20) & 0x1) == 0)
                                                        {
                                                          if (((word >> 4) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x11000xxxx01xxxx0xxxx0xxxx
                                                                 orr.  */
                                                              return 1760;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x11000xxxx01xxxx0xxxx1xxxx
                                                                 orn.  */
                                                              return 1755;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             001001x11001xxxx01xxxx0xxxxxxxxx
                                                             brkb.  */
                                                          return 1304;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 4) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             001001x1100xxxxx01xxxx1xxxx0xxxx
                                                             nor.  */
                                                          return 1752;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             001001x1100xxxxx01xxxx1xxxx1xxxx
                                                             nand.  */
                                                          return 1749;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 13) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1100xxxxx010xxxxxxxxxxxxx
                                                         ld1sb.  */
                                                      return 1562;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1100xxxxx011xxxxxxxxxxxxx
                                                         ldff1sb.  */
                                                      return 1662;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 4) & 0x1) == 0)
                                                    {
                                                      if (((word >> 9) & 0x1) == 0)
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x10100xxxx01xxxx0xxxx0xxxx
                                                                 ands.  */
                                                              return 1289;
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 19) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     001001x101010xxx01xxxx0xxxx0xxxx
                                                                     brkas.  */
                                                                  return 1303;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     001001x101011xxx01xxxx0xxxx0xxxx
                                                                     brkns.  */
                                                                  return 1307;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             001001x1010xxxxx01xxxx1xxxx0xxxx
                                                             eors.  */
                                                          return 1376;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         001001x1010xxxxx01xxxxxxxxx1xxxx
                                                         bics.  */
                                                      return 1301;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 13) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1010xxxxx010xxxxxxxxxxxxx
                                                         ld1w.  */
                                                      return 1593;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1010xxxxx011xxxxxxxxxxxxx
                                                         ldff1w.  */
                                                      return 1693;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 4) & 0x1) == 0)
                                                    {
                                                      if (((word >> 9) & 0x1) == 0)
                                                        {
                                                          if (((word >> 20) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x11100xxxx01xxxx0xxxx0xxxx
                                                                 orrs.  */
                                                              return 1761;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x11101xxxx01xxxx0xxxx0xxxx
                                                                 brkbs.  */
                                                              return 1305;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             001001x1110xxxxx01xxxx1xxxx0xxxx
                                                             nors.  */
                                                          return 1753;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 9) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             001001x1110xxxxx01xxxx0xxxx1xxxx
                                                             orns.  */
                                                          return 1756;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             001001x1110xxxxx01xxxx1xxxx1xxxx
                                                             nands.  */
                                                          return 1750;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 13) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1110xxxxx010xxxxxxxxxxxxx
                                                         ld1sb.  */
                                                      return 1564;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1110xxxxx011xxxxxxxxxxxxx
                                                         ldff1sb.  */
                                                      return 1666;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x01001x1001xxxxx010xxxxxxxxxxxxx
                                                     ld1sh.  */
                                                  return 1575;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x01001x1101xxxxx010xxxxxxxxxxxxx
                                                     ld1sb.  */
                                                  return 1563;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x01001x1011xxxxx010xxxxxxxxxxxxx
                                                     ld1w.  */
                                                  return 1594;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x01001x1111xxxxx010xxxxxxxxxxxxx
                                                     ld1d.  */
                                                  return 1516;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x01001x1001xxxxx011xxxxxxxxxxxxx
                                                     ldff1sh.  */
                                                  return 1676;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x01001x1101xxxxx011xxxxxxxxxxxxx
                                                     ldff1sb.  */
                                                  return 1664;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x01001x1011xxxxx011xxxxxxxxxxxxx
                                                     ldff1w.  */
                                                  return 1695;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     x01001x1111xxxxx011xxxxxxxxxxxxx
                                                     ldff1d.  */
                                                  return 1640;
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 21) & 0x1) == 0)
                                            {
                                              if (((word >> 4) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     011001x1xx0xxxxx010xxxxxxxx0xxxx
                                                     fcmge.  */
                                                  return 1395;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     011001x1xx0xxxxx010xxxxxxxx1xxxx
                                                     fcmgt.  */
                                                  return 1397;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 011001x1xx1xxxxx010xxxxxxxxxxxxx
                                                 fnmla.  */
                                              return 1459;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 111001x1x0xxxxxx010xxxxxxxxxxxxx
                                                 str.  */
                                              return 1945;
                                            }
                                          else
                                            {
                                              if (((word >> 21) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     111001x1x10xxxxx010xxxxxxxxxxxxx
                                                     st1w.  */
                                                  return 1904;
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x1011xxxxx010xxxxxxxxxxxxx
                                                         st1w.  */
                                                      return 1906;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x1111xxxxx010xxxxxxxxxxxxx
                                                         st1d.  */
                                                      return 1883;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 4) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     011001x1xx0xxxxx011xxxxxxxx0xxxx
                                                     fcmeq.  */
                                                  return 1393;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     011001x1xx0xxxxx011xxxxxxxx1xxxx
                                                     fcmne.  */
                                                  return 1401;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x1000xxxxx011xxxxxxxxxxxxx
                                                         stnt1w.  */
                                                      return 1942;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x1100xxxxx011xxxxxxxxxxxxx
                                                         stnt1d.  */
                                                      return 1938;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x1010xxxxx011xxxxxxxxxxxxx
                                                         st3w.  */
                                                      return 1926;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x1110xxxxx011xxxxxxxxxxxxx
                                                         st3d.  */
                                                      return 1922;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 011001x1xx1xxxxx011xxxxxxxxxxxxx
                                                 fnmls.  */
                                              return 1460;
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x1001xxxxx011xxxxxxxxxxxxx
                                                         st2w.  */
                                                      return 1918;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x1101xxxxx011xxxxxxxxxxxxx
                                                         st2d.  */
                                                      return 1914;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x1011xxxxx011xxxxxxxxxxxxx
                                                         st4w.  */
                                                      return 1934;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         111001x1111xxxxx011xxxxxxxxxxxxx
                                                         st4d.  */
                                                      return 1930;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 21) & 0x1) == 0)
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  if (((word >> 14) & 0x1) == 0)
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 4) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x01001x1xx0xxxxx100xxxxxxxx0xxxx
                                                 cmpeq.  */
                                              return 1322;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 x01001x1xx0xxxxx100xxxxxxxx1xxxx
                                                 cmpne.  */
                                              return 1345;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 20) & 0x1) == 0)
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x01001x10000xxxx101xxxxxxxxxxxxx
                                                         ld1sh.  */
                                                      return 1581;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x01001x11000xxxx101xxxxxxxxxxxxx
                                                         ld1sb.  */
                                                      return 1568;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x01001x10100xxxx101xxxxxxxxxxxxx
                                                         ld1w.  */
                                                      return 1600;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x01001x11100xxxx101xxxxxxxxxxxxx
                                                         ld1sb.  */
                                                      return 1570;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x01001x10001xxxx101xxxxxxxxxxxxx
                                                         ldnf1sh.  */
                                                      return 1714;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x01001x11001xxxx101xxxxxxxxxxxxx
                                                         ldnf1sb.  */
                                                      return 1711;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x01001x10101xxxx101xxxxxxxxxxxxx
                                                         ldnf1w.  */
                                                      return 1717;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         x01001x11101xxxx101xxxxxxxxxxxxx
                                                         ldnf1sb.  */
                                                      return 1713;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 4) & 0x1) == 0)
                                            {
                                              if (((word >> 20) & 0x1) == 0)
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         001001x1x000xxxx11xxxxxxxxx0xxxx
                                                         brkpa.  */
                                                      return 1308;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         001001x1x100xxxx11xxxxxxxxx0xxxx
                                                         brkpas.  */
                                                      return 1309;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 16) & 0x1) == 0)
                                                    {
                                                      if (((word >> 19) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             001001x1xx010xx011xxxxxxxxx0xxxx
                                                             ptest.  */
                                                          return 1794;
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 10) & 0x1) == 0)
                                                            {
                                                              if (((word >> 12) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 13) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         001001x1xx011xx01100x0xxxxx0xxxx
                                                                         pfirst.  */
                                                                      return 1764;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         001001x1xx011xx01110x0xxxxx0xxxx
                                                                         ptrue.  */
                                                                      return 1795;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 22) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         001001x1x0011xx011x1x0xxxxx0xxxx
                                                                         rdffr.  */
                                                                      return 1801;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         001001x1x1011xx011x1x0xxxxx0xxxx
                                                                         rdffrs.  */
                                                                      return 1802;
                                                                    }
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x1xx011xx011xxx1xxxxx0xxxx
                                                                 pfalse.  */
                                                              return 1763;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 10) & 0x1) == 0)
                                                        {
                                                          if (((word >> 12) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x1xx01xxx111x0x0xxxxx0xxxx
                                                                 ptrues.  */
                                                              return 1796;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 001001x1xx01xxx111x1x0xxxxx0xxxx
                                                                 rdffr.  */
                                                              return 1800;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             001001x1xx01xxx111xxx1xxxxx0xxxx
                                                             pnext.  */
                                                          return 1765;
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x1x00xxxxx11xxxxxxxxx1xxxx
                                                     brkpb.  */
                                                  return 1310;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     001001x1x10xxxxx11xxxxxxxxx1xxxx
                                                     brkpbs.  */
                                                  return 1311;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1000xxxxx110xxxxxxxxxxxxx
                                                         ldnt1w.  */
                                                      return 1725;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1100xxxxx110xxxxxxxxxxxxx
                                                         ldnt1d.  */
                                                      return 1721;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1010xxxxx110xxxxxxxxxxxxx
                                                         ld3w.  */
                                                      return 1617;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1110xxxxx110xxxxxxxxxxxxx
                                                         ld3d.  */
                                                      return 1613;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1000xxxxx111xxxxxxxxxxxxx
                                                         ldnt1w.  */
                                                      return 1726;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1100xxxxx111xxxxxxxxxxxxx
                                                         ldnt1d.  */
                                                      return 1722;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1010xxxxx111xxxxxxxxxxxxx
                                                         ld3w.  */
                                                      return 1618;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         101001x1110xxxxx111xxxxxxxxxxxxx
                                                         ld3d.  */
                                                      return 1614;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 19) & 0x1) == 0)
                                                {
                                                  if (((word >> 20) & 0x1) == 0)
                                                    {
                                                      if (((word >> 16) & 0x1) == 0)
                                                        {
                                                          if (((word >> 17) & 0x1) == 0)
                                                            {
                                                              if (((word >> 18) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx000000100xxxxxxxxxxxxx
                                                                     fadd.  */
                                                                  return 1384;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx000100100xxxxxxxxxxxxx
                                                                     fmaxnm.  */
                                                                  return 1431;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 18) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx000010100xxxxxxxxxxxxx
                                                                     fmul.  */
                                                                  return 1451;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx000110100xxxxxxxxxxxxx
                                                                     fmax.  */
                                                                  return 1429;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 17) & 0x1) == 0)
                                                            {
                                                              if (((word >> 18) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx000001100xxxxxxxxxxxxx
                                                                     fsub.  */
                                                                  return 1477;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx000101100xxxxxxxxxxxxx
                                                                     fminnm.  */
                                                                  return 1437;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 18) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx000011100xxxxxxxxxxxxx
                                                                     fsubr.  */
                                                                  return 1479;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx000111100xxxxxxxxxxxxx
                                                                     fmin.  */
                                                                  return 1435;
                                                                }
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         011001x1xx010xxx100xxxxxxxxxxxxx
                                                         ftmad.  */
                                                      return 1481;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 16) & 0x1) == 0)
                                                    {
                                                      if (((word >> 17) & 0x1) == 0)
                                                        {
                                                          if (((word >> 18) & 0x1) == 0)
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx001000100xxxxxxxxxxxxx
                                                                     fabd.  */
                                                                  return 1379;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx011000100xxxxxxxxxxxxx
                                                                     fadd.  */
                                                                  return 1385;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx001100100xxxxxxxxxxxxx
                                                                     fdivr.  */
                                                                  return 1425;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx011100100xxxxxxxxxxxxx
                                                                     fmaxnm.  */
                                                                  return 1432;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 18) & 0x1) == 0)
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx001010100xxxxxxxxxxxxx
                                                                     fmulx.  */
                                                                  return 1456;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx011010100xxxxxxxxxxxxx
                                                                     fmul.  */
                                                                  return 1452;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 011001x1xx0x1110100xxxxxxxxxxxxx
                                                                 fmax.  */
                                                              return 1430;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 17) & 0x1) == 0)
                                                        {
                                                          if (((word >> 18) & 0x1) == 0)
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx001001100xxxxxxxxxxxxx
                                                                     fscale.  */
                                                                  return 1474;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx011001100xxxxxxxxxxxxx
                                                                     fsub.  */
                                                                  return 1478;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx001101100xxxxxxxxxxxxx
                                                                     fdiv.  */
                                                                  return 1424;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx011101100xxxxxxxxxxxxx
                                                                     fminnm.  */
                                                                  return 1438;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 18) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 011001x1xx0x1011100xxxxxxxxxxxxx
                                                                 fsubr.  */
                                                              return 1480;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 011001x1xx0x1111100xxxxxxxxxxxxx
                                                                 fmin.  */
                                                              return 1436;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 4) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     011001x1xx0xxxxx110xxxxxxxx0xxxx
                                                     fcmuo.  */
                                                  return 1402;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     011001x1xx0xxxxx110xxxxxxxx1xxxx
                                                     facge.  */
                                                  return 1381;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     111001x1000xxxxx1x0xxxxxxxxxxxxx
                                                     st1w.  */
                                                  return 1900;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     111001x1100xxxxx1x0xxxxxxxxxxxxx
                                                     st1d.  */
                                                  return 1879;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 111001x1x10xxxxx1x0xxxxxxxxxxxxx
                                                 st1w.  */
                                              return 1905;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 16) & 0x1) == 0)
                                                {
                                                  if (((word >> 19) & 0x1) == 0)
                                                    {
                                                      if (((word >> 17) & 0x1) == 0)
                                                        {
                                                          if (((word >> 18) & 0x1) == 0)
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx000000101xxxxxxxxxxxxx
                                                                     frintn.  */
                                                                  return 1468;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx010000101xxxxxxxxxxxxx
                                                                     scvtf.  */
                                                                  return 1814;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx000100101xxxxxxxxxxxxx
                                                                     frinta.  */
                                                                  return 1465;
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 22) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         011001x1x0010100101xxxxxxxxxxxxx
                                                                         scvtf.  */
                                                                      return 1813;
                                                                    }
                                                                  else
                                                                    {
                                                                      if (((word >> 23) & 0x1) == 0)
                                                                        {
                                                                          /* 33222222222211111111110000000000
                                                                             10987654321098765432109876543210
                                                                             011001x101010100101xxxxxxxxxxxxx
                                                                             scvtf.  */
                                                                          return 1812;
                                                                        }
                                                                      else
                                                                        {
                                                                          /* 33222222222211111111110000000000
                                                                             10987654321098765432109876543210
                                                                             011001x111010100101xxxxxxxxxxxxx
                                                                             scvtf.  */
                                                                          return 1816;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 18) & 0x1) == 0)
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx000010101xxxxxxxxxxxxx
                                                                     frintm.  */
                                                                  return 1467;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx010010101xxxxxxxxxxxxx
                                                                     scvtf.  */
                                                                  return 1811;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx000110101xxxxxxxxxxxxx
                                                                     frintx.  */
                                                                  return 1470;
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 23) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         011001x10x010110101xxxxxxxxxxxxx
                                                                         scvtf.  */
                                                                      return 1815;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         011001x11x010110101xxxxxxxxxxxxx
                                                                         scvtf.  */
                                                                      return 1817;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 20) & 0x1) == 0)
                                                        {
                                                          if (((word >> 17) & 0x1) == 0)
                                                            {
                                                              if (((word >> 18) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 22) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         011001x1x0001000101xxxxxxxxxxxxx
                                                                         fcvt.  */
                                                                      return 1404;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         011001x1x1001000101xxxxxxxxxxxxx
                                                                         fcvt.  */
                                                                      return 1406;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx001100101xxxxxxxxxxxxx
                                                                     frecpx.  */
                                                                  return 1464;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 22) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 23) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         011001x100001x10101xxxxxxxxxxxxx
                                                                         fcvtx.  */
                                                                      return 2074;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         011001x110001x10101xxxxxxxxxxxxx
                                                                         bfcvt.  */
                                                                      return 2424;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1x1001x10101xxxxxxxxxxxxx
                                                                     fcvt.  */
                                                                  return 1408;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 22) & 0x1) == 0)
                                                            {
                                                              if (((word >> 23) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x100011xx0101xxxxxxxxxxxxx
                                                                     flogb.  */
                                                                  return 2076;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x110011xx0101xxxxxxxxxxxxx
                                                                     fcvtzs.  */
                                                                  return 1413;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 17) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 18) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         011001x1x1011000101xxxxxxxxxxxxx
                                                                         fcvtzs.  */
                                                                      return 1414;
                                                                    }
                                                                  else
                                                                    {
                                                                      if (((word >> 23) & 0x1) == 0)
                                                                        {
                                                                          /* 33222222222211111111110000000000
                                                                             10987654321098765432109876543210
                                                                             011001x101011100101xxxxxxxxxxxxx
                                                                             fcvtzs.  */
                                                                          return 1411;
                                                                        }
                                                                      else
                                                                        {
                                                                          /* 33222222222211111111110000000000
                                                                             10987654321098765432109876543210
                                                                             011001x111011100101xxxxxxxxxxxxx
                                                                             fcvtzs.  */
                                                                          return 1415;
                                                                        }
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 18) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         011001x1x1011010101xxxxxxxxxxxxx
                                                                         fcvtzs.  */
                                                                      return 1410;
                                                                    }
                                                                  else
                                                                    {
                                                                      if (((word >> 23) & 0x1) == 0)
                                                                        {
                                                                          /* 33222222222211111111110000000000
                                                                             10987654321098765432109876543210
                                                                             011001x101011110101xxxxxxxxxxxxx
                                                                             fcvtzs.  */
                                                                          return 1412;
                                                                        }
                                                                      else
                                                                        {
                                                                          /* 33222222222211111111110000000000
                                                                             10987654321098765432109876543210
                                                                             011001x111011110101xxxxxxxxxxxxx
                                                                             fcvtzs.  */
                                                                          return 1416;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 17) & 0x1) == 0)
                                                    {
                                                      if (((word >> 18) & 0x1) == 0)
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx000001101xxxxxxxxxxxxx
                                                                     frintp.  */
                                                                  return 1469;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx010001101xxxxxxxxxxxxx
                                                                     ucvtf.  */
                                                                  return 1966;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 22) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         011001x1x0001001101xxxxxxxxxxxxx
                                                                         fcvt.  */
                                                                      return 1405;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         011001x1x1001001101xxxxxxxxxxxxx
                                                                         fcvt.  */
                                                                      return 1407;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx011001101xxxxxxxxxxxxx
                                                                     fcvtzu.  */
                                                                  return 1421;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 19) & 0x1) == 0)
                                                            {
                                                              if (((word >> 22) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1x00x0101101xxxxxxxxxxxxx
                                                                     ucvtf.  */
                                                                  return 1965;
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 23) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         011001x1010x0101101xxxxxxxxxxxxx
                                                                         ucvtf.  */
                                                                      return 1964;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         011001x1110x0101101xxxxxxxxxxxxx
                                                                         ucvtf.  */
                                                                      return 1968;
                                                                    }
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 20) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     011001x1xx001101101xxxxxxxxxxxxx
                                                                     fsqrt.  */
                                                                  return 1475;
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 22) & 0x1) == 0)
  