/******************************************************************************
*******************************************************************************
**
**  Copyright (C) 2005-2007 Red Hat, Inc.  All rights reserved.
**
**  This copyrighted material is made available to anyone wishing to use,
**  modify, copy, or redistribute it subject to the terms and conditions
**  of the GNU General Public License v.2.
**
*******************************************************************************
******************************************************************************/

#include <syslog.h>
#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <stdint.h>
#include <signal.h>
#include <time.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#ifndef OPENAIS_WHITETANK
#include <openais/service/logsys.h>
#else
#include <openais/service/objdb.h>
#endif
#include "list.h"
#include "cnxman-socket.h"
#include "cnxman-private.h"
#include "logging.h"

LOGSYS_DECLARE_SUBSYS (CMAN_NAME, LOG_INFO);

int subsys_mask = 0;

void set_debuglog(int subsystems)
{
	subsys_mask = subsystems;
}

#ifdef OPENAIS_WHITETANK
void set_logger_level(struct objdb_iface_ver0 *objdb, char *ident, int level)
{
	unsigned int object_handle;
	unsigned int logger_object_handle;

	fprintf(stderr, "CC: setting logger levels\n");
	objdb->object_find_reset(OBJECT_PARENT_HANDLE);
	if (objdb->object_find(OBJECT_PARENT_HANDLE,
			       "logging", strlen("logging"),
			       &object_handle)) {

		objdb->object_create (OBJECT_PARENT_HANDLE, &object_handle,
				      "logging", strlen("logging"));
	}

	objdb->object_key_create(object_handle, "to_stderr", strlen("to_stderr"),
				 "yes", strlen("yes")+1);

	objdb->object_create (object_handle, &logger_object_handle,
			      "logger", strlen("logger"));

	objdb->object_key_create(logger_object_handle, "ident", strlen("ident"),
				 ident, strlen(ident)+1);
	objdb->object_key_create(logger_object_handle, "debug", strlen("debug"),
				 "on", strlen("on")+1);
}
#endif
