# The PEP 484 type hints stub file for the QtDataVisualization module.
#
# Generated by SIP 4.19.6
#
# Copyright (c) 2017 Riverbank Computing Limited <info@riverbankcomputing.com>
# 
# This file is part of PyQtDataVisualization.
# 
# This file may be used under the terms of the GNU General Public License
# version 3.0 as published by the Free Software Foundation and appearing in
# the file LICENSE included in the packaging of this file.  Please review the
# following information to ensure the GNU General Public License version 3.0
# requirements will be met: http://www.gnu.org/copyleft/gpl.html.
# 
# If you do not wish to use this file under the terms of the GPL version 3.0
# then you may purchase a commercial license.  For more information contact
# info@riverbankcomputing.com.
# 
# This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
# WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.


import typing
import sip

from PyQt5 import QtGui

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[typing.Callable[..., None], QtCore.pyqtBoundSignal]

# Convenient aliases for complicated OpenGL types.
PYQT_OPENGL_ARRAY = typing.Union[typing.Sequence[int], typing.Sequence[float],
        sip.Buffer, None]
PYQT_OPENGL_BOUND_ARRAY = typing.Union[typing.Sequence[int],
        typing.Sequence[float], sip.Buffer, int, None]


class QtDataVisualization(sip.simplewrapper):

    class QAbstract3DGraph(QtGui.QWindow):

        class OptimizationHint(int): ...
        OptimizationDefault = ... # type: 'QAbstract3DGraph.OptimizationHint'
        OptimizationStatic = ... # type: 'QAbstract3DGraph.OptimizationHint'

        class ElementType(int): ...
        ElementNone = ... # type: 'QAbstract3DGraph.ElementType'
        ElementSeries = ... # type: 'QAbstract3DGraph.ElementType'
        ElementAxisXLabel = ... # type: 'QAbstract3DGraph.ElementType'
        ElementAxisYLabel = ... # type: 'QAbstract3DGraph.ElementType'
        ElementAxisZLabel = ... # type: 'QAbstract3DGraph.ElementType'
        ElementCustomItem = ... # type: 'QAbstract3DGraph.ElementType'

        class ShadowQuality(int): ...
        ShadowQualityNone = ... # type: 'QAbstract3DGraph.ShadowQuality'
        ShadowQualityLow = ... # type: 'QAbstract3DGraph.ShadowQuality'
        ShadowQualityMedium = ... # type: 'QAbstract3DGraph.ShadowQuality'
        ShadowQualityHigh = ... # type: 'QAbstract3DGraph.ShadowQuality'
        ShadowQualitySoftLow = ... # type: 'QAbstract3DGraph.ShadowQuality'
        ShadowQualitySoftMedium = ... # type: 'QAbstract3DGraph.ShadowQuality'
        ShadowQualitySoftHigh = ... # type: 'QAbstract3DGraph.ShadowQuality'

        class SelectionFlag(int): ...
        SelectionNone = ... # type: 'QAbstract3DGraph.SelectionFlag'
        SelectionItem = ... # type: 'QAbstract3DGraph.SelectionFlag'
        SelectionRow = ... # type: 'QAbstract3DGraph.SelectionFlag'
        SelectionItemAndRow = ... # type: 'QAbstract3DGraph.SelectionFlag'
        SelectionColumn = ... # type: 'QAbstract3DGraph.SelectionFlag'
        SelectionItemAndColumn = ... # type: 'QAbstract3DGraph.SelectionFlag'
        SelectionRowAndColumn = ... # type: 'QAbstract3DGraph.SelectionFlag'
        SelectionItemRowAndColumn = ... # type: 'QAbstract3DGraph.SelectionFlag'
        SelectionSlice = ... # type: 'QAbstract3DGraph.SelectionFlag'
        SelectionMultiSeries = ... # type: 'QAbstract3DGraph.SelectionFlag'

        class SelectionFlags(sip.simplewrapper):

            @typing.overload
            def __init__(self) -> None: ...
            @typing.overload
            def __init__(self, f: typing.Union['QAbstract3DGraph.SelectionFlags', 'QAbstract3DGraph.SelectionFlag']) -> None: ...
            @typing.overload
            def __init__(self, a0: 'QAbstract3DGraph.SelectionFlags') -> None: ...

            def __hash__(self) -> int: ...
            def __bool__(self) -> int: ...
            def __invert__(self) -> 'QAbstract3DGraph.SelectionFlags': ...
            def __int__(self) -> int: ...

        class OptimizationHints(sip.simplewrapper):

            @typing.overload
            def __init__(self) -> None: ...
            @typing.overload
            def __init__(self, f: typing.Union['QAbstract3DGraph.OptimizationHints', 'QAbstract3DGraph.OptimizationHint']) -> None: ...
            @typing.overload
            def __init__(self, a0: 'QAbstract3DGraph.OptimizationHints') -> None: ...

            def __hash__(self) -> int: ...
            def __bool__(self) -> int: ...
            def __invert__(self) -> 'QAbstract3DGraph.OptimizationHints': ...
            def __int__(self) -> int: ...

        def hasContext(self) -> bool: ...
        def marginChanged(self, margin: float) -> None: ...
        def queriedGraphPositionChanged(self, data: QtGui.QVector3D) -> None: ...
        def localeChanged(self, locale: QtCore.QLocale) -> None: ...
        def reflectivityChanged(self, reflectivity: float) -> None: ...
        def reflectionChanged(self, enabled: bool) -> None: ...
        def horizontalAspectRatioChanged(self, ratio: float) -> None: ...
        def radialLabelOffsetChanged(self, offset: float) -> None: ...
        def polarChanged(self, enabled: bool) -> None: ...
        def margin(self) -> float: ...
        def setMargin(self, margin: float) -> None: ...
        def queriedGraphPosition(self) -> QtGui.QVector3D: ...
        def locale(self) -> QtCore.QLocale: ...
        def setLocale(self, locale: QtCore.QLocale) -> None: ...
        def reflectivity(self) -> float: ...
        def setReflectivity(self, reflectivity: float) -> None: ...
        def isReflection(self) -> bool: ...
        def setReflection(self, enable: bool) -> None: ...
        def horizontalAspectRatio(self) -> float: ...
        def setHorizontalAspectRatio(self, ratio: float) -> None: ...
        def radialLabelOffset(self) -> float: ...
        def setRadialLabelOffset(self, offset: float) -> None: ...
        def isPolar(self) -> bool: ...
        def setPolar(self, enable: bool) -> None: ...
        def customItems(self) -> typing.Any: ...
        def optimizationHintsChanged(self, hints: typing.Union['QAbstract3DGraph.OptimizationHints', 'QAbstract3DGraph.OptimizationHint']) -> None: ...
        def aspectRatioChanged(self, ratio: float) -> None: ...
        def orthoProjectionChanged(self, enabled: bool) -> None: ...
        def currentFpsChanged(self, fps: float) -> None: ...
        def measureFpsChanged(self, enabled: bool) -> None: ...
        def selectedElementChanged(self, type: 'QAbstract3DGraph.ElementType') -> None: ...
        def optimizationHints(self) -> 'QAbstract3DGraph.OptimizationHints': ...
        def setOptimizationHints(self, hints: typing.Union['QAbstract3DGraph.OptimizationHints', 'QAbstract3DGraph.OptimizationHint']) -> None: ...
        def aspectRatio(self) -> float: ...
        def setAspectRatio(self, ratio: float) -> None: ...
        def selectedElement(self) -> 'QAbstract3DGraph.ElementType': ...
        def isOrthoProjection(self) -> bool: ...
        def setOrthoProjection(self, enable: bool) -> None: ...
        def currentFps(self) -> float: ...
        def measureFps(self) -> bool: ...
        def setMeasureFps(self, enable: bool) -> None: ...
        def renderToImage(self, msaaSamples: int = ..., imageSize: QtCore.QSize = ...) -> QtGui.QImage: ...
        def selectedCustomItem(self) -> 'QCustom3DItem': ...
        def selectedCustomItemIndex(self) -> int: ...
        def selectedAxis(self) -> 'QAbstract3DAxis': ...
        def selectedLabelIndex(self) -> int: ...
        def releaseCustomItem(self, item: 'QCustom3DItem') -> None: ...
        def removeCustomItemAt(self, position: QtGui.QVector3D) -> None: ...
        def removeCustomItem(self, item: 'QCustom3DItem') -> None: ...
        def removeCustomItems(self) -> None: ...
        def addCustomItem(self, item: 'QCustom3DItem') -> int: ...
        def wheelEvent(self, event: QtGui.QWheelEvent) -> None: ...
        def mouseMoveEvent(self, event: QtGui.QMouseEvent) -> None: ...
        def mouseReleaseEvent(self, event: QtGui.QMouseEvent) -> None: ...
        def mousePressEvent(self, event: QtGui.QMouseEvent) -> None: ...
        def touchEvent(self, event: QtGui.QTouchEvent) -> None: ...
        def mouseDoubleClickEvent(self, event: QtGui.QMouseEvent) -> None: ...
        def exposeEvent(self, event: QtGui.QExposeEvent) -> None: ...
        def resizeEvent(self, event: QtGui.QResizeEvent) -> None: ...
        def event(self, event: QtCore.QEvent) -> bool: ...
        def shadowQualityChanged(self, quality: 'QAbstract3DGraph.ShadowQuality') -> None: ...
        def selectionModeChanged(self, mode: typing.Union['QAbstract3DGraph.SelectionFlags', 'QAbstract3DGraph.SelectionFlag']) -> None: ...
        def activeThemeChanged(self, theme: 'Q3DTheme') -> None: ...
        def activeInputHandlerChanged(self, inputHandler: 'QAbstract3DInputHandler') -> None: ...
        def shadowsSupported(self) -> bool: ...
        def activeInputHandler(self) -> 'QAbstract3DInputHandler': ...
        def clearSelection(self) -> None: ...
        def scene(self) -> 'Q3DScene': ...
        def shadowQuality(self) -> 'QAbstract3DGraph.ShadowQuality': ...
        def setShadowQuality(self, quality: 'QAbstract3DGraph.ShadowQuality') -> None: ...
        def selectionMode(self) -> 'QAbstract3DGraph.SelectionFlags': ...
        def setSelectionMode(self, mode: typing.Union['QAbstract3DGraph.SelectionFlags', 'QAbstract3DGraph.SelectionFlag']) -> None: ...
        def themes(self) -> typing.Any: ...
        def activeTheme(self) -> 'Q3DTheme': ...
        def setActiveTheme(self, theme: 'Q3DTheme') -> None: ...
        def releaseTheme(self, theme: 'Q3DTheme') -> None: ...
        def addTheme(self, theme: 'Q3DTheme') -> None: ...
        def inputHandlers(self) -> typing.Any: ...
        def setActiveInputHandler(self, inputHandler: 'QAbstract3DInputHandler') -> None: ...
        def releaseInputHandler(self, inputHandler: 'QAbstract3DInputHandler') -> None: ...
        def addInputHandler(self, inputHandler: 'QAbstract3DInputHandler') -> None: ...

    class Q3DBars('QAbstract3DGraph'):

        def __init__(self, format: typing.Optional[QtGui.QSurfaceFormat] = ..., parent: typing.Optional[QtGui.QWindow] = ...) -> None: ...

        def floorLevelChanged(self, level: float) -> None: ...
        def floorLevel(self) -> float: ...
        def setFloorLevel(self, level: float) -> None: ...
        def selectedSeriesChanged(self, series: 'QBar3DSeries') -> None: ...
        def primarySeriesChanged(self, series: 'QBar3DSeries') -> None: ...
        def valueAxisChanged(self, axis: 'QValue3DAxis') -> None: ...
        def columnAxisChanged(self, axis: 'QCategory3DAxis') -> None: ...
        def rowAxisChanged(self, axis: 'QCategory3DAxis') -> None: ...
        def barSpacingRelativeChanged(self, relative: bool) -> None: ...
        def barSpacingChanged(self, spacing: QtCore.QSizeF) -> None: ...
        def barThicknessChanged(self, thicknessRatio: float) -> None: ...
        def multiSeriesUniformChanged(self, uniform: bool) -> None: ...
        def selectedSeries(self) -> 'QBar3DSeries': ...
        def axes(self) -> typing.Any: ...
        def releaseAxis(self, axis: 'QAbstract3DAxis') -> None: ...
        def addAxis(self, axis: 'QAbstract3DAxis') -> None: ...
        def valueAxis(self) -> 'QValue3DAxis': ...
        def setValueAxis(self, axis: 'QValue3DAxis') -> None: ...
        def columnAxis(self) -> 'QCategory3DAxis': ...
        def setColumnAxis(self, axis: 'QCategory3DAxis') -> None: ...
        def rowAxis(self) -> 'QCategory3DAxis': ...
        def setRowAxis(self, axis: 'QCategory3DAxis') -> None: ...
        def isBarSpacingRelative(self) -> bool: ...
        def setBarSpacingRelative(self, relative: bool) -> None: ...
        def barSpacing(self) -> QtCore.QSizeF: ...
        def setBarSpacing(self, spacing: QtCore.QSizeF) -> None: ...
        def barThickness(self) -> float: ...
        def setBarThickness(self, thicknessRatio: float) -> None: ...
        def isMultiSeriesUniform(self) -> bool: ...
        def setMultiSeriesUniform(self, uniform: bool) -> None: ...
        def seriesList(self) -> typing.Any: ...
        def insertSeries(self, index: int, series: 'QBar3DSeries') -> None: ...
        def removeSeries(self, series: 'QBar3DSeries') -> None: ...
        def addSeries(self, series: 'QBar3DSeries') -> None: ...
        def primarySeries(self) -> 'QBar3DSeries': ...
        def setPrimarySeries(self, series: 'QBar3DSeries') -> None: ...

    class Q3DObject(QtCore.QObject):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def isDirty(self) -> bool: ...
        def setDirty(self, dirty: bool) -> None: ...
        def positionChanged(self, position: QtGui.QVector3D) -> None: ...
        def setPosition(self, position: QtGui.QVector3D) -> None: ...
        def position(self) -> QtGui.QVector3D: ...
        def parentScene(self) -> 'Q3DScene': ...
        def copyValuesFrom(self, source: 'Q3DObject') -> None: ...

    class Q3DCamera('Q3DObject'):

        class CameraPreset(int): ...
        CameraPresetNone = ... # type: 'Q3DCamera.CameraPreset'
        CameraPresetFrontLow = ... # type: 'Q3DCamera.CameraPreset'
        CameraPresetFront = ... # type: 'Q3DCamera.CameraPreset'
        CameraPresetFrontHigh = ... # type: 'Q3DCamera.CameraPreset'
        CameraPresetLeftLow = ... # type: 'Q3DCamera.CameraPreset'
        CameraPresetLeft = ... # type: 'Q3DCamera.CameraPreset'
        CameraPresetLeftHigh = ... # type: 'Q3DCamera.CameraPreset'
        CameraPresetRightLow = ... # type: 'Q3DCamera.CameraPreset'
        CameraPresetRight = ... # type: 'Q3DCamera.CameraPreset'
        CameraPresetRightHigh = ... # type: 'Q3DCamera.CameraPreset'
        CameraPresetBehindLow = ... # type: 'Q3DCamera.CameraPreset'
        CameraPresetBehind = ... # type: 'Q3DCamera.CameraPreset'
        CameraPresetBehindHigh = ... # type: 'Q3DCamera.CameraPreset'
        CameraPresetIsometricLeft = ... # type: 'Q3DCamera.CameraPreset'
        CameraPresetIsometricLeftHigh = ... # type: 'Q3DCamera.CameraPreset'
        CameraPresetIsometricRight = ... # type: 'Q3DCamera.CameraPreset'
        CameraPresetIsometricRightHigh = ... # type: 'Q3DCamera.CameraPreset'
        CameraPresetDirectlyAbove = ... # type: 'Q3DCamera.CameraPreset'
        CameraPresetDirectlyAboveCW45 = ... # type: 'Q3DCamera.CameraPreset'
        CameraPresetDirectlyAboveCCW45 = ... # type: 'Q3DCamera.CameraPreset'
        CameraPresetFrontBelow = ... # type: 'Q3DCamera.CameraPreset'
        CameraPresetLeftBelow = ... # type: 'Q3DCamera.CameraPreset'
        CameraPresetRightBelow = ... # type: 'Q3DCamera.CameraPreset'
        CameraPresetBehindBelow = ... # type: 'Q3DCamera.CameraPreset'
        CameraPresetDirectlyBelow = ... # type: 'Q3DCamera.CameraPreset'

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def targetChanged(self, target: QtGui.QVector3D) -> None: ...
        def maxZoomLevelChanged(self, zoomLevel: float) -> None: ...
        def minZoomLevelChanged(self, zoomLevel: float) -> None: ...
        def setTarget(self, target: QtGui.QVector3D) -> None: ...
        def target(self) -> QtGui.QVector3D: ...
        def setMaxZoomLevel(self, zoomLevel: float) -> None: ...
        def maxZoomLevel(self) -> float: ...
        def setMinZoomLevel(self, zoomLevel: float) -> None: ...
        def minZoomLevel(self) -> float: ...
        def wrapYRotationChanged(self, isEnabled: bool) -> None: ...
        def wrapXRotationChanged(self, isEnabled: bool) -> None: ...
        def cameraPresetChanged(self, preset: 'Q3DCamera.CameraPreset') -> None: ...
        def zoomLevelChanged(self, zoomLevel: float) -> None: ...
        def yRotationChanged(self, rotation: float) -> None: ...
        def xRotationChanged(self, rotation: float) -> None: ...
        def setZoomLevel(self, zoomLevel: float) -> None: ...
        def zoomLevel(self) -> float: ...
        def setCameraPosition(self, horizontal: float, vertical: float, zoom: float = ...) -> None: ...
        def setCameraPreset(self, preset: 'Q3DCamera.CameraPreset') -> None: ...
        def cameraPreset(self) -> 'Q3DCamera.CameraPreset': ...
        def copyValuesFrom(self, source: 'Q3DObject') -> None: ...
        def setWrapYRotation(self, isEnabled: bool) -> None: ...
        def wrapYRotation(self) -> bool: ...
        def setWrapXRotation(self, isEnabled: bool) -> None: ...
        def wrapXRotation(self) -> bool: ...
        def setYRotation(self, rotation: float) -> None: ...
        def yRotation(self) -> float: ...
        def setXRotation(self, rotation: float) -> None: ...
        def xRotation(self) -> float: ...

    class QAbstract3DInputHandler(QtCore.QObject):

        class InputView(int): ...
        InputViewNone = ... # type: 'QAbstract3DInputHandler.InputView'
        InputViewOnPrimary = ... # type: 'QAbstract3DInputHandler.InputView'
        InputViewOnSecondary = ... # type: 'QAbstract3DInputHandler.InputView'

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def previousInputPos(self) -> QtCore.QPoint: ...
        def setPreviousInputPos(self, position: QtCore.QPoint) -> None: ...
        def prevDistance(self) -> int: ...
        def setPrevDistance(self, distance: int) -> None: ...
        def sceneChanged(self, scene: 'Q3DScene') -> None: ...
        def inputViewChanged(self, view: 'QAbstract3DInputHandler.InputView') -> None: ...
        def positionChanged(self, position: QtCore.QPoint) -> None: ...
        def setScene(self, scene: 'Q3DScene') -> None: ...
        def scene(self) -> 'Q3DScene': ...
        def setInputPosition(self, position: QtCore.QPoint) -> None: ...
        def inputPosition(self) -> QtCore.QPoint: ...
        def setInputView(self, inputView: 'QAbstract3DInputHandler.InputView') -> None: ...
        def inputView(self) -> 'QAbstract3DInputHandler.InputView': ...
        def wheelEvent(self, event: QtGui.QWheelEvent) -> None: ...
        def mouseMoveEvent(self, event: QtGui.QMouseEvent, mousePos: QtCore.QPoint) -> None: ...
        def mouseReleaseEvent(self, event: QtGui.QMouseEvent, mousePos: QtCore.QPoint) -> None: ...
        def mousePressEvent(self, event: QtGui.QMouseEvent, mousePos: QtCore.QPoint) -> None: ...
        def touchEvent(self, event: QtGui.QTouchEvent) -> None: ...
        def mouseDoubleClickEvent(self, event: QtGui.QMouseEvent) -> None: ...

    class Q3DInputHandler('QAbstract3DInputHandler'):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def zoomAtTargetEnabledChanged(self, enable: bool) -> None: ...
        def selectionEnabledChanged(self, enable: bool) -> None: ...
        def zoomEnabledChanged(self, enable: bool) -> None: ...
        def rotationEnabledChanged(self, enable: bool) -> None: ...
        def isZoomAtTargetEnabled(self) -> bool: ...
        def setZoomAtTargetEnabled(self, enable: bool) -> None: ...
        def isSelectionEnabled(self) -> bool: ...
        def setSelectionEnabled(self, enable: bool) -> None: ...
        def isZoomEnabled(self) -> bool: ...
        def setZoomEnabled(self, enable: bool) -> None: ...
        def isRotationEnabled(self) -> bool: ...
        def setRotationEnabled(self, enable: bool) -> None: ...
        def wheelEvent(self, event: QtGui.QWheelEvent) -> None: ...
        def mouseMoveEvent(self, event: QtGui.QMouseEvent, mousePos: QtCore.QPoint) -> None: ...
        def mouseReleaseEvent(self, event: QtGui.QMouseEvent, mousePos: QtCore.QPoint) -> None: ...
        def mousePressEvent(self, event: QtGui.QMouseEvent, mousePos: QtCore.QPoint) -> None: ...

    class Q3DLight('Q3DObject'):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def autoPositionChanged(self, autoPosition: bool) -> None: ...
        def isAutoPosition(self) -> bool: ...
        def setAutoPosition(self, enabled: bool) -> None: ...

    class Q3DScatter('QAbstract3DGraph'):

        def __init__(self, format: typing.Optional[QtGui.QSurfaceFormat] = ..., parent: typing.Optional[QtGui.QWindow] = ...) -> None: ...

        def selectedSeriesChanged(self, series: 'QScatter3DSeries') -> None: ...
        def axisZChanged(self, axis: 'QValue3DAxis') -> None: ...
        def axisYChanged(self, axis: 'QValue3DAxis') -> None: ...
        def axisXChanged(self, axis: 'QValue3DAxis') -> None: ...
        def selectedSeries(self) -> 'QScatter3DSeries': ...
        def axes(self) -> typing.Any: ...
        def releaseAxis(self, axis: 'QValue3DAxis') -> None: ...
        def addAxis(self, axis: 'QValue3DAxis') -> None: ...
        def axisZ(self) -> 'QValue3DAxis': ...
        def setAxisZ(self, axis: 'QValue3DAxis') -> None: ...
        def axisY(self) -> 'QValue3DAxis': ...
        def setAxisY(self, axis: 'QValue3DAxis') -> None: ...
        def axisX(self) -> 'QValue3DAxis': ...
        def setAxisX(self, axis: 'QValue3DAxis') -> None: ...
        def seriesList(self) -> typing.Any: ...
        def removeSeries(self, series: 'QScatter3DSeries') -> None: ...
        def addSeries(self, series: 'QScatter3DSeries') -> None: ...

    class Q3DScene(QtCore.QObject):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def graphPositionQueryChanged(self, position: QtCore.QPoint) -> None: ...
        def graphPositionQuery(self) -> QtCore.QPoint: ...
        def setGraphPositionQuery(self, point: QtCore.QPoint) -> None: ...
        def selectionQueryPositionChanged(self, position: QtCore.QPoint) -> None: ...
        def devicePixelRatioChanged(self, pixelRatio: float) -> None: ...
        def activeLightChanged(self, light: 'Q3DLight') -> None: ...
        def activeCameraChanged(self, camera: 'Q3DCamera') -> None: ...
        def slicingActiveChanged(self, isSlicingActive: bool) -> None: ...
        def secondarySubviewOnTopChanged(self, isSecondaryOnTop: bool) -> None: ...
        def secondarySubViewportChanged(self, subViewport: QtCore.QRect) -> None: ...
        def primarySubViewportChanged(self, subViewport: QtCore.QRect) -> None: ...
        def viewportChanged(self, viewport: QtCore.QRect) -> None: ...
        def setDevicePixelRatio(self, pixelRatio: float) -> None: ...
        def devicePixelRatio(self) -> float: ...
        def setActiveLight(self, light: 'Q3DLight') -> None: ...
        def activeLight(self) -> 'Q3DLight': ...
        def setActiveCamera(self, camera: 'Q3DCamera') -> None: ...
        def activeCamera(self) -> 'Q3DCamera': ...
        def isSecondarySubviewOnTop(self) -> bool: ...
        def setSecondarySubviewOnTop(self, isSecondaryOnTop: bool) -> None: ...
        def isSlicingActive(self) -> bool: ...
        def setSlicingActive(self, isSlicing: bool) -> None: ...
        @staticmethod
        def invalidSelectionPoint() -> QtCore.QPoint: ...
        def selectionQueryPosition(self) -> QtCore.QPoint: ...
        def setSelectionQueryPosition(self, point: QtCore.QPoint) -> None: ...
        def isPointInSecondarySubView(self, point: QtCore.QPoint) -> bool: ...
        def setSecondarySubViewport(self, secondarySubViewport: QtCore.QRect) -> None: ...
        def secondarySubViewport(self) -> QtCore.QRect: ...
        def isPointInPrimarySubView(self, point: QtCore.QPoint) -> bool: ...
        def setPrimarySubViewport(self, primarySubViewport: QtCore.QRect) -> None: ...
        def primarySubViewport(self) -> QtCore.QRect: ...
        def viewport(self) -> QtCore.QRect: ...

    class Q3DSurface('QAbstract3DGraph'):

        def __init__(self, format: typing.Optional[QtGui.QSurfaceFormat] = ..., parent: typing.Optional[QtGui.QWindow] = ...) -> None: ...

        def flipHorizontalGridChanged(self, flip: bool) -> None: ...
        def flipHorizontalGrid(self) -> bool: ...
        def setFlipHorizontalGrid(self, flip: bool) -> None: ...
        def selectedSeriesChanged(self, series: 'QSurface3DSeries') -> None: ...
        def axisZChanged(self, axis: 'QValue3DAxis') -> None: ...
        def axisYChanged(self, axis: 'QValue3DAxis') -> None: ...
        def axisXChanged(self, axis: 'QValue3DAxis') -> None: ...
        def selectedSeries(self) -> 'QSurface3DSeries': ...
        def axes(self) -> typing.List['QValue3DAxis']: ...
        def releaseAxis(self, axis: 'QValue3DAxis') -> None: ...
        def addAxis(self, axis: 'QValue3DAxis') -> None: ...
        def axisZ(self) -> 'QValue3DAxis': ...
        def setAxisZ(self, axis: 'QValue3DAxis') -> None: ...
        def axisY(self) -> 'QValue3DAxis': ...
        def setAxisY(self, axis: 'QValue3DAxis') -> None: ...
        def axisX(self) -> 'QValue3DAxis': ...
        def setAxisX(self, axis: 'QValue3DAxis') -> None: ...
        def seriesList(self) -> typing.Any: ...
        def removeSeries(self, series: 'QSurface3DSeries') -> None: ...
        def addSeries(self, series: 'QSurface3DSeries') -> None: ...

    class Q3DTheme(QtCore.QObject):

        class Theme(int): ...
        ThemeQt = ... # type: 'Q3DTheme.Theme'
        ThemePrimaryColors = ... # type: 'Q3DTheme.Theme'
        ThemeDigia = ... # type: 'Q3DTheme.Theme'
        ThemeStoneMoss = ... # type: 'Q3DTheme.Theme'
        ThemeArmyBlue = ... # type: 'Q3DTheme.Theme'
        ThemeRetro = ... # type: 'Q3DTheme.Theme'
        ThemeEbony = ... # type: 'Q3DTheme.Theme'
        ThemeIsabelle = ... # type: 'Q3DTheme.Theme'
        ThemeUserDefined = ... # type: 'Q3DTheme.Theme'

        class ColorStyle(int): ...
        ColorStyleUniform = ... # type: 'Q3DTheme.ColorStyle'
        ColorStyleObjectGradient = ... # type: 'Q3DTheme.ColorStyle'
        ColorStyleRangeGradient = ... # type: 'Q3DTheme.ColorStyle'

        @typing.overload
        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
        @typing.overload
        def __init__(self, themeType: 'Q3DTheme.Theme', parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def colorStyleChanged(self, style: 'Q3DTheme.ColorStyle') -> None: ...
        def labelBackgroundEnabledChanged(self, enabled: bool) -> None: ...
        def gridEnabledChanged(self, enabled: bool) -> None: ...
        def backgroundEnabledChanged(self, enabled: bool) -> None: ...
        def fontChanged(self, font: QtGui.QFont) -> None: ...
        def labelBorderEnabledChanged(self, enabled: bool) -> None: ...
        def highlightLightStrengthChanged(self, strength: float) -> None: ...
        def ambientLightStrengthChanged(self, strength: float) -> None: ...
        def lightStrengthChanged(self, strength: float) -> None: ...
        def multiHighlightGradientChanged(self, gradient: QtGui.QLinearGradient) -> None: ...
        def singleHighlightGradientChanged(self, gradient: QtGui.QLinearGradient) -> None: ...
        def baseGradientsChanged(self, gradients: typing.Iterable[QtGui.QLinearGradient]) -> None: ...
        def lightColorChanged(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
        def multiHighlightColorChanged(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
        def singleHighlightColorChanged(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
        def gridLineColorChanged(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
        def labelBackgroundColorChanged(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
        def labelTextColorChanged(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
        def windowColorChanged(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
        def backgroundColorChanged(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
        def baseColorsChanged(self, colors: typing.Iterable[typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]]) -> None: ...
        def typeChanged(self, themeType: 'Q3DTheme.Theme') -> None: ...
        def colorStyle(self) -> 'Q3DTheme.ColorStyle': ...
        def setColorStyle(self, style: 'Q3DTheme.ColorStyle') -> None: ...
        def isLabelBackgroundEnabled(self) -> bool: ...
        def setLabelBackgroundEnabled(self, enabled: bool) -> None: ...
        def isGridEnabled(self) -> bool: ...
        def setGridEnabled(self, enabled: bool) -> None: ...
        def isBackgroundEnabled(self) -> bool: ...
        def setBackgroundEnabled(self, enabled: bool) -> None: ...
        def font(self) -> QtGui.QFont: ...
        def setFont(self, font: QtGui.QFont) -> None: ...
        def isLabelBorderEnabled(self) -> bool: ...
        def setLabelBorderEnabled(self, enabled: bool) -> None: ...
        def highlightLightStrength(self) -> float: ...
        def setHighlightLightStrength(self, strength: float) -> None: ...
        def ambientLightStrength(self) -> float: ...
        def setAmbientLightStrength(self, strength: float) -> None: ...
        def lightStrength(self) -> float: ...
        def setLightStrength(self, strength: float) -> None: ...
        def multiHighlightGradient(self) -> QtGui.QLinearGradient: ...
        def setMultiHighlightGradient(self, gradient: QtGui.QLinearGradient) -> None: ...
        def singleHighlightGradient(self) -> QtGui.QLinearGradient: ...
        def setSingleHighlightGradient(self, gradient: QtGui.QLinearGradient) -> None: ...
        def baseGradients(self) -> typing.List[QtGui.QLinearGradient]: ...
        def setBaseGradients(self, gradients: typing.Any) -> None: ...
        def lightColor(self) -> QtGui.QColor: ...
        def setLightColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
        def multiHighlightColor(self) -> QtGui.QColor: ...
        def setMultiHighlightColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
        def singleHighlightColor(self) -> QtGui.QColor: ...
        def setSingleHighlightColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
        def gridLineColor(self) -> QtGui.QColor: ...
        def setGridLineColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
        def labelBackgroundColor(self) -> QtGui.QColor: ...
        def setLabelBackgroundColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
        def labelTextColor(self) -> QtGui.QColor: ...
        def setLabelTextColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
        def windowColor(self) -> QtGui.QColor: ...
        def setWindowColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
        def backgroundColor(self) -> QtGui.QColor: ...
        def setBackgroundColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
        def baseColors(self) -> typing.List[QtGui.QColor]: ...
        def setBaseColors(self, colors: typing.Any) -> None: ...
        def type(self) -> 'Q3DTheme.Theme': ...
        def setType(self, themeType: 'Q3DTheme.Theme') -> None: ...

    class QAbstract3DAxis(QtCore.QObject):

        class AxisType(int): ...
        AxisTypeNone = ... # type: 'QAbstract3DAxis.AxisType'
        AxisTypeCategory = ... # type: 'QAbstract3DAxis.AxisType'
        AxisTypeValue = ... # type: 'QAbstract3DAxis.AxisType'

        class AxisOrientation(int): ...
        AxisOrientationNone = ... # type: 'QAbstract3DAxis.AxisOrientation'
        AxisOrientationX = ... # type: 'QAbstract3DAxis.AxisOrientation'
        AxisOrientationY = ... # type: 'QAbstract3DAxis.AxisOrientation'
        AxisOrientationZ = ... # type: 'QAbstract3DAxis.AxisOrientation'

        def titleFixedChanged(self, fixed: bool) -> None: ...
        def titleVisibilityChanged(self, visible: bool) -> None: ...
        def labelAutoRotationChanged(self, angle: float) -> None: ...
        def isTitleFixed(self) -> bool: ...
        def setTitleFixed(self, fixed: bool) -> None: ...
        def isTitleVisible(self) -> bool: ...
        def setTitleVisible(self, visible: bool) -> None: ...
        def labelAutoRotation(self) -> float: ...
        def setLabelAutoRotation(self, angle: float) -> None: ...
        def autoAdjustRangeChanged(self, autoAdjust: bool) -> None: ...
        def rangeChanged(self, min: float, max: float) -> None: ...
        def maxChanged(self, value: float) -> None: ...
        def minChanged(self, value: float) -> None: ...
        def orientationChanged(self, orientation: 'QAbstract3DAxis.AxisOrientation') -> None: ...
        def labelsChanged(self) -> None: ...
        def titleChanged(self, newTitle: str) -> None: ...
        def setTitle(self, title: str) -> None: ...
        def setRange(self, min: float, max: float) -> None: ...
        def isAutoAdjustRange(self) -> bool: ...
        def setAutoAdjustRange(self, autoAdjust: bool) -> None: ...
        def max(self) -> float: ...
        def setMax(self, max: float) -> None: ...
        def min(self) -> float: ...
        def setMin(self, min: float) -> None: ...
        def type(self) -> 'QAbstract3DAxis.AxisType': ...
        def orientation(self) -> 'QAbstract3DAxis.AxisOrientation': ...
        def labels(self) -> typing.List[str]: ...
        def setLabels(self, labels: typing.Iterable[str]) -> None: ...
        def title(self) -> str: ...

    class QAbstract3DSeries(QtCore.QObject):

        class Mesh(int): ...
        MeshUserDefined = ... # type: 'QAbstract3DSeries.Mesh'
        MeshBar = ... # type: 'QAbstract3DSeries.Mesh'
        MeshCube = ... # type: 'QAbstract3DSeries.Mesh'
        MeshPyramid = ... # type: 'QAbstract3DSeries.Mesh'
        MeshCone = ... # type: 'QAbstract3DSeries.Mesh'
        MeshCylinder = ... # type: 'QAbstract3DSeries.Mesh'
        MeshBevelBar = ... # type: 'QAbstract3DSeries.Mesh'
        MeshBevelCube = ... # type: 'QAbstract3DSeries.Mesh'
        MeshSphere = ... # type: 'QAbstract3DSeries.Mesh'
        MeshMinimal = ... # type: 'QAbstract3DSeries.Mesh'
        MeshArrow = ... # type: 'QAbstract3DSeries.Mesh'
        MeshPoint = ... # type: 'QAbstract3DSeries.Mesh'

        class SeriesType(int): ...
        SeriesTypeNone = ... # type: 'QAbstract3DSeries.SeriesType'
        SeriesTypeBar = ... # type: 'QAbstract3DSeries.SeriesType'
        SeriesTypeScatter = ... # type: 'QAbstract3DSeries.SeriesType'
        SeriesTypeSurface = ... # type: 'QAbstract3DSeries.SeriesType'

        def itemLabelVisibilityChanged(self, visible: bool) -> None: ...
        def itemLabelChanged(self, label: str) -> None: ...
        def isItemLabelVisible(self) -> bool: ...
        def setItemLabelVisible(self, visible: bool) -> None: ...
        def itemLabel(self) -> str: ...
        def nameChanged(self, name: str) -> None: ...
        def multiHighlightGradientChanged(self, gradient: QtGui.QLinearGradient) -> None: ...
        def multiHighlightColorChanged(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
        def singleHighlightGradientChanged(self, gradient: QtGui.QLinearGradient) -> None: ...
        def singleHighlightColorChanged(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
        def baseGradientChanged(self, gradient: QtGui.QLinearGradient) -> None: ...
        def baseColorChanged(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
        def colorStyleChanged(self, style: 'Q3DTheme.ColorStyle') -> None: ...
        def userDefinedMeshChanged(self, fileName: str) -> None: ...
        def meshRotationChanged(self, rotation: QtGui.QQuaternion) -> None: ...
        def meshSmoothChanged(self, enabled: bool) -> None: ...
        def meshChanged(self, mesh: 'QAbstract3DSeries.Mesh') -> None: ...
        def visibilityChanged(self, visible: bool) -> None: ...
        def itemLabelFormatChanged(self, format: str) -> None: ...
        def setMeshAxisAndAngle(self, axis: QtGui.QVector3D, angle: float) -> None: ...
        def name(self) -> str: ...
        def setName(self, name: str) -> None: ...
        def multiHighlightGradient(self) -> QtGui.QLinearGradient: ...
        def setMultiHighlightGradient(self, gradient: QtGui.QLinearGradient) -> None: ...
        def multiHighlightColor(self) -> QtGui.QColor: ...
        def setMultiHighlightColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
        def singleHighlightGradient(self) -> QtGui.QLinearGradient: ...
        def setSingleHighlightGradient(self, gradient: QtGui.QLinearGradient) -> None: ...
        def singleHighlightColor(self) -> QtGui.QColor: ...
        def setSingleHighlightColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
        def baseGradient(self) -> QtGui.QLinearGradient: ...
        def setBaseGradient(self, gradient: QtGui.QLinearGradient) -> None: ...
        def baseColor(self) -> QtGui.QColor: ...
        def setBaseColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
        def colorStyle(self) -> 'Q3DTheme.ColorStyle': ...
        def setColorStyle(self, style: 'Q3DTheme.ColorStyle') -> None: ...
        def userDefinedMesh(self) -> str: ...
        def setUserDefinedMesh(self, fileName: str) -> None: ...
        def meshRotation(self) -> QtGui.QQuaternion: ...
        def setMeshRotation(self, rotation: QtGui.QQuaternion) -> None: ...
        def isMeshSmooth(self) -> bool: ...
        def setMeshSmooth(self, enable: bool) -> None: ...
        def mesh(self) -> 'QAbstract3DSeries.Mesh': ...
        def setMesh(self, mesh: 'QAbstract3DSeries.Mesh') -> None: ...
        def isVisible(self) -> bool: ...
        def setVisible(self, visible: bool) -> None: ...
        def itemLabelFormat(self) -> str: ...
        def setItemLabelFormat(self, format: str) -> None: ...
        def type(self) -> 'QAbstract3DSeries.SeriesType': ...

    class QAbstractDataProxy(QtCore.QObject):

        class DataType(int): ...
        DataTypeNone = ... # type: 'QAbstractDataProxy.DataType'
        DataTypeBar = ... # type: 'QAbstractDataProxy.DataType'
        DataTypeScatter = ... # type: 'QAbstractDataProxy.DataType'
        DataTypeSurface = ... # type: 'QAbstractDataProxy.DataType'

        def type(self) -> 'QAbstractDataProxy.DataType': ...

    class QBar3DSeries('QAbstract3DSeries'):

        @typing.overload
        def __init__(self, dataProxy: 'QBarDataProxy', parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
        @typing.overload
        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def meshAngleChanged(self, angle: float) -> None: ...
        def selectedBarChanged(self, position: QtCore.QPoint) -> None: ...
        def dataProxyChanged(self, proxy: 'QBarDataProxy') -> None: ...
        def meshAngle(self) -> float: ...
        def setMeshAngle(self, angle: float) -> None: ...
        @staticmethod
        def invalidSelectionPosition() -> QtCore.QPoint: ...
        def selectedBar(self) -> QtCore.QPoint: ...
        def setSelectedBar(self, position: QtCore.QPoint) -> None: ...
        def dataProxy(self) -> 'QBarDataProxy': ...
        def setDataProxy(self, proxy: 'QBarDataProxy') -> None: ...

    class QBarDataItem(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, value: float) -> None: ...
        @typing.overload
        def __init__(self, value: float, angle: float) -> None: ...
        @typing.overload
        def __init__(self, other: 'QBarDataItem') -> None: ...

        def rotation(self) -> float: ...
        def setRotation(self, angle: float) -> None: ...
        def value(self) -> float: ...
        def setValue(self, value: float) -> None: ...

    class QBarDataProxy('QAbstractDataProxy'):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def seriesChanged(self, series: 'QBar3DSeries') -> None: ...
        def columnLabelsChanged(self) -> None: ...
        def rowLabelsChanged(self) -> None: ...
        def rowCountChanged(self, count: int) -> None: ...
        def itemChanged(self, rowIndex: int, columnIndex: int) -> None: ...
        def rowsInserted(self, startIndex: int, count: int) -> None: ...
        def rowsRemoved(self, startIndex: int, count: int) -> None: ...
        def rowsChanged(self, startIndex: int, count: int) -> None: ...
        def rowsAdded(self, startIndex: int, count: int) -> None: ...
        def arrayReset(self) -> None: ...
        def series(self) -> 'QBar3DSeries': ...
        def removeRows(self, rowIndex: int, removeCount: int, removeLabels: bool = ...) -> None: ...
        @typing.overload
        def insertRows(self, rowIndex: int, rows: typing.Any) -> None: ...
        @typing.overload
        def insertRows(self, rowIndex: int, rows: typing.Any, labels: typing.Iterable[str]) -> None: ...
        @typing.overload
        def insertRow(self, rowIndex: int, row: typing.Any) -> None: ...
        @typing.overload
        def insertRow(self, rowIndex: int, row: typing.Any, label: str) -> None: ...
        @typing.overload
        def addRows(self, rows: typing.Any) -> int: ...
        @typing.overload
        def addRows(self, rows: typing.Any, labels: typing.Iterable[str]) -> int: ...
        @typing.overload
        def addRow(self, row: typing.Any) -> int: ...
        @typing.overload
        def addRow(self, row: typing.Any, label: str) -> int: ...
        @typing.overload
        def setItem(self, rowIndex: int, columnIndex: int, item: 'QBarDataItem') -> None: ...
        @typing.overload
        def setItem(self, position: QtCore.QPoint, item: 'QBarDataItem') -> None: ...
        @typing.overload
        def setRows(self, rowIndex: int, rows: typing.Any) -> None: ...
        @typing.overload
        def setRows(self, rowIndex: int, rows: typing.Any, labels: typing.Iterable[str]) -> None: ...
        @typing.overload
        def setRow(self, rowIndex: int, row: typing.Any) -> None: ...
        @typing.overload
        def setRow(self, rowIndex: int, row: typing.Any, label: str) -> None: ...
        @typing.overload
        def resetArray(self) -> None: ...
        @typing.overload
        def resetArray(self, newArray: typing.Any) -> None: ...
        @typing.overload
        def resetArray(self, newArray: typing.Any, rowLabels: typing.Iterable[str], columnLabels: typing.Iterable[str]) -> None: ...
        @typing.overload
        def itemAt(self, rowIndex: int, columnIndex: int) -> 'QBarDataItem': ...
        @typing.overload
        def itemAt(self, position: QtCore.QPoint) -> 'QBarDataItem': ...
        def rowAt(self, rowIndex: int) -> typing.Any: ...
        def array(self) -> typing.Any: ...
        def setColumnLabels(self, labels: typing.Iterable[str]) -> None: ...
        def columnLabels(self) -> typing.List[str]: ...
        def setRowLabels(self, labels: typing.Iterable[str]) -> None: ...
        def rowLabels(self) -> typing.List[str]: ...
        def rowCount(self) -> int: ...

    class QCategory3DAxis('QAbstract3DAxis'):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def labelsChanged(self) -> None: ...
        def labels(self) -> typing.List[str]: ...
        def setLabels(self, labels: typing.Iterable[str]) -> None: ...

    class QCustom3DItem(QtCore.QObject):

        @typing.overload
        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
        @typing.overload
        def __init__(self, meshFile: str, position: QtGui.QVector3D, scaling: QtGui.QVector3D, rotation: QtGui.QQuaternion, texture: QtGui.QImage, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def scalingAbsoluteChanged(self, scalingAbsolute: bool) -> None: ...
        def isScalingAbsolute(self) -> bool: ...
        def setScalingAbsolute(self, scalingAbsolute: bool) -> None: ...
        def shadowCastingChanged(self, shadowCasting: bool) -> None: ...
        def visibleChanged(self, visible: bool) -> None: ...
        def rotationChanged(self, rotation: QtGui.QQuaternion) -> None: ...
        def scalingChanged(self, scaling: QtGui.QVector3D) -> None: ...
        def positionAbsoluteChanged(self, positionAbsolute: bool) -> None: ...
        def positionChanged(self, position: QtGui.QVector3D) -> None: ...
        def textureFileChanged(self, textureFile: str) -> None: ...
        def meshFileChanged(self, meshFile: str) -> None: ...
        def setTextureImage(self, textureImage: QtGui.QImage) -> None: ...
        def setRotationAxisAndAngle(self, axis: QtGui.QVector3D, angle: float) -> None: ...
        def isShadowCasting(self) -> bool: ...
        def setShadowCasting(self, enabled: bool) -> None: ...
        def isVisible(self) -> bool: ...
        def setVisible(self, visible: bool) -> None: ...
        def rotation(self) -> QtGui.QQuaternion: ...
        def setRotation(self, rotation: QtGui.QQuaternion) -> None: ...
        def scaling(self) -> QtGui.QVector3D: ...
        def setScaling(self, scaling: QtGui.QVector3D) -> None: ...
        def isPositionAbsolute(self) -> bool: ...
        def setPositionAbsolute(self, positionAbsolute: bool) -> None: ...
        def position(self) -> QtGui.QVector3D: ...
        def setPosition(self, position: QtGui.QVector3D) -> None: ...
        def textureFile(self) -> str: ...
        def setTextureFile(self, textureFile: str) -> None: ...
        def meshFile(self) -> str: ...
        def setMeshFile(self, meshFile: str) -> None: ...

    class QCustom3DLabel('QCustom3DItem'):

        @typing.overload
        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
        @typing.overload
        def __init__(self, text: str, font: QtGui.QFont, position: QtGui.QVector3D, scaling: QtGui.QVector3D, rotation: QtGui.QQuaternion, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def facingCameraChanged(self, enabled: bool) -> None: ...
        def backgroundEnabledChanged(self, enabled: bool) -> None: ...
        def borderEnabledChanged(self, enabled: bool) -> None: ...
        def backgroundColorChanged(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
        def textColorChanged(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
        def fontChanged(self, font: QtGui.QFont) -> None: ...
        def textChanged(self, text: str) -> None: ...
        def isFacingCamera(self) -> bool: ...
        def setFacingCamera(self, enabled: bool) -> None: ...
        def isBackgroundEnabled(self) -> bool: ...
        def setBackgroundEnabled(self, enabled: bool) -> None: ...
        def isBorderEnabled(self) -> bool: ...
        def setBorderEnabled(self, enabled: bool) -> None: ...
        def backgroundColor(self) -> QtGui.QColor: ...
        def setBackgroundColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
        def textColor(self) -> QtGui.QColor: ...
        def setTextColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
        def font(self) -> QtGui.QFont: ...
        def setFont(self, font: QtGui.QFont) -> None: ...
        def text(self) -> str: ...
        def setText(self, text: str) -> None: ...

    class QCustom3DVolume('QCustom3DItem'):

        @typing.overload
        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
        @typing.overload
        def __init__(self, position: QtGui.QVector3D, scaling: QtGui.QVector3D, rotation: QtGui.QQuaternion, textureWidth: int, textureHeight: int, textureDepth: int, textureData: sip.array, textureFormat: QtGui.QImage.Format, colorTable: typing.Iterable[int], parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def sliceFrameThicknessesChanged(self, values: QtGui.QVector3D) -> None: ...
        def sliceFrameGapsChanged(self, values: QtGui.QVector3D) -> None: ...
        def sliceFrameWidthsChanged(self, values: QtGui.QVector3D) -> None: ...
        def sliceFrameColorChanged(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
        def drawSliceFramesChanged(self, enabled: bool) -> None: ...
        def drawSlicesChanged(self, enabled: bool) -> None: ...
        def useHighDefShaderChanged(self, enabled: bool) -> None: ...
        def preserveOpacityChanged(self, enabled: bool) -> None: ...
        def alphaMultiplierChanged(self, mult: float) -> None: ...
        def textureFormatChanged(self, format: QtGui.QImage.Format) -> None: ...
        def textureDataChanged(self, data: sip.array) -> None: ...
        def colorTableChanged(self) -> None: ...
        def sliceIndexZChanged(self, value: int) -> None: ...
        def sliceIndexYChanged(self, value: int) -> None: ...
        def sliceIndexXChanged(self, value: int) -> None: ...
        def textureDepthChanged(self, value: int) -> None: ...
        def textureHeightChanged(self, value: int) -> None: ...
        def textureWidthChanged(self, value: int) -> None: ...
        def renderSlice(self, axis: QtCore.Qt.Axis, index: int) -> QtGui.QImage: ...
        def sliceFrameThicknesses(self) -> QtGui.QVector3D: ...
        def setSliceFrameThicknesses(self, values: QtGui.QVector3D) -> None: ...
        def sliceFrameGaps(self) -> QtGui.QVector3D: ...
        def setSliceFrameGaps(self, values: QtGui.QVector3D) -> None: ...
        def sliceFrameWidths(self) -> QtGui.QVector3D: ...
        def setSliceFrameWidths(self, values: QtGui.QVector3D) -> None: ...
        def sliceFrameColor(self) -> QtGui.QColor: ...
        def setSliceFrameColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
        def drawSliceFrames(self) -> bool: ...
        def setDrawSliceFrames(self, enable: bool) -> None: ...
        def drawSlices(self) -> bool: ...
        def setDrawSlices(self, enable: bool) -> None: ...
        def useHighDefShader(self) -> bool: ...
        def setUseHighDefShader(self, enable: bool) -> None: ...
        def preserveOpacity(self) -> bool: ...
        def setPreserveOpacity(self, enable: bool) -> None: ...
        def alphaMultiplier(self) -> float: ...
        def setAlphaMultiplier(self, mult: float) -> None: ...
        def textureFormat(self) -> QtGui.QImage.Format: ...
        def setTextureFormat(self, format: QtGui.QImage.Format) -> None: ...
        @typing.overload
        def setSubTextureData(self, axis: QtCore.Qt.Axis, index: int, data: sip.voidptr) -> None: ...
        @typing.overload
        def setSubTextureData(self, axis: QtCore.Qt.Axis, index: int, image: QtGui.QImage) -> None: ...
        def textureData(self) -> sip.array: ...
        def createTextureData(self, images: typing.Iterable[QtGui.QImage]) -> sip.array: ...
        def setTextureData(self, data: sip.array) -> None: ...
        def colorTable(self) -> typing.List[int]: ...
        def setColorTable(self, colors: typing.Iterable[int]) -> None: ...
        def setSliceIndices(self, x: int, y: int, z: int) -> None: ...
        def sliceIndexZ(self) -> int: ...
        def setSliceIndexZ(self, value: int) -> None: ...
        def sliceIndexY(self) -> int: ...
        def setSliceIndexY(self, value: int) -> None: ...
        def sliceIndexX(self) -> int: ...
        def setSliceIndexX(self, value: int) -> None: ...
        def textureDataWidth(self) -> int: ...
        def setTextureDimensions(self, width: int, height: int, depth: int) -> None: ...
        def textureDepth(self) -> int: ...
        def setTextureDepth(self, value: int) -> None: ...
        def textureHeight(self) -> int: ...
        def setTextureHeight(self, value: int) -> None: ...
        def textureWidth(self) -> int: ...
        def setTextureWidth(self, value: int) -> None: ...

    class QSurfaceDataProxy('QAbstractDataProxy'):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def seriesChanged(self, series: 'QSurface3DSeries') -> None: ...
        def columnCountChanged(self, count: int) -> None: ...
        def rowCountChanged(self, count: int) -> None: ...
        def itemChanged(self, rowIndex: int, columnIndex: int) -> None: ...
        def rowsInserted(self, startIndex: int, count: int) -> None: ...
        def rowsRemoved(self, startIndex: int, count: int) -> None: ...
        def rowsChanged(self, startIndex: int, count: int) -> None: ...
        def rowsAdded(self, startIndex: int, count: int) -> None: ...
        def arrayReset(self) -> None: ...
        @typing.overload
        def itemAt(self, rowIndex: int, columnIndex: int) -> 'QSurfaceDataItem': ...
        @typing.overload
        def itemAt(self, position: QtCore.QPoint) -> 'QSurfaceDataItem': ...
        def series(self) -> 'QSurface3DSeries': ...
        def removeRows(self, rowIndex: int, removeCount: int) -> None: ...
        def insertRows(self, rowIndex: int, rows: typing.Any) -> None: ...
        def insertRow(self, rowIndex: int, row: typing.Any) -> None: ...
        def addRows(self, rows: typing.Any) -> int: ...
        def addRow(self, row: typing.Any) -> int: ...
        @typing.overload
        def setItem(self, rowIndex: int, columnIndex: int, item: 'QSurfaceDataItem') -> None: ...
        @typing.overload
        def setItem(self, position: QtCore.QPoint, item: 'QSurfaceDataItem') -> None: ...
        def setRows(self, rowIndex: int, rows: typing.Any) -> None: ...
        def setRow(self, rowIndex: int, row: typing.Any) -> None: ...
        def resetArray(self, newArray: typing.Any) -> None: ...
        def array(self) -> typing.Any: ...
        def columnCount(self) -> int: ...
        def rowCount(self) -> int: ...

    class QHeightMapSurfaceDataProxy('QSurfaceDataProxy'):

        @typing.overload
        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
        @typing.overload
        def __init__(self, image: QtGui.QImage, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
        @typing.overload
        def __init__(self, filename: str, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def maxZValueChanged(self, value: float) -> None: ...
        def minZValueChanged(self, value: float) -> None: ...
        def maxXValueChanged(self, value: float) -> None: ...
        def minXValueChanged(self, value: float) -> None: ...
        def heightMapFileChanged(self, filename: str) -> None: ...
        def heightMapChanged(self, image: QtGui.QImage) -> None: ...
        def maxZValue(self) -> float: ...
        def setMaxZValue(self, max: float) -> None: ...
        def minZValue(self) -> float: ...
        def setMinZValue(self, min: float) -> None: ...
        def maxXValue(self) -> float: ...
        def setMaxXValue(self, max: float) -> None: ...
        def minXValue(self) -> float: ...
        def setMinXValue(self, min: float) -> None: ...
        def setValueRanges(self, minX: float, maxX: float, minZ: float, maxZ: float) -> None: ...
        def heightMapFile(self) -> str: ...
        def setHeightMapFile(self, filename: str) -> None: ...
        def heightMap(self) -> QtGui.QImage: ...
        def setHeightMap(self, image: QtGui.QImage) -> None: ...

    class QItemModelBarDataProxy('QBarDataProxy'):

        class MultiMatchBehavior(int): ...
        MMBFirst = ... # type: 'QItemModelBarDataProxy.MultiMatchBehavior'
        MMBLast = ... # type: 'QItemModelBarDataProxy.MultiMatchBehavior'
        MMBAverage = ... # type: 'QItemModelBarDataProxy.MultiMatchBehavior'
        MMBCumulative = ... # type: 'QItemModelBarDataProxy.MultiMatchBehavior'

        @typing.overload
        def __init__(self, itemModel: QtCore.QAbstractItemModel, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
        @typing.overload
        def __init__(self, itemModel: QtCore.QAbstractItemModel, valueRole: str, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
        @typing.overload
        def __init__(self, itemModel: QtCore.QAbstractItemModel, rowRole: str, columnRole: str, valueRole: str, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
        @typing.overload
        def __init__(self, itemModel: QtCore.QAbstractItemModel, rowRole: str, columnRole: str, valueRole: str, rotationRole: str, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
        @typing.overload
        def __init__(self, itemModel: QtCore.QAbstractItemModel, rowRole: str, columnRole: str, valueRole: str, rowCategories: typing.Iterable[str], columnCategories: typing.Iterable[str], parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
        @typing.overload
        def __init__(self, itemModel: QtCore.QAbstractItemModel, rowRole: str, columnRole: str, valueRole: str, rotationRole: str, rowCategories: typing.Iterable[str], columnCategories: typing.Iterable[str], parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
        @typing.overload
        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def multiMatchBehaviorChanged(self, behavior: 'QItemModelBarDataProxy.MultiMatchBehavior') -> None: ...
        def rotationRoleReplaceChanged(self, replace: str) -> None: ...
        def valueRoleReplaceChanged(self, replace: str) -> None: ...
        def columnRoleReplaceChanged(self, replace: str) -> None: ...
        def rowRoleReplaceChanged(self, replace: str) -> None: ...
        def rotationRolePatternChanged(self, pattern: QtCore.QRegExp) -> None: ...
        def valueRolePatternChanged(self, pattern: QtCore.QRegExp) -> None: ...
        def columnRolePatternChanged(self, pattern: QtCore.QRegExp) -> None: ...
        def rowRolePatternChanged(self, pattern: QtCore.QRegExp) -> None: ...
        def multiMatchBehavior(self) -> 'QItemModelBarDataProxy.MultiMatchBehavior': ...
        def setMultiMatchBehavior(self, behavior: 'QItemModelBarDataProxy.MultiMatchBehavior') -> None: ...
        def rotationRoleReplace(self) -> str: ...
        def setRotationRoleReplace(self, replace: str) -> None: ...
        def valueRoleReplace(self) -> str: ...
        def setValueRoleReplace(self, replace: str) -> None: ...
        def columnRoleReplace(self) -> str: ...
        def setColumnRoleReplace(self, replace: str) -> None: ...
        def rowRoleReplace(self) -> str: ...
        def setRowRoleReplace(self, replace: str) -> None: ...
        def rotationRolePattern(self) -> QtCore.QRegExp: ...
        def setRotationRolePattern(self, pattern: QtCore.QRegExp) -> None: ...
        def valueRolePattern(self) -> QtCore.QRegExp: ...
        def setValueRolePattern(self, pattern: QtCore.QRegExp) -> None: ...
        def columnRolePattern(self) -> QtCore.QRegExp: ...
        def setColumnRolePattern(self, pattern: QtCore.QRegExp) -> None: ...
        def rowRolePattern(self) -> QtCore.QRegExp: ...
        def setRowRolePattern(self, pattern: QtCore.QRegExp) -> None: ...
        def autoColumnCategoriesChanged(self, enable: bool) -> None: ...
        def autoRowCategoriesChanged(self, enable: bool) -> None: ...
        def useModelCategoriesChanged(self, enable: bool) -> None: ...
        def columnCategoriesChanged(self) -> None: ...
        def rowCategoriesChanged(self) -> None: ...
        def rotationRoleChanged(self, role: str) -> None: ...
        def valueRoleChanged(self, role: str) -> None: ...
        def columnRoleChanged(self, role: str) -> None: ...
        def rowRoleChanged(self, role: str) -> None: ...
        def itemModelChanged(self, itemModel: QtCore.QAbstractItemModel) -> None: ...
        def remap(self, rowRole: str, columnRole: str, valueRole: str, rotationRole: str, rowCategories: typing.Iterable[str], columnCategories: typing.Iterable[str]) -> None: ...
        def rotationRole(self) -> str: ...
        def setRotationRole(self, role: str) -> None: ...
        def columnCategoryIndex(self, category: str) -> int: ...
        def rowCategoryIndex(self, category: str) -> int: ...
        def autoColumnCategories(self) -> bool: ...
        def setAutoColumnCategories(self, enable: bool) -> None: ...
        def autoRowCategories(self) -> bool: ...
        def setAutoRowCategories(self, enable: bool) -> None: ...
        def useModelCategories(self) -> bool: ...
        def setUseModelCategories(self, enable: bool) -> None: ...
        def columnCategories(self) -> typing.List[str]: ...
        def setColumnCategories(self, categories: typing.Iterable[str]) -> None: ...
        def rowCategories(self) -> typing.List[str]: ...
        def setRowCategories(self, categories: typing.Iterable[str]) -> None: ...
        def valueRole(self) -> str: ...
        def setValueRole(self, role: str) -> None: ...
        def columnRole(self) -> str: ...
        def setColumnRole(self, role: str) -> None: ...
        def rowRole(self) -> str: ...
        def setRowRole(self, role: str) -> None: ...
        def itemModel(self) -> QtCore.QAbstractItemModel: ...
        def setItemModel(self, itemModel: QtCore.QAbstractItemModel) -> None: ...

    class QScatterDataProxy('QAbstractDataProxy'):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def seriesChanged(self, series: 'QScatter3DSeries') -> None: ...
        def itemCountChanged(self, count: int) -> None: ...
        def itemsInserted(self, startIndex: int, count: int) -> None: ...
        def itemsRemoved(self, startIndex: int, count: int) -> None: ...
        def itemsChanged(self, startIndex: int, count: int) -> None: ...
        def itemsAdded(self, startIndex: int, count: int) -> None: ...
        def arrayReset(self) -> None: ...
        def series(self) -> 'QScatter3DSeries': ...
        def removeItems(self, index: int, removeCount: int) -> None: ...
        def insertItems(self, index: int, items: typing.Any) -> None: ...
        def insertItem(self, index: int, item: 'QScatterDataItem') -> None: ...
        def addItems(self, items: typing.Any) -> int: ...
        def addItem(self, item: 'QScatterDataItem') -> int: ...
        def setItems(self, index: int, items: typing.Any) -> None: ...
        def setItem(self, index: int, item: 'QScatterDataItem') -> None: ...
        def resetArray(self, newArray: typing.Any) -> None: ...
        def itemAt(self, index: int) -> 'QScatterDataItem': ...
        def array(self) -> typing.Any: ...
        def itemCount(self) -> int: ...

    class QItemModelScatterDataProxy('QScatterDataProxy'):

        @typing.overload
        def __init__(self, itemModel: QtCore.QAbstractItemModel, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
        @typing.overload
        def __init__(self, itemModel: QtCore.QAbstractItemModel, xPosRole: str, yPosRole: str, zPosRole: str, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
        @typing.overload
        def __init__(self, itemModel: QtCore.QAbstractItemModel, xPosRole: str, yPosRole: str, zPosRole: str, rotationRole: str, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
        @typing.overload
        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def zPosRoleReplaceChanged(self, replace: str) -> None: ...
        def yPosRoleReplaceChanged(self, replace: str) -> None: ...
        def xPosRoleReplaceChanged(self, replace: str) -> None: ...
        def rotationRoleReplaceChanged(self, replace: str) -> None: ...
        def rotationRolePatternChanged(self, pattern: QtCore.QRegExp) -> None: ...
        def zPosRolePatternChanged(self, pattern: QtCore.QRegExp) -> None: ...
        def yPosRolePatternChanged(self, pattern: QtCore.QRegExp) -> None: ...
        def xPosRolePatternChanged(self, pattern: QtCore.QRegExp) -> None: ...
        def rotationRoleReplace(self) -> str: ...
        def setRotationRoleReplace(self, replace: str) -> None: ...
        def zPosRoleReplace(self) -> str: ...
        def setZPosRoleReplace(self, replace: str) -> None: ...
        def yPosRoleReplace(self) -> str: ...
        def setYPosRoleReplace(self, replace: str) -> None: ...
        def xPosRoleReplace(self) -> str: ...
        def setXPosRoleReplace(self, replace: str) -> None: ...
        def rotationRolePattern(self) -> QtCore.QRegExp: ...
        def setRotationRolePattern(self, pattern: QtCore.QRegExp) -> None: ...
        def zPosRolePattern(self) -> QtCore.QRegExp: ...
        def setZPosRolePattern(self, pattern: QtCore.QRegExp) -> None: ...
        def yPosRolePattern(self) -> QtCore.QRegExp: ...
        def setYPosRolePattern(self, pattern: QtCore.QRegExp) -> None: ...
        def xPosRolePattern(self) -> QtCore.QRegExp: ...
        def setXPosRolePattern(self, pattern: QtCore.QRegExp) -> None: ...
        def rotationRoleChanged(self, role: str) -> None: ...
        def zPosRoleChanged(self, role: str) -> None: ...
        def yPosRoleChanged(self, role: str) -> None: ...
        def xPosRoleChanged(self, role: str) -> None: ...
        def itemModelChanged(self, itemModel: QtCore.QAbstractItemModel) -> None: ...
        def remap(self, xPosRole: str, yPosRole: str, zPosRole: str, rotationRole: str) -> None: ...
        def rotationRole(self) -> str: ...
        def setRotationRole(self, role: str) -> None: ...
        def zPosRole(self) -> str: ...
        def setZPosRole(self, role: str) -> None: ...
        def yPosRole(self) -> str: ...
        def setYPosRole(self, role: str) -> None: ...
        def xPosRole(self) -> str: ...
        def setXPosRole(self, role: str) -> None: ...
        def itemModel(self) -> QtCore.QAbstractItemModel: ...
        def setItemModel(self, itemModel: QtCore.QAbstractItemModel) -> None: ...

    class QItemModelSurfaceDataProxy('QSurfaceDataProxy'):

        class MultiMatchBehavior(int): ...
        MMBFirst = ... # type: 'QItemModelSurfaceDataProxy.MultiMatchBehavior'
        MMBLast = ... # type: 'QItemModelSurfaceDataProxy.MultiMatchBehavior'
        MMBAverage = ... # type: 'QItemModelSurfaceDataProxy.MultiMatchBehavior'
        MMBCumulativeY = ... # type: 'QItemModelSurfaceDataProxy.MultiMatchBehavior'

        @typing.overload
        def __init__(self, itemModel: QtCore.QAbstractItemModel, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
        @typing.overload
        def __init__(self, itemModel: QtCore.QAbstractItemModel, yPosRole: str, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
        @typing.overload
        def __init__(self, itemModel: QtCore.QAbstractItemModel, rowRole: str, columnRole: str, yPosRole: str, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
        @typing.overload
        def __init__(self, itemModel: QtCore.QAbstractItemModel, rowRole: str, columnRole: str, yPosRole: str, rowCategories: typing.Iterable[str], columnCategories: typing.Iterable[str], parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
        @typing.overload
        def __init__(self, itemModel: QtCore.QAbstractItemModel, rowRole: str, columnRole: str, xPosRole: str, yPosRole: str, zPosRole: str, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
        @typing.overload
        def __init__(self, itemModel: QtCore.QAbstractItemModel, rowRole: str, columnRole: str, xPosRole: str, yPosRole: str, zPosRole: str, rowCategories: typing.Iterable[str], columnCategories: typing.Iterable[str], parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
        @typing.overload
        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def multiMatchBehaviorChanged(self, behavior: 'QItemModelSurfaceDataProxy.MultiMatchBehavior') -> None: ...
        def zPosRoleReplaceChanged(self, replace: str) -> None: ...
        def yPosRoleReplaceChanged(self, replace: str) -> None: ...
        def xPosRoleReplaceChanged(self, replace: str) -> None: ...
        def columnRoleReplaceChanged(self, replace: str) -> None: ...
        def rowRoleReplaceChanged(self, replace: str) -> None: ...
        def zPosRolePatternChanged(self, pattern: QtCore.QRegExp) -> None: ...
        def yPosRolePatternChanged(self, pattern: QtCore.QRegExp) -> None: ...
        def xPosRolePatternChanged(self, pattern: QtCore.QRegExp) -> None: ...
        def columnRolePatternChanged(self, pattern: QtCore.QRegExp) -> None: ...
        def rowRolePatternChanged(self, pattern: QtCore.QRegExp) -> None: ...
        def multiMatchBehavior(self) -> 'QItemModelSurfaceDataProxy.MultiMatchBehavior': ...
        def setMultiMatchBehavior(self, behavior: 'QItemModelSurfaceDataProxy.MultiMatchBehavior') -> None: ...
        def zPosRoleReplace(self) -> str: ...
        def setZPosRoleReplace(self, replace: str) -> None: ...
        def yPosRoleReplace(self) -> str: ...
        def setYPosRoleReplace(self, replace: str) -> None: ...
        def xPosRoleReplace(self) -> str: ...
        def setXPosRoleReplace(self, replace: str) -> None: ...
        def columnRoleReplace(self) -> str: ...
        def setColumnRoleReplace(self, replace: str) -> None: ...
        def rowRoleReplace(self) -> str: ...
        def setRowRoleReplace(self, replace: str) -> None: ...
        def zPosRolePattern(self) -> QtCore.QRegExp: ...
        def setZPosRolePattern(self, pattern: QtCore.QRegExp) -> None: ...
        def yPosRolePattern(self) -> QtCore.QRegExp: ...
        def setYPosRolePattern(self, pattern: QtCore.QRegExp) -> None: ...
        def xPosRolePattern(self) -> QtCore.QRegExp: ...
        def setXPosRolePattern(self, pattern: QtCore.QRegExp) -> None: ...
        def columnRolePattern(self) -> QtCore.QRegExp: ...
        def setColumnRolePattern(self, pattern: QtCore.QRegExp) -> None: ...
        def rowRolePattern(self) -> QtCore.QRegExp: ...
        def setRowRolePattern(self, pattern: QtCore.QRegExp) -> None: ...
        def autoColumnCategoriesChanged(self, enable: bool) -> None: ...
        def autoRowCategoriesChanged(self, enable: bool) -> None: ...
        def useModelCategoriesChanged(self, enable: bool) -> None: ...
        def columnCategoriesChanged(self) -> None: ...
        def rowCategoriesChanged(self) -> None: ...
        def zPosRoleChanged(self, role: str) -> None: ...
        def yPosRoleChanged(self, role: str) -> None: ...
        def xPosRoleChanged(self, role: str) -> None: ...
        def columnRoleChanged(self, role: str) -> None: ...
        def rowRoleChanged(self, role: str) -> None: ...
        def itemModelChanged(self, itemModel: QtCore.QAbstractItemModel) -> None: ...
        def remap(self, rowRole: str, columnRole: str, xPosRole: str, yPosRole: str, zPosRole: str, rowCategories: typing.Iterable[str], columnCategories: typing.Iterable[str]) -> None: ...
        def zPosRole(self) -> str: ...
        def setZPosRole(self, role: str) -> None: ...
        def yPosRole(self) -> str: ...
        def setYPosRole(self, role: str) -> None: ...
        def xPosRole(self) -> str: ...
        def setXPosRole(self, role: str) -> None: ...
        def columnCategoryIndex(self, category: str) -> int: ...
        def rowCategoryIndex(self, category: str) -> int: ...
        def autoColumnCategories(self) -> bool: ...
        def setAutoColumnCategories(self, enable: bool) -> None: ...
        def autoRowCategories(self) -> bool: ...
        def setAutoRowCategories(self, enable: bool) -> None: ...
        def useModelCategories(self) -> bool: ...
        def setUseModelCategories(self, enable: bool) -> None: ...
        def columnCategories(self) -> typing.List[str]: ...
        def setColumnCategories(self, categories: typing.Iterable[str]) -> None: ...
        def rowCategories(self) -> typing.List[str]: ...
        def setRowCategories(self, categories: typing.Iterable[str]) -> None: ...
        def columnRole(self) -> str: ...
        def setColumnRole(self, role: str) -> None: ...
        def rowRole(self) -> str: ...
        def setRowRole(self, role: str) -> None: ...
        def itemModel(self) -> QtCore.QAbstractItemModel: ...
        def setItemModel(self, itemModel: QtCore.QAbstractItemModel) -> None: ...

    class QValue3DAxisFormatter(QtCore.QObject):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def locale(self) -> QtCore.QLocale: ...
        def setLocale(self, locale: QtCore.QLocale) -> None: ...
        def labelStrings(self) -> typing.List[str]: ...
        def labelPositions(self) -> typing.List[float]: ...
        def subGridPositions(self) -> typing.List[float]: ...
        def gridPositions(self) -> typing.List[float]: ...
        def axis(self) -> 'QValue3DAxis': ...
        def markDirty(self, labelsChange: bool = ...) -> None: ...
        def populateCopy(self, copy: 'QValue3DAxisFormatter') -> None: ...
        def valueAt(self, position: float) -> float: ...
        def positionAt(self, value: float) -> float: ...
        def stringForValue(self, value: float, format: str) -> str: ...
        def recalculate(self) -> None: ...
        def createNewInstance(self) -> 'QValue3DAxisFormatter': ...
        def allowZero(self) -> bool: ...
        def setAllowZero(self, allow: bool) -> None: ...
        def allowNegatives(self) -> bool: ...
        def setAllowNegatives(self, allow: bool) -> None: ...

    class QLogValue3DAxisFormatter('QValue3DAxisFormatter'):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def populateCopy(self, copy: 'QValue3DAxisFormatter') -> None: ...
        def valueAt(self, position: float) -> float: ...
        def positionAt(self, value: float) -> float: ...
        def recalculate(self) -> None: ...
        def createNewInstance(self) -> 'QValue3DAxisFormatter': ...
        def showEdgeLabelsChanged(self, enabled: bool) -> None: ...
        def autoSubGridChanged(self, enabled: bool) -> None: ...
        def baseChanged(self, base: float) -> None: ...
        def showEdgeLabels(self) -> bool: ...
        def setShowEdgeLabels(self, enabled: bool) -> None: ...
        def autoSubGrid(self) -> bool: ...
        def setAutoSubGrid(self, enabled: bool) -> None: ...
        def base(self) -> float: ...
        def setBase(self, base: float) -> None: ...

    class QScatter3DSeries('QAbstract3DSeries'):

        @typing.overload
        def __init__(self, dataProxy: 'QScatterDataProxy', parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
        @typing.overload
        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def itemSizeChanged(self, size: float) -> None: ...
        def selectedItemChanged(self, index: int) -> None: ...
        def dataProxyChanged(self, proxy: 'QScatterDataProxy') -> None: ...
        def itemSize(self) -> float: ...
        def setItemSize(self, size: float) -> None: ...
        @staticmethod
        def invalidSelectionIndex() -> int: ...
        def selectedItem(self) -> int: ...
        def setSelectedItem(self, index: int) -> None: ...
        def dataProxy(self) -> 'QScatterDataProxy': ...
        def setDataProxy(self, proxy: 'QScatterDataProxy') -> None: ...

    class QScatterDataItem(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, position: QtGui.QVector3D) -> None: ...
        @typing.overload
        def __init__(self, position: QtGui.QVector3D, rotation: QtGui.QQuaternion) -> None: ...
        @typing.overload
        def __init__(self, other: 'QScatterDataItem') -> None: ...

        def z(self) -> float: ...
        def y(self) -> float: ...
        def x(self) -> float: ...
        def setZ(self, value: float) -> None: ...
        def setY(self, value: float) -> None: ...
        def setX(self, value: float) -> None: ...
        def rotation(self) -> QtGui.QQuaternion: ...
        def setRotation(self, rotation: QtGui.QQuaternion) -> None: ...
        def position(self) -> QtGui.QVector3D: ...
        def setPosition(self, position: QtGui.QVector3D) -> None: ...

    class QSurface3DSeries('QAbstract3DSeries'):

        class DrawFlag(int): ...
        DrawWireframe = ... # type: 'QSurface3DSeries.DrawFlag'
        DrawSurface = ... # type: 'QSurface3DSeries.DrawFlag'
        DrawSurfaceAndWireframe = ... # type: 'QSurface3DSeries.DrawFlag'

        class DrawFlags(sip.simplewrapper):

            @typing.overload
            def __init__(self) -> None: ...
            @typing.overload
            def __init__(self, f: typing.Union['QSurface3DSeries.DrawFlags', 'QSurface3DSeries.DrawFlag']) -> None: ...
            @typing.overload
            def __init__(self, a0: 'QSurface3DSeries.DrawFlags') -> None: ...

            def __hash__(self) -> int: ...
            def __bool__(self) -> int: ...
            def __invert__(self) -> 'QSurface3DSeries.DrawFlags': ...
            def __int__(self) -> int: ...

        @typing.overload
        def __init__(self, dataProxy: 'QSurfaceDataProxy', parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
        @typing.overload
        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def textureFileChanged(self, filename: str) -> None: ...
        def textureChanged(self, image: QtGui.QImage) -> None: ...
        def textureFile(self) -> str: ...
        def setTextureFile(self, filename: str) -> None: ...
        def texture(self) -> QtGui.QImage: ...
        def setTexture(self, texture: QtGui.QImage) -> None: ...
        def drawModeChanged(self, mode: typing.Union['QSurface3DSeries.DrawFlags', 'QSurface3DSeries.DrawFlag']) -> None: ...
        def flatShadingSupportedChanged(self, enable: bool) -> None: ...
        def flatShadingEnabledChanged(self, enable: bool) -> None: ...
        def selectedPointChanged(self, position: QtCore.QPoint) -> None: ...
        def dataProxyChanged(self, proxy: 'QSurfaceDataProxy') -> None: ...
        def isFlatShadingSupported(self) -> bool: ...
        def drawMode(self) -> 'QSurface3DSeries.DrawFlags': ...
        def setDrawMode(self, mode: typing.Union['QSurface3DSeries.DrawFlags', 'QSurface3DSeries.DrawFlag']) -> None: ...
        def isFlatShadingEnabled(self) -> bool: ...
        def setFlatShadingEnabled(self, enabled: bool) -> None: ...
        @staticmethod
        def invalidSelectionPosition() -> QtCore.QPoint: ...
        def selectedPoint(self) -> QtCore.QPoint: ...
        def setSelectedPoint(self, position: QtCore.QPoint) -> None: ...
        def dataProxy(self) -> 'QSurfaceDataProxy': ...
        def setDataProxy(self, proxy: 'QSurfaceDataProxy') -> None: ...

    class QSurfaceDataItem(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, position: QtGui.QVector3D) -> None: ...
        @typing.overload
        def __init__(self, other: 'QSurfaceDataItem') -> None: ...

        def z(self) -> float: ...
        def y(self) -> float: ...
        def x(self) -> float: ...
        def setZ(self, value: float) -> None: ...
        def setY(self, value: float) -> None: ...
        def setX(self, value: float) -> None: ...
        def position(self) -> QtGui.QVector3D: ...
        def setPosition(self, position: QtGui.QVector3D) -> None: ...

    class QTouch3DInputHandler('Q3DInputHandler'):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def touchEvent(self, event: QtGui.QTouchEvent) -> None: ...

    class QValue3DAxis('QAbstract3DAxis'):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def reversedChanged(self, enable: bool) -> None: ...
        def formatterChanged(self, formatter: 'QValue3DAxisFormatter') -> None: ...
        def reversed(self) -> bool: ...
        def setReversed(self, enable: bool) -> None: ...
        def formatter(self) -> 'QValue3DAxisFormatter': ...
        def setFormatter(self, formatter: 'QValue3DAxisFormatter') -> None: ...
        def labelFormatChanged(self, format: str) -> None: ...
        def subSegmentCountChanged(self, count: int) -> None: ...
        def segmentCountChanged(self, count: int) -> None: ...
        def labelFormat(self) -> str: ...
        def setLabelFormat(self, format: str) -> None: ...
        def subSegmentCount(self) -> int: ...
        def setSubSegmentCount(self, count: int) -> None: ...
        def segmentCount(self) -> int: ...
        def setSegmentCount(self, count: int) -> None: ...

    def qDefaultSurfaceFormat(self, antialias: bool = ...) -> QtGui.QSurfaceFormat: ...


PYQT_DATAVISUALIZATION_VERSION = ... # type: int
PYQT_DATAVISUALIZATION_VERSION_STR = ... # type: str
QTDATAVISUALIZATION_VERSION = ... # type: int
QTDATAVISUALIZATION_VERSION_STR = ... # type: str
