
//          Copyright Oliver Kowalke 2016.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#include <cstdlib>
#include <iostream>

#include <boost/context/continuation.hpp>

namespace ctx = boost::context;

ctx::continuation foo( ctx::continuation && c) {
    do {
        std::cout << "foo\n";
    } while ( c = c.resume() );
    return std::move( c);
}

int main() {
    ctx::continuation c = ctx::callcc( foo);
    do {
        std::cout << "bar\n";
    } while ( c = c.resume() );
    std::cout << "main: done" << std::endl;
    return EXIT_SUCCESS;
}
