.\" Copyright (C) 1989-95 GROUPE BULL
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a copy
.\" of this software and associated documentation files (the "Software"), to
.\" deal in the Software without restriction, including without limitation the
.\" rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
.\" sell copies of the Software, and to permit persons to whom the Software is
.\" furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included in
.\" all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
.\" GROUPE BULL BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
.\" AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
.\" CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of GROUPE BULL shall not be
.\" used in advertising or otherwise to promote the sale, use or other dealings
.\" in this Software without prior written authorization from GROUPE BULL.
.\"
.hw XImage
.TH  XpmCreateImage __libmansuffix__ __xorgversion__ "libXpm functions"
.SH NAME
XpmCreateImage \- create an Xpm-image
.SH SYNOPSIS
.HP
int XpmCreateImageFromData(Display *display, char **data, XImage **image_return, XImage **shapeimage_return, XpmAttributes *attributes);
.HP
int XpmCreateImageFromBuffer(Display *display, char *buffer, XImage **image_return, XImage **shapeimage_return, XpmAttributes *attributes);
.HP
int XpmCreateImageFromXpmImage(Display *display,  XpmImage *image, XImage *image_return, XImage *shapeimage_return, XpmAttributes *attributes);

.SH ARGUMENTS

.IP \fIdisplay\fP li
Specifies the connection to the X server.
.IP \fIdata\fP li
Specifies the location of the data.
.IP \fIimage_return\fP li
Returns the image which is created.
.IP \fIshapeimage_return\fP li
Returns the shape mask image which is created if the color None is used.
.IP \fIattributes\fP li
Specifies the location of a structure to get and store information (or NULL).
.IP \fIshapeimage\fP li
Specifies the shape mask image which is created if any.

.SH DESCRIPTION

.SS XpmCreateImageFromData
To create an XImage from an XPM data, use XpmCreateImageFromData.

The XpmCreateImageFromData function allows you to include in your C program an XPM file which was
written out by functions such as XpmWriteFileFromImage or XpmWriteFileFromPixmap without reading in the file.
XpmCreateImageFromData exactly works as XpmReadFileToImage() does and returns the same way.
It just reads data instead of a file.
Here again, it is the caller’s responsibility to free the returned images, the colors
and possibly the data returned into the XpmAttributes structure.

.SS XpmCreateImageFromBuffer
To create an XImage from an XPM buffer, use XpmCreateImageFromBuffer.
The XpmCreateImageFromBuffer function works the same way as XpmReadFileToImage(),
it just parses the buffer instead of the file.
Be aware that the feature provided on some systems by XpmReadFileToImage
to deal with compressed files is not available here.

.SS XpmCreateImageFromXpmImage
To create an XImage from an XpmImage, use XpmCreateImageFromXpmImage.
From the given XpmImage and XpmAttributes if not NULL, XpmCreateImageFromXpmImage allocates colors
and creates X images following the same mechanism as XpmReadFileToImage().
When finished the caller must free the images using XDestroyImage,
the colors using XFreeColors, and possibly the
data returned into the XpmAttributes using XpmFreeAttributes().

.SH "SEE ALSO"
.BR XpmCreateImageFromBuffer(__libmansuffix__) ,
.BR XpmCreateImageFromData(__libmansuffix__) ,
.BR XpmCreateImageFromXpmImage(__libmansuffix__)
