.\" Copyright (C) 1989-95 GROUPE BULL
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a copy
.\" of this software and associated documentation files (the "Software"), to
.\" deal in the Software without restriction, including without limitation the
.\" rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
.\" sell copies of the Software, and to permit persons to whom the Software is
.\" furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included in
.\" all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
.\" GROUPE BULL BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
.\" AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
.\" CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of GROUPE BULL shall not be
.\" used in advertising or otherwise to promote the sale, use or other dealings
.\" in this Software without prior written authorization from GROUPE BULL.
.\"
.hw XImage
.TH XpmMisc __libmansuffix__ __xorgversion__ "libXpm functions"
.SH NAME
XpmMisc \- xpm misc functions to free used memory and handle errors
.SH SYNOPSIS

.HP
int XpmFreeXpmImage(XpmImage *image);
.HP
int XpmFreeXpmInfo(XpmInfo *info);
.HP
int XpmFreeAttributes(XpmAttributes *attributes);
.HP
int XpmAttributesSize();
.HP
int XpmFreeExtensions(XpmExtension *extensions,  int nextensions);
.HP
int XpmFree(char *ptr);
.HP
char *XpmGetErrorString(int errorcode);
.HP
int XpmLibraryVersion();

.SH ARGUMENTS

.IP \fIimage\fP li
Specifies the structure to free
.IP \fIinfo\fP li
Specifies the structure to free
.IP \fIptr\fP li
Specifies the data to free
.IP \fIerrorcode\fP li
Specifies the XPM error
.IP \fIextensions\fP li
Specifies the array to free
.IP \fInextensions\fP li
Specifies the number of extensions
.IP \fIattributes\fP li
Specifies the structure to free

.SH DESCRIPTION

To free possible data stored into an XpmImage structure use XpmFreeXpmImage.
The XpmFreeXpmImage function frees the structure members which are not NULL, but not the structure itself.
To free possible data stored into an XpmInfo structure use XpmFreeXpmInfo.

To free data possibly stored into an array of XpmExtension use XpmFreeExtensions.

To free any data allocated by an XPM function use the XpmFree function.
The current distribution of the XPM library uses the standard memory allocation functions and thus
XpmFree is nothing else than a define to the standard free.
However since these functions may be redefined in specific environments it is wise to use XpmFree.

To free possible data stored into an XpmAttributes structure use XpmFreeAttributes.
The XpmFreeAttributes function frees the structure members which have been malloc’ed such as the pixels list.

To dynamically allocate an XpmAttributes structure use the XpmAttributesSize function.
The XpmAttributesSize function provides application using dynamic libraries with a safe way to allocate and then
refer to an XpmAttributes structure, disregarding whether the XpmAttributes structure size has changed or not since
compiled.
To get data when building an error message, one can use XpmGetErrorString.
XpmGetErrorString returns a string related to the given XPM error code.

The XpmLibraryVersion function can be used when one needs to figure out which version of the library is in use.
The value returned by XpmLibraryVersion can be compared to the value of XpmIncludeVersion which is defined
in the header file "xpm.h". These numbers are computed with the following formula:
.nf
 (XpmFormat * 100 + XpmVersion) * 100 + XpmRevision
.fi
Where XpmFormat is the version number of the format, XpmVersion is the library version number (which changes
only if the API changes), and XpmRevision is the library minor version number.

The XpmFreeExtensions function frees all data stored in every extension and the array itself.
Note that XpmFreeAttributes call this function and thus most of the time it should not need to be explicitly called.

.SH "SEE ALSO"
.BR XpmLibraryVersion(__libmansuffix__) ,
.BR XpmGetErrorString(__libmansuffix__) ,
.BR XpmFree(__libmansuffix__) ,
.BR XpmFreeExtensions(__libmansuffix__) ,
.BR XpmAttributesSize(__libmansuffix__) ,
.BR XpmFreeAttributes(__libmansuffix__) ,
.BR XpmFreeXpmImage(__libmansuffix__) ,
.BR XpmFreeXpmInfo(__libmansuffix__)
