/* sorted-bigram-language-model.c generated by valac 0.26.2, the Vala compiler
 * generated from sorted-bigram-language-model.vala, do not modify */

/*
 * Copyright (C) 2012-2014 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2012-2014 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <marisa-glib/marisa-glib.h>


#define KKC_TYPE_LANGUAGE_MODEL (kkc_language_model_get_type ())
#define KKC_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModel))
#define KKC_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModelClass))
#define KKC_IS_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_LANGUAGE_MODEL))
#define KKC_IS_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_LANGUAGE_MODEL))
#define KKC_LANGUAGE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModelClass))

typedef struct _KkcLanguageModel KkcLanguageModel;
typedef struct _KkcLanguageModelClass KkcLanguageModelClass;
typedef struct _KkcLanguageModelPrivate KkcLanguageModelPrivate;

#define KKC_TYPE_LANGUAGE_MODEL_ENTRY (kkc_language_model_entry_get_type ())
typedef struct _KkcLanguageModelEntry KkcLanguageModelEntry;

#define KKC_TYPE_UNIGRAM_LANGUAGE_MODEL (kkc_unigram_language_model_get_type ())
#define KKC_UNIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_UNIGRAM_LANGUAGE_MODEL, KkcUnigramLanguageModel))
#define KKC_IS_UNIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_UNIGRAM_LANGUAGE_MODEL))
#define KKC_UNIGRAM_LANGUAGE_MODEL_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), KKC_TYPE_UNIGRAM_LANGUAGE_MODEL, KkcUnigramLanguageModelIface))

typedef struct _KkcUnigramLanguageModel KkcUnigramLanguageModel;
typedef struct _KkcUnigramLanguageModelIface KkcUnigramLanguageModelIface;

#define KKC_TYPE_BIGRAM_LANGUAGE_MODEL (kkc_bigram_language_model_get_type ())
#define KKC_BIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_BIGRAM_LANGUAGE_MODEL, KkcBigramLanguageModel))
#define KKC_IS_BIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_BIGRAM_LANGUAGE_MODEL))
#define KKC_BIGRAM_LANGUAGE_MODEL_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), KKC_TYPE_BIGRAM_LANGUAGE_MODEL, KkcBigramLanguageModelIface))

typedef struct _KkcBigramLanguageModel KkcBigramLanguageModel;
typedef struct _KkcBigramLanguageModelIface KkcBigramLanguageModelIface;

#define KKC_TYPE_SORTED_BIGRAM_LANGUAGE_MODEL (kkc_sorted_bigram_language_model_get_type ())
#define KKC_SORTED_BIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_SORTED_BIGRAM_LANGUAGE_MODEL, KkcSortedBigramLanguageModel))
#define KKC_SORTED_BIGRAM_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_SORTED_BIGRAM_LANGUAGE_MODEL, KkcSortedBigramLanguageModelClass))
#define KKC_IS_SORTED_BIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_SORTED_BIGRAM_LANGUAGE_MODEL))
#define KKC_IS_SORTED_BIGRAM_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_SORTED_BIGRAM_LANGUAGE_MODEL))
#define KKC_SORTED_BIGRAM_LANGUAGE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_SORTED_BIGRAM_LANGUAGE_MODEL, KkcSortedBigramLanguageModelClass))

typedef struct _KkcSortedBigramLanguageModel KkcSortedBigramLanguageModel;
typedef struct _KkcSortedBigramLanguageModelClass KkcSortedBigramLanguageModelClass;
typedef struct _KkcSortedBigramLanguageModelPrivate KkcSortedBigramLanguageModelPrivate;

#define KKC_TYPE_INDEX_FILE (kkc_index_file_get_type ())
#define KKC_INDEX_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_INDEX_FILE, KkcIndexFile))
#define KKC_IS_INDEX_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_INDEX_FILE))
#define KKC_INDEX_FILE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), KKC_TYPE_INDEX_FILE, KkcIndexFileIface))

typedef struct _KkcIndexFile KkcIndexFile;
typedef struct _KkcIndexFileIface KkcIndexFileIface;

#define KKC_TYPE_BLOOM_FILTER (kkc_bloom_filter_get_type ())
#define KKC_BLOOM_FILTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_BLOOM_FILTER, KkcBloomFilter))
#define KKC_BLOOM_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_BLOOM_FILTER, KkcBloomFilterClass))
#define KKC_IS_BLOOM_FILTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_BLOOM_FILTER))
#define KKC_IS_BLOOM_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_BLOOM_FILTER))
#define KKC_BLOOM_FILTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_BLOOM_FILTER, KkcBloomFilterClass))

typedef struct _KkcBloomFilter KkcBloomFilter;
typedef struct _KkcBloomFilterClass KkcBloomFilterClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define KKC_TYPE_METADATA_FILE (kkc_metadata_file_get_type ())
#define KKC_METADATA_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_METADATA_FILE, KkcMetadataFile))
#define KKC_METADATA_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_METADATA_FILE, KkcMetadataFileClass))
#define KKC_IS_METADATA_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_METADATA_FILE))
#define KKC_IS_METADATA_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_METADATA_FILE))
#define KKC_METADATA_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_METADATA_FILE, KkcMetadataFileClass))

typedef struct _KkcMetadataFile KkcMetadataFile;
typedef struct _KkcMetadataFileClass KkcMetadataFileClass;

#define KKC_TYPE_LANGUAGE_MODEL_METADATA (kkc_language_model_metadata_get_type ())
#define KKC_LANGUAGE_MODEL_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_LANGUAGE_MODEL_METADATA, KkcLanguageModelMetadata))
#define KKC_LANGUAGE_MODEL_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_LANGUAGE_MODEL_METADATA, KkcLanguageModelMetadataClass))
#define KKC_IS_LANGUAGE_MODEL_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_LANGUAGE_MODEL_METADATA))
#define KKC_IS_LANGUAGE_MODEL_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_LANGUAGE_MODEL_METADATA))
#define KKC_LANGUAGE_MODEL_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_LANGUAGE_MODEL_METADATA, KkcLanguageModelMetadataClass))

typedef struct _KkcLanguageModelMetadata KkcLanguageModelMetadata;
typedef struct _KkcLanguageModelMetadataClass KkcLanguageModelMetadataClass;

#define KKC_TYPE_MAPPED_INDEX_FILE (kkc_mapped_index_file_get_type ())
#define KKC_MAPPED_INDEX_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_MAPPED_INDEX_FILE, KkcMappedIndexFile))
#define KKC_MAPPED_INDEX_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_MAPPED_INDEX_FILE, KkcMappedIndexFileClass))
#define KKC_IS_MAPPED_INDEX_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_MAPPED_INDEX_FILE))
#define KKC_IS_MAPPED_INDEX_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_MAPPED_INDEX_FILE))
#define KKC_MAPPED_INDEX_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_MAPPED_INDEX_FILE, KkcMappedIndexFileClass))

typedef struct _KkcMappedIndexFile KkcMappedIndexFile;
typedef struct _KkcMappedIndexFileClass KkcMappedIndexFileClass;

#define KKC_TYPE_LOADED_INDEX_FILE (kkc_loaded_index_file_get_type ())
#define KKC_LOADED_INDEX_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_LOADED_INDEX_FILE, KkcLoadedIndexFile))
#define KKC_LOADED_INDEX_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_LOADED_INDEX_FILE, KkcLoadedIndexFileClass))
#define KKC_IS_LOADED_INDEX_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_LOADED_INDEX_FILE))
#define KKC_IS_LOADED_INDEX_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_LOADED_INDEX_FILE))
#define KKC_LOADED_INDEX_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_LOADED_INDEX_FILE, KkcLoadedIndexFileClass))

typedef struct _KkcLoadedIndexFile KkcLoadedIndexFile;
typedef struct _KkcLoadedIndexFileClass KkcLoadedIndexFileClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _kkc_language_model_entry_free0(var) ((var == NULL) ? NULL : (var = (kkc_language_model_entry_free (var), NULL)))

struct _KkcLanguageModelEntry {
	gchar* input;
	gchar* output;
	guint id;
};

struct _KkcLanguageModel {
	GObject parent_instance;
	KkcLanguageModelPrivate * priv;
};

struct _KkcLanguageModelClass {
	GObjectClass parent_class;
	GeeCollection* (*unigram_entries) (KkcLanguageModel* self, const gchar* input);
	GeeCollection* (*entries) (KkcLanguageModel* self, const gchar* input);
	KkcLanguageModelEntry* (*get) (KkcLanguageModel* self, const gchar* input, const gchar* output);
	gboolean (*parse) (KkcLanguageModel* self, GError** error);
	void (*get_bos) (KkcLanguageModel* self, KkcLanguageModelEntry* result);
	void (*get_eos) (KkcLanguageModel* self, KkcLanguageModelEntry* result);
};

struct _KkcUnigramLanguageModelIface {
	GTypeInterface parent_iface;
	gdouble (*unigram_cost) (KkcUnigramLanguageModel* self, KkcLanguageModelEntry* entry);
	gdouble (*unigram_backoff) (KkcUnigramLanguageModel* self, KkcLanguageModelEntry* entry);
};

struct _KkcBigramLanguageModelIface {
	GTypeInterface parent_iface;
	gboolean (*has_bigram) (KkcBigramLanguageModel* self, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
	gdouble (*bigram_cost) (KkcBigramLanguageModel* self, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
	gdouble (*bigram_backoff) (KkcBigramLanguageModel* self, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
};

struct _KkcSortedBigramLanguageModel {
	KkcLanguageModel parent_instance;
	KkcSortedBigramLanguageModelPrivate * priv;
};

struct _KkcSortedBigramLanguageModelClass {
	KkcLanguageModelClass parent_class;
};

struct _KkcIndexFileIface {
	GTypeInterface parent_iface;
	gchar* (*get_contents) (KkcIndexFile* self);
	gsize (*get_length) (KkcIndexFile* self);
};

struct _KkcSortedBigramLanguageModelPrivate {
	KkcLanguageModelEntry _bos;
	KkcLanguageModelEntry _eos;
	MarisaTrie* input_trie;
	MarisaTrie* unigram_trie;
	KkcIndexFile* unigram_index;
	KkcIndexFile* bigram_index;
	KkcBloomFilter* bigram_filter;
	guint32 last_value;
	guint32 last_pvalue;
	glong last_offset;
};


static gpointer kkc_sorted_bigram_language_model_parent_class = NULL;
extern gboolean kkc_use_mapped_index_file;
static KkcUnigramLanguageModelIface* kkc_sorted_bigram_language_model_kkc_unigram_language_model_parent_iface = NULL;
static KkcBigramLanguageModelIface* kkc_sorted_bigram_language_model_kkc_bigram_language_model_parent_iface = NULL;

GType kkc_language_model_get_type (void) G_GNUC_CONST;
GType kkc_language_model_entry_get_type (void) G_GNUC_CONST;
KkcLanguageModelEntry* kkc_language_model_entry_dup (const KkcLanguageModelEntry* self);
void kkc_language_model_entry_free (KkcLanguageModelEntry* self);
void kkc_language_model_entry_copy (const KkcLanguageModelEntry* self, KkcLanguageModelEntry* dest);
void kkc_language_model_entry_destroy (KkcLanguageModelEntry* self);
GType kkc_unigram_language_model_get_type (void) G_GNUC_CONST;
GType kkc_bigram_language_model_get_type (void) G_GNUC_CONST;
GType kkc_sorted_bigram_language_model_get_type (void) G_GNUC_CONST;
GType kkc_index_file_get_type (void) G_GNUC_CONST;
GType kkc_bloom_filter_get_type (void) G_GNUC_CONST;
#define KKC_SORTED_BIGRAM_LANGUAGE_MODEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KKC_TYPE_SORTED_BIGRAM_LANGUAGE_MODEL, KkcSortedBigramLanguageModelPrivate))
enum  {
	KKC_SORTED_BIGRAM_LANGUAGE_MODEL_DUMMY_PROPERTY,
	KKC_SORTED_BIGRAM_LANGUAGE_MODEL_BOS,
	KKC_SORTED_BIGRAM_LANGUAGE_MODEL_EOS,
	KKC_SORTED_BIGRAM_LANGUAGE_MODEL_MIN_COST
};
static GeeCollection* kkc_sorted_bigram_language_model_real_unigram_entries (KkcLanguageModel* base, const gchar* prefix);
static GeeCollection* kkc_sorted_bigram_language_model_real_entries (KkcLanguageModel* base, const gchar* input);
GeeCollection* kkc_language_model_unigram_entries (KkcLanguageModel* self, const gchar* input);
static KkcLanguageModelEntry* kkc_sorted_bigram_language_model_real_get (KkcLanguageModel* base, const gchar* input, const gchar* output);
glong kkc_sorted_bigram_language_model_bigram_offset (KkcSortedBigramLanguageModel* self, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
gboolean kkc_bloom_filter_contains (KkcBloomFilter* self, guint32 b0, guint32 b1);
glong kkc_language_model_utils_bsearch_ngram (void* memory, glong start_offset, glong end_offset, glong record_size, guint8* needle, int needle_length1);
gchar* kkc_index_file_get_contents (KkcIndexFile* self);
gsize kkc_index_file_get_length (KkcIndexFile* self);
static gdouble kkc_sorted_bigram_language_model_real_unigram_cost (KkcUnigramLanguageModel* base, KkcLanguageModelEntry* entry);
gdouble kkc_language_model_utils_decode_cost (guint16 cost, gdouble min_cost);
gdouble kkc_sorted_bigram_language_model_get_min_cost (KkcSortedBigramLanguageModel* self);
static gdouble kkc_sorted_bigram_language_model_real_unigram_backoff (KkcUnigramLanguageModel* base, KkcLanguageModelEntry* entry);
static gboolean kkc_sorted_bigram_language_model_real_has_bigram (KkcBigramLanguageModel* base, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
static gdouble kkc_sorted_bigram_language_model_real_bigram_cost (KkcBigramLanguageModel* base, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
static gdouble kkc_sorted_bigram_language_model_real_bigram_backoff (KkcBigramLanguageModel* base, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
static gboolean kkc_sorted_bigram_language_model_real_parse (KkcLanguageModel* base, GError** error);
GType kkc_metadata_file_get_type (void) G_GNUC_CONST;
GType kkc_language_model_metadata_get_type (void) G_GNUC_CONST;
KkcLanguageModelMetadata* kkc_language_model_get_metadata (KkcLanguageModel* self);
const gchar* kkc_metadata_file_get_filename (KkcMetadataFile* self);
GType kkc_mapped_index_file_get_type (void) G_GNUC_CONST;
KkcMappedIndexFile* kkc_mapped_index_file_new (const gchar* filename, GError** error);
KkcMappedIndexFile* kkc_mapped_index_file_construct (GType object_type, const gchar* filename, GError** error);
GType kkc_loaded_index_file_get_type (void) G_GNUC_CONST;
KkcLoadedIndexFile* kkc_loaded_index_file_new (const gchar* filename, GError** error);
KkcLoadedIndexFile* kkc_loaded_index_file_construct (GType object_type, const gchar* filename, GError** error);
KkcBloomFilter* kkc_bloom_filter_new (const gchar* filename, GError** error);
KkcBloomFilter* kkc_bloom_filter_construct (GType object_type, const gchar* filename, GError** error);
KkcLanguageModelEntry* kkc_language_model_get (KkcLanguageModel* self, const gchar* input, const gchar* output);
KkcSortedBigramLanguageModel* kkc_sorted_bigram_language_model_new (KkcLanguageModelMetadata* metadata, GError** error);
KkcSortedBigramLanguageModel* kkc_sorted_bigram_language_model_construct (GType object_type, KkcLanguageModelMetadata* metadata, GError** error);
KkcLanguageModel* kkc_language_model_construct (GType object_type, KkcLanguageModelMetadata* metadata, GError** error);
static void kkc_sorted_bigram_language_model_finalize (GObject* obj);
void kkc_language_model_get_bos (KkcLanguageModel* self, KkcLanguageModelEntry* result);
void kkc_language_model_get_eos (KkcLanguageModel* self, KkcLanguageModelEntry* result);
static void _vala_kkc_sorted_bigram_language_model_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1 = 0;
	gint _res_size_ = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static GeeCollection* kkc_sorted_bigram_language_model_real_unigram_entries (KkcLanguageModel* base, const gchar* prefix) {
	KkcSortedBigramLanguageModel * self;
	GeeCollection* result = NULL;
	GeeArrayList* entries = NULL;
	GeeArrayList* _tmp0_ = NULL;
	MarisaAgent* agent = NULL;
	MarisaAgent* _tmp1_ = NULL;
	gchar* query = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	MarisaAgent* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	guint8* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	guint8* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	self = (KkcSortedBigramLanguageModel*) base;
	g_return_val_if_fail (prefix != NULL, NULL);
	_tmp0_ = gee_array_list_new (KKC_TYPE_LANGUAGE_MODEL_ENTRY, (GBoxedCopyFunc) kkc_language_model_entry_dup, kkc_language_model_entry_free, NULL, NULL, NULL);
	entries = _tmp0_;
	_tmp1_ = marisa_agent_new ();
	agent = _tmp1_;
	_tmp2_ = prefix;
	_tmp3_ = g_strconcat (_tmp2_, "/", NULL);
	query = _tmp3_;
	_tmp4_ = agent;
	_tmp5_ = query;
	_tmp6_ = string_get_data (_tmp5_, &_tmp6__length1);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp6__length1;
	marisa_agent_set_query (_tmp4_, (const gchar*) _tmp7_, (gsize) _tmp7__length1);
	while (TRUE) {
		MarisaTrie* _tmp8_ = NULL;
		MarisaAgent* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		MarisaKey* key = NULL;
		MarisaAgent* _tmp11_ = NULL;
		MarisaKey* _tmp12_ = NULL;
		gchar** input_output = NULL;
		MarisaKey* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar** _tmp16_ = NULL;
		gchar** _tmp17_ = NULL;
		gchar** _tmp18_ = NULL;
		gint _tmp18__length1 = 0;
		gint input_output_length1 = 0;
		gint _input_output_size_ = 0;
		guint id = 0U;
		MarisaKey* _tmp19_ = NULL;
		gsize _tmp20_ = 0UL;
		KkcLanguageModelEntry entry = {0};
		gchar** _tmp21_ = NULL;
		gint _tmp21__length1 = 0;
		const gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar** _tmp24_ = NULL;
		gint _tmp24__length1 = 0;
		const gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		guint _tmp27_ = 0U;
		KkcLanguageModelEntry _tmp28_ = {0};
		GeeArrayList* _tmp29_ = NULL;
		KkcLanguageModelEntry _tmp30_ = {0};
		_tmp8_ = self->priv->unigram_trie;
		_tmp9_ = agent;
		_tmp10_ = marisa_trie_predictive_search (_tmp8_, _tmp9_);
		if (!_tmp10_) {
			break;
		}
		_tmp11_ = agent;
		_tmp12_ = marisa_agent_get_key (_tmp11_);
		key = _tmp12_;
		_tmp13_ = key;
		_tmp14_ = marisa_key_get_string (_tmp13_, NULL);
		_tmp15_ = _tmp14_;
		_tmp17_ = _tmp16_ = g_strsplit (_tmp15_, "/", 0);
		_tmp18_ = _tmp17_;
		_tmp18__length1 = _vala_array_length (_tmp16_);
		_g_free0 (_tmp15_);
		input_output = _tmp18_;
		input_output_length1 = _tmp18__length1;
		_input_output_size_ = input_output_length1;
		_tmp19_ = key;
		_tmp20_ = marisa_key_get_id (_tmp19_);
		id = (guint) _tmp20_;
		_tmp21_ = input_output;
		_tmp21__length1 = input_output_length1;
		_tmp22_ = _tmp21_[0];
		_tmp23_ = g_strdup (_tmp22_);
		_tmp24_ = input_output;
		_tmp24__length1 = input_output_length1;
		_tmp25_ = _tmp24_[1];
		_tmp26_ = g_strdup (_tmp25_);
		_tmp27_ = id;
		_g_free0 (_tmp28_.input);
		_tmp28_.input = _tmp23_;
		_g_free0 (_tmp28_.output);
		_tmp28_.output = _tmp26_;
		_tmp28_.id = _tmp27_;
		entry = _tmp28_;
		_tmp29_ = entries;
		_tmp30_ = entry;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp29_, &_tmp30_);
		kkc_language_model_entry_destroy (&entry);
		input_output = (_vala_array_free (input_output, input_output_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (key);
	}
	result = (GeeCollection*) entries;
	_g_free0 (query);
	_g_object_unref0 (agent);
	return result;
}


static GeeCollection* kkc_sorted_bigram_language_model_real_entries (KkcLanguageModel* base, const gchar* input) {
	KkcSortedBigramLanguageModel * self;
	GeeCollection* result = NULL;
	GeeArrayList* entries = NULL;
	GeeArrayList* _tmp0_ = NULL;
	MarisaAgent* agent = NULL;
	MarisaAgent* _tmp1_ = NULL;
	MarisaAgent* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	guint8* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	self = (KkcSortedBigramLanguageModel*) base;
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = gee_array_list_new (KKC_TYPE_LANGUAGE_MODEL_ENTRY, (GBoxedCopyFunc) kkc_language_model_entry_dup, kkc_language_model_entry_free, NULL, NULL, NULL);
	entries = _tmp0_;
	_tmp1_ = marisa_agent_new ();
	agent = _tmp1_;
	_tmp2_ = agent;
	_tmp3_ = input;
	_tmp4_ = string_get_data (_tmp3_, &_tmp4__length1);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	marisa_agent_set_query (_tmp2_, (const gchar*) _tmp5_, (gsize) _tmp5__length1);
	while (TRUE) {
		MarisaTrie* _tmp6_ = NULL;
		MarisaAgent* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		gchar* prefix = NULL;
		MarisaAgent* _tmp9_ = NULL;
		MarisaKey* _tmp10_ = NULL;
		MarisaKey* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		GeeArrayList* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		GeeCollection* _tmp16_ = NULL;
		GeeCollection* _tmp17_ = NULL;
		_tmp6_ = self->priv->input_trie;
		_tmp7_ = agent;
		_tmp8_ = marisa_trie_common_prefix_search (_tmp6_, _tmp7_);
		if (!_tmp8_) {
			break;
		}
		_tmp9_ = agent;
		_tmp10_ = marisa_agent_get_key (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = marisa_key_get_string (_tmp11_, NULL);
		_tmp13_ = _tmp12_;
		_g_object_unref0 (_tmp11_);
		prefix = _tmp13_;
		_tmp14_ = entries;
		_tmp15_ = prefix;
		_tmp16_ = kkc_language_model_unigram_entries ((KkcLanguageModel*) self, _tmp15_);
		_tmp17_ = _tmp16_;
		gee_array_list_add_all (_tmp14_, _tmp17_);
		_g_object_unref0 (_tmp17_);
		_g_free0 (prefix);
	}
	result = (GeeCollection*) entries;
	_g_object_unref0 (agent);
	return result;
}


static gpointer _kkc_language_model_entry_dup0 (gpointer self) {
	return self ? kkc_language_model_entry_dup (self) : NULL;
}


static KkcLanguageModelEntry* kkc_sorted_bigram_language_model_real_get (KkcLanguageModel* base, const gchar* input, const gchar* output) {
	KkcSortedBigramLanguageModel * self;
	KkcLanguageModelEntry* result = NULL;
	MarisaAgent* agent = NULL;
	MarisaAgent* _tmp0_ = NULL;
	gchar* query = NULL;
	const gchar* _tmp1_ = NULL;
	MarisaAgent* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	guint8* _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	guint8* _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	MarisaTrie* _tmp11_ = NULL;
	MarisaAgent* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	self = (KkcSortedBigramLanguageModel*) base;
	g_return_val_if_fail (input != NULL, NULL);
	g_return_val_if_fail (output != NULL, NULL);
	_tmp0_ = marisa_agent_new ();
	agent = _tmp0_;
	_tmp1_ = input;
	if (g_strcmp0 (_tmp1_, " ") != 0) {
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		_tmp2_ = input;
		_tmp3_ = output;
		_tmp4_ = g_strdup_printf ("%s/%s", _tmp2_, _tmp3_);
		_g_free0 (query);
		query = _tmp4_;
	} else {
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = output;
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (query);
		query = _tmp6_;
	}
	_tmp7_ = agent;
	_tmp8_ = query;
	_tmp9_ = string_get_data (_tmp8_, &_tmp9__length1);
	_tmp10_ = _tmp9_;
	_tmp10__length1 = _tmp9__length1;
	marisa_agent_set_query (_tmp7_, (const gchar*) _tmp10_, (gsize) _tmp10__length1);
	_tmp11_ = self->priv->unigram_trie;
	_tmp12_ = agent;
	_tmp13_ = marisa_trie_lookup (_tmp11_, _tmp12_);
	if (_tmp13_) {
		gsize id = 0UL;
		MarisaAgent* _tmp14_ = NULL;
		MarisaKey* _tmp15_ = NULL;
		MarisaKey* _tmp16_ = NULL;
		gsize _tmp17_ = 0UL;
		gsize _tmp18_ = 0UL;
		KkcLanguageModelEntry entry = {0};
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gsize _tmp23_ = 0UL;
		KkcLanguageModelEntry _tmp24_ = {0};
		KkcLanguageModelEntry _tmp25_ = {0};
		KkcLanguageModelEntry* _tmp26_ = NULL;
		KkcLanguageModelEntry* _tmp27_ = NULL;
		_tmp14_ = agent;
		_tmp15_ = marisa_agent_get_key (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = marisa_key_get_id (_tmp16_);
		_tmp18_ = _tmp17_;
		_g_object_unref0 (_tmp16_);
		id = _tmp18_;
		_tmp19_ = input;
		_tmp20_ = g_strdup (_tmp19_);
		_tmp21_ = output;
		_tmp22_ = g_strdup (_tmp21_);
		_tmp23_ = id;
		_g_free0 (_tmp24_.input);
		_tmp24_.input = _tmp20_;
		_g_free0 (_tmp24_.output);
		_tmp24_.output = _tmp22_;
		_tmp24_.id = (guint) _tmp23_;
		entry = _tmp24_;
		_tmp25_ = entry;
		_tmp26_ = _kkc_language_model_entry_dup0 (&_tmp25_);
		_tmp27_ = _tmp26_;
		kkc_language_model_entry_destroy (&_tmp25_);
		result = _tmp27_;
		_g_free0 (query);
		_g_object_unref0 (agent);
		return result;
	}
	result = NULL;
	_g_free0 (query);
	_g_object_unref0 (agent);
	return result;
}


glong kkc_sorted_bigram_language_model_bigram_offset (KkcSortedBigramLanguageModel* self, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry) {
	glong result = 0L;
	gboolean _tmp0_ = FALSE;
	KkcLanguageModelEntry _tmp1_ = {0};
	guint _tmp2_ = 0U;
	guint32 _tmp3_ = 0U;
	gboolean _tmp8_ = FALSE;
	KkcBloomFilter* _tmp9_ = NULL;
	guint8* buffer = NULL;
	guint8* _tmp16_ = NULL;
	gint buffer_length1 = 0;
	gint _buffer_size_ = 0;
	guint8* p = NULL;
	guint8* _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	guint32 value = 0U;
	KkcLanguageModelEntry _tmp18_ = {0};
	guint _tmp19_ = 0U;
	guint8* _tmp20_ = NULL;
	guint8* _tmp21_ = NULL;
	guint32 pvalue = 0U;
	KkcLanguageModelEntry _tmp22_ = {0};
	guint _tmp23_ = 0U;
	guint8* _tmp24_ = NULL;
	gint record_size = 0;
	glong offset = 0L;
	KkcIndexFile* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	KkcIndexFile* _tmp27_ = NULL;
	gsize _tmp28_ = 0UL;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	guint8* _tmp31_ = NULL;
	gint _tmp31__length1 = 0;
	glong _tmp32_ = 0L;
	KkcLanguageModelEntry _tmp33_ = {0};
	guint _tmp34_ = 0U;
	KkcLanguageModelEntry _tmp35_ = {0};
	guint _tmp36_ = 0U;
	glong _tmp37_ = 0L;
	g_return_val_if_fail (self != NULL, 0L);
	g_return_val_if_fail (pentry != NULL, 0L);
	g_return_val_if_fail (entry != NULL, 0L);
	_tmp1_ = *pentry;
	_tmp2_ = _tmp1_.id;
	_tmp3_ = self->priv->last_pvalue;
	if (_tmp2_ == ((guint) _tmp3_)) {
		KkcLanguageModelEntry _tmp4_ = {0};
		guint _tmp5_ = 0U;
		guint32 _tmp6_ = 0U;
		_tmp4_ = *entry;
		_tmp5_ = _tmp4_.id;
		_tmp6_ = self->priv->last_value;
		_tmp0_ = _tmp5_ == ((guint) _tmp6_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp7_ = 0L;
		_tmp7_ = self->priv->last_offset;
		result = _tmp7_;
		return result;
	}
	_tmp9_ = self->priv->bigram_filter;
	if (_tmp9_ != NULL) {
		KkcBloomFilter* _tmp10_ = NULL;
		KkcLanguageModelEntry _tmp11_ = {0};
		guint _tmp12_ = 0U;
		KkcLanguageModelEntry _tmp13_ = {0};
		guint _tmp14_ = 0U;
		gboolean _tmp15_ = FALSE;
		_tmp10_ = self->priv->bigram_filter;
		_tmp11_ = *entry;
		_tmp12_ = _tmp11_.id;
		_tmp13_ = *pentry;
		_tmp14_ = _tmp13_.id;
		_tmp15_ = kkc_bloom_filter_contains (_tmp10_, (guint32) _tmp12_, (guint32) _tmp14_);
		_tmp8_ = !_tmp15_;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		result = (glong) (-1);
		return result;
	}
	_tmp16_ = g_new0 (guint8, 8);
	buffer = _tmp16_;
	buffer_length1 = 8;
	_buffer_size_ = buffer_length1;
	_tmp17_ = buffer;
	_tmp17__length1 = buffer_length1;
	p = _tmp17_;
	_tmp18_ = *entry;
	_tmp19_ = _tmp18_.id;
	value = (guint32) _tmp19_;
	_tmp20_ = p;
	memcpy (_tmp20_, &value, (gsize) sizeof (guint32));
	_tmp21_ = p;
	p = _tmp21_ + 4;
	_tmp22_ = *pentry;
	_tmp23_ = _tmp22_.id;
	pvalue = (guint32) _tmp23_;
	_tmp24_ = p;
	memcpy (_tmp24_, &pvalue, (gsize) sizeof (guint32));
	record_size = 12;
	_tmp25_ = self->priv->bigram_index;
	_tmp26_ = kkc_index_file_get_contents (_tmp25_);
	_tmp27_ = self->priv->bigram_index;
	_tmp28_ = kkc_index_file_get_length (_tmp27_);
	_tmp29_ = record_size;
	_tmp30_ = record_size;
	_tmp31_ = buffer;
	_tmp31__length1 = buffer_length1;
	_tmp32_ = kkc_language_model_utils_bsearch_ngram (_tmp26_, (glong) 0, ((glong) _tmp28_) / _tmp29_, (glong) _tmp30_, _tmp31_, _tmp31__length1);
	offset = _tmp32_;
	_tmp33_ = *entry;
	_tmp34_ = _tmp33_.id;
	self->priv->last_value = (guint32) _tmp34_;
	_tmp35_ = *pentry;
	_tmp36_ = _tmp35_.id;
	self->priv->last_pvalue = (guint32) _tmp36_;
	_tmp37_ = offset;
	self->priv->last_offset = _tmp37_;
	result = offset;
	buffer = (g_free (buffer), NULL);
	return result;
}


static gdouble kkc_sorted_bigram_language_model_real_unigram_cost (KkcUnigramLanguageModel* base, KkcLanguageModelEntry* entry) {
	KkcSortedBigramLanguageModel * self;
	gdouble result = 0.0;
	KkcLanguageModelEntry _tmp0_ = {0};
	guint _tmp1_ = 0U;
	KkcIndexFile* _tmp2_ = NULL;
	gsize _tmp3_ = 0UL;
	guint8* p = NULL;
	KkcIndexFile* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	KkcLanguageModelEntry _tmp6_ = {0};
	guint _tmp7_ = 0U;
	guint16 cost = 0U;
	guint8* _tmp8_ = NULL;
	guint16 _tmp9_ = 0U;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
	self = (KkcSortedBigramLanguageModel*) base;
	g_return_val_if_fail (entry != NULL, 0.0);
	_tmp0_ = *entry;
	_tmp1_ = _tmp0_.id;
	_tmp2_ = self->priv->unigram_index;
	_tmp3_ = kkc_index_file_get_length (_tmp2_);
	if (((gsize) _tmp1_) >= _tmp3_) {
		result = (gdouble) 0;
		return result;
	}
	_tmp4_ = self->priv->unigram_index;
	_tmp5_ = kkc_index_file_get_contents (_tmp4_);
	_tmp6_ = *entry;
	_tmp7_ = _tmp6_.id;
	p = ((guint8*) _tmp5_) + (_tmp7_ * 6);
	_tmp8_ = p;
	cost = *((guint16*) _tmp8_);
	_tmp9_ = cost;
	_tmp10_ = kkc_sorted_bigram_language_model_get_min_cost (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = kkc_language_model_utils_decode_cost (_tmp9_, _tmp11_);
	result = _tmp12_;
	return result;
}


static gdouble kkc_sorted_bigram_language_model_real_unigram_backoff (KkcUnigramLanguageModel* base, KkcLanguageModelEntry* entry) {
	KkcSortedBigramLanguageModel * self;
	gdouble result = 0.0;
	KkcLanguageModelEntry _tmp0_ = {0};
	guint _tmp1_ = 0U;
	KkcIndexFile* _tmp2_ = NULL;
	gsize _tmp3_ = 0UL;
	guint8* p = NULL;
	KkcIndexFile* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	KkcLanguageModelEntry _tmp6_ = {0};
	guint _tmp7_ = 0U;
	guint16 backoff = 0U;
	guint8* _tmp8_ = NULL;
	guint16 _tmp9_ = 0U;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
	self = (KkcSortedBigramLanguageModel*) base;
	g_return_val_if_fail (entry != NULL, 0.0);
	_tmp0_ = *entry;
	_tmp1_ = _tmp0_.id;
	_tmp2_ = self->priv->unigram_index;
	_tmp3_ = kkc_index_file_get_length (_tmp2_);
	if (((gsize) _tmp1_) >= _tmp3_) {
		result = (gdouble) 0;
		return result;
	}
	_tmp4_ = self->priv->unigram_index;
	_tmp5_ = kkc_index_file_get_contents (_tmp4_);
	_tmp6_ = *entry;
	_tmp7_ = _tmp6_.id;
	p = (((guint8*) _tmp5_) + (_tmp7_ * 6)) + 2;
	_tmp8_ = p;
	backoff = *((guint16*) _tmp8_);
	_tmp9_ = backoff;
	_tmp10_ = kkc_sorted_bigram_language_model_get_min_cost (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = kkc_language_model_utils_decode_cost (_tmp9_, _tmp11_);
	result = _tmp12_;
	return result;
}


static gboolean kkc_sorted_bigram_language_model_real_has_bigram (KkcBigramLanguageModel* base, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry) {
	KkcSortedBigramLanguageModel * self;
	gboolean result = FALSE;
	KkcLanguageModelEntry _tmp0_ = {0};
	KkcLanguageModelEntry _tmp1_ = {0};
	glong _tmp2_ = 0L;
	self = (KkcSortedBigramLanguageModel*) base;
	g_return_val_if_fail (pentry != NULL, FALSE);
	g_return_val_if_fail (entry != NULL, FALSE);
	_tmp0_ = *pentry;
	_tmp1_ = *entry;
	_tmp2_ = kkc_sorted_bigram_language_model_bigram_offset (self, &_tmp0_, &_tmp1_);
	result = _tmp2_ >= ((glong) 0);
	return result;
}


static gdouble kkc_sorted_bigram_language_model_real_bigram_cost (KkcBigramLanguageModel* base, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry) {
	KkcSortedBigramLanguageModel * self;
	gdouble result = 0.0;
	glong offset = 0L;
	KkcLanguageModelEntry _tmp0_ = {0};
	KkcLanguageModelEntry _tmp1_ = {0};
	glong _tmp2_ = 0L;
	glong _tmp3_ = 0L;
	guint8* p = NULL;
	KkcIndexFile* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	glong _tmp6_ = 0L;
	guint16 cost = 0U;
	guint8* _tmp7_ = NULL;
	guint16 _tmp8_ = 0U;
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	self = (KkcSortedBigramLanguageModel*) base;
	g_return_val_if_fail (pentry != NULL, 0.0);
	g_return_val_if_fail (entry != NULL, 0.0);
	_tmp0_ = *pentry;
	_tmp1_ = *entry;
	_tmp2_ = kkc_sorted_bigram_language_model_bigram_offset (self, &_tmp0_, &_tmp1_);
	offset = _tmp2_;
	_tmp3_ = offset;
	if (_tmp3_ < ((glong) 0)) {
		result = (gdouble) 0;
		return result;
	}
	_tmp4_ = self->priv->bigram_index;
	_tmp5_ = kkc_index_file_get_contents (_tmp4_);
	_tmp6_ = offset;
	p = (((guint8*) _tmp5_) + (_tmp6_ * 12)) + 8;
	_tmp7_ = p;
	cost = *((guint16*) _tmp7_);
	_tmp8_ = cost;
	_tmp9_ = kkc_sorted_bigram_language_model_get_min_cost (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = kkc_language_model_utils_decode_cost (_tmp8_, _tmp10_);
	result = _tmp11_;
	return result;
}


static gdouble kkc_sorted_bigram_language_model_real_bigram_backoff (KkcBigramLanguageModel* base, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry) {
	KkcSortedBigramLanguageModel * self;
	gdouble result = 0.0;
	glong offset = 0L;
	KkcLanguageModelEntry _tmp0_ = {0};
	KkcLanguageModelEntry _tmp1_ = {0};
	glong _tmp2_ = 0L;
	glong _tmp3_ = 0L;
	guint8* p = NULL;
	KkcIndexFile* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	glong _tmp6_ = 0L;
	guint16 backoff = 0U;
	guint8* _tmp7_ = NULL;
	guint16 _tmp8_ = 0U;
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	self = (KkcSortedBigramLanguageModel*) base;
	g_return_val_if_fail (pentry != NULL, 0.0);
	g_return_val_if_fail (entry != NULL, 0.0);
	_tmp0_ = *pentry;
	_tmp1_ = *entry;
	_tmp2_ = kkc_sorted_bigram_language_model_bigram_offset (self, &_tmp0_, &_tmp1_);
	offset = _tmp2_;
	_tmp3_ = offset;
	if (_tmp3_ < ((glong) 0)) {
		result = (gdouble) 0;
		return result;
	}
	_tmp4_ = self->priv->bigram_index;
	_tmp5_ = kkc_index_file_get_contents (_tmp4_);
	_tmp6_ = offset;
	p = (((guint8*) _tmp5_) + (_tmp6_ * 12)) + 10;
	_tmp7_ = p;
	backoff = *((guint16*) _tmp7_);
	_tmp8_ = backoff;
	_tmp9_ = kkc_sorted_bigram_language_model_get_min_cost (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = kkc_language_model_utils_decode_cost (_tmp8_, _tmp10_);
	result = _tmp11_;
	return result;
}


static gboolean kkc_sorted_bigram_language_model_real_parse (KkcLanguageModel* base, GError** error) {
	KkcSortedBigramLanguageModel * self;
	gboolean result = FALSE;
	gchar* prefix = NULL;
	KkcLanguageModelMetadata* _tmp0_ = NULL;
	KkcLanguageModelMetadata* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* input_trie_filename = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	MarisaTrie* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* unigram_trie_filename = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	MarisaTrie* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	gchar* bigram_filter_filename = NULL;
	const gchar* _tmp45_ = NULL;
	gchar* _tmp46_ = NULL;
	KkcLanguageModelEntry* _tmp54_ = NULL;
	KkcLanguageModelEntry* _tmp55_ = NULL;
	KkcLanguageModelEntry _tmp56_ = {0};
	KkcLanguageModelEntry* _tmp57_ = NULL;
	KkcLanguageModelEntry* _tmp58_ = NULL;
	KkcLanguageModelEntry _tmp59_ = {0};
	GError * _inner_error_ = NULL;
	self = (KkcSortedBigramLanguageModel*) base;
	_tmp0_ = kkc_language_model_get_metadata ((KkcLanguageModel*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = kkc_metadata_file_get_filename ((KkcMetadataFile*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_path_get_dirname (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_build_filename (_tmp5_, "data", NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	prefix = _tmp7_;
	_tmp8_ = prefix;
	_tmp9_ = g_strconcat (_tmp8_, ".input", NULL);
	input_trie_filename = _tmp9_;
	_tmp10_ = self->priv->input_trie;
	_tmp11_ = input_trie_filename;
	marisa_trie_mmap (_tmp10_, _tmp11_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (input_trie_filename);
		_g_free0 (prefix);
		return FALSE;
	}
	_tmp12_ = prefix;
	_tmp13_ = g_strconcat (_tmp12_, ".1gram.index", NULL);
	unigram_trie_filename = _tmp13_;
	_tmp14_ = self->priv->unigram_trie;
	_tmp15_ = unigram_trie_filename;
	marisa_trie_mmap (_tmp14_, _tmp15_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (unigram_trie_filename);
		_g_free0 (input_trie_filename);
		_g_free0 (prefix);
		return FALSE;
	}
	_tmp16_ = kkc_use_mapped_index_file;
	if (_tmp16_) {
		KkcMappedIndexFile* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		KkcMappedIndexFile* _tmp21_ = NULL;
		KkcMappedIndexFile* _tmp22_ = NULL;
		KkcMappedIndexFile* _tmp23_ = NULL;
		KkcMappedIndexFile* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		KkcMappedIndexFile* _tmp28_ = NULL;
		KkcMappedIndexFile* _tmp29_ = NULL;
		KkcMappedIndexFile* _tmp30_ = NULL;
		_tmp18_ = prefix;
		_tmp19_ = g_strconcat (_tmp18_, ".1gram", NULL);
		_tmp20_ = _tmp19_;
		_tmp21_ = kkc_mapped_index_file_new (_tmp20_, &_inner_error_);
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp20_);
		_tmp17_ = _tmp22_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (unigram_trie_filename);
			_g_free0 (input_trie_filename);
			_g_free0 (prefix);
			return FALSE;
		}
		_tmp23_ = _tmp17_;
		_tmp17_ = NULL;
		_g_object_unref0 (self->priv->unigram_index);
		self->priv->unigram_index = (KkcIndexFile*) _tmp23_;
		_tmp25_ = prefix;
		_tmp26_ = g_strconcat (_tmp25_, ".2gram", NULL);
		_tmp27_ = _tmp26_;
		_tmp28_ = kkc_mapped_index_file_new (_tmp27_, &_inner_error_);
		_tmp29_ = _tmp28_;
		_g_free0 (_tmp27_);
		_tmp24_ = _tmp29_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (_tmp17_);
			_g_free0 (unigram_trie_filename);
			_g_free0 (input_trie_filename);
			_g_free0 (prefix);
			return FALSE;
		}
		_tmp30_ = _tmp24_;
		_tmp24_ = NULL;
		_g_object_unref0 (self->priv->bigram_index);
		self->priv->bigram_index = (KkcIndexFile*) _tmp30_;
		_g_object_unref0 (_tmp24_);
		_g_object_unref0 (_tmp17_);
	} else {
		KkcLoadedIndexFile* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		KkcLoadedIndexFile* _tmp35_ = NULL;
		KkcLoadedIndexFile* _tmp36_ = NULL;
		KkcLoadedIndexFile* _tmp37_ = NULL;
		KkcLoadedIndexFile* _tmp38_ = NULL;
		const gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		gchar* _tmp41_ = NULL;
		KkcLoadedIndexFile* _tmp42_ = NULL;
		KkcLoadedIndexFile* _tmp43_ = NULL;
		KkcLoadedIndexFile* _tmp44_ = NULL;
		_tmp32_ = prefix;
		_tmp33_ = g_strconcat (_tmp32_, ".1gram", NULL);
		_tmp34_ = _tmp33_;
		_tmp35_ = kkc_loaded_index_file_new (_tmp34_, &_inner_error_);
		_tmp36_ = _tmp35_;
		_g_free0 (_tmp34_);
		_tmp31_ = _tmp36_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (unigram_trie_filename);
			_g_free0 (input_trie_filename);
			_g_free0 (prefix);
			return FALSE;
		}
		_tmp37_ = _tmp31_;
		_tmp31_ = NULL;
		_g_object_unref0 (self->priv->unigram_index);
		self->priv->unigram_index = (KkcIndexFile*) _tmp37_;
		_tmp39_ = prefix;
		_tmp40_ = g_strconcat (_tmp39_, ".2gram", NULL);
		_tmp41_ = _tmp40_;
		_tmp42_ = kkc_loaded_index_file_new (_tmp41_, &_inner_error_);
		_tmp43_ = _tmp42_;
		_g_free0 (_tmp41_);
		_tmp38_ = _tmp43_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (_tmp31_);
			_g_free0 (unigram_trie_filename);
			_g_free0 (input_trie_filename);
			_g_free0 (prefix);
			return FALSE;
		}
		_tmp44_ = _tmp38_;
		_tmp38_ = NULL;
		_g_object_unref0 (self->priv->bigram_index);
		self->priv->bigram_index = (KkcIndexFile*) _tmp44_;
		_g_object_unref0 (_tmp38_);
		_g_object_unref0 (_tmp31_);
	}
	_tmp45_ = prefix;
	_tmp46_ = g_strconcat (_tmp45_, ".2gram.filter", NULL);
	bigram_filter_filename = _tmp46_;
	{
		KkcBloomFilter* _tmp47_ = NULL;
		const gchar* _tmp48_ = NULL;
		KkcBloomFilter* _tmp49_ = NULL;
		KkcBloomFilter* _tmp50_ = NULL;
		_tmp48_ = bigram_filter_filename;
		_tmp49_ = kkc_bloom_filter_new (_tmp48_, &_inner_error_);
		_tmp47_ = _tmp49_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp50_ = _tmp47_;
		_tmp47_ = NULL;
		_g_object_unref0 (self->priv->bigram_filter);
		self->priv->bigram_filter = _tmp50_;
		_g_object_unref0 (_tmp47_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp51_ = NULL;
		GError* _tmp52_ = NULL;
		const gchar* _tmp53_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp51_ = bigram_filter_filename;
		_tmp52_ = e;
		_tmp53_ = _tmp52_->message;
		g_warning ("sorted-bigram-language-model.vala:200: can't load %s: %s", _tmp51_, _tmp53_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (bigram_filter_filename);
		_g_free0 (unigram_trie_filename);
		_g_free0 (input_trie_filename);
		_g_free0 (prefix);
		return FALSE;
	}
	_tmp54_ = kkc_language_model_get ((KkcLanguageModel*) self, " ", "<s>");
	_tmp55_ = _tmp54_;
	kkc_language_model_entry_copy (_tmp55_, &_tmp56_);
	kkc_language_model_entry_destroy (&self->priv->_bos);
	self->priv->_bos = _tmp56_;
	_kkc_language_model_entry_free0 (_tmp55_);
	_tmp57_ = kkc_language_model_get ((KkcLanguageModel*) self, " ", "</s>");
	_tmp58_ = _tmp57_;
	kkc_language_model_entry_copy (_tmp58_, &_tmp59_);
	kkc_language_model_entry_destroy (&self->priv->_eos);
	self->priv->_eos = _tmp59_;
	_kkc_language_model_entry_free0 (_tmp58_);
	result = TRUE;
	_g_free0 (bigram_filter_filename);
	_g_free0 (unigram_trie_filename);
	_g_free0 (input_trie_filename);
	_g_free0 (prefix);
	return result;
}


KkcSortedBigramLanguageModel* kkc_sorted_bigram_language_model_construct (GType object_type, KkcLanguageModelMetadata* metadata, GError** error) {
	KkcSortedBigramLanguageModel * self = NULL;
	KkcLanguageModelMetadata* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (metadata != NULL, NULL);
	_tmp0_ = metadata;
	self = (KkcSortedBigramLanguageModel*) kkc_language_model_construct (object_type, _tmp0_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}


KkcSortedBigramLanguageModel* kkc_sorted_bigram_language_model_new (KkcLanguageModelMetadata* metadata, GError** error) {
	return kkc_sorted_bigram_language_model_construct (KKC_TYPE_SORTED_BIGRAM_LANGUAGE_MODEL, metadata, error);
}


static void kkc_sorted_bigram_language_model_real_get_bos (KkcLanguageModel* base, KkcLanguageModelEntry* result) {
	KkcSortedBigramLanguageModel* self;
	KkcLanguageModelEntry _tmp0_ = {0};
	self = (KkcSortedBigramLanguageModel*) base;
	_tmp0_ = self->priv->_bos;
	*result = _tmp0_;
	return;
}


static void kkc_sorted_bigram_language_model_real_get_eos (KkcLanguageModel* base, KkcLanguageModelEntry* result) {
	KkcSortedBigramLanguageModel* self;
	KkcLanguageModelEntry _tmp0_ = {0};
	self = (KkcSortedBigramLanguageModel*) base;
	_tmp0_ = self->priv->_eos;
	*result = _tmp0_;
	return;
}


gdouble kkc_sorted_bigram_language_model_get_min_cost (KkcSortedBigramLanguageModel* self) {
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = -8.0;
	return result;
}


static void kkc_sorted_bigram_language_model_class_init (KkcSortedBigramLanguageModelClass * klass) {
	kkc_sorted_bigram_language_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KkcSortedBigramLanguageModelPrivate));
	((KkcLanguageModelClass *) klass)->unigram_entries = kkc_sorted_bigram_language_model_real_unigram_entries;
	((KkcLanguageModelClass *) klass)->entries = kkc_sorted_bigram_language_model_real_entries;
	((KkcLanguageModelClass *) klass)->get = kkc_sorted_bigram_language_model_real_get;
	((KkcLanguageModelClass *) klass)->parse = kkc_sorted_bigram_language_model_real_parse;
	KKC_LANGUAGE_MODEL_CLASS (klass)->get_bos = kkc_sorted_bigram_language_model_real_get_bos;
	KKC_LANGUAGE_MODEL_CLASS (klass)->get_eos = kkc_sorted_bigram_language_model_real_get_eos;
	G_OBJECT_CLASS (klass)->get_property = _vala_kkc_sorted_bigram_language_model_get_property;
	G_OBJECT_CLASS (klass)->finalize = kkc_sorted_bigram_language_model_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_SORTED_BIGRAM_LANGUAGE_MODEL_BOS, g_param_spec_boxed ("bos", "bos", "bos", KKC_TYPE_LANGUAGE_MODEL_ENTRY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_SORTED_BIGRAM_LANGUAGE_MODEL_EOS, g_param_spec_boxed ("eos", "eos", "eos", KKC_TYPE_LANGUAGE_MODEL_ENTRY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_SORTED_BIGRAM_LANGUAGE_MODEL_MIN_COST, g_param_spec_double ("min-cost", "min-cost", "min-cost", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void kkc_sorted_bigram_language_model_kkc_unigram_language_model_interface_init (KkcUnigramLanguageModelIface * iface) {
	kkc_sorted_bigram_language_model_kkc_unigram_language_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->unigram_cost = (gdouble (*)(KkcUnigramLanguageModel*, KkcLanguageModelEntry*)) kkc_sorted_bigram_language_model_real_unigram_cost;
	iface->unigram_backoff = (gdouble (*)(KkcUnigramLanguageModel*, KkcLanguageModelEntry*)) kkc_sorted_bigram_language_model_real_unigram_backoff;
}


static void kkc_sorted_bigram_language_model_kkc_bigram_language_model_interface_init (KkcBigramLanguageModelIface * iface) {
	kkc_sorted_bigram_language_model_kkc_bigram_language_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->has_bigram = (gboolean (*)(KkcBigramLanguageModel*, KkcLanguageModelEntry*, KkcLanguageModelEntry*)) kkc_sorted_bigram_language_model_real_has_bigram;
	iface->bigram_cost = (gdouble (*)(KkcBigramLanguageModel*, KkcLanguageModelEntry*, KkcLanguageModelEntry*)) kkc_sorted_bigram_language_model_real_bigram_cost;
	iface->bigram_backoff = (gdouble (*)(KkcBigramLanguageModel*, KkcLanguageModelEntry*, KkcLanguageModelEntry*)) kkc_sorted_bigram_language_model_real_bigram_backoff;
}


static void kkc_sorted_bigram_language_model_instance_init (KkcSortedBigramLanguageModel * self) {
	MarisaTrie* _tmp0_ = NULL;
	MarisaTrie* _tmp1_ = NULL;
	self->priv = KKC_SORTED_BIGRAM_LANGUAGE_MODEL_GET_PRIVATE (self);
	_tmp0_ = marisa_trie_new ();
	self->priv->input_trie = _tmp0_;
	_tmp1_ = marisa_trie_new ();
	self->priv->unigram_trie = _tmp1_;
	self->priv->bigram_filter = NULL;
	self->priv->last_value = (guint32) 0;
	self->priv->last_pvalue = (guint32) 0;
	self->priv->last_offset = (glong) 0;
}


static void kkc_sorted_bigram_language_model_finalize (GObject* obj) {
	KkcSortedBigramLanguageModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_TYPE_SORTED_BIGRAM_LANGUAGE_MODEL, KkcSortedBigramLanguageModel);
	kkc_language_model_entry_destroy (&self->priv->_bos);
	kkc_language_model_entry_destroy (&self->priv->_eos);
	_g_object_unref0 (self->priv->input_trie);
	_g_object_unref0 (self->priv->unigram_trie);
	_g_object_unref0 (self->priv->unigram_index);
	_g_object_unref0 (self->priv->bigram_index);
	_g_object_unref0 (self->priv->bigram_filter);
	G_OBJECT_CLASS (kkc_sorted_bigram_language_model_parent_class)->finalize (obj);
}


GType kkc_sorted_bigram_language_model_get_type (void) {
	static volatile gsize kkc_sorted_bigram_language_model_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_sorted_bigram_language_model_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcSortedBigramLanguageModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_sorted_bigram_language_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcSortedBigramLanguageModel), 0, (GInstanceInitFunc) kkc_sorted_bigram_language_model_instance_init, NULL };
		static const GInterfaceInfo kkc_unigram_language_model_info = { (GInterfaceInitFunc) kkc_sorted_bigram_language_model_kkc_unigram_language_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo kkc_bigram_language_model_info = { (GInterfaceInitFunc) kkc_sorted_bigram_language_model_kkc_bigram_language_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType kkc_sorted_bigram_language_model_type_id;
		kkc_sorted_bigram_language_model_type_id = g_type_register_static (KKC_TYPE_LANGUAGE_MODEL, "KkcSortedBigramLanguageModel", &g_define_type_info, 0);
		g_type_add_interface_static (kkc_sorted_bigram_language_model_type_id, KKC_TYPE_UNIGRAM_LANGUAGE_MODEL, &kkc_unigram_language_model_info);
		g_type_add_interface_static (kkc_sorted_bigram_language_model_type_id, KKC_TYPE_BIGRAM_LANGUAGE_MODEL, &kkc_bigram_language_model_info);
		g_once_init_leave (&kkc_sorted_bigram_language_model_type_id__volatile, kkc_sorted_bigram_language_model_type_id);
	}
	return kkc_sorted_bigram_language_model_type_id__volatile;
}


static void _vala_kkc_sorted_bigram_language_model_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	KkcSortedBigramLanguageModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KKC_TYPE_SORTED_BIGRAM_LANGUAGE_MODEL, KkcSortedBigramLanguageModel);
	switch (property_id) {
		case KKC_SORTED_BIGRAM_LANGUAGE_MODEL_BOS:
		{
			KkcLanguageModelEntry boxed;
			kkc_language_model_get_bos ((KkcLanguageModel*) self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case KKC_SORTED_BIGRAM_LANGUAGE_MODEL_EOS:
		{
			KkcLanguageModelEntry boxed;
			kkc_language_model_get_eos ((KkcLanguageModel*) self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case KKC_SORTED_BIGRAM_LANGUAGE_MODEL_MIN_COST:
		g_value_set_double (value, kkc_sorted_bigram_language_model_get_min_cost (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



