.TH "ZIP_SOURCE_GET_ARGS" "3" "December 18, 2017" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBZIP_SOURCE_GET_ARGS\fR
\- validate and cast arguments to source callback
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fItype *\fR
.br
.PD 0
.HP 4n
\fBZIP_SOURCE_GET_ARGS\fR(\fItype\fR, \fIvoid\ *data\fR, \fIzip_uint64_t\ len\fR, \fIzip_error_t\ *error\fR);
.PD
.SH "DESCRIPTION"
The
\fBZIP_SOURCE_GET_ARGS\fR()
macro casts
\fIdata\fR
to a pointer to
\fItype\fR.
.SH "RETURN VALUES"
On success,
\fBZIP_SOURCE_GET_ARGS\fR()
returns
\fIdata\fR.
In case of error, it returns
\fRNULL\fR
and sets
\fIerror\fR.
.SH "ERRORS"
\fBZIP_SOURCE_GET_ARGS\fR()
fails if:
.TP 19n
[\fRZIP_ER_INVAL\fR]
\fIlen\fR
is less than the size of
\fItype\fR
.SH "SEE ALSO"
libzip(3),
zip_source_function(3)
.SH "HISTORY"
\fBZIP_SOURCE_GET_ARGS\fR()
was added in libzip 1.0.
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
