; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=thumbv8.1m.main-none-none-eabi -mattr=+mve -verify-machineinstrs %s -o - | FileCheck %s --check-prefix=CHECK

define arm_aapcs_vfpcc i32 @add_v4i32_v4i32(<4 x i32> %x, <4 x i32> %b) {
; CHECK-LABEL: add_v4i32_v4i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q1, zr
; CHECK-NEXT:    vaddvt.u32 r0, q0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i32> %b, zeroinitializer
  %s = select <4 x i1> %c, <4 x i32> %x, <4 x i32> zeroinitializer
  %z = call i32 @llvm.vector.reduce.add.v4i32(<4 x i32> %s)
  ret i32 %z
}

define arm_aapcs_vfpcc i64 @add_v4i32_v4i64_zext(<4 x i32> %x, <4 x i32> %b) {
; CHECK-LABEL: add_v4i32_v4i64_zext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q1, zr
; CHECK-NEXT:    vaddlvt.u32 r0, r1, q0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i32> %b, zeroinitializer
  %xx = zext <4 x i32> %x to <4 x i64>
  %s = select <4 x i1> %c, <4 x i64> %xx, <4 x i64> zeroinitializer
  %z = call i64 @llvm.vector.reduce.add.v4i64(<4 x i64> %s)
  ret i64 %z
}

define arm_aapcs_vfpcc i64 @add_v4i32_v4i64_sext(<4 x i32> %x, <4 x i32> %b) {
; CHECK-LABEL: add_v4i32_v4i64_sext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q1, zr
; CHECK-NEXT:    vaddlvt.s32 r0, r1, q0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i32> %b, zeroinitializer
  %xx = sext <4 x i32> %x to <4 x i64>
  %s = select <4 x i1> %c, <4 x i64> %xx, <4 x i64> zeroinitializer
  %z = call i64 @llvm.vector.reduce.add.v4i64(<4 x i64> %s)
  ret i64 %z
}

define arm_aapcs_vfpcc i64 @add_v2i32_v2i64_zext(<2 x i32> %x, <2 x i32> %b) {
; CHECK-LABEL: add_v2i32_v2i64_zext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov r0, s4
; CHECK-NEXT:    movs r1, #0
; CHECK-NEXT:    vmov.i64 q2, #0xffffffff
; CHECK-NEXT:    vand q0, q0, q2
; CHECK-NEXT:    cmp r0, #0
; CHECK-NEXT:    csetm r0, eq
; CHECK-NEXT:    bfi r1, r0, #0, #8
; CHECK-NEXT:    vmov r0, s6
; CHECK-NEXT:    vmov.i32 q1, #0x0
; CHECK-NEXT:    cmp r0, #0
; CHECK-NEXT:    csetm r0, eq
; CHECK-NEXT:    bfi r1, r0, #8, #8
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    vmov r0, r1, d1
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <2 x i32> %b, zeroinitializer
  %xx = zext <2 x i32> %x to <2 x i64>
  %s = select <2 x i1> %c, <2 x i64> %xx, <2 x i64> zeroinitializer
  %z = call i64 @llvm.vector.reduce.add.v2i64(<2 x i64> %s)
  ret i64 %z
}

define arm_aapcs_vfpcc i64 @add_v2i32_v2i64_sext(<2 x i32> %x, <2 x i32> %b) {
; CHECK-LABEL: add_v2i32_v2i64_sext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov r0, s2
; CHECK-NEXT:    vmov r1, s0
; CHECK-NEXT:    vmov q0[2], q0[0], r1, r0
; CHECK-NEXT:    asrs r0, r0, #31
; CHECK-NEXT:    asrs r1, r1, #31
; CHECK-NEXT:    vmov q0[3], q0[1], r1, r0
; CHECK-NEXT:    vmov r0, s4
; CHECK-NEXT:    movs r1, #0
; CHECK-NEXT:    cmp r0, #0
; CHECK-NEXT:    csetm r0, eq
; CHECK-NEXT:    bfi r1, r0, #0, #8
; CHECK-NEXT:    vmov r0, s6
; CHECK-NEXT:    vmov.i32 q1, #0x0
; CHECK-NEXT:    cmp r0, #0
; CHECK-NEXT:    csetm r0, eq
; CHECK-NEXT:    bfi r1, r0, #8, #8
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    vmov r0, r1, d1
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <2 x i32> %b, zeroinitializer
  %xx = sext <2 x i32> %x to <2 x i64>
  %s = select <2 x i1> %c, <2 x i64> %xx, <2 x i64> zeroinitializer
  %z = call i64 @llvm.vector.reduce.add.v2i64(<2 x i64> %s)
  ret i64 %z
}

define arm_aapcs_vfpcc i32 @add_v8i16_v8i32_zext(<8 x i16> %x, <8 x i16> %b) {
; CHECK-LABEL: add_v8i16_v8i32_zext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i16 eq, q1, zr
; CHECK-NEXT:    vaddvt.u16 r0, q0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i16> %b, zeroinitializer
  %xx = zext <8 x i16> %x to <8 x i32>
  %s = select <8 x i1> %c, <8 x i32> %xx, <8 x i32> zeroinitializer
  %z = call i32 @llvm.vector.reduce.add.v8i32(<8 x i32> %s)
  ret i32 %z
}

define arm_aapcs_vfpcc i32 @add_v8i16_v8i32_sext(<8 x i16> %x, <8 x i16> %b) {
; CHECK-LABEL: add_v8i16_v8i32_sext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i16 eq, q1, zr
; CHECK-NEXT:    vaddvt.s16 r0, q0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i16> %b, zeroinitializer
  %xx = sext <8 x i16> %x to <8 x i32>
  %s = select <8 x i1> %c, <8 x i32> %xx, <8 x i32> zeroinitializer
  %z = call i32 @llvm.vector.reduce.add.v8i32(<8 x i32> %s)
  ret i32 %z
}

define arm_aapcs_vfpcc i32 @add_v4i16_v4i32_zext(<4 x i16> %x, <4 x i16> %b) {
; CHECK-LABEL: add_v4i16_v4i32_zext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmovlb.u16 q1, q1
; CHECK-NEXT:    vmovlb.u16 q0, q0
; CHECK-NEXT:    vpt.i32 eq, q1, zr
; CHECK-NEXT:    vaddvt.u32 r0, q0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i16> %b, zeroinitializer
  %xx = zext <4 x i16> %x to <4 x i32>
  %s = select <4 x i1> %c, <4 x i32> %xx, <4 x i32> zeroinitializer
  %z = call i32 @llvm.vector.reduce.add.v4i32(<4 x i32> %s)
  ret i32 %z
}

define arm_aapcs_vfpcc i32 @add_v4i16_v4i32_sext(<4 x i16> %x, <4 x i16> %b) {
; CHECK-LABEL: add_v4i16_v4i32_sext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmovlb.u16 q1, q1
; CHECK-NEXT:    vmovlb.s16 q0, q0
; CHECK-NEXT:    vpt.i32 eq, q1, zr
; CHECK-NEXT:    vaddvt.u32 r0, q0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i16> %b, zeroinitializer
  %xx = sext <4 x i16> %x to <4 x i32>
  %s = select <4 x i1> %c, <4 x i32> %xx, <4 x i32> zeroinitializer
  %z = call i32 @llvm.vector.reduce.add.v4i32(<4 x i32> %s)
  ret i32 %z
}

define arm_aapcs_vfpcc zeroext i16 @add_v8i16_v8i16(<8 x i16> %x, <8 x i16> %b) {
; CHECK-LABEL: add_v8i16_v8i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i16 eq, q1, zr
; CHECK-NEXT:    vaddvt.u16 r0, q0
; CHECK-NEXT:    uxth r0, r0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i16> %b, zeroinitializer
  %s = select <8 x i1> %c, <8 x i16> %x, <8 x i16> zeroinitializer
  %z = call i16 @llvm.vector.reduce.add.v8i16(<8 x i16> %s)
  ret i16 %z
}

define arm_aapcs_vfpcc i64 @add_v8i16_v8i64_zext(<8 x i16> %x, <8 x i16> %b) {
; CHECK-LABEL: add_v8i16_v8i64_zext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vmov.i8 q3, #0x0
; CHECK-NEXT:    vmov.i8 q4, #0xff
; CHECK-NEXT:    vcmp.i16 eq, q1, zr
; CHECK-NEXT:    vpsel q5, q4, q3
; CHECK-NEXT:    vmov.u16 r0, q5[2]
; CHECK-NEXT:    vmov.u16 r1, q5[0]
; CHECK-NEXT:    vmov q1[2], q1[0], r1, r0
; CHECK-NEXT:    vmov.u16 r0, q5[3]
; CHECK-NEXT:    vmov.u16 r1, q5[1]
; CHECK-NEXT:    vmov q1[3], q1[1], r1, r0
; CHECK-NEXT:    vcmp.i32 ne, q1, zr
; CHECK-NEXT:    vpsel q6, q4, q3
; CHECK-NEXT:    vmov r0, r1, d12
; CHECK-NEXT:    vmov q1[2], q1[0], r0, r1
; CHECK-NEXT:    vmov q1[3], q1[1], r0, r1
; CHECK-NEXT:    vmov.u16 r0, q0[1]
; CHECK-NEXT:    vmov.u16 r1, q0[0]
; CHECK-NEXT:    vcmp.i32 ne, q1, zr
; CHECK-NEXT:    vmov q2[2], q2[0], r1, r0
; CHECK-NEXT:    vmov.i64 q1, #0xffff
; CHECK-NEXT:    vand q7, q2, q1
; CHECK-NEXT:    vmov.i32 q2, #0x0
; CHECK-NEXT:    vpsel q7, q7, q2
; CHECK-NEXT:    vmov r0, r1, d15
; CHECK-NEXT:    vmov r2, r3, d14
; CHECK-NEXT:    orrs r1, r3
; CHECK-NEXT:    add r0, r2
; CHECK-NEXT:    vmov r2, r3, d13
; CHECK-NEXT:    vmov q6[2], q6[0], r2, r3
; CHECK-NEXT:    vmov q6[3], q6[1], r2, r3
; CHECK-NEXT:    vmov.u16 r2, q0[3]
; CHECK-NEXT:    vmov.u16 r3, q0[2]
; CHECK-NEXT:    vcmp.i32 ne, q6, zr
; CHECK-NEXT:    vmov q6[2], q6[0], r3, r2
; CHECK-NEXT:    vand q6, q6, q1
; CHECK-NEXT:    vpsel q6, q6, q2
; CHECK-NEXT:    vmov r2, r3, d12
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d13
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    vmov.u16 r2, q5[6]
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov.u16 r3, q5[4]
; CHECK-NEXT:    vmov q6[2], q6[0], r3, r2
; CHECK-NEXT:    vmov.u16 r2, q5[7]
; CHECK-NEXT:    vmov.u16 r3, q5[5]
; CHECK-NEXT:    vmov q6[3], q6[1], r3, r2
; CHECK-NEXT:    vcmp.i32 ne, q6, zr
; CHECK-NEXT:    vpsel q3, q4, q3
; CHECK-NEXT:    vmov r2, r3, d6
; CHECK-NEXT:    vmov q4[2], q4[0], r2, r3
; CHECK-NEXT:    vmov q4[3], q4[1], r2, r3
; CHECK-NEXT:    vmov.u16 r2, q0[5]
; CHECK-NEXT:    vmov.u16 r3, q0[4]
; CHECK-NEXT:    vcmp.i32 ne, q4, zr
; CHECK-NEXT:    vmov q4[2], q4[0], r3, r2
; CHECK-NEXT:    vand q4, q4, q1
; CHECK-NEXT:    vpsel q4, q4, q2
; CHECK-NEXT:    vmov r2, r3, d8
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d9
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d7
; CHECK-NEXT:    vmov q3[2], q3[0], r2, r3
; CHECK-NEXT:    vmov q3[3], q3[1], r2, r3
; CHECK-NEXT:    vmov.u16 r2, q0[7]
; CHECK-NEXT:    vmov.u16 r3, q0[6]
; CHECK-NEXT:    vcmp.i32 ne, q3, zr
; CHECK-NEXT:    vmov q0[2], q0[0], r3, r2
; CHECK-NEXT:    vand q0, q0, q1
; CHECK-NEXT:    vpsel q0, q0, q2
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d1
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i16> %b, zeroinitializer
  %xx = zext <8 x i16> %x to <8 x i64>
  %s = select <8 x i1> %c, <8 x i64> %xx, <8 x i64> zeroinitializer
  %z = call i64 @llvm.vector.reduce.add.v8i64(<8 x i64> %s)
  ret i64 %z
}

define arm_aapcs_vfpcc i64 @add_v8i16_v8i64_sext(<8 x i16> %x, <8 x i16> %b) {
; CHECK-LABEL: add_v8i16_v8i64_sext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    vmov.i8 q2, #0x0
; CHECK-NEXT:    vmov.i8 q3, #0xff
; CHECK-NEXT:    vcmp.i16 eq, q1, zr
; CHECK-NEXT:    vpsel q4, q3, q2
; CHECK-NEXT:    vmov.u16 r0, q4[2]
; CHECK-NEXT:    vmov.u16 r1, q4[0]
; CHECK-NEXT:    vmov q1[2], q1[0], r1, r0
; CHECK-NEXT:    vmov.u16 r0, q4[3]
; CHECK-NEXT:    vmov.u16 r1, q4[1]
; CHECK-NEXT:    vmov q1[3], q1[1], r1, r0
; CHECK-NEXT:    vcmp.i32 ne, q1, zr
; CHECK-NEXT:    vpsel q5, q3, q2
; CHECK-NEXT:    vmov r0, r1, d10
; CHECK-NEXT:    vmov q1[2], q1[0], r0, r1
; CHECK-NEXT:    vmov q1[3], q1[1], r0, r1
; CHECK-NEXT:    vmov.s16 r0, q0[1]
; CHECK-NEXT:    vmov.s16 r1, q0[0]
; CHECK-NEXT:    vcmp.i32 ne, q1, zr
; CHECK-NEXT:    vmov q6[2], q6[0], r1, r0
; CHECK-NEXT:    asrs r0, r0, #31
; CHECK-NEXT:    asrs r1, r1, #31
; CHECK-NEXT:    vmov.i32 q1, #0x0
; CHECK-NEXT:    vmov q6[3], q6[1], r1, r0
; CHECK-NEXT:    vpsel q6, q6, q1
; CHECK-NEXT:    vmov r0, r1, d13
; CHECK-NEXT:    vmov r2, r3, d12
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d11
; CHECK-NEXT:    vmov q5[2], q5[0], r2, r3
; CHECK-NEXT:    vmov q5[3], q5[1], r2, r3
; CHECK-NEXT:    vmov.s16 r2, q0[3]
; CHECK-NEXT:    vmov.s16 r3, q0[2]
; CHECK-NEXT:    vcmp.i32 ne, q5, zr
; CHECK-NEXT:    vmov q5[2], q5[0], r3, r2
; CHECK-NEXT:    asrs r2, r2, #31
; CHECK-NEXT:    asrs r3, r3, #31
; CHECK-NEXT:    vmov q5[3], q5[1], r3, r2
; CHECK-NEXT:    vpsel q5, q5, q1
; CHECK-NEXT:    vmov r2, r3, d10
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d11
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    vmov.u16 r2, q4[6]
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov.u16 r3, q4[4]
; CHECK-NEXT:    vmov q5[2], q5[0], r3, r2
; CHECK-NEXT:    vmov.u16 r2, q4[7]
; CHECK-NEXT:    vmov.u16 r3, q4[5]
; CHECK-NEXT:    vmov q5[3], q5[1], r3, r2
; CHECK-NEXT:    vcmp.i32 ne, q5, zr
; CHECK-NEXT:    vpsel q2, q3, q2
; CHECK-NEXT:    vmov r2, r3, d4
; CHECK-NEXT:    vmov q3[2], q3[0], r2, r3
; CHECK-NEXT:    vmov q3[3], q3[1], r2, r3
; CHECK-NEXT:    vmov.s16 r2, q0[5]
; CHECK-NEXT:    vmov.s16 r3, q0[4]
; CHECK-NEXT:    vcmp.i32 ne, q3, zr
; CHECK-NEXT:    vmov q3[2], q3[0], r3, r2
; CHECK-NEXT:    asrs r2, r2, #31
; CHECK-NEXT:    asrs r3, r3, #31
; CHECK-NEXT:    vmov q3[3], q3[1], r3, r2
; CHECK-NEXT:    vpsel q3, q3, q1
; CHECK-NEXT:    vmov r2, r3, d6
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d7
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d5
; CHECK-NEXT:    vmov q2[2], q2[0], r2, r3
; CHECK-NEXT:    vmov q2[3], q2[1], r2, r3
; CHECK-NEXT:    vmov.s16 r2, q0[7]
; CHECK-NEXT:    vmov.s16 r3, q0[6]
; CHECK-NEXT:    vcmp.i32 ne, q2, zr
; CHECK-NEXT:    vmov q0[2], q0[0], r3, r2
; CHECK-NEXT:    asrs r2, r2, #31
; CHECK-NEXT:    asrs r3, r3, #31
; CHECK-NEXT:    vmov q0[3], q0[1], r3, r2
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d1
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i16> %b, zeroinitializer
  %xx = sext <8 x i16> %x to <8 x i64>
  %s = select <8 x i1> %c, <8 x i64> %xx, <8 x i64> zeroinitializer
  %z = call i64 @llvm.vector.reduce.add.v8i64(<8 x i64> %s)
  ret i64 %z
}

define arm_aapcs_vfpcc i64 @add_v4i16_v4i64_zext(<4 x i16> %x, <4 x i16> %b) {
; CHECK-LABEL: add_v4i16_v4i64_zext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmovlb.u16 q1, q1
; CHECK-NEXT:    vmovlb.u16 q0, q0
; CHECK-NEXT:    vpt.i32 eq, q1, zr
; CHECK-NEXT:    vaddlvt.u32 r0, r1, q0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i16> %b, zeroinitializer
  %xx = zext <4 x i16> %x to <4 x i64>
  %s = select <4 x i1> %c, <4 x i64> %xx, <4 x i64> zeroinitializer
  %z = call i64 @llvm.vector.reduce.add.v4i64(<4 x i64> %s)
  ret i64 %z
}

define arm_aapcs_vfpcc i64 @add_v4i16_v4i64_sext(<4 x i16> %x, <4 x i16> %b) {
; CHECK-LABEL: add_v4i16_v4i64_sext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmovlb.u16 q1, q1
; CHECK-NEXT:    vmovlb.s16 q0, q0
; CHECK-NEXT:    vpt.i32 eq, q1, zr
; CHECK-NEXT:    vaddlvt.s32 r0, r1, q0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i16> %b, zeroinitializer
  %xx = sext <4 x i16> %x to <4 x i64>
  %s = select <4 x i1> %c, <4 x i64> %xx, <4 x i64> zeroinitializer
  %z = call i64 @llvm.vector.reduce.add.v4i64(<4 x i64> %s)
  ret i64 %z
}

define arm_aapcs_vfpcc i64 @add_v2i16_v2i64_zext(<2 x i16> %x, <2 x i16> %b) {
; CHECK-LABEL: add_v2i16_v2i64_zext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.i64 q2, #0xffff
; CHECK-NEXT:    movs r1, #0
; CHECK-NEXT:    vand q1, q1, q2
; CHECK-NEXT:    vand q0, q0, q2
; CHECK-NEXT:    vmov r0, s4
; CHECK-NEXT:    cmp r0, #0
; CHECK-NEXT:    csetm r0, eq
; CHECK-NEXT:    bfi r1, r0, #0, #8
; CHECK-NEXT:    vmov r0, s6
; CHECK-NEXT:    vmov.i32 q1, #0x0
; CHECK-NEXT:    cmp r0, #0
; CHECK-NEXT:    csetm r0, eq
; CHECK-NEXT:    bfi r1, r0, #8, #8
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    vmov r0, r1, d1
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    add r0, r2
; CHECK-NEXT:    orrs r1, r3
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <2 x i16> %b, zeroinitializer
  %xx = zext <2 x i16> %x to <2 x i64>
  %s = select <2 x i1> %c, <2 x i64> %xx, <2 x i64> zeroinitializer
  %z = call i64 @llvm.vector.reduce.add.v2i64(<2 x i64> %s)
  ret i64 %z
}

define arm_aapcs_vfpcc i64 @add_v2i16_v2i64_sext(<2 x i16> %x, <2 x i16> %b) {
; CHECK-LABEL: add_v2i16_v2i64_sext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.i32 q2, #0xffff
; CHECK-NEXT:    movs r1, #0
; CHECK-NEXT:    vand q1, q1, q2
; CHECK-NEXT:    vmov r0, s4
; CHECK-NEXT:    cmp r0, #0
; CHECK-NEXT:    csetm r0, eq
; CHECK-NEXT:    bfi r1, r0, #0, #8
; CHECK-NEXT:    vmov r0, s6
; CHECK-NEXT:    vmov.i32 q1, #0x0
; CHECK-NEXT:    cmp r0, #0
; CHECK-NEXT:    csetm r0, eq
; CHECK-NEXT:    bfi r1, r0, #8, #8
; CHECK-NEXT:    vmov r0, s2
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vmov r1, s0
; CHECK-NEXT:    sxth r0, r0
; CHECK-NEXT:    sxth r1, r1
; CHECK-NEXT:    vmov q0[2], q0[0], r1, r0
; CHECK-NEXT:    asrs r0, r0, #31
; CHECK-NEXT:    asrs r1, r1, #31
; CHECK-NEXT:    vmov q0[3], q0[1], r1, r0
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    vmov r0, r1, d1
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <2 x i16> %b, zeroinitializer
  %xx = sext <2 x i16> %x to <2 x i64>
  %s = select <2 x i1> %c, <2 x i64> %xx, <2 x i64> zeroinitializer
  %z = call i64 @llvm.vector.reduce.add.v2i64(<2 x i64> %s)
  ret i64 %z
}

define arm_aapcs_vfpcc i32 @add_v16i8_v16i32_zext(<16 x i8> %x, <16 x i8> %b) {
; CHECK-LABEL: add_v16i8_v16i32_zext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i8 eq, q1, zr
; CHECK-NEXT:    vaddvt.u8 r0, q0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <16 x i8> %b, zeroinitializer
  %xx = zext <16 x i8> %x to <16 x i32>
  %s = select <16 x i1> %c, <16 x i32> %xx, <16 x i32> zeroinitializer
  %z = call i32 @llvm.vector.reduce.add.v16i32(<16 x i32> %s)
  ret i32 %z
}

define arm_aapcs_vfpcc i32 @add_v16i8_v16i32_sext(<16 x i8> %x, <16 x i8> %b) {
; CHECK-LABEL: add_v16i8_v16i32_sext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i8 eq, q1, zr
; CHECK-NEXT:    vaddvt.s8 r0, q0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <16 x i8> %b, zeroinitializer
  %xx = sext <16 x i8> %x to <16 x i32>
  %s = select <16 x i1> %c, <16 x i32> %xx, <16 x i32> zeroinitializer
  %z = call i32 @llvm.vector.reduce.add.v16i32(<16 x i32> %s)
  ret i32 %z
}

define arm_aapcs_vfpcc i32 @add_v8i8_v8i32_zext(<8 x i8> %x, <8 x i8> %b) {
; CHECK-LABEL: add_v8i8_v8i32_zext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmovlb.u8 q1, q1
; CHECK-NEXT:    vmovlb.u8 q0, q0
; CHECK-NEXT:    vpt.i16 eq, q1, zr
; CHECK-NEXT:    vaddvt.u16 r0, q0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i8> %b, zeroinitializer
  %xx = zext <8 x i8> %x to <8 x i32>
  %s = select <8 x i1> %c, <8 x i32> %xx, <8 x i32> zeroinitializer
  %z = call i32 @llvm.vector.reduce.add.v8i32(<8 x i32> %s)
  ret i32 %z
}

define arm_aapcs_vfpcc i32 @add_v8i8_v8i32_sext(<8 x i8> %x, <8 x i8> %b) {
; CHECK-LABEL: add_v8i8_v8i32_sext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmovlb.u8 q1, q1
; CHECK-NEXT:    vmovlb.s8 q0, q0
; CHECK-NEXT:    vpt.i16 eq, q1, zr
; CHECK-NEXT:    vaddvt.s16 r0, q0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i8> %b, zeroinitializer
  %xx = sext <8 x i8> %x to <8 x i32>
  %s = select <8 x i1> %c, <8 x i32> %xx, <8 x i32> zeroinitializer
  %z = call i32 @llvm.vector.reduce.add.v8i32(<8 x i32> %s)
  ret i32 %z
}

define arm_aapcs_vfpcc i32 @add_v4i8_v4i32_zext(<4 x i8> %x, <4 x i8> %b) {
; CHECK-LABEL: add_v4i8_v4i32_zext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.i32 q2, #0xff
; CHECK-NEXT:    vand q1, q1, q2
; CHECK-NEXT:    vand q0, q0, q2
; CHECK-NEXT:    vpt.i32 eq, q1, zr
; CHECK-NEXT:    vaddvt.u32 r0, q0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i8> %b, zeroinitializer
  %xx = zext <4 x i8> %x to <4 x i32>
  %s = select <4 x i1> %c, <4 x i32> %xx, <4 x i32> zeroinitializer
  %z = call i32 @llvm.vector.reduce.add.v4i32(<4 x i32> %s)
  ret i32 %z
}

define arm_aapcs_vfpcc i32 @add_v4i8_v4i32_sext(<4 x i8> %x, <4 x i8> %b) {
; CHECK-LABEL: add_v4i8_v4i32_sext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.i32 q2, #0xff
; CHECK-NEXT:    vmovlb.s8 q0, q0
; CHECK-NEXT:    vand q1, q1, q2
; CHECK-NEXT:    vmovlb.s16 q0, q0
; CHECK-NEXT:    vpt.i32 eq, q1, zr
; CHECK-NEXT:    vaddvt.u32 r0, q0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i8> %b, zeroinitializer
  %xx = sext <4 x i8> %x to <4 x i32>
  %s = select <4 x i1> %c, <4 x i32> %xx, <4 x i32> zeroinitializer
  %z = call i32 @llvm.vector.reduce.add.v4i32(<4 x i32> %s)
  ret i32 %z
}

define arm_aapcs_vfpcc zeroext i16 @add_v16i8_v16i16_zext(<16 x i8> %x, <16 x i8> %b) {
; CHECK-LABEL: add_v16i8_v16i16_zext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i8 eq, q1, zr
; CHECK-NEXT:    vaddvt.u8 r0, q0
; CHECK-NEXT:    uxth r0, r0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <16 x i8> %b, zeroinitializer
  %xx = zext <16 x i8> %x to <16 x i16>
  %s = select <16 x i1> %c, <16 x i16> %xx, <16 x i16> zeroinitializer
  %z = call i16 @llvm.vector.reduce.add.v16i16(<16 x i16> %s)
  ret i16 %z
}

define arm_aapcs_vfpcc signext i16 @add_v16i8_v16i16_sext(<16 x i8> %x, <16 x i8> %b) {
; CHECK-LABEL: add_v16i8_v16i16_sext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i8 eq, q1, zr
; CHECK-NEXT:    vaddvt.s8 r0, q0
; CHECK-NEXT:    sxth r0, r0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <16 x i8> %b, zeroinitializer
  %xx = sext <16 x i8> %x to <16 x i16>
  %s = select <16 x i1> %c, <16 x i16> %xx, <16 x i16> zeroinitializer
  %z = call i16 @llvm.vector.reduce.add.v16i16(<16 x i16> %s)
  ret i16 %z
}

define arm_aapcs_vfpcc zeroext i16 @add_v8i8_v8i16_zext(<8 x i8> %x, <8 x i8> %b) {
; CHECK-LABEL: add_v8i8_v8i16_zext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmovlb.u8 q1, q1
; CHECK-NEXT:    vmovlb.u8 q0, q0
; CHECK-NEXT:    vpt.i16 eq, q1, zr
; CHECK-NEXT:    vaddvt.u16 r0, q0
; CHECK-NEXT:    uxth r0, r0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i8> %b, zeroinitializer
  %xx = zext <8 x i8> %x to <8 x i16>
  %s = select <8 x i1> %c, <8 x i16> %xx, <8 x i16> zeroinitializer
  %z = call i16 @llvm.vector.reduce.add.v8i16(<8 x i16> %s)
  ret i16 %z
}

define arm_aapcs_vfpcc signext i16 @add_v8i8_v8i16_sext(<8 x i8> %x, <8 x i8> %b) {
; CHECK-LABEL: add_v8i8_v8i16_sext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmovlb.u8 q1, q1
; CHECK-NEXT:    vmovlb.s8 q0, q0
; CHECK-NEXT:    vpt.i16 eq, q1, zr
; CHECK-NEXT:    vaddvt.u16 r0, q0
; CHECK-NEXT:    sxth r0, r0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i8> %b, zeroinitializer
  %xx = sext <8 x i8> %x to <8 x i16>
  %s = select <8 x i1> %c, <8 x i16> %xx, <8 x i16> zeroinitializer
  %z = call i16 @llvm.vector.reduce.add.v8i16(<8 x i16> %s)
  ret i16 %z
}

define arm_aapcs_vfpcc zeroext i8 @add_v16i8_v16i8(<16 x i8> %x, <16 x i8> %b) {
; CHECK-LABEL: add_v16i8_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i8 eq, q1, zr
; CHECK-NEXT:    vaddvt.u8 r0, q0
; CHECK-NEXT:    uxtb r0, r0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <16 x i8> %b, zeroinitializer
  %s = select <16 x i1> %c, <16 x i8> %x, <16 x i8> zeroinitializer
  %z = call i8 @llvm.vector.reduce.add.v16i8(<16 x i8> %s)
  ret i8 %z
}

define arm_aapcs_vfpcc i64 @add_v16i8_v16i64_zext(<16 x i8> %x, <16 x i8> %b) {
; CHECK-LABEL: add_v16i8_v16i64_zext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    .pad #16
; CHECK-NEXT:    sub sp, #16
; CHECK-NEXT:    vmov q2, q0
; CHECK-NEXT:    vcmp.i8 eq, q1, zr
; CHECK-NEXT:    vmov.i8 q0, #0x0
; CHECK-NEXT:    vmov.i8 q1, #0xff
; CHECK-NEXT:    vpsel q5, q1, q0
; CHECK-NEXT:    vstrw.32 q0, [sp] @ 16-byte Spill
; CHECK-NEXT:    vmov.u8 r0, q5[0]
; CHECK-NEXT:    vmov.16 q3[0], r0
; CHECK-NEXT:    vmov.u8 r0, q5[1]
; CHECK-NEXT:    vmov.16 q3[1], r0
; CHECK-NEXT:    vmov.u8 r0, q5[2]
; CHECK-NEXT:    vmov.16 q3[2], r0
; CHECK-NEXT:    vmov.u8 r0, q5[3]
; CHECK-NEXT:    vmov.16 q3[3], r0
; CHECK-NEXT:    vmov.u8 r0, q5[4]
; CHECK-NEXT:    vmov.16 q3[4], r0
; CHECK-NEXT:    vmov.u8 r0, q5[5]
; CHECK-NEXT:    vmov.16 q3[5], r0
; CHECK-NEXT:    vmov.u8 r0, q5[6]
; CHECK-NEXT:    vmov.16 q3[6], r0
; CHECK-NEXT:    vmov.u8 r0, q5[7]
; CHECK-NEXT:    vmov.16 q3[7], r0
; CHECK-NEXT:    vcmp.i16 ne, q3, zr
; CHECK-NEXT:    vpsel q6, q1, q0
; CHECK-NEXT:    vmov.u16 r0, q6[2]
; CHECK-NEXT:    vmov.u16 r1, q6[0]
; CHECK-NEXT:    vmov q3[2], q3[0], r1, r0
; CHECK-NEXT:    vmov.u16 r0, q6[3]
; CHECK-NEXT:    vmov.u16 r1, q6[1]
; CHECK-NEXT:    vmov q3[3], q3[1], r1, r0
; CHECK-NEXT:    vcmp.i32 ne, q3, zr
; CHECK-NEXT:    vpsel q7, q1, q0
; CHECK-NEXT:    vmov r0, r1, d14
; CHECK-NEXT:    vmov q3[2], q3[0], r0, r1
; CHECK-NEXT:    vmov q3[3], q3[1], r0, r1
; CHECK-NEXT:    vmov.u8 r0, q2[1]
; CHECK-NEXT:    vmov.u8 r1, q2[0]
; CHECK-NEXT:    vcmp.i32 ne, q3, zr
; CHECK-NEXT:    vmov q4[2], q4[0], r1, r0
; CHECK-NEXT:    vmov.i64 q3, #0xff
; CHECK-NEXT:    vand q0, q4, q3
; CHECK-NEXT:    vmov.i32 q4, #0x0
; CHECK-NEXT:    vpsel q0, q0, q4
; CHECK-NEXT:    vmov r0, r1, d1
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    orrs r1, r3
; CHECK-NEXT:    add r0, r2
; CHECK-NEXT:    vmov r2, r3, d15
; CHECK-NEXT:    vldrw.u32 q7, [sp] @ 16-byte Reload
; CHECK-NEXT:    vmov q0[2], q0[0], r2, r3
; CHECK-NEXT:    vmov q0[3], q0[1], r2, r3
; CHECK-NEXT:    vmov.u8 r2, q2[3]
; CHECK-NEXT:    vmov.u8 r3, q2[2]
; CHECK-NEXT:    vcmp.i32 ne, q0, zr
; CHECK-NEXT:    vmov q0[2], q0[0], r3, r2
; CHECK-NEXT:    vand q0, q0, q3
; CHECK-NEXT:    vpsel q0, q0, q4
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d1
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    vmov.u16 r2, q6[6]
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov.u16 r3, q6[4]
; CHECK-NEXT:    vmov q0[2], q0[0], r3, r2
; CHECK-NEXT:    vmov.u16 r2, q6[7]
; CHECK-NEXT:    vmov.u16 r3, q6[5]
; CHECK-NEXT:    vmov q0[3], q0[1], r3, r2
; CHECK-NEXT:    vcmp.i32 ne, q0, zr
; CHECK-NEXT:    vpsel q6, q1, q7
; CHECK-NEXT:    vmov r2, r3, d12
; CHECK-NEXT:    vmov q0[2], q0[0], r2, r3
; CHECK-NEXT:    vmov q0[3], q0[1], r2, r3
; CHECK-NEXT:    vmov.u8 r2, q2[5]
; CHECK-NEXT:    vmov.u8 r3, q2[4]
; CHECK-NEXT:    vcmp.i32 ne, q0, zr
; CHECK-NEXT:    vmov q0[2], q0[0], r3, r2
; CHECK-NEXT:    vand q0, q0, q3
; CHECK-NEXT:    vpsel q0, q0, q4
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d1
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d13
; CHECK-NEXT:    vmov q0[2], q0[0], r2, r3
; CHECK-NEXT:    vmov q0[3], q0[1], r2, r3
; CHECK-NEXT:    vmov.u8 r2, q2[7]
; CHECK-NEXT:    vmov.u8 r3, q2[6]
; CHECK-NEXT:    vcmp.i32 ne, q0, zr
; CHECK-NEXT:    vmov q0[2], q0[0], r3, r2
; CHECK-NEXT:    vand q0, q0, q3
; CHECK-NEXT:    vpsel q0, q0, q4
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d1
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    vmov.u8 r2, q5[8]
; CHECK-NEXT:    vmov.16 q6[0], r2
; CHECK-NEXT:    vmov.u8 r2, q5[9]
; CHECK-NEXT:    vmov.16 q6[1], r2
; CHECK-NEXT:    vmov.u8 r2, q5[10]
; CHECK-NEXT:    vmov.16 q6[2], r2
; CHECK-NEXT:    vmov.u8 r2, q5[11]
; CHECK-NEXT:    vmov.16 q6[3], r2
; CHECK-NEXT:    vmov.u8 r2, q5[12]
; CHECK-NEXT:    vmov.16 q6[4], r2
; CHECK-NEXT:    vmov.u8 r2, q5[13]
; CHECK-NEXT:    vmov.16 q6[5], r2
; CHECK-NEXT:    vmov.u8 r2, q5[14]
; CHECK-NEXT:    vmov.16 q6[6], r2
; CHECK-NEXT:    vmov.u8 r2, q5[15]
; CHECK-NEXT:    vmov.16 q6[7], r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vcmp.i16 ne, q6, zr
; CHECK-NEXT:    vpsel q5, q1, q7
; CHECK-NEXT:    vmov.u16 r2, q5[2]
; CHECK-NEXT:    vmov.u16 r3, q5[0]
; CHECK-NEXT:    vmov q0[2], q0[0], r3, r2
; CHECK-NEXT:    vmov.u16 r2, q5[3]
; CHECK-NEXT:    vmov.u16 r3, q5[1]
; CHECK-NEXT:    vmov q0[3], q0[1], r3, r2
; CHECK-NEXT:    vcmp.i32 ne, q0, zr
; CHECK-NEXT:    vpsel q6, q1, q7
; CHECK-NEXT:    vmov r2, r3, d12
; CHECK-NEXT:    vmov q0[2], q0[0], r2, r3
; CHECK-NEXT:    vmov q0[3], q0[1], r2, r3
; CHECK-NEXT:    vmov.u8 r2, q2[9]
; CHECK-NEXT:    vmov.u8 r3, q2[8]
; CHECK-NEXT:    vcmp.i32 ne, q0, zr
; CHECK-NEXT:    vmov q0[2], q0[0], r3, r2
; CHECK-NEXT:    vand q0, q0, q3
; CHECK-NEXT:    vpsel q0, q0, q4
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d1
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d13
; CHECK-NEXT:    vmov q0[2], q0[0], r2, r3
; CHECK-NEXT:    vmov q0[3], q0[1], r2, r3
; CHECK-NEXT:    vmov.u8 r2, q2[11]
; CHECK-NEXT:    vmov.u8 r3, q2[10]
; CHECK-NEXT:    vcmp.i32 ne, q0, zr
; CHECK-NEXT:    vmov q0[2], q0[0], r3, r2
; CHECK-NEXT:    vand q0, q0, q3
; CHECK-NEXT:    vpsel q0, q0, q4
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d1
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    vmov.u16 r2, q5[6]
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov.u16 r3, q5[4]
; CHECK-NEXT:    vmov q0[2], q0[0], r3, r2
; CHECK-NEXT:    vmov.u16 r2, q5[7]
; CHECK-NEXT:    vmov.u16 r3, q5[5]
; CHECK-NEXT:    vmov q0[3], q0[1], r3, r2
; CHECK-NEXT:    vcmp.i32 ne, q0, zr
; CHECK-NEXT:    vpsel q1, q1, q7
; CHECK-NEXT:    vmov r2, r3, d2
; CHECK-NEXT:    vmov q0[2], q0[0], r2, r3
; CHECK-NEXT:    vmov q0[3], q0[1], r2, r3
; CHECK-NEXT:    vmov.u8 r2, q2[13]
; CHECK-NEXT:    vmov.u8 r3, q2[12]
; CHECK-NEXT:    vcmp.i32 ne, q0, zr
; CHECK-NEXT:    vmov q0[2], q0[0], r3, r2
; CHECK-NEXT:    vand q0, q0, q3
; CHECK-NEXT:    vpsel q0, q0, q4
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d1
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d3
; CHECK-NEXT:    vmov q0[2], q0[0], r2, r3
; CHECK-NEXT:    vmov q0[3], q0[1], r2, r3
; CHECK-NEXT:    vmov.u8 r2, q2[15]
; CHECK-NEXT:    vmov.u8 r3, q2[14]
; CHECK-NEXT:    vcmp.i32 ne, q0, zr
; CHECK-NEXT:    vmov q0[2], q0[0], r3, r2
; CHECK-NEXT:    vand q0, q0, q3
; CHECK-NEXT:    vpsel q0, q0, q4
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d1
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    add sp, #16
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <16 x i8> %b, zeroinitializer
  %xx = zext <16 x i8> %x to <16 x i64>
  %s = select <16 x i1> %c, <16 x i64> %xx, <16 x i64> zeroinitializer
  %z = call i64 @llvm.vector.reduce.add.v16i64(<16 x i64> %s)
  ret i64 %z
}

define arm_aapcs_vfpcc i64 @add_v16i8_v16i64_sext(<16 x i8> %x, <16 x i8> %b) {
; CHECK-LABEL: add_v16i8_v16i64_sext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vcmp.i8 eq, q1, zr
; CHECK-NEXT:    vmov.i8 q1, #0x0
; CHECK-NEXT:    vmov.i8 q2, #0xff
; CHECK-NEXT:    vpsel q4, q2, q1
; CHECK-NEXT:    vmov.u8 r0, q4[0]
; CHECK-NEXT:    vmov.16 q3[0], r0
; CHECK-NEXT:    vmov.u8 r0, q4[1]
; CHECK-NEXT:    vmov.16 q3[1], r0
; CHECK-NEXT:    vmov.u8 r0, q4[2]
; CHECK-NEXT:    vmov.16 q3[2], r0
; CHECK-NEXT:    vmov.u8 r0, q4[3]
; CHECK-NEXT:    vmov.16 q3[3], r0
; CHECK-NEXT:    vmov.u8 r0, q4[4]
; CHECK-NEXT:    vmov.16 q3[4], r0
; CHECK-NEXT:    vmov.u8 r0, q4[5]
; CHECK-NEXT:    vmov.16 q3[5], r0
; CHECK-NEXT:    vmov.u8 r0, q4[6]
; CHECK-NEXT:    vmov.16 q3[6], r0
; CHECK-NEXT:    vmov.u8 r0, q4[7]
; CHECK-NEXT:    vmov.16 q3[7], r0
; CHECK-NEXT:    vcmp.i16 ne, q3, zr
; CHECK-NEXT:    vpsel q5, q2, q1
; CHECK-NEXT:    vmov.u16 r0, q5[2]
; CHECK-NEXT:    vmov.u16 r1, q5[0]
; CHECK-NEXT:    vmov q3[2], q3[0], r1, r0
; CHECK-NEXT:    vmov.u16 r0, q5[3]
; CHECK-NEXT:    vmov.u16 r1, q5[1]
; CHECK-NEXT:    vmov q3[3], q3[1], r1, r0
; CHECK-NEXT:    vcmp.i32 ne, q3, zr
; CHECK-NEXT:    vpsel q6, q2, q1
; CHECK-NEXT:    vmov r0, r1, d12
; CHECK-NEXT:    vmov q3[2], q3[0], r0, r1
; CHECK-NEXT:    vmov q3[3], q3[1], r0, r1
; CHECK-NEXT:    vmov.s8 r0, q0[1]
; CHECK-NEXT:    vmov.s8 r1, q0[0]
; CHECK-NEXT:    vcmp.i32 ne, q3, zr
; CHECK-NEXT:    vmov q7[2], q7[0], r1, r0
; CHECK-NEXT:    asrs r0, r0, #31
; CHECK-NEXT:    asrs r1, r1, #31
; CHECK-NEXT:    vmov.i32 q3, #0x0
; CHECK-NEXT:    vmov q7[3], q7[1], r1, r0
; CHECK-NEXT:    vpsel q7, q7, q3
; CHECK-NEXT:    vmov r0, r1, d15
; CHECK-NEXT:    vmov r2, r3, d14
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d13
; CHECK-NEXT:    vmov q6[2], q6[0], r2, r3
; CHECK-NEXT:    vmov q6[3], q6[1], r2, r3
; CHECK-NEXT:    vmov.s8 r2, q0[3]
; CHECK-NEXT:    vmov.s8 r3, q0[2]
; CHECK-NEXT:    vcmp.i32 ne, q6, zr
; CHECK-NEXT:    vmov q6[2], q6[0], r3, r2
; CHECK-NEXT:    asrs r2, r2, #31
; CHECK-NEXT:    asrs r3, r3, #31
; CHECK-NEXT:    vmov q6[3], q6[1], r3, r2
; CHECK-NEXT:    vpsel q6, q6, q3
; CHECK-NEXT:    vmov r2, r3, d12
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d13
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    vmov.u16 r2, q5[6]
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov.u16 r3, q5[4]
; CHECK-NEXT:    vmov q6[2], q6[0], r3, r2
; CHECK-NEXT:    vmov.u16 r2, q5[7]
; CHECK-NEXT:    vmov.u16 r3, q5[5]
; CHECK-NEXT:    vmov q6[3], q6[1], r3, r2
; CHECK-NEXT:    vcmp.i32 ne, q6, zr
; CHECK-NEXT:    vpsel q5, q2, q1
; CHECK-NEXT:    vmov r2, r3, d10
; CHECK-NEXT:    vmov q6[2], q6[0], r2, r3
; CHECK-NEXT:    vmov q6[3], q6[1], r2, r3
; CHECK-NEXT:    vmov.s8 r2, q0[5]
; CHECK-NEXT:    vmov.s8 r3, q0[4]
; CHECK-NEXT:    vcmp.i32 ne, q6, zr
; CHECK-NEXT:    vmov q6[2], q6[0], r3, r2
; CHECK-NEXT:    asrs r2, r2, #31
; CHECK-NEXT:    asrs r3, r3, #31
; CHECK-NEXT:    vmov q6[3], q6[1], r3, r2
; CHECK-NEXT:    vpsel q6, q6, q3
; CHECK-NEXT:    vmov r2, r3, d12
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d13
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d11
; CHECK-NEXT:    vmov q5[2], q5[0], r2, r3
; CHECK-NEXT:    vmov q5[3], q5[1], r2, r3
; CHECK-NEXT:    vmov.s8 r2, q0[7]
; CHECK-NEXT:    vmov.s8 r3, q0[6]
; CHECK-NEXT:    vcmp.i32 ne, q5, zr
; CHECK-NEXT:    vmov q5[2], q5[0], r3, r2
; CHECK-NEXT:    asrs r2, r2, #31
; CHECK-NEXT:    asrs r3, r3, #31
; CHECK-NEXT:    vmov q5[3], q5[1], r3, r2
; CHECK-NEXT:    vpsel q5, q5, q3
; CHECK-NEXT:    vmov r2, r3, d10
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d11
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    vmov.u8 r2, q4[8]
; CHECK-NEXT:    vmov.16 q5[0], r2
; CHECK-NEXT:    vmov.u8 r2, q4[9]
; CHECK-NEXT:    vmov.16 q5[1], r2
; CHECK-NEXT:    vmov.u8 r2, q4[10]
; CHECK-NEXT:    vmov.16 q5[2], r2
; CHECK-NEXT:    vmov.u8 r2, q4[11]
; CHECK-NEXT:    vmov.16 q5[3], r2
; CHECK-NEXT:    vmov.u8 r2, q4[12]
; CHECK-NEXT:    vmov.16 q5[4], r2
; CHECK-NEXT:    vmov.u8 r2, q4[13]
; CHECK-NEXT:    vmov.16 q5[5], r2
; CHECK-NEXT:    vmov.u8 r2, q4[14]
; CHECK-NEXT:    vmov.16 q5[6], r2
; CHECK-NEXT:    vmov.u8 r2, q4[15]
; CHECK-NEXT:    vmov.16 q5[7], r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vcmp.i16 ne, q5, zr
; CHECK-NEXT:    vpsel q4, q2, q1
; CHECK-NEXT:    vmov.u16 r2, q4[2]
; CHECK-NEXT:    vmov.u16 r3, q4[0]
; CHECK-NEXT:    vmov q5[2], q5[0], r3, r2
; CHECK-NEXT:    vmov.u16 r2, q4[3]
; CHECK-NEXT:    vmov.u16 r3, q4[1]
; CHECK-NEXT:    vmov q5[3], q5[1], r3, r2
; CHECK-NEXT:    vcmp.i32 ne, q5, zr
; CHECK-NEXT:    vpsel q5, q2, q1
; CHECK-NEXT:    vmov r2, r3, d10
; CHECK-NEXT:    vmov q6[2], q6[0], r2, r3
; CHECK-NEXT:    vmov q6[3], q6[1], r2, r3
; CHECK-NEXT:    vmov.s8 r2, q0[9]
; CHECK-NEXT:    vmov.s8 r3, q0[8]
; CHECK-NEXT:    vcmp.i32 ne, q6, zr
; CHECK-NEXT:    vmov q6[2], q6[0], r3, r2
; CHECK-NEXT:    asrs r2, r2, #31
; CHECK-NEXT:    asrs r3, r3, #31
; CHECK-NEXT:    vmov q6[3], q6[1], r3, r2
; CHECK-NEXT:    vpsel q6, q6, q3
; CHECK-NEXT:    vmov r2, r3, d12
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d13
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d11
; CHECK-NEXT:    vmov q5[2], q5[0], r2, r3
; CHECK-NEXT:    vmov q5[3], q5[1], r2, r3
; CHECK-NEXT:    vmov.s8 r2, q0[11]
; CHECK-NEXT:    vmov.s8 r3, q0[10]
; CHECK-NEXT:    vcmp.i32 ne, q5, zr
; CHECK-NEXT:    vmov q5[2], q5[0], r3, r2
; CHECK-NEXT:    asrs r2, r2, #31
; CHECK-NEXT:    asrs r3, r3, #31
; CHECK-NEXT:    vmov q5[3], q5[1], r3, r2
; CHECK-NEXT:    vpsel q5, q5, q3
; CHECK-NEXT:    vmov r2, r3, d10
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d11
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    vmov.u16 r2, q4[6]
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov.u16 r3, q4[4]
; CHECK-NEXT:    vmov q5[2], q5[0], r3, r2
; CHECK-NEXT:    vmov.u16 r2, q4[7]
; CHECK-NEXT:    vmov.u16 r3, q4[5]
; CHECK-NEXT:    vmov q5[3], q5[1], r3, r2
; CHECK-NEXT:    vcmp.i32 ne, q5, zr
; CHECK-NEXT:    vpsel q1, q2, q1
; CHECK-NEXT:    vmov r2, r3, d2
; CHECK-NEXT:    vmov q2[2], q2[0], r2, r3
; CHECK-NEXT:    vmov q2[3], q2[1], r2, r3
; CHECK-NEXT:    vmov.s8 r2, q0[13]
; CHECK-NEXT:    vmov.s8 r3, q0[12]
; CHECK-NEXT:    vcmp.i32 ne, q2, zr
; CHECK-NEXT:    vmov q2[2], q2[0], r3, r2
; CHECK-NEXT:    asrs r2, r2, #31
; CHECK-NEXT:    asrs r3, r3, #31
; CHECK-NEXT:    vmov q2[3], q2[1], r3, r2
; CHECK-NEXT:    vpsel q2, q2, q3
; CHECK-NEXT:    vmov r2, r3, d4
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d5
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d3
; CHECK-NEXT:    vmov q1[2], q1[0], r2, r3
; CHECK-NEXT:    vmov q1[3], q1[1], r2, r3
; CHECK-NEXT:    vmov.s8 r2, q0[15]
; CHECK-NEXT:    vmov.s8 r3, q0[14]
; CHECK-NEXT:    vcmp.i32 ne, q1, zr
; CHECK-NEXT:    vmov q0[2], q0[0], r3, r2
; CHECK-NEXT:    asrs r2, r2, #31
; CHECK-NEXT:    asrs r3, r3, #31
; CHECK-NEXT:    vmov q0[3], q0[1], r3, r2
; CHECK-NEXT:    vpsel q0, q0, q3
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d1
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <16 x i8> %b, zeroinitializer
  %xx = sext <16 x i8> %x to <16 x i64>
  %s = select <16 x i1> %c, <16 x i64> %xx, <16 x i64> zeroinitializer
  %z = call i64 @llvm.vector.reduce.add.v16i64(<16 x i64> %s)
  ret i64 %z
}

define arm_aapcs_vfpcc i64 @add_v8i8_v8i64_zext(<8 x i8> %x, <8 x i8> %b) {
; CHECK-LABEL: add_v8i8_v8i64_zext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vmovlb.u8 q1, q1
; CHECK-NEXT:    vmov.i8 q3, #0x0
; CHECK-NEXT:    vcmp.i16 eq, q1, zr
; CHECK-NEXT:    vmov.i8 q4, #0xff
; CHECK-NEXT:    vpsel q5, q4, q3
; CHECK-NEXT:    vmovlb.u8 q0, q0
; CHECK-NEXT:    vmov.u16 r0, q5[2]
; CHECK-NEXT:    vmov.u16 r1, q5[0]
; CHECK-NEXT:    vmov q1[2], q1[0], r1, r0
; CHECK-NEXT:    vmov.u16 r0, q5[3]
; CHECK-NEXT:    vmov.u16 r1, q5[1]
; CHECK-NEXT:    vmov q1[3], q1[1], r1, r0
; CHECK-NEXT:    vcmp.i32 ne, q1, zr
; CHECK-NEXT:    vpsel q6, q4, q3
; CHECK-NEXT:    vmov r0, r1, d12
; CHECK-NEXT:    vmov q1[2], q1[0], r0, r1
; CHECK-NEXT:    vmov q1[3], q1[1], r0, r1
; CHECK-NEXT:    vmov.u16 r0, q0[1]
; CHECK-NEXT:    vmov.u16 r1, q0[0]
; CHECK-NEXT:    vcmp.i32 ne, q1, zr
; CHECK-NEXT:    vmov q2[2], q2[0], r1, r0
; CHECK-NEXT:    vmov.i64 q1, #0xffff
; CHECK-NEXT:    vand q7, q2, q1
; CHECK-NEXT:    vmov.i32 q2, #0x0
; CHECK-NEXT:    vpsel q7, q7, q2
; CHECK-NEXT:    vmov r0, r1, d15
; CHECK-NEXT:    vmov r2, r3, d14
; CHECK-NEXT:    orrs r1, r3
; CHECK-NEXT:    add r0, r2
; CHECK-NEXT:    vmov r2, r3, d13
; CHECK-NEXT:    vmov q6[2], q6[0], r2, r3
; CHECK-NEXT:    vmov q6[3], q6[1], r2, r3
; CHECK-NEXT:    vmov.u16 r2, q0[3]
; CHECK-NEXT:    vmov.u16 r3, q0[2]
; CHECK-NEXT:    vcmp.i32 ne, q6, zr
; CHECK-NEXT:    vmov q6[2], q6[0], r3, r2
; CHECK-NEXT:    vand q6, q6, q1
; CHECK-NEXT:    vpsel q6, q6, q2
; CHECK-NEXT:    vmov r2, r3, d12
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d13
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    vmov.u16 r2, q5[6]
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov.u16 r3, q5[4]
; CHECK-NEXT:    vmov q6[2], q6[0], r3, r2
; CHECK-NEXT:    vmov.u16 r2, q5[7]
; CHECK-NEXT:    vmov.u16 r3, q5[5]
; CHECK-NEXT:    vmov q6[3], q6[1], r3, r2
; CHECK-NEXT:    vcmp.i32 ne, q6, zr
; CHECK-NEXT:    vpsel q3, q4, q3
; CHECK-NEXT:    vmov r2, r3, d6
; CHECK-NEXT:    vmov q4[2], q4[0], r2, r3
; CHECK-NEXT:    vmov q4[3], q4[1], r2, r3
; CHECK-NEXT:    vmov.u16 r2, q0[5]
; CHECK-NEXT:    vmov.u16 r3, q0[4]
; CHECK-NEXT:    vcmp.i32 ne, q4, zr
; CHECK-NEXT:    vmov q4[2], q4[0], r3, r2
; CHECK-NEXT:    vand q4, q4, q1
; CHECK-NEXT:    vpsel q4, q4, q2
; CHECK-NEXT:    vmov r2, r3, d8
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d9
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d7
; CHECK-NEXT:    vmov q3[2], q3[0], r2, r3
; CHECK-NEXT:    vmov q3[3], q3[1], r2, r3
; CHECK-NEXT:    vmov.u16 r2, q0[7]
; CHECK-NEXT:    vmov.u16 r3, q0[6]
; CHECK-NEXT:    vcmp.i32 ne, q3, zr
; CHECK-NEXT:    vmov q0[2], q0[0], r3, r2
; CHECK-NEXT:    vand q0, q0, q1
; CHECK-NEXT:    vpsel q0, q0, q2
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d1
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i8> %b, zeroinitializer
  %xx = zext <8 x i8> %x to <8 x i64>
  %s = select <8 x i1> %c, <8 x i64> %xx, <8 x i64> zeroinitializer
  %z = call i64 @llvm.vector.reduce.add.v8i64(<8 x i64> %s)
  ret i64 %z
}

define arm_aapcs_vfpcc i64 @add_v8i8_v8i64_sext(<8 x i8> %x, <8 x i8> %b) {
; CHECK-LABEL: add_v8i8_v8i64_sext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    vmovlb.u8 q1, q1
; CHECK-NEXT:    vmov.i8 q2, #0x0
; CHECK-NEXT:    vcmp.i16 eq, q1, zr
; CHECK-NEXT:    vmov.i8 q3, #0xff
; CHECK-NEXT:    vpsel q4, q3, q2
; CHECK-NEXT:    vmov.u16 r0, q4[2]
; CHECK-NEXT:    vmov.u16 r1, q4[0]
; CHECK-NEXT:    vmov q1[2], q1[0], r1, r0
; CHECK-NEXT:    vmov.u16 r0, q4[3]
; CHECK-NEXT:    vmov.u16 r1, q4[1]
; CHECK-NEXT:    vmov q1[3], q1[1], r1, r0
; CHECK-NEXT:    vcmp.i32 ne, q1, zr
; CHECK-NEXT:    vpsel q5, q3, q2
; CHECK-NEXT:    vmov r0, r1, d10
; CHECK-NEXT:    vmov q1[2], q1[0], r0, r1
; CHECK-NEXT:    vmov q1[3], q1[1], r0, r1
; CHECK-NEXT:    vmov.u16 r0, q0[1]
; CHECK-NEXT:    vmov.u16 r1, q0[0]
; CHECK-NEXT:    sxtb r0, r0
; CHECK-NEXT:    sxtb r1, r1
; CHECK-NEXT:    vcmp.i32 ne, q1, zr
; CHECK-NEXT:    vmov q6[2], q6[0], r1, r0
; CHECK-NEXT:    asrs r0, r0, #31
; CHECK-NEXT:    asrs r1, r1, #31
; CHECK-NEXT:    vmov.i32 q1, #0x0
; CHECK-NEXT:    vmov q6[3], q6[1], r1, r0
; CHECK-NEXT:    vpsel q6, q6, q1
; CHECK-NEXT:    vmov r0, r1, d13
; CHECK-NEXT:    vmov r2, r3, d12
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d11
; CHECK-NEXT:    vmov q5[2], q5[0], r2, r3
; CHECK-NEXT:    vmov q5[3], q5[1], r2, r3
; CHECK-NEXT:    vmov.u16 r2, q0[3]
; CHECK-NEXT:    vmov.u16 r3, q0[2]
; CHECK-NEXT:    sxtb r2, r2
; CHECK-NEXT:    sxtb r3, r3
; CHECK-NEXT:    vcmp.i32 ne, q5, zr
; CHECK-NEXT:    vmov q5[2], q5[0], r3, r2
; CHECK-NEXT:    asrs r2, r2, #31
; CHECK-NEXT:    asrs r3, r3, #31
; CHECK-NEXT:    vmov q5[3], q5[1], r3, r2
; CHECK-NEXT:    vpsel q5, q5, q1
; CHECK-NEXT:    vmov r2, r3, d10
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d11
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    vmov.u16 r2, q4[6]
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov.u16 r3, q4[4]
; CHECK-NEXT:    vmov q5[2], q5[0], r3, r2
; CHECK-NEXT:    vmov.u16 r2, q4[7]
; CHECK-NEXT:    vmov.u16 r3, q4[5]
; CHECK-NEXT:    vmov q5[3], q5[1], r3, r2
; CHECK-NEXT:    vcmp.i32 ne, q5, zr
; CHECK-NEXT:    vpsel q2, q3, q2
; CHECK-NEXT:    vmov r2, r3, d4
; CHECK-NEXT:    vmov q3[2], q3[0], r2, r3
; CHECK-NEXT:    vmov q3[3], q3[1], r2, r3
; CHECK-NEXT:    vmov.u16 r2, q0[5]
; CHECK-NEXT:    vmov.u16 r3, q0[4]
; CHECK-NEXT:    sxtb r2, r2
; CHECK-NEXT:    sxtb r3, r3
; CHECK-NEXT:    vcmp.i32 ne, q3, zr
; CHECK-NEXT:    vmov q3[2], q3[0], r3, r2
; CHECK-NEXT:    asrs r2, r2, #31
; CHECK-NEXT:    asrs r3, r3, #31
; CHECK-NEXT:    vmov q3[3], q3[1], r3, r2
; CHECK-NEXT:    vpsel q3, q3, q1
; CHECK-NEXT:    vmov r2, r3, d6
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d7
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d5
; CHECK-NEXT:    vmov q2[2], q2[0], r2, r3
; CHECK-NEXT:    vmov q2[3], q2[1], r2, r3
; CHECK-NEXT:    vmov.u16 r2, q0[7]
; CHECK-NEXT:    vmov.u16 r3, q0[6]
; CHECK-NEXT:    sxtb r2, r2
; CHECK-NEXT:    sxtb r3, r3
; CHECK-NEXT:    vcmp.i32 ne, q2, zr
; CHECK-NEXT:    vmov q0[2], q0[0], r3, r2
; CHECK-NEXT:    asrs r2, r2, #31
; CHECK-NEXT:    asrs r3, r3, #31
; CHECK-NEXT:    vmov q0[3], q0[1], r3, r2
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vmov r2, r3, d1
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i8> %b, zeroinitializer
  %xx = sext <8 x i8> %x to <8 x i64>
  %s = select <8 x i1> %c, <8 x i64> %xx, <8 x i64> zeroinitializer
  %z = call i64 @llvm.vector.reduce.add.v8i64(<8 x i64> %s)
  ret i64 %z
}

define arm_aapcs_vfpcc i64 @add_v4i8_v4i64_zext(<4 x i8> %x, <4 x i8> %b) {
; CHECK-LABEL: add_v4i8_v4i64_zext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.i32 q2, #0xff
; CHECK-NEXT:    vand q1, q1, q2
; CHECK-NEXT:    vand q0, q0, q2
; CHECK-NEXT:    vpt.i32 eq, q1, zr
; CHECK-NEXT:    vaddlvt.u32 r0, r1, q0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i8> %b, zeroinitializer
  %xx = zext <4 x i8> %x to <4 x i64>
  %s = select <4 x i1> %c, <4 x i64> %xx, <4 x i64> zeroinitializer
  %z = call i64 @llvm.vector.reduce.add.v4i64(<4 x i64> %s)
  ret i64 %z
}

define arm_aapcs_vfpcc i64 @add_v4i8_v4i64_sext(<4 x i8> %x, <4 x i8> %b) {
; CHECK-LABEL: add_v4i8_v4i64_sext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.i32 q2, #0xff
; CHECK-NEXT:    vmovlb.s8 q0, q0
; CHECK-NEXT:    vand q1, q1, q2
; CHECK-NEXT:    vmovlb.s16 q0, q0
; CHECK-NEXT:    vpt.i32 eq, q1, zr
; CHECK-NEXT:    vaddlvt.s32 r0, r1, q0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i8> %b, zeroinitializer
  %xx = sext <4 x i8> %x to <4 x i64>
  %s = select <4 x i1> %c, <4 x i64> %xx, <4 x i64> zeroinitializer
  %z = call i64 @llvm.vector.reduce.add.v4i64(<4 x i64> %s)
  ret i64 %z
}

define arm_aapcs_vfpcc i64 @add_v2i8_v2i64_zext(<2 x i8> %x, <2 x i8> %b) {
; CHECK-LABEL: add_v2i8_v2i64_zext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.i64 q2, #0xff
; CHECK-NEXT:    movs r1, #0
; CHECK-NEXT:    vand q1, q1, q2
; CHECK-NEXT:    vand q0, q0, q2
; CHECK-NEXT:    vmov r0, s4
; CHECK-NEXT:    cmp r0, #0
; CHECK-NEXT:    csetm r0, eq
; CHECK-NEXT:    bfi r1, r0, #0, #8
; CHECK-NEXT:    vmov r0, s6
; CHECK-NEXT:    vmov.i32 q1, #0x0
; CHECK-NEXT:    cmp r0, #0
; CHECK-NEXT:    csetm r0, eq
; CHECK-NEXT:    bfi r1, r0, #8, #8
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    vmov r0, r1, d1
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    add r0, r2
; CHECK-NEXT:    orrs r1, r3
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <2 x i8> %b, zeroinitializer
  %xx = zext <2 x i8> %x to <2 x i64>
  %s = select <2 x i1> %c, <2 x i64> %xx, <2 x i64> zeroinitializer
  %z = call i64 @llvm.vector.reduce.add.v2i64(<2 x i64> %s)
  ret i64 %z
}

define arm_aapcs_vfpcc i64 @add_v2i8_v2i64_sext(<2 x i8> %x, <2 x i8> %b) {
; CHECK-LABEL: add_v2i8_v2i64_sext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.i32 q2, #0xff
; CHECK-NEXT:    movs r1, #0
; CHECK-NEXT:    vand q1, q1, q2
; CHECK-NEXT:    vmov r0, s4
; CHECK-NEXT:    cmp r0, #0
; CHECK-NEXT:    csetm r0, eq
; CHECK-NEXT:    bfi r1, r0, #0, #8
; CHECK-NEXT:    vmov r0, s6
; CHECK-NEXT:    vmov.i32 q1, #0x0
; CHECK-NEXT:    cmp r0, #0
; CHECK-NEXT:    csetm r0, eq
; CHECK-NEXT:    bfi r1, r0, #8, #8
; CHECK-NEXT:    vmov r0, s2
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vmov r1, s0
; CHECK-NEXT:    sxtb r0, r0
; CHECK-NEXT:    sxtb r1, r1
; CHECK-NEXT:    vmov q0[2], q0[0], r1, r0
; CHECK-NEXT:    asrs r0, r0, #31
; CHECK-NEXT:    asrs r1, r1, #31
; CHECK-NEXT:    vmov q0[3], q0[1], r1, r0
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    vmov r0, r1, d1
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <2 x i8> %b, zeroinitializer
  %xx = sext <2 x i8> %x to <2 x i64>
  %s = select <2 x i1> %c, <2 x i64> %xx, <2 x i64> zeroinitializer
  %z = call i64 @llvm.vector.reduce.add.v2i64(<2 x i64> %s)
  ret i64 %z
}

define arm_aapcs_vfpcc i64 @add_v2i64_v2i64(<2 x i64> %x, <2 x i64> %b) {
; CHECK-LABEL: add_v2i64_v2i64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov r0, r1, d2
; CHECK-NEXT:    orrs r0, r1
; CHECK-NEXT:    mov.w r1, #0
; CHECK-NEXT:    csetm r0, eq
; CHECK-NEXT:    bfi r1, r0, #0, #8
; CHECK-NEXT:    vmov r0, r2, d3
; CHECK-NEXT:    vmov.i32 q1, #0x0
; CHECK-NEXT:    orrs r0, r2
; CHECK-NEXT:    csetm r0, eq
; CHECK-NEXT:    bfi r1, r0, #8, #8
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    vmov r0, r1, d1
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <2 x i64> %b, zeroinitializer
  %s = select <2 x i1> %c, <2 x i64> %x, <2 x i64> zeroinitializer
  %z = call i64 @llvm.vector.reduce.add.v2i64(<2 x i64> %s)
  ret i64 %z
}

define arm_aapcs_vfpcc i32 @add_v4i32_v4i32_acc(<4 x i32> %x, <4 x i32> %b, i32 %a) {
; CHECK-LABEL: add_v4i32_v4i32_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q1, zr
; CHECK-NEXT:    vaddvat.u32 r0, q0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i32> %b, zeroinitializer
  %s = select <4 x i1> %c, <4 x i32> %x, <4 x i32> zeroinitializer
  %z = call i32 @llvm.vector.reduce.add.v4i32(<4 x i32> %s)
  %r = add i32 %z, %a
  ret i32 %r
}

define arm_aapcs_vfpcc i64 @add_v4i32_v4i64_acc_zext(<4 x i32> %x, <4 x i32> %b, i64 %a) {
; CHECK-LABEL: add_v4i32_v4i64_acc_zext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q1, zr
; CHECK-NEXT:    vaddlvat.u32 r0, r1, q0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i32> %b, zeroinitializer
  %xx = zext <4 x i32> %x to <4 x i64>
  %s = select <4 x i1> %c, <4 x i64> %xx, <4 x i64> zeroinitializer
  %z = call i64 @llvm.vector.reduce.add.v4i64(<4 x i64> %s)
  %r = add i64 %z, %a
  ret i64 %r
}

define arm_aapcs_vfpcc i64 @add_v4i32_v4i64_acc_sext(<4 x i32> %x, <4 x i32> %b, i64 %a) {
; CHECK-LABEL: add_v4i32_v4i64_acc_sext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q1, zr
; CHECK-NEXT:    vaddlvat.s32 r0, r1, q0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i32> %b, zeroinitializer
  %xx = sext <4 x i32> %x to <4 x i64>
  %s = select <4 x i1> %c, <4 x i64> %xx, <4 x i64> zeroinitializer
  %z = call i64 @llvm.vector.reduce.add.v4i64(<4 x i64> %s)
  %r = add i64 %z, %a
  ret i64 %r
}

define arm_aapcs_vfpcc i64 @add_v2i32_v2i64_acc_zext(<2 x i32> %x, <2 x i32> %b, i64 %a) {
; CHECK-LABEL: add_v2i32_v2i64_acc_zext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r7, lr}
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    vmov r2, s4
; CHECK-NEXT:    movs r3, #0
; CHECK-NEXT:    vmov.i64 q2, #0xffffffff
; CHECK-NEXT:    vand q0, q0, q2
; CHECK-NEXT:    cmp r2, #0
; CHECK-NEXT:    csetm r2, eq
; CHECK-NEXT:    bfi r3, r2, #0, #8
; CHECK-NEXT:    vmov r2, s6
; CHECK-NEXT:    vmov.i32 q1, #0x0
; CHECK-NEXT:    cmp r2, #0
; CHECK-NEXT:    csetm r2, eq
; CHECK-NEXT:    bfi r3, r2, #8, #8
; CHECK-NEXT:    vmsr p0, r3
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    vmov lr, r12, d1
; CHECK-NEXT:    vmov r3, r2, d0
; CHECK-NEXT:    adds.w r3, r3, lr
; CHECK-NEXT:    adc.w r2, r2, r12
; CHECK-NEXT:    adds r0, r0, r3
; CHECK-NEXT:    adcs r1, r2
; CHECK-NEXT:    pop {r7, pc}
entry:
  %c = icmp eq <2 x i32> %b, zeroinitializer
  %xx = zext <2 x i32> %x to <2 x i64>
  %s = select <2 x i1> %c, <2 x i64> %xx, <2 x i64> zeroinitializer
  %z = call i64 @llvm.vector.reduce.add.v2i64(<2 x i64> %s)
  %r = add i64 %z, %a
  ret i64 %r
}

define arm_aapcs_vfpcc i64 @add_v2i32_v2i64_acc_sext(<2 x i32> %x, <2 x i32> %b, i64 %a) {
; CHECK-LABEL: add_v2i32_v2i64_acc_sext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r7, lr}
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    vmov r2, s2
; CHECK-NEXT:    vmov r3, s0
; CHECK-NEXT:    vmov q0[2], q0[0], r3, r2
; CHECK-NEXT:    asrs r2, r2, #31
; CHECK-NEXT:    asrs r3, r3, #31
; CHECK-NEXT:    vmov q0[3], q0[1], r3, r2
; CHECK-NEXT:    vmov r2, s4
; CHECK-NEXT:    movs r3, #0
; CHECK-NEXT:    cmp r2, #0
; CHECK-NEXT:    csetm r2, eq
; CHECK-NEXT:    bfi r3, r2, #0, #8
; CHECK-NEXT:    vmov r2, s6
; CHECK-NEXT:    vmov.i32 q1, #0x0
; CHECK-NEXT:    cmp r2, #0
; CHECK-NEXT:    csetm r2, eq
; CHECK-NEXT:    bfi r3, r2, #8, #8
; CHECK-NEXT:    vmsr p0, r3
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    vmov lr, r12, d1
; CHECK-NEXT:    vmov r3, r2, d0
; CHECK-NEXT:    adds.w r3, r3, lr
; CHECK-NEXT:    adc.w r2, r2, r12
; CHECK-NEXT:    adds r0, r0, r3
; CHECK-NEXT:    adcs r1, r2
; CHECK-NEXT:    pop {r7, pc}
entry:
  %c = icmp eq <2 x i32> %b, zeroinitializer
  %xx = sext <2 x i32> %x to <2 x i64>
  %s = select <2 x i1> %c, <2 x i64> %xx, <2 x i64> zeroinitializer
  %z = call i64 @llvm.vector.reduce.add.v2i64(<2 x i64> %s)
  %r = add i64 %z, %a
  ret i64 %r
}

define arm_aapcs_vfpcc i32 @add_v8i16_v8i32_acc_zext(<8 x i16> %x, <8 x i16> %b, i32 %a) {
; CHECK-LABEL: add_v8i16_v8i32_acc_zext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i16 eq, q1, zr
; CHECK-NEXT:    vaddvat.u16 r0, q0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i16> %b, zeroinitializer
  %xx = zext <8 x i16> %x to <8 x i32>
  %s = select <8 x i1> %c, <8 x i32> %xx, <8 x i32> zeroinitializer
  %z = call i32 @llvm.vector.reduce.add.v8i32(<8 x i32> %s)
  %r = add i32 %z, %a
  ret i32 %r
}

define arm_aapcs_vfpcc i32 @add_v8i16_v8i32_acc_sext(<8 x i16> %x, <8 x i16> %b, i32 %a) {
; CHECK-LABEL: add_v8i16_v8i32_acc_sext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i16 eq, q1, zr
; CHECK-NEXT:    vaddvat.s16 r0, q0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i16> %b, zeroinitializer
  %xx = sext <8 x i16> %x to <8 x i32>
  %s = select <8 x i1> %c, <8 x i32> %xx, <8 x i32> zeroinitializer
  %z = call i32 @llvm.vector.reduce.add.v8i32(<8 x i32> %s)
  %r = add i32 %z, %a
  ret i32 %r
}

define arm_aapcs_vfpcc i32 @add_v4i16_v4i32_acc_zext(<4 x i16> %x, <4 x i16> %b, i32 %a) {
; CHECK-LABEL: add_v4i16_v4i32_acc_zext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmovlb.u16 q1, q1
; CHECK-NEXT:    vmovlb.u16 q0, q0
; CHECK-NEXT:    vpt.i32 eq, q1, zr
; CHECK-NEXT:    vaddvat.u32 r0, q0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i16> %b, zeroinitializer
  %xx = zext <4 x i16> %x to <4 x i32>
  %s = select <4 x i1> %c, <4 x i32> %xx, <4 x i32> zeroinitializer
  %z = call i32 @llvm.vector.reduce.add.v4i32(<4 x i32> %s)
  %r = add i32 %z, %a
  ret i32 %r
}

define arm_aapcs_vfpcc i32 @add_v4i16_v4i32_acc_sext(<4 x i16> %x, <4 x i16> %b, i32 %a) {
; CHECK-LABEL: add_v4i16_v4i32_acc_sext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmovlb.u16 q1, q1
; CHECK-NEXT:    vmovlb.s16 q0, q0
; CHECK-NEXT:    vpt.i32 eq, q1, zr
; CHECK-NEXT:    vaddvat.u32 r0, q0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i16> %b, zeroinitializer
  %xx = sext <4 x i16> %x to <4 x i32>
  %s = select <4 x i1> %c, <4 x i32> %xx, <4 x i32> zeroinitializer
  %z = call i32 @llvm.vector.reduce.add.v4i32(<4 x i32> %s)
  %r = add i32 %z, %a
  ret i32 %r
}

define arm_aapcs_vfpcc zeroext i16 @add_v8i16_v8i16_acc(<8 x i16> %x, <8 x i16> %b, i16 %a) {
; CHECK-LABEL: add_v8i16_v8i16_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i16 eq, q1, zr
; CHECK-NEXT:    vaddvat.u16 r0, q0
; CHECK-NEXT:    uxth r0, r0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i16> %b, zeroinitializer
  %s = select <8 x i1> %c, <8 x i16> %x, <8 x i16> zeroinitializer
  %z = call i16 @llvm.vector.reduce.add.v8i16(<8 x i16> %s)
  %r = add i16 %z, %a
  ret i16 %r
}

define arm_aapcs_vfpcc i64 @add_v8i16_v8i64_acc_zext(<8 x i16> %x, <8 x i16> %b, i64 %a) {
; CHECK-LABEL: add_v8i16_v8i64_acc_zext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r7, lr}
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vmov.i8 q3, #0x0
; CHECK-NEXT:    vmov.i8 q4, #0xff
; CHECK-NEXT:    vcmp.i16 eq, q1, zr
; CHECK-NEXT:    vpsel q5, q4, q3
; CHECK-NEXT:    vmov.u16 r2, q5[2]
; CHECK-NEXT:    vmov.u16 r3, q5[0]
; CHECK-NEXT:    vmov q1[2], q1[0], r3, r2
; CHECK-NEXT:    vmov.u16 r2, q5[3]
; CHECK-NEXT:    vmov.u16 r3, q5[1]
; CHECK-NEXT:    vmov q1[3], q1[1], r3, r2
; CHECK-NEXT:    vcmp.i32 ne, q1, zr
; CHECK-NEXT:    vpsel q6, q4, q3
; CHECK-NEXT:    vmov r2, r3, d12
; CHECK-NEXT:    vmov q1[2], q1[0], r2, r3
; CHECK-NEXT:    vmov q1[3], q1[1], r2, r3
; CHECK-NEXT:    vmov.u16 r2, q0[1]
; CHECK-NEXT:    vmov.u16 r3, q0[0]
; CHECK-NEXT:    vcmp.i32 ne, q1, zr
; CHECK-NEXT:    vmov q2[2], q2[0], r3, r2
; CHECK-NEXT:    vmov.i64 q1, #0xffff
; CHECK-NEXT:    vand q7, q2, q1
; CHECK-NEXT:    vmov.i32 q2, #0x0
; CHECK-NEXT:    vpsel q7, q7, q2
; CHECK-NEXT:    vmov r12, lr, d15
; CHECK-NEXT:    vmov r2, r3, d14
; CHECK-NEXT:    orr.w lr, lr, r3
; CHECK-NEXT:    add r12, r2
; CHECK-NEXT:    vmov r3, r2, d13
; CHECK-NEXT:    vmov q6[2], q6[0], r3, r2
; CHECK-NEXT:    vmov q6[3], q6[1], r3, r2
; CHECK-NEXT:    vmov.u16 r2, q0[3]
; CHECK-NEXT:    vmov.u16 r3, q0[2]
; CHECK-NEXT:    vcmp.i32 ne, q6, zr
; CHECK-NEXT:    vmov q6[2], q6[0], r3, r2
; CHECK-NEXT:    vand q6, q6, q1
; CHECK-NEXT:    vpsel q6, q6, q2
; CHECK-NEXT:    vmov r2, r3, d12
; CHECK-NEXT:    adds.w r12, r12, r2
; CHECK-NEXT:    adc.w lr, lr, r3
; CHECK-NEXT:    vmov r2, r3, d13
; CHECK-NEXT:    adds.w r12, r12, r2
; CHECK-NEXT:    vmov.u16 r2, q5[6]
; CHECK-NEXT:    adc.w lr, lr, r3
; CHECK-NEXT:    vmov.u16 r3, q5[4]
; CHECK-NEXT:    vmov q6[2], q6[0], r3, r2
; CHECK-NEXT:    vmov.u16 r2, q5[7]
; CHECK-NEXT:    vmov.u16 r3, q5[5]
; CHECK-NEXT:    vmov q6[3], q6[1], r3, r2
; CHECK-NEXT:    vcmp.i32 ne, q6, zr
; CHECK-NEXT:    vpsel q3, q4, q3
; CHECK-NEXT:    vmov r2, r3, d6
; CHECK-NEXT:    vmov q4[2], q4[0], r2, r3
; CHECK-NEXT:    vmov q4[3], q4[1], r2, r3
; CHECK-NEXT:    vmov.u16 r2, q0[5]
; CHECK-NEXT:    vmov.u16 r3, q0[4]
; CHECK-NEXT:    vcmp.i32 ne, q4, zr
; CHECK-NEXT:    vmov q4[2], q4[0], r3, r2
; CHECK-NEXT:    vand q4, q4, q1
; CHECK-NEXT:    vpsel q4, q4, q2
; CHECK-NEXT:    vmov r2, r3, d8
; CHECK-NEXT:    adds.w r12, r12, r2
; CHECK-NEXT:    adc.w lr, lr, r3
; CHECK-NEXT:    vmov r2, r3, d9
; CHECK-NEXT:    adds.w r12, r12, r2
; CHECK-NEXT:    adc.w lr, lr, r3
; CHECK-NEXT:    vmov r2, r3, d7
; CHECK-NEXT:    vmov q3[2], q3[0], r2, r3
; CHECK-NEXT:    vmov q3[3], q3[1], r2, r3
; CHECK-NEXT:    vmov.u16 r2, q0[7]
; CHECK-NEXT:    vmov.u16 r3, q0[6]
; CHECK-NEXT:    vcmp.i32 ne, q3, zr
; CHECK-NEXT:    vmov q0[2], q0[0], r3, r2
; CHECK-NEXT:    vand q0, q0, q1
; CHECK-NEXT:    vpsel q0, q0, q2
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    adds.w r12, r12, r2
; CHECK-NEXT:    adc.w lr, lr, r3
; CHECK-NEXT:    vmov r2, r3, d1
; CHECK-NEXT:    adds.w r2, r2, r12
; CHECK-NEXT:    adc.w r3, r3, lr
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    pop {r7, pc}
entry:
  %c = icmp eq <8 x i16> %b, zeroinitializer
  %xx = zext <8 x i16> %x to <8 x i64>
  %s = select <8 x i1> %c, <8 x i64> %xx, <8 x i64> zeroinitializer
  %z = call i64 @llvm.vector.reduce.add.v8i64(<8 x i64> %s)
  %r = add i64 %z, %a
  ret i64 %r
}

define arm_aapcs_vfpcc i64 @add_v8i16_v8i64_acc_sext(<8 x i16> %x, <8 x i16> %b, i64 %a) {
; CHECK-LABEL: add_v8i16_v8i64_acc_sext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r7, lr}
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    vmov.i8 q2, #0x0
; CHECK-NEXT:    vmov.i8 q3, #0xff
; CHECK-NEXT:    vcmp.i16 eq, q1, zr
; CHECK-NEXT:    vpsel q4, q3, q2
; CHECK-NEXT:    vmov.u16 r2, q4[2]
; CHECK-NEXT:    vmov.u16 r3, q4[0]
; CHECK-NEXT:    vmov q1[2], q1[0], r3, r2
; CHECK-NEXT:    vmov.u16 r2, q4[3]
; CHECK-NEXT:    vmov.u16 r3, q4[1]
; CHECK-NEXT:    vmov q1[3], q1[1], r3, r2
; CHECK-NEXT:    vcmp.i32 ne, q1, zr
; CHECK-NEXT:    vpsel q5, q3, q2
; CHECK-NEXT:    vmov r2, r3, d10
; CHECK-NEXT:    vmov q1[2], q1[0], r2, r3
; CHECK-NEXT:    vmov q1[3], q1[1], r2, r3
; CHECK-NEXT:    vmov.s16 r2, q0[1]
; CHECK-NEXT:    vmov.s16 r3, q0[0]
; CHECK-NEXT:    vcmp.i32 ne, q1, zr
; CHECK-NEXT:    vmov q6[2], q6[0], r3, r2
; CHECK-NEXT:    asrs r2, r2, #31
; CHECK-NEXT:    asrs r3, r3, #31
; CHECK-NEXT:    vmov.i32 q1, #0x0
; CHECK-NEXT:    vmov q6[3], q6[1], r3, r2
; CHECK-NEXT:    vpsel q6, q6, q1
; CHECK-NEXT:    vmov lr, r12, d13
; CHECK-NEXT:    vmov r3, r2, d12
; CHECK-NEXT:    adds.w lr, lr, r3
; CHECK-NEXT:    adc.w r12, r12, r2
; CHECK-NEXT:    vmov r2, r3, d11
; CHECK-NEXT:    vmov q5[2], q5[0], r2, r3
; CHECK-NEXT:    vmov q5[3], q5[1], r2, r3
; CHECK-NEXT:    vmov.s16 r2, q0[3]
; CHECK-NEXT:    vmov.s16 r3, q0[2]
; CHECK-NEXT:    vcmp.i32 ne, q5, zr
; CHECK-NEXT:    vmov q5[2], q5[0], r3, r2
; CHECK-NEXT:    asrs r2, r2, #31
; CHECK-NEXT:    asrs r3, r3, #31
; CHECK-NEXT:    vmov q5[3], q5[1], r3, r2
; CHECK-NEXT:    vpsel q5, q5, q1
; CHECK-NEXT:    vmov r2, r3, d10
; CHECK-NEXT:    adds.w lr, lr, r2
; CHECK-NEXT:    adc.w r12, r12, r3
; CHECK-NEXT:    vmov r2, r3, d11
; CHECK-NEXT:    adds.w lr, lr, r2
; CHECK-NEXT:    vmov.u16 r2, q4[6]
; CHECK-NEXT:    adc.w r12, r12, r3
; CHECK-NEXT:    vmov.u16 r3, q4[4]
; CHECK-NEXT:    vmov q5[2], q5[0], r3, r2
; CHECK-NEXT:    vmov.u16 r2, q4[7]
; CHECK-NEXT:    vmov.u16 r3, q4[5]
; CHECK-NEXT:    vmov q5[3], q5[1], r3, r2
; CHECK-NEXT:    vcmp.i32 ne, q5, zr
; CHECK-NEXT:    vpsel q2, q3, q2
; CHECK-NEXT:    vmov r2, r3, d4
; CHECK-NEXT:    vmov q3[2], q3[0], r2, r3
; CHECK-NEXT:    vmov q3[3], q3[1], r2, r3
; CHECK-NEXT:    vmov.s16 r2, q0[5]
; CHECK-NEXT:    vmov.s16 r3, q0[4]
; CHECK-NEXT:    vcmp.i32 ne, q3, zr
; CHECK-NEXT:    vmov q3[2], q3[0], r3, r2
; CHECK-NEXT:    asrs r2, r2, #31
; CHECK-NEXT:    asrs r3, r3, #31
; CHECK-NEXT:    vmov q3[3], q3[1], r3, r2
; CHECK-NEXT:    vpsel q3, q3, q1
; CHECK-NEXT:    vmov r2, r3, d6
; CHECK-NEXT:    adds.w lr, lr, r2
; CHECK-NEXT:    adc.w r12, r12, r3
; CHECK-NEXT:    vmov r2, r3, d7
; CHECK-NEXT:    adds.w lr, lr, r2
; CHECK-NEXT:    adc.w r12, r12, r3
; CHECK-NEXT:    vmov r2, r3, d5
; CHECK-NEXT:    vmov q2[2], q2[0], r2, r3
; CHECK-NEXT:    vmov q2[3], q2[1], r2, r3
; CHECK-NEXT:    vmov.s16 r2, q0[7]
; CHECK-NEXT:    vmov.s16 r3, q0[6]
; CHECK-NEXT:    vcmp.i32 ne, q2, zr
; CHECK-NEXT:    vmov q0[2], q0[0], r3, r2
; CHECK-NEXT:    asrs r2, r2, #31
; CHECK-NEXT:    asrs r3, r3, #31
; CHECK-NEXT:    vmov q0[3], q0[1], r3, r2
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    adds.w lr, lr, r2
; CHECK-NEXT:    adc.w r12, r12, r3
; CHECK-NEXT:    vmov r2, r3, d1
; CHECK-NEXT:    adds.w r2, r2, lr
; CHECK-NEXT:    adc.w r3, r3, r12
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    pop {r7, pc}
entry:
  %c = icmp eq <8 x i16> %b, zeroinitializer
  %xx = sext <8 x i16> %x to <8 x i64>
  %s = select <8 x i1> %c, <8 x i64> %xx, <8 x i64> zeroinitializer
  %z = call i64 @llvm.vector.reduce.add.v8i64(<8 x i64> %s)
  %r = add i64 %z, %a
  ret i64 %r
}

define arm_aapcs_vfpcc i64 @add_v2i16_v2i64_acc_zext(<2 x i16> %x, <2 x i16> %b, i64 %a) {
; CHECK-LABEL: add_v2i16_v2i64_acc_zext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r7, lr}
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    vmov.i64 q2, #0xffff
; CHECK-NEXT:    movs r3, #0
; CHECK-NEXT:    vand q1, q1, q2
; CHECK-NEXT:    vand q0, q0, q2
; CHECK-NEXT:    vmov r2, s4
; CHECK-NEXT:    cmp r2, #0
; CHECK-NEXT:    csetm r2, eq
; CHECK-NEXT:    bfi r3, r2, #0, #8
; CHECK-NEXT:    vmov r2, s6
; CHECK-NEXT:    vmov.i32 q1, #0x0
; CHECK-NEXT:    cmp r2, #0
; CHECK-NEXT:    csetm r2, eq
; CHECK-NEXT:    bfi r3, r2, #8, #8
; CHECK-NEXT:    vmsr p0, r3
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    vmov r12, lr, d1
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    add r2, r12
; CHECK-NEXT:    orr.w r3, r3, lr
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    pop {r7, pc}
entry:
  %c = icmp eq <2 x i16> %b, zeroinitializer
  %xx = zext <2 x i16> %x to <2 x i64>
  %s = select <2 x i1> %c, <2 x i64> %xx, <2 x i64> zeroinitializer
  %z = call i64 @llvm.vector.reduce.add.v2i64(<2 x i64> %s)
  %r = add i64 %z, %a
  ret i64 %r
}

define arm_aapcs_vfpcc i64 @add_v2i16_v2i64_acc_sext(<2 x i16> %x, <2 x i16> %b, i64 %a) {
; CHECK-LABEL: add_v2i16_v2i64_acc_sext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r7, lr}
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    vmov.i32 q2, #0xffff
; CHECK-NEXT:    movs r3, #0
; CHECK-NEXT:    vand q1, q1, q2
; CHECK-NEXT:    vmov r2, s4
; CHECK-NEXT:    cmp r2, #0
; CHECK-NEXT:    csetm r2, eq
; CHECK-NEXT:    bfi r3, r2, #0, #8
; CHECK-NEXT:    vmov r2, s6
; CHECK-NEXT:    vmov.i32 q1, #0x0
; CHECK-NEXT:    cmp r2, #0
; CHECK-NEXT:    csetm r2, eq
; CHECK-NEXT:    bfi r3, r2, #8, #8
; CHECK-NEXT:    vmov r2, s2
; CHECK-NEXT:    vmsr p0, r3
; CHECK-NEXT:    vmov r3, s0
; CHECK-NEXT:    sxth r2, r2
; CHECK-NEXT:    sxth r3, r3
; CHECK-NEXT:    vmov q0[2], q0[0], r3, r2
; CHECK-NEXT:    asrs r2, r2, #31
; CHECK-NEXT:    asrs r3, r3, #31
; CHECK-NEXT:    vmov q0[3], q0[1], r3, r2
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    vmov lr, r12, d1
; CHECK-NEXT:    vmov r3, r2, d0
; CHECK-NEXT:    adds.w r3, r3, lr
; CHECK-NEXT:    adc.w r2, r2, r12
; CHECK-NEXT:    adds r0, r0, r3
; CHECK-NEXT:    adcs r1, r2
; CHECK-NEXT:    pop {r7, pc}
entry:
  %c = icmp eq <2 x i16> %b, zeroinitializer
  %xx = sext <2 x i16> %x to <2 x i64>
  %s = select <2 x i1> %c, <2 x i64> %xx, <2 x i64> zeroinitializer
  %z = call i64 @llvm.vector.reduce.add.v2i64(<2 x i64> %s)
  %r = add i64 %z, %a
  ret i64 %r
}

define arm_aapcs_vfpcc i32 @add_v16i8_v16i32_acc_zext(<16 x i8> %x, <16 x i8> %b, i32 %a) {
; CHECK-LABEL: add_v16i8_v16i32_acc_zext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i8 eq, q1, zr
; CHECK-NEXT:    vaddvat.u8 r0, q0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <16 x i8> %b, zeroinitializer
  %xx = zext <16 x i8> %x to <16 x i32>
  %s = select <16 x i1> %c, <16 x i32> %xx, <16 x i32> zeroinitializer
  %z = call i32 @llvm.vector.reduce.add.v16i32(<16 x i32> %s)
  %r = add i32 %z, %a
  ret i32 %r
}

define arm_aapcs_vfpcc i32 @add_v16i8_v16i32_acc_sext(<16 x i8> %x, <16 x i8> %b, i32 %a) {
; CHECK-LABEL: add_v16i8_v16i32_acc_sext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i8 eq, q1, zr
; CHECK-NEXT:    vaddvat.s8 r0, q0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <16 x i8> %b, zeroinitializer
  %xx = sext <16 x i8> %x to <16 x i32>
  %s = select <16 x i1> %c, <16 x i32> %xx, <16 x i32> zeroinitializer
  %z = call i32 @llvm.vector.reduce.add.v16i32(<16 x i32> %s)
  %r = add i32 %z, %a
  ret i32 %r
}

define arm_aapcs_vfpcc i32 @add_v4i8_v4i32_acc_zext(<4 x i8> %x, <4 x i8> %b, i32 %a) {
; CHECK-LABEL: add_v4i8_v4i32_acc_zext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.i32 q2, #0xff
; CHECK-NEXT:    vand q1, q1, q2
; CHECK-NEXT:    vand q0, q0, q2
; CHECK-NEXT:    vpt.i32 eq, q1, zr
; CHECK-NEXT:    vaddvat.u32 r0, q0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i8> %b, zeroinitializer
  %xx = zext <4 x i8> %x to <4 x i32>
  %s = select <4 x i1> %c, <4 x i32> %xx, <4 x i32> zeroinitializer
  %z = call i32 @llvm.vector.reduce.add.v4i32(<4 x i32> %s)
  %r = add i32 %z, %a
  ret i32 %r
}

define arm_aapcs_vfpcc i32 @add_v4i8_v4i32_acc_sext(<4 x i8> %x, <4 x i8> %b, i32 %a) {
; CHECK-LABEL: add_v4i8_v4i32_acc_sext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.i32 q2, #0xff
; CHECK-NEXT:    vmovlb.s8 q0, q0
; CHECK-NEXT:    vand q1, q1, q2
; CHECK-NEXT:    vmovlb.s16 q0, q0
; CHECK-NEXT:    vpt.i32 eq, q1, zr
; CHECK-NEXT:    vaddvat.u32 r0, q0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i8> %b, zeroinitializer
  %xx = sext <4 x i8> %x to <4 x i32>
  %s = select <4 x i1> %c, <4 x i32> %xx, <4 x i32> zeroinitializer
  %z = call i32 @llvm.vector.reduce.add.v4i32(<4 x i32> %s)
  %r = add i32 %z, %a
  ret i32 %r
}

define arm_aapcs_vfpcc zeroext i16 @add_v16i8_v16i16_acc_zext(<16 x i8> %x, <16 x i8> %b, i16 %a) {
; CHECK-LABEL: add_v16i8_v16i16_acc_zext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i8 eq, q1, zr
; CHECK-NEXT:    vaddvat.u8 r0, q0
; CHECK-NEXT:    uxth r0, r0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <16 x i8> %b, zeroinitializer
  %xx = zext <16 x i8> %x to <16 x i16>
  %s = select <16 x i1> %c, <16 x i16> %xx, <16 x i16> zeroinitializer
  %z = call i16 @llvm.vector.reduce.add.v16i16(<16 x i16> %s)
  %r = add i16 %z, %a
  ret i16 %r
}

define arm_aapcs_vfpcc signext i16 @add_v16i8_v16i16_acc_sext(<16 x i8> %x, <16 x i8> %b, i16 %a) {
; CHECK-LABEL: add_v16i8_v16i16_acc_sext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i8 eq, q1, zr
; CHECK-NEXT:    vaddvat.s8 r0, q0
; CHECK-NEXT:    sxth r0, r0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <16 x i8> %b, zeroinitializer
  %xx = sext <16 x i8> %x to <16 x i16>
  %s = select <16 x i1> %c, <16 x i16> %xx, <16 x i16> zeroinitializer
  %z = call i16 @llvm.vector.reduce.add.v16i16(<16 x i16> %s)
  %r = add i16 %z, %a
  ret i16 %r
}

define arm_aapcs_vfpcc zeroext i16 @add_v8i8_v8i16_acc_zext(<8 x i8> %x, <8 x i8> %b, i16 %a) {
; CHECK-LABEL: add_v8i8_v8i16_acc_zext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmovlb.u8 q1, q1
; CHECK-NEXT:    vmovlb.u8 q0, q0
; CHECK-NEXT:    vpt.i16 eq, q1, zr
; CHECK-NEXT:    vaddvat.u16 r0, q0
; CHECK-NEXT:    uxth r0, r0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i8> %b, zeroinitializer
  %xx = zext <8 x i8> %x to <8 x i16>
  %s = select <8 x i1> %c, <8 x i16> %xx, <8 x i16> zeroinitializer
  %z = call i16 @llvm.vector.reduce.add.v8i16(<8 x i16> %s)
  %r = add i16 %z, %a
  ret i16 %r
}

define arm_aapcs_vfpcc signext i16 @add_v8i8_v8i16_acc_sext(<8 x i8> %x, <8 x i8> %b, i16 %a) {
; CHECK-LABEL: add_v8i8_v8i16_acc_sext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmovlb.u8 q1, q1
; CHECK-NEXT:    vmovlb.s8 q0, q0
; CHECK-NEXT:    vpt.i16 eq, q1, zr
; CHECK-NEXT:    vaddvat.u16 r0, q0
; CHECK-NEXT:    sxth r0, r0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i8> %b, zeroinitializer
  %xx = sext <8 x i8> %x to <8 x i16>
  %s = select <8 x i1> %c, <8 x i16> %xx, <8 x i16> zeroinitializer
  %z = call i16 @llvm.vector.reduce.add.v8i16(<8 x i16> %s)
  %r = add i16 %z, %a
  ret i16 %r
}

define arm_aapcs_vfpcc zeroext i8 @add_v16i8_v16i8_acc(<16 x i8> %x, <16 x i8> %b, i8 %a) {
; CHECK-LABEL: add_v16i8_v16i8_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i8 eq, q1, zr
; CHECK-NEXT:    vaddvat.u8 r0, q0
; CHECK-NEXT:    uxtb r0, r0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <16 x i8> %b, zeroinitializer
  %s = select <16 x i1> %c, <16 x i8> %x, <16 x i8> zeroinitializer
  %z = call i8 @llvm.vector.reduce.add.v16i8(<16 x i8> %s)
  %r = add i8 %z, %a
  ret i8 %r
}

define arm_aapcs_vfpcc i64 @add_v16i8_v16i64_acc_zext(<16 x i8> %x, <16 x i8> %b, i64 %a) {
; CHECK-LABEL: add_v16i8_v16i64_acc_zext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r7, lr}
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    .pad #16
; CHECK-NEXT:    sub sp, #16
; CHECK-NEXT:    vmov q2, q0
; CHECK-NEXT:    vcmp.i8 eq, q1, zr
; CHECK-NEXT:    vmov.i8 q0, #0x0
; CHECK-NEXT:    vmov.i8 q1, #0xff
; CHECK-NEXT:    vpsel q5, q1, q0
; CHECK-NEXT:    vstrw.32 q0, [sp] @ 16-byte Spill
; CHECK-NEXT:    vmov.u8 r2, q5[0]
; CHECK-NEXT:    vmov.16 q3[0], r2
; CHECK-NEXT:    vmov.u8 r2, q5[1]
; CHECK-NEXT:    vmov.16 q3[1], r2
; CHECK-NEXT:    vmov.u8 r2, q5[2]
; CHECK-NEXT:    vmov.16 q3[2], r2
; CHECK-NEXT:    vmov.u8 r2, q5[3]
; CHECK-NEXT:    vmov.16 q3[3], r2
; CHECK-NEXT:    vmov.u8 r2, q5[4]
; CHECK-NEXT:    vmov.16 q3[4], r2
; CHECK-NEXT:    vmov.u8 r2, q5[5]
; CHECK-NEXT:    vmov.16 q3[5], r2
; CHECK-NEXT:    vmov.u8 r2, q5[6]
; CHECK-NEXT:    vmov.16 q3[6], r2
; CHECK-NEXT:    vmov.u8 r2, q5[7]
; CHECK-NEXT:    vmov.16 q3[7], r2
; CHECK-NEXT:    vcmp.i16 ne, q3, zr
; CHECK-NEXT:    vpsel q6, q1, q0
; CHECK-NEXT:    vmov.u16 r2, q6[2]
; CHECK-NEXT:    vmov.u16 r3, q6[0]
; CHECK-NEXT:    vmov q3[2], q3[0], r3, r2
; CHECK-NEXT:    vmov.u16 r2, q6[3]
; CHECK-NEXT:    vmov.u16 r3, q6[1]
; CHECK-NEXT:    vmov q3[3], q3[1], r3, r2
; CHECK-NEXT:    vcmp.i32 ne, q3, zr
; CHECK-NEXT:    vpsel q7, q1, q0
; CHECK-NEXT:    vmov r2, r3, d14
; CHECK-NEXT:    vmov q3[2], q3[0], r2, r3
; CHECK-NEXT:    vmov q3[3], q3[1], r2, r3
; CHECK-NEXT:    vmov.u8 r2, q2[1]
; CHECK-NEXT:    vmov.u8 r3, q2[0]
; CHECK-NEXT:    vcmp.i32 ne, q3, zr
; CHECK-NEXT:    vmov q4[2], q4[0], r3, r2
; CHECK-NEXT:    vmov.i64 q3, #0xff
; CHECK-NEXT:    vand q0, q4, q3
; CHECK-NEXT:    vmov.i32 q4, #0x0
; CHECK-NEXT:    vpsel q0, q0, q4
; CHECK-NEXT:    vmov r12, lr, d1
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    orr.w lr, lr, r3
; CHECK-NEXT:    add r12, r2
; CHECK-NEXT:    vmov r3, r2, d15
; CHECK-NEXT:    vldrw.u32 q7, [sp] @ 16-byte Reload
; CHECK-NEXT:    vmov q0[2], q0[0], r3, r2
; CHECK-NEXT:    vmov q0[3], q0[1], r3, r2
; CHECK-NEXT:    vmov.u8 r2, q2[3]
; CHECK-NEXT:    vmov.u8 r3, q2[2]
; CHECK-NEXT:    vcmp.i32 ne, q0, zr
; CHECK-NEXT:    vmov q0[2], q0[0], r3, r2
; CHECK-NEXT:    vand q0, q0, q3
; CHECK-NEXT:    vpsel q0, q0, q4
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    adds.w r12, r12, r2
; CHECK-NEXT:    adc.w lr, lr, r3
; CHECK-NEXT:    vmov r2, r3, d1
; CHECK-NEXT:    adds.w r12, r12, r2
; CHECK-NEXT:    vmov.u16 r2, q6[6]
; CHECK-NEXT:    adc.w lr, lr, r3
; CHECK-NEXT:    vmov.u16 r3, q6[4]
; CHECK-NEXT:    vmov q0[2], q0[0], r3, r2
; CHECK-NEXT:    vmov.u16 r2, q6[7]
; CHECK-NEXT:    vmov.u16 r3, q6[5]
; CHECK-NEXT:    vmov q0[3], q0[1], r3, r2
; CHECK-NEXT:    vcmp.i32 ne, q0, zr
; CHECK-NEXT:    vpsel q6, q1, q7
; CHECK-NEXT:    vmov r2, r3, d12
; CHECK-NEXT:    vmov q0[2], q0[0], r2, r3
; CHECK-NEXT:    vmov q0[3], q0[1], r2, r3
; CHECK-NEXT:    vmov.u8 r2, q2[5]
; CHECK-NEXT:    vmov.u8 r3, q2[4]
; CHECK-NEXT:    vcmp.i32 ne, q0, zr
; CHECK-NEXT:    vmov q0[2], q0[0], r3, r2
; CHECK-NEXT:    vand q0, q0, q3
; CHECK-NEXT:    vpsel q0, q0, q4
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    adds.w r12, r12, r2
; CHECK-NEXT:    adc.w lr, lr, r3
; CHECK-NEXT:    vmov r2, r3, d1
; CHECK-NEXT:    adds.w r12, r12, r2
; CHECK-NEXT:    adc.w lr, lr, r3
; CHECK-NEXT:    vmov r2, r3, d13
; CHECK-NEXT:    vmov q0[2], q0[0], r2, r3
; CHECK-NEXT:    vmov q0[3], q0[1], r2, r3
; CHECK-NEXT:    vmov.u8 r2, q2[7]
; CHECK-NEXT:    vmov.u8 r3, q2[6]
; CHECK-NEXT:    vcmp.i32 ne, q0, zr
; CHECK-NEXT:    vmov q0[2], q0[0], r3, r2
; CHECK-NEXT:    vand q0, q0, q3
; CHECK-NEXT:    vpsel q0, q0, q4
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    adds.w r12, r12, r2
; CHECK-NEXT:    adc.w lr, lr, r3
; CHECK-NEXT:    vmov r2, r3, d1
; CHECK-NEXT:    adds.w r12, r12, r2
; CHECK-NEXT:    vmov.u8 r2, q5[8]
; CHECK-NEXT:    vmov.16 q6[0], r2
; CHECK-NEXT:    vmov.u8 r2, q5[9]
; CHECK-NEXT:    vmov.16 q6[1], r2
; CHECK-NEXT:    vmov.u8 r2, q5[10]
; CHECK-NEXT:    vmov.16 q6[2], r2
; CHECK-NEXT:    vmov.u8 r2, q5[11]
; CHECK-NEXT:    vmov.16 q6[3], r2
; CHECK-NEXT:    vmov.u8 r2, q5[12]
; CHECK-NEXT:    vmov.16 q6[4], r2
; CHECK-NEXT:    vmov.u8 r2, q5[13]
; CHECK-NEXT:    vmov.16 q6[5], r2
; CHECK-NEXT:    vmov.u8 r2, q5[14]
; CHECK-NEXT:    vmov.16 q6[6], r2
; CHECK-NEXT:    vmov.u8 r2, q5[15]
; CHECK-NEXT:    vmov.16 q6[7], r2
; CHECK-NEXT:    adc.w lr, lr, r3
; CHECK-NEXT:    vcmp.i16 ne, q6, zr
; CHECK-NEXT:    vpsel q5, q1, q7
; CHECK-NEXT:    vmov.u16 r2, q5[2]
; CHECK-NEXT:    vmov.u16 r3, q5[0]
; CHECK-NEXT:    vmov q0[2], q0[0], r3, r2
; CHECK-NEXT:    vmov.u16 r2, q5[3]
; CHECK-NEXT:    vmov.u16 r3, q5[1]
; CHECK-NEXT:    vmov q0[3], q0[1], r3, r2
; CHECK-NEXT:    vcmp.i32 ne, q0, zr
; CHECK-NEXT:    vpsel q6, q1, q7
; CHECK-NEXT:    vmov r2, r3, d12
; CHECK-NEXT:    vmov q0[2], q0[0], r2, r3
; CHECK-NEXT:    vmov q0[3], q0[1], r2, r3
; CHECK-NEXT:    vmov.u8 r2, q2[9]
; CHECK-NEXT:    vmov.u8 r3, q2[8]
; CHECK-NEXT:    vcmp.i32 ne, q0, zr
; CHECK-NEXT:    vmov q0[2], q0[0], r3, r2
; CHECK-NEXT:    vand q0, q0, q3
; CHECK-NEXT:    vpsel q0, q0, q4
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    adds.w r12, r12, r2
; CHECK-NEXT:    adc.w lr, lr, r3
; CHECK-NEXT:    vmov r2, r3, d1
; CHECK-NEXT:    adds.w r12, r12, r2
; CHECK-NEXT:    adc.w lr, lr, r3
; CHECK-NEXT:    vmov r2, r3, d13
; CHECK-NEXT:    vmov q0[2], q0[0], r2, r3
; CHECK-NEXT:    vmov q0[3], q0[1], r2, r3
; CHECK-NEXT:    vmov.u8 r2, q2[11]
; CHECK-NEXT:    vmov.u8 r3, q2[10]
; CHECK-NEXT:    vcmp.i32 ne, q0, zr
; CHECK-NEXT:    vmov q0[2], q0[0], r3, r2
; CHECK-NEXT:    vand q0, q0, q3
; CHECK-NEXT:    vpsel q0, q0, q4
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    adds.w r12, r12, r2
; CHECK-NEXT:    adc.w lr, lr, r3
; CHECK-NEXT:    vmov r2, r3, d1
; CHECK-NEXT:    adds.w r12, r12, r2
; CHECK-NEXT:    vmov.u16 r2, q5[6]
; CHECK-NEXT:    adc.w lr, lr, r3
; CHECK-NEXT:    vmov.u16 r3, q5[4]
; CHECK-NEXT:    vmov q0[2], q0[0], r3, r2
; CHECK-NEXT:    vmov.u16 r2, q5[7]
; CHECK-NEXT:    vmov.u16 r3, q5[5]
; CHECK-NEXT:    vmov q0[3], q0[1], r3, r2
; CHECK-NEXT:    vcmp.i32 ne, q0, zr
; CHECK-NEXT:    vpsel q1, q1, q7
; CHECK-NEXT:    vmov r2, r3, d2
; CHECK-NEXT:    vmov q0[2], q0[0], r2, r3
; CHECK-NEXT:    vmov q0[3], q0[1], r2, r3
; CHECK-NEXT:    vmov.u8 r2, q2[13]
; CHECK-NEXT:    vmov.u8 r3, q2[12]
; CHECK-NEXT:    vcmp.i32 ne, q0, zr
; CHECK-NEXT:    vmov q0[2], q0[0], r3, r2
; CHECK-NEXT:    vand q0, q0, q3
; CHECK-NEXT:    vpsel q0, q0, q4
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    adds.w r12, r12, r2
; CHECK-NEXT:    adc.w lr, lr, r3
; CHECK-NEXT:    vmov r2, r3, d1
; CHECK-NEXT:    adds.w r12, r12, r2
; CHECK-NEXT:    adc.w lr, lr, r3
; CHECK-NEXT:    vmov r2, r3, d3
; CHECK-NEXT:    vmov q0[2], q0[0], r2, r3
; CHECK-NEXT:    vmov q0[3], q0[1], r2, r3
; CHECK-NEXT:    vmov.u8 r2, q2[15]
; CHECK-NEXT:    vmov.u8 r3, q2[14]
; CHECK-NEXT:    vcmp.i32 ne, q0, zr
; CHECK-NEXT:    vmov q0[2], q0[0], r3, r2
; CHECK-NEXT:    vand q0, q0, q3
; CHECK-NEXT:    vpsel q0, q0, q4
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    adds.w r12, r12, r2
; CHECK-NEXT:    adc.w lr, lr, r3
; CHECK-NEXT:    vmov r2, r3, d1
; CHECK-NEXT:    adds.w r2, r2, r12
; CHECK-NEXT:    adc.w r3, r3, lr
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    add sp, #16
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    pop {r7, pc}
entry:
  %c = icmp eq <16 x i8> %b, zeroinitializer
  %xx = zext <16 x i8> %x to <16 x i64>
  %s = select <16 x i1> %c, <16 x i64> %xx, <16 x i64> zeroinitializer
  %z = call i64 @llvm.vector.reduce.add.v16i64(<16 x i64> %s)
  %r = add i64 %z, %a
  ret i64 %r
}

define arm_aapcs_vfpcc i64 @add_v16i8_v16i64_acc_sext(<16 x i8> %x, <16 x i8> %b, i64 %a) {
; CHECK-LABEL: add_v16i8_v16i64_acc_sext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r7, lr}
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vcmp.i8 eq, q1, zr
; CHECK-NEXT:    vmov.i8 q1, #0x0
; CHECK-NEXT:    vmov.i8 q2, #0xff
; CHECK-NEXT:    vpsel q4, q2, q1
; CHECK-NEXT:    vmov.u8 r2, q4[0]
; CHECK-NEXT:    vmov.16 q3[0], r2
; CHECK-NEXT:    vmov.u8 r2, q4[1]
; CHECK-NEXT:    vmov.16 q3[1], r2
; CHECK-NEXT:    vmov.u8 r2, q4[2]
; CHECK-NEXT:    vmov.16 q3[2], r2
; CHECK-NEXT:    vmov.u8 r2, q4[3]
; CHECK-NEXT:    vmov.16 q3[3], r2
; CHECK-NEXT:    vmov.u8 r2, q4[4]
; CHECK-NEXT:    vmov.16 q3[4], r2
; CHECK-NEXT:    vmov.u8 r2, q4[5]
; CHECK-NEXT:    vmov.16 q3[5], r2
; CHECK-NEXT:    vmov.u8 r2, q4[6]
; CHECK-NEXT:    vmov.16 q3[6], r2
; CHECK-NEXT:    vmov.u8 r2, q4[7]
; CHECK-NEXT:    vmov.16 q3[7], r2
; CHECK-NEXT:    vcmp.i16 ne, q3, zr
; CHECK-NEXT:    vpsel q5, q2, q1
; CHECK-NEXT:    vmov.u16 r2, q5[2]
; CHECK-NEXT:    vmov.u16 r3, q5[0]
; CHECK-NEXT:    vmov q3[2], q3[0], r3, r2
; CHECK-NEXT:    vmov.u16 r2, q5[3]
; CHECK-NEXT:    vmov.u16 r3, q5[1]
; CHECK-NEXT:    vmov q3[3], q3[1], r3, r2
; CHECK-NEXT:    vcmp.i32 ne, q3, zr
; CHECK-NEXT:    vpsel q6, q2, q1
; CHECK-NEXT:    vmov r2, r3, d12
; CHECK-NEXT:    vmov q3[2], q3[0], r2, r3
; CHECK-NEXT:    vmov q3[3], q3[1], r2, r3
; CHECK-NEXT:    vmov.s8 r2, q0[1]
; CHECK-NEXT:    vmov.s8 r3, q0[0]
; CHECK-NEXT:    vcmp.i32 ne, q3, zr
; CHECK-NEXT:    vmov q7[2], q7[0], r3, r2
; CHECK-NEXT:    asrs r2, r2, #31
; CHECK-NEXT:    asrs r3, r3, #31
; CHECK-NEXT:    vmov.i32 q3, #0x0
; CHECK-NEXT:    vmov q7[3], q7[1], r3, r2
; CHECK-NEXT:    vpsel q7, q7, q3
; CHECK-NEXT:    vmov lr, r12, d15
; CHECK-NEXT:    vmov r3, r2, d14
; CHECK-NEXT:    adds.w lr, lr, r3
; CHECK-NEXT:    adc.w r12, r12, r2
; CHECK-NEXT:    vmov r2, r3, d13
; CHECK-NEXT:    vmov q6[2], q6[0], r2, r3
; CHECK-NEXT:    vmov q6[3], q6[1], r2, r3
; CHECK-NEXT:    vmov.s8 r2, q0[3]
; CHECK-NEXT:    vmov.s8 r3, q0[2]
; CHECK-NEXT:    vcmp.i32 ne, q6, zr
; CHECK-NEXT:    vmov q6[2], q6[0], r3, r2
; CHECK-NEXT:    asrs r2, r2, #31
; CHECK-NEXT:    asrs r3, r3, #31
; CHECK-NEXT:    vmov q6[3], q6[1], r3, r2
; CHECK-NEXT:    vpsel q6, q6, q3
; CHECK-NEXT:    vmov r2, r3, d12
; CHECK-NEXT:    adds.w lr, lr, r2
; CHECK-NEXT:    adc.w r12, r12, r3
; CHECK-NEXT:    vmov r2, r3, d13
; CHECK-NEXT:    adds.w lr, lr, r2
; CHECK-NEXT:    vmov.u16 r2, q5[6]
; CHECK-NEXT:    adc.w r12, r12, r3
; CHECK-NEXT:    vmov.u16 r3, q5[4]
; CHECK-NEXT:    vmov q6[2], q6[0], r3, r2
; CHECK-NEXT:    vmov.u16 r2, q5[7]
; CHECK-NEXT:    vmov.u16 r3, q5[5]
; CHECK-NEXT:    vmov q6[3], q6[1], r3, r2
; CHECK-NEXT:    vcmp.i32 ne, q6, zr
; CHECK-NEXT:    vpsel q5, q2, q1
; CHECK-NEXT:    vmov r2, r3, d10
; CHECK-NEXT:    vmov q6[2], q6[0], r2, r3
; CHECK-NEXT:    vmov q6[3], q6[1], r2, r3
; CHECK-NEXT:    vmov.s8 r2, q0[5]
; CHECK-NEXT:    vmov.s8 r3, q0[4]
; CHECK-NEXT:    vcmp.i32 ne, q6, zr
; CHECK-NEXT:    vmov q6[2], q6[0], r3, r2
; CHECK-NEXT:    asrs r2, r2, #31
; CHECK-NEXT:    asrs r3, r3, #31
; CHECK-NEXT:    vmov q6[3], q6[1], r3, r2
; CHECK-NEXT:    vpsel q6, q6, q3
; CHECK-NEXT:    vmov r2, r3, d12
; CHECK-NEXT:    adds.w lr, lr, r2
; CHECK-NEXT:    adc.w r12, r12, r3
; CHECK-NEXT:    vmov r2, r3, d13
; CHECK-NEXT:    adds.w lr, lr, r2
; CHECK-NEXT:    adc.w r12, r12, r3
; CHECK-NEXT:    vmov r2, r3, d11
; CHECK-NEXT:    vmov q5[2], q5[0], r2, r3
; CHECK-NEXT:    vmov q5[3], q5[1], r2, r3
; CHECK-NEXT:    vmov.s8 r2, q0[7]
; CHECK-NEXT:    vmov.s8 r3, q0[6]
; CHECK-NEXT:    vcmp.i32 ne, q5, zr
; CHECK-NEXT:    vmov q5[2], q5[0], r3, r2
; CHECK-NEXT:    asrs r2, r2, #31
; CHECK-NEXT:    asrs r3, r3, #31
; CHECK-NEXT:    vmov q5[3], q5[1], r3, r2
; CHECK-NEXT:    vpsel q5, q5, q3
; CHECK-NEXT:    vmov r2, r3, d10
; CHECK-NEXT:    adds.w lr, lr, r2
; CHECK-NEXT:    adc.w r12, r12, r3
; CHECK-NEXT:    vmov r2, r3, d11
; CHECK-NEXT:    adds.w lr, lr, r2
; CHECK-NEXT:    vmov.u8 r2, q4[8]
; CHECK-NEXT:    vmov.16 q5[0], r2
; CHECK-NEXT:    vmov.u8 r2, q4[9]
; CHECK-NEXT:    vmov.16 q5[1], r2
; CHECK-NEXT:    vmov.u8 r2, q4[10]
; CHECK-NEXT:    vmov.16 q5[2], r2
; CHECK-NEXT:    vmov.u8 r2, q4[11]
; CHECK-NEXT:    vmov.16 q5[3], r2
; CHECK-NEXT:    vmov.u8 r2, q4[12]
; CHECK-NEXT:    vmov.16 q5[4], r2
; CHECK-NEXT:    vmov.u8 r2, q4[13]
; CHECK-NEXT:    vmov.16 q5[5], r2
; CHECK-NEXT:    vmov.u8 r2, q4[14]
; CHECK-NEXT:    vmov.16 q5[6], r2
; CHECK-NEXT:    vmov.u8 r2, q4[15]
; CHECK-NEXT:    vmov.16 q5[7], r2
; CHECK-NEXT:    adc.w r12, r12, r3
; CHECK-NEXT:    vcmp.i16 ne, q5, zr
; CHECK-NEXT:    vpsel q4, q2, q1
; CHECK-NEXT:    vmov.u16 r2, q4[2]
; CHECK-NEXT:    vmov.u16 r3, q4[0]
; CHECK-NEXT:    vmov q5[2], q5[0], r3, r2
; CHECK-NEXT:    vmov.u16 r2, q4[3]
; CHECK-NEXT:    vmov.u16 r3, q4[1]
; CHECK-NEXT:    vmov q5[3], q5[1], r3, r2
; CHECK-NEXT:    vcmp.i32 ne, q5, zr
; CHECK-NEXT:    vpsel q5, q2, q1
; CHECK-NEXT:    vmov r2, r3, d10
; CHECK-NEXT:    vmov q6[2], q6[0], r2, r3
; CHECK-NEXT:    vmov q6[3], q6[1], r2, r3
; CHECK-NEXT:    vmov.s8 r2, q0[9]
; CHECK-NEXT:    vmov.s8 r3, q0[8]
; CHECK-NEXT:    vcmp.i32 ne, q6, zr
; CHECK-NEXT:    vmov q6[2], q6[0], r3, r2
; CHECK-NEXT:    asrs r2, r2, #31
; CHECK-NEXT:    asrs r3, r3, #31
; CHECK-NEXT:    vmov q6[3], q6[1], r3, r2
; CHECK-NEXT:    vpsel q6, q6, q3
; CHECK-NEXT:    vmov r2, r3, d12
; CHECK-NEXT:    adds.w lr, lr, r2
; CHECK-NEXT:    adc.w r12, r12, r3
; CHECK-NEXT:    vmov r2, r3, d13
; CHECK-NEXT:    adds.w lr, lr, r2
; CHECK-NEXT:    adc.w r12, r12, r3
; CHECK-NEXT:    vmov r2, r3, d11
; CHECK-NEXT:    vmov q5[2], q5[0], r2, r3
; CHECK-NEXT:    vmov q5[3], q5[1], r2, r3
; CHECK-NEXT:    vmov.s8 r2, q0[11]
; CHECK-NEXT:    vmov.s8 r3, q0[10]
; CHECK-NEXT:    vcmp.i32 ne, q5, zr
; CHECK-NEXT:    vmov q5[2], q5[0], r3, r2
; CHECK-NEXT:    asrs r2, r2, #31
; CHECK-NEXT:    asrs r3, r3, #31
; CHECK-NEXT:    vmov q5[3], q5[1], r3, r2
; CHECK-NEXT:    vpsel q5, q5, q3
; CHECK-NEXT:    vmov r2, r3, d10
; CHECK-NEXT:    adds.w lr, lr, r2
; CHECK-NEXT:    adc.w r12, r12, r3
; CHECK-NEXT:    vmov r2, r3, d11
; CHECK-NEXT:    adds.w lr, lr, r2
; CHECK-NEXT:    vmov.u16 r2, q4[6]
; CHECK-NEXT:    adc.w r12, r12, r3
; CHECK-NEXT:    vmov.u16 r3, q4[4]
; CHECK-NEXT:    vmov q5[2], q5[0], r3, r2
; CHECK-NEXT:    vmov.u16 r2, q4[7]
; CHECK-NEXT:    vmov.u16 r3, q4[5]
; CHECK-NEXT:    vmov q5[3], q5[1], r3, r2
; CHECK-NEXT:    vcmp.i32 ne, q5, zr
; CHECK-NEXT:    vpsel q1, q2, q1
; CHECK-NEXT:    vmov r2, r3, d2
; CHECK-NEXT:    vmov q2[2], q2[0], r2, r3
; CHECK-NEXT:    vmov q2[3], q2[1], r2, r3
; CHECK-NEXT:    vmov.s8 r2, q0[13]
; CHECK-NEXT:    vmov.s8 r3, q0[12]
; CHECK-NEXT:    vcmp.i32 ne, q2, zr
; CHECK-NEXT:    vmov q2[2], q2[0], r3, r2
; CHECK-NEXT:    asrs r2, r2, #31
; CHECK-NEXT:    asrs r3, r3, #31
; CHECK-NEXT:    vmov q2[3], q2[1], r3, r2
; CHECK-NEXT:    vpsel q2, q2, q3
; CHECK-NEXT:    vmov r2, r3, d4
; CHECK-NEXT:    adds.w lr, lr, r2
; CHECK-NEXT:    adc.w r12, r12, r3
; CHECK-NEXT:    vmov r2, r3, d5
; CHECK-NEXT:    adds.w lr, lr, r2
; CHECK-NEXT:    adc.w r12, r12, r3
; CHECK-NEXT:    vmov r2, r3, d3
; CHECK-NEXT:    vmov q1[2], q1[0], r2, r3
; CHECK-NEXT:    vmov q1[3], q1[1], r2, r3
; CHECK-NEXT:    vmov.s8 r2, q0[15]
; CHECK-NEXT:    vmov.s8 r3, q0[14]
; CHECK-NEXT:    vcmp.i32 ne, q1, zr
; CHECK-NEXT:    vmov q0[2], q0[0], r3, r2
; CHECK-NEXT:    asrs r2, r2, #31
; CHECK-NEXT:    asrs r3, r3, #31
; CHECK-NEXT:    vmov q0[3], q0[1], r3, r2
; CHECK-NEXT:    vpsel q0, q0, q3
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    adds.w lr, lr, r2
; CHECK-NEXT:    adc.w r12, r12, r3
; CHECK-NEXT:    vmov r2, r3, d1
; CHECK-NEXT:    adds.w r2, r2, lr
; CHECK-NEXT:    adc.w r3, r3, r12
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    pop {r7, pc}
entry:
  %c = icmp eq <16 x i8> %b, zeroinitializer
  %xx = sext <16 x i8> %x to <16 x i64>
  %s = select <16 x i1> %c, <16 x i64> %xx, <16 x i64> zeroinitializer
  %z = call i64 @llvm.vector.reduce.add.v16i64(<16 x i64> %s)
  %r = add i64 %z, %a
  ret i64 %r
}

define arm_aapcs_vfpcc i64 @add_v2i8_v2i64_acc_zext(<2 x i8> %x, <2 x i8> %b, i64 %a) {
; CHECK-LABEL: add_v2i8_v2i64_acc_zext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r7, lr}
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    vmov.i64 q2, #0xff
; CHECK-NEXT:    movs r3, #0
; CHECK-NEXT:    vand q1, q1, q2
; CHECK-NEXT:    vand q0, q0, q2
; CHECK-NEXT:    vmov r2, s4
; CHECK-NEXT:    cmp r2, #0
; CHECK-NEXT:    csetm r2, eq
; CHECK-NEXT:    bfi r3, r2, #0, #8
; CHECK-NEXT:    vmov r2, s6
; CHECK-NEXT:    vmov.i32 q1, #0x0
; CHECK-NEXT:    cmp r2, #0
; CHECK-NEXT:    csetm r2, eq
; CHECK-NEXT:    bfi r3, r2, #8, #8
; CHECK-NEXT:    vmsr p0, r3
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    vmov r12, lr, d1
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    add r2, r12
; CHECK-NEXT:    orr.w r3, r3, lr
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    pop {r7, pc}
entry:
  %c = icmp eq <2 x i8> %b, zeroinitializer
  %xx = zext <2 x i8> %x to <2 x i64>
  %s = select <2 x i1> %c, <2 x i64> %xx, <2 x i64> zeroinitializer
  %z = call i64 @llvm.vector.reduce.add.v2i64(<2 x i64> %s)
  %r = add i64 %z, %a
  ret i64 %r
}

define arm_aapcs_vfpcc i64 @add_v2i8_v2i64_acc_sext(<2 x i8> %x, <2 x i8> %b, i64 %a) {
; CHECK-LABEL: add_v2i8_v2i64_acc_sext:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r7, lr}
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    vmov.i32 q2, #0xff
; CHECK-NEXT:    movs r3, #0
; CHECK-NEXT:    vand q1, q1, q2
; CHECK-NEXT:    vmov r2, s4
; CHECK-NEXT:    cmp r2, #0
; CHECK-NEXT:    csetm r2, eq
; CHECK-NEXT:    bfi r3, r2, #0, #8
; CHECK-NEXT:    vmov r2, s6
; CHECK-NEXT:    vmov.i32 q1, #0x0
; CHECK-NEXT:    cmp r2, #0
; CHECK-NEXT:    csetm r2, eq
; CHECK-NEXT:    bfi r3, r2, #8, #8
; CHECK-NEXT:    vmov r2, s2
; CHECK-NEXT:    vmsr p0, r3
; CHECK-NEXT:    vmov r3, s0
; CHECK-NEXT:    sxtb r2, r2
; CHECK-NEXT:    sxtb r3, r3
; CHECK-NEXT:    vmov q0[2], q0[0], r3, r2
; CHECK-NEXT:    asrs r2, r2, #31
; CHECK-NEXT:    asrs r3, r3, #31
; CHECK-NEXT:    vmov q0[3], q0[1], r3, r2
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    vmov lr, r12, d1
; CHECK-NEXT:    vmov r3, r2, d0
; CHECK-NEXT:    adds.w r3, r3, lr
; CHECK-NEXT:    adc.w r2, r2, r12
; CHECK-NEXT:    adds r0, r0, r3
; CHECK-NEXT:    adcs r1, r2
; CHECK-NEXT:    pop {r7, pc}
entry:
  %c = icmp eq <2 x i8> %b, zeroinitializer
  %xx = sext <2 x i8> %x to <2 x i64>
  %s = select <2 x i1> %c, <2 x i64> %xx, <2 x i64> zeroinitializer
  %z = call i64 @llvm.vector.reduce.add.v2i64(<2 x i64> %s)
  %r = add i64 %z, %a
  ret i64 %r
}

define arm_aapcs_vfpcc i64 @add_v2i64_v2i64_acc(<2 x i64> %x, <2 x i64> %b, i64 %a) {
; CHECK-LABEL: add_v2i64_v2i64_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r7, lr}
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    vmov r2, r3, d2
; CHECK-NEXT:    mov.w r12, #0
; CHECK-NEXT:    orrs r2, r3
; CHECK-NEXT:    csetm r2, eq
; CHECK-NEXT:    bfi r12, r2, #0, #8
; CHECK-NEXT:    vmov r2, r3, d3
; CHECK-NEXT:    vmov.i32 q1, #0x0
; CHECK-NEXT:    orrs r2, r3
; CHECK-NEXT:    csetm r2, eq
; CHECK-NEXT:    bfi r12, r2, #8, #8
; CHECK-NEXT:    vmsr p0, r12
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    vmov lr, r12, d1
; CHECK-NEXT:    vmov r3, r2, d0
; CHECK-NEXT:    adds.w r3, r3, lr
; CHECK-NEXT:    adc.w r2, r2, r12
; CHECK-NEXT:    adds r0, r0, r3
; CHECK-NEXT:    adcs r1, r2
; CHECK-NEXT:    pop {r7, pc}
entry:
  %c = icmp eq <2 x i64> %b, zeroinitializer
  %s = select <2 x i1> %c, <2 x i64> %x, <2 x i64> zeroinitializer
  %z = call i64 @llvm.vector.reduce.add.v2i64(<2 x i64> %s)
  %r = add i64 %z, %a
  ret i64 %r
}

declare i16 @llvm.vector.reduce.add.v16i16(<16 x i16>)
declare i16 @llvm.vector.reduce.add.v8i16(<8 x i16>)
declare i32 @llvm.vector.reduce.add.v16i32(<16 x i32>)
declare i32 @llvm.vector.reduce.add.v4i32(<4 x i32>)
declare i32 @llvm.vector.reduce.add.v8i32(<8 x i32>)
declare i64 @llvm.vector.reduce.add.v16i64(<16 x i64>)
declare i64 @llvm.vector.reduce.add.v2i64(<2 x i64>)
declare i64 @llvm.vector.reduce.add.v4i64(<4 x i64>)
declare i64 @llvm.vector.reduce.add.v8i64(<8 x i64>)
declare i8 @llvm.vector.reduce.add.v16i8(<16 x i8>)
