; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,SSE2
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mattr=+sse4.2 | FileCheck %s --check-prefixes=SSE,SSE4
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mattr=+avx | FileCheck %s --check-prefixes=AVX,AVX1
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX2
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mattr=+avx512f | FileCheck %s --check-prefixes=AVX512
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mattr=+avx512f,+avx512bw | FileCheck %s --check-prefixes=AVX512
;
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mcpu=slm | FileCheck %s --check-prefixes=SSE,SSE4
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mcpu=goldmont | FileCheck %s --check-prefixes=SSE,SSE4
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mcpu=btver2 | FileCheck %s --check-prefixes=AVX,AVX1

define i32 @f32(i32 %arg) {
; SSE2-LABEL: 'f32'
; SSE2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:7 Lat:5 SizeLat:7 for: %F32 = call float @llvm.maxnum.f32(float undef, float undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:6 Lat:6 SizeLat:6 for: %V2F32 = call <2 x float> @llvm.maxnum.v2f32(<2 x float> undef, <2 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:6 Lat:6 SizeLat:6 for: %V4F32 = call <4 x float> @llvm.maxnum.v4f32(<4 x float> undef, <4 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:12 Lat:12 SizeLat:12 for: %V8F32 = call <8 x float> @llvm.maxnum.v8f32(<8 x float> undef, <8 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:24 Lat:24 SizeLat:24 for: %V16F32 = call <16 x float> @llvm.maxnum.v16f32(<16 x float> undef, <16 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE4-LABEL: 'f32'
; SSE4-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:7 Lat:5 SizeLat:7 for: %F32 = call float @llvm.maxnum.f32(float undef, float undef)
; SSE4-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:5 for: %V2F32 = call <2 x float> @llvm.maxnum.v2f32(<2 x float> undef, <2 x float> undef)
; SSE4-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:5 for: %V4F32 = call <4 x float> @llvm.maxnum.v4f32(<4 x float> undef, <4 x float> undef)
; SSE4-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:10 for: %V8F32 = call <8 x float> @llvm.maxnum.v8f32(<8 x float> undef, <8 x float> undef)
; SSE4-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:16 Lat:16 SizeLat:20 for: %V16F32 = call <16 x float> @llvm.maxnum.v16f32(<16 x float> undef, <16 x float> undef)
; SSE4-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'f32'
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:6 SizeLat:5 for: %F32 = call float @llvm.maxnum.f32(float undef, float undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:6 SizeLat:5 for: %V2F32 = call <2 x float> @llvm.maxnum.v2f32(<2 x float> undef, <2 x float> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:6 SizeLat:5 for: %V4F32 = call <4 x float> @llvm.maxnum.v4f32(<4 x float> undef, <4 x float> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:3 Lat:7 SizeLat:10 for: %V8F32 = call <8 x float> @llvm.maxnum.v8f32(<8 x float> undef, <8 x float> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:6 Lat:14 SizeLat:20 for: %V16F32 = call <16 x float> @llvm.maxnum.v16f32(<16 x float> undef, <16 x float> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'f32'
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:7 SizeLat:5 for: %F32 = call float @llvm.maxnum.f32(float undef, float undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:7 SizeLat:5 for: %V2F32 = call <2 x float> @llvm.maxnum.v2f32(<2 x float> undef, <2 x float> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:7 SizeLat:5 for: %V4F32 = call <4 x float> @llvm.maxnum.v4f32(<4 x float> undef, <4 x float> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:7 SizeLat:6 for: %V8F32 = call <8 x float> @llvm.maxnum.v8f32(<8 x float> undef, <8 x float> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:14 SizeLat:12 for: %V16F32 = call <16 x float> @llvm.maxnum.v16f32(<16 x float> undef, <16 x float> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'f32'
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:2 SizeLat:3 for: %F32 = call float @llvm.maxnum.f32(float undef, float undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:3 Lat:1 SizeLat:3 for: %V2F32 = call <2 x float> @llvm.maxnum.v2f32(<2 x float> undef, <2 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:3 Lat:1 SizeLat:3 for: %V4F32 = call <4 x float> @llvm.maxnum.v4f32(<4 x float> undef, <4 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:2 SizeLat:3 for: %V8F32 = call <8 x float> @llvm.maxnum.v8f32(<8 x float> undef, <8 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:3 Lat:4 SizeLat:3 for: %V16F32 = call <16 x float> @llvm.maxnum.v16f32(<16 x float> undef, <16 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %F32 = call float @llvm.maxnum.f32(float undef, float undef)
  %V2F32 = call <2 x float> @llvm.maxnum.v2f32(<2 x float> undef, <2 x float> undef)
  %V4F32 = call <4 x float> @llvm.maxnum.v4f32(<4 x float> undef, <4 x float> undef)
  %V8F32 = call <8 x float> @llvm.maxnum.v8f32(<8 x float> undef, <8 x float> undef)
  %V16F32 = call <16 x float> @llvm.maxnum.v16f32(<16 x float> undef, <16 x float> undef)
  ret i32 undef
}

define i32 @f64(i32 %arg) {
; SSE2-LABEL: 'f64'
; SSE2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:7 Lat:5 SizeLat:7 for: %f64 = call double @llvm.maxnum.f64(double undef, double undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:6 Lat:6 SizeLat:6 for: %V2f64 = call <2 x double> @llvm.maxnum.v2f64(<2 x double> undef, <2 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:12 Lat:12 SizeLat:12 for: %V4f64 = call <4 x double> @llvm.maxnum.v4f64(<4 x double> undef, <4 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:24 Lat:24 SizeLat:24 for: %V8f64 = call <8 x double> @llvm.maxnum.v8f64(<8 x double> undef, <8 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:48 Lat:48 SizeLat:48 for: %V16f64 = call <16 x double> @llvm.maxnum.v16f64(<16 x double> undef, <16 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE4-LABEL: 'f64'
; SSE4-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:7 Lat:5 SizeLat:7 for: %f64 = call double @llvm.maxnum.f64(double undef, double undef)
; SSE4-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:5 for: %V2f64 = call <2 x double> @llvm.maxnum.v2f64(<2 x double> undef, <2 x double> undef)
; SSE4-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:10 for: %V4f64 = call <4 x double> @llvm.maxnum.v4f64(<4 x double> undef, <4 x double> undef)
; SSE4-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:16 Lat:16 SizeLat:20 for: %V8f64 = call <8 x double> @llvm.maxnum.v8f64(<8 x double> undef, <8 x double> undef)
; SSE4-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:32 Lat:32 SizeLat:40 for: %V16f64 = call <16 x double> @llvm.maxnum.v16f64(<16 x double> undef, <16 x double> undef)
; SSE4-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'f64'
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:6 SizeLat:5 for: %f64 = call double @llvm.maxnum.f64(double undef, double undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:6 SizeLat:5 for: %V2f64 = call <2 x double> @llvm.maxnum.v2f64(<2 x double> undef, <2 x double> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:3 Lat:7 SizeLat:10 for: %V4f64 = call <4 x double> @llvm.maxnum.v4f64(<4 x double> undef, <4 x double> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:6 Lat:14 SizeLat:20 for: %V8f64 = call <8 x double> @llvm.maxnum.v8f64(<8 x double> undef, <8 x double> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:12 Lat:28 SizeLat:40 for: %V16f64 = call <16 x double> @llvm.maxnum.v16f64(<16 x double> undef, <16 x double> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'f64'
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:7 SizeLat:5 for: %f64 = call double @llvm.maxnum.f64(double undef, double undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:7 SizeLat:5 for: %V2f64 = call <2 x double> @llvm.maxnum.v2f64(<2 x double> undef, <2 x double> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:7 SizeLat:6 for: %V4f64 = call <4 x double> @llvm.maxnum.v4f64(<4 x double> undef, <4 x double> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:14 SizeLat:12 for: %V8f64 = call <8 x double> @llvm.maxnum.v8f64(<8 x double> undef, <8 x double> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:28 SizeLat:24 for: %V16f64 = call <16 x double> @llvm.maxnum.v16f64(<16 x double> undef, <16 x double> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'f64'
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:2 SizeLat:3 for: %f64 = call double @llvm.maxnum.f64(double undef, double undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:3 Lat:1 SizeLat:3 for: %V2f64 = call <2 x double> @llvm.maxnum.v2f64(<2 x double> undef, <2 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:2 SizeLat:3 for: %V4f64 = call <4 x double> @llvm.maxnum.v4f64(<4 x double> undef, <4 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of 3 for: %V8f64 = call <8 x double> @llvm.maxnum.v8f64(<8 x double> undef, <8 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of 6 for: %V16f64 = call <16 x double> @llvm.maxnum.v16f64(<16 x double> undef, <16 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %f64 = call double @llvm.maxnum.f64(double undef, double undef)
  %V2f64 = call <2 x double> @llvm.maxnum.v2f64(<2 x double> undef, <2 x double> undef)
  %V4f64 = call <4 x double> @llvm.maxnum.v4f64(<4 x double> undef, <4 x double> undef)
  %V8f64 = call <8 x double> @llvm.maxnum.v8f64(<8 x double> undef, <8 x double> undef)
  %V16f64 = call <16 x double> @llvm.maxnum.v16f64(<16 x double> undef, <16 x double> undef)
  ret i32 undef
}

define i32 @f32_nnan(i32 %arg) {
; SSE-LABEL: 'f32_nnan'
; SSE-NEXT:  Cost Model: Found costs of 1 for: %F32 = call nnan float @llvm.maxnum.f32(float undef, float undef)
; SSE-NEXT:  Cost Model: Found costs of 1 for: %V2F32 = call nnan <2 x float> @llvm.maxnum.v2f32(<2 x float> undef, <2 x float> undef)
; SSE-NEXT:  Cost Model: Found costs of 1 for: %V4F32 = call nnan <4 x float> @llvm.maxnum.v4f32(<4 x float> undef, <4 x float> undef)
; SSE-NEXT:  Cost Model: Found costs of 2 for: %V8F32 = call nnan <8 x float> @llvm.maxnum.v8f32(<8 x float> undef, <8 x float> undef)
; SSE-NEXT:  Cost Model: Found costs of 4 for: %V16F32 = call nnan <16 x float> @llvm.maxnum.v16f32(<16 x float> undef, <16 x float> undef)
; SSE-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX-LABEL: 'f32_nnan'
; AVX-NEXT:  Cost Model: Found costs of 1 for: %F32 = call nnan float @llvm.maxnum.f32(float undef, float undef)
; AVX-NEXT:  Cost Model: Found costs of 1 for: %V2F32 = call nnan <2 x float> @llvm.maxnum.v2f32(<2 x float> undef, <2 x float> undef)
; AVX-NEXT:  Cost Model: Found costs of 1 for: %V4F32 = call nnan <4 x float> @llvm.maxnum.v4f32(<4 x float> undef, <4 x float> undef)
; AVX-NEXT:  Cost Model: Found costs of 1 for: %V8F32 = call nnan <8 x float> @llvm.maxnum.v8f32(<8 x float> undef, <8 x float> undef)
; AVX-NEXT:  Cost Model: Found costs of 2 for: %V16F32 = call nnan <16 x float> @llvm.maxnum.v16f32(<16 x float> undef, <16 x float> undef)
; AVX-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'f32_nnan'
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %F32 = call nnan float @llvm.maxnum.f32(float undef, float undef)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V2F32 = call nnan <2 x float> @llvm.maxnum.v2f32(<2 x float> undef, <2 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V4F32 = call nnan <4 x float> @llvm.maxnum.v4f32(<4 x float> undef, <4 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V8F32 = call nnan <8 x float> @llvm.maxnum.v8f32(<8 x float> undef, <8 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V16F32 = call nnan <16 x float> @llvm.maxnum.v16f32(<16 x float> undef, <16 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %F32 = call nnan float @llvm.maxnum.f32(float undef, float undef)
  %V2F32 = call nnan <2 x float> @llvm.maxnum.v2f32(<2 x float> undef, <2 x float> undef)
  %V4F32 = call nnan <4 x float> @llvm.maxnum.v4f32(<4 x float> undef, <4 x float> undef)
  %V8F32 = call nnan <8 x float> @llvm.maxnum.v8f32(<8 x float> undef, <8 x float> undef)
  %V16F32 = call nnan <16 x float> @llvm.maxnum.v16f32(<16 x float> undef, <16 x float> undef)
  ret i32 undef
}

define i32 @f64_nnan(i32 %arg) {
; SSE-LABEL: 'f64_nnan'
; SSE-NEXT:  Cost Model: Found costs of 1 for: %f64 = call nnan double @llvm.maxnum.f64(double undef, double undef)
; SSE-NEXT:  Cost Model: Found costs of 1 for: %V2f64 = call nnan <2 x double> @llvm.maxnum.v2f64(<2 x double> undef, <2 x double> undef)
; SSE-NEXT:  Cost Model: Found costs of 2 for: %V4f64 = call nnan <4 x double> @llvm.maxnum.v4f64(<4 x double> undef, <4 x double> undef)
; SSE-NEXT:  Cost Model: Found costs of 4 for: %V8f64 = call nnan <8 x double> @llvm.maxnum.v8f64(<8 x double> undef, <8 x double> undef)
; SSE-NEXT:  Cost Model: Found costs of 8 for: %V16f64 = call nnan <16 x double> @llvm.maxnum.v16f64(<16 x double> undef, <16 x double> undef)
; SSE-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX-LABEL: 'f64_nnan'
; AVX-NEXT:  Cost Model: Found costs of 1 for: %f64 = call nnan double @llvm.maxnum.f64(double undef, double undef)
; AVX-NEXT:  Cost Model: Found costs of 1 for: %V2f64 = call nnan <2 x double> @llvm.maxnum.v2f64(<2 x double> undef, <2 x double> undef)
; AVX-NEXT:  Cost Model: Found costs of 1 for: %V4f64 = call nnan <4 x double> @llvm.maxnum.v4f64(<4 x double> undef, <4 x double> undef)
; AVX-NEXT:  Cost Model: Found costs of 2 for: %V8f64 = call nnan <8 x double> @llvm.maxnum.v8f64(<8 x double> undef, <8 x double> undef)
; AVX-NEXT:  Cost Model: Found costs of 4 for: %V16f64 = call nnan <16 x double> @llvm.maxnum.v16f64(<16 x double> undef, <16 x double> undef)
; AVX-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'f64_nnan'
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %f64 = call nnan double @llvm.maxnum.f64(double undef, double undef)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V2f64 = call nnan <2 x double> @llvm.maxnum.v2f64(<2 x double> undef, <2 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V4f64 = call nnan <4 x double> @llvm.maxnum.v4f64(<4 x double> undef, <4 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V8f64 = call nnan <8 x double> @llvm.maxnum.v8f64(<8 x double> undef, <8 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of 2 for: %V16f64 = call nnan <16 x double> @llvm.maxnum.v16f64(<16 x double> undef, <16 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %f64 = call nnan double @llvm.maxnum.f64(double undef, double undef)
  %V2f64 = call nnan <2 x double> @llvm.maxnum.v2f64(<2 x double> undef, <2 x double> undef)
  %V4f64 = call nnan <4 x double> @llvm.maxnum.v4f64(<4 x double> undef, <4 x double> undef)
  %V8f64 = call nnan <8 x double> @llvm.maxnum.v8f64(<8 x double> undef, <8 x double> undef)
  %V16f64 = call nnan <16 x double> @llvm.maxnum.v16f64(<16 x double> undef, <16 x double> undef)
  ret i32 undef
}

declare float @llvm.maxnum.f32(float, float)
declare <2 x float> @llvm.maxnum.v2f32(<2 x float>, <2 x float>)
declare <4 x float> @llvm.maxnum.v4f32(<4 x float>, <4 x float>)
declare <8 x float> @llvm.maxnum.v8f32(<8 x float>, <8 x float>)
declare <16 x float> @llvm.maxnum.v16f32(<16 x float>, <16 x float>)

declare double @llvm.maxnum.f64(double, double)
declare <2 x double> @llvm.maxnum.v2f64(<2 x double>, <2 x double>)
declare <4 x double> @llvm.maxnum.v4f64(<4 x double>, <4 x double>)
declare <8 x double> @llvm.maxnum.v8f64(<8 x double>, <8 x double>)
declare <16 x double> @llvm.maxnum.v16f64(<16 x double>, <16 x double>)
