; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt < %s -passes=instcombine -mtriple x86_64-unknown-linux-gnu -S | FileCheck %s

define float @erff_const() {
; CHECK-LABEL: define float @erff_const() {
; CHECK-NEXT:    [[R:%.*]] = call float @erff(float 5.000000e-01)
; CHECK-NEXT:    ret float 0x3FE0A7EF60000000
;
  %r = call float @erff(float 5.000000e-01)
  ret float %r
}

define double @erf_const() {
; CHECK-LABEL: define double @erf_const() {
; CHECK-NEXT:    [[R:%.*]] = call double @erf(double -5.000000e-01)
; CHECK-NEXT:    ret double 0xBFE0A7EF5C18EDD2
;
  %r = call double @erf(double -5.000000e-01)
  ret double %r
}

define float @erff_zero() {
; CHECK-LABEL: define float @erff_zero() {
; CHECK-NEXT:    [[R:%.*]] = call float @erff(float 0.000000e+00)
; CHECK-NEXT:    ret float 0.000000e+00
;
  %r = call float @erff(float 0.000000e+00)
  ret float %r
}

define double @erf_zero() {
; CHECK-LABEL: define double @erf_zero() {
; CHECK-NEXT:    [[R:%.*]] = call double @erf(double 0.000000e+00)
; CHECK-NEXT:    ret double 0.000000e+00
;
  %r = call double @erf(double 0.000000e+00)
  ret double %r
}

define float @erff_neg_zero() {
; CHECK-LABEL: define float @erff_neg_zero() {
; CHECK-NEXT:    [[R:%.*]] = call float @erff(float -0.000000e+00)
; CHECK-NEXT:    ret float -0.000000e+00
;
  %r = call float @erff(float -0.000000e+00)
  ret float %r
}

define double @erf_neg_zero() {
; CHECK-LABEL: define double @erf_neg_zero() {
; CHECK-NEXT:    [[R:%.*]] = call double @erf(double -0.000000e+00)
; CHECK-NEXT:    ret double -0.000000e+00
;
  %r = call double @erf(double -0.000000e+00)
  ret double %r
}

define float @erff_inf() {
; CHECK-LABEL: define float @erff_inf() {
; CHECK-NEXT:    [[R:%.*]] = call float @erff(float 0x7FF0000000000000)
; CHECK-NEXT:    ret float [[R]]
;
  %r = call float @erff(float 0x7FF0000000000000)
  ret float %r
}

define double @erf_inf() {
; CHECK-LABEL: define double @erf_inf() {
; CHECK-NEXT:    [[R:%.*]] = call double @erf(double 0x7FF0000000000000)
; CHECK-NEXT:    ret double [[R]]
;
  %r = call double @erf(double 0x7FF0000000000000)
  ret double %r
}

define float @erff_inf_memory_none() {
; CHECK-LABEL: define float @erff_inf_memory_none() {
; CHECK-NEXT:    [[R:%.*]] = call float @erff(float 0x7FF0000000000000) #[[ATTR1:[0-9]+]]
; CHECK-NEXT:    ret float [[R]]
;
  %r = call float @erff(float 0x7FF0000000000000) readnone
  ret float %r
}

define double @erf_inf_memory_none() {
; CHECK-LABEL: define double @erf_inf_memory_none() {
; CHECK-NEXT:    [[R:%.*]] = call double @erf(double 0x7FF0000000000000) #[[ATTR1]]
; CHECK-NEXT:    ret double [[R]]
;
  %r = call double @erf(double 0x7FF0000000000000) readnone
  ret double %r
}

define float @erff_neg_inf() {
; CHECK-LABEL: define float @erff_neg_inf() {
; CHECK-NEXT:    [[R:%.*]] = call float @erff(float 0xFFF0000000000000)
; CHECK-NEXT:    ret float [[R]]
;
  %r = call float @erff(float 0xFFF0000000000000)
  ret float %r
}

define double @erf_neg_inf() {
; CHECK-LABEL: define double @erf_neg_inf() {
; CHECK-NEXT:    [[R:%.*]] = call double @erf(double 0xFFF0000000000000)
; CHECK-NEXT:    ret double [[R]]
;
  %r = call double @erf(double 0xFFF0000000000000)
  ret double %r
}

define float @erff_neg_inf_memory_none() {
; CHECK-LABEL: define float @erff_neg_inf_memory_none() {
; CHECK-NEXT:    [[R:%.*]] = call float @erff(float 0xFFF0000000000000) #[[ATTR1]]
; CHECK-NEXT:    ret float [[R]]
;
  %r = call float @erff(float 0xFFF0000000000000) readnone
  ret float %r
}

define double @erf_neg_inf_memory_none() {
; CHECK-LABEL: define double @erf_neg_inf_memory_none() {
; CHECK-NEXT:    [[R:%.*]] = call double @erf(double 0xFFF0000000000000) #[[ATTR1]]
; CHECK-NEXT:    ret double [[R]]
;
  %r = call double @erf(double 0xFFF0000000000000) readnone
  ret double %r
}

define float @erff_nan() {
; CHECK-LABEL: define float @erff_nan() {
; CHECK-NEXT:    [[R:%.*]] = call float @erff(float 0x7FF8000000000000)
; CHECK-NEXT:    ret float [[R]]
;
  %r = call float @erff(float 0x7FF8000000000000)
  ret float %r
}

define double @erf_nan() {
; CHECK-LABEL: define double @erf_nan() {
; CHECK-NEXT:    [[R:%.*]] = call double @erf(double 0x7FF8000000000000)
; CHECK-NEXT:    ret double [[R]]
;
  %r = call double @erf(double 0x7FF8000000000000)
  ret double %r
}

define float @erff_nan_memory_none() {
; CHECK-LABEL: define float @erff_nan_memory_none() {
; CHECK-NEXT:    [[R:%.*]] = call float @erff(float 0x7FF8000000000000) #[[ATTR1]]
; CHECK-NEXT:    ret float [[R]]
;
  %r = call float @erff(float 0x7FF8000000000000) readnone
  ret float %r
}

define double @erf_nan_memory_none() {
; CHECK-LABEL: define double @erf_nan_memory_none() {
; CHECK-NEXT:    [[R:%.*]] = call double @erf(double 0x7FF8000000000000) #[[ATTR1]]
; CHECK-NEXT:    ret double [[R]]
;
  %r = call double @erf(double 0x7FF8000000000000) readnone
  ret double %r
}

define float @erff_poison() {
; CHECK-LABEL: define float @erff_poison() {
; CHECK-NEXT:    [[R:%.*]] = call float @erff(float poison)
; CHECK-NEXT:    ret float [[R]]
;
  %r = call float @erff(float poison)
  ret float %r
}

define double @erf_poison() {
; CHECK-LABEL: define double @erf_poison() {
; CHECK-NEXT:    [[R:%.*]] = call double @erf(double poison)
; CHECK-NEXT:    ret double [[R]]
;
  %r = call double @erf(double poison)
  ret double %r
}

define float @erff_const_strictfp() {
; CHECK-LABEL: define float @erff_const_strictfp() {
; CHECK-NEXT:    [[R:%.*]] = call float @erff(float 5.000000e-01) #[[ATTR2:[0-9]+]]
; CHECK-NEXT:    ret float [[R]]
;
  %r = call float @erff(float 5.000000e-01) strictfp
  ret float %r
}

define double @erf_const_strictfp() {
; CHECK-LABEL: define double @erf_const_strictfp() {
; CHECK-NEXT:    [[R:%.*]] = call double @erf(double -5.000000e-01) #[[ATTR2]]
; CHECK-NEXT:    ret double [[R]]
;
  %r = call double @erf(double -5.000000e-01) strictfp
  ret double %r
}

define float @erff_nan_strictfp() {
; CHECK-LABEL: define float @erff_nan_strictfp() {
; CHECK-NEXT:    [[R:%.*]] = call float @erff(float 0x7FF8000000000000) #[[ATTR2]]
; CHECK-NEXT:    ret float [[R]]
;
  %r = call float @erff(float 0x7FF8000000000000) strictfp
  ret float %r
}

define double @erf_nan_strictfp() {
; CHECK-LABEL: define double @erf_nan_strictfp() {
; CHECK-NEXT:    [[R:%.*]] = call double @erf(double 0x7FF8000000000000) #[[ATTR2]]
; CHECK-NEXT:    ret double [[R]]
;
  %r = call double @erf(double 0x7FF8000000000000) strictfp
  ret double %r
}

declare float @erff(float) willreturn
declare double @erf(double) willreturn
