#line 1 "numpy/core/src/multiarray/nditer_templ.c.src"

/*
 *****************************************************************************
 **       This file was autogenerated from a template  DO NOT EDIT!!!!      **
 **       Changes should be made to the original source (.src) file         **
 *****************************************************************************
 */

#line 1
/*
 * This file implements the API functions for NumPy's nditer that
 * are specialized using the templating system.
 *
 * Copyright (c) 2010-2011 by Mark Wiebe (mwwiebe@gmail.com)
 * The University of British Columbia
 *
 * See LICENSE.txt for the license.
 */

/* Indicate that this .c file is allowed to include the header */
#define NPY_ITERATOR_IMPLEMENTATION_CODE
#include "nditer_impl.h"

/* SPECIALIZED iternext functions that handle the non-buffering part */

#line 25
#line 29
#line 33

/* Specialized iternext (0,1,1) */
static int
npyiter_iternext_itflags0_dims1_iters1(
                                                      NpyIter *iter)
{
#if !(0&NPY_ITFLAG_EXLOOP) || (1 > 1)
    const npy_uint32 itflags = 0;
#  if 1 >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if 1 < NPY_MAXDIMS
    const int nop = 1;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if 1 > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if 1 > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (0&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if 1 > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(0&NPY_ITFLAG_EXLOOP) || (1 > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(0&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if 1 == 1

#  if !(0&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(0&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if 1 == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}


#line 33

/* Specialized iternext (0,1,2) */
static int
npyiter_iternext_itflags0_dims1_iters2(
                                                      NpyIter *iter)
{
#if !(0&NPY_ITFLAG_EXLOOP) || (1 > 1)
    const npy_uint32 itflags = 0;
#  if 1 >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if 2 < NPY_MAXDIMS
    const int nop = 2;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if 1 > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if 1 > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (0&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if 1 > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(0&NPY_ITFLAG_EXLOOP) || (1 > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(0&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if 1 == 1

#  if !(0&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(0&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if 1 == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}


#line 33

/* Specialized iternext (0,1,ANY) */
static int
npyiter_iternext_itflags0_dims1_itersANY(
                                                      NpyIter *iter)
{
#if !(0&NPY_ITFLAG_EXLOOP) || (1 > 1)
    const npy_uint32 itflags = 0;
#  if 1 >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if NPY_MAXDIMS < NPY_MAXDIMS
    const int nop = NPY_MAXDIMS;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if 1 > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if 1 > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (0&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if 1 > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(0&NPY_ITFLAG_EXLOOP) || (1 > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(0&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if 1 == 1

#  if !(0&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(0&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if 1 == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}



#line 29
#line 33

/* Specialized iternext (0,2,1) */
static int
npyiter_iternext_itflags0_dims2_iters1(
                                                      NpyIter *iter)
{
#if !(0&NPY_ITFLAG_EXLOOP) || (2 > 1)
    const npy_uint32 itflags = 0;
#  if 2 >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if 1 < NPY_MAXDIMS
    const int nop = 1;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if 2 > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if 2 > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (0&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if 2 > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(0&NPY_ITFLAG_EXLOOP) || (2 > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(0&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if 2 == 1

#  if !(0&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(0&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if 2 == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}


#line 33

/* Specialized iternext (0,2,2) */
static int
npyiter_iternext_itflags0_dims2_iters2(
                                                      NpyIter *iter)
{
#if !(0&NPY_ITFLAG_EXLOOP) || (2 > 1)
    const npy_uint32 itflags = 0;
#  if 2 >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if 2 < NPY_MAXDIMS
    const int nop = 2;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if 2 > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if 2 > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (0&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if 2 > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(0&NPY_ITFLAG_EXLOOP) || (2 > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(0&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if 2 == 1

#  if !(0&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(0&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if 2 == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}


#line 33

/* Specialized iternext (0,2,ANY) */
static int
npyiter_iternext_itflags0_dims2_itersANY(
                                                      NpyIter *iter)
{
#if !(0&NPY_ITFLAG_EXLOOP) || (2 > 1)
    const npy_uint32 itflags = 0;
#  if 2 >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if NPY_MAXDIMS < NPY_MAXDIMS
    const int nop = NPY_MAXDIMS;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if 2 > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if 2 > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (0&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if 2 > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(0&NPY_ITFLAG_EXLOOP) || (2 > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(0&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if 2 == 1

#  if !(0&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(0&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if 2 == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}



#line 29
#line 33

/* Specialized iternext (0,ANY,1) */
static int
npyiter_iternext_itflags0_dimsANY_iters1(
                                                      NpyIter *iter)
{
#if !(0&NPY_ITFLAG_EXLOOP) || (NPY_MAXDIMS > 1)
    const npy_uint32 itflags = 0;
#  if NPY_MAXDIMS >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if 1 < NPY_MAXDIMS
    const int nop = 1;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if NPY_MAXDIMS > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if NPY_MAXDIMS > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (0&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if NPY_MAXDIMS > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(0&NPY_ITFLAG_EXLOOP) || (NPY_MAXDIMS > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(0&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if NPY_MAXDIMS == 1

#  if !(0&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(0&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if NPY_MAXDIMS == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}


#line 33

/* Specialized iternext (0,ANY,2) */
static int
npyiter_iternext_itflags0_dimsANY_iters2(
                                                      NpyIter *iter)
{
#if !(0&NPY_ITFLAG_EXLOOP) || (NPY_MAXDIMS > 1)
    const npy_uint32 itflags = 0;
#  if NPY_MAXDIMS >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if 2 < NPY_MAXDIMS
    const int nop = 2;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if NPY_MAXDIMS > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if NPY_MAXDIMS > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (0&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if NPY_MAXDIMS > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(0&NPY_ITFLAG_EXLOOP) || (NPY_MAXDIMS > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(0&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if NPY_MAXDIMS == 1

#  if !(0&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(0&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if NPY_MAXDIMS == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}


#line 33

/* Specialized iternext (0,ANY,ANY) */
static int
npyiter_iternext_itflags0_dimsANY_itersANY(
                                                      NpyIter *iter)
{
#if !(0&NPY_ITFLAG_EXLOOP) || (NPY_MAXDIMS > 1)
    const npy_uint32 itflags = 0;
#  if NPY_MAXDIMS >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if NPY_MAXDIMS < NPY_MAXDIMS
    const int nop = NPY_MAXDIMS;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if NPY_MAXDIMS > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if NPY_MAXDIMS > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (0&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if NPY_MAXDIMS > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(0&NPY_ITFLAG_EXLOOP) || (NPY_MAXDIMS > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(0&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if NPY_MAXDIMS == 1

#  if !(0&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(0&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if NPY_MAXDIMS == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}




#line 25
#line 29
#line 33

/* Specialized iternext (NPY_ITFLAG_HASINDEX,1,1) */
static int
npyiter_iternext_itflagsIND_dims1_iters1(
                                                      NpyIter *iter)
{
#if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP) || (1 > 1)
    const npy_uint32 itflags = NPY_ITFLAG_HASINDEX;
#  if 1 >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if 1 < NPY_MAXDIMS
    const int nop = 1;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if 1 > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if 1 > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (NPY_ITFLAG_HASINDEX&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if 1 > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP) || (1 > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if 1 == 1

#  if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if 1 == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}


#line 33

/* Specialized iternext (NPY_ITFLAG_HASINDEX,1,2) */
static int
npyiter_iternext_itflagsIND_dims1_iters2(
                                                      NpyIter *iter)
{
#if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP) || (1 > 1)
    const npy_uint32 itflags = NPY_ITFLAG_HASINDEX;
#  if 1 >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if 2 < NPY_MAXDIMS
    const int nop = 2;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if 1 > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if 1 > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (NPY_ITFLAG_HASINDEX&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if 1 > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP) || (1 > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if 1 == 1

#  if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if 1 == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}


#line 33

/* Specialized iternext (NPY_ITFLAG_HASINDEX,1,ANY) */
static int
npyiter_iternext_itflagsIND_dims1_itersANY(
                                                      NpyIter *iter)
{
#if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP) || (1 > 1)
    const npy_uint32 itflags = NPY_ITFLAG_HASINDEX;
#  if 1 >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if NPY_MAXDIMS < NPY_MAXDIMS
    const int nop = NPY_MAXDIMS;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if 1 > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if 1 > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (NPY_ITFLAG_HASINDEX&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if 1 > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP) || (1 > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if 1 == 1

#  if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if 1 == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}



#line 29
#line 33

/* Specialized iternext (NPY_ITFLAG_HASINDEX,2,1) */
static int
npyiter_iternext_itflagsIND_dims2_iters1(
                                                      NpyIter *iter)
{
#if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP) || (2 > 1)
    const npy_uint32 itflags = NPY_ITFLAG_HASINDEX;
#  if 2 >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if 1 < NPY_MAXDIMS
    const int nop = 1;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if 2 > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if 2 > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (NPY_ITFLAG_HASINDEX&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if 2 > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP) || (2 > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if 2 == 1

#  if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if 2 == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}


#line 33

/* Specialized iternext (NPY_ITFLAG_HASINDEX,2,2) */
static int
npyiter_iternext_itflagsIND_dims2_iters2(
                                                      NpyIter *iter)
{
#if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP) || (2 > 1)
    const npy_uint32 itflags = NPY_ITFLAG_HASINDEX;
#  if 2 >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if 2 < NPY_MAXDIMS
    const int nop = 2;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if 2 > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if 2 > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (NPY_ITFLAG_HASINDEX&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if 2 > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP) || (2 > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if 2 == 1

#  if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if 2 == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}


#line 33

/* Specialized iternext (NPY_ITFLAG_HASINDEX,2,ANY) */
static int
npyiter_iternext_itflagsIND_dims2_itersANY(
                                                      NpyIter *iter)
{
#if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP) || (2 > 1)
    const npy_uint32 itflags = NPY_ITFLAG_HASINDEX;
#  if 2 >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if NPY_MAXDIMS < NPY_MAXDIMS
    const int nop = NPY_MAXDIMS;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if 2 > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if 2 > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (NPY_ITFLAG_HASINDEX&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if 2 > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP) || (2 > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if 2 == 1

#  if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if 2 == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}



#line 29
#line 33

/* Specialized iternext (NPY_ITFLAG_HASINDEX,ANY,1) */
static int
npyiter_iternext_itflagsIND_dimsANY_iters1(
                                                      NpyIter *iter)
{
#if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP) || (NPY_MAXDIMS > 1)
    const npy_uint32 itflags = NPY_ITFLAG_HASINDEX;
#  if NPY_MAXDIMS >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if 1 < NPY_MAXDIMS
    const int nop = 1;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if NPY_MAXDIMS > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if NPY_MAXDIMS > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (NPY_ITFLAG_HASINDEX&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if NPY_MAXDIMS > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP) || (NPY_MAXDIMS > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if NPY_MAXDIMS == 1

#  if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if NPY_MAXDIMS == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}


#line 33

/* Specialized iternext (NPY_ITFLAG_HASINDEX,ANY,2) */
static int
npyiter_iternext_itflagsIND_dimsANY_iters2(
                                                      NpyIter *iter)
{
#if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP) || (NPY_MAXDIMS > 1)
    const npy_uint32 itflags = NPY_ITFLAG_HASINDEX;
#  if NPY_MAXDIMS >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if 2 < NPY_MAXDIMS
    const int nop = 2;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if NPY_MAXDIMS > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if NPY_MAXDIMS > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (NPY_ITFLAG_HASINDEX&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if NPY_MAXDIMS > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP) || (NPY_MAXDIMS > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if NPY_MAXDIMS == 1

#  if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if NPY_MAXDIMS == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}


#line 33

/* Specialized iternext (NPY_ITFLAG_HASINDEX,ANY,ANY) */
static int
npyiter_iternext_itflagsIND_dimsANY_itersANY(
                                                      NpyIter *iter)
{
#if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP) || (NPY_MAXDIMS > 1)
    const npy_uint32 itflags = NPY_ITFLAG_HASINDEX;
#  if NPY_MAXDIMS >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if NPY_MAXDIMS < NPY_MAXDIMS
    const int nop = NPY_MAXDIMS;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if NPY_MAXDIMS > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if NPY_MAXDIMS > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (NPY_ITFLAG_HASINDEX&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if NPY_MAXDIMS > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP) || (NPY_MAXDIMS > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if NPY_MAXDIMS == 1

#  if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if NPY_MAXDIMS == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}




#line 25
#line 29
#line 33

/* Specialized iternext (NPY_ITFLAG_EXLOOP,1,1) */
static int
npyiter_iternext_itflagsNOINN_dims1_iters1(
                                                      NpyIter *iter)
{
#if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP) || (1 > 1)
    const npy_uint32 itflags = NPY_ITFLAG_EXLOOP;
#  if 1 >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if 1 < NPY_MAXDIMS
    const int nop = 1;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if 1 > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if 1 > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (NPY_ITFLAG_EXLOOP&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if 1 > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP) || (1 > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if 1 == 1

#  if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if 1 == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}


#line 33

/* Specialized iternext (NPY_ITFLAG_EXLOOP,1,2) */
static int
npyiter_iternext_itflagsNOINN_dims1_iters2(
                                                      NpyIter *iter)
{
#if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP) || (1 > 1)
    const npy_uint32 itflags = NPY_ITFLAG_EXLOOP;
#  if 1 >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if 2 < NPY_MAXDIMS
    const int nop = 2;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if 1 > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if 1 > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (NPY_ITFLAG_EXLOOP&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if 1 > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP) || (1 > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if 1 == 1

#  if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if 1 == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}


#line 33

/* Specialized iternext (NPY_ITFLAG_EXLOOP,1,ANY) */
static int
npyiter_iternext_itflagsNOINN_dims1_itersANY(
                                                      NpyIter *iter)
{
#if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP) || (1 > 1)
    const npy_uint32 itflags = NPY_ITFLAG_EXLOOP;
#  if 1 >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if NPY_MAXDIMS < NPY_MAXDIMS
    const int nop = NPY_MAXDIMS;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if 1 > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if 1 > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (NPY_ITFLAG_EXLOOP&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if 1 > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP) || (1 > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if 1 == 1

#  if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if 1 == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}



#line 29
#line 33

/* Specialized iternext (NPY_ITFLAG_EXLOOP,2,1) */
static int
npyiter_iternext_itflagsNOINN_dims2_iters1(
                                                      NpyIter *iter)
{
#if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP) || (2 > 1)
    const npy_uint32 itflags = NPY_ITFLAG_EXLOOP;
#  if 2 >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if 1 < NPY_MAXDIMS
    const int nop = 1;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if 2 > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if 2 > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (NPY_ITFLAG_EXLOOP&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if 2 > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP) || (2 > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if 2 == 1

#  if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if 2 == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}


#line 33

/* Specialized iternext (NPY_ITFLAG_EXLOOP,2,2) */
static int
npyiter_iternext_itflagsNOINN_dims2_iters2(
                                                      NpyIter *iter)
{
#if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP) || (2 > 1)
    const npy_uint32 itflags = NPY_ITFLAG_EXLOOP;
#  if 2 >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if 2 < NPY_MAXDIMS
    const int nop = 2;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if 2 > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if 2 > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (NPY_ITFLAG_EXLOOP&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if 2 > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP) || (2 > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if 2 == 1

#  if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if 2 == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}


#line 33

/* Specialized iternext (NPY_ITFLAG_EXLOOP,2,ANY) */
static int
npyiter_iternext_itflagsNOINN_dims2_itersANY(
                                                      NpyIter *iter)
{
#if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP) || (2 > 1)
    const npy_uint32 itflags = NPY_ITFLAG_EXLOOP;
#  if 2 >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if NPY_MAXDIMS < NPY_MAXDIMS
    const int nop = NPY_MAXDIMS;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if 2 > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if 2 > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (NPY_ITFLAG_EXLOOP&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if 2 > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP) || (2 > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if 2 == 1

#  if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if 2 == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}



#line 29
#line 33

/* Specialized iternext (NPY_ITFLAG_EXLOOP,ANY,1) */
static int
npyiter_iternext_itflagsNOINN_dimsANY_iters1(
                                                      NpyIter *iter)
{
#if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP) || (NPY_MAXDIMS > 1)
    const npy_uint32 itflags = NPY_ITFLAG_EXLOOP;
#  if NPY_MAXDIMS >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if 1 < NPY_MAXDIMS
    const int nop = 1;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if NPY_MAXDIMS > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if NPY_MAXDIMS > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (NPY_ITFLAG_EXLOOP&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if NPY_MAXDIMS > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP) || (NPY_MAXDIMS > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if NPY_MAXDIMS == 1

#  if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if NPY_MAXDIMS == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}


#line 33

/* Specialized iternext (NPY_ITFLAG_EXLOOP,ANY,2) */
static int
npyiter_iternext_itflagsNOINN_dimsANY_iters2(
                                                      NpyIter *iter)
{
#if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP) || (NPY_MAXDIMS > 1)
    const npy_uint32 itflags = NPY_ITFLAG_EXLOOP;
#  if NPY_MAXDIMS >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if 2 < NPY_MAXDIMS
    const int nop = 2;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if NPY_MAXDIMS > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if NPY_MAXDIMS > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (NPY_ITFLAG_EXLOOP&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if NPY_MAXDIMS > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP) || (NPY_MAXDIMS > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if NPY_MAXDIMS == 1

#  if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if NPY_MAXDIMS == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}


#line 33

/* Specialized iternext (NPY_ITFLAG_EXLOOP,ANY,ANY) */
static int
npyiter_iternext_itflagsNOINN_dimsANY_itersANY(
                                                      NpyIter *iter)
{
#if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP) || (NPY_MAXDIMS > 1)
    const npy_uint32 itflags = NPY_ITFLAG_EXLOOP;
#  if NPY_MAXDIMS >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if NPY_MAXDIMS < NPY_MAXDIMS
    const int nop = NPY_MAXDIMS;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if NPY_MAXDIMS > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if NPY_MAXDIMS > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (NPY_ITFLAG_EXLOOP&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if NPY_MAXDIMS > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP) || (NPY_MAXDIMS > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if NPY_MAXDIMS == 1

#  if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(NPY_ITFLAG_EXLOOP&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if NPY_MAXDIMS == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}




#line 25
#line 29
#line 33

/* Specialized iternext (NPY_ITFLAG_RANGE,1,1) */
static int
npyiter_iternext_itflagsRNG_dims1_iters1(
                                                      NpyIter *iter)
{
#if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP) || (1 > 1)
    const npy_uint32 itflags = NPY_ITFLAG_RANGE;
#  if 1 >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if 1 < NPY_MAXDIMS
    const int nop = 1;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if 1 > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if 1 > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (NPY_ITFLAG_RANGE&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if 1 > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP) || (1 > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if 1 == 1

#  if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if 1 == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}


#line 33

/* Specialized iternext (NPY_ITFLAG_RANGE,1,2) */
static int
npyiter_iternext_itflagsRNG_dims1_iters2(
                                                      NpyIter *iter)
{
#if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP) || (1 > 1)
    const npy_uint32 itflags = NPY_ITFLAG_RANGE;
#  if 1 >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if 2 < NPY_MAXDIMS
    const int nop = 2;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if 1 > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if 1 > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (NPY_ITFLAG_RANGE&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if 1 > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP) || (1 > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if 1 == 1

#  if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if 1 == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}


#line 33

/* Specialized iternext (NPY_ITFLAG_RANGE,1,ANY) */
static int
npyiter_iternext_itflagsRNG_dims1_itersANY(
                                                      NpyIter *iter)
{
#if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP) || (1 > 1)
    const npy_uint32 itflags = NPY_ITFLAG_RANGE;
#  if 1 >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if NPY_MAXDIMS < NPY_MAXDIMS
    const int nop = NPY_MAXDIMS;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if 1 > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if 1 > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (NPY_ITFLAG_RANGE&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if 1 > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP) || (1 > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if 1 == 1

#  if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if 1 == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}



#line 29
#line 33

/* Specialized iternext (NPY_ITFLAG_RANGE,2,1) */
static int
npyiter_iternext_itflagsRNG_dims2_iters1(
                                                      NpyIter *iter)
{
#if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP) || (2 > 1)
    const npy_uint32 itflags = NPY_ITFLAG_RANGE;
#  if 2 >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if 1 < NPY_MAXDIMS
    const int nop = 1;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if 2 > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if 2 > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (NPY_ITFLAG_RANGE&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if 2 > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP) || (2 > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if 2 == 1

#  if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if 2 == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}


#line 33

/* Specialized iternext (NPY_ITFLAG_RANGE,2,2) */
static int
npyiter_iternext_itflagsRNG_dims2_iters2(
                                                      NpyIter *iter)
{
#if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP) || (2 > 1)
    const npy_uint32 itflags = NPY_ITFLAG_RANGE;
#  if 2 >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if 2 < NPY_MAXDIMS
    const int nop = 2;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if 2 > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if 2 > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (NPY_ITFLAG_RANGE&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if 2 > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP) || (2 > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if 2 == 1

#  if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if 2 == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}


#line 33

/* Specialized iternext (NPY_ITFLAG_RANGE,2,ANY) */
static int
npyiter_iternext_itflagsRNG_dims2_itersANY(
                                                      NpyIter *iter)
{
#if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP) || (2 > 1)
    const npy_uint32 itflags = NPY_ITFLAG_RANGE;
#  if 2 >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if NPY_MAXDIMS < NPY_MAXDIMS
    const int nop = NPY_MAXDIMS;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if 2 > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if 2 > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (NPY_ITFLAG_RANGE&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if 2 > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP) || (2 > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if 2 == 1

#  if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if 2 == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}



#line 29
#line 33

/* Specialized iternext (NPY_ITFLAG_RANGE,ANY,1) */
static int
npyiter_iternext_itflagsRNG_dimsANY_iters1(
                                                      NpyIter *iter)
{
#if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP) || (NPY_MAXDIMS > 1)
    const npy_uint32 itflags = NPY_ITFLAG_RANGE;
#  if NPY_MAXDIMS >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if 1 < NPY_MAXDIMS
    const int nop = 1;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if NPY_MAXDIMS > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if NPY_MAXDIMS > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (NPY_ITFLAG_RANGE&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if NPY_MAXDIMS > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP) || (NPY_MAXDIMS > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if NPY_MAXDIMS == 1

#  if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if NPY_MAXDIMS == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}


#line 33

/* Specialized iternext (NPY_ITFLAG_RANGE,ANY,2) */
static int
npyiter_iternext_itflagsRNG_dimsANY_iters2(
                                                      NpyIter *iter)
{
#if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP) || (NPY_MAXDIMS > 1)
    const npy_uint32 itflags = NPY_ITFLAG_RANGE;
#  if NPY_MAXDIMS >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if 2 < NPY_MAXDIMS
    const int nop = 2;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if NPY_MAXDIMS > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if NPY_MAXDIMS > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (NPY_ITFLAG_RANGE&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if NPY_MAXDIMS > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP) || (NPY_MAXDIMS > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if NPY_MAXDIMS == 1

#  if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if NPY_MAXDIMS == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}


#line 33

/* Specialized iternext (NPY_ITFLAG_RANGE,ANY,ANY) */
static int
npyiter_iternext_itflagsRNG_dimsANY_itersANY(
                                                      NpyIter *iter)
{
#if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP) || (NPY_MAXDIMS > 1)
    const npy_uint32 itflags = NPY_ITFLAG_RANGE;
#  if NPY_MAXDIMS >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if NPY_MAXDIMS < NPY_MAXDIMS
    const int nop = NPY_MAXDIMS;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if NPY_MAXDIMS > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if NPY_MAXDIMS > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (NPY_ITFLAG_RANGE&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if NPY_MAXDIMS > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP) || (NPY_MAXDIMS > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if NPY_MAXDIMS == 1

#  if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(NPY_ITFLAG_RANGE&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if NPY_MAXDIMS == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}




#line 25
#line 29
#line 33

/* Specialized iternext (NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX,1,1) */
static int
npyiter_iternext_itflagsRNGuIND_dims1_iters1(
                                                      NpyIter *iter)
{
#if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP) || (1 > 1)
    const npy_uint32 itflags = NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX;
#  if 1 >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if 1 < NPY_MAXDIMS
    const int nop = 1;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if 1 > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if 1 > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if 1 > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP) || (1 > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if 1 == 1

#  if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if 1 == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}


#line 33

/* Specialized iternext (NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX,1,2) */
static int
npyiter_iternext_itflagsRNGuIND_dims1_iters2(
                                                      NpyIter *iter)
{
#if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP) || (1 > 1)
    const npy_uint32 itflags = NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX;
#  if 1 >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if 2 < NPY_MAXDIMS
    const int nop = 2;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if 1 > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if 1 > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if 1 > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP) || (1 > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if 1 == 1

#  if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if 1 == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}


#line 33

/* Specialized iternext (NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX,1,ANY) */
static int
npyiter_iternext_itflagsRNGuIND_dims1_itersANY(
                                                      NpyIter *iter)
{
#if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP) || (1 > 1)
    const npy_uint32 itflags = NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX;
#  if 1 >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if NPY_MAXDIMS < NPY_MAXDIMS
    const int nop = NPY_MAXDIMS;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if 1 > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if 1 > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if 1 > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP) || (1 > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if 1 == 1

#  if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if 1 == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}



#line 29
#line 33

/* Specialized iternext (NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX,2,1) */
static int
npyiter_iternext_itflagsRNGuIND_dims2_iters1(
                                                      NpyIter *iter)
{
#if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP) || (2 > 1)
    const npy_uint32 itflags = NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX;
#  if 2 >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if 1 < NPY_MAXDIMS
    const int nop = 1;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if 2 > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if 2 > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if 2 > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP) || (2 > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if 2 == 1

#  if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if 2 == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}


#line 33

/* Specialized iternext (NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX,2,2) */
static int
npyiter_iternext_itflagsRNGuIND_dims2_iters2(
                                                      NpyIter *iter)
{
#if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP) || (2 > 1)
    const npy_uint32 itflags = NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX;
#  if 2 >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if 2 < NPY_MAXDIMS
    const int nop = 2;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if 2 > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if 2 > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if 2 > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP) || (2 > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if 2 == 1

#  if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if 2 == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}


#line 33

/* Specialized iternext (NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX,2,ANY) */
static int
npyiter_iternext_itflagsRNGuIND_dims2_itersANY(
                                                      NpyIter *iter)
{
#if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP) || (2 > 1)
    const npy_uint32 itflags = NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX;
#  if 2 >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if NPY_MAXDIMS < NPY_MAXDIMS
    const int nop = NPY_MAXDIMS;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if 2 > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if 2 > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if 2 > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP) || (2 > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if 2 == 1

#  if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if 2 == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}



#line 29
#line 33

/* Specialized iternext (NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX,ANY,1) */
static int
npyiter_iternext_itflagsRNGuIND_dimsANY_iters1(
                                                      NpyIter *iter)
{
#if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP) || (NPY_MAXDIMS > 1)
    const npy_uint32 itflags = NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX;
#  if NPY_MAXDIMS >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if 1 < NPY_MAXDIMS
    const int nop = 1;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if NPY_MAXDIMS > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if NPY_MAXDIMS > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if NPY_MAXDIMS > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP) || (NPY_MAXDIMS > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if NPY_MAXDIMS == 1

#  if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if NPY_MAXDIMS == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}


#line 33

/* Specialized iternext (NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX,ANY,2) */
static int
npyiter_iternext_itflagsRNGuIND_dimsANY_iters2(
                                                      NpyIter *iter)
{
#if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP) || (NPY_MAXDIMS > 1)
    const npy_uint32 itflags = NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX;
#  if NPY_MAXDIMS >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if 2 < NPY_MAXDIMS
    const int nop = 2;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if NPY_MAXDIMS > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if NPY_MAXDIMS > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if NPY_MAXDIMS > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP) || (NPY_MAXDIMS > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if NPY_MAXDIMS == 1

#  if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if NPY_MAXDIMS == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}


#line 33

/* Specialized iternext (NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX,ANY,ANY) */
static int
npyiter_iternext_itflagsRNGuIND_dimsANY_itersANY(
                                                      NpyIter *iter)
{
#if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP) || (NPY_MAXDIMS > 1)
    const npy_uint32 itflags = NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX;
#  if NPY_MAXDIMS >= NPY_MAXDIMS
    int idim, ndim = NIT_NDIM(iter);
#  endif
#  if NPY_MAXDIMS < NPY_MAXDIMS
    const int nop = NPY_MAXDIMS;
#  else
    int nop = NIT_NOP(iter);
#  endif

    NpyIter_AxisData *axisdata0;
    npy_intp istrides, nstrides = NAD_NSTRIDES();
#endif
#if NPY_MAXDIMS > 1
    NpyIter_AxisData *axisdata1;
    npy_intp sizeof_axisdata;
#endif
#if NPY_MAXDIMS > 2
    NpyIter_AxisData *axisdata2;
#endif

#if (NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_RANGE)
    /* When ranged iteration is enabled, use the iterindex */
    if (++NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        return 0;
    }
#endif

#if NPY_MAXDIMS > 1
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#endif

#  if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP) || (NPY_MAXDIMS > 1)
    axisdata0 = NIT_AXISDATA(iter);
#  endif
#  if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    /* Increment index 0 */
    NAD_INDEX(axisdata0)++;
    /* Increment pointer 0 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata0)[istrides] += NAD_STRIDES(axisdata0)[istrides];
    }
#  endif

#if NPY_MAXDIMS == 1

#  if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    /* Finished when the index equals the shape */
    return NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0);
#  else
    return 0;
#  endif

#else

#  if !(NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX&NPY_ITFLAG_EXLOOP)
    if (NAD_INDEX(axisdata0) < NAD_SHAPE(axisdata0)) {
        return 1;
    }
#  endif

    axisdata1 = NIT_INDEX_AXISDATA(axisdata0, 1);
    /* Increment index 1 */
    NAD_INDEX(axisdata1)++;
    /* Increment pointer 1 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata1)[istrides] += NAD_STRIDES(axisdata1)[istrides];
    }

    if (NAD_INDEX(axisdata1) < NAD_SHAPE(axisdata1)) {
        /* Reset the 1st index to 0 */
        NAD_INDEX(axisdata0) = 0;
        /* Reset the 1st pointer to the value of the 2nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata1)[istrides];
        }
        return 1;
    }

# if NPY_MAXDIMS == 2
    return 0;
# else

    axisdata2 = NIT_INDEX_AXISDATA(axisdata1, 1);
    /* Increment index 2 */
    NAD_INDEX(axisdata2)++;
    /* Increment pointer 2 */
    for (istrides = 0; istrides < nstrides; ++istrides) {
        NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
    }

    if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
        /* Reset the 1st and 2nd indices to 0 */
        NAD_INDEX(axisdata0) = 0;
        NAD_INDEX(axisdata1) = 0;
        /* Reset the 1st and 2nd pointers to the value of the 3nd */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata0)[istrides] = NAD_PTRS(axisdata2)[istrides];
            NAD_PTRS(axisdata1)[istrides] = NAD_PTRS(axisdata2)[istrides];
        }
        return 1;
    }

    for (idim = 3; idim < ndim; ++idim) {
        NIT_ADVANCE_AXISDATA(axisdata2, 1);
        /* Increment the index */
        NAD_INDEX(axisdata2)++;
        /* Increment the pointer */
        for (istrides = 0; istrides < nstrides; ++istrides) {
            NAD_PTRS(axisdata2)[istrides] += NAD_STRIDES(axisdata2)[istrides];
        }


        if (NAD_INDEX(axisdata2) < NAD_SHAPE(axisdata2)) {
            /* Reset the indices and pointers of all previous axisdatas */
            axisdata1 = axisdata2;
            do {
                NIT_ADVANCE_AXISDATA(axisdata1, -1);
                /* Reset the index to 0 */
                NAD_INDEX(axisdata1) = 0;
                /* Reset the pointer to the updated value */
                for (istrides = 0; istrides < nstrides; ++istrides) {
                    NAD_PTRS(axisdata1)[istrides] =
                                        NAD_PTRS(axisdata2)[istrides];
                }
            } while (axisdata1 != axisdata0);

            return 1;
        }
    }

    return 0;

# endif /* ndim != 2 */

#endif /* ndim != 1 */
}






#line 187

/*
 * Iternext function that handles the reduction buffering part.  This
 * is done with a double loop to avoid frequent re-buffering.
 */
static int
npyiter_buffered_reduce_iternext_iters1(NpyIter *iter)
{
    npy_uint32 itflags = NIT_ITFLAGS(iter);
    /*int ndim = NIT_NDIM(iter);*/
#if 1 >= NPY_MAXDIMS
    int nop = NIT_NOP(iter);
#else
    const int nop = 1;
#endif

    int iop;

    NpyIter_AxisData *axisdata;
    NpyIter_BufferData *bufferdata = NIT_BUFFERDATA(iter);
    char **ptrs;
    char *prev_dataptrs[NPY_MAXARGS];

    ptrs = NBF_PTRS(bufferdata);

    /*
     * If the iterator handles the inner loop, need to increment all
     * the indices and pointers
     */
    if (!(itflags&NPY_ITFLAG_EXLOOP)) {
        /* Increment within the buffer */
        if (++NIT_ITERINDEX(iter) < NBF_BUFITEREND(bufferdata)) {
            npy_intp *strides;

            strides = NBF_STRIDES(bufferdata);
            for (iop = 0; iop < nop; ++iop) {
                ptrs[iop] += strides[iop];
            }
            return 1;
        }
    }
    else {
        NIT_ITERINDEX(iter) += NBF_SIZE(bufferdata);
    }

    NPY_IT_DBG_PRINT1("Iterator: Finished iteration %d of outer reduce loop\n",
                            (int)NBF_REDUCE_POS(bufferdata));
    /* The outer increment for the reduce double loop */
    if (++NBF_REDUCE_POS(bufferdata) < NBF_REDUCE_OUTERSIZE(bufferdata)) {
        npy_intp *reduce_outerstrides = NBF_REDUCE_OUTERSTRIDES(bufferdata);
        char **reduce_outerptrs = NBF_REDUCE_OUTERPTRS(bufferdata);
        for (iop = 0; iop < nop; ++iop) {
            char *ptr = reduce_outerptrs[iop] + reduce_outerstrides[iop];
            ptrs[iop] = ptr;
            reduce_outerptrs[iop] = ptr;
        }
        NBF_BUFITEREND(bufferdata) = NIT_ITERINDEX(iter) + NBF_SIZE(bufferdata);
        return 1;
    }

    /* Save the previously used data pointers */
    axisdata = NIT_AXISDATA(iter);
    memcpy(prev_dataptrs, NAD_PTRS(axisdata), NPY_SIZEOF_INTP*nop);

    /* Write back to the arrays */
    if (npyiter_copy_from_buffers(iter) < 0) {
        npyiter_clear_buffers(iter);
        return 0;
    }

    /* Check if we're past the end */
    if (NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        NBF_SIZE(bufferdata) = 0;
        return 0;
    }
    /* Increment to the next buffer */
    else {
        npyiter_goto_iterindex(iter, NIT_ITERINDEX(iter));
    }

    /* Prepare the next buffers and set iterend/size */
    if (npyiter_copy_to_buffers(iter, prev_dataptrs) < 0) {
        npyiter_clear_buffers(iter);
        return 0;
    }

    return 1;
}


#line 187

/*
 * Iternext function that handles the reduction buffering part.  This
 * is done with a double loop to avoid frequent re-buffering.
 */
static int
npyiter_buffered_reduce_iternext_iters2(NpyIter *iter)
{
    npy_uint32 itflags = NIT_ITFLAGS(iter);
    /*int ndim = NIT_NDIM(iter);*/
#if 2 >= NPY_MAXDIMS
    int nop = NIT_NOP(iter);
#else
    const int nop = 2;
#endif

    int iop;

    NpyIter_AxisData *axisdata;
    NpyIter_BufferData *bufferdata = NIT_BUFFERDATA(iter);
    char **ptrs;
    char *prev_dataptrs[NPY_MAXARGS];

    ptrs = NBF_PTRS(bufferdata);

    /*
     * If the iterator handles the inner loop, need to increment all
     * the indices and pointers
     */
    if (!(itflags&NPY_ITFLAG_EXLOOP)) {
        /* Increment within the buffer */
        if (++NIT_ITERINDEX(iter) < NBF_BUFITEREND(bufferdata)) {
            npy_intp *strides;

            strides = NBF_STRIDES(bufferdata);
            for (iop = 0; iop < nop; ++iop) {
                ptrs[iop] += strides[iop];
            }
            return 1;
        }
    }
    else {
        NIT_ITERINDEX(iter) += NBF_SIZE(bufferdata);
    }

    NPY_IT_DBG_PRINT1("Iterator: Finished iteration %d of outer reduce loop\n",
                            (int)NBF_REDUCE_POS(bufferdata));
    /* The outer increment for the reduce double loop */
    if (++NBF_REDUCE_POS(bufferdata) < NBF_REDUCE_OUTERSIZE(bufferdata)) {
        npy_intp *reduce_outerstrides = NBF_REDUCE_OUTERSTRIDES(bufferdata);
        char **reduce_outerptrs = NBF_REDUCE_OUTERPTRS(bufferdata);
        for (iop = 0; iop < nop; ++iop) {
            char *ptr = reduce_outerptrs[iop] + reduce_outerstrides[iop];
            ptrs[iop] = ptr;
            reduce_outerptrs[iop] = ptr;
        }
        NBF_BUFITEREND(bufferdata) = NIT_ITERINDEX(iter) + NBF_SIZE(bufferdata);
        return 1;
    }

    /* Save the previously used data pointers */
    axisdata = NIT_AXISDATA(iter);
    memcpy(prev_dataptrs, NAD_PTRS(axisdata), NPY_SIZEOF_INTP*nop);

    /* Write back to the arrays */
    if (npyiter_copy_from_buffers(iter) < 0) {
        npyiter_clear_buffers(iter);
        return 0;
    }

    /* Check if we're past the end */
    if (NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        NBF_SIZE(bufferdata) = 0;
        return 0;
    }
    /* Increment to the next buffer */
    else {
        npyiter_goto_iterindex(iter, NIT_ITERINDEX(iter));
    }

    /* Prepare the next buffers and set iterend/size */
    if (npyiter_copy_to_buffers(iter, prev_dataptrs) < 0) {
        npyiter_clear_buffers(iter);
        return 0;
    }

    return 1;
}


#line 187

/*
 * Iternext function that handles the reduction buffering part.  This
 * is done with a double loop to avoid frequent re-buffering.
 */
static int
npyiter_buffered_reduce_iternext_iters3(NpyIter *iter)
{
    npy_uint32 itflags = NIT_ITFLAGS(iter);
    /*int ndim = NIT_NDIM(iter);*/
#if 3 >= NPY_MAXDIMS
    int nop = NIT_NOP(iter);
#else
    const int nop = 3;
#endif

    int iop;

    NpyIter_AxisData *axisdata;
    NpyIter_BufferData *bufferdata = NIT_BUFFERDATA(iter);
    char **ptrs;
    char *prev_dataptrs[NPY_MAXARGS];

    ptrs = NBF_PTRS(bufferdata);

    /*
     * If the iterator handles the inner loop, need to increment all
     * the indices and pointers
     */
    if (!(itflags&NPY_ITFLAG_EXLOOP)) {
        /* Increment within the buffer */
        if (++NIT_ITERINDEX(iter) < NBF_BUFITEREND(bufferdata)) {
            npy_intp *strides;

            strides = NBF_STRIDES(bufferdata);
            for (iop = 0; iop < nop; ++iop) {
                ptrs[iop] += strides[iop];
            }
            return 1;
        }
    }
    else {
        NIT_ITERINDEX(iter) += NBF_SIZE(bufferdata);
    }

    NPY_IT_DBG_PRINT1("Iterator: Finished iteration %d of outer reduce loop\n",
                            (int)NBF_REDUCE_POS(bufferdata));
    /* The outer increment for the reduce double loop */
    if (++NBF_REDUCE_POS(bufferdata) < NBF_REDUCE_OUTERSIZE(bufferdata)) {
        npy_intp *reduce_outerstrides = NBF_REDUCE_OUTERSTRIDES(bufferdata);
        char **reduce_outerptrs = NBF_REDUCE_OUTERPTRS(bufferdata);
        for (iop = 0; iop < nop; ++iop) {
            char *ptr = reduce_outerptrs[iop] + reduce_outerstrides[iop];
            ptrs[iop] = ptr;
            reduce_outerptrs[iop] = ptr;
        }
        NBF_BUFITEREND(bufferdata) = NIT_ITERINDEX(iter) + NBF_SIZE(bufferdata);
        return 1;
    }

    /* Save the previously used data pointers */
    axisdata = NIT_AXISDATA(iter);
    memcpy(prev_dataptrs, NAD_PTRS(axisdata), NPY_SIZEOF_INTP*nop);

    /* Write back to the arrays */
    if (npyiter_copy_from_buffers(iter) < 0) {
        npyiter_clear_buffers(iter);
        return 0;
    }

    /* Check if we're past the end */
    if (NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        NBF_SIZE(bufferdata) = 0;
        return 0;
    }
    /* Increment to the next buffer */
    else {
        npyiter_goto_iterindex(iter, NIT_ITERINDEX(iter));
    }

    /* Prepare the next buffers and set iterend/size */
    if (npyiter_copy_to_buffers(iter, prev_dataptrs) < 0) {
        npyiter_clear_buffers(iter);
        return 0;
    }

    return 1;
}


#line 187

/*
 * Iternext function that handles the reduction buffering part.  This
 * is done with a double loop to avoid frequent re-buffering.
 */
static int
npyiter_buffered_reduce_iternext_iters4(NpyIter *iter)
{
    npy_uint32 itflags = NIT_ITFLAGS(iter);
    /*int ndim = NIT_NDIM(iter);*/
#if 4 >= NPY_MAXDIMS
    int nop = NIT_NOP(iter);
#else
    const int nop = 4;
#endif

    int iop;

    NpyIter_AxisData *axisdata;
    NpyIter_BufferData *bufferdata = NIT_BUFFERDATA(iter);
    char **ptrs;
    char *prev_dataptrs[NPY_MAXARGS];

    ptrs = NBF_PTRS(bufferdata);

    /*
     * If the iterator handles the inner loop, need to increment all
     * the indices and pointers
     */
    if (!(itflags&NPY_ITFLAG_EXLOOP)) {
        /* Increment within the buffer */
        if (++NIT_ITERINDEX(iter) < NBF_BUFITEREND(bufferdata)) {
            npy_intp *strides;

            strides = NBF_STRIDES(bufferdata);
            for (iop = 0; iop < nop; ++iop) {
                ptrs[iop] += strides[iop];
            }
            return 1;
        }
    }
    else {
        NIT_ITERINDEX(iter) += NBF_SIZE(bufferdata);
    }

    NPY_IT_DBG_PRINT1("Iterator: Finished iteration %d of outer reduce loop\n",
                            (int)NBF_REDUCE_POS(bufferdata));
    /* The outer increment for the reduce double loop */
    if (++NBF_REDUCE_POS(bufferdata) < NBF_REDUCE_OUTERSIZE(bufferdata)) {
        npy_intp *reduce_outerstrides = NBF_REDUCE_OUTERSTRIDES(bufferdata);
        char **reduce_outerptrs = NBF_REDUCE_OUTERPTRS(bufferdata);
        for (iop = 0; iop < nop; ++iop) {
            char *ptr = reduce_outerptrs[iop] + reduce_outerstrides[iop];
            ptrs[iop] = ptr;
            reduce_outerptrs[iop] = ptr;
        }
        NBF_BUFITEREND(bufferdata) = NIT_ITERINDEX(iter) + NBF_SIZE(bufferdata);
        return 1;
    }

    /* Save the previously used data pointers */
    axisdata = NIT_AXISDATA(iter);
    memcpy(prev_dataptrs, NAD_PTRS(axisdata), NPY_SIZEOF_INTP*nop);

    /* Write back to the arrays */
    if (npyiter_copy_from_buffers(iter) < 0) {
        npyiter_clear_buffers(iter);
        return 0;
    }

    /* Check if we're past the end */
    if (NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        NBF_SIZE(bufferdata) = 0;
        return 0;
    }
    /* Increment to the next buffer */
    else {
        npyiter_goto_iterindex(iter, NIT_ITERINDEX(iter));
    }

    /* Prepare the next buffers and set iterend/size */
    if (npyiter_copy_to_buffers(iter, prev_dataptrs) < 0) {
        npyiter_clear_buffers(iter);
        return 0;
    }

    return 1;
}


#line 187

/*
 * Iternext function that handles the reduction buffering part.  This
 * is done with a double loop to avoid frequent re-buffering.
 */
static int
npyiter_buffered_reduce_iternext_itersANY(NpyIter *iter)
{
    npy_uint32 itflags = NIT_ITFLAGS(iter);
    /*int ndim = NIT_NDIM(iter);*/
#if NPY_MAXDIMS >= NPY_MAXDIMS
    int nop = NIT_NOP(iter);
#else
    const int nop = NPY_MAXDIMS;
#endif

    int iop;

    NpyIter_AxisData *axisdata;
    NpyIter_BufferData *bufferdata = NIT_BUFFERDATA(iter);
    char **ptrs;
    char *prev_dataptrs[NPY_MAXARGS];

    ptrs = NBF_PTRS(bufferdata);

    /*
     * If the iterator handles the inner loop, need to increment all
     * the indices and pointers
     */
    if (!(itflags&NPY_ITFLAG_EXLOOP)) {
        /* Increment within the buffer */
        if (++NIT_ITERINDEX(iter) < NBF_BUFITEREND(bufferdata)) {
            npy_intp *strides;

            strides = NBF_STRIDES(bufferdata);
            for (iop = 0; iop < nop; ++iop) {
                ptrs[iop] += strides[iop];
            }
            return 1;
        }
    }
    else {
        NIT_ITERINDEX(iter) += NBF_SIZE(bufferdata);
    }

    NPY_IT_DBG_PRINT1("Iterator: Finished iteration %d of outer reduce loop\n",
                            (int)NBF_REDUCE_POS(bufferdata));
    /* The outer increment for the reduce double loop */
    if (++NBF_REDUCE_POS(bufferdata) < NBF_REDUCE_OUTERSIZE(bufferdata)) {
        npy_intp *reduce_outerstrides = NBF_REDUCE_OUTERSTRIDES(bufferdata);
        char **reduce_outerptrs = NBF_REDUCE_OUTERPTRS(bufferdata);
        for (iop = 0; iop < nop; ++iop) {
            char *ptr = reduce_outerptrs[iop] + reduce_outerstrides[iop];
            ptrs[iop] = ptr;
            reduce_outerptrs[iop] = ptr;
        }
        NBF_BUFITEREND(bufferdata) = NIT_ITERINDEX(iter) + NBF_SIZE(bufferdata);
        return 1;
    }

    /* Save the previously used data pointers */
    axisdata = NIT_AXISDATA(iter);
    memcpy(prev_dataptrs, NAD_PTRS(axisdata), NPY_SIZEOF_INTP*nop);

    /* Write back to the arrays */
    if (npyiter_copy_from_buffers(iter) < 0) {
        npyiter_clear_buffers(iter);
        return 0;
    }

    /* Check if we're past the end */
    if (NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        NBF_SIZE(bufferdata) = 0;
        return 0;
    }
    /* Increment to the next buffer */
    else {
        npyiter_goto_iterindex(iter, NIT_ITERINDEX(iter));
    }

    /* Prepare the next buffers and set iterend/size */
    if (npyiter_copy_to_buffers(iter, prev_dataptrs) < 0) {
        npyiter_clear_buffers(iter);
        return 0;
    }

    return 1;
}



/* iternext function that handles the buffering part */
static int
npyiter_buffered_iternext(NpyIter *iter)
{
    npy_uint32 itflags = NIT_ITFLAGS(iter);
    /*int ndim = NIT_NDIM(iter);*/
    int nop = NIT_NOP(iter);

    NpyIter_BufferData *bufferdata = NIT_BUFFERDATA(iter);

    /*
     * If the iterator handles the inner loop, need to increment all
     * the indices and pointers
     */
    if (!(itflags&NPY_ITFLAG_EXLOOP)) {
        /* Increment within the buffer */
        if (++NIT_ITERINDEX(iter) < NBF_BUFITEREND(bufferdata)) {
            int iop;
            npy_intp *strides;
            char **ptrs;

            strides = NBF_STRIDES(bufferdata);
            ptrs = NBF_PTRS(bufferdata);
            for (iop = 0; iop < nop; ++iop) {
                ptrs[iop] += strides[iop];
            }
            return 1;
        }
    }
    else {
        NIT_ITERINDEX(iter) += NBF_SIZE(bufferdata);
    }

    /* Write back to the arrays */
    if (npyiter_copy_from_buffers(iter) < 0) {
        npyiter_clear_buffers(iter);
        return 0;
    }

    /* Check if we're past the end */
    if (NIT_ITERINDEX(iter) >= NIT_ITEREND(iter)) {
        NBF_SIZE(bufferdata) = 0;
        return 0;
    }
    /* Increment to the next buffer */
    else {
        npyiter_goto_iterindex(iter, NIT_ITERINDEX(iter));
    }

    /* Prepare the next buffers and set iterend/size */
    if (npyiter_copy_to_buffers(iter, NULL) < 0) {
        npyiter_clear_buffers(iter);
        return 0;
    }

    return 1;
}

/**end repeat2**/
/**end repeat1**/
/**end repeat**/

/* Specialization of iternext for when the iteration size is 1 */
static int
npyiter_iternext_sizeone(NpyIter *iter)
{
    return 0;
}

/*NUMPY_API
 * Compute the specialized iteration function for an iterator
 *
 * If errmsg is non-NULL, it should point to a variable which will
 * receive the error message, and no Python exception will be set.
 * This is so that the function can be called from code not holding
 * the GIL.
 */
NPY_NO_EXPORT NpyIter_IterNextFunc *
NpyIter_GetIterNext(NpyIter *iter, char **errmsg)
{
    npy_uint32 itflags = NIT_ITFLAGS(iter);
    int ndim = NIT_NDIM(iter);
    int nop = NIT_NOP(iter);

    if (NIT_ITERSIZE(iter) < 0) {
        if (errmsg == NULL) {
            PyErr_SetString(PyExc_ValueError, "iterator is too large");
        }
        else {
            *errmsg = "iterator is too large";
        }
        return NULL;
    }

    /*
     * When there is just one iteration and buffering is disabled
     * the iternext function is very simple.
     */
    if (itflags&NPY_ITFLAG_ONEITERATION) {
        return &npyiter_iternext_sizeone;
    }

    /*
     * If buffering is enabled.
     */
    if (itflags&NPY_ITFLAG_BUFFER) {
        if (itflags&NPY_ITFLAG_REDUCE) {
            switch (nop) {
                case 1:
                    return &npyiter_buffered_reduce_iternext_iters1;
                case 2:
                    return &npyiter_buffered_reduce_iternext_iters2;
                case 3:
                    return &npyiter_buffered_reduce_iternext_iters3;
                case 4:
                    return &npyiter_buffered_reduce_iternext_iters4;
                default:
                    return &npyiter_buffered_reduce_iternext_itersANY;
            }
        }
        else {
            return &npyiter_buffered_iternext;
        }
    }

    /*
     * Ignore all the flags that don't affect the iterator memory
     * layout or the iternext function.  Currently only HASINDEX,
     * EXLOOP, and RANGE affect them here.
     */
    itflags &= (NPY_ITFLAG_HASINDEX|NPY_ITFLAG_EXLOOP|NPY_ITFLAG_RANGE);

    /* Switch statements let the compiler optimize this most effectively */
    switch (itflags) {
    /*
     * The combinations HASINDEX|EXLOOP and RANGE|EXLOOP are excluded
     * by the New functions
     */
#line 424
        case 0:
            switch (ndim) {
#line 430
                case 1:
                    switch (nop) {
#line 436
                        case 1:
                            return &npyiter_iternext_itflags0_dims1_iters1;

#line 436
                        case 2:
                            return &npyiter_iternext_itflags0_dims1_iters2;

                        /* Not specialized on nop */
                        default:
                            return &npyiter_iternext_itflags0_dims1_itersANY;
                    }

#line 430
                case 2:
                    switch (nop) {
#line 436
                        case 1:
                            return &npyiter_iternext_itflags0_dims2_iters1;

#line 436
                        case 2:
                            return &npyiter_iternext_itflags0_dims2_iters2;

                        /* Not specialized on nop */
                        default:
                            return &npyiter_iternext_itflags0_dims2_itersANY;
                    }

                /* Not specialized on ndim */
                default:
                    switch (nop) {
#line 451
                        case 1:
                            return &npyiter_iternext_itflags0_dimsANY_iters1;

#line 451
                        case 2:
                            return &npyiter_iternext_itflags0_dimsANY_iters2;

                        /* Not specialized on nop */
                        default:
                            return &npyiter_iternext_itflags0_dimsANY_itersANY;
                    }
            }

#line 424
        case NPY_ITFLAG_HASINDEX:
            switch (ndim) {
#line 430
                case 1:
                    switch (nop) {
#line 436
                        case 1:
                            return &npyiter_iternext_itflagsIND_dims1_iters1;

#line 436
                        case 2:
                            return &npyiter_iternext_itflagsIND_dims1_iters2;

                        /* Not specialized on nop */
                        default:
                            return &npyiter_iternext_itflagsIND_dims1_itersANY;
                    }

#line 430
                case 2:
                    switch (nop) {
#line 436
                        case 1:
                            return &npyiter_iternext_itflagsIND_dims2_iters1;

#line 436
                        case 2:
                            return &npyiter_iternext_itflagsIND_dims2_iters2;

                        /* Not specialized on nop */
                        default:
                            return &npyiter_iternext_itflagsIND_dims2_itersANY;
                    }

                /* Not specialized on ndim */
                default:
                    switch (nop) {
#line 451
                        case 1:
                            return &npyiter_iternext_itflagsIND_dimsANY_iters1;

#line 451
                        case 2:
                            return &npyiter_iternext_itflagsIND_dimsANY_iters2;

                        /* Not specialized on nop */
                        default:
                            return &npyiter_iternext_itflagsIND_dimsANY_itersANY;
                    }
            }

#line 424
        case NPY_ITFLAG_EXLOOP:
            switch (ndim) {
#line 430
                case 1:
                    switch (nop) {
#line 436
                        case 1:
                            return &npyiter_iternext_itflagsNOINN_dims1_iters1;

#line 436
                        case 2:
                            return &npyiter_iternext_itflagsNOINN_dims1_iters2;

                        /* Not specialized on nop */
                        default:
                            return &npyiter_iternext_itflagsNOINN_dims1_itersANY;
                    }

#line 430
                case 2:
                    switch (nop) {
#line 436
                        case 1:
                            return &npyiter_iternext_itflagsNOINN_dims2_iters1;

#line 436
                        case 2:
                            return &npyiter_iternext_itflagsNOINN_dims2_iters2;

                        /* Not specialized on nop */
                        default:
                            return &npyiter_iternext_itflagsNOINN_dims2_itersANY;
                    }

                /* Not specialized on ndim */
                default:
                    switch (nop) {
#line 451
                        case 1:
                            return &npyiter_iternext_itflagsNOINN_dimsANY_iters1;

#line 451
                        case 2:
                            return &npyiter_iternext_itflagsNOINN_dimsANY_iters2;

                        /* Not specialized on nop */
                        default:
                            return &npyiter_iternext_itflagsNOINN_dimsANY_itersANY;
                    }
            }

#line 424
        case NPY_ITFLAG_RANGE:
            switch (ndim) {
#line 430
                case 1:
                    switch (nop) {
#line 436
                        case 1:
                            return &npyiter_iternext_itflagsRNG_dims1_iters1;

#line 436
                        case 2:
                            return &npyiter_iternext_itflagsRNG_dims1_iters2;

                        /* Not specialized on nop */
                        default:
                            return &npyiter_iternext_itflagsRNG_dims1_itersANY;
                    }

#line 430
                case 2:
                    switch (nop) {
#line 436
                        case 1:
                            return &npyiter_iternext_itflagsRNG_dims2_iters1;

#line 436
                        case 2:
                            return &npyiter_iternext_itflagsRNG_dims2_iters2;

                        /* Not specialized on nop */
                        default:
                            return &npyiter_iternext_itflagsRNG_dims2_itersANY;
                    }

                /* Not specialized on ndim */
                default:
                    switch (nop) {
#line 451
                        case 1:
                            return &npyiter_iternext_itflagsRNG_dimsANY_iters1;

#line 451
                        case 2:
                            return &npyiter_iternext_itflagsRNG_dimsANY_iters2;

                        /* Not specialized on nop */
                        default:
                            return &npyiter_iternext_itflagsRNG_dimsANY_itersANY;
                    }
            }

#line 424
        case NPY_ITFLAG_RANGE|NPY_ITFLAG_HASINDEX:
            switch (ndim) {
#line 430
                case 1:
                    switch (nop) {
#line 436
                        case 1:
                            return &npyiter_iternext_itflagsRNGuIND_dims1_iters1;

#line 436
                        case 2:
                            return &npyiter_iternext_itflagsRNGuIND_dims1_iters2;

                        /* Not specialized on nop */
                        default:
                            return &npyiter_iternext_itflagsRNGuIND_dims1_itersANY;
                    }

#line 430
                case 2:
                    switch (nop) {
#line 436
                        case 1:
                            return &npyiter_iternext_itflagsRNGuIND_dims2_iters1;

#line 436
                        case 2:
                            return &npyiter_iternext_itflagsRNGuIND_dims2_iters2;

                        /* Not specialized on nop */
                        default:
                            return &npyiter_iternext_itflagsRNGuIND_dims2_itersANY;
                    }

                /* Not specialized on ndim */
                default:
                    switch (nop) {
#line 451
                        case 1:
                            return &npyiter_iternext_itflagsRNGuIND_dimsANY_iters1;

#line 451
                        case 2:
                            return &npyiter_iternext_itflagsRNGuIND_dimsANY_iters2;

                        /* Not specialized on nop */
                        default:
                            return &npyiter_iternext_itflagsRNGuIND_dimsANY_itersANY;
                    }
            }

    }
    /* The switch above should have caught all the possibilities. */
    if (errmsg == NULL) {
        PyErr_Format(PyExc_ValueError,
                "GetIterNext internal iterator error - unexpected "
                "itflags/ndim/nop combination (%04x/%d/%d)",
                (int)itflags, (int)ndim, (int)nop);
    }
    else {
        *errmsg = "GetIterNext internal iterator error - unexpected "
                  "itflags/ndim/nop combination";
    }
    return NULL;
}


/* SPECIALIZED getindex functions */

#line 494
static void
npyiter_get_multi_index_itflags0(
                        NpyIter *iter, npy_intp *out_multi_index)
{
    const npy_uint32 itflags = 0;
    int idim, ndim = NIT_NDIM(iter);
    int nop = NIT_NOP(iter);

    npy_intp sizeof_axisdata;
    NpyIter_AxisData *axisdata;
#if !((0)&NPY_ITFLAG_IDENTPERM)
    npy_int8 *perm = NIT_PERM(iter);
#endif

    axisdata = NIT_AXISDATA(iter);
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#if ((0)&NPY_ITFLAG_IDENTPERM)
    out_multi_index += ndim-1;
    for(idim = 0; idim < ndim; ++idim, --out_multi_index,
                                    NIT_ADVANCE_AXISDATA(axisdata, 1)) {
        *out_multi_index = NAD_INDEX(axisdata);
    }
#elif !((0)&NPY_ITFLAG_NEGPERM)
    for(idim = 0; idim < ndim; ++idim, NIT_ADVANCE_AXISDATA(axisdata, 1)) {
        npy_int8 p = perm[idim];
        out_multi_index[ndim-p-1] = NAD_INDEX(axisdata);
    }
#else
    for(idim = 0; idim < ndim; ++idim, NIT_ADVANCE_AXISDATA(axisdata, 1)) {
        npy_int8 p = perm[idim];
        if (p < 0) {
            /* If the perm entry is negative, reverse the index */
            out_multi_index[ndim+p] = NAD_SHAPE(axisdata) - NAD_INDEX(axisdata) - 1;
        }
        else {
            out_multi_index[ndim-p-1] = NAD_INDEX(axisdata);
        }
    }
#endif /* not ident perm */
}

#line 494
static void
npyiter_get_multi_index_itflagsIND(
                        NpyIter *iter, npy_intp *out_multi_index)
{
    const npy_uint32 itflags = NPY_ITFLAG_HASINDEX;
    int idim, ndim = NIT_NDIM(iter);
    int nop = NIT_NOP(iter);

    npy_intp sizeof_axisdata;
    NpyIter_AxisData *axisdata;
#if !((NPY_ITFLAG_HASINDEX)&NPY_ITFLAG_IDENTPERM)
    npy_int8 *perm = NIT_PERM(iter);
#endif

    axisdata = NIT_AXISDATA(iter);
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#if ((NPY_ITFLAG_HASINDEX)&NPY_ITFLAG_IDENTPERM)
    out_multi_index += ndim-1;
    for(idim = 0; idim < ndim; ++idim, --out_multi_index,
                                    NIT_ADVANCE_AXISDATA(axisdata, 1)) {
        *out_multi_index = NAD_INDEX(axisdata);
    }
#elif !((NPY_ITFLAG_HASINDEX)&NPY_ITFLAG_NEGPERM)
    for(idim = 0; idim < ndim; ++idim, NIT_ADVANCE_AXISDATA(axisdata, 1)) {
        npy_int8 p = perm[idim];
        out_multi_index[ndim-p-1] = NAD_INDEX(axisdata);
    }
#else
    for(idim = 0; idim < ndim; ++idim, NIT_ADVANCE_AXISDATA(axisdata, 1)) {
        npy_int8 p = perm[idim];
        if (p < 0) {
            /* If the perm entry is negative, reverse the index */
            out_multi_index[ndim+p] = NAD_SHAPE(axisdata) - NAD_INDEX(axisdata) - 1;
        }
        else {
            out_multi_index[ndim-p-1] = NAD_INDEX(axisdata);
        }
    }
#endif /* not ident perm */
}

#line 494
static void
npyiter_get_multi_index_itflagsIDP(
                        NpyIter *iter, npy_intp *out_multi_index)
{
    const npy_uint32 itflags = NPY_ITFLAG_IDENTPERM;
    int idim, ndim = NIT_NDIM(iter);
    int nop = NIT_NOP(iter);

    npy_intp sizeof_axisdata;
    NpyIter_AxisData *axisdata;
#if !((NPY_ITFLAG_IDENTPERM)&NPY_ITFLAG_IDENTPERM)
    npy_int8 *perm = NIT_PERM(iter);
#endif

    axisdata = NIT_AXISDATA(iter);
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#if ((NPY_ITFLAG_IDENTPERM)&NPY_ITFLAG_IDENTPERM)
    out_multi_index += ndim-1;
    for(idim = 0; idim < ndim; ++idim, --out_multi_index,
                                    NIT_ADVANCE_AXISDATA(axisdata, 1)) {
        *out_multi_index = NAD_INDEX(axisdata);
    }
#elif !((NPY_ITFLAG_IDENTPERM)&NPY_ITFLAG_NEGPERM)
    for(idim = 0; idim < ndim; ++idim, NIT_ADVANCE_AXISDATA(axisdata, 1)) {
        npy_int8 p = perm[idim];
        out_multi_index[ndim-p-1] = NAD_INDEX(axisdata);
    }
#else
    for(idim = 0; idim < ndim; ++idim, NIT_ADVANCE_AXISDATA(axisdata, 1)) {
        npy_int8 p = perm[idim];
        if (p < 0) {
            /* If the perm entry is negative, reverse the index */
            out_multi_index[ndim+p] = NAD_SHAPE(axisdata) - NAD_INDEX(axisdata) - 1;
        }
        else {
            out_multi_index[ndim-p-1] = NAD_INDEX(axisdata);
        }
    }
#endif /* not ident perm */
}

#line 494
static void
npyiter_get_multi_index_itflagsINDuIDP(
                        NpyIter *iter, npy_intp *out_multi_index)
{
    const npy_uint32 itflags = NPY_ITFLAG_HASINDEX|NPY_ITFLAG_IDENTPERM;
    int idim, ndim = NIT_NDIM(iter);
    int nop = NIT_NOP(iter);

    npy_intp sizeof_axisdata;
    NpyIter_AxisData *axisdata;
#if !((NPY_ITFLAG_HASINDEX|NPY_ITFLAG_IDENTPERM)&NPY_ITFLAG_IDENTPERM)
    npy_int8 *perm = NIT_PERM(iter);
#endif

    axisdata = NIT_AXISDATA(iter);
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#if ((NPY_ITFLAG_HASINDEX|NPY_ITFLAG_IDENTPERM)&NPY_ITFLAG_IDENTPERM)
    out_multi_index += ndim-1;
    for(idim = 0; idim < ndim; ++idim, --out_multi_index,
                                    NIT_ADVANCE_AXISDATA(axisdata, 1)) {
        *out_multi_index = NAD_INDEX(axisdata);
    }
#elif !((NPY_ITFLAG_HASINDEX|NPY_ITFLAG_IDENTPERM)&NPY_ITFLAG_NEGPERM)
    for(idim = 0; idim < ndim; ++idim, NIT_ADVANCE_AXISDATA(axisdata, 1)) {
        npy_int8 p = perm[idim];
        out_multi_index[ndim-p-1] = NAD_INDEX(axisdata);
    }
#else
    for(idim = 0; idim < ndim; ++idim, NIT_ADVANCE_AXISDATA(axisdata, 1)) {
        npy_int8 p = perm[idim];
        if (p < 0) {
            /* If the perm entry is negative, reverse the index */
            out_multi_index[ndim+p] = NAD_SHAPE(axisdata) - NAD_INDEX(axisdata) - 1;
        }
        else {
            out_multi_index[ndim-p-1] = NAD_INDEX(axisdata);
        }
    }
#endif /* not ident perm */
}

#line 494
static void
npyiter_get_multi_index_itflagsNEGP(
                        NpyIter *iter, npy_intp *out_multi_index)
{
    const npy_uint32 itflags = NPY_ITFLAG_NEGPERM;
    int idim, ndim = NIT_NDIM(iter);
    int nop = NIT_NOP(iter);

    npy_intp sizeof_axisdata;
    NpyIter_AxisData *axisdata;
#if !((NPY_ITFLAG_NEGPERM)&NPY_ITFLAG_IDENTPERM)
    npy_int8 *perm = NIT_PERM(iter);
#endif

    axisdata = NIT_AXISDATA(iter);
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#if ((NPY_ITFLAG_NEGPERM)&NPY_ITFLAG_IDENTPERM)
    out_multi_index += ndim-1;
    for(idim = 0; idim < ndim; ++idim, --out_multi_index,
                                    NIT_ADVANCE_AXISDATA(axisdata, 1)) {
        *out_multi_index = NAD_INDEX(axisdata);
    }
#elif !((NPY_ITFLAG_NEGPERM)&NPY_ITFLAG_NEGPERM)
    for(idim = 0; idim < ndim; ++idim, NIT_ADVANCE_AXISDATA(axisdata, 1)) {
        npy_int8 p = perm[idim];
        out_multi_index[ndim-p-1] = NAD_INDEX(axisdata);
    }
#else
    for(idim = 0; idim < ndim; ++idim, NIT_ADVANCE_AXISDATA(axisdata, 1)) {
        npy_int8 p = perm[idim];
        if (p < 0) {
            /* If the perm entry is negative, reverse the index */
            out_multi_index[ndim+p] = NAD_SHAPE(axisdata) - NAD_INDEX(axisdata) - 1;
        }
        else {
            out_multi_index[ndim-p-1] = NAD_INDEX(axisdata);
        }
    }
#endif /* not ident perm */
}

#line 494
static void
npyiter_get_multi_index_itflagsINDuNEGP(
                        NpyIter *iter, npy_intp *out_multi_index)
{
    const npy_uint32 itflags = NPY_ITFLAG_HASINDEX|NPY_ITFLAG_NEGPERM;
    int idim, ndim = NIT_NDIM(iter);
    int nop = NIT_NOP(iter);

    npy_intp sizeof_axisdata;
    NpyIter_AxisData *axisdata;
#if !((NPY_ITFLAG_HASINDEX|NPY_ITFLAG_NEGPERM)&NPY_ITFLAG_IDENTPERM)
    npy_int8 *perm = NIT_PERM(iter);
#endif

    axisdata = NIT_AXISDATA(iter);
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#if ((NPY_ITFLAG_HASINDEX|NPY_ITFLAG_NEGPERM)&NPY_ITFLAG_IDENTPERM)
    out_multi_index += ndim-1;
    for(idim = 0; idim < ndim; ++idim, --out_multi_index,
                                    NIT_ADVANCE_AXISDATA(axisdata, 1)) {
        *out_multi_index = NAD_INDEX(axisdata);
    }
#elif !((NPY_ITFLAG_HASINDEX|NPY_ITFLAG_NEGPERM)&NPY_ITFLAG_NEGPERM)
    for(idim = 0; idim < ndim; ++idim, NIT_ADVANCE_AXISDATA(axisdata, 1)) {
        npy_int8 p = perm[idim];
        out_multi_index[ndim-p-1] = NAD_INDEX(axisdata);
    }
#else
    for(idim = 0; idim < ndim; ++idim, NIT_ADVANCE_AXISDATA(axisdata, 1)) {
        npy_int8 p = perm[idim];
        if (p < 0) {
            /* If the perm entry is negative, reverse the index */
            out_multi_index[ndim+p] = NAD_SHAPE(axisdata) - NAD_INDEX(axisdata) - 1;
        }
        else {
            out_multi_index[ndim-p-1] = NAD_INDEX(axisdata);
        }
    }
#endif /* not ident perm */
}

#line 494
static void
npyiter_get_multi_index_itflagsBUF(
                        NpyIter *iter, npy_intp *out_multi_index)
{
    const npy_uint32 itflags = NPY_ITFLAG_BUFFER;
    int idim, ndim = NIT_NDIM(iter);
    int nop = NIT_NOP(iter);

    npy_intp sizeof_axisdata;
    NpyIter_AxisData *axisdata;
#if !((NPY_ITFLAG_BUFFER)&NPY_ITFLAG_IDENTPERM)
    npy_int8 *perm = NIT_PERM(iter);
#endif

    axisdata = NIT_AXISDATA(iter);
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#if ((NPY_ITFLAG_BUFFER)&NPY_ITFLAG_IDENTPERM)
    out_multi_index += ndim-1;
    for(idim = 0; idim < ndim; ++idim, --out_multi_index,
                                    NIT_ADVANCE_AXISDATA(axisdata, 1)) {
        *out_multi_index = NAD_INDEX(axisdata);
    }
#elif !((NPY_ITFLAG_BUFFER)&NPY_ITFLAG_NEGPERM)
    for(idim = 0; idim < ndim; ++idim, NIT_ADVANCE_AXISDATA(axisdata, 1)) {
        npy_int8 p = perm[idim];
        out_multi_index[ndim-p-1] = NAD_INDEX(axisdata);
    }
#else
    for(idim = 0; idim < ndim; ++idim, NIT_ADVANCE_AXISDATA(axisdata, 1)) {
        npy_int8 p = perm[idim];
        if (p < 0) {
            /* If the perm entry is negative, reverse the index */
            out_multi_index[ndim+p] = NAD_SHAPE(axisdata) - NAD_INDEX(axisdata) - 1;
        }
        else {
            out_multi_index[ndim-p-1] = NAD_INDEX(axisdata);
        }
    }
#endif /* not ident perm */
}

#line 494
static void
npyiter_get_multi_index_itflagsINDuBUF(
                        NpyIter *iter, npy_intp *out_multi_index)
{
    const npy_uint32 itflags = NPY_ITFLAG_HASINDEX|NPY_ITFLAG_BUFFER;
    int idim, ndim = NIT_NDIM(iter);
    int nop = NIT_NOP(iter);

    npy_intp sizeof_axisdata;
    NpyIter_AxisData *axisdata;
#if !((NPY_ITFLAG_HASINDEX|NPY_ITFLAG_BUFFER)&NPY_ITFLAG_IDENTPERM)
    npy_int8 *perm = NIT_PERM(iter);
#endif

    axisdata = NIT_AXISDATA(iter);
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#if ((NPY_ITFLAG_HASINDEX|NPY_ITFLAG_BUFFER)&NPY_ITFLAG_IDENTPERM)
    out_multi_index += ndim-1;
    for(idim = 0; idim < ndim; ++idim, --out_multi_index,
                                    NIT_ADVANCE_AXISDATA(axisdata, 1)) {
        *out_multi_index = NAD_INDEX(axisdata);
    }
#elif !((NPY_ITFLAG_HASINDEX|NPY_ITFLAG_BUFFER)&NPY_ITFLAG_NEGPERM)
    for(idim = 0; idim < ndim; ++idim, NIT_ADVANCE_AXISDATA(axisdata, 1)) {
        npy_int8 p = perm[idim];
        out_multi_index[ndim-p-1] = NAD_INDEX(axisdata);
    }
#else
    for(idim = 0; idim < ndim; ++idim, NIT_ADVANCE_AXISDATA(axisdata, 1)) {
        npy_int8 p = perm[idim];
        if (p < 0) {
            /* If the perm entry is negative, reverse the index */
            out_multi_index[ndim+p] = NAD_SHAPE(axisdata) - NAD_INDEX(axisdata) - 1;
        }
        else {
            out_multi_index[ndim-p-1] = NAD_INDEX(axisdata);
        }
    }
#endif /* not ident perm */
}

#line 494
static void
npyiter_get_multi_index_itflagsIDPuBUF(
                        NpyIter *iter, npy_intp *out_multi_index)
{
    const npy_uint32 itflags = NPY_ITFLAG_IDENTPERM|NPY_ITFLAG_BUFFER;
    int idim, ndim = NIT_NDIM(iter);
    int nop = NIT_NOP(iter);

    npy_intp sizeof_axisdata;
    NpyIter_AxisData *axisdata;
#if !((NPY_ITFLAG_IDENTPERM|NPY_ITFLAG_BUFFER)&NPY_ITFLAG_IDENTPERM)
    npy_int8 *perm = NIT_PERM(iter);
#endif

    axisdata = NIT_AXISDATA(iter);
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#if ((NPY_ITFLAG_IDENTPERM|NPY_ITFLAG_BUFFER)&NPY_ITFLAG_IDENTPERM)
    out_multi_index += ndim-1;
    for(idim = 0; idim < ndim; ++idim, --out_multi_index,
                                    NIT_ADVANCE_AXISDATA(axisdata, 1)) {
        *out_multi_index = NAD_INDEX(axisdata);
    }
#elif !((NPY_ITFLAG_IDENTPERM|NPY_ITFLAG_BUFFER)&NPY_ITFLAG_NEGPERM)
    for(idim = 0; idim < ndim; ++idim, NIT_ADVANCE_AXISDATA(axisdata, 1)) {
        npy_int8 p = perm[idim];
        out_multi_index[ndim-p-1] = NAD_INDEX(axisdata);
    }
#else
    for(idim = 0; idim < ndim; ++idim, NIT_ADVANCE_AXISDATA(axisdata, 1)) {
        npy_int8 p = perm[idim];
        if (p < 0) {
            /* If the perm entry is negative, reverse the index */
            out_multi_index[ndim+p] = NAD_SHAPE(axisdata) - NAD_INDEX(axisdata) - 1;
        }
        else {
            out_multi_index[ndim-p-1] = NAD_INDEX(axisdata);
        }
    }
#endif /* not ident perm */
}

#line 494
static void
npyiter_get_multi_index_itflagsINDuIDPuBUF(
                        NpyIter *iter, npy_intp *out_multi_index)
{
    const npy_uint32 itflags = NPY_ITFLAG_HASINDEX|NPY_ITFLAG_IDENTPERM|NPY_ITFLAG_BUFFER;
    int idim, ndim = NIT_NDIM(iter);
    int nop = NIT_NOP(iter);

    npy_intp sizeof_axisdata;
    NpyIter_AxisData *axisdata;
#if !((NPY_ITFLAG_HASINDEX|NPY_ITFLAG_IDENTPERM|NPY_ITFLAG_BUFFER)&NPY_ITFLAG_IDENTPERM)
    npy_int8 *perm = NIT_PERM(iter);
#endif

    axisdata = NIT_AXISDATA(iter);
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#if ((NPY_ITFLAG_HASINDEX|NPY_ITFLAG_IDENTPERM|NPY_ITFLAG_BUFFER)&NPY_ITFLAG_IDENTPERM)
    out_multi_index += ndim-1;
    for(idim = 0; idim < ndim; ++idim, --out_multi_index,
                                    NIT_ADVANCE_AXISDATA(axisdata, 1)) {
        *out_multi_index = NAD_INDEX(axisdata);
    }
#elif !((NPY_ITFLAG_HASINDEX|NPY_ITFLAG_IDENTPERM|NPY_ITFLAG_BUFFER)&NPY_ITFLAG_NEGPERM)
    for(idim = 0; idim < ndim; ++idim, NIT_ADVANCE_AXISDATA(axisdata, 1)) {
        npy_int8 p = perm[idim];
        out_multi_index[ndim-p-1] = NAD_INDEX(axisdata);
    }
#else
    for(idim = 0; idim < ndim; ++idim, NIT_ADVANCE_AXISDATA(axisdata, 1)) {
        npy_int8 p = perm[idim];
        if (p < 0) {
            /* If the perm entry is negative, reverse the index */
            out_multi_index[ndim+p] = NAD_SHAPE(axisdata) - NAD_INDEX(axisdata) - 1;
        }
        else {
            out_multi_index[ndim-p-1] = NAD_INDEX(axisdata);
        }
    }
#endif /* not ident perm */
}

#line 494
static void
npyiter_get_multi_index_itflagsNEGPuBUF(
                        NpyIter *iter, npy_intp *out_multi_index)
{
    const npy_uint32 itflags = NPY_ITFLAG_NEGPERM|NPY_ITFLAG_BUFFER;
    int idim, ndim = NIT_NDIM(iter);
    int nop = NIT_NOP(iter);

    npy_intp sizeof_axisdata;
    NpyIter_AxisData *axisdata;
#if !((NPY_ITFLAG_NEGPERM|NPY_ITFLAG_BUFFER)&NPY_ITFLAG_IDENTPERM)
    npy_int8 *perm = NIT_PERM(iter);
#endif

    axisdata = NIT_AXISDATA(iter);
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#if ((NPY_ITFLAG_NEGPERM|NPY_ITFLAG_BUFFER)&NPY_ITFLAG_IDENTPERM)
    out_multi_index += ndim-1;
    for(idim = 0; idim < ndim; ++idim, --out_multi_index,
                                    NIT_ADVANCE_AXISDATA(axisdata, 1)) {
        *out_multi_index = NAD_INDEX(axisdata);
    }
#elif !((NPY_ITFLAG_NEGPERM|NPY_ITFLAG_BUFFER)&NPY_ITFLAG_NEGPERM)
    for(idim = 0; idim < ndim; ++idim, NIT_ADVANCE_AXISDATA(axisdata, 1)) {
        npy_int8 p = perm[idim];
        out_multi_index[ndim-p-1] = NAD_INDEX(axisdata);
    }
#else
    for(idim = 0; idim < ndim; ++idim, NIT_ADVANCE_AXISDATA(axisdata, 1)) {
        npy_int8 p = perm[idim];
        if (p < 0) {
            /* If the perm entry is negative, reverse the index */
            out_multi_index[ndim+p] = NAD_SHAPE(axisdata) - NAD_INDEX(axisdata) - 1;
        }
        else {
            out_multi_index[ndim-p-1] = NAD_INDEX(axisdata);
        }
    }
#endif /* not ident perm */
}

#line 494
static void
npyiter_get_multi_index_itflagsINDuNEGPuBUF(
                        NpyIter *iter, npy_intp *out_multi_index)
{
    const npy_uint32 itflags = NPY_ITFLAG_HASINDEX|NPY_ITFLAG_NEGPERM|NPY_ITFLAG_BUFFER;
    int idim, ndim = NIT_NDIM(iter);
    int nop = NIT_NOP(iter);

    npy_intp sizeof_axisdata;
    NpyIter_AxisData *axisdata;
#if !((NPY_ITFLAG_HASINDEX|NPY_ITFLAG_NEGPERM|NPY_ITFLAG_BUFFER)&NPY_ITFLAG_IDENTPERM)
    npy_int8 *perm = NIT_PERM(iter);
#endif

    axisdata = NIT_AXISDATA(iter);
    sizeof_axisdata = NIT_AXISDATA_SIZEOF(itflags, ndim, nop);
#if ((NPY_ITFLAG_HASINDEX|NPY_ITFLAG_NEGPERM|NPY_ITFLAG_BUFFER)&NPY_ITFLAG_IDENTPERM)
    out_multi_index += ndim-1;
    for(idim = 0; idim < ndim; ++idim, --out_multi_index,
                                    NIT_ADVANCE_AXISDATA(axisdata, 1)) {
        *out_multi_index = NAD_INDEX(axisdata);
    }
#elif !((NPY_ITFLAG_HASINDEX|NPY_ITFLAG_NEGPERM|NPY_ITFLAG_BUFFER)&NPY_ITFLAG_NEGPERM)
    for(idim = 0; idim < ndim; ++idim, NIT_ADVANCE_AXISDATA(axisdata, 1)) {
        npy_int8 p = perm[idim];
        out_multi_index[ndim-p-1] = NAD_INDEX(axisdata);
    }
#else
    for(idim = 0; idim < ndim; ++idim, NIT_ADVANCE_AXISDATA(axisdata, 1)) {
        npy_int8 p = perm[idim];
        if (p < 0) {
            /* If the perm entry is negative, reverse the index */
            out_multi_index[ndim+p] = NAD_SHAPE(axisdata) - NAD_INDEX(axisdata) - 1;
        }
        else {
            out_multi_index[ndim-p-1] = NAD_INDEX(axisdata);
        }
    }
#endif /* not ident perm */
}


/*NUMPY_API
 * Compute a specialized get_multi_index function for the iterator
 *
 * If errmsg is non-NULL, it should point to a variable which will
 * receive the error message, and no Python exception will be set.
 * This is so that the function can be called from code not holding
 * the GIL.
 */
NPY_NO_EXPORT NpyIter_GetMultiIndexFunc *
NpyIter_GetGetMultiIndex(NpyIter *iter, char **errmsg)
{
    npy_uint32 itflags = NIT_ITFLAGS(iter);
    int ndim = NIT_NDIM(iter);
    int nop = NIT_NOP(iter);

    /* These flags must be correct */
    if ((itflags&(NPY_ITFLAG_HASMULTIINDEX|NPY_ITFLAG_DELAYBUF)) !=
            NPY_ITFLAG_HASMULTIINDEX) {
        if (!(itflags&NPY_ITFLAG_HASMULTIINDEX)) {
            if (errmsg == NULL) {
                PyErr_SetString(PyExc_ValueError,
                        "Cannot retrieve a GetMultiIndex function for an "
                        "iterator that doesn't track a multi-index.");
            }
            else {
                *errmsg = "Cannot retrieve a GetMultiIndex function for an "
                          "iterator that doesn't track a multi-index.";
            }
            return NULL;
        }
        else {
            if (errmsg == NULL) {
                PyErr_SetString(PyExc_ValueError,
                        "Cannot retrieve a GetMultiIndex function for an "
                        "iterator that used DELAY_BUFALLOC before a Reset call");
            }
            else {
                *errmsg = "Cannot retrieve a GetMultiIndex function for an "
                          "iterator that used DELAY_BUFALLOC before a "
                          "Reset call";
            }
            return NULL;
        }
    }

    /*
     * Only these flags affect the iterator memory layout or
     * the get_multi_index behavior. IDENTPERM and NEGPERM are mutually
     * exclusive, so that reduces the number of cases slightly.
     */
    itflags &= (NPY_ITFLAG_HASINDEX |
                NPY_ITFLAG_IDENTPERM |
                NPY_ITFLAG_NEGPERM |
                NPY_ITFLAG_BUFFER);

    switch (itflags) {
#line 608
        case 0:
            return npyiter_get_multi_index_itflags0;

#line 608
        case NPY_ITFLAG_HASINDEX:
            return npyiter_get_multi_index_itflagsIND;

#line 608
        case NPY_ITFLAG_IDENTPERM:
            return npyiter_get_multi_index_itflagsIDP;

#line 608
        case NPY_ITFLAG_HASINDEX|NPY_ITFLAG_IDENTPERM:
            return npyiter_get_multi_index_itflagsINDuIDP;

#line 608
        case NPY_ITFLAG_NEGPERM:
            return npyiter_get_multi_index_itflagsNEGP;

#line 608
        case NPY_ITFLAG_HASINDEX|NPY_ITFLAG_NEGPERM:
            return npyiter_get_multi_index_itflagsINDuNEGP;

#line 608
        case NPY_ITFLAG_BUFFER:
            return npyiter_get_multi_index_itflagsBUF;

#line 608
        case NPY_ITFLAG_HASINDEX|NPY_ITFLAG_BUFFER:
            return npyiter_get_multi_index_itflagsINDuBUF;

#line 608
        case NPY_ITFLAG_IDENTPERM|NPY_ITFLAG_BUFFER:
            return npyiter_get_multi_index_itflagsIDPuBUF;

#line 608
        case NPY_ITFLAG_HASINDEX|NPY_ITFLAG_IDENTPERM|NPY_ITFLAG_BUFFER:
            return npyiter_get_multi_index_itflagsINDuIDPuBUF;

#line 608
        case NPY_ITFLAG_NEGPERM|NPY_ITFLAG_BUFFER:
            return npyiter_get_multi_index_itflagsNEGPuBUF;

#line 608
        case NPY_ITFLAG_HASINDEX|NPY_ITFLAG_NEGPERM|NPY_ITFLAG_BUFFER:
            return npyiter_get_multi_index_itflagsINDuNEGPuBUF;

    }
    /* The switch above should have caught all the possibilities. */
    if (errmsg == NULL) {
        PyErr_Format(PyExc_ValueError,
                "GetGetMultiIndex internal iterator error - unexpected "
                "itflags/ndim/nop combination (%04x/%d/%d)",
                (int)itflags, (int)ndim, (int)nop);
    }
    else {
        *errmsg = "GetGetMultiIndex internal iterator error - unexpected "
                  "itflags/ndim/nop combination";
    }
    return NULL;

}

#undef NPY_ITERATOR_IMPLEMENTATION_CODE

