}q (X   __module_docstringqX  This module contains a widget class and supporting classes for a generic HTML
renderer.  It supports only a subset of the HTML standards, and no Javascript
or CSS, but it is relatively lightweight and has no platform dependencies.  It
is suitable for displaying simple HTML documents, such as the application's
documentation or built-in help pages.

.. note:: Due to some internal dynamic initialization in wxWidgets, this
          module should be imported **before** the :class:`wx.App` object is
          created.
qX
   HtmlSelectionqX    qX   HtmlRenderingStateqXj   Selection state is passed to :meth:`wx.html.HtmlCell.Draw`   so that it can render itself differently e.g.qX   HtmlRenderingStyleqXS   :ref:`wx.html.HtmlSelection`  is data holder with information about text selection.qX   HtmlRenderingInfoq	XA   This class contains information given to cells when drawing them.q
X   HtmlCellqX   Internal data structure.qX   HtmlContainerCellq
Xm   The :ref:`wx.html.HtmlContainerCell`  class is an implementation of a cell that may contain more cells in it.qX   HtmlLinkInfoqXp   This class stores all necessary information about hypertext links (as represented by <A> tag in HTML documents).qX   HtmlColourCellqXH   This cell changes the colour of either the background or the foreground.qX   HtmlWidgetCellqX   :ref:`wx.html.HtmlWidgetCell`  is a class that provides a connection between HTML cells and widgets (an object derived from :ref:`wx.Window`).qX   HtmlWordCellqXP   This html cell represents a single word or text fragment in the document stream.qX   HtmlWordWithTabsCellqXi   :ref:`wx.html.HtmlWordCell`  is a specialization for storing text fragments with embedded tab characters.qX   HtmlFontCellqX:   This cell represents a font change in the document stream.qX
   HtmlFilterqXN   This class is the parent class of input filters for :ref:`wx.html.HtmlWindow`.qX   HtmlTagqX(   This class represents a single HTML tag.qX   HtmlTagHandlerqhX
   HtmlParserq X   Classes derived from this handle the **generic**  parsing of HTML documents: it scans the document and divide it into blocks of tags (where one block consists of beginning and ending tag and of text between these two tags).q!X   HtmlWindowInterfaceq"X   Abstract interface to a HTML rendering window (such as :ref:`wx.html.HtmlWindow`  or :ref:`wx.html.HtmlListBox`) that is passed to :ref:`wx.html.HtmlWinParser`.q#X
   HtmlWindowq$X   :ref:`wx.html.HtmlWindow`  is probably the only class you will directly use unless you want to do something special (like adding new tag handlers or MIME filters).q%X
   HtmlLinkEventq&XO   This event class is used for the events generated by :ref:`wx.html.HtmlWindow`.q'X
   HtmlCellEventq(XO   This event class is used for the events generated by :ref:`wx.html.HtmlWindow`.q)X   HtmlDCRendererq*XB   This class can render HTML document into a specified area of a DC.q+X   HtmlEasyPrintingq,XC   This class provides very simple interface to printing architecture.q-X   HtmlPrintoutq.X7   This class serves as printout class for HTML documents.q/X   HtmlWinTagHandlerq0X   This is basically :ref:`wx.html.HtmlTagHandler`  except that it is extended with protected member m_WParser pointing to the :ref:`wx.html.HtmlWinParser`  object (value of this member is identical to :ref:`wx.html.HtmlParser`'s m_Parser).q1X
   HtmlWinParserq2X   This class is derived from :ref:`wx.html.HtmlParser`  and its main goal is to parse HTML input so that it can be displayed in :ref:`wx.html.HtmlWindow`.q3X   HtmlBookRecordq4X-   Helper class for :ref:`wx.html.HtmlHelpData`.q5X   HtmlHelpDataItemq6X-   Helper class for :ref:`wx.html.HtmlHelpData`.q7X   HtmlHelpDataq8Xu   This class is used by :ref:`wx.html.HtmlHelpController`  and :ref:`wx.html.HtmlHelpFrame`  to access HTML help items.q9X
   HtmlHelpFrameq:XI   This class is used by :ref:`wx.html.HtmlHelpController`  to display help.q;X   HtmlHelpDialogq<XI   This class is used by :ref:`wx.html.HtmlHelpController`  to display help.q=X   HtmlHelpWindowq>X   This class is used by :ref:`wx.html.HtmlHelpController`  to display help within a frame or dialog, but you can use it yourself to create an embedded HTML help window.q?X   HtmlHelpControllerq@X   This help controller provides an easy way of displaying HTML help in your application (see :ref:`HTML Sample <html sample>`, test example).qAX
   HtmlModalHelpqBXU   This class uses :ref:`wx.html.HtmlHelpController`  to display help in a modal dialog.qCX   HtmlListBoxqDXu   :ref:`wx.html.HtmlListBox`  is an implementation of :ref:`wx.VListBox`  which shows HTML content in the listbox rows.qEX   SimpleHtmlListBoxqFX   :ref:`wx.html.SimpleHtmlListBox`  is an implementation of :ref:`wx.html.HtmlListBox`  which shows HTML content in the listbox rows.qGu.