/************************************************************************/
/*									*/
/*  Windows Enhanced Meta File and GDI specific definitions.		*/
/*									*/
/************************************************************************/

#   include	<geo2DInteger.h>

typedef enum EmrRecordType
{
    EMR_HEADER = 0x00000001,
    EMR_POLYBEZIER = 0x00000002,
    EMR_POLYGON = 0x00000003,
    EMR_POLYLINE = 0x00000004,
    EMR_POLYBEZIERTO = 0x00000005,
    EMR_POLYLINETO = 0x00000006,
    EMR_POLYPOLYLINE = 0x00000007,
    EMR_POLYPOLYGON = 0x00000008,
    EMR_SETWINDOWEXTEX = 0x00000009,
    EMR_SETWINDOWORGEX = 0x0000000A,
    EMR_SETVIEWPORTEXTEX = 0x0000000B,
    EMR_SETVIEWPORTORGEX = 0x0000000C,
    EMR_SETBRUSHORGEX = 0x0000000D,
    EMR_EOF = 0x0000000E,
    EMR_SETPIXELV = 0x0000000F,
    EMR_SETMAPPERFLAGS = 0x00000010,
    EMR_SETMAPMODE = 0x00000011,
    EMR_SETBKMODE = 0x00000012,
    EMR_SETPOLYFILLMODE = 0x00000013,
    EMR_SETROP2 = 0x00000014,
    EMR_SETSTRETCHBLTMODE = 0x00000015,
    EMR_SETTEXTALIGN = 0x00000016,
    EMR_SETCOLORADJUSTMENT = 0x00000017,
    EMR_SETTEXTCOLOR = 0x00000018,
    EMR_SETBKCOLOR = 0x00000019,
    EMR_OFFSETCLIPRGN = 0x0000001A,
    EMR_MOVETOEX = 0x0000001B,
    EMR_SETMETARGN = 0x0000001C,
    EMR_EXCLUDECLIPRECT = 0x0000001D,
    EMR_INTERSECTCLIPRECT = 0x0000001E,
    EMR_SCALEVIEWPORTEXTEX = 0x0000001F,
    EMR_SCALEWINDOWEXTEX = 0x00000020,
    EMR_SAVEDC = 0x00000021,
    EMR_RESTOREDC = 0x00000022,
    EMR_SETWORLDTRANSFORM = 0x00000023,
    EMR_MODIFYWORLDTRANSFORM = 0x00000024,
    EMR_SELECTOBJECT = 0x00000025,
    EMR_CREATEPEN = 0x00000026,
    EMR_CREATEBRUSHINDIRECT = 0x00000027,
    EMR_DELETEOBJECT = 0x00000028,
    EMR_ANGLEARC = 0x00000029,
    EMR_ELLIPSE = 0x0000002A,
    EMR_RECTANGLE = 0x0000002B,
    EMR_ROUNDRECT = 0x0000002C,
    EMR_ARC = 0x0000002D,
    EMR_CHORD = 0x0000002E,
    EMR_PIE = 0x0000002F,
    EMR_SELECTPALETTE = 0x00000030,
    EMR_CREATEPALETTE = 0x00000031,
    EMR_SETPALETTEENTRIES = 0x00000032,
    EMR_RESIZEPALETTE = 0x00000033,
    EMR_REALIZEPALETTE = 0x00000034,
    EMR_EXTFLOODFILL = 0x00000035,
    EMR_LINETO = 0x00000036,
    EMR_ARCTO = 0x00000037,
    EMR_POLYDRAW = 0x00000038,
    EMR_SETARCDIRECTION = 0x00000039,
    EMR_SETMITERLIMIT = 0x0000003A,
    EMR_BEGINPATH = 0x0000003B,
    EMR_ENDPATH = 0x0000003C,
    EMR_CLOSEFIGURE = 0x0000003D,
    EMR_FILLPATH = 0x0000003E,
    EMR_STROKEANDFILLPATH = 0x0000003F,
    EMR_STROKEPATH = 0x00000040,
    EMR_FLATTENPATH = 0x00000041,
    EMR_WIDENPATH = 0x00000042,
    EMR_SELECTCLIPPATH = 0x00000043,
    EMR_ABORTPATH = 0x00000044,
    EMR_COMMENT = 0x00000046,
    EMR_FILLRGN = 0x00000047,
    EMR_FRAMERGN = 0x00000048,
    EMR_INVERTRGN = 0x00000049,
    EMR_PAINTRGN = 0x0000004A,
    EMR_EXTSELECTCLIPRGN = 0x0000004B,
    EMR_BITBLT = 0x0000004C,
    EMR_STRETCHBLT = 0x0000004D,
    EMR_MASKBLT = 0x0000004E,
    EMR_PLGBLT = 0x0000004F,
    EMR_SETDIBITSTODEVICE = 0x00000050,
    EMR_STRETCHDIBITS = 0x00000051,
    EMR_EXTCREATEFONTINDIRECTW = 0x00000052,
    EMR_EXTTEXTOUTA = 0x00000053,
    EMR_EXTTEXTOUTW = 0x00000054,
    EMR_POLYBEZIER16 = 0x00000055,
    EMR_POLYGON16 = 0x00000056,
    EMR_POLYLINE16 = 0x00000057,
    EMR_POLYBEZIERTO16 = 0x00000058,
    EMR_POLYLINETO16 = 0x00000059,
    EMR_POLYPOLYLINE16 = 0x0000005A,
    EMR_POLYPOLYGON16 = 0x0000005B,
    EMR_POLYDRAW16 = 0x0000005C,
    EMR_CREATEMONOBRUSH = 0x0000005D,
    EMR_CREATEDIBPATTERNBRUSHPT = 0x0000005E,
    EMR_EXTCREATEPEN = 0x0000005F,
    EMR_POLYTEXTOUTA = 0x00000060,
    EMR_POLYTEXTOUTW = 0x00000061,
    EMR_SETICMMODE = 0x00000062,
    EMR_CREATECOLORSPACE = 0x00000063,
    EMR_SETCOLORSPACE = 0x00000064,
    EMR_DELETECOLORSPACE = 0x00000065,
    EMR_GLSRECORD = 0x00000066,
    EMR_GLSBOUNDEDRECORD = 0x00000067,
    EMR_PIXELFORMAT = 0x00000068,
    EMR_DRAWESCAPE = 0x00000069,
    EMR_EXTESCAPE = 0x0000006A,
    EMR_SMALLTEXTOUT = 0x0000006C,
    EMR_FORCEUFIMAPPING = 0x0000006D,
    EMR_NAMEDESCAPE = 0x0000006E,
    EMR_COLORCORRECTPALETTE = 0x0000006F,
    EMR_SETICMPROFILEA = 0x00000070,
    EMR_SETICMPROFILEW = 0x00000071,
    EMR_ALPHABLEND = 0x00000072,
    EMR_SETLAYOUT = 0x00000073,
    EMR_TRANSPARENTBLT = 0x00000074,
    EMR_GRADIENTFILL = 0x00000076,
    EMR_SETLINKEDUFIS = 0x00000077,
    EMR_SETTEXTJUSTIFICATION = 0x00000078,
    EMR_COLORMATCHTOTARGETW = 0x00000079,
    EMR_CREATECOLORSPACEW = 0x0000007A
} EmrRecordType;

#   define	WHITE_BRUSH		0x80000000
#   define	LTGRAY_BRUSH		0x80000001
#   define	GRAY_BRUSH		0x80000002
#   define	DKGRAY_BRUSH		0x80000003
#   define	BLACK_BRUSH		0x80000004
#   define	NULL_BRUSH		0x80000005
#   define	WHITE_PEN		0x80000006
#   define	BLACK_PEN		0x80000007
#   define	NULL_PEN		0x80000008
#   define	OEM_FIXED_FONT		0x8000000A
#   define	ANSI_FIXED_FONT		0x8000000B
#   define	ANSI_VAR_FONT		0x8000000C
#   define	SYSTEM_FONT		0x8000000D
#   define	DEVICE_DEFAULT_FONT	0x8000000E
#   define	DEFAULT_PALETTE		0x8000000F
#   define	SYSTEM_FIXED_FONT	0x80000010
#   define	DEFAULT_GUI_FONT	0x80000011
#   define	DC_BRUSH		0x80000012
#   define	DC_PEN			0x80000013

typedef enum
    {
    MWT_IDENTITY = 0x01,
    MWT_LEFTMULTIPLY = 0x02,
    MWT_RIGHTMULTIPLY = 0x03,
    MWT_SET = 0x04
    } ModifyWorldTransformMode;

typedef enum
    {
    ETO_OPAQUE = 0x00000002,
    ETO_CLIPPED = 0x00000004,
    ETO_GLYPH_INDEX = 0x00000010,
    ETO_RTLREADING = 0x00000080,
    ETO_NO_RECT = 0x00000100,
    ETO_SMALL_CHARS = 0x00000200,
    ETO_NUMERICSLOCAL = 0x00000400,
    ETO_NUMERICSLATIN = 0x00000800,
    ETO_IGNORELANGUAGE = 0x00001000,
    ETO_PDY = 0x00002000,
    ETO_REVERSE_INDEX_MAP = 0x00010000
    } ExtTextOutOptions;

typedef enum
    {
    GM_COMPATIBLE = 0x00000001,
    GM_ADVANCED = 0x00000002
    } GraphicsMode;

/************************************************************************/
/*									*/
/*  The header of an EMF metafile.					*/
/*									*/
/************************************************************************/

typedef struct EmfHeader
    {
    unsigned long	eh_headerSize;
    DocumentRectangle	ehBounds;	/*  In device units		*/
    DocumentRectangle	ehFrame;	/*  In 0.01 mm units		*/
    unsigned long	eh_signature;
    unsigned long	eh_version;
    unsigned long	eh_size;
    unsigned long	eh_numOfRecords;
    unsigned int	eh_numOfHandles;
    unsigned int	eh_reserved;
    unsigned long	eh_sizeOfDescrip;
    unsigned long	eh_offsOfDescrip;
    unsigned long	eh_numPalEntries;
    long		eh_widthDevPixels;
    long		eh_heightDevPixels;
    long		eh_widthDevMM;
    long		eh_heightDevMM;
    } EmfHeader;
