;; $Id: dbbibl.dsl,v 1.1 1998/02/18 13:14:08 rosalia Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

;; ......................... BIBLIOGRAPHIC DATA .........................

(define %biblsep% ", ")
(define %biblend% ".")

(element BIBLIOGRAPHY ($component$))
(element (BIBLIOGRAPHY TITLE) (empty-sosofo))

(element BIBLIODIV ($section$))
(element (BIBLIODIV TITLE) (empty-sosofo))

(element BIBLIOENTRY 
  (let* ((proper_children (children (current-node)))
	 ;; improper children?
	 (other_children (expand-children proper_children
					  '("BIBLIOMSET" "BIBLIOSET")))
	 (print_children (node-list-filter-by-gi other_children
						 '("ABBREV"
						   "AUTHORGROUP"
						   "AUTHOR"
						   "TITLE"
						   "PUBLISHER"
						   "COPYRIGHT"
						   "ISBN"
						   "ISSN"
						   "PAGENUMS"))))
    (make paragraph
      space-before: %para-sep%
      space-after: %para-sep%
      start-indent: (+ (inherited-start-indent) 2pi)
      first-line-start-indent: -2pi
      (let loop ((nl print_children))
	(if (node-list-empty? nl)
	    (empty-sosofo)
	    (make sequence
	      (process-node-list (node-list-first nl))
	      (if (node-list-empty? (node-list-rest nl))
		  (literal %biblend%)
		  (if (equal? (gi (node-list-first nl)) "ABBREV")
		      (literal " ")
		      (literal %biblsep%)))
	      (loop (node-list-rest nl))))))))

(element (BIBLIOENTRY ABBREV) 
  (make sequence
    (literal "[")
    (process-children)
    (literal "]")))

(element (BIBLIOENTRY COPYRIGHT)
  ($bibl-node-list$ (select-elements (children (current-node)) 
				     "YEAR")))

(element (BIBLIOSET COPYRIGHT)
  ($bibl-node-list$ (select-elements (children (current-node)) 
				     "YEAR")))

(mode bibl-year-mode
  (element YEAR
    (process-children)))

(element (BIBLIOENTRY ISBN) 
  (make sequence
    (literal "ISBN: ")
    (process-children)))

(element (BIBLIOENTRY ISSN) 
  (make sequence
    (literal "ISSN: ")
    (process-children)))

(element (BIBLIOSET ISBN) 
  (make sequence
    (literal "ISBN: ")
    (process-children)))

(element (BIBLIOSET ISSN) 
  (make sequence
    (literal "ISSN: ")
    (process-children)))

(element (BIBLIOSET PAGENUMS) 
  (make sequence
    (literal %gentext-bibl-pages% " ")
    (process-children)))

(define ($bibl-node-list$ nodes)
  (let loop ((nl nodes) (count 1))
    (if (node-list-empty? nl)
	(empty-sosofo)
	(if (> count 1)
	    (make sequence
	      (literal ", ")
	      (with-mode bibl-year-mode
		(process-node-list (node-list-first nl)))
	      (loop (node-list-rest nl) (+ count 1)))
	    (make sequence
	      (with-mode bibl-year-mode
		(process-node-list (node-list-first nl)))
	      (loop (node-list-rest nl) (+ count 1)))))))

(element (BIBLIOENTRY PUBLISHER)
  ($bibl-node-list$ (select-elements (children (current-node)) 
				     "PUBLISHERNAME")))

(element (BIBLIOSET PUBLISHER)
  ($bibl-node-list$ (select-elements (children (current-node)) 
				     "PUBLISHERNAME")))

(element (BIBLIOENTRY TITLE) 
  (make score
    type: 'after
    (process-children)))

(element (BIBLIOMIXED TITLE) 
  (make score
    type: 'after
    (process-children)))

(element (BIBLIOSET TITLE)
  (case (case-fold-up (inherited-attribute-string "RELATION"))
    (("ARTICLE") (make sequence
		   (literal %gentext-start-quote%)
		   (process-children)
		   (literal %gentext-end-quote%)))
    (else        (make score
		   type: 'after
		   (process-children)))))

(element (BIBLIOMSET TITLE)
  (case (case-fold-up (inherited-attribute-string "RELATION"))
    (("ARTICLE") (make sequence
		   (literal %gentext-start-quote%)
		   (process-children)
		   (literal %gentext-end-quote%)))
    (else        (make score
		   type: 'after
		   (process-children)))))

(element BIBLIOMISC (process-children))
(element BIBLIOMIXED 
  (make paragraph
    space-before: %para-sep%
    space-after: %para-sep%
    start-indent: (+ (inherited-start-indent) 2pi)
    first-line-start-indent: -2pi
    (process-children)))

(element BIBLIOMSET (process-children))
(element BIBLIOSET (process-children))
(element BOOKBIBLIO (process-children))

(element ACKNO ($charseq$))
(element STREET ($charseq$))
(element POB ($charseq$))
(element POSTCODE ($charseq$))
(element CITY ($charseq$))
(element STATE ($charseq$))
(element COUNTRY ($charseq$))
(element PHONE ($charseq$))
(element FAX ($charseq$))
(element OTHERADDR ($charseq$))
(element AFFILIATION ($charseq$))
(element SHORTAFFIL ($charseq$))
(element JOBTITLE ($charseq$))
(element ORGDIV ($charseq$))
(element ARTPAGENUMS ($charseq$))

(element AUTHOR
  (make sequence
    (literal (author-list-string))))

(element AUTHORGROUP (process-children))

(element COLLAB (process-children))
(element COLLABNAME ($charseq$))
(element AUTHORINITIALS ($charseq$))
(element CONFGROUP (process-children))
(element CONFDATES ($charseq$))
(element CONFTITLE ($charseq$))
(element CONFNUM ($charseq$))
(element CONFSPONSOR ($charseq$))
(element CONTRACTNUM ($charseq$))
(element CONTRACTSPONSOR ($charseq$))

(element COPYRIGHT
  (make paragraph
    use: para-style
    (make sequence
      (literal (gentext-element-name (gi (current-node))))
      (literal " ")
      (literal (dingbat "copyright"))
      (literal " ")
      (process-children-trim))))

(element YEAR
  (make sequence
    (process-children)
    (if (not (last-sibling? (current-node)))
	(literal ", ")
	(literal (string-append " " %gentext-by% " ")))))

(element HOLDER ($charseq$))

(element CORPAUTHOR
  (make sequence
    (literal (author-list-string))))

(element CORPNAME ($charseq$))
(element DATE ($charseq$))
(element EDITION ($charseq$))
(element EDITOR ($charseq$))
(element ISBN ($charseq$))
(element ISSN ($charseq$))
(element INVPARTNUMBER ($charseq$))
(element ISSUENUM ($charseq$))

(element LEGALNOTICE ($semiformal-object$))

(element MODESPEC (empty-sosofo))

(element ORGNAME ($charseq$))

(element OTHERCREDIT
  (make sequence
    (literal (author-list-string))))

(element PAGENUMS ($charseq$))
(element CONTRIB ($charseq$))

(element FIRSTNAME ($charseq$))
(element HONORIFIC ($charseq$))
(element LINEAGE ($charseq$))
(element OTHERNAME ($charseq$))
(element SURNAME ($charseq$))

(element PRINTHISTORY (empty-sosofo))
(element PRODUCTNAME ($charseq$))
(element PRODUCTNUMBER ($charseq$))
(element PUBDATE ($charseq$))
(element PUBLISHER (process-children))
(element PUBLISHERNAME ($charseq$))
(element PUBSNUMBER ($charseq$))
(element RELEASEINFO (empty-sosofo))
(element REVISION ($charseq$))
(element REVNUMBER ($charseq$))
(element REVREMARK ($charseq$))
(element SERIESVOLNUMS ($charseq$))
(element VOLUMENUM ($charseq$))

;; The (element (BOOKINFO REVHISTORY)) construction rule is in dbinfo.dsl
;; It calls $book-revhistory$...
(define ($book-revhistory$)
  (make sequence
    (make paragraph
      use: title-style
      font-family-name: %title-font-family%
      font-weight: 'bold
      space-before: (* (HSIZE 3) %head-before-factor%)
      space-after: (* (HSIZE 1) %head-before-factor%)
      (literal (gentext-element-name (gi (current-node)))))
    (make table
      before-row-border: #f
      (process-children))))

(element (REVHISTORY REVISION)
  (let ((revnumber (select-elements (descendants (current-node)) "REVNUMBER"))
	(revdate   (select-elements (descendants (current-node)) "DATE"))
	(revauthor (select-elements (descendants (current-node)) "AUTHORINITIALS"))
	(revremark (select-elements (descendants (current-node)) "REVREMARK")))
    (make sequence
      (make table-row
	(make table-cell
	  column-number: 1
	  n-columns-spanned: 1
	  n-rows-spanned: 1
	  (if (not (node-list-empty? revnumber))
	      (make paragraph
		(make sequence
		  (literal (gentext-element-name-space (gi (current-node))))
		  (process-node-list revnumber)))
	      (empty-sosofo)))
	(make table-cell
	  column-number: 2
	  n-columns-spanned: 1
	  n-rows-spanned: 1
	  (if (not (node-list-empty? revdate))
	      (make paragraph
		(process-node-list revdate))
	      (empty-sosofo)))
	(make table-cell
	  column-number: 3
	  n-columns-spanned: 1
	  n-rows-spanned: 1
	  (if (not (node-list-empty? revauthor))
	      (make paragraph
		(make sequence
		  (literal "Revised by: ")
		  (process-node-list revauthor)))
	      (empty-sosofo))))
      (make table-row
	cell-after-row-border: #f
	(make table-cell
	  column-number: 1
	  n-columns-spanned: 3
	  n-rows-spanned: 1
	  (if (not (node-list-empty? revremark))
	      (make paragraph
		space-after: %block-sep%
		(process-node-list revremark))
	      (empty-sosofo)))))))

(element (REVISION REVNUMBER) (process-children-trim))
(element (REVISION DATE) (process-children-trim))
(element (REVISION AUTHORINITIALS) (process-children-trim))
(element (REVISION REVREMARK) (process-children-trim))
