;; $Id: dbl1da.dsl,v 1.1.1.1 1999/01/28 15:21:15 rosalia Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://nwalsh.com/docbook/dsssl/
;;

;; ----------------------------- Localization -----------------------------

;; If you create a new version of this file, please send it to
;; Norman Walsh, ndw@nwalsh.com

;; The generated text for cross references to elements.  See dblink.dsl
;; for a discussion of how substitution is performed on the %x 
;; keywords.
;;

(define (da-appendix-xref-string gi-or-name)
  (if %chapter-autolabel%
      "&Appendix; %n"
      "&appendix; med navn %t"))

(define (da-article-xref-string gi-or-name)
  (string-append %gentext-da-start-quote%
		 "%t"
		 %gentext-da-end-quote%))

(define (da-bibliography-xref-string gi-or-name)
  "%t")

(define (da-book-xref-string gi-or-name)
  "%t")

(define (da-chapter-xref-string gi-or-name)
  (if %chapter-autolabel%
      "&Chapter; %n"
      "kapitlet om %t"))

(define (da-equation-xref-string gi-or-name)
  "&Equation; %n")

(define (da-example-xref-string gi-or-name)
  "&Example; %n")

(define (da-figure-xref-string gi-or-name)
  "&Figure; %n")

(define (da-listitem-xref-string gi-or-name)
  "%n")

(define (da-part-xref-string gi-or-name)
  "&Part; %n")

(define (da-preface-xref-string gi-or-name)
  "%t")

(define (da-procedure-xref-string gi-or-name)
  "&Procedure; %n, %t")

(define (da-sect1-xref-string gi-or-name)
  (if %section-autolabel% 
      "&Section; %n" 
      "sektionen med navn %t"))

(define (da-sect2-xref-string gi-or-name)
  (if %section-autolabel% 
      "&Section; %n" 
      "undersektionen med navn %t"))

(define (da-sect3-xref-string gi-or-name)
  (da-sect2-xref-string gi-or-name))

(define (da-sect4-xref-string gi-or-name)
  (da-sect2-xref-string gi-or-name))

(define (da-sect5-xref-string gi-or-name)
  (da-sect2-xref-string gi-or-name))

(define (da-step-xref-string gi-or-name)
  "&step; %n")

(define (da-table-xref-string gi-or-name)
  "&Table; %n")

(define (da-default-xref-string gi-or-name)
  (let* ((giname (if (string? gi-or-name) gi-or-name (gi gi-or-name)))
	 (msg    (string-append "[&xrefto; "
				(if giname giname "&nonexistantelement;")
				" &unsupported;]"))
	 (err    (node-list-error msg (current-node))))
    msg))

(define (gentext-da-xref-strings gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
      ((equal? name (normalize "appendix")) (da-appendix-xref-string gind))
      ((equal? name (normalize "article"))  (da-article-xref-string gind))
      ((equal? name (normalize "bibliography")) (da-bibliography-xref-string gind))
      ((equal? name (normalize "book"))     (da-book-xref-string gind))
      ((equal? name (normalize "chapter"))  (da-chapter-xref-string gind))
      ((equal? name (normalize "equation")) (da-equation-xref-string gind))
      ((equal? name (normalize "example"))  (da-example-xref-string gind))
      ((equal? name (normalize "figure"))   (da-figure-xref-string gind))
      ((equal? name (normalize "listitem")) (da-listitem-xref-string gind))
      ((equal? name (normalize "part"))     (da-part-xref-string gind))
      ((equal? name (normalize "preface"))  (da-preface-xref-string gind))
      ((equal? name (normalize "procedure")) (da-procedure-xref-string gind))
      ((equal? name (normalize "sect1"))    (da-sect1-xref-string gind))
      ((equal? name (normalize "sect2"))    (da-sect2-xref-string gind))
      ((equal? name (normalize "sect3"))    (da-sect3-xref-string gind))
      ((equal? name (normalize "sect4"))    (da-sect4-xref-string gind))
      ((equal? name (normalize "sect5"))    (da-sect5-xref-string gind))
      ((equal? name (normalize "step"))     (da-step-xref-string gind))
      ((equal? name (normalize "table"))    (da-table-xref-string gind))
      (else (da-default-xref-string gind)))))

(define (da-auto-xref-indirect-connector before) 
  (literal " med navn "))

;; Should the TOC come first or last?
;;
(define %generate-da-toc-in-front% #t)

;; gentext-element-name returns the generated text that should be 
;; used to make reference to the selected element.
;;
(define da-abstract-name	"&Abstract;")
(define da-appendix-name	"&Appendix;")
(define da-article-name	"&Article;")
(define da-bibliography-name	"&Bibliography;")
(define da-book-name		"&Book;")
(define da-calloutlist-name	"")
(define da-caution-name	"&Caution;")
(define da-chapter-name	"&Chapter;")
(define da-copyright-name	"&Copyright;")
(define da-dedication-name	"&Dedication;")
(define da-edition-name	"&Edition;")
(define da-equation-name	"&Equation;")
(define da-example-name	"&Example;")
(define da-figure-name	"&Figure;")
(define da-glossary-name	"&Glossary;")
(define da-glosssee-name	"&GlossSee;")
(define da-glossseealso-name	"&GlossSeeAlso;")
(define da-important-name	"&Important;")
(define da-index-name		"&Index;")
(define da-setindex-name	"&SetIndex;")
(define da-isbn-name		"&ISBN;")
(define da-legalnotice-name	"&LegalNotice;")
(define da-msgaud-name	"&MsgAud;")
(define da-msglevel-name	"&MsgLevel;")
(define da-msgorig-name	"&MsgOrig;")
(define da-note-name		"&Note;")
(define da-part-name		"&Part;")
(define da-preface-name	"&Preface;")
(define da-procedure-name	"&Procedure;")
(define da-pubdate-name	"&Published;")
(define da-reference-name	"&Reference;")
(define da-refname-name	"&RefName;")
(define da-revhistory-name	"&RevHistory;")
(define da-revision-name	"&Revision;")
(define da-sect1-name		"&Section;")
(define da-sect2-name		"&Section;")
(define da-sect3-name		"&Section;")
(define da-sect4-name		"&Section;")
(define da-sect5-name		"&Section;")
(define da-simplesect-name	"&Section;")
(define da-seeie-name		"&See;")
(define da-seealsoie-name	"&Seealso;")
(define da-set-name		"&Set;")
(define da-sidebar-name	"&Sidebar;")
(define da-step-name		"&step;")
(define da-table-name		"&Table;")
(define da-tip-name		"&Tip;")
(define da-toc-name		"&TableofContents;")
(define da-warning-name	"&Warning;")

(define (gentext-da-element-name gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "abstract"))	da-abstract-name)
     ((equal? name (normalize "appendix"))	da-appendix-name)
     ((equal? name (normalize "article"))	da-article-name)
     ((equal? name (normalize "bibliography"))	da-bibliography-name)
     ((equal? name (normalize "book"))		da-book-name)
     ((equal? name (normalize "calloutlist"))	da-calloutlist-name)
     ((equal? name (normalize "caution"))	da-caution-name)
     ((equal? name (normalize "chapter"))	da-chapter-name)
     ((equal? name (normalize "copyright"))	da-copyright-name)
     ((equal? name (normalize "dedication"))	da-dedication-name)
     ((equal? name (normalize "edition"))	da-edition-name)
     ((equal? name (normalize "equation"))	da-equation-name)
     ((equal? name (normalize "example"))	da-example-name)
     ((equal? name (normalize "figure"))	da-figure-name)
     ((equal? name (normalize "glossary"))	da-glossary-name)
     ((equal? name (normalize "glosssee"))	da-glosssee-name)
     ((equal? name (normalize "glossseealso"))	da-glossseealso-name)
     ((equal? name (normalize "important"))	da-important-name)
     ((equal? name (normalize "index"))		da-index-name)
     ((equal? name (normalize "setindex"))	da-setindex-name)
     ((equal? name (normalize "isbn"))		da-isbn-name)
     ((equal? name (normalize "legalnotice"))	da-legalnotice-name)
     ((equal? name (normalize "msgaud"))	da-msgaud-name)
     ((equal? name (normalize "msglevel"))	da-msglevel-name)
     ((equal? name (normalize "msgorig"))	da-msgorig-name)
     ((equal? name (normalize "note"))		da-note-name)
     ((equal? name (normalize "part"))		da-part-name)
     ((equal? name (normalize "preface"))	da-preface-name)
     ((equal? name (normalize "procedure"))	da-procedure-name)
     ((equal? name (normalize "pubdate"))	da-pubdate-name)
     ((equal? name (normalize "reference"))	da-reference-name)
     ((equal? name (normalize "refname"))	da-refname-name)
     ((equal? name (normalize "revhistory"))	da-revhistory-name)
     ((equal? name (normalize "revision"))	da-revision-name)
     ((equal? name (normalize "sect1"))		da-sect1-name)
     ((equal? name (normalize "sect2"))		da-sect2-name)
     ((equal? name (normalize "sect3"))		da-sect3-name)
     ((equal? name (normalize "sect4"))		da-sect4-name)
     ((equal? name (normalize "sect5"))		da-sect5-name)
     ((equal? name (normalize "simplesect"))    da-simplesect-name)
     ((equal? name (normalize "seeie"))		da-seeie-name)
     ((equal? name (normalize "seealsoie"))	da-seealsoie-name)
     ((equal? name (normalize "set"))		da-set-name)
     ((equal? name (normalize "sidebar"))	da-sidebar-name)
     ((equal? name (normalize "step"))		da-step-name)
     ((equal? name (normalize "table"))		da-table-name)
     ((equal? name (normalize "tip"))		da-tip-name)
     ((equal? name (normalize "toc"))		da-toc-name)
     ((equal? name (normalize "warning"))	da-warning-name)
     (else (let* ((msg (string-append "&unexpectedelementname;: " name))
		  (err (node-list-error msg (current-node))))
	     msg)))))

;; gentext-element-name-space returns gentext-element-name with a 
;; trailing space, if gentext-element-name isn't "".
;;
(define (gentext-da-element-name-space giname)
  (string-with-space (gentext-element-name giname)))

;; gentext-intra-label-sep returns the seperator to be inserted
;; between multiple occurances of a label (or parts of a label)
;; for the specified element.  Most of these are for enumerated
;; labels like "Figure 2-4", but this function is used elsewhere
;; (e.g. REFNAME) with a little abuse.
;;

(define da-equation-intra-label-sep "-")
(define da-example-intra-label-sep "-")
(define da-figure-intra-label-sep "-")
(define da-procedure-intra-label-sep ".")
(define da-refentry-intra-label-sep ".")
(define da-reference-intra-label-sep ".")
(define da-refname-intra-label-sep ", ")
(define da-refsect1-intra-label-sep ".")
(define da-refsect2-intra-label-sep ".")
(define da-refsect3-intra-label-sep ".")
(define da-sect1-intra-label-sep ".")
(define da-sect2-intra-label-sep ".")
(define da-sect3-intra-label-sep ".")
(define da-sect4-intra-label-sep ".")
(define da-sect5-intra-label-sep ".")
(define da-step-intra-label-sep ".")
(define da-table-intra-label-sep "-")
(define da-_pagenumber-intra-label-sep "-")
(define da-default-intra-label-sep "")

(define (gentext-da-intra-label-sep gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "equation"))	da-equation-intra-label-sep)
     ((equal? name (normalize "example"))	da-example-intra-label-sep)
     ((equal? name (normalize "figure"))	da-figure-intra-label-sep)
     ((equal? name (normalize "procedure"))	da-procedure-intra-label-sep)
     ((equal? name (normalize "refentry"))	da-refentry-intra-label-sep)
     ((equal? name (normalize "reference"))	da-reference-intra-label-sep)
     ((equal? name (normalize "refname"))	da-refname-intra-label-sep)
     ((equal? name (normalize "refsect1"))	da-refsect1-intra-label-sep)
     ((equal? name (normalize "refsect2"))	da-refsect2-intra-label-sep)
     ((equal? name (normalize "refsect3"))	da-refsect3-intra-label-sep)
     ((equal? name (normalize "sect1"))		da-sect1-intra-label-sep)
     ((equal? name (normalize "sect2"))		da-sect2-intra-label-sep)
     ((equal? name (normalize "sect3"))		da-sect3-intra-label-sep)
     ((equal? name (normalize "sect4"))		da-sect4-intra-label-sep)
     ((equal? name (normalize "sect5"))		da-sect5-intra-label-sep)
     ((equal? name (normalize "step"))		da-step-intra-label-sep)
     ((equal? name (normalize "table"))		da-table-intra-label-sep)
     ((equal? name (normalize "_pagenumber"))	da-_pagenumber-intra-label-sep)
     (else da-default-intra-label-sep))))

;; gentext-label-title-sep returns the seperator to be inserted
;; between a label and the text following the label for the
;; specified element.  Most of these are for use between
;; enumerated labels and titles like "1. Chapter One Title", but
;; this function is used elsewhere (e.g. NOTE) with a little
;; abuse.
;;

(define da-abstract-label-title-sep ": ")
(define da-appendix-label-title-sep ". ")
(define da-caution-label-title-sep "")
(define da-chapter-label-title-sep ". ")
(define da-equation-label-title-sep ". ")
(define da-example-label-title-sep ". ")
(define da-figure-label-title-sep ". ")
(define da-footnote-label-title-sep ". ")
(define da-glosssee-label-title-sep ": ")
(define da-glossseealso-label-title-sep ": ")
(define da-important-label-title-sep ": ")
(define da-note-label-title-sep ": ")
(define da-orderedlist-label-title-sep ". ")
(define da-part-label-title-sep ". ")
(define da-procedure-label-title-sep ". ")
(define da-prefix-label-title-sep ". ")
(define da-refentry-label-title-sep "")
(define da-reference-label-title-sep ". ")
(define da-refsect1-label-title-sep ". ")
(define da-refsect2-label-title-sep ". ")
(define da-refsect3-label-title-sep ". ")
(define da-sect1-label-title-sep ". ")
(define da-sect2-label-title-sep ". ")
(define da-sect3-label-title-sep ". ")
(define da-sect4-label-title-sep ". ")
(define da-sect5-label-title-sep ". ")
(define da-seeie-label-title-sep " ")
(define da-seealsoie-label-title-sep " ")
(define da-step-label-title-sep ". ")
(define da-table-label-title-sep ". ")
(define da-tip-label-title-sep ": ")
(define da-warning-label-title-sep "")
(define da-default-label-title-sep "")

(define (gentext-da-label-title-sep gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "abstract")) da-abstract-label-title-sep)
     ((equal? name (normalize "appendix")) da-appendix-label-title-sep)
     ((equal? name (normalize "caution")) da-caution-label-title-sep)
     ((equal? name (normalize "chapter")) da-chapter-label-title-sep)
     ((equal? name (normalize "equation")) da-equation-label-title-sep)
     ((equal? name (normalize "example")) da-example-label-title-sep)
     ((equal? name (normalize "figure")) da-figure-label-title-sep)
     ((equal? name (normalize "footnote")) da-footnote-label-title-sep)
     ((equal? name (normalize "glosssee")) da-glosssee-label-title-sep)
     ((equal? name (normalize "glossseealso")) da-glossseealso-label-title-sep)
     ((equal? name (normalize "important")) da-important-label-title-sep)
     ((equal? name (normalize "note")) da-note-label-title-sep)
     ((equal? name (normalize "orderedlist")) da-orderedlist-label-title-sep)
     ((equal? name (normalize "part")) da-part-label-title-sep)
     ((equal? name (normalize "procedure")) da-procedure-label-title-sep)
     ((equal? name (normalize "prefix")) da-prefix-label-title-sep)
     ((equal? name (normalize "refentry")) da-refentry-label-title-sep)
     ((equal? name (normalize "reference")) da-reference-label-title-sep)
     ((equal? name (normalize "refsect1")) da-refsect1-label-title-sep)
     ((equal? name (normalize "refsect2")) da-refsect2-label-title-sep)
     ((equal? name (normalize "refsect3")) da-refsect3-label-title-sep)
     ((equal? name (normalize "sect1")) da-sect1-label-title-sep)
     ((equal? name (normalize "sect2")) da-sect2-label-title-sep)
     ((equal? name (normalize "sect3")) da-sect3-label-title-sep)
     ((equal? name (normalize "sect4")) da-sect4-label-title-sep)
     ((equal? name (normalize "sect5")) da-sect5-label-title-sep)
     ((equal? name (normalize "seeie")) da-seeie-label-title-sep)
     ((equal? name (normalize "seealsoie")) da-seealsoie-label-title-sep)
     ((equal? name (normalize "step")) da-step-label-title-sep)
     ((equal? name (normalize "table")) da-table-label-title-sep)
     ((equal? name (normalize "tip")) da-tip-label-title-sep)
     ((equal? name (normalize "warning")) da-warning-label-title-sep)
     (else da-default-label-title-sep))))

(define (da-set-label-number-format gind) "1")
(define (da-book-label-number-format gind) "1")
(define (da-prefix-label-number-format gind) "1")
(define (da-part-label-number-format gind) "I")
(define (da-chapter-label-number-format gind) "1")
(define (da-appendix-label-number-format gind) "A")
(define (da-reference-label-number-format gind) "I")
(define (da-example-label-number-format gind) "1")
(define (da-figure-label-number-format gind) "1")
(define (da-table-label-number-format gind) "1")
(define (da-procedure-label-number-format gind) "1")
(define (da-step-label-number-format gind) "1")
(define (da-refsect1-label-number-format gind) "1")
(define (da-refsect2-label-number-format gind) "1")
(define (da-refsect3-label-number-format gind) "1")
(define (da-sect1-label-number-format gind) "1")
(define (da-sect2-label-number-format gind) "1")
(define (da-sect3-label-number-format gind) "1")
(define (da-sect4-label-number-format gind) "1")
(define (da-sect5-label-number-format gind) "1")
(define (da-default-label-number-format gind) "1")

(define (da-label-number-format gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "set")) (da-set-label-number-format gind))
     ((equal? name (normalize "book")) (da-book-label-number-format gind))
     ((equal? name (normalize "prefix")) (da-prefix-label-number-format gind))
     ((equal? name (normalize "part")) (da-part-label-number-format gind))
     ((equal? name (normalize "chapter")) (da-chapter-label-number-format gind))
     ((equal? name (normalize "appendix")) (da-appendix-label-number-format gind))
     ((equal? name (normalize "reference")) (da-reference-label-number-format gind))
     ((equal? name (normalize "example")) (da-example-label-number-format gind))
     ((equal? name (normalize "figure")) (da-figure-label-number-format gind))
     ((equal? name (normalize "table")) (da-table-label-number-format gind))
     ((equal? name (normalize "procedure")) (da-procedure-label-number-format gind))
     ((equal? name (normalize "step")) (da-step-label-number-format gind))
     ((equal? name (normalize "refsect1")) (da-refsect1-label-number-format gind))
     ((equal? name (normalize "refsect2")) (da-refsect2-label-number-format gind))
     ((equal? name (normalize "refsect3")) (da-refsect3-label-number-format gind))
     ((equal? name (normalize "sect1")) (da-sect1-label-number-format gind))
     ((equal? name (normalize "sect2")) (da-sect2-label-number-format gind))
     ((equal? name (normalize "sect3")) (da-sect3-label-number-format gind))
     ((equal? name (normalize "sect4")) (da-sect4-label-number-format gind))
     ((equal? name (normalize "sect5")) (da-sect5-label-number-format gind))
     (else (da-default-label-number-format gind)))))

(define ($lot-title-da$ gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond ((equal? name (normalize "table"))    "&ListofTables;")
	  ((equal? name (normalize "example"))  "&ListofExamples;")
	  ((equal? name (normalize "figure"))   "&ListofFigures;")
	  ((equal? name (normalize "equation")) "&ListofEquations;")
	  (else (let* ((msg (string-append "&ListofUnknown;: " name))
		       (err (node-list-error msg (current-node))))
		  msg)))))

(define %gentext-da-start-quote% (dingbat "ldquo"))

(define %gentext-da-end-quote% (dingbat "rdquo"))

(define %gentext-da-by% "&by;") ;; e.g. Copyright 1997 "by" A. Nonymous
                           ;; Authored "by" Jane Doe

(define %gentext-da-edited-by% "&Editedby;")
                           ;; "Edited by" Jane Doe

(define %gentext-da-page% "")

(define %gentext-da-and% "&and;")

(define %gentext-da-bibl-pages% "&Pgs;")

(define %gentext-da-endnotes% "&Notes;")

(define %gentext-da-table-endnotes% "&TableNotes;:")

(define %gentext-da-index-see% "&See;")

(define %gentext-da-index-seealso% "&SeeAlso;")

