//===========================================================================
//
// MLT linker script for MIPS32
//
//===========================================================================
//####COPYRIGHTBEGIN####
//                                                                          
// -------------------------------------------                              
// The contents of this file are subject to the Red Hat eCos Public License 
// Version 1.1 (the "License"); you may not use this file except in         
// compliance with the License.  You may obtain a copy of the License at    
// http://www.redhat.com/                                                   
//                                                                          
// Software distributed under the License is distributed on an "AS IS"      
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the 
// License for the specific language governing rights and limitations under 
// the License.                                                             
//                                                                          
// The Original Code is eCos - Embedded Configurable Operating System,      
// released September 30, 1998.                                             
//                                                                          
// The Initial Developer of the Original Code is Red Hat.                   
// Portions created by Red Hat are                                          
// Copyright (C) 1998, 1999, 2000 Red Hat, Inc.                             
// All Rights Reserved.                                                     
// -------------------------------------------                              
//                                                                          
//####COPYRIGHTEND####
//===========================================================================

#include <pkgconf/system.h>

OUTPUT_FORMAT("elf32-bigmips", "elf32-bigmips",
              "elf32-littlemips")
/* The preprocessor defines mips, but we know we're mips :-) */
#undef mips
OUTPUT_ARCH(mips:isa32)

STARTUP(vectors.o)
ENTRY(reset_vector)
#ifdef EXTRAS
INPUT(extras.o)
#endif
GROUP(libtarget.a libgcc.a)

/* FIXME: The MLT should pass in the required alignment since it must be
 * the same as the VMA's alignment. As a result of this bug, all the MIPS32
 * ROM mlt files have alignment 8, when some should have alignment 4
 * (902557-CR)
 */
#define ALIGN_LMA 0x40
#define FOLLOWING(_section_) AT ((LOADADDR (_section_) + SIZEOF (_section_) + ALIGN_LMA - 1) & ~ (ALIGN_LMA - 1))
#define LMA_EQ_VMA
#define FORCE_OUTPUT . = .

#define SECTIONS_BEGIN

#if defined(CYG_HAL_STARTUP_RAM)

/* this version for RAM startup */
#define SECTION_rom_vectors(_region_, _vma_, _lma_) \
    .rom_vectors _vma_ : _lma_ \
    { KEEP (*(.utlb_vector)) \
    . = ALIGN(0x80); KEEP(*(.other_vector)) \
        /* debug and reset vector not used in RAM version */ \
        KEEP(*(.debug_vector)) \
        KEEP (*(.reset_vector)) } \
    > _region_

#elif defined(CYG_HAL_STARTUP_ROM)

/* this version for ROM startup */
#define SECTION_rom_vectors(_region_, _vma_, _lma_) \
    .rom_vectors _vma_ : _lma_ \
    { KEEP (*(.reset_vector)) \
    . = ALIGN(0x200); KEEP (*(.utlb_vector)) \
    . = . + 0x100; \
    . = ALIGN(0x80); KEEP(*(.other_vector)) \
    . = . + 0x80; \
    . = ALIGN(0x80); KEEP(*(.debug_vector)) } \
    > _region_

#endif /* ROM startup version of ROM vectors */

#define SECTION_ROMISC(_region_, _vma_, _lma_)                                 \
  .interp _vma_  : _lma_ { *(.interp)                            } > _region_  \
  .hash          : FOLLOWING(.interp)        { *(.hash)          } > _region_  \
  .dynsym        : FOLLOWING(.hash)          { *(.dynsym)        } > _region_  \
  .dynstr        : FOLLOWING(.dynsym)        { *(.dynstr)        } > _region_  \
  .gnu.version   : FOLLOWING(.dynstr)        { *(.gnu.version)   } > _region_  \
  .gnu.version_d : FOLLOWING(.gnu.version)   { *(.gnu.version_d) } > _region_  \
  .gnu.version_r : FOLLOWING(.gnu.version_d) { *(.gnu.version_r) } > _region_  \
  .plt           : FOLLOWING(.gnu.version_r) { *(.plt)           } > _region_

#define SECTION_RELOCS(_region_, _vma_, _lma_)                              \
  .rel.text      :                                                          \
    {                                                                       \
      *(.rel.text)                                                          \
      *(.rel.text.*)                                                        \
      *(.rel.gnu.linkonce.t*)                                               \
    } > _region_                                                            \
  .rela.text     :                                                          \
    {                                                                       \
      *(.rela.text)                                                         \
      *(.rela.text.*)                                                       \
      *(.rela.gnu.linkonce.t*)                                              \
    } > _region_                                                            \
  .rel.data      :                                                          \
    {                                                                       \
      *(.rel.data)                                                          \
      *(.rel.data.*)                                                        \
      *(.rel.gnu.linkonce.d*)                                               \
    } > _region_                                                            \
  .rela.data     :                                                          \
    {                                                                       \
      *(.rela.data)                                                         \
      *(.rela.data.*)                                                       \
      *(.rela.gnu.linkonce.d*)                                              \
    } > _region_                                                            \
  .rel.rodata    :                                                          \
    {                                                                       \
      *(.rel.rodata)                                                        \
      *(.rel.rodata.*)                                                      \
      *(.rel.gnu.linkonce.r*)                                               \
    } > _region_                                                            \
  .rela.rodata   :                                                          \
    {                                                                       \
      *(.rela.rodata)                                                       \
      *(.rela.rodata.*)                                                     \
      *(.rela.gnu.linkonce.r*)                                              \
    } > _region_                                                            \
  .rel.got       :   { *(.rel.got)    } > _region_                          \
  .rela.got      :   { *(.rela.got)   } > _region_                          \
  .rel.ctors     :   { *(.rel.ctors)  } > _region_                          \
  .rela.ctors    :   { *(.rela.ctors) } > _region_                          \
  .rel.dtors     :   { *(.rel.dtors)  } > _region_                          \
  .rela.dtors    :   { *(.rela.dtors) } > _region_                          \
  .rel.init      :   { *(.rel.init)   } > _region_                          \
  .rela.init     :   { *(.rela.init)  } > _region_                          \
  .rel.fini      :   { *(.rel.fini)   } > _region_                          \
  .rela.fini     :   { *(.rela.fini)  } > _region_                          \
  .rel.bss       :   { *(.rel.bss)    } > _region_                          \
  .rela.bss      :   { *(.rela.bss)   } > _region_                          \
  .rel.plt       :   { *(.rel.plt)    } > _region_                          \
  .rela.plt      :   { *(.rela.plt)   } > _region_                          \
  .rel.dyn       :   { *(.rel.dyn)    } > _region_

#define SECTION_init(_region_, _vma_, _lma_)   \
  .init _vma_ : _lma_                          \
    {                                          \
      FORCE_OUTPUT; KEEP (*(.init))            \
    } > _region_ =0

#define SECTION_text(_region_, _vma_, _lma_)   \
  .text _vma_ : _lma_                          \
    {                                          \
      _stext = .; _ftext = . ;                 \
      *(.text)                                 \
      *(.text.*)                               \
      *(.stub)                                 \
      *(.gnu.warning)                          \
      *(.gnu.linkonce.t*)                      \
      *(.mips16.fn.*) *(.mips16.call.*)        \
    } > _region_ =0                            \
  _etext = .; PROVIDE (etext = .);

#define SECTION_fini(_region_, _vma_, _lma_)   \
  .fini _vma_ : _lma_                          \
    {                                          \
      FORCE_OUTPUT; KEEP (*(.fini))                   \
    } > _region_ =0

#define SECTION_rodata(_region_, _vma_, _lma_)        \
  .rodata _vma_ : _lma_                               \
    {                                                 \
      FORCE_OUTPUT; *(.rodata) *(.rodata.*) *(.gnu.linkonce.r*)    \
    } > _region_

#define SECTION_rodata1(_region_, _vma_, _lma_)       \
  .rodata1 _vma_ : _lma_                              \
    {                                                 \
     FORCE_OUTPUT; *(.rodata1) *(.rodata1.*)          \
    } > _region_

#define SECTION_vsr_table(_region_, _vma_, _lma_)     \
  .vsr_table _vma_ : _lma_                            \
    {                                                 \
      FORCE_OUTPUT; *(.vsr_table)                     \
    } > _region_

#define SECTION_data(_region_, _vma_, _lma_)          \
  .data _vma_ : _lma_                                 \
    {                                                 \
      __ram_data_start = ABSOLUTE (.); _fdata = . ;   \
      *(.data) *(.data.*) *(.gnu.linkonce.d*)         \
      *( .2ram.*)                                     \
    . = ALIGN (8);                                    \
    SORT(CONSTRUCTORS)                                \
    } > _region_                                      \
    __rom_data_start = LOADADDR(.data);

#define SECTION_data1(_region_, _vma_, _lma_)         \
  .data1 _vma_ : _lma_                                \
    {                                                 \
       FORCE_OUTPUT; *(.data1) *(.data1.*)            \
    } > _region_

#define SECTION_eh_frame(_region_, _vma_, _lma_)      \
  .eh_frame _vma_ : _lma_                             \
    {                                                 \
       FORCE_OUTPUT; *(.eh_frame)                     \
    } > _region_

#define SECTION_gcc_except_table(_region_, _vma_, _lma_) \
  .gcc_except_table _vma_ : _lma_                        \
    {                                                    \
      FORCE_OUTPUT; *(.gcc_except_table)                 \
    } > _region_


    /* gcc uses crtbegin.o to find the start of
       the constructors, so we make sure it is
       first.  Because this is a wildcard, it
       doesn't matter if the user does not
       actually link against crtbegin.o; the
       linker won't look for a file to match a
       wildcard.  The wildcard also means that it
       doesn't matter which directory crtbegin.o
       is in.  */

    /* We don't want to include the .ctors section from
       the crtend.o file until after the sorted ctors.
       The .ctor section from the crtend file contains the
       end of ctors marker and it must be last */

/* FIXME: We shouldn't need to define __CTOR_LIST__/__CTOR_END__
   and __DTOR_LIST__/__DTOR_END__ except by the PROVIDE lines.
   However this doesn't work for old (99r1-era) toolchains, so
   leave it for now. */

#define SECTION_ctors(_region_, _vma_, _lma_)     \
  .ctors _vma_ : _lma_                            \
    {                                             \
      FORCE_OUTPUT;                               \
      KEEP (*crtbegin.o(.ctors))                  \
      __CTOR_LIST__ = .;                \
      PROVIDE (__CTOR_LIST__ = .);                \
      KEEP (*(EXCLUDE_FILE (*crtend.o) .ctors))   \
      KEEP (*(SORT(.ctors.*)))                    \
      KEEP (*(.ctors))                            \
      __CTOR_END__ = .;                 \
      PROVIDE (__CTOR_END__ = .);                 \
    } > _region_

#define SECTION_dtors(_region_, _vma_, _lma_)     \
  .dtors _vma_ : _lma_                            \
    {                                             \
      FORCE_OUTPUT;                               \
      KEEP (*crtbegin.o(.dtors))                  \
      __DTOR_LIST__ = .;                \
      PROVIDE (__DTOR_LIST__ = .);                \
      KEEP (*(EXCLUDE_FILE (*crtend.o) .dtors))   \
      KEEP (*(SORT(.dtors.*)))                    \
      KEEP (*(.dtors))                            \
      __DTOR_END__ = .;                 \
      PROVIDE (__DTOR_END__ = .);                 \
    } > _region_

#define SECTION_devtab(_region_, _vma_, _lma_)    \
  .devtab _vma_ : _lma_                           \
    {                                             \
      FORCE_OUTPUT;                               \
      KEEP(*( SORT (.ecos.table.*))) ;            \
    } > _region_

#define SECTION_got(_region_, _vma_, _lma_)     \
  _gp = ALIGN(16) + 0x7ff0;                     \
  .got _vma_ : _lma_                            \
    {                                           \
      FORCE_OUTPUT; *(.got.plt) *(.got)         \
    } > _region_

#define SECTION_dynamic(_region_, _vma_, _lma_) \
  .dynamic _vma_ : _lma_                        \
    {                                           \
      FORCE_OUTPUT; *(.dynamic)                 \
    } > _region_

  /* We want the small data sections together, so single-instruction offsets
     can access them all, and initialized data all before uninitialized, so
     we can shorten the on-disk segment size.  */

#define SECTION_sdata(_region_, _vma_, _lma_)                 \
  .sdata _vma_ : _lma_                                        \
    {                                                         \
      FORCE_OUTPUT; *(.sdata) *(.sdata.*) *(.gnulinkonce.s*)  \
    } > _region_

#define SECTION_lit8(_region_, _vma_, _lma_)    \
  .lit8 _vma_ : _lma_                           \
    {                                           \
      FORCE_OUTPUT; *(.lit8)                    \
    } > _region_

#define SECTION_lit4(_region_, _vma_, _lma_)    \
  .lit4 : FOLLOWING(.lit8)                      \
    {                                           \
      FORCE_OUTPUT; *(.lit4)                    \
    } > _region_                                \
  __ram_data_end = .; _edata = . ;              \
  PROVIDE (edata = .);

#define SECTION_sbss(_region_, _vma_, _lma_)                    \
  __bss_start = .; _fbss = .;                                   \
  .sbss _vma_ : _lma_                                           \
    {                                                           \
      FORCE_OUTPUT; *(.dynsbss) *(.sbss) *(.sbss.*) *(.scommon) \
    } > _region_

#define SECTION_bss(_region_, _vma_, _lma_)       \
  .bss _vma_ : _lma_                              \
    {                                             \
      *(.dynbss) *(.bss) *(.bss.*) *(COMMON)      \
    } > _region_                                  \
  __bss_end = .;

/* The /DISCARD/ section ensures that the output will not contain a
 * .mdebug section as it confuses GDB. This is a workaround for CR 100804.
 */

#define SECTIONS_END . = ALIGN(4); _end = .; PROVIDE (end = .); \
  /* Stabs debugging sections.  */                              \
  .stab          0 : { *(.stab) }                               \
  .stabstr       0 : { *(.stabstr) }                            \
  .stab.excl     0 : { *(.stab.excl) }                          \
  .stab.exclstr  0 : { *(.stab.exclstr) }                       \
  .stab.index    0 : { *(.stab.index) }                         \
  .stab.indexstr 0 : { *(.stab.indexstr) }                      \
  .comment       0 : { *(.comment) }                            \
  /* DWARF debug sections.                                      \
     Symbols in the DWARF debugging sections are relative to    \
     the beginning of the section so we begin them at 0.  */    \
  /* DWARF 1 */                                                 \
  .debug          0 : { *(.debug) }                             \
  .line           0 : { *(.line) }                              \
  /* GNU DWARF 1 extensions */                                  \
  .debug_srcinfo  0 : { *(.debug_srcinfo) }                     \
  .debug_sfnames  0 : { *(.debug_sfnames) }                     \
  /* DWARF 1.1 and DWARF 2 */                                   \
  .debug_aranges  0 : { *(.debug_aranges) }                     \
  .debug_pubnames 0 : { *(.debug_pubnames) }                    \
  /* DWARF 2 */                                                 \
  .debug_info     0 : { *(.debug_info) }                        \
  .debug_abbrev   0 : { *(.debug_abbrev) }                      \
  .debug_line     0 : { *(.debug_line) }                        \
  .debug_frame    0 : { *(.debug_frame) }                       \
  .debug_str      0 : { *(.debug_str) }                         \
  .debug_loc      0 : { *(.debug_loc) }                         \
  .debug_macinfo  0 : { *(.debug_macinfo) }                     \
  /* SGI/MIPS DWARF 2 extensions */                             \
  .debug_weaknames 0 : { *(.debug_weaknames) }                  \
  .debug_funcnames 0 : { *(.debug_funcnames) }                  \
  .debug_typenames 0 : { *(.debug_typenames) }                  \
  .debug_varnames  0 : { *(.debug_varnames) }                   \
  /* These must appear regardless of  .  */                     \
  .gptab.sdata : { *(.gptab.data) *(.gptab.sdata) }             \
  .gptab.sbss : { *(.gptab.bss) *(.gptab.sbss) }                \
  /DISCARD/        0 : { *(.mdebug) }

#include CYGHWR_MEMORY_LAYOUT_LDI

hal_vsr_table = 0x80000200;
hal_virtual_vector_table = 0x80000300;
