// $ANTLR 2.7.4: "cpp.g" -> "CppParser.java"$

// This file is part of the program FRYSK.
//
// Copyright 2005, Red Hat Inc.
//
// FRYSK is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; version 2 of the License.
//
// FRYSK is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with FRYSK; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
// 
// In addition, as a special exception, Red Hat, Inc. gives You the
// additional right to link the code of FRYSK with code not covered
// under the GNU General Public License ("Non-GPL Code") and to
// distribute linked combinations including the two, subject to the
// limitations in this paragraph. Non-GPL Code permitted under this
// exception must only link to the code of FRYSK through those well
// defined interfaces identified in the file named EXCEPTION found in
// the source code files (the "Approved Interfaces"). The files of
// Non-GPL Code may instantiate templates or use macros or inline
// functions from the Approved Interfaces without causing the
// resulting work to be covered by the GNU General Public
// License. Only Red Hat, Inc. may make changes or additions to the
// list of Approved Interfaces. You must obey the GNU General Public
// License in all respects for all of the FRYSK code and other code
// used in conjunction with FRYSK except the Non-GPL Code covered by
// this exception. If you modify this file, you may extend this
// exception to your version of the file, but you are not obligated to
// do so. If you do not wish to provide this exception without
// modification, you must delete this exception statement from your
// version and license this file solely under the GPL without
// exception.
    package frysk.expr;

    /* import frysk.lang.*; */
    /* import java.util.*; */
  
import antlr.TokenBuffer;
import antlr.TokenStreamException;
/* import antlr.TokenStreamIOException; */
/* import antlr.ANTLRException; */
/* import antlr.LLkParser; */
import antlr.Token;
import antlr.TokenStream;
import antlr.RecognitionException;
import antlr.NoViableAltException;
/* import antlr.MismatchedTokenException; */
/* import antlr.SemanticException; */
import antlr.ParserSharedInputState;
import antlr.collections.impl.BitSet;
import antlr.collections.AST;
/* import java.util.Hashtable; */
import antlr.ASTFactory;
import antlr.ASTPair;
import antlr.collections.impl.ASTArray;

public class CppParser extends antlr.LLkParser       implements CppParserTokenTypes
 {

   /** 
    *	A member variable to keep track of TAB completions requests.
    *	If this is true the normal course of action is to simply
    *	bail out by throwing an exception
    */
    private boolean bTabPressed;
    private int assign_stmt_RHS_found;
    /* private String sInputExpression; */

    protected CppParser(TokenStream lexer, String sInput)
    {
      this(lexer);
      bTabPressed = false;
      /* sInputExpression = sInput; */
    }
  
protected CppParser(TokenBuffer tokenBuf, int k) {
  super(tokenBuf,k);
  tokenNames = _tokenNames;
  buildTokenTypeASTClassMap();
  astFactory = new ASTFactory(getTokenTypeToASTClassMap());
}

public CppParser(TokenBuffer tokenBuf) {
  this(tokenBuf,2);
}

protected CppParser(TokenStream lexer, int k) {
  super(lexer,k);
  tokenNames = _tokenNames;
  buildTokenTypeASTClassMap();
  astFactory = new ASTFactory(getTokenTypeToASTClassMap());
}

public CppParser(TokenStream lexer) {
  this(lexer,2);
}

public CppParser(ParserSharedInputState state) {
  super(state,2);
  tokenNames = _tokenNames;
  buildTokenTypeASTClassMap();
  astFactory = new ASTFactory(getTokenTypeToASTClassMap());
}

/** 
  * These tokens are never returned by the Lexer. These are imaginary
  * tokens used as root nodes in the generated Abstract Syntax Tree.
  */
	public final void imaginaryTokenDefinitions() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST imaginaryTokenDefinitions_AST = null;
		
		AST tmp32_AST = null;
		tmp32_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp32_AST);
		match(APPLY);
		AST tmp33_AST = null;
		tmp33_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp33_AST);
		match(ARG_LIST);
		AST tmp34_AST = null;
		tmp34_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp34_AST);
		match(EXPR_LIST);
		AST tmp35_AST = null;
		tmp35_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp35_AST);
		match(COND_EXPR);
		AST tmp36_AST = null;
		tmp36_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp36_AST);
		match(ARRAY_REF);
		imaginaryTokenDefinitions_AST = (AST)currentAST.root;
		returnAST = imaginaryTokenDefinitions_AST;
	}
	
/** 
    * The start rule simply expects an expression list following by
    * the end of text symbol (ETX \3).
    *
    * The TabException propagates all the way up, to the start rule,
    * which then propagates it up to the calling program.
    */
	public final void start() throws RecognitionException, TokenStreamException, TabException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST start_AST = null;
		
		expression();
		astFactory.addASTChild(currentAST, returnAST);
		AST tmp37_AST = null;
		tmp37_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp37_AST);
		match(ETX);
		start_AST = (AST)currentAST.root;
		returnAST = start_AST;
	}
	
/**
   *  This rule looks for comma separated expressions.
   */
	public final void expression() throws RecognitionException, TokenStreamException, TabException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST expression_AST = null;
		AST assign_expr1_AST = null;
		Token  comma = null;
		AST comma_AST = null;
		AST assign_expr2_AST = null;
		
		assignment_expression();
		assign_expr1_AST = (AST)returnAST;
		{
		_loop5:
		do {
			if ((LA(1)==COMMA)) {
				comma = LT(1);
				comma_AST = astFactory.create(comma);
				match(COMMA);
				assignment_expression();
				assign_expr2_AST = (AST)returnAST;
			}
			else {
				break _loop5;
			}
			
		} while (true);
		}
		if ( inputState.guessing==0 ) {
			expression_AST = (AST)currentAST.root;
			
			/** 
			* The following syntax is used for generation of ASTs. The # before a symbol refers
			* to the AST for that symbol. ## refers to the AST returned by this rule (expression)
			*/
			
			if(comma_AST!=null)
				expression_AST = (AST)astFactory.make( (new ASTArray(3)).add(astFactory.create(EXPR_LIST,"ExpressionList")).add(assign_expr1_AST).add(assign_expr2_AST));
			else
				expression_AST = assign_expr1_AST;
			
			currentAST.root = expression_AST;
			currentAST.child = expression_AST!=null &&expression_AST.getFirstChild()!=null ?
				expression_AST.getFirstChild() : expression_AST;
			currentAST.advanceChildToEnd();
		}
		returnAST = expression_AST;
	}
	
/**
   *  Assignment expressions of the form "expr1 = expr2 = expr3".
   *  Notice that the operator can by any assignment operator.
   */
	public final void assignment_expression() throws RecognitionException, TokenStreamException, TabException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST assignment_expression_AST = null;
		AST c_AST = null;
		AST a_AST = null;
		AST r_AST = null;
		
		{
		conditional_expression();
		c_AST = (AST)returnAST;
		{
		switch ( LA(1)) {
		case ASSIGNEQUAL:
		case TIMESEQUAL:
		case DIVIDEEQUAL:
		case MINUSEQUAL:
		case PLUSEQUAL:
		case MODEQUAL:
		case SHIFTLEFTEQUAL:
		case SHIFTRIGHTEQUAL:
		case BITWISEANDEQUAL:
		case BITWISEXOREQUAL:
		case BITWISEOREQUAL:
		{
			assign_op();
			a_AST = (AST)returnAST;
			remainder_expression();
			r_AST = (AST)returnAST;
			break;
		}
		case ETX:
		case COMMA:
		case RPAREN:
		case COLON:
		case RSQUARE:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		}
		if ( inputState.guessing==0 ) {
			assignment_expression_AST = (AST)currentAST.root;
			
			if(a_AST != null)
				assignment_expression_AST = (AST)astFactory.make( (new ASTArray(3)).add(a_AST).add(c_AST).add(r_AST));
			else
				assignment_expression_AST = c_AST;
			
			currentAST.root = assignment_expression_AST;
			currentAST.child = assignment_expression_AST!=null &&assignment_expression_AST.getFirstChild()!=null ?
				assignment_expression_AST.getFirstChild() : assignment_expression_AST;
			currentAST.advanceChildToEnd();
		}
		returnAST = assignment_expression_AST;
	}
	
/**
   *  Various types of assignment operators like +=, *=, /= etc.
   */
	public final void assign_op() throws RecognitionException, TokenStreamException, TabException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST assign_op_AST = null;
		
		switch ( LA(1)) {
		case ASSIGNEQUAL:
		{
			AST tmp38_AST = null;
			tmp38_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp38_AST);
			match(ASSIGNEQUAL);
			assign_op_AST = (AST)currentAST.root;
			break;
		}
		case TIMESEQUAL:
		{
			AST tmp39_AST = null;
			tmp39_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp39_AST);
			match(TIMESEQUAL);
			assign_op_AST = (AST)currentAST.root;
			break;
		}
		case DIVIDEEQUAL:
		{
			AST tmp40_AST = null;
			tmp40_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp40_AST);
			match(DIVIDEEQUAL);
			assign_op_AST = (AST)currentAST.root;
			break;
		}
		case MINUSEQUAL:
		{
			AST tmp41_AST = null;
			tmp41_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp41_AST);
			match(MINUSEQUAL);
			assign_op_AST = (AST)currentAST.root;
			break;
		}
		case PLUSEQUAL:
		{
			AST tmp42_AST = null;
			tmp42_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp42_AST);
			match(PLUSEQUAL);
			assign_op_AST = (AST)currentAST.root;
			break;
		}
		case MODEQUAL:
		{
			AST tmp43_AST = null;
			tmp43_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp43_AST);
			match(MODEQUAL);
			assign_op_AST = (AST)currentAST.root;
			break;
		}
		case SHIFTLEFTEQUAL:
		{
			AST tmp44_AST = null;
			tmp44_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp44_AST);
			match(SHIFTLEFTEQUAL);
			assign_op_AST = (AST)currentAST.root;
			break;
		}
		case SHIFTRIGHTEQUAL:
		{
			AST tmp45_AST = null;
			tmp45_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp45_AST);
			match(SHIFTRIGHTEQUAL);
			assign_op_AST = (AST)currentAST.root;
			break;
		}
		case BITWISEANDEQUAL:
		{
			AST tmp46_AST = null;
			tmp46_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp46_AST);
			match(BITWISEANDEQUAL);
			assign_op_AST = (AST)currentAST.root;
			break;
		}
		case BITWISEXOREQUAL:
		{
			AST tmp47_AST = null;
			tmp47_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp47_AST);
			match(BITWISEXOREQUAL);
			assign_op_AST = (AST)currentAST.root;
			break;
		}
		case BITWISEOREQUAL:
		{
			AST tmp48_AST = null;
			tmp48_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp48_AST);
			match(BITWISEOREQUAL);
			assign_op_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = assign_op_AST;
	}
	
/**
   *  Conditional expressions of the form
   *  (logical_expr)?expr:expr
   */
	public final void conditional_expression() throws RecognitionException, TokenStreamException, TabException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST conditional_expression_AST = null;
		AST log_or_expr_AST = null;
		Token  ques = null;
		/* AST ques_AST = null; */
		AST expr_AST = null;
		Token  colon = null;
		/* AST colon_AST = null; */
		AST cond_expr_AST = null;
		
		logical_or_expression();
		log_or_expr_AST = (AST)returnAST;
		{
		switch ( LA(1)) {
		case QUESTIONMARK:
		{
			ques = LT(1);
			/* ques_AST = */ astFactory.create(ques);
			match(QUESTIONMARK);
			expression();
			expr_AST = (AST)returnAST;
			colon = LT(1);
			/* colon_AST = */ astFactory.create(colon);
			match(COLON);
			conditional_expression();
			cond_expr_AST = (AST)returnAST;
			break;
		}
		case ETX:
		case COMMA:
		case ASSIGNEQUAL:
		case TIMESEQUAL:
		case DIVIDEEQUAL:
		case MINUSEQUAL:
		case PLUSEQUAL:
		case MODEQUAL:
		case SHIFTLEFTEQUAL:
		case SHIFTRIGHTEQUAL:
		case BITWISEANDEQUAL:
		case BITWISEXOREQUAL:
		case BITWISEOREQUAL:
		case RPAREN:
		case COLON:
		case RSQUARE:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		if ( inputState.guessing==0 ) {
			conditional_expression_AST = (AST)currentAST.root;
			
			if(ques != null)
				conditional_expression_AST = (AST)astFactory.make( (new ASTArray(4)).add(astFactory.create(COND_EXPR,"ConditionalExpression")).add(log_or_expr_AST).add(expr_AST).add(cond_expr_AST));
			else
				conditional_expression_AST = log_or_expr_AST;
			
			currentAST.root = conditional_expression_AST;
			currentAST.child = conditional_expression_AST!=null &&conditional_expression_AST.getFirstChild()!=null ?
				conditional_expression_AST.getFirstChild() : conditional_expression_AST;
			currentAST.advanceChildToEnd();
		}
		returnAST = conditional_expression_AST;
	}
	
	public final void remainder_expression() throws RecognitionException, TokenStreamException, TabException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST remainder_expression_AST = null;
		
		{
		boolean synPredMatched14 = false;
		if (((_tokenSet_0.member(LA(1))) && (_tokenSet_1.member(LA(2))))) {
			int _m14 = mark();
			synPredMatched14 = true;
			inputState.guessing++;
			try {
				{
				conditional_expression();
				{
				switch ( LA(1)) {
				case COMMA:
				{
					match(COMMA);
					break;
				}
				case SEMICOLON:
				{
					match(SEMICOLON);
					break;
				}
				case RPAREN:
				{
					match(RPAREN);
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				}
			}
			catch (RecognitionException pe) {
				synPredMatched14 = false;
			}
			rewind(_m14);
			inputState.guessing--;
		}
		if ( synPredMatched14 ) {
			if ( inputState.guessing==0 ) {
				assign_stmt_RHS_found += 1;
			}
			assignment_expression();
			astFactory.addASTChild(currentAST, returnAST);
			if ( inputState.guessing==0 ) {
				
					if (assign_stmt_RHS_found > 0)
					  assign_stmt_RHS_found -= 1;
					else
					{
					  System.out.println(LT(1).getLine() + 
					    "warning Error in assign_stmt_RHS_found = " +
					    assign_stmt_RHS_found + "\n");
					  System.out.println("Press return to continue\n");
					}
				
			}
		}
		else if ((_tokenSet_0.member(LA(1))) && (_tokenSet_1.member(LA(2)))) {
			assignment_expression();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		remainder_expression_AST = (AST)currentAST.root;
		returnAST = remainder_expression_AST;
	}
	
	public final void logical_or_expression() throws RecognitionException, TokenStreamException, TabException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST logical_or_expression_AST = null;
		
		logical_and_expression();
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop19:
		do {
			if ((LA(1)==OR)) {
				AST tmp49_AST = null;
				tmp49_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp49_AST);
				match(OR);
				logical_and_expression();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop19;
			}
			
		} while (true);
		}
		logical_or_expression_AST = (AST)currentAST.root;
		returnAST = logical_or_expression_AST;
	}
	
	public final void logical_and_expression() throws RecognitionException, TokenStreamException, TabException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST logical_and_expression_AST = null;
		
		inclusive_or_expression();
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop22:
		do {
			if ((LA(1)==AND)) {
				AST tmp50_AST = null;
				tmp50_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp50_AST);
				match(AND);
				inclusive_or_expression();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop22;
			}
			
		} while (true);
		}
		logical_and_expression_AST = (AST)currentAST.root;
		returnAST = logical_and_expression_AST;
	}
	
	public final void inclusive_or_expression() throws RecognitionException, TokenStreamException, TabException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST inclusive_or_expression_AST = null;
		
		exclusive_or_expression();
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop25:
		do {
			if ((LA(1)==BITWISEOR)) {
				AST tmp51_AST = null;
				tmp51_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp51_AST);
				match(BITWISEOR);
				exclusive_or_expression();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop25;
			}
			
		} while (true);
		}
		inclusive_or_expression_AST = (AST)currentAST.root;
		returnAST = inclusive_or_expression_AST;
	}
	
	public final void exclusive_or_expression() throws RecognitionException, TokenStreamException, TabException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST exclusive_or_expression_AST = null;
		
		and_expression();
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop28:
		do {
			if ((LA(1)==BITWISEXOR)) {
				AST tmp52_AST = null;
				tmp52_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp52_AST);
				match(BITWISEXOR);
				and_expression();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop28;
			}
			
		} while (true);
		}
		exclusive_or_expression_AST = (AST)currentAST.root;
		returnAST = exclusive_or_expression_AST;
	}
	
	public final void and_expression() throws RecognitionException, TokenStreamException, TabException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST and_expression_AST = null;
		
		equality_expression();
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop31:
		do {
			if ((LA(1)==AMPERSAND)) {
				AST tmp53_AST = null;
				tmp53_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp53_AST);
				match(AMPERSAND);
				equality_expression();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop31;
			}
			
		} while (true);
		}
		and_expression_AST = (AST)currentAST.root;
		returnAST = and_expression_AST;
	}
	
	public final void equality_expression() throws RecognitionException, TokenStreamException, TabException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST equality_expression_AST = null;
		
		relational_expression();
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop35:
		do {
			if ((LA(1)==NOTEQUAL||LA(1)==EQUAL)) {
				{
				switch ( LA(1)) {
				case NOTEQUAL:
				{
					AST tmp54_AST = null;
					tmp54_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp54_AST);
					match(NOTEQUAL);
					break;
				}
				case EQUAL:
				{
					AST tmp55_AST = null;
					tmp55_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp55_AST);
					match(EQUAL);
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				relational_expression();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop35;
			}
			
		} while (true);
		}
		equality_expression_AST = (AST)currentAST.root;
		returnAST = equality_expression_AST;
	}
	
	public final void relational_expression() throws RecognitionException, TokenStreamException, TabException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST relational_expression_AST = null;
		
		shift_expression();
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop39:
		do {
			if (((LA(1) >= LESSTHAN && LA(1) <= GREATERTHANOREQUALTO))) {
				{
				switch ( LA(1)) {
				case LESSTHAN:
				{
					AST tmp56_AST = null;
					tmp56_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp56_AST);
					match(LESSTHAN);
					break;
				}
				case GREATERTHAN:
				{
					AST tmp57_AST = null;
					tmp57_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp57_AST);
					match(GREATERTHAN);
					break;
				}
				case LESSTHANOREQUALTO:
				{
					AST tmp58_AST = null;
					tmp58_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp58_AST);
					match(LESSTHANOREQUALTO);
					break;
				}
				case GREATERTHANOREQUALTO:
				{
					AST tmp59_AST = null;
					tmp59_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp59_AST);
					match(GREATERTHANOREQUALTO);
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				shift_expression();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop39;
			}
			
		} while (true);
		}
		relational_expression_AST = (AST)currentAST.root;
		returnAST = relational_expression_AST;
	}
	
	public final void shift_expression() throws RecognitionException, TokenStreamException, TabException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST shift_expression_AST = null;
		
		additive_expression();
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop43:
		do {
			if ((LA(1)==SHIFTLEFT||LA(1)==SHIFTRIGHT)) {
				{
				switch ( LA(1)) {
				case SHIFTLEFT:
				{
					AST tmp60_AST = null;
					tmp60_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp60_AST);
					match(SHIFTLEFT);
					break;
				}
				case SHIFTRIGHT:
				{
					AST tmp61_AST = null;
					tmp61_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp61_AST);
					match(SHIFTRIGHT);
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				additive_expression();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop43;
			}
			
		} while (true);
		}
		shift_expression_AST = (AST)currentAST.root;
		returnAST = shift_expression_AST;
	}
	
	public final void additive_expression() throws RecognitionException, TokenStreamException, TabException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST additive_expression_AST = null;
		
		multiplicative_expression();
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop47:
		do {
			if ((LA(1)==PLUS||LA(1)==MINUS)) {
				{
				switch ( LA(1)) {
				case PLUS:
				{
					AST tmp62_AST = null;
					tmp62_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp62_AST);
					match(PLUS);
					break;
				}
				case MINUS:
				{
					AST tmp63_AST = null;
					tmp63_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp63_AST);
					match(MINUS);
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				multiplicative_expression();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop47;
			}
			
		} while (true);
		}
		additive_expression_AST = (AST)currentAST.root;
		returnAST = additive_expression_AST;
	}
	
	public final void multiplicative_expression() throws RecognitionException, TokenStreamException, TabException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST multiplicative_expression_AST = null;
		
		pm_expression();
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop51:
		do {
			if (((LA(1) >= STAR && LA(1) <= MOD))) {
				{
				switch ( LA(1)) {
				case STAR:
				{
					AST tmp64_AST = null;
					tmp64_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp64_AST);
					match(STAR);
					break;
				}
				case DIVIDE:
				{
					AST tmp65_AST = null;
					tmp65_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp65_AST);
					match(DIVIDE);
					break;
				}
				case MOD:
				{
					AST tmp66_AST = null;
					tmp66_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp66_AST);
					match(MOD);
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				pm_expression();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop51;
			}
			
		} while (true);
		}
		multiplicative_expression_AST = (AST)currentAST.root;
		returnAST = multiplicative_expression_AST;
	}
	
	public final void pm_expression() throws RecognitionException, TokenStreamException, TabException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST pm_expression_AST = null;
		AST post_expr1_AST = null;
		/* AST post_expr2_AST = null; */
		String sTabText;
		
		postfix_expression();
		post_expr1_AST = (AST)returnAST;
		astFactory.addASTChild(currentAST, returnAST);
		if ( inputState.guessing==0 ) {
			
			if(bTabPressed)
			{
				if(post_expr1_AST.getFirstChild() != null)
				  sTabText = post_expr1_AST.getFirstChild().getNextSibling().getText();
				else 
				  sTabText = post_expr1_AST.getText();
			
				throw new TabException(post_expr1_AST, sTabText);
			}
			
		}
		{
		_loop55:
		do {
			if ((LA(1)==DOTMBR||LA(1)==POINTERTOMBR)) {
				{
				switch ( LA(1)) {
				case DOTMBR:
				{
					AST tmp67_AST = null;
					tmp67_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp67_AST);
					match(DOTMBR);
					break;
				}
				case POINTERTOMBR:
				{
					AST tmp68_AST = null;
					tmp68_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp68_AST);
					match(POINTERTOMBR);
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				postfix_expression();
				/* post_expr2_AST = (AST)returnAST; */
				astFactory.addASTChild(currentAST, returnAST);
				if ( inputState.guessing==0 ) {
					
						if(bTabPressed)
						{
						  if(post_expr1_AST.getFirstChild() != null)
						    sTabText = post_expr1_AST.getFirstChild().getNextSibling().getText();
						  else 
						    sTabText = post_expr1_AST.getText();
					
						  throw new TabException(post_expr1_AST, sTabText);
						}
					
				}
			}
			else {
				break _loop55;
			}
			
		} while (true);
		}
		pm_expression_AST = (AST)currentAST.root;
		returnAST = pm_expression_AST;
	}
	
/**
   *  TabException is raised everytime the TAB is pressed.
   *  The parser thus bails out immediately and returns the
   *  parse tree constructed so far.
   */
	public final void postfix_expression() throws RecognitionException, TokenStreamException, TabException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST postfix_expression_AST = null;
		AST prim_expr_AST = null;
		AST expr1_AST = null;
		AST expr2_AST = null;
		Token  tb = null;
		AST tb_AST = null;
		AST id_expr1_AST = null;
		AST id_expr2_AST = null;
		
		AST astPostExpr = null, astDotExpr = null;
		
		
		{
		primary_expression();
		prim_expr_AST = (AST)returnAST;
		if ( inputState.guessing==0 ) {
			
				astPostExpr = prim_expr_AST;
			
		}
		{
		_loop61:
		do {
			switch ( LA(1)) {
			case LSQUARE:
			{
				/* AST tmp69_AST = null; */
				/* tmp69_AST = */ astFactory.create(LT(1));
				match(LSQUARE);
				expression();
				expr1_AST = (AST)returnAST;
				/* AST tmp70_AST = null; */
				/* tmp70_AST = */ astFactory.create(LT(1));
				match(RSQUARE);
				if ( inputState.guessing==0 ) {
						astPostExpr = (AST)astFactory.make( (new ASTArray(3)).add(astFactory.create(ARRAY_REF,"ArrayReference")).add(astPostExpr).add(expr1_AST));
				}
				break;
			}
			case LPAREN:
			{
				/* AST tmp71_AST = null; */
				/* tmp71_AST = */ astFactory.create(LT(1));
				match(LPAREN);
				{
				switch ( LA(1)) {
				case LPAREN:
				case TAB:
				case LITERAL_this:
				case OCTALINT:
				case DECIMALINT:
				case HEXADECIMALINT:
				case CharLiteral:
				case StringLiteral:
				case FLOATONE:
				case FLOATTWO:
				case LITERAL_true:
				case LITERAL_false:
				case IDENT:
				{
					expression();
					expr2_AST = (AST)returnAST;
					break;
				}
				case RPAREN:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				/* AST tmp72_AST = null; */
				/* tmp72_AST = */ astFactory.create(LT(1));
				match(RPAREN);
				if ( inputState.guessing==0 ) {
						astPostExpr = (AST)astFactory.make( (new ASTArray(3)).add(astFactory.create(APPLY,"FuncCall")).add(astPostExpr).add(expr2_AST));
				}
				break;
			}
			case DOT:
			{
				AST tmp73_AST = null;
				tmp73_AST = astFactory.create(LT(1));
				match(DOT);
				{
				switch ( LA(1)) {
				case TAB:
				{
					tb = LT(1);
					tb_AST = astFactory.create(tb);
					match(TAB);
					if ( inputState.guessing==0 ) {
						
							    bTabPressed = true;
							    astDotExpr = tb_AST; 
							
					}
					break;
				}
				case IDENT:
				{
					id_expression();
					id_expr1_AST = (AST)returnAST;
					if ( inputState.guessing==0 ) {
						astDotExpr = id_expr1_AST;
					}
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				if ( inputState.guessing==0 ) {
					astPostExpr = (AST)astFactory.make( (new ASTArray(3)).add(tmp73_AST).add(astPostExpr).add(astDotExpr));
				}
				break;
			}
			case POINTERTO:
			{
				AST tmp74_AST = null;
				tmp74_AST = astFactory.create(LT(1));
				match(POINTERTO);
				id_expression();
				id_expr2_AST = (AST)returnAST;
				if ( inputState.guessing==0 ) {
					astPostExpr = (AST)astFactory.make( (new ASTArray(3)).add(tmp74_AST).add(astPostExpr).add(id_expr2_AST));
				}
				break;
			}
			case PLUSPLUS:
			{
				AST tmp75_AST = null;
				tmp75_AST = astFactory.create(LT(1));
				match(PLUSPLUS);
				if ( inputState.guessing==0 ) {
					astPostExpr = (AST)astFactory.make( (new ASTArray(2)).add(tmp75_AST).add(astPostExpr));
				}
				break;
			}
			case MINUSMINUS:
			{
				AST tmp76_AST = null;
				tmp76_AST = astFactory.create(LT(1));
				match(MINUSMINUS);
				if ( inputState.guessing==0 ) {
					astPostExpr = (AST)astFactory.make( (new ASTArray(2)).add(tmp76_AST).add(astPostExpr));
				}
				break;
			}
			default:
			{
				break _loop61;
			}
			}
		} while (true);
		}
		}
		if ( inputState.guessing==0 ) {
			postfix_expression_AST = (AST)currentAST.root;
			
			postfix_expression_AST = astPostExpr; 
			
			currentAST.root = postfix_expression_AST;
			currentAST.child = postfix_expression_AST!=null &&postfix_expression_AST.getFirstChild()!=null ?
				postfix_expression_AST.getFirstChild() : postfix_expression_AST;
			currentAST.advanceChildToEnd();
		}
		returnAST = postfix_expression_AST;
	}
	
/**
     *	The TAB over here is not part of the C++ grammar.
     *	This enables auto-completion by allowing the user
     *	to press TAB whenever auto-completion is required
     */
	public final void primary_expression() throws RecognitionException, TokenStreamException, TabException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST primary_expression_AST = null;
		
		switch ( LA(1)) {
		case TAB:
		case IDENT:
		{
			{
			switch ( LA(1)) {
			case IDENT:
			{
				id_expression();
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			case TAB:
			{
				{
				AST tmp77_AST = null;
				tmp77_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp77_AST);
				match(TAB);
				if ( inputState.guessing==0 ) {
					bTabPressed = true;
				}
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			primary_expression_AST = (AST)currentAST.root;
			break;
		}
		case OCTALINT:
		case DECIMALINT:
		case HEXADECIMALINT:
		case CharLiteral:
		case StringLiteral:
		case FLOATONE:
		case FLOATTWO:
		case LITERAL_true:
		case LITERAL_false:
		{
			constant();
			astFactory.addASTChild(currentAST, returnAST);
			primary_expression_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_this:
		{
			AST tmp78_AST = null;
			tmp78_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp78_AST);
			match(LITERAL_this);
			primary_expression_AST = (AST)currentAST.root;
			break;
		}
		case LPAREN:
		{
			match(LPAREN);
			expression();
			astFactory.addASTChild(currentAST, returnAST);
			match(RPAREN);
			primary_expression_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = primary_expression_AST;
	}
	
	public final void id_expression() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST id_expression_AST = null;
		
		AST tmp81_AST = null;
		tmp81_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp81_AST);
		match(IDENT);
		id_expression_AST = (AST)currentAST.root;
		returnAST = id_expression_AST;
	}
	
	public final void constant() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST constant_AST = null;
		
		switch ( LA(1)) {
		case OCTALINT:
		{
			AST tmp82_AST = null;
			tmp82_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp82_AST);
			match(OCTALINT);
			constant_AST = (AST)currentAST.root;
			break;
		}
		case DECIMALINT:
		{
			AST tmp83_AST = null;
			tmp83_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp83_AST);
			match(DECIMALINT);
			constant_AST = (AST)currentAST.root;
			break;
		}
		case HEXADECIMALINT:
		{
			AST tmp84_AST = null;
			tmp84_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp84_AST);
			match(HEXADECIMALINT);
			constant_AST = (AST)currentAST.root;
			break;
		}
		case CharLiteral:
		{
			AST tmp85_AST = null;
			tmp85_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp85_AST);
			match(CharLiteral);
			constant_AST = (AST)currentAST.root;
			break;
		}
		case StringLiteral:
		{
			{
			int _cnt67=0;
			_loop67:
			do {
				if ((LA(1)==StringLiteral)) {
					AST tmp86_AST = null;
					tmp86_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp86_AST);
					match(StringLiteral);
				}
				else {
					if ( _cnt67>=1 ) { break _loop67; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt67++;
			} while (true);
			}
			constant_AST = (AST)currentAST.root;
			break;
		}
		case FLOATONE:
		{
			AST tmp87_AST = null;
			tmp87_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp87_AST);
			match(FLOATONE);
			constant_AST = (AST)currentAST.root;
			break;
		}
		case FLOATTWO:
		{
			AST tmp88_AST = null;
			tmp88_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp88_AST);
			match(FLOATTWO);
			constant_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_true:
		{
			AST tmp89_AST = null;
			tmp89_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp89_AST);
			match(LITERAL_true);
			constant_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_false:
		{
			AST tmp90_AST = null;
			tmp90_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp90_AST);
			match(LITERAL_false);
			constant_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = constant_AST;
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"APPLY",
		"ARG_LIST",
		"EXPR_LIST",
		"COND_EXPR",
		"ARRAY_REF",
		"ETX",
		"COMMA",
		"ASSIGNEQUAL",
		"TIMESEQUAL",
		"DIVIDEEQUAL",
		"MINUSEQUAL",
		"PLUSEQUAL",
		"MODEQUAL",
		"SHIFTLEFTEQUAL",
		"SHIFTRIGHTEQUAL",
		"BITWISEANDEQUAL",
		"BITWISEXOREQUAL",
		"BITWISEOREQUAL",
		"SEMICOLON",
		"RPAREN",
		"QUESTIONMARK",
		"COLON",
		"OR",
		"AND",
		"BITWISEOR",
		"BITWISEXOR",
		"AMPERSAND",
		"NOTEQUAL",
		"EQUAL",
		"LESSTHAN",
		"GREATERTHAN",
		"LESSTHANOREQUALTO",
		"GREATERTHANOREQUALTO",
		"SHIFTLEFT",
		"SHIFTRIGHT",
		"PLUS",
		"MINUS",
		"STAR",
		"DIVIDE",
		"MOD",
		"DOTMBR",
		"POINTERTOMBR",
		"LSQUARE",
		"RSQUARE",
		"LPAREN",
		"DOT",
		"TAB",
		"POINTERTO",
		"PLUSPLUS",
		"MINUSMINUS",
		"\"this\"",
		"OCTALINT",
		"DECIMALINT",
		"HEXADECIMALINT",
		"CharLiteral",
		"StringLiteral",
		"FLOATONE",
		"FLOATTWO",
		"\"true\"",
		"\"false\"",
		"IDENT",
		"\"operator\"",
		"LCURLY",
		"RCURLY",
		"NOT",
		"TILDE",
		"ELLIPSIS",
		"SCOPE",
		"TAB_IDENT",
		"NL",
		"WS",
		"Escape",
		"Digit",
		"Decimal",
		"LongSuffix",
		"UnsignedSuffix",
		"FloatSuffix",
		"Exponent",
		"Vocabulary",
		"NUM"
	};
	
	protected void buildTokenTypeASTClassMap() {
		tokenTypeToASTClassMap=null;
	}
	
	private static final long[] mk_tokenSet_0() {
		long[] data = { -16607023625928704L, 1L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_0 = new BitSet(mk_tokenSet_0());
	private static final long[] mk_tokenSet_1() {
		long[] data = { -4194816L, 1L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_1 = new BitSet(mk_tokenSet_1());
	
	}
