// $ANTLR 2.7.4: "cpp.g" -> "CppTreeParser.java"$

// This file is part of the program FRYSK.
//
// Copyright 2005, Red Hat Inc.
//
// FRYSK is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; version 2 of the License.
//
// FRYSK is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with FRYSK; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
// 
// In addition, as a special exception, Red Hat, Inc. gives You the
// additional right to link the code of FRYSK with code not covered
// under the GNU General Public License ("Non-GPL Code") and to
// distribute linked combinations including the two, subject to the
// limitations in this paragraph. Non-GPL Code permitted under this
// exception must only link to the code of FRYSK through those well
// defined interfaces identified in the file named EXCEPTION found in
// the source code files (the "Approved Interfaces"). The files of
// Non-GPL Code may instantiate templates or use macros or inline
// functions from the Approved Interfaces without causing the
// resulting work to be covered by the GNU General Public
// License. Only Red Hat, Inc. may make changes or additions to the
// list of Approved Interfaces. You must obey the GNU General Public
// License in all respects for all of the FRYSK code and other code
// used in conjunction with FRYSK except the Non-GPL Code covered by
// this exception. If you modify this file, you may extend this
// exception to your version of the file, but you are not obligated to
// do so. If you do not wish to provide this exception without
// modification, you must delete this exception statement from your
// version and license this file solely under the GPL without
// exception.
    package frysk.expr;

    import frysk.lang.*;
    import java.util.*;
  
/* import antlr.TreeParser; */
/* import antlr.Token; */
import antlr.collections.AST;
import antlr.RecognitionException;
/* import antlr.ANTLRException; */
import antlr.NoViableAltException;
/* import antlr.MismatchedTokenException; */
/* import antlr.SemanticException; */
/* import antlr.collections.impl.BitSet; */
/* import antlr.ASTPair; */
/* import antlr.collections.impl.ASTArray; */


public class CppTreeParser extends antlr.TreeParser       implements CppTreeParserTokenTypes
 {

    IntegerType intType;
    ShortType shortType;
    Map symTab;
    public CppTreeParser(int intSize, int shortSize, Map _symTab) {
      this();
      symTab = _symTab;
      intType = new IntegerType(intSize, Endian.BIG_ENDIAN);
      shortType = new ShortType(shortSize, Endian.LITTLE_ENDIAN);
    }
  public CppTreeParser() {
	tokenNames = _tokenNames;
}

	public final Variable  expr(AST _t) throws RecognitionException, InvalidOperatorException,OperationNotDefinedException {
		Variable returnVar=null;
		
		/* AST expr_AST_in = (_t == ASTNULL) ? null : (AST)_t; */
		AST i = null;
		AST ident = null;
		Variable v1, v2, log_expr;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case PLUS:
			{
				AST __t209 = _t;
				/* AST tmp1_AST_in = (AST)_t; */
				match(_t,PLUS);
				_t = _t.getFirstChild();
				v1=expr(_t);
				_t = _retTree;
				v2=expr(_t);
				_t = _retTree;
				_t = __t209;
				_t = _t.getNextSibling();
					returnVar = v1.getType().add(v1, v2);
				break;
			}
			case MINUS:
			{
				AST __t210 = _t;
				/* AST tmp2_AST_in = (AST)_t; */
				match(_t,MINUS);
				_t = _t.getFirstChild();
				v1=expr(_t);
				_t = _retTree;
				v2=expr(_t);
				_t = _retTree;
				_t = __t210;
				_t = _t.getNextSibling();
				returnVar = v1.getType().subtract(v1, v2);
				break;
			}
			case STAR:
			{
				AST __t211 = _t;
				/* AST tmp3_AST_in = (AST)_t; */
				match(_t,STAR);
				_t = _t.getFirstChild();
				v1=expr(_t);
				_t = _retTree;
				v2=expr(_t);
				_t = _retTree;
				_t = __t211;
				_t = _t.getNextSibling();
					returnVar = v1.getType().multiply(v1, v2);
				break;
			}
			case DIVIDE:
			{
				AST __t212 = _t;
				/* AST tmp4_AST_in = (AST)_t; */
				match(_t,DIVIDE);
				_t = _t.getFirstChild();
				v1=expr(_t);
				_t = _retTree;
				v2=expr(_t);
				_t = _retTree;
				_t = __t212;
				_t = _t.getNextSibling();
				returnVar = v1.getType().divide(v1, v2);
				break;
			}
			case MOD:
			{
				AST __t213 = _t;
				/* AST tmp5_AST_in = (AST)_t; */
				match(_t,MOD);
				_t = _t.getFirstChild();
				v1=expr(_t);
				_t = _retTree;
				v2=expr(_t);
				_t = _retTree;
				_t = __t213;
				_t = _t.getNextSibling();
					returnVar = v1.getType().mod(v1, v2);
				break;
			}
			case SHIFTLEFT:
			{
				AST __t214 = _t;
				/* AST tmp6_AST_in = (AST)_t; */
				match(_t,SHIFTLEFT);
				_t = _t.getFirstChild();
				v1=expr(_t);
				_t = _retTree;
				v2=expr(_t);
				_t = _retTree;
				_t = __t214;
				_t = _t.getNextSibling();
					
				if((v1.getType().getTypeId() < BaseTypes.baseTypeChar && v1.getType().getTypeId() > BaseTypes.baseTypeLong) ||
					  (v2.getType().getTypeId() < BaseTypes.baseTypeChar && v2.getType().getTypeId() > BaseTypes.baseTypeLong)) {
				
					throw new OperationNotDefinedException("binary operator << not defined for types " + 
					    v1.getType().getName() + " and " + v2.getType().getName());
				}
				
				returnVar = v1.getType().shiftLeft(v1, v2);
				break;
			}
			case SHIFTRIGHT:
			{
				AST __t215 = _t;
				/* AST tmp7_AST_in = (AST)_t; */
				match(_t,SHIFTRIGHT);
				_t = _t.getFirstChild();
				v1=expr(_t);
				_t = _retTree;
				v2=expr(_t);
				_t = _retTree;
				_t = __t215;
				_t = _t.getNextSibling();
					
				if((v1.getType().getTypeId() < BaseTypes.baseTypeChar && v1.getType().getTypeId() > BaseTypes.baseTypeLong) ||
					  (v2.getType().getTypeId() < BaseTypes.baseTypeChar && v2.getType().getTypeId() > BaseTypes.baseTypeLong)) {
				
					throw new OperationNotDefinedException("binary operator >> not defined for types " + 
					    v1.getType().getName() + " and " + v2.getType().getName());
				}
				
				returnVar = v1.getType().shiftRight(v1, v2);
				break;
			}
			case LESSTHAN:
			{
				AST __t216 = _t;
				/* AST tmp8_AST_in = (AST)_t; */
				match(_t,LESSTHAN);
				_t = _t.getFirstChild();
				v1=expr(_t);
				_t = _retTree;
				v2=expr(_t);
				_t = _retTree;
				_t = __t216;
				_t = _t.getNextSibling();
				returnVar = v1.getType().lessThan(v1, v2);
				break;
			}
			case GREATERTHAN:
			{
				AST __t217 = _t;
				/* AST tmp9_AST_in = (AST)_t; */
				match(_t,GREATERTHAN);
				_t = _t.getFirstChild();
				v1=expr(_t);
				_t = _retTree;
				v2=expr(_t);
				_t = _retTree;
				_t = __t217;
				_t = _t.getNextSibling();
				returnVar = v1.getType().greaterThan(v1, v2);
				break;
			}
			case LESSTHANOREQUALTO:
			{
				AST __t218 = _t;
				/* AST tmp10_AST_in = (AST)_t; */
				match(_t,LESSTHANOREQUALTO);
				_t = _t.getFirstChild();
				v1=expr(_t);
				_t = _retTree;
				v2=expr(_t);
				_t = _retTree;
				_t = __t218;
				_t = _t.getNextSibling();
				returnVar = v1.getType().lessThanOrEqualTo(v1, v2);
				break;
			}
			case GREATERTHANOREQUALTO:
			{
				AST __t219 = _t;
				/* AST tmp11_AST_in = (AST)_t; */
				match(_t,GREATERTHANOREQUALTO);
				_t = _t.getFirstChild();
				v1=expr(_t);
				_t = _retTree;
				v2=expr(_t);
				_t = _retTree;
				_t = __t219;
				_t = _t.getNextSibling();
				returnVar = v1.getType().greaterThanOrEqualTo(v1, v2);
				break;
			}
			case NOTEQUAL:
			{
				AST __t220 = _t;
				/* AST tmp12_AST_in = (AST)_t; */
				match(_t,NOTEQUAL);
				_t = _t.getFirstChild();
				v1=expr(_t);
				_t = _retTree;
				v2=expr(_t);
				_t = _retTree;
				_t = __t220;
				_t = _t.getNextSibling();
				returnVar = v1.getType().notEqual(v1, v2);
				break;
			}
			case EQUAL:
			{
				AST __t221 = _t;
				/* AST tmp13_AST_in = (AST)_t; */
				match(_t,EQUAL);
				_t = _t.getFirstChild();
				v1=expr(_t);
				_t = _retTree;
				v2=expr(_t);
				_t = _retTree;
				_t = __t221;
				_t = _t.getNextSibling();
				returnVar = v1.getType().equal(v1, v2);
				break;
			}
			case AMPERSAND:
			{
				AST __t222 = _t;
				/* AST tmp14_AST_in = (AST)_t; */
				match(_t,AMPERSAND);
				_t = _t.getFirstChild();
				v1=expr(_t);
				_t = _retTree;
				v2=expr(_t);
				_t = _retTree;
				_t = __t222;
				_t = _t.getNextSibling();
				returnVar = v1.getType().bitWiseAnd(v1, v2);
				break;
			}
			case BITWISEXOR:
			{
				AST __t223 = _t;
				/* AST tmp15_AST_in = (AST)_t; */
				match(_t,BITWISEXOR);
				_t = _t.getFirstChild();
				v1=expr(_t);
				_t = _retTree;
				v2=expr(_t);
				_t = _retTree;
				_t = __t223;
				_t = _t.getNextSibling();
				returnVar = v1.getType().bitWiseXor(v1, v2);
				break;
			}
			case BITWISEOR:
			{
				AST __t224 = _t;
				/* AST tmp16_AST_in = (AST)_t; */
				match(_t,BITWISEOR);
				_t = _t.getFirstChild();
				v1=expr(_t);
				_t = _retTree;
				v2=expr(_t);
				_t = _retTree;
				_t = __t224;
				_t = _t.getNextSibling();
				returnVar = v1.getType().bitWiseOr(v1, v2);
				break;
			}
			case AND:
			{
				AST __t225 = _t;
				/* AST tmp17_AST_in = (AST)_t; */
				match(_t,AND);
				_t = _t.getFirstChild();
				v1=expr(_t);
				_t = _retTree;
				v2=expr(_t);
				_t = _retTree;
				_t = __t225;
				_t = _t.getNextSibling();
				returnVar = v1.getType().logicalAnd(v1, v2);
				break;
			}
			case OR:
			{
				AST __t226 = _t;
				/* AST tmp18_AST_in = (AST)_t; */
				match(_t,OR);
				_t = _t.getFirstChild();
				v1=expr(_t);
				_t = _retTree;
				v2=expr(_t);
				_t = _retTree;
				_t = __t226;
				_t = _t.getNextSibling();
				returnVar = v1.getType().logicalOr(v1, v2);
				break;
			}
			case COND_EXPR:
			{
				AST __t227 = _t;
				/* AST tmp19_AST_in = (AST)_t; */
				match(_t,COND_EXPR);
				_t = _t.getFirstChild();
				log_expr=expr(_t);
				_t = _retTree;
				v1=expr(_t);
				_t = _retTree;
				v2=expr(_t);
				_t = _retTree;
				_t = __t227;
				_t = _t.getNextSibling();
				
				returnVar = ((log_expr.getType().getLogicalValue(log_expr)) ? v1 : v2);  
				
				break;
			}
			case DECIMALINT:
			{
				i = (AST)_t;
				match(_t,DECIMALINT);
				_t = _t.getNextSibling();
				
				returnVar = IntegerType.newIntegerVariable(
					  intType, Integer.parseInt(i.getText()));
				
				break;
			}
			case ASSIGNEQUAL:
			{
				AST __t228 = _t;
				/* AST tmp20_AST_in = (AST)_t; */
				match(_t,ASSIGNEQUAL);
				_t = _t.getFirstChild();
				v1=expr(_t);
				_t = _retTree;
				v2=expr(_t);
				_t = _retTree;
				_t = __t228;
				_t = _t.getNextSibling();
				
				if(v1.getType().getTypeId() != v2.getType().getTypeId())
					v1 = v2.getType().newVariable(v2.getType(), v1);
				v1.getType().assign(v1, v2);
				returnVar = v1;
				symTab.put(v1.getText(), v1);
				
				break;
			}
			case TIMESEQUAL:
			{
				AST __t229 = _t;
				/* AST tmp21_AST_in = (AST)_t; */
				match(_t,TIMESEQUAL);
				_t = _t.getFirstChild();
				v1=expr(_t);
				_t = _retTree;
				v2=expr(_t);
				_t = _retTree;
				_t = __t229;
				_t = _t.getNextSibling();
				
				if(v1.getType().getTypeId() != v2.getType().getTypeId())
					v1 = v2.getType().newVariable(v2.getType(), v1);
				v1.getType().timesEqual(v1, v2);
				returnVar = v1;
				symTab.put(v1.getText(), v1);
				
				break;
			}
			case DIVIDEEQUAL:
			{
				AST __t230 = _t;
				/* AST tmp22_AST_in = (AST)_t; */
				match(_t,DIVIDEEQUAL);
				_t = _t.getFirstChild();
				v1=expr(_t);
				_t = _retTree;
				v2=expr(_t);
				_t = _retTree;
				_t = __t230;
				_t = _t.getNextSibling();
				
				if(v1.getType().getTypeId() != v2.getType().getTypeId())
					v1 = v2.getType().newVariable(v2.getType(), v1);
				v1.getType().divideEqual(v1, v2);
				returnVar = v1;
				symTab.put(v1.getText(), v1);
				
				break;
			}
			case MINUSEQUAL:
			{
				AST __t231 = _t;
				/* AST tmp23_AST_in = (AST)_t; */
				match(_t,MINUSEQUAL);
				_t = _t.getFirstChild();
				v1=expr(_t);
				_t = _retTree;
				v2=expr(_t);
				_t = _retTree;
				_t = __t231;
				_t = _t.getNextSibling();
				
				if(v1.getType().getTypeId() != v2.getType().getTypeId())
					v1 = v2.getType().newVariable(v2.getType(), v1);
				v1.getType().minusEqual(v1, v2);
				returnVar = v1;
				symTab.put(v1.getText(), v1);
				
				break;
			}
			case PLUSEQUAL:
			{
				AST __t232 = _t;
				/* AST tmp24_AST_in = (AST)_t; */
				match(_t,PLUSEQUAL);
				_t = _t.getFirstChild();
				v1=expr(_t);
				_t = _retTree;
				v2=expr(_t);
				_t = _retTree;
				_t = __t232;
				_t = _t.getNextSibling();
				
				if(v1.getType().getTypeId() != v2.getType().getTypeId())
					v1 = v2.getType().newVariable(v2.getType(), v1);
				v1.getType().plusEqual(v1, v2);
				returnVar = v1;
				symTab.put(v1.getText(), v1);
				
				break;
			}
			case MODEQUAL:
			{
				AST __t233 = _t;
				/* AST tmp25_AST_in = (AST)_t; */
				match(_t,MODEQUAL);
				_t = _t.getFirstChild();
				v1=expr(_t);
				_t = _retTree;
				v2=expr(_t);
				_t = _retTree;
				_t = __t233;
				_t = _t.getNextSibling();
				
				if(v1.getType().getTypeId() != v2.getType().getTypeId())
					v1 = v2.getType().newVariable(v2.getType(), v1);
				v1.getType().modEqual(v1, v2);
				returnVar = v1;
				symTab.put(v1.getText(), v1);
				
				break;
			}
			case SHIFTLEFTEQUAL:
			{
				AST __t234 = _t;
				/* AST tmp26_AST_in = (AST)_t; */
				match(_t,SHIFTLEFTEQUAL);
				_t = _t.getFirstChild();
				v1=expr(_t);
				_t = _retTree;
				v2=expr(_t);
				_t = _retTree;
				_t = __t234;
				_t = _t.getNextSibling();
				
				if(v1.getType().getTypeId() != v2.getType().getTypeId())
					v1 = v2.getType().newVariable(v2.getType(), v1);
				v1.getType().shiftLeftEqual(v1, v2);
				returnVar = v1;
				symTab.put(v1.getText(), v1);
				
				break;
			}
			case SHIFTRIGHTEQUAL:
			{
				AST __t235 = _t;
				/* AST tmp27_AST_in = (AST)_t; */
				match(_t,SHIFTRIGHTEQUAL);
				_t = _t.getFirstChild();
				v1=expr(_t);
				_t = _retTree;
				v2=expr(_t);
				_t = _retTree;
				_t = __t235;
				_t = _t.getNextSibling();
				
				if(v1.getType().getTypeId() != v2.getType().getTypeId())
					v1 = v2.getType().newVariable(v2.getType(), v1);
				v1.getType().shiftRightEqual(v1, v2);
				returnVar = v1;
				symTab.put(v1.getText(), v1);
				
				break;
			}
			case BITWISEANDEQUAL:
			{
				AST __t236 = _t;
				/* AST tmp28_AST_in = (AST)_t; */
				match(_t,BITWISEANDEQUAL);
				_t = _t.getFirstChild();
				v1=expr(_t);
				_t = _retTree;
				v2=expr(_t);
				_t = _retTree;
				_t = __t236;
				_t = _t.getNextSibling();
				
				if(v1.getType().getTypeId() != v2.getType().getTypeId())
					v1 = v2.getType().newVariable(v2.getType(), v1);
				v1.getType().bitWiseAndEqual(v1, v2);
				returnVar = v1;
				symTab.put(v1.getText(), v1);
				
				break;
			}
			case BITWISEXOREQUAL:
			{
				AST __t237 = _t;
				/* AST tmp29_AST_in = (AST)_t; */
				match(_t,BITWISEXOREQUAL);
				_t = _t.getFirstChild();
				v1=expr(_t);
				_t = _retTree;
				v2=expr(_t);
				_t = _retTree;
				_t = __t237;
				_t = _t.getNextSibling();
				
				if(v1.getType().getTypeId() != v2.getType().getTypeId())
					v1 = v2.getType().newVariable(v2.getType(), v1);
				v1.getType().bitWiseXorEqual(v1, v2);
				returnVar = v1;
				symTab.put(v1.getText(), v1);
				
				break;
			}
			case BITWISEOREQUAL:
			{
				AST __t238 = _t;
				/* AST tmp30_AST_in = (AST)_t; */
				match(_t,BITWISEOREQUAL);
				_t = _t.getFirstChild();
				v1=expr(_t);
				_t = _retTree;
				v2=expr(_t);
				_t = _retTree;
				_t = __t238;
				_t = _t.getNextSibling();
				
				if(v1.getType().getTypeId() != v2.getType().getTypeId())
					v1 = v2.getType().newVariable(v2.getType(), v1);
				v1.getType().bitWiseOrEqual(v1, v2);
				returnVar = v1;
				symTab.put(v1.getText(), v1);
				
				break;
			}
			case EXPR_LIST:
			{
				AST __t239 = _t;
				/* AST tmp31_AST_in = (AST)_t; */
				match(_t,EXPR_LIST);
				_t = _t.getFirstChild();
				v1=expr(_t);
				_t = _retTree;
				v2=expr(_t);
				_t = _retTree;
				_t = __t239;
				_t = _t.getNextSibling();
				returnVar = v1;
				break;
			}
			case IDENT:
			{
				ident = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				
				if((returnVar = ((Variable)symTab.get(ident.getText()))) == null) {
					returnVar = IntegerType.newIntegerVariable(intType, ident.getText(), 0);
					symTab.put(ident.getText(), returnVar);
				}
				
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
		return returnVar;
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"APPLY",
		"ARG_LIST",
		"EXPR_LIST",
		"COND_EXPR",
		"ARRAY_REF",
		"ETX",
		"COMMA",
		"ASSIGNEQUAL",
		"TIMESEQUAL",
		"DIVIDEEQUAL",
		"MINUSEQUAL",
		"PLUSEQUAL",
		"MODEQUAL",
		"SHIFTLEFTEQUAL",
		"SHIFTRIGHTEQUAL",
		"BITWISEANDEQUAL",
		"BITWISEXOREQUAL",
		"BITWISEOREQUAL",
		"SEMICOLON",
		"RPAREN",
		"QUESTIONMARK",
		"COLON",
		"OR",
		"AND",
		"BITWISEOR",
		"BITWISEXOR",
		"AMPERSAND",
		"NOTEQUAL",
		"EQUAL",
		"LESSTHAN",
		"GREATERTHAN",
		"LESSTHANOREQUALTO",
		"GREATERTHANOREQUALTO",
		"SHIFTLEFT",
		"SHIFTRIGHT",
		"PLUS",
		"MINUS",
		"STAR",
		"DIVIDE",
		"MOD",
		"DOTMBR",
		"POINTERTOMBR",
		"LSQUARE",
		"RSQUARE",
		"LPAREN",
		"DOT",
		"TAB",
		"POINTERTO",
		"PLUSPLUS",
		"MINUSMINUS",
		"\"this\"",
		"OCTALINT",
		"DECIMALINT",
		"HEXADECIMALINT",
		"CharLiteral",
		"StringLiteral",
		"FLOATONE",
		"FLOATTWO",
		"\"true\"",
		"\"false\"",
		"IDENT",
		"\"operator\"",
		"LCURLY",
		"RCURLY",
		"NOT",
		"TILDE",
		"ELLIPSIS",
		"SCOPE",
		"TAB_IDENT",
		"NL",
		"WS",
		"Escape",
		"Digit",
		"Decimal",
		"LongSuffix",
		"UnsignedSuffix",
		"FloatSuffix",
		"Exponent",
		"Vocabulary",
		"NUM"
	};
	
	}
	
