// This file is part of the program FRYSK.
//
// Copyright 2006, 2008, Red Hat Inc.
//
// FRYSK is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; version 2 of the License.
//
// FRYSK is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with FRYSK; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
// 
// In addition, as a special exception, Red Hat, Inc. gives You the
// additional right to link the code of FRYSK with code not covered
// under the GNU General Public License ("Non-GPL Code") and to
// distribute linked combinations including the two, subject to the
// limitations in this paragraph. Non-GPL Code permitted under this
// exception must only link to the code of FRYSK through those well
// defined interfaces identified in the file named EXCEPTION found in
// the source code files (the "Approved Interfaces"). The files of
// Non-GPL Code may instantiate templates or use macros or inline
// functions from the Approved Interfaces without causing the
// resulting work to be covered by the GNU General Public
// License. Only Red Hat, Inc. may make changes or additions to the
// list of Approved Interfaces. You must obey the GNU General Public
// License in all respects for all of the FRYSK code and other code
// used in conjunction with FRYSK except the Non-GPL Code covered by
// this exception. If you modify this file, you may extend this
// exception to your version of the file, but you are not obligated to
// do so. If you do not wish to provide this exception without
// modification, you must delete this exception statement from your
// version and license this file solely under the GPL without
// exception.


package frysk.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import frysk.rsl.Log;
import frysk.debuginfo.PrintStackOptions;
import frysk.event.Event;
import frysk.event.RequestStopEvent;
import frysk.proc.Manager;
import frysk.proc.Proc;
import frysk.proc.ProcBlockAction;
import frysk.testbed.TestLib;
import frysk.testbed.SlaveOffspring;
import frysk.testbed.FunitThreadsOffspring;

public class StressTestStackTraceAction extends TestLib {
    private static final Log fine = Log.fine(StressTestStackTraceAction.class);

  static String mainClone
      = "Task #\\d+\n"
      + "(#[\\d]+ 0x[\\da-f]+ in .*\n)*"
      + "#[\\d]+ 0x[\\da-f]+ in main \\(\\) from .*\n"
      + "(#[\\d]+ 0x[\\da-f]+ in .*\n)*";

  static String clone = "Task #\\d+\n" + "(#[\\d]+ 0x[\\da-f]+ in .*\n)*";

  public void testStressMultiThreadedDetach ()
  {
    int clones = 20;
    SlaveOffspring ackProc = SlaveOffspring.createChild()
	.assertSendAddClonesWaitForAcks(clones);
    TestStackTraceAction.multiThreaded(ackProc, clones);
  }

  public void testClone ()
  {
      StringWriter stringWriter = new StringWriter();
      
    int threads = 2;
    FunitThreadsOffspring ackProc = new FunitThreadsOffspring(threads);
    final Proc proc = ackProc.assertRunToFindProc();

    PrintStackOptions options = new PrintStackOptions();
    options.setNumberOfFrames(20);
    options.setPrintParams(true);
    
    StacktraceAction stacker = new StacktraceAction(new PrintWriter(stringWriter),proc, new Event()
    {

      public void execute ()
      {
        proc.requestAbandonAndRunEvent(new RequestStopEvent(Manager.eventLoop));
      }
    },options)
    {

      public void addFailed (Object observable, Throwable w)
      {
        fail("Proc add failed" + w.getMessage());
      }
    };
    
    new ProcBlockAction(proc, stacker);
    assertRunUntilStop("perform backtrace");

    String regex = "(" + mainClone + ")(" + clone + ")*";

    String result = stringWriter.getBuffer().toString();
    fine.log("result", result);
    assertTrue(result + "should match: " + regex, result.matches(regex));

  }

}
