// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license
//-----------------------------------------------------------------------------
// BrickEngine test code
//-----------------------------------------------------------------------------

#include "Pooma/Pooma.h"
#include "Utilities/PAssert.h"
#include "Utilities/Tester.h"
#include "Domain/SliceInterval.h"
#include "Domain/SliceRange.h"
#include "Domain/AllDomain.h"
#include "Engine/BrickEngine.h"

typedef Engine<5,double,Brick> Brick5_t;

int main(int argc, char *argv[])
{
  Pooma::initialize(argc,argv);
  Pooma::Tester tester(argc,argv);
#if POOMA_EXCEPTIONS
  try {
#endif
    tester.out() << "\n\nTesting 5D slice-range subsetting...\n\n";

    Interval<1> I(5);
    Interval<5> BD(I,I,I,I,I);

    Brick5_t b(BD);

    for (int i4 = 0; i4 < b.domain()[4].length(); ++i4)
      for (int i3 = 0; i3 < b.domain()[3].length(); ++i3)
	for (int i2 = 0; i2 < b.domain()[2].length(); ++i2)
	  for (int i1 = 0; i1 < b.domain()[1].length(); ++i1)
	    for (int i0 = 0; i0 < b.domain()[0].length(); ++i0)
	      b(i0,i1,i2,i3,i4) = i4+10*(i3+10*(i2+10*(i1+10*i0)));

    tester.out() << "b.domain()     = " << b.domain() << std::endl;
    tester.out() << std::endl;

    typedef NewDomain5<int, Range<1>, int, AllDomain<1>, Interval<1> > 
      NewDomain_t;
    typedef NewDomain_t::SliceType_t SliceType_t;
    SliceType_t VD;
    AllDomain<1> A;
    Interval<1> I1(1,3);
    Range<1> R(0,4,2);
    NewDomain_t::fillSlice(VD, b.domain(), 2, R, 1, A, I1);

    tester.out() << "VD = " << VD << std::endl;

    typedef NewEngine<Brick5_t, SliceType_t>::Type_t Engine_t;
    Engine_t v(b, VD);

    // v.domain() should be:     [0:2:1,0:4:1,0:2:1]

    tester.out() << "v.domain()     = " << v.domain() << std::endl;

    // v's values should be 2 | 0,2,4 | 1 | 0,1,2,3,4 | 1,2,3

    tester.out() << "v = \n";
    for (int i2 = 0; i2 < v.domain()[2].length(); ++i2)
      for (int i1 = 0; i1 < v.domain()[1].length(); ++i1)
	for (int i0 = 0; i0 < v.domain()[0].length(); ++i0)
	  tester.out() << v(i0,i1,i2) << std::endl;
            
    typedef NewDomain3<int, Range<1>, Interval<1> > NewDomain2_t;
    typedef NewDomain2_t::SliceType_t SliceType2_t;
    SliceType2_t VD2;
    Interval<1> I2(1,2);
    Range<1> R2(0,2,2);
    NewDomain2_t::fillSlice(VD2, v.domain(), 0, R2, I2);

    tester.out() << "VD2 = " << VD2 << std::endl;

    NewEngine<Engine_t, SliceType2_t>::Type_t v2(v, VD2);

    // v2.domain() should be:     [0:1:1,0:1:1]
      
    tester.out() << "v2.domain()     = " << v2.domain() << std::endl;

    // v2's values should be 2 | 0 | 1 | 0,2 | 2,3

    tester.out() << "v2 = \n";
    for (int i1 = 0; i1 < v2.domain()[1].length(); ++i1)
      for (int i0 = 0; i0 < v2.domain()[0].length(); ++i0)
	tester.out() << v2(i0,i1) << std::endl;
#if POOMA_EXCEPTIONS
  }
  catch(const char *err) 
    { 
      tester.exceptionHandler( err );
      tester.set( false );
    }
  catch(const Pooma::Assertion &err)
    { 
      tester.exceptionHandler( err );
      tester.set( false );
    }
#endif    
  int ret = tester.results("brickview_test1");
  Pooma::finalize();
  return ret;
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: brickview_test1.cpp,v $   $Author: sa_smith $
// $Revision: 1.15 $   $Date: 2000/07/11 18:59:11 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
