

template<class Geometry, class T, class E, class Tag>
struct LeafFunctor<Field<Geometry, T, E>, EngineApply<Tag> >
{
  typedef Field<Geometry, T, E> Subject_t;
  typedef typename Subject_t::FieldEngine_t FieldEngine_t;
  typedef LeafFunctor<FieldEngine_t, EngineApply<Tag> > LeafFunctor_t;
  typedef typename LeafFunctor_t::Type_t Type_t;

  inline static
  Type_t apply(const Subject_t &field, 
	       const EngineApply<Tag> &tag)
    {
      return LeafFunctor_t::apply(field.fieldEngine(), tag);
    }
};

template<class Geometry, class T, class E, class Tag>
struct LeafFunctor<FieldEngine<Geometry, T, E>, EngineApply<Tag> >
{
  typedef FieldEngine<Geometry, T, E> Subject_t;
  typedef typename Subject_t::Engine_t Engine_t;
  typedef LeafFunctor<Engine_t, EngineApply<Tag> > LeafFunctor_t;
  typedef typename LeafFunctor_t::Type_t Type_t;

  inline static
  Type_t apply(const Subject_t &fieldEngine, 
	       const EngineApply<Tag> &tag)
    {
      return LeafFunctor_t::apply(fieldEngine.engine(), tag);
    }
};

