// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// ParticleBCList method implementations.
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Include Files
//-----------------------------------------------------------------------------

#include "Particles/ParticleBCList.h"

//-----------------------------------------------------------------------------
// Constructor.
// ParticleBCList just has a default constructor; it initially has
// no ParticleBCs at all.
//-----------------------------------------------------------------------------

ParticleBCList::ParticleBCList()
{
}


//-----------------------------------------------------------------------------
// Copy Constructor.
// Copy contents of an existing ParticleBCList.
//-----------------------------------------------------------------------------

ParticleBCList::ParticleBCList(const ParticleBCList& model)
{
  // copy the BC list.
  Size_t i, n = model.bcList_m.size();
  bcList_m.reserve(n);
  for (i=0; i<n; ++i)
    bcList_m.push_back(model.bcList_m[i]);
}

//-----------------------------------------------------------------------------
// Destructor.
// ParticleBCList will delete all ParticleBCs that it owns when
// it is deleted.
//-----------------------------------------------------------------------------

ParticleBCList::~ParticleBCList()
{
  while (size() > 0)
    removeBC(size() - 1);
}


//-----------------------------------------------------------------------------
// Remove the ith ParticleBC from our list, deleting it in the process.
//-----------------------------------------------------------------------------

void ParticleBCList::removeBC(Size_t i)
{
  PAssert(i < bcList_m.size());
  delete bcList_m[i];
  bcList_m.erase(bcList_m.begin() + i);
  return;
}


//-----------------------------------------------------------------------------
// Print the ParticleBCList to the given ostream.
//-----------------------------------------------------------------------------

void ParticleBCList::print(std::ostream& o) const
{
  Size_t n = size();

  for (Size_t i = 0; i < n; ++i)
    bcList_m[i]->print(o);
	return;
}


// operator<< for ostream and ParticleBCList

std::ostream&
operator<<(std::ostream& o, const ParticleBCList& bcList)
{
  bcList.print(o);
  return o;
}


// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: ParticleBCList.cmpl.cpp,v $   $Author: swhaney $
// $Revision: 1.4 $   $Date: 2000/03/07 13:17:49 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
