// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license
//-----------------------------------------------------------------------------
// Classes:
// View1<Object,Domain>
// View2<Object,Domain1,Domain2>
// ...
// View7<Object,Domain1,...,Domain7>
// ComponentView[2-7]<Object>
//-----------------------------------------------------------------------------

#ifndef POOMA_POOMA_VIEW_H
#define POOMA_POOMA_VIEW_H

//-----------------------------------------------------------------------------
// Overview: 
//
// View1<Object,Domain>::Type_t is defined for several Pooma objects, and
// tells you the type of a(b).  You should be able to write code like:
//
// A a;
// B b;
// typename View1<A,B>::Type_t c = a(b);
//
// ViewN will also give the type for the read() member function in arrays
// and fields.
//
// To define the view properties for a new class, you should specialize
// View for that class.  Reliance on the partial specialization ordering
// rules for more than one argument is a very bad thing, so never define
// View for a particular domain and general A.  (It will be common for
// us to define View for general domains with a particular A, so
// specializations with general A would also require complete specializations
// in order to avoid ambiguity.)
//
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// View0 enables you to write:
//
// A a;
// typename View0<A>::Type_t c = a();
//-----------------------------------------------------------------------------

template<class Thing>
struct View0
{
};

//-----------------------------------------------------------------------------
// View1 enables you to write:
//
// A a;
// B b;
// typename View1<A,B>::Type_t c = a(b);
//-----------------------------------------------------------------------------

template<class Thing, class Sub>
struct View1
{
};

//-----------------------------------------------------------------------------
// View2 enables you to write:
//
// A a;
// B b;
// C c;
// typename View2<A,B,C>::Type_t d = a(b,c);
//-----------------------------------------------------------------------------

template<class Thing, class Sub1, class Sub2>
struct View2
{
};

//-----------------------------------------------------------------------------
// View3 enables you to write:
//
// A a;
// B b;
// C c;
// D d;
// typename View2<A,B,C,D>::Type_t e = a(b,c,d);
//-----------------------------------------------------------------------------

template<class Thing, class Sub1, class Sub2, class Sub3>
struct View3
{
};

//-----------------------------------------------------------------------------
// View4 enables you to write:
//
// A a;
// B b;
// C c;
// D d;
// E e;
// typename View2<A,B,C,D,E>::Type_t thing = a(b,c,d,e);
//-----------------------------------------------------------------------------

template<class Thing, class Sub1, class Sub2, class Sub3, class Sub4>
struct View4
{
};

//-----------------------------------------------------------------------------
// View5 enables you to write:
//
// A a;
// B b;
// C c;
// D d;
// E e;
// F f;
// typename View5<A,B,C,D,E,F>::Type_t thing = a(b,c,d,e,f);
//-----------------------------------------------------------------------------

template<class Thing, class Sub1, class Sub2, class Sub3, class Sub4,
  class Sub5>
struct View5
{
};

//-----------------------------------------------------------------------------
// View6 enables you to write:
//
// A a;
// B b;
// C c;
// D d;
// E e;
// F f;
// G g;
// typename View6<A,B,C,D,E,F,G>::Type_t thing = a(b,c,d,e,f,g);
//-----------------------------------------------------------------------------

template<class Thing, class Sub1, class Sub2, class Sub3, class Sub4,
  class Sub5, class Sub6>
struct View6
{
};

//-----------------------------------------------------------------------------
// View7 enables you to write:
//
// A a;
// B b;
// C c;
// D d;
// E e;
// F f;
// G g;
// H h;
// typename View7<A,B,C,D,E,F,G,H>::Type_t thing = a(b,c,d,e,f,g,h);
//-----------------------------------------------------------------------------

template<class Thing, class Sub1, class Sub2, class Sub3, class Sub4,
  class Sub5, class Sub6, class Sub7>
struct View7
{
};

//-----------------------------------------------------------------------------
// Overview: 
//
// ComponentView<Components, Object>::Type_t is defined for several POOMA objects.
// It tells you the type of a.comp(b).  You should be able to write code like:
//
// A a;
// typename ComponentView<Loc<1>, A>::Type_t c = a.comp(i);
// typename ComponentView<Loc<2>, A>::Type_t c = a.comp(i, j);
//
// The number gives the number of components you are applying.
//
// To define the view properties for a new class, you should specialize
// ComponentView for that class.
//
//-----------------------------------------------------------------------------

template<class Components, class Object>
struct ComponentView;

#endif     // POOMA_POOMA_VIEW_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: View.h,v $   $Author: swhaney $
// $Revision: 1.10 $   $Date: 2000/03/07 13:18:04 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
