// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No.  W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE, and to allow others to do so.
// The public may copy and use this SOFTWARE, FOR NONCOMMERCIAL USE ONLY,
// without charge, provided that this Notice and any statement of
// authorship are reproduced on all copies.  Neither the Government nor
// the University makes any warranty, express or implied, or assumes any
// liability or responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// Function:
// min(Array<D,T,E>, Array<D,T,E>)
//-----------------------------------------------------------------------------

#ifndef POOMA_ARRAY_ARRAYOPERATORSPECIALIZATIONS_H
#define POOMA_ARRAY_ARRAYOPERATORSPECIALIZATIONS_H

//-----------------------------------------------------------------------------
// Overview: 
//
// The STL defines min() and max() functions with signatures
// template<class T> T min(T,T);
// If you generate a scope that includes both the std:: namespace,
// and the namespace containing the Pooma versions of min() and max(),
// then min(Array<1>,Array<1>) is ambiguous.  These specializations
// disambiguate this common case.
//
//-----------------------------------------------------------------------------

template<int D1,class T1,class E1>
inline typename MakeReturn<BinaryNode<FnMin,
  typename CreateLeaf<Array<D1,T1,E1> >::Leaf_t,
  typename CreateLeaf<Array<D1,T1,E1> >::Leaf_t> >::Expression_t
min(const Array<D1,T1,E1> & l,const Array<D1,T1,E1> & r)
{
  typedef BinaryNode<FnMin,
    typename CreateLeaf<Array<D1,T1,E1> >::Leaf_t,
    typename CreateLeaf<Array<D1,T1,E1> >::Leaf_t> Tree_t;
  return MakeReturn<Tree_t>::make(Tree_t(
    CreateLeaf<Array<D1,T1,E1> >::make(l),
    CreateLeaf<Array<D1,T1,E1> >::make(r)));
}

template<int D1,class T1,class E1>
inline typename MakeReturn<BinaryNode<FnMax,
  typename CreateLeaf<Array<D1,T1,E1> >::Leaf_t,
  typename CreateLeaf<Array<D1,T1,E1> >::Leaf_t> >::Expression_t
max(const Array<D1,T1,E1> & l,const Array<D1,T1,E1> & r)
{
  typedef BinaryNode<FnMax,
    typename CreateLeaf<Array<D1,T1,E1> >::Leaf_t,
    typename CreateLeaf<Array<D1,T1,E1> >::Leaf_t> Tree_t;
  return MakeReturn<Tree_t>::make(Tree_t(
    CreateLeaf<Array<D1,T1,E1> >::make(l),
    CreateLeaf<Array<D1,T1,E1> >::make(r)));
}

#endif     // POOMA_ARRAY_ARRAYOPERATORSPECIALIZATIONS_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: ArrayOperatorSpecializations.h,v $   $Author: swhaney $
// $Revision: 1.2 $   $Date: 2000/07/20 15:36:24 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
