// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license
//-----------------------------------------------------------------------------
// SparseTileLayout test: Create and use SparseTileLayout objects
//-----------------------------------------------------------------------------
#include "Pooma/Pooma.h"
#include "Pooma/Domains.h"
#include "Utilities/Tester.h"
#include <iostream>
#include <iterator>

template <int Dim> 
std::vector<Interval<Dim> >
DomainRemoveOverlap(const Interval<Dim> & s,const Interval<Dim> &r)
{
  typedef Interval<Dim>         Domain_t;
  typedef std::vector<Domain_t> DomainList_t;

  DomainList_t result,temp;

  result.push_back(s);

  for (int i=0;i<Dim;++i)
    {
      DomainList_t::iterator start = result.begin();
      DomainList_t::iterator end = result.end();
      for ( ; start!=end; ++start)
	{ 
	  if (touches( (*start)[i], Loc<1>(r[i].min())))
	    {
	      Domain_t lower=*start,upper=*start;
	      if(r[i].min()-1>=lower[i].min())
		{
		  lower[i] = Interval<1>(lower[i].min(),r[i].min()-1);
		  temp.push_back(lower);
		}	      upper[i] = Interval<1>(r[i].min(),upper[i].max());
	
	      temp.push_back(upper);
	    }
	  else 
	    temp.push_back(*start);
	}
      result = temp;
      temp.clear();
      
      start = result.begin();
      end = result.end();
      for ( ; start!=end; ++start)
	{ 
	  if (touches( (*start)[i], Loc<1>(r[i].max())))
	    {
	      Domain_t lower=*start,upper=*start;
	      lower[i] = Interval<1>(lower[i].min(),r[i].max());
	      temp.push_back(lower);
	      if( r[i].max()+1 <= upper[i].max())
		{
		  upper[i] = Interval<1>(r[i].max()+1,upper[i].max());
		  temp.push_back(upper);
		}
	    }
	  else
	    temp.push_back(*start);
	}
      result=temp;
      temp.clear();
    }
  
  DomainList_t::iterator start = result.begin();
  DomainList_t::iterator end = result.end();
  for ( ; start!=end ; ++start)
    {
      if (!touches(*start,r ) ) 
	temp.push_back(*start);
    }
  return temp;
}
