//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that it is illegal to use a formal function argument
// as part of a default expression for the same function
// declaration.
//
// Cases:
//	global functions
//	member functions
//
// Cases:
//	earlier parameters
//	later parameters

void function_1 (int i = 27, int j = i);		// ERROR
void function_2 (int k = l, int l = 99);		// ERROR

struct base {
	int data_member;

	void member_function_1 (int i = 27, int j = i);		// ERROR
	void member_function_2 (int k = l, int l = 99);		// ERROR
};
