//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that type float parameters can be correctly passed to
// methods.

class tres_floats {
	float ff1;
	float ff2;
	float ff3;
public:
	tres_floats (float f1, float f2, float f3);
	float get_f1 ();
	float get_f2 ();
	float get_f3 ();
};

float v1 = 1.2345;
float v2 = 3.14159;
float v3 = 0.707;

int main ()
{
	tres_floats tf (v1, v2, v3);

	return ((tf.get_f1() != v1) || (tf.get_f2() != v2) || (tf.get_f3() != v3));
}

tres_floats::tres_floats (float f1, float f2, float f3)
{
	ff1 = f1;
	ff2 = f2;
	ff3 = f3;
}

float tres_floats::get_f1 ()
{
	return ff1;
}

float tres_floats::get_f2 ()
{
	return ff2;
}

float tres_floats::get_f3 ()
{
	return ff3;
}
