// PR java/18036

public class ExtraClassLoader extends ClassLoader
{
  public static void main(String args[]) throws Exception
  {
    ClassLoader loader = new ExtraClassLoader();
    Class c = Class.forName("C", false, loader);
    Object o = c.newInstance();
    System.out.println(o.getClass() == c);
    System.out.println(c.getClassLoader() == loader);
  }

  public Class findClass(String name) throws ClassNotFoundException
  {
    return defineClass("C", Cbytes, 0, Cbytes.length);
  }

 /*
  * Generated by compiling the following program with gcj -C C.java:
  *
  * public class C
  * {
  *   public C() throws ClassNotFoundException
  *   {
  *     System.out.println(getClass() == Class.forName("C"));
  *   }
  * }
  *
  * And then processing the byte code as follows:
  * od -w1000 -An -td1 C.class | sed "s/\ \+/,/g"
  */
  private static byte[] Cbytes = new byte[] {
-54,-2,-70,-66,0,3,0,45,0,39,1,0,1,67,7,0,1,1,0,16,106,97,118,97,47,108,97,110,103,47,79,98,106,101,99,116,7,0,3,1,0,6,60,105,110,105,116,62,1,0,3,40,41,86,1,0,4,67,111,100,101,12,0,5,0,6,10,0,4,0,8,1,0,16,106,97,118,97,47,108,97,110,103,47,83,121,115,116,101,109,7,0,10,1,0,3,111,117,116,1,0,21,76,106,97,118,97,47,105,111,47,80,114,105,110,116,83,116,114,101,97,109,59,12,0,12,0,13,9,0,11,0,14,1,0,8,103,101,116,67,108,97,115,115,1,0,19,40,41,76,106,97,118,97,47,108,97,110,103,47,67,108,97,115,115,59,12,0,16,0,17,10,0,4,0,18,8,0,1,1,0,15,106,97,118,97,47,108,97,110,103,47,67,108,97,115,115,7,0,21,1,0,7,102,111,114,78,97,109,101,1,0,37,40,76,106,97,118,97,47,108,97,110,103,47,83,116,114,105,110,103,59,41,76,106,97,118,97,47,108,97,110,103,47,67,108,97,115,115,59,12,0,23,0,24,10,0,22,0,25,1,0,19,106,97,118,97,47,105,111,47,80,114,105,110,116,83,116,114,101,97,109,7,0,27,1,0,7,112,114,105,110,116,108,110,1,0,4,40,90,41,86,12,0,29,0,30,10,0,28,0,31,1,0,15,76,105,110,101,78,117,109,98,101,114,84,97,98,108,101,1,0,10,69,120,99,101,112,116,105,111,110,115,1,0,32,106,97,118,97,47,108,97,110,103,47,67,108,97,115,115,78,111,116,70,111,117,110,100,69,120,99,101,112,116,105,111,110,7,0,35,1,0,10,83,111,117,114,99,101,70,105,108,101,1,0,6,67,46,106,97,118,97,0,33,0,2,0,4,0,0,0,0,0,1,0,1,0,5,0,6,0,2,0,7,0,0,0,52,0,3,0,1,0,0,0,28,42,-73,0,9,-78,0,15,42,-74,0,19,18,20,-72,0,26,-90,0,7,4,-89,0,4,3,-74,0,32,-79,0,0,0,1,0,33,0,0,0,6,0,1,0,4,0,5,0,34,0,0,0,4,0,1,0,36,0,1,0,37,0,0,0,2,0,38
  };
}
