/*
 *  $Header: /Ski/libdas.h 1.4 1997/09/09 19:10:17 morrell Rel $
 *
 *  Tahoe Disassembly Library Header
 *
 *  Copyright (c) 1996-1997
 *  Systems Architecture & Design Lab
 *  The Hewlett-Packard Company
 *  Palo Alto, California
 *
 *  *** HP Confidential ***
 */

/*
 * The user of this library must provide two functions:
 *     dasAddress and symAddrtoName
 *
 *  The prototype for dasAddress is:
 *     unsigned long long dasAddress(void)
 *
 *  Its purpose is to return the current disassembly address for use by
 *  instructions which have an ip-relative source (target25 or tag13)
 *
 *  The prototype for symAddrtoName is:
 *     void symAddrtoName(unsigned long long adr, char sname[],
 *                        int rmdr, int add0x, int width)
 *
 *  Its purpose is to fill in sname with a string of the form "sym+hexoffset"
 *  where the value of the symbol "sym" plus the "hexoffset" is equal to the
 *  passed address.  The rmdr argument specifies how "far" the address can be
 *  from the closest symbol and must be >= 0, the add0x argument specifies
 *  whether to add a leading 0x to the hexoffset, and the width argument
 *  specifies the desired width of the generated string (a negative value
 *  means that the result should not be padded but should be truncated to
 *  -width characters).  The symbol chosen should be the symbol whose value
 *  is the greatest value less than or equal to adr that satisfies:
 *            symbol <= adr < symbol + (1 << rmdr*4)
 *  (so rmdr represents the number of hex digits used in "sym+0x0010").
 *
 *  It is called for instructions which have an ip-relative source as
 *     symAddrtoName(adr, name, 4, 1, -40)
 *
 *  and by the movl instruction as
 *     symAddrtoName(adr, name, 0, 1, -40)
 *  which says to use only an exact match for the 64-bit immediate.
 */

#ifndef _DECODER_H
typedef struct bundle {
    unsigned long long left, right;
} Bundle;
#endif
#define MAX_DAS_LEN	80

typedef enum {
    DasNoOpts,			/* no options */
    DasTemplate = 0x1,		/* include template type in i0Str */
    DasTemplateComment = 0x3,	/* include template type as comment */
    DasSepStopLines = 0x4,	/* put ";;" (stop bits) on separate lines */
    DasPseudoOps = 0x8,		/* check for pseudo-ops */
    DasSpaceOperands = 0x10	/* space-separate operands */
} DasOptions;

#define dasBundle(bndl, i0Str, i1Str, i2Str) \
		dasBundleSB(bndl, i0Str, i1Str, i2Str, 0)

void dasInit(DasOptions opts, int width);
void dasBundleSB(Bundle *bndl, char *i0Str, char *i1Str, char *i2Str,
		 Bundle *SB);
char *hexBundle(Bundle *bndl, char *str);
#if 0
char *dasInst(Unit unit, unsigned long long instBits,
	      unsigned long long extraInstBits, char *iStr);
#endif
unsigned int bundleTargets(Bundle *bndl, unsigned long long tgtAdr[]);
