/* ia64-opc-m.c -- IA-64 `M' opcode table.
   Copyright (C) 1998, 1999 Free Software Foundation, Inc.
   Contributed by David Mosberger-Tang <davidm@hpl.hp.com>

   This file is part of GDB, GAS, and the GNU binutils.

   GDB, GAS, and the GNU binutils are free software; you can redistribute
   them and/or modify them under the terms of the GNU General Public
   License as published by the Free Software Foundation; either version
   2, or (at your option) any later version.

   GDB, GAS, and the GNU binutils are distributed in the hope that they
   will be useful, but WITHOUT ANY WARRANTY; without even the implied
   warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
   the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this file; see the file COPYING.  If not, write to the
   Free Software Foundation, 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  */

#include "ia64-opc.h"

#define M0	IA64_TYPE_M, 0
#define M	IA64_TYPE_M, 1
#define M2	IA64_TYPE_M, 2

/* instruction bit fields: */
#define bM(x)		(((ia64_insn) ((x) & 0x1)) << 36)
#define bX(x)		(((ia64_insn) ((x) & 0x1)) << 27)
#define bX2(x)		(((ia64_insn) ((x) & 0x3)) << 31)
#define bX3(x)		(((ia64_insn) ((x) & 0x7)) << 33)
#define bX4(x)		(((ia64_insn) ((x) & 0xf)) << 27)
#define bX6a(x)		(((ia64_insn) ((x) & 0x3f)) << 30)
#define bX6b(x)		(((ia64_insn) ((x) & 0x3f)) << 27)
#define bHint(x)	(((ia64_insn) ((x) & 0x3)) << 28)

#define mM	bM (-1)
#define mX	bX (-1)
#define mX2	bX2 (-1)
#define mX3	bX3 (-1)
#define mX4	bX4 (-1)
#define mX6a	bX6a (-1)
#define mX6b	bX6b (-1)
#define mHint	bHint (-1)

#define OpX3(a,b) 		(bOp (a) | bX3 (b)), (mOp | mX3)
#define OpX3X6b(a,b,c) 		(bOp (a) | bX3 (b) | bX6b (c)), \
				(mOp | mX3 | mX6b)
#define OpX3X4(a,b,c)	 	(bOp (a) | bX3 (b) | bX4 (c)), \
				(mOp | mX3 | mX4)
#define OpX3X4X2(a,b,c,d) 	(bOp (a) | bX3 (b) | bX4 (c) | bX2 (d)), \
				(mOp | mX3 | mX4 | mX2)
#define OpX6aHint(a,b,c) 	(bOp (a) | bX6a (b) | bHint (c)), \
				(mOp | mX6a | mHint)
#define OpXX6aHint(a,b,c,d) 	(bOp (a) | bX (b) | bX6a (c) | bHint (d)), \
				(mOp | mX | mX6a | mHint)
#define OpMXX6a(a,b,c,d) \
	(bOp (a) | bM (b) | bX (c) | bX6a (d)), (mOp | mM | mX | mX6a)
#define OpMXX6aHint(a,b,c,d,e) \
	(bOp (a) | bM (b) | bX (c) | bX6a (d) | bHint (e)), \
	(mOp | mM | mX | mX6a | mHint)

struct ia64_opcode ia64_opcodes_m[] =
  {
    /* M-type instruction encodings (sorted according to major opcode) */

    {"chk.a.nc",	M0, OpX3 (0, 4), {R1, TGT25c}},
    {"chk.a.clr",	M0, OpX3 (0, 5), {R1, TGT25c}},
    {"chk.a.nc",	M0, OpX3 (0, 6), {F1, TGT25c}},
    {"chk.a.clr",	M0, OpX3 (0, 7), {F1, TGT25c}},

    {"invala",		M0, OpX3X4X2 (0, 0, 0, 1)},
    {"fwb",		M0, OpX3X4X2 (0, 0, 0, 2)},
    {"mf",		M0, OpX3X4X2 (0, 0, 2, 2)},
    {"mf.a",		M0, OpX3X4X2 (0, 0, 3, 2)},
    {"srlz.d",		M0, OpX3X4X2 (0, 0, 0, 3)},
    {"srlz.i",		M0, OpX3X4X2 (0, 0, 1, 3)},
    {"sync.i",		M0, OpX3X4X2 (0, 0, 3, 3)},
    {"flushrs",		M0, OpX3X4X2 (0, 0, 0xc, 0), {0, }, FIRST | NO_PRED},
    {"loadrs",		M0, OpX3X4X2 (0, 0, 0xa, 0), {0, }, FIRST | NO_PRED},
    {"invala.e",	M0, OpX3X4X2 (0, 0, 2, 1), {R1}},
    {"invala.e",	M0, OpX3X4X2 (0, 0, 3, 1), {F1}},
    {"mov.m",		M, OpX3X4X2 (0, 0, 8, 2), {AR3, IMM8}},

    {"break.m",		M0, OpX3X4X2 (0, 0, 0, 0), {IMMU21}},
    {"nop.m",		M0, OpX3X4X2 (0, 0, 1, 0), {IMMU21}},

    {"sum",		M0, OpX3X4 (0, 0, 4), {IMMU24}},
    {"rum",		M0, OpX3X4 (0, 0, 5), {IMMU24}},
    {"ssm",		M0, OpX3X4 (0, 0, 6), {IMMU24}, PRIV},
    {"rsm",		M0, OpX3X4 (0, 0, 7), {IMMU24}, PRIV},

    {"mov.m",	M, OpX3X6b (1, 0, 0x2a), {AR3, R2}},
    {"mov.m",	M, OpX3X6b (1, 0, 0x22), {R1, AR3}},
    {"mov",	M, OpX3X6b (1, 0, 0x2c), {CR3, R2}, PRIV},
    {"mov",	M, OpX3X6b (1, 0, 0x24), {R1, CR3}, PRIV},

    {"alloc",	M, OpX3 (1, 6), {R1, AR_PFS, SOF, SOL, SOR}, FIRST|NO_PRED|MOD_RRBS},

    {"mov",	M, OpX3X6b (1, 0, 0x2d), {PSR_L, R2}, PRIV},
    {"mov",	M, OpX3X6b (1, 0, 0x29), {PSR_UM, R2}},
    {"mov",	M, OpX3X6b (1, 0, 0x25), {R1, PSR}, PRIV},
    {"mov",	M, OpX3X6b (1, 0, 0x21), {R1, PSR_UM}},
    {"probe.r",	M, OpX3X6b (1, 0, 0x38), {R1, R3, R2}},
    {"probe.w",	M, OpX3X6b (1, 0, 0x39), {R1, R3, R2}},
    {"probe.r", M, OpX3X6b (1, 0, 0x18), {R1, R3, IMMU2}},
    {"probe.w", M, OpX3X6b (1, 0, 0x19), {R1, R3, IMMU2}},
    {"probe.rw.fault", M0, OpX3X6b (1, 0, 0x31), {R3, IMMU2}},
    {"probe.r.fault",  M0, OpX3X6b (1, 0, 0x32), {R3, IMMU2}},
    {"probe.w.fault",  M0, OpX3X6b (1, 0, 0x33), {R3, IMMU2}},
    {"itc.d",	M0, OpX3X6b (1, 0, 0x2e), {R2}, LAST | PRIV},
    {"itc.i",	M0, OpX3X6b (1, 0, 0x2f), {R2}, LAST | PRIV},

    {"mov",	M, OpX3X6b (1, 0, 0x00), {RR_R3, R2}, PRIV},
    {"mov",	M, OpX3X6b (1, 0, 0x01), {DBR_R3, R2}, PRIV},
    {"mov",	M, OpX3X6b (1, 0, 0x02), {IBR_R3, R2}, PRIV},
    {"mov",	M, OpX3X6b (1, 0, 0x03), {PKR_R3, R2}, PRIV},
    {"mov",	M, OpX3X6b (1, 0, 0x04), {PMC_R3, R2}, PRIV},
    {"mov",	M, OpX3X6b (1, 0, 0x05), {PMD_R3, R2}, PRIV},
    {"mov",	M, OpX3X6b (1, 0, 0x06), {MSR_R3, R2}, PRIV},
    {"itr.d",	M, OpX3X6b (1, 0, 0x0e), {DTR_R3, R2}, PRIV},
    {"itr.i",	M, OpX3X6b (1, 0, 0x0f), {ITR_R3, R2}, PRIV},

    {"mov",	M, OpX3X6b (1, 0, 0x10), {R1, RR_R3}, PRIV},
    {"mov",	M, OpX3X6b (1, 0, 0x11), {R1, DBR_R3}, PRIV},
    {"mov",	M, OpX3X6b (1, 0, 0x12), {R1, IBR_R3}, PRIV},
    {"mov",	M, OpX3X6b (1, 0, 0x13), {R1, PKR_R3}, PRIV},
    {"mov",	M, OpX3X6b (1, 0, 0x14), {R1, PMC_R3}, PRIV},
    {"mov",	M, OpX3X6b (1, 0, 0x15), {R1, PMD_R3}},
    {"mov",	M, OpX3X6b (1, 0, 0x16), {R1, MSR_R3}, PRIV},
    {"mov",	M, OpX3X6b (1, 0, 0x17), {R1, CPUID_R3}},

    {"ptc.l",	M0, OpX3X6b (1, 0, 0x09), {R3, R2}, PRIV},
    {"ptc.g",	M0, OpX3X6b (1, 0, 0x0a), {R3, R2}, LAST | PRIV},
    {"ptc.ga",	M0, OpX3X6b (1, 0, 0x0b), {R3, R2}, LAST | PRIV},
    {"ptr.d",	M0, OpX3X6b (1, 0, 0x0c), {R3, R2}, PRIV},
    {"ptr.i",	M0, OpX3X6b (1, 0, 0x0d), {R3, R2}, PRIV},

    {"thash",	M, OpX3X6b (1, 0, 0x1a), {R1, R3}},
    {"ttag",	M, OpX3X6b (1, 0, 0x1b), {R1, R3}},
    {"tpa",	M, OpX3X6b (1, 0, 0x1e), {R1, R3}, PRIV},
    {"tak",	M, OpX3X6b (1, 0, 0x1f), {R1, R3}, PRIV},

    {"chk.s.m",	M0, OpX3 (1, 1), {R2, TGT25b}},
    {"chk.s",	M0, OpX3 (1, 3), {F2, TGT25b}},

    {"fc",	M0, OpX3X6b (1, 0, 0x30), {R3}},
    {"ptc.e",	M0, OpX3X6b (1, 0, 0x34), {R3}, PRIV},

    /* integer load */
    {"ld1",		M, OpMXX6aHint (4, 0, 0, 0x00, 0), {R1, MR3}},
    {"ld1.nt1",		M, OpMXX6aHint (4, 0, 0, 0x00, 1), {R1, MR3}},
    {"ld1.nta",		M, OpMXX6aHint (4, 0, 0, 0x00, 3), {R1, MR3}},
    {"ld2",		M, OpMXX6aHint (4, 0, 0, 0x01, 0), {R1, MR3}},
    {"ld2.nt1",		M, OpMXX6aHint (4, 0, 0, 0x01, 1), {R1, MR3}},
    {"ld2.nta",		M, OpMXX6aHint (4, 0, 0, 0x01, 3), {R1, MR3}},
    {"ld4",		M, OpMXX6aHint (4, 0, 0, 0x02, 0), {R1, MR3}},
    {"ld4.nt1",		M, OpMXX6aHint (4, 0, 0, 0x02, 1), {R1, MR3}},
    {"ld4.nta",		M, OpMXX6aHint (4, 0, 0, 0x02, 3), {R1, MR3}},
    {"ld8",		M, OpMXX6aHint (4, 0, 0, 0x03, 0), {R1, MR3}},
    {"ld8.nt1",		M, OpMXX6aHint (4, 0, 0, 0x03, 1), {R1, MR3}},
    {"ld8.nta",		M, OpMXX6aHint (4, 0, 0, 0x03, 3), {R1, MR3}},
    {"ld1.s",		M, OpMXX6aHint (4, 0, 0, 0x04, 0), {R1, MR3}},
    {"ld1.s.nt1",	M, OpMXX6aHint (4, 0, 0, 0x04, 1), {R1, MR3}},
    {"ld1.s.nta",	M, OpMXX6aHint (4, 0, 0, 0x04, 3), {R1, MR3}},
    {"ld2.s",		M, OpMXX6aHint (4, 0, 0, 0x05, 0), {R1, MR3}},
    {"ld2.s.nt1",	M, OpMXX6aHint (4, 0, 0, 0x05, 1), {R1, MR3}},
    {"ld2.s.nta",	M, OpMXX6aHint (4, 0, 0, 0x05, 3), {R1, MR3}},
    {"ld4.s",		M, OpMXX6aHint (4, 0, 0, 0x06, 0), {R1, MR3}},
    {"ld4.s.nt1",	M, OpMXX6aHint (4, 0, 0, 0x06, 1), {R1, MR3}},
    {"ld4.s.nta",	M, OpMXX6aHint (4, 0, 0, 0x06, 3), {R1, MR3}},
    {"ld8.s",		M, OpMXX6aHint (4, 0, 0, 0x07, 0), {R1, MR3}},
    {"ld8.s.nt1",	M, OpMXX6aHint (4, 0, 0, 0x07, 1), {R1, MR3}},
    {"ld8.s.nta",	M, OpMXX6aHint (4, 0, 0, 0x07, 3), {R1, MR3}},
    {"ld1.a",		M, OpMXX6aHint (4, 0, 0, 0x08, 0), {R1, MR3}},
    {"ld1.a.nt1",	M, OpMXX6aHint (4, 0, 0, 0x08, 1), {R1, MR3}},
    {"ld1.a.nta",	M, OpMXX6aHint (4, 0, 0, 0x08, 3), {R1, MR3}},
    {"ld2.a",		M, OpMXX6aHint (4, 0, 0, 0x09, 0), {R1, MR3}},
    {"ld2.a.nt1",	M, OpMXX6aHint (4, 0, 0, 0x09, 1), {R1, MR3}},
    {"ld2.a.nta",	M, OpMXX6aHint (4, 0, 0, 0x09, 3), {R1, MR3}},
    {"ld4.a",		M, OpMXX6aHint (4, 0, 0, 0x0a, 0), {R1, MR3}},
    {"ld4.a.nt1",	M, OpMXX6aHint (4, 0, 0, 0x0a, 1), {R1, MR3}},
    {"ld4.a.nta",	M, OpMXX6aHint (4, 0, 0, 0x0a, 3), {R1, MR3}},
    {"ld8.a",		M, OpMXX6aHint (4, 0, 0, 0x0b, 0), {R1, MR3}},
    {"ld8.a.nt1",	M, OpMXX6aHint (4, 0, 0, 0x0b, 1), {R1, MR3}},
    {"ld8.a.nta",	M, OpMXX6aHint (4, 0, 0, 0x0b, 3), {R1, MR3}},
    {"ld1.sa",		M, OpMXX6aHint (4, 0, 0, 0x0c, 0), {R1, MR3}},
    {"ld1.sa.nt1",	M, OpMXX6aHint (4, 0, 0, 0x0c, 1), {R1, MR3}},
    {"ld1.sa.nta",	M, OpMXX6aHint (4, 0, 0, 0x0c, 3), {R1, MR3}},
    {"ld2.sa",		M, OpMXX6aHint (4, 0, 0, 0x0d, 0), {R1, MR3}},
    {"ld2.sa.nt1",	M, OpMXX6aHint (4, 0, 0, 0x0d, 1), {R1, MR3}},
    {"ld2.sa.nta",	M, OpMXX6aHint (4, 0, 0, 0x0d, 3), {R1, MR3}},
    {"ld4.sa",		M, OpMXX6aHint (4, 0, 0, 0x0e, 0), {R1, MR3}},
    {"ld4.sa.nt1",	M, OpMXX6aHint (4, 0, 0, 0x0e, 1), {R1, MR3}},
    {"ld4.sa.nta",	M, OpMXX6aHint (4, 0, 0, 0x0e, 3), {R1, MR3}},
    {"ld8.sa",		M, OpMXX6aHint (4, 0, 0, 0x0f, 0), {R1, MR3}},
    {"ld8.sa.nt1",	M, OpMXX6aHint (4, 0, 0, 0x0f, 1), {R1, MR3}},
    {"ld8.sa.nta",	M, OpMXX6aHint (4, 0, 0, 0x0f, 3), {R1, MR3}},
    {"ld1.bias",	M, OpMXX6aHint (4, 0, 0, 0x10, 0), {R1, MR3}},
    {"ld1.bias.nt1",	M, OpMXX6aHint (4, 0, 0, 0x10, 1), {R1, MR3}},
    {"ld1.bias.nta",	M, OpMXX6aHint (4, 0, 0, 0x10, 3), {R1, MR3}},
    {"ld2.bias",	M, OpMXX6aHint (4, 0, 0, 0x11, 0), {R1, MR3}},
    {"ld2.bias.nt1",	M, OpMXX6aHint (4, 0, 0, 0x11, 1), {R1, MR3}},
    {"ld2.bias.nta",	M, OpMXX6aHint (4, 0, 0, 0x11, 3), {R1, MR3}},
    {"ld4.bias",	M, OpMXX6aHint (4, 0, 0, 0x12, 0), {R1, MR3}},
    {"ld4.bias.nt1",	M, OpMXX6aHint (4, 0, 0, 0x12, 1), {R1, MR3}},
    {"ld4.bias.nta",	M, OpMXX6aHint (4, 0, 0, 0x12, 3), {R1, MR3}},
    {"ld8.bias",	M, OpMXX6aHint (4, 0, 0, 0x13, 0), {R1, MR3}},
    {"ld8.bias.nt1",	M, OpMXX6aHint (4, 0, 0, 0x13, 1), {R1, MR3}},
    {"ld8.bias.nta",	M, OpMXX6aHint (4, 0, 0, 0x13, 3), {R1, MR3}},
    {"ld1.acq",		M, OpMXX6aHint (4, 0, 0, 0x14, 0), {R1, MR3}},
    {"ld1.acq.nt1",	M, OpMXX6aHint (4, 0, 0, 0x14, 1), {R1, MR3}},
    {"ld1.acq.nta",	M, OpMXX6aHint (4, 0, 0, 0x14, 3), {R1, MR3}},
    {"ld2.acq",		M, OpMXX6aHint (4, 0, 0, 0x15, 0), {R1, MR3}},
    {"ld2.acq.nt1",	M, OpMXX6aHint (4, 0, 0, 0x15, 1), {R1, MR3}},
    {"ld2.acq.nta",	M, OpMXX6aHint (4, 0, 0, 0x15, 3), {R1, MR3}},
    {"ld4.acq",		M, OpMXX6aHint (4, 0, 0, 0x16, 0), {R1, MR3}},
    {"ld4.acq.nt1",	M, OpMXX6aHint (4, 0, 0, 0x16, 1), {R1, MR3}},
    {"ld4.acq.nta",	M, OpMXX6aHint (4, 0, 0, 0x16, 3), {R1, MR3}},
    {"ld8.acq",		M, OpMXX6aHint (4, 0, 0, 0x17, 0), {R1, MR3}},
    {"ld8.acq.nt1",	M, OpMXX6aHint (4, 0, 0, 0x17, 1), {R1, MR3}},
    {"ld8.acq.nta",	M, OpMXX6aHint (4, 0, 0, 0x17, 3), {R1, MR3}},
    {"ld8.fill",	M, OpMXX6aHint (4, 0, 0, 0x1b, 0), {R1, MR3}},
    {"ld8.fill.nt1",	M, OpMXX6aHint (4, 0, 0, 0x1b, 1), {R1, MR3}},
    {"ld8.fill.nta",	M, OpMXX6aHint (4, 0, 0, 0x1b, 3), {R1, MR3}},
    {"ld1.c.clr",	M, OpMXX6aHint (4, 0, 0, 0x20, 0), {R1, MR3}},
    {"ld1.c.clr.nt1",	M, OpMXX6aHint (4, 0, 0, 0x20, 1), {R1, MR3}},
    {"ld1.c.clr.nta",	M, OpMXX6aHint (4, 0, 0, 0x20, 3), {R1, MR3}},
    {"ld2.c.clr",	M, OpMXX6aHint (4, 0, 0, 0x21, 0), {R1, MR3}},
    {"ld2.c.clr.nt1",	M, OpMXX6aHint (4, 0, 0, 0x21, 1), {R1, MR3}},
    {"ld2.c.clr.nta",	M, OpMXX6aHint (4, 0, 0, 0x21, 3), {R1, MR3}},
    {"ld4.c.clr",	M, OpMXX6aHint (4, 0, 0, 0x22, 0), {R1, MR3}},
    {"ld4.c.clr.nt1",	M, OpMXX6aHint (4, 0, 0, 0x22, 1), {R1, MR3}},
    {"ld4.c.clr.nta",	M, OpMXX6aHint (4, 0, 0, 0x22, 3), {R1, MR3}},
    {"ld8.c.clr",	M, OpMXX6aHint (4, 0, 0, 0x23, 0), {R1, MR3}},
    {"ld8.c.clr.nt1",	M, OpMXX6aHint (4, 0, 0, 0x23, 1), {R1, MR3}},
    {"ld8.c.clr.nta",	M, OpMXX6aHint (4, 0, 0, 0x23, 3), {R1, MR3}},
    {"ld1.c.nc",	M, OpMXX6aHint (4, 0, 0, 0x24, 0), {R1, MR3}},
    {"ld1.c.nc.nt1",	M, OpMXX6aHint (4, 0, 0, 0x24, 1), {R1, MR3}},
    {"ld1.c.nc.nta",	M, OpMXX6aHint (4, 0, 0, 0x24, 3), {R1, MR3}},
    {"ld2.c.nc",	M, OpMXX6aHint (4, 0, 0, 0x25, 0), {R1, MR3}},
    {"ld2.c.nc.nt1",	M, OpMXX6aHint (4, 0, 0, 0x25, 1), {R1, MR3}},
    {"ld2.c.nc.nta",	M, OpMXX6aHint (4, 0, 0, 0x25, 3), {R1, MR3}},
    {"ld4.c.nc",	M, OpMXX6aHint (4, 0, 0, 0x26, 0), {R1, MR3}},
    {"ld4.c.nc.nt1",	M, OpMXX6aHint (4, 0, 0, 0x26, 1), {R1, MR3}},
    {"ld4.c.nc.nta",	M, OpMXX6aHint (4, 0, 0, 0x26, 3), {R1, MR3}},
    {"ld8.c.nc",	M, OpMXX6aHint (4, 0, 0, 0x27, 0), {R1, MR3}},
    {"ld8.c.nc.nt1",	M, OpMXX6aHint (4, 0, 0, 0x27, 1), {R1, MR3}},
    {"ld8.c.nc.nta",	M, OpMXX6aHint (4, 0, 0, 0x27, 3), {R1, MR3}},
    {"ld1.c.clr.acq",	  M, OpMXX6aHint (4, 0, 0, 0x28, 0), {R1, MR3}},
    {"ld1.c.clr.acq.nt1", M, OpMXX6aHint (4, 0, 0, 0x28, 1), {R1, MR3}},
    {"ld1.c.clr.acq.nta", M, OpMXX6aHint (4, 0, 0, 0x28, 3), {R1, MR3}},
    {"ld2.c.clr.acq",	  M, OpMXX6aHint (4, 0, 0, 0x29, 0), {R1, MR3}},
    {"ld2.c.clr.acq.nt1", M, OpMXX6aHint (4, 0, 0, 0x29, 1), {R1, MR3}},
    {"ld2.c.clr.acq.nta", M, OpMXX6aHint (4, 0, 0, 0x29, 3), {R1, MR3}},
    {"ld4.c.clr.acq",	  M, OpMXX6aHint (4, 0, 0, 0x2a, 0), {R1, MR3}},
    {"ld4.c.clr.acq.nt1", M, OpMXX6aHint (4, 0, 0, 0x2a, 1), {R1, MR3}},
    {"ld4.c.clr.acq.nta", M, OpMXX6aHint (4, 0, 0, 0x2a, 3), {R1, MR3}},
    {"ld8.c.clr.acq",	  M, OpMXX6aHint (4, 0, 0, 0x2b, 0), {R1, MR3}},
    {"ld8.c.clr.acq.nt1", M, OpMXX6aHint (4, 0, 0, 0x2b, 1), {R1, MR3}},
    {"ld8.c.clr.acq.nta", M, OpMXX6aHint (4, 0, 0, 0x2b, 3), {R1, MR3}},

    /* integer load w/increment by register */
    {"ld1",		M, OpMXX6aHint (4, 1, 0, 0x00, 0), {R1, MR3, R2}},
    {"ld1.nt1",		M, OpMXX6aHint (4, 1, 0, 0x00, 1), {R1, MR3, R2}},
    {"ld1.nta",		M, OpMXX6aHint (4, 1, 0, 0x00, 3), {R1, MR3, R2}},
    {"ld2",		M, OpMXX6aHint (4, 1, 0, 0x01, 0), {R1, MR3, R2}},
    {"ld2.nt1",		M, OpMXX6aHint (4, 1, 0, 0x01, 1), {R1, MR3, R2}},
    {"ld2.nta",		M, OpMXX6aHint (4, 1, 0, 0x01, 3), {R1, MR3, R2}},
    {"ld4",		M, OpMXX6aHint (4, 1, 0, 0x02, 0), {R1, MR3, R2}},
    {"ld4.nt1",		M, OpMXX6aHint (4, 1, 0, 0x02, 1), {R1, MR3, R2}},
    {"ld4.nta",		M, OpMXX6aHint (4, 1, 0, 0x02, 3), {R1, MR3, R2}},
    {"ld8",		M, OpMXX6aHint (4, 1, 0, 0x03, 0), {R1, MR3, R2}},
    {"ld8.nt1",		M, OpMXX6aHint (4, 1, 0, 0x03, 1), {R1, MR3, R2}},
    {"ld8.nta",		M, OpMXX6aHint (4, 1, 0, 0x03, 3), {R1, MR3, R2}},
    {"ld1.s",		M, OpMXX6aHint (4, 1, 0, 0x04, 0), {R1, MR3, R2}},
    {"ld1.s.nt1",	M, OpMXX6aHint (4, 1, 0, 0x04, 1), {R1, MR3, R2}},
    {"ld1.s.nta",	M, OpMXX6aHint (4, 1, 0, 0x04, 3), {R1, MR3, R2}},
    {"ld2.s",		M, OpMXX6aHint (4, 1, 0, 0x05, 0), {R1, MR3, R2}},
    {"ld2.s.nt1",	M, OpMXX6aHint (4, 1, 0, 0x05, 1), {R1, MR3, R2}},
    {"ld2.s.nta",	M, OpMXX6aHint (4, 1, 0, 0x05, 3), {R1, MR3, R2}},
    {"ld4.s",		M, OpMXX6aHint (4, 1, 0, 0x06, 0), {R1, MR3, R2}},
    {"ld4.s.nt1",	M, OpMXX6aHint (4, 1, 0, 0x06, 1), {R1, MR3, R2}},
    {"ld4.s.nta",	M, OpMXX6aHint (4, 1, 0, 0x06, 3), {R1, MR3, R2}},
    {"ld8.s",		M, OpMXX6aHint (4, 1, 0, 0x07, 0), {R1, MR3, R2}},
    {"ld8.s.nt1",	M, OpMXX6aHint (4, 1, 0, 0x07, 1), {R1, MR3, R2}},
    {"ld8.s.nta",	M, OpMXX6aHint (4, 1, 0, 0x07, 3), {R1, MR3, R2}},
    {"ld1.a",		M, OpMXX6aHint (4, 1, 0, 0x08, 0), {R1, MR3, R2}},
    {"ld1.a.nt1",	M, OpMXX6aHint (4, 1, 0, 0x08, 1), {R1, MR3, R2}},
    {"ld1.a.nta",	M, OpMXX6aHint (4, 1, 0, 0x08, 3), {R1, MR3, R2}},
    {"ld2.a",		M, OpMXX6aHint (4, 1, 0, 0x09, 0), {R1, MR3, R2}},
    {"ld2.a.nt1",	M, OpMXX6aHint (4, 1, 0, 0x09, 1), {R1, MR3, R2}},
    {"ld2.a.nta",	M, OpMXX6aHint (4, 1, 0, 0x09, 3), {R1, MR3, R2}},
    {"ld4.a",		M, OpMXX6aHint (4, 1, 0, 0x0a, 0), {R1, MR3, R2}},
    {"ld4.a.nt1",	M, OpMXX6aHint (4, 1, 0, 0x0a, 1), {R1, MR3, R2}},
    {"ld4.a.nta",	M, OpMXX6aHint (4, 1, 0, 0x0a, 3), {R1, MR3, R2}},
    {"ld8.a",		M, OpMXX6aHint (4, 1, 0, 0x0b, 0), {R1, MR3, R2}},
    {"ld8.a.nt1",	M, OpMXX6aHint (4, 1, 0, 0x0b, 1), {R1, MR3, R2}},
    {"ld8.a.nta",	M, OpMXX6aHint (4, 1, 0, 0x0b, 3), {R1, MR3, R2}},
    {"ld1.sa",		M, OpMXX6aHint (4, 1, 0, 0x0c, 0), {R1, MR3, R2}},
    {"ld1.sa.nt1",	M, OpMXX6aHint (4, 1, 0, 0x0c, 1), {R1, MR3, R2}},
    {"ld1.sa.nta",	M, OpMXX6aHint (4, 1, 0, 0x0c, 3), {R1, MR3, R2}},
    {"ld2.sa",		M, OpMXX6aHint (4, 1, 0, 0x0d, 0), {R1, MR3, R2}},
    {"ld2.sa.nt1",	M, OpMXX6aHint (4, 1, 0, 0x0d, 1), {R1, MR3, R2}},
    {"ld2.sa.nta",	M, OpMXX6aHint (4, 1, 0, 0x0d, 3), {R1, MR3, R2}},
    {"ld4.sa",		M, OpMXX6aHint (4, 1, 0, 0x0e, 0), {R1, MR3, R2}},
    {"ld4.sa.nt1",	M, OpMXX6aHint (4, 1, 0, 0x0e, 1), {R1, MR3, R2}},
    {"ld4.sa.nta",	M, OpMXX6aHint (4, 1, 0, 0x0e, 3), {R1, MR3, R2}},
    {"ld8.sa",		M, OpMXX6aHint (4, 1, 0, 0x0f, 0), {R1, MR3, R2}},
    {"ld8.sa.nt1",	M, OpMXX6aHint (4, 1, 0, 0x0f, 1), {R1, MR3, R2}},
    {"ld8.sa.nta",	M, OpMXX6aHint (4, 1, 0, 0x0f, 3), {R1, MR3, R2}},
    {"ld1.bias",	M, OpMXX6aHint (4, 1, 0, 0x10, 0), {R1, MR3, R2}},
    {"ld1.bias.nt1",	M, OpMXX6aHint (4, 1, 0, 0x10, 1), {R1, MR3, R2}},
    {"ld1.bias.nta",	M, OpMXX6aHint (4, 1, 0, 0x10, 3), {R1, MR3, R2}},
    {"ld2.bias",	M, OpMXX6aHint (4, 1, 0, 0x11, 0), {R1, MR3, R2}},
    {"ld2.bias.nt1",	M, OpMXX6aHint (4, 1, 0, 0x11, 1), {R1, MR3, R2}},
    {"ld2.bias.nta",	M, OpMXX6aHint (4, 1, 0, 0x11, 3), {R1, MR3, R2}},
    {"ld4.bias",	M, OpMXX6aHint (4, 1, 0, 0x12, 0), {R1, MR3, R2}},
    {"ld4.bias.nt1",	M, OpMXX6aHint (4, 1, 0, 0x12, 1), {R1, MR3, R2}},
    {"ld4.bias.nta",	M, OpMXX6aHint (4, 1, 0, 0x12, 3), {R1, MR3, R2}},
    {"ld8.bias",	M, OpMXX6aHint (4, 1, 0, 0x13, 0), {R1, MR3, R2}},
    {"ld8.bias.nt1",	M, OpMXX6aHint (4, 1, 0, 0x13, 1), {R1, MR3, R2}},
    {"ld8.bias.nta",	M, OpMXX6aHint (4, 1, 0, 0x13, 3), {R1, MR3, R2}},
    {"ld1.acq",		M, OpMXX6aHint (4, 1, 0, 0x14, 0), {R1, MR3, R2}},
    {"ld1.acq.nt1",	M, OpMXX6aHint (4, 1, 0, 0x14, 1), {R1, MR3, R2}},
    {"ld1.acq.nta",	M, OpMXX6aHint (4, 1, 0, 0x14, 3), {R1, MR3, R2}},
    {"ld2.acq",		M, OpMXX6aHint (4, 1, 0, 0x15, 0), {R1, MR3, R2}},
    {"ld2.acq.nt1",	M, OpMXX6aHint (4, 1, 0, 0x15, 1), {R1, MR3, R2}},
    {"ld2.acq.nta",	M, OpMXX6aHint (4, 1, 0, 0x15, 3), {R1, MR3, R2}},
    {"ld4.acq",		M, OpMXX6aHint (4, 1, 0, 0x16, 0), {R1, MR3, R2}},
    {"ld4.acq.nt1",	M, OpMXX6aHint (4, 1, 0, 0x16, 1), {R1, MR3, R2}},
    {"ld4.acq.nta",	M, OpMXX6aHint (4, 1, 0, 0x16, 3), {R1, MR3, R2}},
    {"ld8.acq",		M, OpMXX6aHint (4, 1, 0, 0x17, 0), {R1, MR3, R2}},
    {"ld8.acq.nt1",	M, OpMXX6aHint (4, 1, 0, 0x17, 1), {R1, MR3, R2}},
    {"ld8.acq.nta",	M, OpMXX6aHint (4, 1, 0, 0x17, 3), {R1, MR3, R2}},
    {"ld8.fill",	M, OpMXX6aHint (4, 1, 0, 0x1b, 0), {R1, MR3, R2}},
    {"ld8.fill.nt1",	M, OpMXX6aHint (4, 1, 0, 0x1b, 1), {R1, MR3, R2}},
    {"ld8.fill.nta",	M, OpMXX6aHint (4, 1, 0, 0x1b, 3), {R1, MR3, R2}},
    {"ld1.c.clr",	M, OpMXX6aHint (4, 1, 0, 0x20, 0), {R1, MR3, R2}},
    {"ld1.c.clr.nt1",	M, OpMXX6aHint (4, 1, 0, 0x20, 1), {R1, MR3, R2}},
    {"ld1.c.clr.nta",	M, OpMXX6aHint (4, 1, 0, 0x20, 3), {R1, MR3, R2}},
    {"ld2.c.clr",	M, OpMXX6aHint (4, 1, 0, 0x21, 0), {R1, MR3, R2}},
    {"ld2.c.clr.nt1",	M, OpMXX6aHint (4, 1, 0, 0x21, 1), {R1, MR3, R2}},
    {"ld2.c.clr.nta",	M, OpMXX6aHint (4, 1, 0, 0x21, 3), {R1, MR3, R2}},
    {"ld4.c.clr",	M, OpMXX6aHint (4, 1, 0, 0x22, 0), {R1, MR3, R2}},
    {"ld4.c.clr.nt1",	M, OpMXX6aHint (4, 1, 0, 0x22, 1), {R1, MR3, R2}},
    {"ld4.c.clr.nta",	M, OpMXX6aHint (4, 1, 0, 0x22, 3), {R1, MR3, R2}},
    {"ld8.c.clr",	M, OpMXX6aHint (4, 1, 0, 0x23, 0), {R1, MR3, R2}},
    {"ld8.c.clr.nt1",	M, OpMXX6aHint (4, 1, 0, 0x23, 1), {R1, MR3, R2}},
    {"ld8.c.clr.nta",	M, OpMXX6aHint (4, 1, 0, 0x23, 3), {R1, MR3, R2}},
    {"ld1.c.nc",	M, OpMXX6aHint (4, 1, 0, 0x24, 0), {R1, MR3, R2}},
    {"ld1.c.nc.nt1",	M, OpMXX6aHint (4, 1, 0, 0x24, 1), {R1, MR3, R2}},
    {"ld1.c.nc.nta",	M, OpMXX6aHint (4, 1, 0, 0x24, 3), {R1, MR3, R2}},
    {"ld2.c.nc",	M, OpMXX6aHint (4, 1, 0, 0x25, 0), {R1, MR3, R2}},
    {"ld2.c.nc.nt1",	M, OpMXX6aHint (4, 1, 0, 0x25, 1), {R1, MR3, R2}},
    {"ld2.c.nc.nta",	M, OpMXX6aHint (4, 1, 0, 0x25, 3), {R1, MR3, R2}},
    {"ld4.c.nc",	M, OpMXX6aHint (4, 1, 0, 0x26, 0), {R1, MR3, R2}},
    {"ld4.c.nc.nt1",	M, OpMXX6aHint (4, 1, 0, 0x26, 1), {R1, MR3, R2}},
    {"ld4.c.nc.nta",	M, OpMXX6aHint (4, 1, 0, 0x26, 3), {R1, MR3, R2}},
    {"ld8.c.nc",	M, OpMXX6aHint (4, 1, 0, 0x27, 0), {R1, MR3, R2}},
    {"ld8.c.nc.nt1",	M, OpMXX6aHint (4, 1, 0, 0x27, 1), {R1, MR3, R2}},
    {"ld8.c.nc.nta",	M, OpMXX6aHint (4, 1, 0, 0x27, 3), {R1, MR3, R2}},
    {"ld1.c.clr.acq",	  M, OpMXX6aHint (4, 1, 0, 0x28, 0), {R1, MR3, R2}},
    {"ld1.c.clr.acq.nt1", M, OpMXX6aHint (4, 1, 0, 0x28, 1), {R1, MR3, R2}},
    {"ld1.c.clr.acq.nta", M, OpMXX6aHint (4, 1, 0, 0x28, 3), {R1, MR3, R2}},
    {"ld2.c.clr.acq",	  M, OpMXX6aHint (4, 1, 0, 0x29, 0), {R1, MR3, R2}},
    {"ld2.c.clr.acq.nt1", M, OpMXX6aHint (4, 1, 0, 0x29, 1), {R1, MR3, R2}},
    {"ld2.c.clr.acq.nta", M, OpMXX6aHint (4, 1, 0, 0x29, 3), {R1, MR3, R2}},
    {"ld4.c.clr.acq",	  M, OpMXX6aHint (4, 1, 0, 0x2a, 0), {R1, MR3, R2}},
    {"ld4.c.clr.acq.nt1", M, OpMXX6aHint (4, 1, 0, 0x2a, 1), {R1, MR3, R2}},
    {"ld4.c.clr.acq.nta", M, OpMXX6aHint (4, 1, 0, 0x2a, 3), {R1, MR3, R2}},
    {"ld8.c.clr.acq",	  M, OpMXX6aHint (4, 1, 0, 0x2b, 0), {R1, MR3, R2}},
    {"ld8.c.clr.acq.nt1", M, OpMXX6aHint (4, 1, 0, 0x2b, 1), {R1, MR3, R2}},
    {"ld8.c.clr.acq.nta", M, OpMXX6aHint (4, 1, 0, 0x2b, 3), {R1, MR3, R2}},

    {"st1",		M, OpMXX6aHint (4, 0, 0, 0x30, 0), {MR3, R2}},
    {"st1.nta",		M, OpMXX6aHint (4, 0, 0, 0x30, 3), {MR3, R2}},
    {"st2",		M, OpMXX6aHint (4, 0, 0, 0x31, 0), {MR3, R2}},
    {"st2.nta",		M, OpMXX6aHint (4, 0, 0, 0x31, 3), {MR3, R2}},
    {"st4",		M, OpMXX6aHint (4, 0, 0, 0x32, 0), {MR3, R2}},
    {"st4.nta",		M, OpMXX6aHint (4, 0, 0, 0x32, 3), {MR3, R2}},
    {"st8",		M, OpMXX6aHint (4, 0, 0, 0x33, 0), {MR3, R2}},
    {"st8.nta",		M, OpMXX6aHint (4, 0, 0, 0x33, 3), {MR3, R2}},
    {"st1.rel",		M, OpMXX6aHint (4, 0, 0, 0x34, 0), {MR3, R2}},
    {"st1.rel.nta",	M, OpMXX6aHint (4, 0, 0, 0x34, 3), {MR3, R2}},
    {"st2.rel",		M, OpMXX6aHint (4, 0, 0, 0x35, 0), {MR3, R2}},
    {"st2.rel.nta",	M, OpMXX6aHint (4, 0, 0, 0x35, 3), {MR3, R2}},
    {"st4.rel",		M, OpMXX6aHint (4, 0, 0, 0x36, 0), {MR3, R2}},
    {"st4.rel.nta",	M, OpMXX6aHint (4, 0, 0, 0x36, 3), {MR3, R2}},
    {"st8.rel",		M, OpMXX6aHint (4, 0, 0, 0x37, 0), {MR3, R2}},
    {"st8.rel.nta",	M, OpMXX6aHint (4, 0, 0, 0x37, 3), {MR3, R2}},
    {"st8.spill",	M, OpMXX6aHint (4, 0, 0, 0x3b, 0), {MR3, R2}},
    {"st8.spill.nta",	M, OpMXX6aHint (4, 0, 0, 0x3b, 3), {MR3, R2}},

#define CMPXCHG(c,h)	M, OpMXX6aHint (4, 0, 1, c, h), {R1, MR3, R2, AR_CCV}
    {"cmpxchg1.acq",		CMPXCHG (0x00, 0)},
    {"cmpxchg1.acq.nt1",	CMPXCHG (0x00, 1)},
    {"cmpxchg1.acq.nta",	CMPXCHG (0x00, 3)},
    {"cmpxchg2.acq",		CMPXCHG (0x01, 0)},
    {"cmpxchg2.acq.nt1",	CMPXCHG (0x01, 1)},
    {"cmpxchg2.acq.nta",	CMPXCHG (0x01, 3)},
    {"cmpxchg4.acq",		CMPXCHG (0x02, 0)},
    {"cmpxchg4.acq.nt1",	CMPXCHG (0x02, 1)},
    {"cmpxchg4.acq.nta",	CMPXCHG (0x02, 3)},
    {"cmpxchg8.acq",		CMPXCHG (0x03, 0)},
    {"cmpxchg8.acq.nt1",	CMPXCHG (0x03, 1)},
    {"cmpxchg8.acq.nta",	CMPXCHG (0x03, 3)},
    {"cmpxchg1.rel",		CMPXCHG (0x04, 0)},
    {"cmpxchg1.rel.nt1",	CMPXCHG (0x04, 1)},
    {"cmpxchg1.rel.nta",	CMPXCHG (0x04, 3)},
    {"cmpxchg2.rel",		CMPXCHG (0x05, 0)},
    {"cmpxchg2.rel.nt1",	CMPXCHG (0x05, 1)},
    {"cmpxchg2.rel.nta",	CMPXCHG (0x05, 3)},
    {"cmpxchg4.rel",		CMPXCHG (0x06, 0)},
    {"cmpxchg4.rel.nt1",	CMPXCHG (0x06, 1)},
    {"cmpxchg4.rel.nta",	CMPXCHG (0x06, 3)},
    {"cmpxchg8.rel",		CMPXCHG (0x07, 0)},
    {"cmpxchg8.rel.nt1",	CMPXCHG (0x07, 1)},
    {"cmpxchg8.rel.nta",	CMPXCHG (0x07, 3)},
#undef CMPXCHG
    {"xchg1",		  M, OpMXX6aHint (4, 0, 1, 0x08, 0), {R1, MR3, R2}},
    {"xchg1.nt1",	  M, OpMXX6aHint (4, 0, 1, 0x08, 1), {R1, MR3, R2}},
    {"xchg1.nta",	  M, OpMXX6aHint (4, 0, 1, 0x08, 3), {R1, MR3, R2}},
    {"xchg2",		  M, OpMXX6aHint (4, 0, 1, 0x09, 0), {R1, MR3, R2}},
    {"xchg2.nt1",	  M, OpMXX6aHint (4, 0, 1, 0x09, 1), {R1, MR3, R2}},
    {"xchg2.nta",	  M, OpMXX6aHint (4, 0, 1, 0x09, 3), {R1, MR3, R2}},
    {"xchg4",		  M, OpMXX6aHint (4, 0, 1, 0x0a, 0), {R1, MR3, R2}},
    {"xchg4.nt1",	  M, OpMXX6aHint (4, 0, 1, 0x0a, 1), {R1, MR3, R2}},
    {"xchg4.nta",	  M, OpMXX6aHint (4, 0, 1, 0x0a, 3), {R1, MR3, R2}},
    {"xchg8",		  M, OpMXX6aHint (4, 0, 1, 0x0b, 0), {R1, MR3, R2}},
    {"xchg8.nt1",	  M, OpMXX6aHint (4, 0, 1, 0x0b, 1), {R1, MR3, R2}},
    {"xchg8.nta",	  M, OpMXX6aHint (4, 0, 1, 0x0b, 3), {R1, MR3, R2}},

    {"fetchadd4.acq",	  M, OpMXX6aHint (4, 0, 1, 0x12, 0), {R1, MR3, INC3}},
    {"fetchadd4.acq.nt1", M, OpMXX6aHint (4, 0, 1, 0x12, 1), {R1, MR3, INC3}},
    {"fetchadd4.acq.nta", M, OpMXX6aHint (4, 0, 1, 0x12, 3), {R1, MR3, INC3}},
    {"fetchadd8.acq",	  M, OpMXX6aHint (4, 0, 1, 0x13, 0), {R1, MR3, INC3}},
    {"fetchadd8.acq.nt1", M, OpMXX6aHint (4, 0, 1, 0x13, 1), {R1, MR3, INC3}},
    {"fetchadd8.acq.nta", M, OpMXX6aHint (4, 0, 1, 0x13, 3), {R1, MR3, INC3}},
    {"fetchadd4.rel",	  M, OpMXX6aHint (4, 0, 1, 0x16, 0), {R1, MR3, INC3}},
    {"fetchadd4.rel.nt1", M, OpMXX6aHint (4, 0, 1, 0x16, 1), {R1, MR3, INC3}},
    {"fetchadd4.rel.nta", M, OpMXX6aHint (4, 0, 1, 0x16, 3), {R1, MR3, INC3}},
    {"fetchadd8.rel",	  M, OpMXX6aHint (4, 0, 1, 0x17, 0), {R1, MR3, INC3}},
    {"fetchadd8.rel.nt1", M, OpMXX6aHint (4, 0, 1, 0x17, 1), {R1, MR3, INC3}},
    {"fetchadd8.rel.nta", M, OpMXX6aHint (4, 0, 1, 0x17, 3), {R1, MR3, INC3}},

    {"getf.sig",	  M, OpMXX6a (4, 0, 1, 0x1c), {R1, F2}},
    {"getf.exp",	  M, OpMXX6a (4, 0, 1, 0x1d), {R1, F2}},
    {"getf.s",		  M, OpMXX6a (4, 0, 1, 0x1e), {R1, F2}},
    {"getf.d",		  M, OpMXX6a (4, 0, 1, 0x1f), {R1, F2}},

    /* integer load w/increment by immediate */
    {"ld1",		M, OpX6aHint (5, 0x00, 0), {R1, MR3, IMM9b}},
    {"ld1.nt1",		M, OpX6aHint (5, 0x00, 1), {R1, MR3, IMM9b}},
    {"ld1.nta",		M, OpX6aHint (5, 0x00, 3), {R1, MR3, IMM9b}},
    {"ld2",		M, OpX6aHint (5, 0x01, 0), {R1, MR3, IMM9b}},
    {"ld2.nt1",		M, OpX6aHint (5, 0x01, 1), {R1, MR3, IMM9b}},
    {"ld2.nta",		M, OpX6aHint (5, 0x01, 3), {R1, MR3, IMM9b}},
    {"ld4",		M, OpX6aHint (5, 0x02, 0), {R1, MR3, IMM9b}},
    {"ld4.nt1",		M, OpX6aHint (5, 0x02, 1), {R1, MR3, IMM9b}},
    {"ld4.nta",		M, OpX6aHint (5, 0x02, 3), {R1, MR3, IMM9b}},
    {"ld8",		M, OpX6aHint (5, 0x03, 0), {R1, MR3, IMM9b}},
    {"ld8.nt1",		M, OpX6aHint (5, 0x03, 1), {R1, MR3, IMM9b}},
    {"ld8.nta",		M, OpX6aHint (5, 0x03, 3), {R1, MR3, IMM9b}},
    {"ld1.s",		M, OpX6aHint (5, 0x04, 0), {R1, MR3, IMM9b}},
    {"ld1.s.nt1",	M, OpX6aHint (5, 0x04, 1), {R1, MR3, IMM9b}},
    {"ld1.s.nta",	M, OpX6aHint (5, 0x04, 3), {R1, MR3, IMM9b}},
    {"ld2.s",		M, OpX6aHint (5, 0x05, 0), {R1, MR3, IMM9b}},
    {"ld2.s.nt1",	M, OpX6aHint (5, 0x05, 1), {R1, MR3, IMM9b}},
    {"ld2.s.nta",	M, OpX6aHint (5, 0x05, 3), {R1, MR3, IMM9b}},
    {"ld4.s",		M, OpX6aHint (5, 0x06, 0), {R1, MR3, IMM9b}},
    {"ld4.s.nt1",	M, OpX6aHint (5, 0x06, 1), {R1, MR3, IMM9b}},
    {"ld4.s.nta",	M, OpX6aHint (5, 0x06, 3), {R1, MR3, IMM9b}},
    {"ld8.s",		M, OpX6aHint (5, 0x07, 0), {R1, MR3, IMM9b}},
    {"ld8.s.nt1",	M, OpX6aHint (5, 0x07, 1), {R1, MR3, IMM9b}},
    {"ld8.s.nta",	M, OpX6aHint (5, 0x07, 3), {R1, MR3, IMM9b}},
    {"ld1.a",		M, OpX6aHint (5, 0x08, 0), {R1, MR3, IMM9b}},
    {"ld1.a.nt1",	M, OpX6aHint (5, 0x08, 1), {R1, MR3, IMM9b}},
    {"ld1.a.nta",	M, OpX6aHint (5, 0x08, 3), {R1, MR3, IMM9b}},
    {"ld2.a",		M, OpX6aHint (5, 0x09, 0), {R1, MR3, IMM9b}},
    {"ld2.a.nt1",	M, OpX6aHint (5, 0x09, 1), {R1, MR3, IMM9b}},
    {"ld2.a.nta",	M, OpX6aHint (5, 0x09, 3), {R1, MR3, IMM9b}},
    {"ld4.a",		M, OpX6aHint (5, 0x0a, 0), {R1, MR3, IMM9b}},
    {"ld4.a.nt1",	M, OpX6aHint (5, 0x0a, 1), {R1, MR3, IMM9b}},
    {"ld4.a.nta",	M, OpX6aHint (5, 0x0a, 3), {R1, MR3, IMM9b}},
    {"ld8.a",		M, OpX6aHint (5, 0x0b, 0), {R1, MR3, IMM9b}},
    {"ld8.a.nt1",	M, OpX6aHint (5, 0x0b, 1), {R1, MR3, IMM9b}},
    {"ld8.a.nta",	M, OpX6aHint (5, 0x0b, 3), {R1, MR3, IMM9b}},
    {"ld1.sa",		M, OpX6aHint (5, 0x0c, 0), {R1, MR3, IMM9b}},
    {"ld1.sa.nt1",	M, OpX6aHint (5, 0x0c, 1), {R1, MR3, IMM9b}},
    {"ld1.sa.nta",	M, OpX6aHint (5, 0x0c, 3), {R1, MR3, IMM9b}},
    {"ld2.sa",		M, OpX6aHint (5, 0x0d, 0), {R1, MR3, IMM9b}},
    {"ld2.sa.nt1",	M, OpX6aHint (5, 0x0d, 1), {R1, MR3, IMM9b}},
    {"ld2.sa.nta",	M, OpX6aHint (5, 0x0d, 3), {R1, MR3, IMM9b}},
    {"ld4.sa",		M, OpX6aHint (5, 0x0e, 0), {R1, MR3, IMM9b}},
    {"ld4.sa.nt1",	M, OpX6aHint (5, 0x0e, 1), {R1, MR3, IMM9b}},
    {"ld4.sa.nta",	M, OpX6aHint (5, 0x0e, 3), {R1, MR3, IMM9b}},
    {"ld8.sa",		M, OpX6aHint (5, 0x0f, 0), {R1, MR3, IMM9b}},
    {"ld8.sa.nt1",	M, OpX6aHint (5, 0x0f, 1), {R1, MR3, IMM9b}},
    {"ld8.sa.nta",	M, OpX6aHint (5, 0x0f, 3), {R1, MR3, IMM9b}},
    {"ld1.bias",	M, OpX6aHint (5, 0x10, 0), {R1, MR3, IMM9b}},
    {"ld1.bias.nt1",	M, OpX6aHint (5, 0x10, 1), {R1, MR3, IMM9b}},
    {"ld1.bias.nta",	M, OpX6aHint (5, 0x10, 3), {R1, MR3, IMM9b}},
    {"ld2.bias",	M, OpX6aHint (5, 0x11, 0), {R1, MR3, IMM9b}},
    {"ld2.bias.nt1",	M, OpX6aHint (5, 0x11, 1), {R1, MR3, IMM9b}},
    {"ld2.bias.nta",	M, OpX6aHint (5, 0x11, 3), {R1, MR3, IMM9b}},
    {"ld4.bias",	M, OpX6aHint (5, 0x12, 0), {R1, MR3, IMM9b}},
    {"ld4.bias.nt1",	M, OpX6aHint (5, 0x12, 1), {R1, MR3, IMM9b}},
    {"ld4.bias.nta",	M, OpX6aHint (5, 0x12, 3), {R1, MR3, IMM9b}},
    {"ld8.bias",	M, OpX6aHint (5, 0x13, 0), {R1, MR3, IMM9b}},
    {"ld8.bias.nt1",	M, OpX6aHint (5, 0x13, 1), {R1, MR3, IMM9b}},
    {"ld8.bias.nta",	M, OpX6aHint (5, 0x13, 3), {R1, MR3, IMM9b}},
    {"ld1.acq",		M, OpX6aHint (5, 0x14, 0), {R1, MR3, IMM9b}},
    {"ld1.acq.nt1",	M, OpX6aHint (5, 0x14, 1), {R1, MR3, IMM9b}},
    {"ld1.acq.nta",	M, OpX6aHint (5, 0x14, 3), {R1, MR3, IMM9b}},
    {"ld2.acq",		M, OpX6aHint (5, 0x15, 0), {R1, MR3, IMM9b}},
    {"ld2.acq.nt1",	M, OpX6aHint (5, 0x15, 1), {R1, MR3, IMM9b}},
    {"ld2.acq.nta",	M, OpX6aHint (5, 0x15, 3), {R1, MR3, IMM9b}},
    {"ld4.acq",		M, OpX6aHint (5, 0x16, 0), {R1, MR3, IMM9b}},
    {"ld4.acq.nt1",	M, OpX6aHint (5, 0x16, 1), {R1, MR3, IMM9b}},
    {"ld4.acq.nta",	M, OpX6aHint (5, 0x16, 3), {R1, MR3, IMM9b}},
    {"ld8.acq",		M, OpX6aHint (5, 0x17, 0), {R1, MR3, IMM9b}},
    {"ld8.acq.nt1",	M, OpX6aHint (5, 0x17, 1), {R1, MR3, IMM9b}},
    {"ld8.acq.nta",	M, OpX6aHint (5, 0x17, 3), {R1, MR3, IMM9b}},
    {"ld8.fill",	M, OpX6aHint (5, 0x1b, 0), {R1, MR3, IMM9b}},
    {"ld8.fill.nt1",	M, OpX6aHint (5, 0x1b, 1), {R1, MR3, IMM9b}},
    {"ld8.fill.nta",	M, OpX6aHint (5, 0x1b, 3), {R1, MR3, IMM9b}},
    {"ld1.c.clr",	M, OpX6aHint (5, 0x20, 0), {R1, MR3, IMM9b}},
    {"ld1.c.clr.nt1",	M, OpX6aHint (5, 0x20, 1), {R1, MR3, IMM9b}},
    {"ld1.c.clr.nta",	M, OpX6aHint (5, 0x20, 3), {R1, MR3, IMM9b}},
    {"ld2.c.clr",	M, OpX6aHint (5, 0x21, 0), {R1, MR3, IMM9b}},
    {"ld2.c.clr.nt1",	M, OpX6aHint (5, 0x21, 1), {R1, MR3, IMM9b}},
    {"ld2.c.clr.nta",	M, OpX6aHint (5, 0x21, 3), {R1, MR3, IMM9b}},
    {"ld4.c.clr",	M, OpX6aHint (5, 0x22, 0), {R1, MR3, IMM9b}},
    {"ld4.c.clr.nt1",	M, OpX6aHint (5, 0x22, 1), {R1, MR3, IMM9b}},
    {"ld4.c.clr.nta",	M, OpX6aHint (5, 0x22, 3), {R1, MR3, IMM9b}},
    {"ld8.c.clr",	M, OpX6aHint (5, 0x23, 0), {R1, MR3, IMM9b}},
    {"ld8.c.clr.nt1",	M, OpX6aHint (5, 0x23, 1), {R1, MR3, IMM9b}},
    {"ld8.c.clr.nta",	M, OpX6aHint (5, 0x23, 3), {R1, MR3, IMM9b}},
    {"ld1.c.nc",	M, OpX6aHint (5, 0x24, 0), {R1, MR3, IMM9b}},
    {"ld1.c.nc.nt1",	M, OpX6aHint (5, 0x24, 1), {R1, MR3, IMM9b}},
    {"ld1.c.nc.nta",	M, OpX6aHint (5, 0x24, 3), {R1, MR3, IMM9b}},
    {"ld2.c.nc",	M, OpX6aHint (5, 0x25, 0), {R1, MR3, IMM9b}},
    {"ld2.c.nc.nt1",	M, OpX6aHint (5, 0x25, 1), {R1, MR3, IMM9b}},
    {"ld2.c.nc.nta",	M, OpX6aHint (5, 0x25, 3), {R1, MR3, IMM9b}},
    {"ld4.c.nc",	M, OpX6aHint (5, 0x26, 0), {R1, MR3, IMM9b}},
    {"ld4.c.nc.nt1",	M, OpX6aHint (5, 0x26, 1), {R1, MR3, IMM9b}},
    {"ld4.c.nc.nta",	M, OpX6aHint (5, 0x26, 3), {R1, MR3, IMM9b}},
    {"ld8.c.nc",	M, OpX6aHint (5, 0x27, 0), {R1, MR3, IMM9b}},
    {"ld8.c.nc.nt1",	M, OpX6aHint (5, 0x27, 1), {R1, MR3, IMM9b}},
    {"ld8.c.nc.nta",	M, OpX6aHint (5, 0x27, 3), {R1, MR3, IMM9b}},
    {"ld1.c.clr.acq",	  M, OpX6aHint (5, 0x28, 0), {R1, MR3, IMM9b}},
    {"ld1.c.clr.acq.nt1", M, OpX6aHint (5, 0x28, 1), {R1, MR3, IMM9b}},
    {"ld1.c.clr.acq.nta", M, OpX6aHint (5, 0x28, 3), {R1, MR3, IMM9b}},
    {"ld2.c.clr.acq",	  M, OpX6aHint (5, 0x29, 0), {R1, MR3, IMM9b}},
    {"ld2.c.clr.acq.nt1", M, OpX6aHint (5, 0x29, 1), {R1, MR3, IMM9b}},
    {"ld2.c.clr.acq.nta", M, OpX6aHint (5, 0x29, 3), {R1, MR3, IMM9b}},
    {"ld4.c.clr.acq",	  M, OpX6aHint (5, 0x2a, 0), {R1, MR3, IMM9b}},
    {"ld4.c.clr.acq.nt1", M, OpX6aHint (5, 0x2a, 1), {R1, MR3, IMM9b}},
    {"ld4.c.clr.acq.nta", M, OpX6aHint (5, 0x2a, 3), {R1, MR3, IMM9b}},
    {"ld8.c.clr.acq",	  M, OpX6aHint (5, 0x2b, 0), {R1, MR3, IMM9b}},
    {"ld8.c.clr.acq.nt1", M, OpX6aHint (5, 0x2b, 1), {R1, MR3, IMM9b}},
    {"ld8.c.clr.acq.nta", M, OpX6aHint (5, 0x2b, 3), {R1, MR3, IMM9b}},

    /* store w/increment by immediate */
    {"st1",		M, OpX6aHint (5, 0x30, 0), {MR3, R2, IMM9a}},
    {"st1.nta",		M, OpX6aHint (5, 0x30, 3), {MR3, R2, IMM9a}},
    {"st2",		M, OpX6aHint (5, 0x31, 0), {MR3, R2, IMM9a}},
    {"st2.nta",		M, OpX6aHint (5, 0x31, 3), {MR3, R2, IMM9a}},
    {"st4",		M, OpX6aHint (5, 0x32, 0), {MR3, R2, IMM9a}},
    {"st4.nta",		M, OpX6aHint (5, 0x32, 3), {MR3, R2, IMM9a}},
    {"st8",		M, OpX6aHint (5, 0x33, 0), {MR3, R2, IMM9a}},
    {"st8.nta",		M, OpX6aHint (5, 0x33, 3), {MR3, R2, IMM9a}},
    {"st1.rel",		M, OpX6aHint (5, 0x34, 0), {MR3, R2, IMM9a}},
    {"st1.rel.nta",	M, OpX6aHint (5, 0x34, 3), {MR3, R2, IMM9a}},
    {"st2.rel",		M, OpX6aHint (5, 0x35, 0), {MR3, R2, IMM9a}},
    {"st2.rel.nta",	M, OpX6aHint (5, 0x35, 3), {MR3, R2, IMM9a}},
    {"st4.rel",		M, OpX6aHint (5, 0x36, 0), {MR3, R2, IMM9a}},
    {"st4.rel.nta",	M, OpX6aHint (5, 0x36, 3), {MR3, R2, IMM9a}},
    {"st8.rel",		M, OpX6aHint (5, 0x37, 0), {MR3, R2, IMM9a}},
    {"st8.rel.nta",	M, OpX6aHint (5, 0x37, 3), {MR3, R2, IMM9a}},
    {"st8.spill",	M, OpX6aHint (5, 0x3b, 0), {MR3, R2, IMM9a}},
    {"st8.spill.nta",	M, OpX6aHint (5, 0x3b, 3), {MR3, R2, IMM9a}},

    /* floating-point load */
    {"ldfs",		M, OpMXX6aHint (6, 0, 0, 0x02, 0), {F1, MR3}},
    {"ldfs.nt1",	M, OpMXX6aHint (6, 0, 0, 0x02, 1), {F1, MR3}},
    {"ldfs.nta",	M, OpMXX6aHint (6, 0, 0, 0x02, 3), {F1, MR3}},
    {"ldfd",		M, OpMXX6aHint (6, 0, 0, 0x03, 0), {F1, MR3}},
    {"ldfd.nt1",	M, OpMXX6aHint (6, 0, 0, 0x03, 1), {F1, MR3}},
    {"ldfd.nta",	M, OpMXX6aHint (6, 0, 0, 0x03, 3), {F1, MR3}},
    {"ldf8",		M, OpMXX6aHint (6, 0, 0, 0x01, 0), {F1, MR3}},
    {"ldf8.nt1",	M, OpMXX6aHint (6, 0, 0, 0x01, 1), {F1, MR3}},
    {"ldf8.nta",	M, OpMXX6aHint (6, 0, 0, 0x01, 3), {F1, MR3}},
    {"ldfe",		M, OpMXX6aHint (6, 0, 0, 0x00, 0), {F1, MR3}},
    {"ldfe.nt1",	M, OpMXX6aHint (6, 0, 0, 0x00, 1), {F1, MR3}},
    {"ldfe.nta",	M, OpMXX6aHint (6, 0, 0, 0x00, 3), {F1, MR3}},
    {"ldfs.s",		M, OpMXX6aHint (6, 0, 0, 0x06, 0), {F1, MR3}},
    {"ldfs.s.nt1",	M, OpMXX6aHint (6, 0, 0, 0x06, 1), {F1, MR3}},
    {"ldfs.s.nta",	M, OpMXX6aHint (6, 0, 0, 0x06, 3), {F1, MR3}},
    {"ldfd.s",		M, OpMXX6aHint (6, 0, 0, 0x07, 0), {F1, MR3}},
    {"ldfd.s.nt1",	M, OpMXX6aHint (6, 0, 0, 0x07, 1), {F1, MR3}},
    {"ldfd.s.nta",	M, OpMXX6aHint (6, 0, 0, 0x07, 3), {F1, MR3}},
    {"ldf8.s",		M, OpMXX6aHint (6, 0, 0, 0x05, 0), {F1, MR3}},
    {"ldf8.s.nt1",	M, OpMXX6aHint (6, 0, 0, 0x05, 1), {F1, MR3}},
    {"ldf8.s.nta",	M, OpMXX6aHint (6, 0, 0, 0x05, 3), {F1, MR3}},
    {"ldfe.s",		M, OpMXX6aHint (6, 0, 0, 0x04, 0), {F1, MR3}},
    {"ldfe.s.nt1",	M, OpMXX6aHint (6, 0, 0, 0x04, 1), {F1, MR3}},
    {"ldfe.s.nta",	M, OpMXX6aHint (6, 0, 0, 0x04, 3), {F1, MR3}},
    {"ldfs.a",		M, OpMXX6aHint (6, 0, 0, 0x0a, 0), {F1, MR3}},
    {"ldfs.a.nt1",	M, OpMXX6aHint (6, 0, 0, 0x0a, 1), {F1, MR3}},
    {"ldfs.a.nta",	M, OpMXX6aHint (6, 0, 0, 0x0a, 3), {F1, MR3}},
    {"ldfd.a",		M, OpMXX6aHint (6, 0, 0, 0x0b, 0), {F1, MR3}},
    {"ldfd.a.nt1",	M, OpMXX6aHint (6, 0, 0, 0x0b, 1), {F1, MR3}},
    {"ldfd.a.nta",	M, OpMXX6aHint (6, 0, 0, 0x0b, 3), {F1, MR3}},
    {"ldf8.a",		M, OpMXX6aHint (6, 0, 0, 0x09, 0), {F1, MR3}},
    {"ldf8.a.nt1",	M, OpMXX6aHint (6, 0, 0, 0x09, 1), {F1, MR3}},
    {"ldf8.a.nta",	M, OpMXX6aHint (6, 0, 0, 0x09, 3), {F1, MR3}},
    {"ldfe.a",		M, OpMXX6aHint (6, 0, 0, 0x08, 0), {F1, MR3}},
    {"ldfe.a.nt1",	M, OpMXX6aHint (6, 0, 0, 0x08, 1), {F1, MR3}},
    {"ldfe.a.nta",	M, OpMXX6aHint (6, 0, 0, 0x08, 3), {F1, MR3}},
    {"ldfs.sa",		M, OpMXX6aHint (6, 0, 0, 0x0e, 0), {F1, MR3}},
    {"ldfs.sa.nt1",	M, OpMXX6aHint (6, 0, 0, 0x0e, 1), {F1, MR3}},
    {"ldfs.sa.nta",	M, OpMXX6aHint (6, 0, 0, 0x0e, 3), {F1, MR3}},
    {"ldfd.sa",		M, OpMXX6aHint (6, 0, 0, 0x0f, 0), {F1, MR3}},
    {"ldfd.sa.nt1",	M, OpMXX6aHint (6, 0, 0, 0x0f, 1), {F1, MR3}},
    {"ldfd.sa.nta",	M, OpMXX6aHint (6, 0, 0, 0x0f, 3), {F1, MR3}},
    {"ldf8.sa",		M, OpMXX6aHint (6, 0, 0, 0x0d, 0), {F1, MR3}},
    {"ldf8.sa.nt1",	M, OpMXX6aHint (6, 0, 0, 0x0d, 1), {F1, MR3}},
    {"ldf8.sa.nta",	M, OpMXX6aHint (6, 0, 0, 0x0d, 3), {F1, MR3}},
    {"ldfe.sa",		M, OpMXX6aHint (6, 0, 0, 0x0c, 0), {F1, MR3}},
    {"ldfe.sa.nt1",	M, OpMXX6aHint (6, 0, 0, 0x0c, 1), {F1, MR3}},
    {"ldfe.sa.nta",	M, OpMXX6aHint (6, 0, 0, 0x0c, 3), {F1, MR3}},
    {"ldf.fill",	M, OpMXX6aHint (6, 0, 0, 0x1b, 0), {F1, MR3}},
    {"ldf.fill.nt1",	M, OpMXX6aHint (6, 0, 0, 0x1b, 1), {F1, MR3}},
    {"ldf.fill.nta",	M, OpMXX6aHint (6, 0, 0, 0x1b, 3), {F1, MR3}},
    {"ldfs.c.clr",	M, OpMXX6aHint (6, 0, 0, 0x22, 0), {F1, MR3}},
    {"ldfs.c.clr.nt1",	M, OpMXX6aHint (6, 0, 0, 0x22, 1), {F1, MR3}},
    {"ldfs.c.clr.nta",	M, OpMXX6aHint (6, 0, 0, 0x22, 3), {F1, MR3}},
    {"ldfd.c.clr",	M, OpMXX6aHint (6, 0, 0, 0x23, 0), {F1, MR3}},
    {"ldfd.c.clr.nt1",	M, OpMXX6aHint (6, 0, 0, 0x23, 1), {F1, MR3}},
    {"ldfd.c.clr.nta",	M, OpMXX6aHint (6, 0, 0, 0x23, 3), {F1, MR3}},
    {"ldf8.c.clr",	M, OpMXX6aHint (6, 0, 0, 0x21, 0), {F1, MR3}},
    {"ldf8.c.clr.nt1",	M, OpMXX6aHint (6, 0, 0, 0x21, 1), {F1, MR3}},
    {"ldf8.c.clr.nta",	M, OpMXX6aHint (6, 0, 0, 0x21, 3), {F1, MR3}},
    {"ldfe.c.clr",	M, OpMXX6aHint (6, 0, 0, 0x20, 0), {F1, MR3}},
    {"ldfe.c.clr.nt1",	M, OpMXX6aHint (6, 0, 0, 0x20, 1), {F1, MR3}},
    {"ldfe.c.clr.nta",	M, OpMXX6aHint (6, 0, 0, 0x20, 3), {F1, MR3}},
    {"ldfs.c.nc",	M, OpMXX6aHint (6, 0, 0, 0x26, 0), {F1, MR3}},
    {"ldfs.c.nc.nt1",	M, OpMXX6aHint (6, 0, 0, 0x26, 1), {F1, MR3}},
    {"ldfs.c.nc.nta",	M, OpMXX6aHint (6, 0, 0, 0x26, 3), {F1, MR3}},
    {"ldfd.c.nc",	M, OpMXX6aHint (6, 0, 0, 0x27, 0), {F1, MR3}},
    {"ldfd.c.nc.nt1",	M, OpMXX6aHint (6, 0, 0, 0x27, 1), {F1, MR3}},
    {"ldfd.c.nc.nta",	M, OpMXX6aHint (6, 0, 0, 0x27, 3), {F1, MR3}},
    {"ldf8.c.nc",	M, OpMXX6aHint (6, 0, 0, 0x25, 0), {F1, MR3}},
    {"ldf8.c.nc.nt1",	M, OpMXX6aHint (6, 0, 0, 0x25, 1), {F1, MR3}},
    {"ldf8.c.nc.nta",	M, OpMXX6aHint (6, 0, 0, 0x25, 3), {F1, MR3}},
    {"ldfe.c.nc",	M, OpMXX6aHint (6, 0, 0, 0x24, 0), {F1, MR3}},
    {"ldfe.c.nc.nt1",	M, OpMXX6aHint (6, 0, 0, 0x24, 1), {F1, MR3}},
    {"ldfe.c.nc.nta",	M, OpMXX6aHint (6, 0, 0, 0x24, 3), {F1, MR3}},

    {"ldfs",		M, OpMXX6aHint (6, 1, 0, 0x02, 0), {F1, MR3, R2}},
    {"ldfs.nt1",	M, OpMXX6aHint (6, 1, 0, 0x02, 1), {F1, MR3, R2}},
    {"ldfs.nta",	M, OpMXX6aHint (6, 1, 0, 0x02, 3), {F1, MR3, R2}},
    {"ldfd",		M, OpMXX6aHint (6, 1, 0, 0x03, 0), {F1, MR3, R2}},
    {"ldfd.nt1",	M, OpMXX6aHint (6, 1, 0, 0x03, 1), {F1, MR3, R2}},
    {"ldfd.nta",	M, OpMXX6aHint (6, 1, 0, 0x03, 3), {F1, MR3, R2}},
    {"ldf8",		M, OpMXX6aHint (6, 1, 0, 0x01, 0), {F1, MR3, R2}},
    {"ldf8.nt1",	M, OpMXX6aHint (6, 1, 0, 0x01, 1), {F1, MR3, R2}},
    {"ldf8.nta",	M, OpMXX6aHint (6, 1, 0, 0x01, 3), {F1, MR3, R2}},
    {"ldfe",		M, OpMXX6aHint (6, 1, 0, 0x00, 0), {F1, MR3, R2}},
    {"ldfe.nt1",	M, OpMXX6aHint (6, 1, 0, 0x00, 1), {F1, MR3, R2}},
    {"ldfe.nta",	M, OpMXX6aHint (6, 1, 0, 0x00, 3), {F1, MR3, R2}},
    {"ldfs.s",		M, OpMXX6aHint (6, 1, 0, 0x06, 0), {F1, MR3, R2}},
    {"ldfs.s.nt1",	M, OpMXX6aHint (6, 1, 0, 0x06, 1), {F1, MR3, R2}},
    {"ldfs.s.nta",	M, OpMXX6aHint (6, 1, 0, 0x06, 3), {F1, MR3, R2}},
    {"ldfd.s",		M, OpMXX6aHint (6, 1, 0, 0x07, 0), {F1, MR3, R2}},
    {"ldfd.s.nt1",	M, OpMXX6aHint (6, 1, 0, 0x07, 1), {F1, MR3, R2}},
    {"ldfd.s.nta",	M, OpMXX6aHint (6, 1, 0, 0x07, 3), {F1, MR3, R2}},
    {"ldf8.s",		M, OpMXX6aHint (6, 1, 0, 0x05, 0), {F1, MR3, R2}},
    {"ldf8.s.nt1",	M, OpMXX6aHint (6, 1, 0, 0x05, 1), {F1, MR3, R2}},
    {"ldf8.s.nta",	M, OpMXX6aHint (6, 1, 0, 0x05, 3), {F1, MR3, R2}},
    {"ldfe.s",		M, OpMXX6aHint (6, 1, 0, 0x04, 0), {F1, MR3, R2}},
    {"ldfe.s.nt1",	M, OpMXX6aHint (6, 1, 0, 0x04, 1), {F1, MR3, R2}},
    {"ldfe.s.nta",	M, OpMXX6aHint (6, 1, 0, 0x04, 3), {F1, MR3, R2}},
    {"ldfs.a",		M, OpMXX6aHint (6, 1, 0, 0x0a, 0), {F1, MR3, R2}},
    {"ldfs.a.nt1",	M, OpMXX6aHint (6, 1, 0, 0x0a, 1), {F1, MR3, R2}},
    {"ldfs.a.nta",	M, OpMXX6aHint (6, 1, 0, 0x0a, 3), {F1, MR3, R2}},
    {"ldfd.a",		M, OpMXX6aHint (6, 1, 0, 0x0b, 0), {F1, MR3, R2}},
    {"ldfd.a.nt1",	M, OpMXX6aHint (6, 1, 0, 0x0b, 1), {F1, MR3, R2}},
    {"ldfd.a.nta",	M, OpMXX6aHint (6, 1, 0, 0x0b, 3), {F1, MR3, R2}},
    {"ldf8.a",		M, OpMXX6aHint (6, 1, 0, 0x09, 0), {F1, MR3, R2}},
    {"ldf8.a.nt1",	M, OpMXX6aHint (6, 1, 0, 0x09, 1), {F1, MR3, R2}},
    {"ldf8.a.nta",	M, OpMXX6aHint (6, 1, 0, 0x09, 3), {F1, MR3, R2}},
    {"ldfe.a",		M, OpMXX6aHint (6, 1, 0, 0x08, 0), {F1, MR3, R2}},
    {"ldfe.a.nt1",	M, OpMXX6aHint (6, 1, 0, 0x08, 1), {F1, MR3, R2}},
    {"ldfe.a.nta",	M, OpMXX6aHint (6, 1, 0, 0x08, 3), {F1, MR3, R2}},
    {"ldfs.sa",		M, OpMXX6aHint (6, 1, 0, 0x0e, 0), {F1, MR3, R2}},
    {"ldfs.sa.nt1",	M, OpMXX6aHint (6, 1, 0, 0x0e, 1), {F1, MR3, R2}},
    {"ldfs.sa.nta",	M, OpMXX6aHint (6, 1, 0, 0x0e, 3), {F1, MR3, R2}},
    {"ldfd.sa",		M, OpMXX6aHint (6, 1, 0, 0x0f, 0), {F1, MR3, R2}},
    {"ldfd.sa.nt1",	M, OpMXX6aHint (6, 1, 0, 0x0f, 1), {F1, MR3, R2}},
    {"ldfd.sa.nta",	M, OpMXX6aHint (6, 1, 0, 0x0f, 3), {F1, MR3, R2}},
    {"ldf8.sa",		M, OpMXX6aHint (6, 1, 0, 0x0d, 0), {F1, MR3, R2}},
    {"ldf8.sa.nt1",	M, OpMXX6aHint (6, 1, 0, 0x0d, 1), {F1, MR3, R2}},
    {"ldf8.sa.nta",	M, OpMXX6aHint (6, 1, 0, 0x0d, 3), {F1, MR3, R2}},
    {"ldfe.sa",		M, OpMXX6aHint (6, 1, 0, 0x0c, 0), {F1, MR3, R2}},
    {"ldfe.sa.nt1",	M, OpMXX6aHint (6, 1, 0, 0x0c, 1), {F1, MR3, R2}},
    {"ldfe.sa.nta",	M, OpMXX6aHint (6, 1, 0, 0x0c, 3), {F1, MR3, R2}},
    {"ldf.fill",	M, OpMXX6aHint (6, 1, 0, 0x1b, 0), {F1, MR3, R2}},
    {"ldf.fill.nt1",	M, OpMXX6aHint (6, 1, 0, 0x1b, 1), {F1, MR3, R2}},
    {"ldf.fill.nta",	M, OpMXX6aHint (6, 1, 0, 0x1b, 3), {F1, MR3, R2}},
    {"ldfs.c.clr",	M, OpMXX6aHint (6, 1, 0, 0x22, 0), {F1, MR3, R2}},
    {"ldfs.c.clr.nt1",	M, OpMXX6aHint (6, 1, 0, 0x22, 1), {F1, MR3, R2}},
    {"ldfs.c.clr.nta",	M, OpMXX6aHint (6, 1, 0, 0x22, 3), {F1, MR3, R2}},
    {"ldfd.c.clr",	M, OpMXX6aHint (6, 1, 0, 0x23, 0), {F1, MR3, R2}},
    {"ldfd.c.clr.nt1",	M, OpMXX6aHint (6, 1, 0, 0x23, 1), {F1, MR3, R2}},
    {"ldfd.c.clr.nta",	M, OpMXX6aHint (6, 1, 0, 0x23, 3), {F1, MR3, R2}},
    {"ldf8.c.clr",	M, OpMXX6aHint (6, 1, 0, 0x21, 0), {F1, MR3, R2}},
    {"ldf8.c.clr.nt1",	M, OpMXX6aHint (6, 1, 0, 0x21, 1), {F1, MR3, R2}},
    {"ldf8.c.clr.nta",	M, OpMXX6aHint (6, 1, 0, 0x21, 3), {F1, MR3, R2}},
    {"ldfe.c.clr",	M, OpMXX6aHint (6, 1, 0, 0x20, 0), {F1, MR3, R2}},
    {"ldfe.c.clr.nt1",	M, OpMXX6aHint (6, 1, 0, 0x20, 1), {F1, MR3, R2}},
    {"ldfe.c.clr.nta",	M, OpMXX6aHint (6, 1, 0, 0x20, 3), {F1, MR3, R2}},
    {"ldfs.c.nc",	M, OpMXX6aHint (6, 1, 0, 0x26, 0), {F1, MR3, R2}},
    {"ldfs.c.nc.nt1",	M, OpMXX6aHint (6, 1, 0, 0x26, 1), {F1, MR3, R2}},
    {"ldfs.c.nc.nta",	M, OpMXX6aHint (6, 1, 0, 0x26, 3), {F1, MR3, R2}},
    {"ldfd.c.nc",	M, OpMXX6aHint (6, 1, 0, 0x27, 0), {F1, MR3, R2}},
    {"ldfd.c.nc.nt1",	M, OpMXX6aHint (6, 1, 0, 0x27, 1), {F1, MR3, R2}},
    {"ldfd.c.nc.nta",	M, OpMXX6aHint (6, 1, 0, 0x27, 3), {F1, MR3, R2}},
    {"ldf8.c.nc",	M, OpMXX6aHint (6, 1, 0, 0x25, 0), {F1, MR3, R2}},
    {"ldf8.c.nc.nt1",	M, OpMXX6aHint (6, 1, 0, 0x25, 1), {F1, MR3, R2}},
    {"ldf8.c.nc.nta",	M, OpMXX6aHint (6, 1, 0, 0x25, 3), {F1, MR3, R2}},
    {"ldfe.c.nc",	M, OpMXX6aHint (6, 1, 0, 0x24, 0), {F1, MR3, R2}},
    {"ldfe.c.nc.nt1",	M, OpMXX6aHint (6, 1, 0, 0x24, 1), {F1, MR3, R2}},
    {"ldfe.c.nc.nta",	M, OpMXX6aHint (6, 1, 0, 0x24, 3), {F1, MR3, R2}},

    /* floating-point store */
    {"stfs",		M, OpMXX6aHint (6, 0, 0, 0x32, 0), {MR3, F2}},
    {"stfs.nta",	M, OpMXX6aHint (6, 0, 0, 0x32, 3), {MR3, F2}},
    {"stfd",		M, OpMXX6aHint (6, 0, 0, 0x33, 0), {MR3, F2}},
    {"stfd.nta",	M, OpMXX6aHint (6, 0, 0, 0x33, 3), {MR3, F2}},
    {"stf8",		M, OpMXX6aHint (6, 0, 0, 0x31, 0), {MR3, F2}},
    {"stf8.nta",	M, OpMXX6aHint (6, 0, 0, 0x31, 3), {MR3, F2}},
    {"stfe",		M, OpMXX6aHint (6, 0, 0, 0x30, 0), {MR3, F2}},
    {"stfe.nta",	M, OpMXX6aHint (6, 0, 0, 0x30, 3), {MR3, F2}},
    {"stf.spill",	M, OpMXX6aHint (6, 0, 0, 0x3b, 0), {MR3, F2}},
    {"stf.spill.nta",	M, OpMXX6aHint (6, 0, 0, 0x3b, 3), {MR3, F2}},

    /* floating-point load pair */
    {"ldfps",		M2, OpMXX6aHint (6, 0, 1, 0x02, 0), {F1, F2, MR3}},
    {"ldfps.nt1",	M2, OpMXX6aHint (6, 0, 1, 0x02, 1), {F1, F2, MR3}},
    {"ldfps.nta",	M2, OpMXX6aHint (6, 0, 1, 0x02, 3), {F1, F2, MR3}},
    {"ldfpd",		M2, OpMXX6aHint (6, 0, 1, 0x03, 0), {F1, F2, MR3}},
    {"ldfpd.nt1",	M2, OpMXX6aHint (6, 0, 1, 0x03, 1), {F1, F2, MR3}},
    {"ldfpd.nta",	M2, OpMXX6aHint (6, 0, 1, 0x03, 3), {F1, F2, MR3}},
    {"ldfp8",		M2, OpMXX6aHint (6, 0, 1, 0x01, 0), {F1, F2, MR3}},
    {"ldfp8.nt1",	M2, OpMXX6aHint (6, 0, 1, 0x01, 1), {F1, F2, MR3}},
    {"ldfp8.nta",	M2, OpMXX6aHint (6, 0, 1, 0x01, 3), {F1, F2, MR3}},
    {"ldfps.s",		M2, OpMXX6aHint (6, 0, 1, 0x06, 0), {F1, F2, MR3}},
    {"ldfps.s.nt1",	M2, OpMXX6aHint (6, 0, 1, 0x06, 1), {F1, F2, MR3}},
    {"ldfps.s.nta",	M2, OpMXX6aHint (6, 0, 1, 0x06, 3), {F1, F2, MR3}},
    {"ldfpd.s",		M2, OpMXX6aHint (6, 0, 1, 0x07, 0), {F1, F2, MR3}},
    {"ldfpd.s.nt1",	M2, OpMXX6aHint (6, 0, 1, 0x07, 1), {F1, F2, MR3}},
    {"ldfpd.s.nta",	M2, OpMXX6aHint (6, 0, 1, 0x07, 3), {F1, F2, MR3}},
    {"ldfp8.s",		M2, OpMXX6aHint (6, 0, 1, 0x05, 0), {F1, F2, MR3}},
    {"ldfp8.s.nt1",	M2, OpMXX6aHint (6, 0, 1, 0x05, 1), {F1, F2, MR3}},
    {"ldfp8.s.nta",	M2, OpMXX6aHint (6, 0, 1, 0x05, 3), {F1, F2, MR3}},
    {"ldfps.a",		M2, OpMXX6aHint (6, 0, 1, 0x0a, 0), {F1, F2, MR3}},
    {"ldfps.a.nt1",	M2, OpMXX6aHint (6, 0, 1, 0x0a, 1), {F1, F2, MR3}},
    {"ldfps.a.nta",	M2, OpMXX6aHint (6, 0, 1, 0x0a, 3), {F1, F2, MR3}},
    {"ldfpd.a",		M2, OpMXX6aHint (6, 0, 1, 0x0b, 0), {F1, F2, MR3}},
    {"ldfpd.a.nt1",	M2, OpMXX6aHint (6, 0, 1, 0x0b, 1), {F1, F2, MR3}},
    {"ldfpd.a.nta",	M2, OpMXX6aHint (6, 0, 1, 0x0b, 3), {F1, F2, MR3}},
    {"ldfp8.a",		M2, OpMXX6aHint (6, 0, 1, 0x09, 0), {F1, F2, MR3}},
    {"ldfp8.a.nt1",	M2, OpMXX6aHint (6, 0, 1, 0x09, 1), {F1, F2, MR3}},
    {"ldfp8.a.nta",	M2, OpMXX6aHint (6, 0, 1, 0x09, 3), {F1, F2, MR3}},
    {"ldfps.sa",	M2, OpMXX6aHint (6, 0, 1, 0x0e, 0), {F1, F2, MR3}},
    {"ldfps.sa.nt1",	M2, OpMXX6aHint (6, 0, 1, 0x0e, 1), {F1, F2, MR3}},
    {"ldfps.sa.nta",	M2, OpMXX6aHint (6, 0, 1, 0x0e, 3), {F1, F2, MR3}},
    {"ldfpd.sa",	M2, OpMXX6aHint (6, 0, 1, 0x0f, 0), {F1, F2, MR3}},
    {"ldfpd.sa.nt1",	M2, OpMXX6aHint (6, 0, 1, 0x0f, 1), {F1, F2, MR3}},
    {"ldfpd.sa.nta",	M2, OpMXX6aHint (6, 0, 1, 0x0f, 3), {F1, F2, MR3}},
    {"ldfp8.sa",	M2, OpMXX6aHint (6, 0, 1, 0x0d, 0), {F1, F2, MR3}},
    {"ldfp8.sa.nt1",	M2, OpMXX6aHint (6, 0, 1, 0x0d, 1), {F1, F2, MR3}},
    {"ldfp8.sa.nta",	M2, OpMXX6aHint (6, 0, 1, 0x0d, 3), {F1, F2, MR3}},
    {"ldfps.c.clr",	M2, OpMXX6aHint (6, 0, 1, 0x22, 0), {F1, F2, MR3}},
    {"ldfps.c.clr.nt1",	M2, OpMXX6aHint (6, 0, 1, 0x22, 1), {F1, F2, MR3}},
    {"ldfps.c.clr.nta",	M2, OpMXX6aHint (6, 0, 1, 0x22, 3), {F1, F2, MR3}},
    {"ldfpd.c.clr",	M2, OpMXX6aHint (6, 0, 1, 0x23, 0), {F1, F2, MR3}},
    {"ldfpd.c.clr.nt1",	M2, OpMXX6aHint (6, 0, 1, 0x23, 1), {F1, F2, MR3}},
    {"ldfpd.c.clr.nta",	M2, OpMXX6aHint (6, 0, 1, 0x23, 3), {F1, F2, MR3}},
    {"ldfp8.c.clr",	M2, OpMXX6aHint (6, 0, 1, 0x21, 0), {F1, F2, MR3}},
    {"ldfp8.c.clr.nt1",	M2, OpMXX6aHint (6, 0, 1, 0x21, 1), {F1, F2, MR3}},
    {"ldfp8.c.clr.nta",	M2, OpMXX6aHint (6, 0, 1, 0x21, 3), {F1, F2, MR3}},
    {"ldfps.c.nc",	M2, OpMXX6aHint (6, 0, 1, 0x26, 0), {F1, F2, MR3}},
    {"ldfps.c.nc.nt1",	M2, OpMXX6aHint (6, 0, 1, 0x26, 1), {F1, F2, MR3}},
    {"ldfps.c.nc.nta",	M2, OpMXX6aHint (6, 0, 1, 0x26, 3), {F1, F2, MR3}},
    {"ldfpd.c.nc",	M2, OpMXX6aHint (6, 0, 1, 0x27, 0), {F1, F2, MR3}},
    {"ldfpd.c.nc.nt1",	M2, OpMXX6aHint (6, 0, 1, 0x27, 1), {F1, F2, MR3}},
    {"ldfpd.c.nc.nta",	M2, OpMXX6aHint (6, 0, 1, 0x27, 3), {F1, F2, MR3}},
    {"ldfp8.c.nc",	M2, OpMXX6aHint (6, 0, 1, 0x25, 0), {F1, F2, MR3}},
    {"ldfp8.c.nc.nt1",	M2, OpMXX6aHint (6, 0, 1, 0x25, 1), {F1, F2, MR3}},
    {"ldfp8.c.nc.nta",	M2, OpMXX6aHint (6, 0, 1, 0x25, 3), {F1, F2, MR3}},

    /* floating-point load pair w/increment by immediate */
#define LD(a,b,c)	M2, OpMXX6aHint (6, 1, 1, a, b), {F1, F2, MR3, c}
    {"ldfps",		LD (0x02, 0, C8)},
    {"ldfps.nt1",	LD (0x02, 1, C8)},
    {"ldfps.nta",	LD (0x02, 3, C8)},
    {"ldfpd",		LD (0x03, 0, C16)},
    {"ldfpd.nt1",	LD (0x03, 1, C16)},
    {"ldfpd.nta",	LD (0x03, 3, C16)},
    {"ldfp8",		LD (0x01, 0, C16)},
    {"ldfp8.nt1",	LD (0x01, 1, C16)},
    {"ldfp8.nta",	LD (0x01, 3, C16)},
    {"ldfps.s",		LD (0x06, 0, C8)},
    {"ldfps.s.nt1",	LD (0x06, 1, C8)},
    {"ldfps.s.nta",	LD (0x06, 3, C8)},
    {"ldfpd.s",		LD (0x07, 0, C16)},
    {"ldfpd.s.nt1",	LD (0x07, 1, C16)},
    {"ldfpd.s.nta",	LD (0x07, 3, C16)},
    {"ldfp8.s",		LD (0x05, 0, C16)},
    {"ldfp8.s.nt1",	LD (0x05, 1, C16)},
    {"ldfp8.s.nta",	LD (0x05, 3, C16)},
    {"ldfps.a",		LD (0x0a, 0, C8)},
    {"ldfps.a.nt1",	LD (0x0a, 1, C8)},
    {"ldfps.a.nta",	LD (0x0a, 3, C8)},
    {"ldfpd.a",		LD (0x0b, 0, C16)},
    {"ldfpd.a.nt1",	LD (0x0b, 1, C16)},
    {"ldfpd.a.nta",	LD (0x0b, 3, C16)},
    {"ldfp8.a",		LD (0x09, 0, C16)},
    {"ldfp8.a.nt1",	LD (0x09, 1, C16)},
    {"ldfp8.a.nta",	LD (0x09, 3, C16)},
    {"ldfps.sa",	LD (0x0e, 0, C8)},
    {"ldfps.sa.nt1",	LD (0x0e, 1, C8)},
    {"ldfps.sa.nta",	LD (0x0e, 3, C8)},
    {"ldfpd.sa",	LD (0x0f, 0, C16)},
    {"ldfpd.sa.nt1",	LD (0x0f, 1, C16)},
    {"ldfpd.sa.nta",	LD (0x0f, 3, C16)},
    {"ldfp8.sa",	LD (0x0d, 0, C16)},
    {"ldfp8.sa.nt1",	LD (0x0d, 1, C16)},
    {"ldfp8.sa.nta",	LD (0x0d, 3, C16)},
    {"ldfps.c.clr",	LD (0x22, 0, C8)},
    {"ldfps.c.clr.nt1",	LD (0x22, 1, C8)},
    {"ldfps.c.clr.nta",	LD (0x22, 3, C8)},
    {"ldfpd.c.clr",	LD (0x23, 0, C16)},
    {"ldfpd.c.clr.nt1",	LD (0x23, 1, C16)},
    {"ldfpd.c.clr.nta",	LD (0x23, 3, C16)},
    {"ldfp8.c.clr",	LD (0x21, 0, C16)},
    {"ldfp8.c.clr.nt1",	LD (0x21, 1, C16)},
    {"ldfp8.c.clr.nta",	LD (0x21, 3, C16)},
    {"ldfps.c.nc",	LD (0x26, 0, C8)},
    {"ldfps.c.nc.nt1",	LD (0x26, 1, C8)},
    {"ldfps.c.nc.nta",	LD (0x26, 3, C8)},
    {"ldfpd.c.nc",	LD (0x27, 0, C16)},
    {"ldfpd.c.nc.nt1",	LD (0x27, 1, C16)},
    {"ldfpd.c.nc.nta",	LD (0x27, 3, C16)},
    {"ldfp8.c.nc",	LD (0x25, 0, C16)},
    {"ldfp8.c.nc.nt1",	LD (0x25, 1, C16)},
    {"ldfp8.c.nc.nta",	LD (0x25, 3, C16)},
#undef LD

    /* line prefetch */
    {"lfetch",			M0, OpMXX6aHint (6, 0, 0, 0x2c, 0), {MR3}},
    {"lfetch.nt1",		M0, OpMXX6aHint (6, 0, 0, 0x2c, 1), {MR3}},
    {"lfetch.nt2",		M0, OpMXX6aHint (6, 0, 0, 0x2c, 2), {MR3}},
    {"lfetch.nta",		M0, OpMXX6aHint (6, 0, 0, 0x2c, 3), {MR3}},
    {"lfetch.excl",		M0, OpMXX6aHint (6, 0, 0, 0x2d, 0), {MR3}},
    {"lfetch.excl.nt1",		M0, OpMXX6aHint (6, 0, 0, 0x2d, 1), {MR3}},
    {"lfetch.excl.nt2",		M0, OpMXX6aHint (6, 0, 0, 0x2d, 2), {MR3}},
    {"lfetch.excl.nta",		M0, OpMXX6aHint (6, 0, 0, 0x2d, 3), {MR3}},
    {"lfetch.fault",		M0, OpMXX6aHint (6, 0, 0, 0x2e, 0), {MR3}},
    {"lfetch.fault.nt1",	M0, OpMXX6aHint (6, 0, 0, 0x2e, 1), {MR3}},
    {"lfetch.fault.nt2",	M0, OpMXX6aHint (6, 0, 0, 0x2e, 2), {MR3}},
    {"lfetch.fault.nta",	M0, OpMXX6aHint (6, 0, 0, 0x2e, 3), {MR3}},
    {"lfetch.fault.excl",	M0, OpMXX6aHint (6, 0, 0, 0x2f, 0), {MR3}},
    {"lfetch.fault.excl.nt1",	M0, OpMXX6aHint (6, 0, 0, 0x2f, 1), {MR3}},
    {"lfetch.fault.excl.nt2",	M0, OpMXX6aHint (6, 0, 0, 0x2f, 2), {MR3}},
    {"lfetch.fault.excl.nta",	M0, OpMXX6aHint (6, 0, 0, 0x2f, 3), {MR3}},

    /* line prefetch w/increment by register */
    {"lfetch",			M0, OpMXX6aHint (6, 1, 0, 0x2c, 0), {MR3, R2}},
    {"lfetch.nt1",		M0, OpMXX6aHint (6, 1, 0, 0x2c, 1), {MR3, R2}},
    {"lfetch.nt2",		M0, OpMXX6aHint (6, 1, 0, 0x2c, 2), {MR3, R2}},
    {"lfetch.nta",		M0, OpMXX6aHint (6, 1, 0, 0x2c, 3), {MR3, R2}},
    {"lfetch.excl",		M0, OpMXX6aHint (6, 1, 0, 0x2d, 0), {MR3, R2}},
    {"lfetch.excl.nt1",		M0, OpMXX6aHint (6, 1, 0, 0x2d, 1), {MR3, R2}},
    {"lfetch.excl.nt2",		M0, OpMXX6aHint (6, 1, 0, 0x2d, 2), {MR3, R2}},
    {"lfetch.excl.nta",		M0, OpMXX6aHint (6, 1, 0, 0x2d, 3), {MR3, R2}},
    {"lfetch.fault",		M0, OpMXX6aHint (6, 1, 0, 0x2e, 0), {MR3, R2}},
    {"lfetch.fault.nt1",	M0, OpMXX6aHint (6, 1, 0, 0x2e, 1), {MR3, R2}},
    {"lfetch.fault.nt2",	M0, OpMXX6aHint (6, 1, 0, 0x2e, 2), {MR3, R2}},
    {"lfetch.fault.nta",	M0, OpMXX6aHint (6, 1, 0, 0x2e, 3), {MR3, R2}},
    {"lfetch.fault.excl",	M0, OpMXX6aHint (6, 1, 0, 0x2f, 0), {MR3, R2}},
    {"lfetch.fault.excl.nt1",	M0, OpMXX6aHint (6, 1, 0, 0x2f, 1), {MR3, R2}},
    {"lfetch.fault.excl.nt2",	M0, OpMXX6aHint (6, 1, 0, 0x2f, 2), {MR3, R2}},
    {"lfetch.fault.excl.nta",	M0, OpMXX6aHint (6, 1, 0, 0x2f, 3), {MR3, R2}},

    /* semaphore operations */
    {"setf.sig",	M, OpMXX6a (6, 0, 1, 0x1c), {F1, R2}},
    {"setf.exp",	M, OpMXX6a (6, 0, 1, 0x1d), {F1, R2}},
    {"setf.s",		M, OpMXX6a (6, 0, 1, 0x1e), {F1, R2}},
    {"setf.d",		M, OpMXX6a (6, 0, 1, 0x1f), {F1, R2}},

    {"ldfs",		M, OpX6aHint (7, 0x02, 0), {F1, MR3, IMM9b}},
    {"ldfs.nt1",	M, OpX6aHint (7, 0x02, 1), {F1, MR3, IMM9b}},
    {"ldfs.nta",	M, OpX6aHint (7, 0x02, 3), {F1, MR3, IMM9b}},
    {"ldfd",		M, OpX6aHint (7, 0x03, 0), {F1, MR3, IMM9b}},
    {"ldfd.nt1",	M, OpX6aHint (7, 0x03, 1), {F1, MR3, IMM9b}},
    {"ldfd.nta",	M, OpX6aHint (7, 0x03, 3), {F1, MR3, IMM9b}},
    {"ldf8",		M, OpX6aHint (7, 0x01, 0), {F1, MR3, IMM9b}},
    {"ldf8.nt1",	M, OpX6aHint (7, 0x01, 1), {F1, MR3, IMM9b}},
    {"ldf8.nta",	M, OpX6aHint (7, 0x01, 3), {F1, MR3, IMM9b}},
    {"ldfe",		M, OpX6aHint (7, 0x00, 0), {F1, MR3, IMM9b}},
    {"ldfe.nt1",	M, OpX6aHint (7, 0x00, 1), {F1, MR3, IMM9b}},
    {"ldfe.nta",	M, OpX6aHint (7, 0x00, 3), {F1, MR3, IMM9b}},
    {"ldfs.s",		M, OpX6aHint (7, 0x06, 0), {F1, MR3, IMM9b}},
    {"ldfs.s.nt1",	M, OpX6aHint (7, 0x06, 1), {F1, MR3, IMM9b}},
    {"ldfs.s.nta",	M, OpX6aHint (7, 0x06, 3), {F1, MR3, IMM9b}},
    {"ldfd.s",		M, OpX6aHint (7, 0x07, 0), {F1, MR3, IMM9b}},
    {"ldfd.s.nt1",	M, OpX6aHint (7, 0x07, 1), {F1, MR3, IMM9b}},
    {"ldfd.s.nta",	M, OpX6aHint (7, 0x07, 3), {F1, MR3, IMM9b}},
    {"ldf8.s",		M, OpX6aHint (7, 0x05, 0), {F1, MR3, IMM9b}},
    {"ldf8.s.nt1",	M, OpX6aHint (7, 0x05, 1), {F1, MR3, IMM9b}},
    {"ldf8.s.nta",	M, OpX6aHint (7, 0x05, 3), {F1, MR3, IMM9b}},
    {"ldfe.s",		M, OpX6aHint (7, 0x04, 0), {F1, MR3, IMM9b}},
    {"ldfe.s.nt1",	M, OpX6aHint (7, 0x04, 1), {F1, MR3, IMM9b}},
    {"ldfe.s.nta",	M, OpX6aHint (7, 0x04, 3), {F1, MR3, IMM9b}},
    {"ldfs.a",		M, OpX6aHint (7, 0x0a, 0), {F1, MR3, IMM9b}},
    {"ldfs.a.nt1",	M, OpX6aHint (7, 0x0a, 1), {F1, MR3, IMM9b}},
    {"ldfs.a.nta",	M, OpX6aHint (7, 0x0a, 3), {F1, MR3, IMM9b}},
    {"ldfd.a",		M, OpX6aHint (7, 0x0b, 0), {F1, MR3, IMM9b}},
    {"ldfd.a.nt1",	M, OpX6aHint (7, 0x0b, 1), {F1, MR3, IMM9b}},
    {"ldfd.a.nta",	M, OpX6aHint (7, 0x0b, 3), {F1, MR3, IMM9b}},
    {"ldf8.a",		M, OpX6aHint (7, 0x09, 0), {F1, MR3, IMM9b}},
    {"ldf8.a.nt1",	M, OpX6aHint (7, 0x09, 1), {F1, MR3, IMM9b}},
    {"ldf8.a.nta",	M, OpX6aHint (7, 0x09, 3), {F1, MR3, IMM9b}},
    {"ldfe.a",		M, OpX6aHint (7, 0x08, 0), {F1, MR3, IMM9b}},
    {"ldfe.a.nt1",	M, OpX6aHint (7, 0x08, 1), {F1, MR3, IMM9b}},
    {"ldfe.a.nta",	M, OpX6aHint (7, 0x08, 3), {F1, MR3, IMM9b}},
    {"ldfs.sa",		M, OpX6aHint (7, 0x0e, 0), {F1, MR3, IMM9b}},
    {"ldfs.sa.nt1",	M, OpX6aHint (7, 0x0e, 1), {F1, MR3, IMM9b}},
    {"ldfs.sa.nta",	M, OpX6aHint (7, 0x0e, 3), {F1, MR3, IMM9b}},
    {"ldfd.sa",		M, OpX6aHint (7, 0x0f, 0), {F1, MR3, IMM9b}},
    {"ldfd.sa.nt1",	M, OpX6aHint (7, 0x0f, 1), {F1, MR3, IMM9b}},
    {"ldfd.sa.nta",	M, OpX6aHint (7, 0x0f, 3), {F1, MR3, IMM9b}},
    {"ldf8.sa",		M, OpX6aHint (7, 0x0d, 0), {F1, MR3, IMM9b}},
    {"ldf8.sa.nt1",	M, OpX6aHint (7, 0x0d, 1), {F1, MR3, IMM9b}},
    {"ldf8.sa.nta",	M, OpX6aHint (7, 0x0d, 3), {F1, MR3, IMM9b}},
    {"ldfe.sa",		M, OpX6aHint (7, 0x0c, 0), {F1, MR3, IMM9b}},
    {"ldfe.sa.nt1",	M, OpX6aHint (7, 0x0c, 1), {F1, MR3, IMM9b}},
    {"ldfe.sa.nta",	M, OpX6aHint (7, 0x0c, 3), {F1, MR3, IMM9b}},
    {"ldf.fill",	M, OpX6aHint (7, 0x1b, 0), {F1, MR3, IMM9b}},
    {"ldf.fill.nt1",	M, OpX6aHint (7, 0x1b, 1), {F1, MR3, IMM9b}},
    {"ldf.fill.nta",	M, OpX6aHint (7, 0x1b, 3), {F1, MR3, IMM9b}},
    {"ldfs.c.clr",	M, OpX6aHint (7, 0x22, 0), {F1, MR3, IMM9b}},
    {"ldfs.c.clr.nt1",	M, OpX6aHint (7, 0x22, 1), {F1, MR3, IMM9b}},
    {"ldfs.c.clr.nta",	M, OpX6aHint (7, 0x22, 3), {F1, MR3, IMM9b}},
    {"ldfd.c.clr",	M, OpX6aHint (7, 0x23, 0), {F1, MR3, IMM9b}},
    {"ldfd.c.clr.nt1",	M, OpX6aHint (7, 0x23, 1), {F1, MR3, IMM9b}},
    {"ldfd.c.clr.nta",	M, OpX6aHint (7, 0x23, 3), {F1, MR3, IMM9b}},
    {"ldf8.c.clr",	M, OpX6aHint (7, 0x21, 0), {F1, MR3, IMM9b}},
    {"ldf8.c.clr.nt1",	M, OpX6aHint (7, 0x21, 1), {F1, MR3, IMM9b}},
    {"ldf8.c.clr.nta",	M, OpX6aHint (7, 0x21, 3), {F1, MR3, IMM9b}},
    {"ldfe.c.clr",	M, OpX6aHint (7, 0x20, 0), {F1, MR3, IMM9b}},
    {"ldfe.c.clr.nt1",	M, OpX6aHint (7, 0x20, 1), {F1, MR3, IMM9b}},
    {"ldfe.c.clr.nta",	M, OpX6aHint (7, 0x20, 3), {F1, MR3, IMM9b}},
    {"ldfs.c.nc",	M, OpX6aHint (7, 0x26, 0), {F1, MR3, IMM9b}},
    {"ldfs.c.nc.nt1",	M, OpX6aHint (7, 0x26, 1), {F1, MR3, IMM9b}},
    {"ldfs.c.nc.nta",	M, OpX6aHint (7, 0x26, 3), {F1, MR3, IMM9b}},
    {"ldfd.c.nc",	M, OpX6aHint (7, 0x27, 0), {F1, MR3, IMM9b}},
    {"ldfd.c.nc.nt1",	M, OpX6aHint (7, 0x27, 1), {F1, MR3, IMM9b}},
    {"ldfd.c.nc.nta",	M, OpX6aHint (7, 0x27, 3), {F1, MR3, IMM9b}},
    {"ldf8.c.nc",	M, OpX6aHint (7, 0x25, 0), {F1, MR3, IMM9b}},
    {"ldf8.c.nc.nt1",	M, OpX6aHint (7, 0x25, 1), {F1, MR3, IMM9b}},
    {"ldf8.c.nc.nta",	M, OpX6aHint (7, 0x25, 3), {F1, MR3, IMM9b}},
    {"ldfe.c.nc",	M, OpX6aHint (7, 0x24, 0), {F1, MR3, IMM9b}},
    {"ldfe.c.nc.nt1",	M, OpX6aHint (7, 0x24, 1), {F1, MR3, IMM9b}},
    {"ldfe.c.nc.nta",	M, OpX6aHint (7, 0x24, 3), {F1, MR3, IMM9b}},

    /* floating-point store w/increment by immediate */
    {"stfs",		M, OpX6aHint (7, 0x32, 0), {MR3, F2, IMM9a}},
    {"stfs.nta",	M, OpX6aHint (7, 0x32, 3), {MR3, F2, IMM9a}},
    {"stfd",		M, OpX6aHint (7, 0x33, 0), {MR3, F2, IMM9a}},
    {"stfd.nta",	M, OpX6aHint (7, 0x33, 3), {MR3, F2, IMM9a}},
    {"stf8",		M, OpX6aHint (7, 0x31, 0), {MR3, F2, IMM9a}},
    {"stf8.nta",	M, OpX6aHint (7, 0x31, 3), {MR3, F2, IMM9a}},
    {"stfe",		M, OpX6aHint (7, 0x30, 0), {MR3, F2, IMM9a}},
    {"stfe.nta",	M, OpX6aHint (7, 0x30, 3), {MR3, F2, IMM9a}},
    {"stf.spill",	M, OpX6aHint (7, 0x3b, 0), {MR3, F2, IMM9a}},
    {"stf.spill.nta",	M, OpX6aHint (7, 0x3b, 3), {MR3, F2, IMM9a}},

    /* line prefetch w/increment by immediate */
    {"lfetch",			M0, OpX6aHint (7, 0x2c, 0), {MR3, IMM9b}},
    {"lfetch.nt1",		M0, OpX6aHint (7, 0x2c, 1), {MR3, IMM9b}},
    {"lfetch.nt2",		M0, OpX6aHint (7, 0x2c, 2), {MR3, IMM9b}},
    {"lfetch.nta",		M0, OpX6aHint (7, 0x2c, 3), {MR3, IMM9b}},
    {"lfetch.excl",		M0, OpX6aHint (7, 0x2d, 0), {MR3, IMM9b}},
    {"lfetch.excl.nt1",		M0, OpX6aHint (7, 0x2d, 1), {MR3, IMM9b}},
    {"lfetch.excl.nt2",		M0, OpX6aHint (7, 0x2d, 2), {MR3, IMM9b}},
    {"lfetch.excl.nta",		M0, OpX6aHint (7, 0x2d, 3), {MR3, IMM9b}},
    {"lfetch.fault",		M0, OpX6aHint (7, 0x2e, 0), {MR3, IMM9b}},
    {"lfetch.fault.nt1",	M0, OpX6aHint (7, 0x2e, 1), {MR3, IMM9b}},
    {"lfetch.fault.nt2",	M0, OpX6aHint (7, 0x2e, 2), {MR3, IMM9b}},
    {"lfetch.fault.nta",	M0, OpX6aHint (7, 0x2e, 3), {MR3, IMM9b}},
    {"lfetch.fault.excl",	M0, OpX6aHint (7, 0x2f, 0), {MR3, IMM9b}},
    {"lfetch.fault.excl.nt1",	M0, OpX6aHint (7, 0x2f, 1), {MR3, IMM9b}},
    {"lfetch.fault.excl.nt2",	M0, OpX6aHint (7, 0x2f, 2), {MR3, IMM9b}},
    {"lfetch.fault.excl.nta",	M0, OpX6aHint (7, 0x2f, 3), {MR3, IMM9b}},

    {0}
  };

#undef M0
#undef M
#undef M2
#undef bM
#undef bX
#undef bX2
#undef bX3
#undef bX4
#undef bX6a
#undef bX6b
#undef bHint
#undef mM
#undef mX
#undef mX2
#undef mX3
#undef mX4
#undef mX6a
#undef mX6b
#undef mHint
#undef OpX3
#undef OpX3X6b
#undef OpX3X4
#undef OpX3X4X2
#undef OpX6aHint
#undef OpXX6aHint
#undef OpMXX6a
#undef OpMXX6aHint
