'\"
'\" Copyright (c) 1993-1998  Lucent Technologies, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" RCS: $Id: scope.n,v 1.2 1999/01/27 18:56:04 jingham Exp $
'\"
.so man.macros
.TH scope n "" Tcl "[incr\ Tcl]"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
scope \- capture the namespace context for a variable
.SH SYNOPSIS
\fBscope \fIname\fR
.BE

.SH DESCRIPTION
.PP
Creates a scoped value for the specified \fIname\fR, which must
be a variable name.  If the \fIname\fR is an instance variable,
then the scope command returns a string of the following form:
.CS
@itcl \fIobject varName\fP
.CE
This is recognized in any context as an instance variable belonging
to \fIobject\fR.  So with itcl3.0 and beyond, it is possible to use
instance variables in conjunction with widgets.  For example, if you
have an object with a private variable \fCx\fR, and you can use
\fCx\fR in conjunction with the \fC-textvariable\fR option of an
entry widget.  Before itcl3.0, only common variables could be used
in this manner.
.PP
If the \fIname\fR is not an instance variable, then it must be
a common variable or a global variable.  In that case, the scope
command returns the fully qualified name of the variable, e.g.,
\fC::foo::bar::x\fR.
.PP
If the \fIname\fR is not recognized as a variable, the scope
command returns an error.
.PP
Ordinary variable names refer to variables in the global namespace.
A scoped value captures a variable name together with its namespace
context in a way that allows it to be referenced properly later.
It is needed, for example, to wrap up variable names when a Tk
widget is used within a namespace:
.CS
namespace foo {
    private variable mode 1

    radiobutton .rb1 -text "Mode #1" \
        -variable [scope mode] -value 1
    pack .rb1

    radiobutton .rb2 -text "Mode #2" \
        -variable [scope mode] -value 2
    pack .rb2
}
.CE
Radiobuttons \fC.rb1\fR and \fC.rb2\fR interact via the variable
"mode" contained in the namespace "foo".  The \fBscope\fR command
guarantees this by returning the fully qualified variable name
\fC::foo::mode\fR.
.PP
You should never use the \fC@itcl\fR syntax directly.  For example,
it is a bad idea to write code like this:
.CS
set {@itcl ::fred x} 3
puts "value = ${@itcl ::fred x}"
.CE
Instead, you should always use the scope command to generate the
variable name dynamically.  Then, you can pass that name to a widget
or to any other bit of code in your program.

.SH KEYWORDS
code, namespace, variable
