/* A Bison parser, made by GNU Bison 3.0.4.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.0.4"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* Copy the first part of user declarations.  */
#line 36 "ada-exp.y" /* yacc.c:339  */


#include "defs.h"
#include <ctype.h>
#include "expression.h"
#include "value.h"
#include "parser-defs.h"
#include "language.h"
#include "ada-lang.h"
#include "bfd.h" /* Required by objfiles.h.  */
#include "symfile.h" /* Required by objfiles.h.  */
#include "objfiles.h" /* For have_full_symbols and have_partial_symbols */
#include "frame.h"
#include "block.h"
#include "ada-exp.h"

#define parse_type(ps) builtin_type (ps->gdbarch ())

/* Remap normal yacc parser interface names (yyparse, yylex, yyerror,
   etc).  */
#define GDB_YY_REMAP_PREFIX ada_
#include "yy-remap.h"

struct name_info {
  struct symbol *sym;
  struct minimal_symbol *msym;
  const struct block *block;
  struct stoken stoken;
};

/* The state of the parser, used internally when we are parsing the
   expression.  */

static struct parser_state *pstate = NULL;

/* The original expression string.  */
static const char *original_expr;

int yyparse (void);

static int yylex (void);

static void yyerror (const char *);

static void write_int (struct parser_state *, LONGEST, struct type *);

static void write_object_renaming (struct parser_state *,
				   const struct block *, const char *, int,
				   const char *, int);

static struct type* write_var_or_type (struct parser_state *,
				       const struct block *, struct stoken);
static struct type *write_var_or_type_completion (struct parser_state *,
						  const struct block *,
						  struct stoken);

static void write_name_assoc (struct parser_state *, struct stoken);

static const struct block *block_lookup (const struct block *, const char *);

static void write_ambiguous_var (struct parser_state *,
				 const struct block *, const char *, int);

static struct type *type_int (struct parser_state *);

static struct type *type_long (struct parser_state *);

static struct type *type_long_long (struct parser_state *);

static struct type *type_long_double (struct parser_state *);

static struct type *type_for_char (struct parser_state *, ULONGEST);

static struct type *type_boolean (struct parser_state *);

static struct type *type_system_address (struct parser_state *);

static std::string find_completion_bounds (struct parser_state *);

using namespace expr;

/* Handle Ada type resolution for OP.  DEPROCEDURE_P and CONTEXT_TYPE
   are passed to the resolve method, if called.  */
static operation_up
resolve (operation_up &&op, bool deprocedure_p, struct type *context_type)
{
  operation_up result = std::move (op);
  ada_resolvable *res = dynamic_cast<ada_resolvable *> (result.get ());
  if (res != nullptr)
    return res->replace (std::move (result),
			 pstate->expout.get (),
			 deprocedure_p,
			 pstate->parse_completion,
			 pstate->block_tracker,
			 context_type);
  return result;
}

/* Like parser_state::pop, but handles Ada type resolution.
   DEPROCEDURE_P and CONTEXT_TYPE are passed to the resolve method, if
   called.  */
static operation_up
ada_pop (bool deprocedure_p = true, struct type *context_type = nullptr)
{
  /* Of course it's ok to call parser_state::pop here... */
  return resolve (pstate->pop (), deprocedure_p, context_type);
}

/* Like parser_state::wrap, but use ada_pop to pop the value.  */
template<typename T>
void
ada_wrap ()
{
  operation_up arg = ada_pop ();
  pstate->push_new<T> (std::move (arg));
}

/* Create and push an address-of operation, as appropriate for Ada.
   If TYPE is not NULL, the resulting operation will be wrapped in a
   cast to TYPE.  */
static void
ada_addrof (struct type *type = nullptr)
{
  operation_up arg = ada_pop (false);
  operation_up addr = make_operation<unop_addr_operation> (std::move (arg));
  operation_up wrapped
    = make_operation<ada_wrapped_operation> (std::move (addr));
  if (type != nullptr)
    wrapped = make_operation<unop_cast_operation> (std::move (wrapped), type);
  pstate->push (std::move (wrapped));
}

/* Handle operator overloading.  Either returns a function all
   operation wrapping the arguments, or it returns null, leaving the
   caller to construct the appropriate operation.  If RHS is null, a
   unary operator is assumed.  */
static operation_up
maybe_overload (enum exp_opcode op, operation_up &lhs, operation_up &rhs)
{
  struct value *args[2];

  int nargs = 1;
  args[0] = lhs->evaluate (nullptr, pstate->expout.get (),
			   EVAL_AVOID_SIDE_EFFECTS);
  if (rhs == nullptr)
    args[1] = nullptr;
  else
    {
      args[1] = rhs->evaluate (nullptr, pstate->expout.get (),
			       EVAL_AVOID_SIDE_EFFECTS);
      ++nargs;
    }

  block_symbol fn = ada_find_operator_symbol (op, pstate->parse_completion,
					      nargs, args);
  if (fn.symbol == nullptr)
    return {};

  if (symbol_read_needs_frame (fn.symbol))
    pstate->block_tracker->update (fn.block, INNERMOST_BLOCK_FOR_SYMBOLS);
  operation_up callee = make_operation<ada_var_value_operation> (fn);

  std::vector<operation_up> argvec;
  argvec.push_back (std::move (lhs));
  if (rhs != nullptr)
    argvec.push_back (std::move (rhs));
  return make_operation<ada_funcall_operation> (std::move (callee),
						std::move (argvec));
}

/* Like parser_state::wrap, but use ada_pop to pop the value, and
   handle unary overloading.  */
template<typename T>
void
ada_wrap_overload (enum exp_opcode op)
{
  operation_up arg = ada_pop ();
  operation_up empty;

  operation_up call = maybe_overload (op, arg, empty);
  if (call == nullptr)
    call = make_operation<T> (std::move (arg));
  pstate->push (std::move (call));
}

/* A variant of parser_state::wrap2 that uses ada_pop to pop both
   operands, and then pushes a new Ada-wrapped operation of the
   template type T.  */
template<typename T>
void
ada_un_wrap2 (enum exp_opcode op)
{
  operation_up rhs = ada_pop ();
  operation_up lhs = ada_pop ();

  operation_up wrapped = maybe_overload (op, lhs, rhs);
  if (wrapped == nullptr)
    {
      wrapped = make_operation<T> (std::move (lhs), std::move (rhs));
      wrapped = make_operation<ada_wrapped_operation> (std::move (wrapped));
    }
  pstate->push (std::move (wrapped));
}

/* A variant of parser_state::wrap2 that uses ada_pop to pop both
   operands.  Unlike ada_un_wrap2, ada_wrapped_operation is not
   used.  */
template<typename T>
void
ada_wrap2 (enum exp_opcode op)
{
  operation_up rhs = ada_pop ();
  operation_up lhs = ada_pop ();
  operation_up call = maybe_overload (op, lhs, rhs);
  if (call == nullptr)
    call = make_operation<T> (std::move (lhs), std::move (rhs));
  pstate->push (std::move (call));
}

/* A variant of parser_state::wrap2 that uses ada_pop to pop both
   operands.  OP is also passed to the constructor of the new binary
   operation.  */
template<typename T>
void
ada_wrap_op (enum exp_opcode op)
{
  operation_up rhs = ada_pop ();
  operation_up lhs = ada_pop ();
  operation_up call = maybe_overload (op, lhs, rhs);
  if (call == nullptr)
    call = make_operation<T> (op, std::move (lhs), std::move (rhs));
  pstate->push (std::move (call));
}

/* Pop three operands using ada_pop, then construct a new ternary
   operation of type T and push it.  */
template<typename T>
void
ada_wrap3 ()
{
  operation_up rhs = ada_pop ();
  operation_up mid = ada_pop ();
  operation_up lhs = ada_pop ();
  pstate->push_new<T> (std::move (lhs), std::move (mid), std::move (rhs));
}

/* Pop NARGS operands, then a callee operand, and use these to
   construct and push a new Ada function call operation.  */
static void
ada_funcall (int nargs)
{
  /* We use the ordinary pop here, because we're going to do
     resolution in a separate step, in order to handle array
     indices.  */
  std::vector<operation_up> args = pstate->pop_vector (nargs);
  /* Call parser_state::pop here, because we don't want to
     function-convert the callee slot of a call we're already
     constructing.  */
  operation_up callee = pstate->pop ();

  ada_var_value_operation *vvo
    = dynamic_cast<ada_var_value_operation *> (callee.get ());
  int array_arity = 0;
  struct type *callee_t = nullptr;
  if (vvo == nullptr
      || vvo->get_symbol ()->domain () != UNDEF_DOMAIN)
    {
      struct value *callee_v = callee->evaluate (nullptr,
						 pstate->expout.get (),
						 EVAL_AVOID_SIDE_EFFECTS);
      callee_t = ada_check_typedef (value_type (callee_v));
      array_arity = ada_array_arity (callee_t);
    }

  for (int i = 0; i < nargs; ++i)
    {
      struct type *subtype = nullptr;
      if (i < array_arity)
	subtype = ada_index_type (callee_t, i + 1, "array type");
      args[i] = resolve (std::move (args[i]), true, subtype);
    }

  std::unique_ptr<ada_funcall_operation> funcall
    (new ada_funcall_operation (std::move (callee), std::move (args)));
  funcall->resolve (pstate->expout.get (), true, pstate->parse_completion,
		    pstate->block_tracker, nullptr);
  pstate->push (std::move (funcall));
}

/* The components being constructed during this parse.  */
static std::vector<ada_component_up> components;

/* Create a new ada_component_up of the indicated type and arguments,
   and push it on the global 'components' vector.  */
template<typename T, typename... Arg>
void
push_component (Arg... args)
{
  components.emplace_back (new T (std::forward<Arg> (args)...));
}

/* Examine the final element of the 'components' vector, and return it
   as a pointer to an ada_choices_component.  The caller is
   responsible for ensuring that the final element is in fact an
   ada_choices_component.  */
static ada_choices_component *
choice_component ()
{
  ada_component *last = components.back ().get ();
  return gdb::checked_static_cast<ada_choices_component *> (last);
}

/* Pop the most recent component from the global stack, and return
   it.  */
static ada_component_up
pop_component ()
{
  ada_component_up result = std::move (components.back ());
  components.pop_back ();
  return result;
}

/* Pop the N most recent components from the global stack, and return
   them in a vector.  */
static std::vector<ada_component_up>
pop_components (int n)
{
  std::vector<ada_component_up> result (n);
  for (int i = 1; i <= n; ++i)
    result[n - i] = pop_component ();
  return result;
}

/* The associations being constructed during this parse.  */
static std::vector<ada_association_up> associations;

/* Create a new ada_association_up of the indicated type and
   arguments, and push it on the global 'associations' vector.  */
template<typename T, typename... Arg>
void
push_association (Arg... args)
{
  associations.emplace_back (new T (std::forward<Arg> (args)...));
}

/* Pop the most recent association from the global stack, and return
   it.  */
static ada_association_up
pop_association ()
{
  ada_association_up result = std::move (associations.back ());
  associations.pop_back ();
  return result;
}

/* Pop the N most recent associations from the global stack, and
   return them in a vector.  */
static std::vector<ada_association_up>
pop_associations (int n)
{
  std::vector<ada_association_up> result (n);
  for (int i = 1; i <= n; ++i)
    result[n - i] = pop_association ();
  return result;
}

/* Expression completer for attributes.  */
struct ada_tick_completer : public expr_completion_base
{
  explicit ada_tick_completer (std::string &&name)
    : m_name (std::move (name))
  {
  }

  bool complete (struct expression *exp,
		 completion_tracker &tracker) override;

private:

  std::string m_name;
};

/* Make a new ada_tick_completer and wrap it in a unique pointer.  */
static std::unique_ptr<expr_completion_base>
make_tick_completer (struct stoken tok)
{
  return (std::unique_ptr<expr_completion_base>
	  (new ada_tick_completer (std::string (tok.ptr, tok.length))));
}


#line 458 "ada-exp.c.tmp" /* yacc.c:339  */

# ifndef YY_NULLPTRPTR
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULLPTRPTR nullptr
#  else
#   define YY_NULLPTRPTR 0
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif


/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    INT = 258,
    NULL_PTR = 259,
    CHARLIT = 260,
    FLOAT = 261,
    TRUEKEYWORD = 262,
    FALSEKEYWORD = 263,
    COLONCOLON = 264,
    STRING = 265,
    NAME = 266,
    DOT_ID = 267,
    TICK_COMPLETE = 268,
    DOT_COMPLETE = 269,
    NAME_COMPLETE = 270,
    DOLLAR_VARIABLE = 271,
    ASSIGN = 272,
    _AND_ = 273,
    OR = 274,
    XOR = 275,
    THEN = 276,
    ELSE = 277,
    NOTEQUAL = 278,
    LEQ = 279,
    GEQ = 280,
    IN = 281,
    DOTDOT = 282,
    UNARY = 283,
    MOD = 284,
    REM = 285,
    STARSTAR = 286,
    ABS = 287,
    NOT = 288,
    VAR = 289,
    ARROW = 290,
    TICK_ACCESS = 291,
    TICK_ADDRESS = 292,
    TICK_FIRST = 293,
    TICK_LAST = 294,
    TICK_LENGTH = 295,
    TICK_MAX = 296,
    TICK_MIN = 297,
    TICK_MODULUS = 298,
    TICK_POS = 299,
    TICK_RANGE = 300,
    TICK_SIZE = 301,
    TICK_TAG = 302,
    TICK_VAL = 303,
    NEW = 304,
    OTHERS = 305
  };
#endif
/* Tokens.  */
#define INT 258
#define NULL_PTR 259
#define CHARLIT 260
#define FLOAT 261
#define TRUEKEYWORD 262
#define FALSEKEYWORD 263
#define COLONCOLON 264
#define STRING 265
#define NAME 266
#define DOT_ID 267
#define TICK_COMPLETE 268
#define DOT_COMPLETE 269
#define NAME_COMPLETE 270
#define DOLLAR_VARIABLE 271
#define ASSIGN 272
#define _AND_ 273
#define OR 274
#define XOR 275
#define THEN 276
#define ELSE 277
#define NOTEQUAL 278
#define LEQ 279
#define GEQ 280
#define IN 281
#define DOTDOT 282
#define UNARY 283
#define MOD 284
#define REM 285
#define STARSTAR 286
#define ABS 287
#define NOT 288
#define VAR 289
#define ARROW 290
#define TICK_ACCESS 291
#define TICK_ADDRESS 292
#define TICK_FIRST 293
#define TICK_LAST 294
#define TICK_LENGTH 295
#define TICK_MAX 296
#define TICK_MIN 297
#define TICK_MODULUS 298
#define TICK_POS 299
#define TICK_RANGE 300
#define TICK_SIZE 301
#define TICK_TAG 302
#define TICK_VAL 303
#define NEW 304
#define OTHERS 305

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED

union YYSTYPE
{
#line 429 "ada-exp.y" /* yacc.c:355  */

    LONGEST lval;
    struct {
      LONGEST val;
      struct type *type;
    } typed_val;
    struct {
      gdb_byte val[16];
      struct type *type;
    } typed_val_float;
    struct type *tval;
    struct stoken sval;
    const struct block *bval;
    struct internalvar *ivar;
  

#line 612 "ada-exp.c.tmp" /* yacc.c:355  */
};

typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif


extern YYSTYPE yylval;

int yyparse (void);



/* Copy the second part of user declarations.  */

#line 629 "ada-exp.c.tmp" /* yacc.c:358  */

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE
# if (defined __GNUC__                                               \
      && (2 < __GNUC__ || (__GNUC__ == 2 && 96 <= __GNUC_MINOR__)))  \
     || defined __SUNPRO_C && 0x5110 <= __SUNPRO_C
#  define YY_ATTRIBUTE(Spec) __attribute__(Spec)
# else
#  define YY_ATTRIBUTE(Spec) /* empty */
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# define YY_ATTRIBUTE_PURE   YY_ATTRIBUTE ((__pure__))
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# define YY_ATTRIBUTE_UNUSED YY_ATTRIBUTE ((__unused__))
#endif

#if !defined _Noreturn \
     && (!defined __STDC_VERSION__ || __STDC_VERSION__ < 201112)
# if defined _MSC_VER && 1200 <= _MSC_VER
#  define _Noreturn __declspec (noreturn)
# else
#  define _Noreturn YY_ATTRIBUTE ((__noreturn__))
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN \
    _Pragma ("GCC diagnostic push") \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")\
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif


#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or xmalloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined xmalloc) \
             && (defined YYFREE || defined xfree)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC xmalloc
#   if ! defined xmalloc && ! defined EXIT_SUCCESS
void *xmalloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE xfree
#   if ! defined xfree && ! defined EXIT_SUCCESS
void xfree (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYSIZE_T yynewbytes;                                            \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / sizeof (*yyptr);                          \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, (Count) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYSIZE_T yyi;                         \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  58
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   801

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  71
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  25
/* YYNRULES -- Number of rules.  */
#define YYNRULES  119
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  230

/* YYTRANSLATE[YYX] -- Symbol number corresponding to YYX as returned
   by yylex, with out-of-bounds checking.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   305

#define YYTRANSLATE(YYX)                                                \
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, without out-of-bounds checking.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    34,    66,
      60,    65,    36,    32,    67,    33,    59,    37,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,    64,
      25,    23,    26,     2,    31,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    61,     2,    70,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    68,    45,    69,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    24,    27,
      28,    29,    30,    35,    38,    39,    40,    41,    42,    43,
      44,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    62,    63
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,   491,   491,   495,   496,   498,   514,   527,   541,   543,
     558,   570,   572,   580,   591,   597,   601,   608,   611,   615,
     631,   638,   642,   645,   647,   649,   651,   655,   668,   672,
     676,   680,   684,   688,   692,   696,   700,   704,   707,   711,
     715,   719,   721,   728,   736,   739,   747,   758,   762,   766,
     770,   771,   772,   773,   774,   775,   779,   782,   788,   791,
     797,   800,   806,   808,   812,   815,   828,   830,   832,   836,
     842,   848,   854,   856,   858,   860,   862,   864,   870,   880,
     882,   887,   896,   899,   903,   907,   913,   924,   932,   939,
     941,   945,   949,   951,   957,   959,   965,   973,   984,   986,
     991,  1002,  1003,  1009,  1014,  1020,  1029,  1030,  1031,  1035,
    1042,  1055,  1061,  1067,  1076,  1081,  1086,  1100,  1102,  1104
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 0
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "INT", "NULL_PTR", "CHARLIT", "FLOAT",
  "TRUEKEYWORD", "FALSEKEYWORD", "COLONCOLON", "STRING", "NAME", "DOT_ID",
  "TICK_COMPLETE", "DOT_COMPLETE", "NAME_COMPLETE", "DOLLAR_VARIABLE",
  "ASSIGN", "_AND_", "OR", "XOR", "THEN", "ELSE", "'='", "NOTEQUAL", "'<'",
  "'>'", "LEQ", "GEQ", "IN", "DOTDOT", "'@'", "'+'", "'-'", "'&'", "UNARY",
  "'*'", "'/'", "MOD", "REM", "STARSTAR", "ABS", "NOT", "VAR", "ARROW",
  "'|'", "TICK_ACCESS", "TICK_ADDRESS", "TICK_FIRST", "TICK_LAST",
  "TICK_LENGTH", "TICK_MAX", "TICK_MIN", "TICK_MODULUS", "TICK_POS",
  "TICK_RANGE", "TICK_SIZE", "TICK_TAG", "TICK_VAL", "'.'", "'('", "'['",
  "NEW", "OTHERS", "';'", "')'", "'\\''", "','", "'{'", "'}'", "']'",
  "$accept", "start", "exp1", "primary", "simple_exp", "arglist",
  "relation", "exp", "and_exp", "and_then_exp", "or_exp", "or_else_exp",
  "xor_exp", "tick_arglist", "type_prefix", "opt_type_prefix",
  "var_or_type", "block", "aggregate", "aggregate_component_list",
  "positional_list", "component_groups", "others", "component_group",
  "component_associations", YY_NULLPTRPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,    61,   278,    60,    62,   279,   280,   281,
     282,    64,    43,    45,    38,   283,    42,    47,   284,   285,
     286,   287,   288,   289,   290,   124,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,    46,
      40,    91,   304,   305,    59,    41,    39,    44,   123,   125,
      93
};
# endif

#define YYPACT_NINF -106

#define yypact_value_is_default(Yystate) \
  (!!((Yystate) == (-106)))

#define YYTABLE_NINF -82

#define yytable_value_is_error(Yytable_value) \
  0

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
     421,  -106,  -106,  -106,  -106,  -106,  -106,  -106,     6,  -106,
    -106,   421,   421,   541,   541,   421,   421,   274,    45,    17,
      61,    10,   566,   723,    26,  -106,    48,    52,    57,    60,
      76,   -32,    49,    99,    32,  -106,  -106,  -106,   621,     2,
       2,    -7,    -7,     2,     2,     4,    54,   -29,   660,    35,
      39,   274,  -106,  -106,    38,  -106,  -106,    37,  -106,   421,
    -106,  -106,  -106,   421,  -106,  -106,    51,    51,    51,  -106,
    -106,   260,   421,   421,   421,   421,   421,   421,   421,   421,
     421,   421,   421,   421,   421,   421,   421,   421,   421,    79,
     340,   381,   421,   421,    92,   421,    94,   421,  -106,    71,
      72,    73,    75,   260,    77,    22,  -106,   421,   461,   421,
    -106,   421,   421,   461,  -106,  -106,    47,  -106,   274,   541,
    -106,  -106,   114,  -106,  -106,  -106,    16,   683,   -38,  -106,
      66,   553,   553,   553,   553,   553,   553,   582,   534,   171,
     761,     2,     2,     2,    98,    98,    98,    98,    98,   421,
     421,  -106,   421,  -106,  -106,  -106,   421,  -106,   421,  -106,
     421,   421,   421,   421,   703,   -10,   421,  -106,  -106,  -106,
     736,  -106,  -106,   326,  -106,  -106,  -106,  -106,    -7,    89,
     421,   421,  -106,   501,  -106,    51,   421,   605,   752,   192,
    -106,  -106,  -106,  -106,    93,    97,   100,   103,   421,  -106,
     105,   421,   461,  -106,  -106,    90,    21,  -106,  -106,   553,
      51,   421,  -106,   421,   421,  -106,   109,  -106,  -106,  -106,
    -106,   421,  -106,   553,   107,   108,  -106,  -106,  -106,  -106
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
      83,    84,    87,    85,    86,    89,    90,    88,    92,    93,
      15,    83,    83,    83,    83,    83,    83,    83,     0,     0,
       0,     2,    17,    37,    50,     3,    51,    52,    53,    54,
      55,    82,     0,    14,     0,    16,    98,    96,    17,    19,
      18,   118,   117,    21,    20,    92,     0,     0,    37,     3,
       0,    83,   101,   106,   107,   110,    91,     0,     1,    83,
       6,    68,     7,    83,    66,    67,    79,    79,    79,    72,
      73,    83,    83,    83,    83,    83,    83,    83,    83,    83,
      83,    83,    83,    83,    83,    83,    83,    83,    83,     0,
      83,    83,    83,    83,     0,    83,     0,    83,    78,     0,
       0,     0,     0,    83,     0,    94,    95,    83,    83,    83,
      13,    83,    83,    83,   104,   100,   102,   103,    83,    83,
       4,     5,     0,    69,    70,    71,    92,    37,     0,    23,
       0,    38,    39,    48,    49,    40,    47,    17,     0,    14,
      33,    34,    36,    35,    29,    30,    32,    31,    28,    83,
      83,    56,    83,    60,    64,    57,    83,    61,    83,    65,
      83,    83,    83,    83,    37,     0,    83,    99,    97,   111,
       0,   114,   109,     0,   112,   115,   105,   108,    27,     0,
      83,    83,     8,    83,   119,    79,    83,    17,     0,    14,
      58,    62,    59,    63,     0,     0,     0,     0,    83,     9,
       0,    83,    83,    80,    24,     0,    92,    25,    42,    41,
      79,    83,    77,    83,    83,    76,     0,    10,   113,   116,
      11,    83,    45,    44,     0,     0,    12,    26,    75,    74
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -106,  -106,   158,    20,     7,    74,   -81,     0,  -106,  -106,
    -106,  -106,  -106,   -66,  -106,  -106,   -15,  -106,  -106,  -106,
    -106,   -45,  -106,  -106,  -105
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    20,    21,    38,    23,   128,    24,   129,    26,    27,
      28,    29,    30,   123,    31,    32,    33,    34,    35,    50,
      51,    52,    53,    54,    55
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      25,   124,   125,   171,    57,    60,   117,    62,   175,   151,
     153,   154,   155,    36,   157,    36,   159,    49,    39,    40,
      22,    98,    43,    44,    48,    36,    99,   182,     8,   183,
      36,   167,     9,    41,    42,    59,   110,    22,    84,    85,
      86,    87,    88,   105,    90,    91,    92,   106,   107,   108,
      37,   116,    37,    71,    72,   199,    56,   183,    48,   120,
     180,    58,    37,   121,   139,   221,    93,    37,   168,   190,
      94,   191,   130,   177,    59,   192,    95,   193,   127,    96,
     131,   132,   133,   134,   135,   136,   138,   140,   141,   142,
     143,   144,   145,   146,   147,   148,    97,   219,   109,   137,
     100,   101,   114,   102,   115,   118,   119,   169,   149,   172,
     164,   122,   174,   156,   176,   170,   158,   179,   173,   208,
     170,    80,    81,    82,    83,   170,    84,    85,    86,    87,
      88,   160,   161,   162,   189,   163,   184,   166,    88,   178,
      80,    81,    82,    83,   222,    84,    85,    86,    87,    88,
     -81,   -81,   -81,   -81,   203,   220,   188,   -81,   212,   103,
     194,   195,   196,   197,   213,   104,   200,   214,   215,   187,
     217,   -43,   228,   229,   226,    47,     0,   165,     0,     0,
     204,     0,     0,   207,     0,     0,     0,     0,   205,   -43,
     -43,   -43,   -46,   209,     0,     0,     0,     0,     0,     0,
       0,   218,     0,     0,     0,   216,     0,     0,     0,   170,
     -46,   -46,   -46,   224,   225,     0,     0,     0,   223,     0,
       0,   227,   -81,   -81,   -81,   -81,     0,     0,     0,   -81,
       0,   103,     0,     0,     0,   -43,   -43,   104,   -43,     0,
       0,   -43,     0,   -81,   -81,   -81,   -81,     0,     0,     0,
     -81,     0,   103,     0,     0,     0,   -46,   -46,   104,   -46,
       0,     0,   -46,     1,     2,     3,     4,     5,     6,     0,
       7,   126,     0,     0,     0,     9,    10,     1,     2,     3,
       4,     5,     6,     0,     7,    45,     0,     0,     0,     9,
      10,     0,    11,    12,    13,     0,    14,     0,     0,     0,
       0,    15,    16,     0,     0,     0,    11,    12,    13,     0,
      14,     0,     0,     0,     0,    15,    16,     0,     0,     0,
      17,     0,    18,     0,     0,   -22,     0,   -22,    19,     0,
       0,     0,     0,     0,    17,     0,    18,    46,     0,     0,
       0,     0,    19,     1,     2,     3,     4,     5,     6,     0,
       7,     8,     0,     0,     0,     9,    10,    80,    81,    82,
      83,   150,    84,    85,    86,    87,    88,     0,     0,     0,
     201,   202,    11,    12,    13,     0,    14,     0,     0,     0,
       0,    15,    16,     0,     1,     2,     3,     4,     5,     6,
       0,     7,     8,     0,     0,     0,     9,    10,     0,     0,
      17,     0,    18,   152,     0,     0,     0,     0,    19,     0,
       0,     0,     0,    11,    12,    13,     0,    14,     0,     0,
       0,     0,    15,    16,     1,     2,     3,     4,     5,     6,
       0,     7,     8,     0,     0,     0,     9,    10,     0,     0,
       0,    17,     0,    18,     0,     0,     0,     0,     0,    19,
       0,     0,     0,    11,    12,    13,     0,    14,     0,     0,
       0,     0,    15,    16,     1,     2,     3,     4,     5,     6,
       0,     7,    45,     0,     0,     0,     9,    10,     0,     0,
       0,    17,     0,    18,     0,     0,     0,     0,     0,    19,
       0,     0,     0,    11,    12,    13,     0,    14,     0,     0,
       0,     0,    15,    16,     1,     2,     3,     4,     5,     6,
       0,     7,   206,     0,     0,     0,     9,    10,     0,     0,
       0,    17,     0,    18,     0,     0,     0,     0,     0,    19,
       0,     0,     0,    11,    12,    13,     0,    14,     0,     0,
       0,     0,    15,    16,     1,     2,     3,     4,     5,     6,
       0,     7,     8,     0,     0,     0,     9,    10,     0,     0,
       0,    17,     0,    18,   186,    80,    81,    82,    83,    19,
      84,    85,    86,    87,    88,    13,     0,    14,    60,    61,
      62,     0,     0,    63,    80,    81,    82,    83,     0,    84,
      85,    86,    87,    88,    60,    61,    62,     0,     0,     0,
       0,    17,     0,    18,     0,     0,     0,     0,     0,    19,
       0,     0,    64,    65,    66,    67,    68,    60,    61,    62,
       0,     0,    69,    70,     0,     0,    71,    72,    64,    65,
      66,    67,    68,    60,    61,    62,     0,   185,    69,    70,
       0,     0,    71,    72,     0,     0,     0,     0,     0,     0,
       0,    64,    65,    66,    67,    68,     0,     0,     0,     0,
     210,    69,    70,     0,     0,    71,    72,    64,    65,    66,
      67,    68,     0,     0,     0,     0,     0,    69,    70,     0,
       0,    71,    72,    73,    74,    75,    76,    77,    78,    79,
     111,    80,    81,    82,    83,     0,    84,    85,    86,    87,
      88,     0,    89,     0,   112,   113,    73,    74,    75,    76,
      77,    78,    79,   181,    80,    81,    82,    83,     0,    84,
      85,    86,    87,    88,     0,    89,    73,    74,    75,    76,
      77,    78,    79,   198,    80,    81,    82,    83,     0,    84,
      85,    86,    87,    88,     0,    89,    73,    74,    75,    76,
      77,    78,    79,     0,    80,    81,    82,    83,     0,    84,
      85,    86,    87,    88,     0,    89,   111,    80,    81,    82,
      83,     0,    84,    85,    86,    87,    88,     0,     0,     0,
     112,   113,   211,    80,    81,    82,    83,     0,    84,    85,
      86,    87,    88,    81,    82,    83,     0,    84,    85,    86,
      87,    88
};

static const yytype_int16 yycheck[] =
{
       0,    67,    68,   108,    19,    12,    51,    14,   113,    90,
      91,    92,    93,     9,    95,     9,    97,    17,    11,    12,
       0,    53,    15,    16,    17,     9,    58,    65,    11,    67,
       9,     9,    15,    13,    14,    64,    65,    17,    36,    37,
      38,    39,    40,    11,    18,    19,    20,    15,    44,    45,
      46,    51,    46,    60,    61,    65,    11,    67,    51,    59,
      44,     0,    46,    63,    79,    44,    18,    46,    46,   150,
      18,   152,    72,   118,    64,   156,    19,   158,    71,    19,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    20,   202,    44,    79,
      51,    52,    67,    54,    65,    67,    69,   107,    29,   109,
     103,    60,   112,    21,    67,   108,    22,     3,   111,   185,
     113,    31,    32,    33,    34,   118,    36,    37,    38,    39,
      40,    60,    60,    60,   149,    60,    70,    60,    40,   119,
      31,    32,    33,    34,   210,    36,    37,    38,    39,    40,
      51,    52,    53,    54,    65,    65,   149,    58,    65,    60,
     160,   161,   162,   163,    67,    66,   166,    67,    65,   149,
      65,     0,    65,    65,    65,    17,    -1,   103,    -1,    -1,
     180,    -1,    -1,   183,    -1,    -1,    -1,    -1,   181,    18,
      19,    20,     0,   186,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   201,    -1,    -1,    -1,   198,    -1,    -1,    -1,   202,
      18,    19,    20,   213,   214,    -1,    -1,    -1,   211,    -1,
      -1,   221,    51,    52,    53,    54,    -1,    -1,    -1,    58,
      -1,    60,    -1,    -1,    -1,    64,    65,    66,    67,    -1,
      -1,    70,    -1,    51,    52,    53,    54,    -1,    -1,    -1,
      58,    -1,    60,    -1,    -1,    -1,    64,    65,    66,    67,
      -1,    -1,    70,     3,     4,     5,     6,     7,     8,    -1,
      10,    11,    -1,    -1,    -1,    15,    16,     3,     4,     5,
       6,     7,     8,    -1,    10,    11,    -1,    -1,    -1,    15,
      16,    -1,    32,    33,    34,    -1,    36,    -1,    -1,    -1,
      -1,    41,    42,    -1,    -1,    -1,    32,    33,    34,    -1,
      36,    -1,    -1,    -1,    -1,    41,    42,    -1,    -1,    -1,
      60,    -1,    62,    -1,    -1,    65,    -1,    67,    68,    -1,
      -1,    -1,    -1,    -1,    60,    -1,    62,    63,    -1,    -1,
      -1,    -1,    68,     3,     4,     5,     6,     7,     8,    -1,
      10,    11,    -1,    -1,    -1,    15,    16,    31,    32,    33,
      34,    21,    36,    37,    38,    39,    40,    -1,    -1,    -1,
      44,    45,    32,    33,    34,    -1,    36,    -1,    -1,    -1,
      -1,    41,    42,    -1,     3,     4,     5,     6,     7,     8,
      -1,    10,    11,    -1,    -1,    -1,    15,    16,    -1,    -1,
      60,    -1,    62,    22,    -1,    -1,    -1,    -1,    68,    -1,
      -1,    -1,    -1,    32,    33,    34,    -1,    36,    -1,    -1,
      -1,    -1,    41,    42,     3,     4,     5,     6,     7,     8,
      -1,    10,    11,    -1,    -1,    -1,    15,    16,    -1,    -1,
      -1,    60,    -1,    62,    -1,    -1,    -1,    -1,    -1,    68,
      -1,    -1,    -1,    32,    33,    34,    -1,    36,    -1,    -1,
      -1,    -1,    41,    42,     3,     4,     5,     6,     7,     8,
      -1,    10,    11,    -1,    -1,    -1,    15,    16,    -1,    -1,
      -1,    60,    -1,    62,    -1,    -1,    -1,    -1,    -1,    68,
      -1,    -1,    -1,    32,    33,    34,    -1,    36,    -1,    -1,
      -1,    -1,    41,    42,     3,     4,     5,     6,     7,     8,
      -1,    10,    11,    -1,    -1,    -1,    15,    16,    -1,    -1,
      -1,    60,    -1,    62,    -1,    -1,    -1,    -1,    -1,    68,
      -1,    -1,    -1,    32,    33,    34,    -1,    36,    -1,    -1,
      -1,    -1,    41,    42,     3,     4,     5,     6,     7,     8,
      -1,    10,    11,    -1,    -1,    -1,    15,    16,    -1,    -1,
      -1,    60,    -1,    62,    30,    31,    32,    33,    34,    68,
      36,    37,    38,    39,    40,    34,    -1,    36,    12,    13,
      14,    -1,    -1,    17,    31,    32,    33,    34,    -1,    36,
      37,    38,    39,    40,    12,    13,    14,    -1,    -1,    -1,
      -1,    60,    -1,    62,    -1,    -1,    -1,    -1,    -1,    68,
      -1,    -1,    46,    47,    48,    49,    50,    12,    13,    14,
      -1,    -1,    56,    57,    -1,    -1,    60,    61,    46,    47,
      48,    49,    50,    12,    13,    14,    -1,    55,    56,    57,
      -1,    -1,    60,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    46,    47,    48,    49,    50,    -1,    -1,    -1,    -1,
      55,    56,    57,    -1,    -1,    60,    61,    46,    47,    48,
      49,    50,    -1,    -1,    -1,    -1,    -1,    56,    57,    -1,
      -1,    60,    61,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    -1,    36,    37,    38,    39,
      40,    -1,    42,    -1,    44,    45,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    -1,    36,
      37,    38,    39,    40,    -1,    42,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    -1,    36,
      37,    38,    39,    40,    -1,    42,    23,    24,    25,    26,
      27,    28,    29,    -1,    31,    32,    33,    34,    -1,    36,
      37,    38,    39,    40,    -1,    42,    30,    31,    32,    33,
      34,    -1,    36,    37,    38,    39,    40,    -1,    -1,    -1,
      44,    45,    30,    31,    32,    33,    34,    -1,    36,    37,
      38,    39,    40,    32,    33,    34,    -1,    36,    37,    38,
      39,    40
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,     3,     4,     5,     6,     7,     8,    10,    11,    15,
      16,    32,    33,    34,    36,    41,    42,    60,    62,    68,
      72,    73,    74,    75,    77,    78,    79,    80,    81,    82,
      83,    85,    86,    87,    88,    89,     9,    46,    74,    75,
      75,    74,    74,    75,    75,    11,    63,    73,    75,    78,
      90,    91,    92,    93,    94,    95,    11,    87,     0,    64,
      12,    13,    14,    17,    46,    47,    48,    49,    50,    56,
      57,    60,    61,    23,    24,    25,    26,    27,    28,    29,
      31,    32,    33,    34,    36,    37,    38,    39,    40,    42,
      18,    19,    20,    18,    18,    19,    19,    20,    53,    58,
      51,    52,    54,    60,    66,    11,    15,    44,    45,    44,
      65,    30,    44,    45,    67,    65,    78,    92,    67,    69,
      78,    78,    60,    84,    84,    84,    11,    75,    76,    78,
      78,    75,    75,    75,    75,    75,    75,    74,    75,    87,
      75,    75,    75,    75,    75,    75,    75,    75,    75,    29,
      21,    77,    22,    77,    77,    77,    21,    77,    22,    77,
      60,    60,    60,    60,    75,    76,    60,     9,    46,    78,
      75,    95,    78,    75,    78,    95,    67,    92,    74,     3,
      44,    30,    65,    67,    70,    55,    30,    74,    75,    87,
      77,    77,    77,    77,    78,    78,    78,    78,    30,    65,
      78,    44,    45,    65,    78,    75,    11,    78,    84,    75,
      55,    30,    65,    67,    67,    65,    75,    65,    78,    95,
      65,    44,    84,    75,    78,    78,    65,    78,    65,    65
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,    71,    72,    73,    73,    73,    74,    74,    74,    74,
      74,    74,    74,    74,    74,    74,    74,    75,    75,    75,
      75,    75,    76,    76,    76,    76,    76,    74,    75,    75,
      75,    75,    75,    75,    75,    75,    75,    77,    77,    77,
      77,    77,    77,    77,    77,    77,    77,    77,    77,    77,
      78,    78,    78,    78,    78,    78,    79,    79,    80,    80,
      81,    81,    82,    82,    83,    83,    74,    74,    74,    74,
      74,    74,    74,    74,    74,    74,    74,    74,    74,    84,
      84,    85,    86,    86,    74,    74,    74,    74,    74,    74,
      74,    74,    87,    87,    87,    87,    87,    87,    88,    88,
      89,    90,    90,    90,    91,    91,    92,    92,    92,    93,
      94,    95,    95,    95,    95,    95,    95,    74,    74,    74
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     1,     3,     3,     2,     2,     4,     4,
       5,     6,     6,     3,     1,     1,     1,     1,     2,     2,
       2,     2,     0,     1,     3,     3,     5,     4,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     1,     3,     3,
       3,     5,     5,     3,     6,     6,     4,     3,     3,     3,
       1,     1,     1,     1,     1,     1,     3,     3,     4,     4,
       3,     3,     4,     4,     3,     3,     2,     2,     2,     3,
       3,     3,     2,     2,     7,     7,     5,     5,     2,     0,
       3,     1,     1,     0,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     1,     2,     2,     2,     3,     2,     3,
       3,     1,     2,     2,     2,     3,     1,     1,     3,     3,
       1,     3,     3,     5,     3,     3,     5,     2,     2,     4
};


#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)
#define YYEMPTY         (-2)
#define YYEOF           0

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                  \
do                                                              \
  if (yychar == YYEMPTY)                                        \
    {                                                           \
      yychar = (Token);                                         \
      yylval = (Value);                                         \
      YYPOPSTACK (yylen);                                       \
      yystate = *yyssp;                                         \
      goto yybackup;                                            \
    }                                                           \
  else                                                          \
    {                                                           \
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;                                                  \
    }                                                           \
while (0)

/* Error token number */
#define YYTERROR        1
#define YYERRCODE       256



/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)

/* This macro is provided for backward compatibility. */
#ifndef YY_LOCATION_PRINT
# define YY_LOCATION_PRINT(File, Loc) ((void) 0)
#endif


# define YY_SYMBOL_PRINT(Title, Type, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Type, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*----------------------------------------.
| Print this symbol's value on YYOUTPUT.  |
`----------------------------------------*/

static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
{
  FILE *yyo = yyoutput;
  YYUSE (yyo);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  YYUSE (yytype);
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyoutput, "%s %s (",
             yytype < YYNTOKENS ? "token" : "nterm", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yytype_int16 *yyssp, YYSTYPE *yyvsp, int yyrule)
{
  unsigned long int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       yystos[yyssp[yyi + 1 - yynrhs]],
                       &(yyvsp[(yyi + 1) - (yynrhs)])
                                              );
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
yystrlen (const char *yystr)
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            /* Fall through.  */
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return 1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return 2 if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYSIZE_T *yymsg_alloc, char **yymsg,
                yytype_int16 *yyssp, int yytoken)
{
  YYSIZE_T yysize0 = yytnamerr (YY_NULLPTRPTR, yytname[yytoken]);
  YYSIZE_T yysize = yysize0;
  enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTRPTR;
  /* Arguments of yyformat. */
  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
  /* Number of reported tokens (one for the "unexpected", one per
     "expected"). */
  int yycount = 0;

  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yytoken != YYEMPTY)
    {
      int yyn = yypact[*yyssp];
      yyarg[yycount++] = yytname[yytoken];
      if (!yypact_value_is_default (yyn))
        {
          /* Start YYX at -YYN if negative to avoid negative indexes in
             YYCHECK.  In other words, skip the first -YYN actions for
             this state because they are default actions.  */
          int yyxbegin = yyn < 0 ? -yyn : 0;
          /* Stay within bounds of both yycheck and yytname.  */
          int yychecklim = YYLAST - yyn + 1;
          int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
          int yyx;

          for (yyx = yyxbegin; yyx < yyxend; ++yyx)
            if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR
                && !yytable_value_is_error (yytable[yyx + yyn]))
              {
                if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                  {
                    yycount = 1;
                    yysize = yysize0;
                    break;
                  }
                yyarg[yycount++] = yytname[yyx];
                {
                  YYSIZE_T yysize1 = yysize + yytnamerr (YY_NULLPTRPTR, yytname[yyx]);
                  if (! (yysize <= yysize1
                         && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
                    return 2;
                  yysize = yysize1;
                }
              }
        }
    }

  switch (yycount)
    {
# define YYCASE_(N, S)                      \
      case N:                               \
        yyformat = S;                       \
      break
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
# undef YYCASE_
    }

  {
    YYSIZE_T yysize1 = yysize + yystrlen (yyformat);
    if (! (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
      return 2;
    yysize = yysize1;
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return 1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yyarg[yyi++]);
          yyformat += 2;
        }
      else
        {
          yyp++;
          yyformat++;
        }
  }
  return 0;
}
#endif /* YYERROR_VERBOSE */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
{
  YYUSE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YYUSE (yytype);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}




/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;


/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       'yyss': related to states.
       'yyvs': related to semantic values.

       Refer to the stacks through separate pointers, to allow yyoverflow
       to xreallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yyssp = yyss = yyssa;
  yyvsp = yyvs = yyvsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */
  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
        /* Give user a chance to xreallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        YYSTYPE *yyvs1 = yyvs;
        yytype_int16 *yyss1 = yyss;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * sizeof (*yyssp),
                    &yyvs1, yysize * sizeof (*yyvsp),
                    &yystacksize);

        yyss = yyss1;
        yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yytype_int16 *yyss1 = yyss;
        union yyalloc *yyptr =
          (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
                  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 4:
#line 497 "ada-exp.y" /* yacc.c:1646  */
    { ada_wrap2<comma_operation> (BINOP_COMMA); }
#line 1983 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 5:
#line 499 "ada-exp.y" /* yacc.c:1646  */
    {
			  operation_up rhs = pstate->pop ();
			  operation_up lhs = ada_pop ();
			  value *lhs_val
			    = lhs->evaluate (nullptr, pstate->expout.get (),
					     EVAL_AVOID_SIDE_EFFECTS);
			  rhs = resolve (std::move (rhs), true,
					 value_type (lhs_val));
			  pstate->push_new<ada_assign_operation>
			    (std::move (lhs), std::move (rhs));
			}
#line 1999 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 6:
#line 515 "ada-exp.y" /* yacc.c:1646  */
    {
			  if (strcmp ((yyvsp[0].sval).ptr, "all") == 0)
			    ada_wrap<ada_unop_ind_operation> ();
			  else
			    {
			      operation_up arg = ada_pop ();
			      pstate->push_new<ada_structop_operation>
				(std::move (arg), copy_name ((yyvsp[0].sval)));
			    }
			}
#line 2014 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 7:
#line 528 "ada-exp.y" /* yacc.c:1646  */
    {
			  /* This is done even for ".all", because
			     that might be a prefix.  */
			  operation_up arg = ada_pop ();
			  ada_structop_operation *str_op
			    = (new ada_structop_operation
			       (std::move (arg), copy_name ((yyvsp[0].sval))));
			  str_op->set_prefix (find_completion_bounds (pstate));
			  pstate->push (operation_up (str_op));
			  pstate->mark_struct_expression (str_op);
			}
#line 2030 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 8:
#line 542 "ada-exp.y" /* yacc.c:1646  */
    { ada_funcall ((yyvsp[-1].lval)); }
#line 2036 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 9:
#line 544 "ada-exp.y" /* yacc.c:1646  */
    {
			  if ((yyvsp[-3].tval) != NULL)
			    {
			      if ((yyvsp[-1].lval) != 1)
				error (_("Invalid conversion"));
			      operation_up arg = ada_pop ();
			      pstate->push_new<unop_cast_operation>
				(std::move (arg), (yyvsp[-3].tval));
			    }
			  else
			    ada_funcall ((yyvsp[-1].lval));
			}
#line 2053 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 10:
#line 559 "ada-exp.y" /* yacc.c:1646  */
    {
			  if ((yyvsp[-4].tval) == NULL)
			    error (_("Type required for qualification"));
			  operation_up arg = ada_pop (true,
						      check_typedef ((yyvsp[-4].tval)));
			  pstate->push_new<ada_qual_operation>
			    (std::move (arg), (yyvsp[-4].tval));
			}
#line 2066 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 11:
#line 571 "ada-exp.y" /* yacc.c:1646  */
    { ada_wrap3<ada_ternop_slice_operation> (); }
#line 2072 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 12:
#line 573 "ada-exp.y" /* yacc.c:1646  */
    { if ((yyvsp[-5].tval) == NULL) 
			    ada_wrap3<ada_ternop_slice_operation> ();
			  else
			    error (_("Cannot slice a type"));
			}
#line 2082 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 13:
#line 580 "ada-exp.y" /* yacc.c:1646  */
    { }
#line 2088 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 14:
#line 592 "ada-exp.y" /* yacc.c:1646  */
    { if ((yyvsp[0].tval) != NULL)
			    pstate->push_new<type_operation> ((yyvsp[0].tval));
			}
#line 2096 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 15:
#line 598 "ada-exp.y" /* yacc.c:1646  */
    { pstate->push_dollar ((yyvsp[0].sval)); }
#line 2102 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 16:
#line 602 "ada-exp.y" /* yacc.c:1646  */
    {
			  pstate->push_new<ada_aggregate_operation>
			    (pop_component ());
			}
#line 2111 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 18:
#line 612 "ada-exp.y" /* yacc.c:1646  */
    { ada_wrap_overload<ada_neg_operation> (UNOP_NEG); }
#line 2117 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 19:
#line 616 "ada-exp.y" /* yacc.c:1646  */
    {
			  operation_up arg = ada_pop ();
			  operation_up empty;

			  /* If an overloaded operator was found, use
			     it.  Otherwise, unary + has no effect and
			     the argument can be pushed instead.  */
			  operation_up call = maybe_overload (UNOP_PLUS, arg,
							      empty);
			  if (call != nullptr)
			    arg = std::move (call);
			  pstate->push (std::move (arg));
			}
#line 2135 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 20:
#line 632 "ada-exp.y" /* yacc.c:1646  */
    {
			  ada_wrap_overload<unary_logical_not_operation>
			    (UNOP_LOGICAL_NOT);
			}
#line 2144 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 21:
#line 639 "ada-exp.y" /* yacc.c:1646  */
    { ada_wrap_overload<ada_abs_operation> (UNOP_ABS); }
#line 2150 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 22:
#line 642 "ada-exp.y" /* yacc.c:1646  */
    { (yyval.lval) = 0; }
#line 2156 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 23:
#line 646 "ada-exp.y" /* yacc.c:1646  */
    { (yyval.lval) = 1; }
#line 2162 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 24:
#line 648 "ada-exp.y" /* yacc.c:1646  */
    { (yyval.lval) = 1; }
#line 2168 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 25:
#line 650 "ada-exp.y" /* yacc.c:1646  */
    { (yyval.lval) = (yyvsp[-2].lval) + 1; }
#line 2174 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 26:
#line 652 "ada-exp.y" /* yacc.c:1646  */
    { (yyval.lval) = (yyvsp[-4].lval) + 1; }
#line 2180 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 27:
#line 657 "ada-exp.y" /* yacc.c:1646  */
    { 
			  if ((yyvsp[-2].tval) == NULL)
			    error (_("Type required within braces in coercion"));
			  operation_up arg = ada_pop ();
			  pstate->push_new<unop_memval_operation>
			    (std::move (arg), (yyvsp[-2].tval));
			}
#line 2192 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 28:
#line 669 "ada-exp.y" /* yacc.c:1646  */
    { ada_wrap2<ada_binop_exp_operation> (BINOP_EXP); }
#line 2198 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 29:
#line 673 "ada-exp.y" /* yacc.c:1646  */
    { ada_wrap2<ada_binop_mul_operation> (BINOP_MUL); }
#line 2204 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 30:
#line 677 "ada-exp.y" /* yacc.c:1646  */
    { ada_wrap2<ada_binop_div_operation> (BINOP_DIV); }
#line 2210 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 31:
#line 681 "ada-exp.y" /* yacc.c:1646  */
    { ada_wrap2<ada_binop_rem_operation> (BINOP_REM); }
#line 2216 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 32:
#line 685 "ada-exp.y" /* yacc.c:1646  */
    { ada_wrap2<ada_binop_mod_operation> (BINOP_MOD); }
#line 2222 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 33:
#line 689 "ada-exp.y" /* yacc.c:1646  */
    { ada_wrap2<repeat_operation> (BINOP_REPEAT); }
#line 2228 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 34:
#line 693 "ada-exp.y" /* yacc.c:1646  */
    { ada_wrap_op<ada_binop_addsub_operation> (BINOP_ADD); }
#line 2234 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 35:
#line 697 "ada-exp.y" /* yacc.c:1646  */
    { ada_wrap2<ada_concat_operation> (BINOP_CONCAT); }
#line 2240 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 36:
#line 701 "ada-exp.y" /* yacc.c:1646  */
    { ada_wrap_op<ada_binop_addsub_operation> (BINOP_SUB); }
#line 2246 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 38:
#line 708 "ada-exp.y" /* yacc.c:1646  */
    { ada_wrap_op<ada_binop_equal_operation> (BINOP_EQUAL); }
#line 2252 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 39:
#line 712 "ada-exp.y" /* yacc.c:1646  */
    { ada_wrap_op<ada_binop_equal_operation> (BINOP_NOTEQUAL); }
#line 2258 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 40:
#line 716 "ada-exp.y" /* yacc.c:1646  */
    { ada_un_wrap2<leq_operation> (BINOP_LEQ); }
#line 2264 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 41:
#line 720 "ada-exp.y" /* yacc.c:1646  */
    { ada_wrap3<ada_ternop_range_operation> (); }
#line 2270 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 42:
#line 722 "ada-exp.y" /* yacc.c:1646  */
    {
			  operation_up rhs = ada_pop ();
			  operation_up lhs = ada_pop ();
			  pstate->push_new<ada_binop_in_bounds_operation>
			    (std::move (lhs), std::move (rhs), (yyvsp[0].lval));
			}
#line 2281 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 43:
#line 729 "ada-exp.y" /* yacc.c:1646  */
    { 
			  if ((yyvsp[0].tval) == NULL)
			    error (_("Right operand of 'in' must be type"));
			  operation_up arg = ada_pop ();
			  pstate->push_new<ada_unop_range_operation>
			    (std::move (arg), (yyvsp[0].tval));
			}
#line 2293 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 44:
#line 737 "ada-exp.y" /* yacc.c:1646  */
    { ada_wrap3<ada_ternop_range_operation> ();
			  ada_wrap<unary_logical_not_operation> (); }
#line 2300 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 45:
#line 740 "ada-exp.y" /* yacc.c:1646  */
    {
			  operation_up rhs = ada_pop ();
			  operation_up lhs = ada_pop ();
			  pstate->push_new<ada_binop_in_bounds_operation>
			    (std::move (lhs), std::move (rhs), (yyvsp[0].lval));
			  ada_wrap<unary_logical_not_operation> ();
			}
#line 2312 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 46:
#line 748 "ada-exp.y" /* yacc.c:1646  */
    { 
			  if ((yyvsp[0].tval) == NULL)
			    error (_("Right operand of 'in' must be type"));
			  operation_up arg = ada_pop ();
			  pstate->push_new<ada_unop_range_operation>
			    (std::move (arg), (yyvsp[0].tval));
			  ada_wrap<unary_logical_not_operation> ();
			}
#line 2325 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 47:
#line 759 "ada-exp.y" /* yacc.c:1646  */
    { ada_un_wrap2<geq_operation> (BINOP_GEQ); }
#line 2331 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 48:
#line 763 "ada-exp.y" /* yacc.c:1646  */
    { ada_un_wrap2<less_operation> (BINOP_LESS); }
#line 2337 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 49:
#line 767 "ada-exp.y" /* yacc.c:1646  */
    { ada_un_wrap2<gtr_operation> (BINOP_GTR); }
#line 2343 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 56:
#line 780 "ada-exp.y" /* yacc.c:1646  */
    { ada_wrap2<ada_bitwise_and_operation>
			    (BINOP_BITWISE_AND); }
#line 2350 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 57:
#line 783 "ada-exp.y" /* yacc.c:1646  */
    { ada_wrap2<ada_bitwise_and_operation>
			    (BINOP_BITWISE_AND); }
#line 2357 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 58:
#line 789 "ada-exp.y" /* yacc.c:1646  */
    { ada_wrap2<logical_and_operation>
			    (BINOP_LOGICAL_AND); }
#line 2364 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 59:
#line 792 "ada-exp.y" /* yacc.c:1646  */
    { ada_wrap2<logical_and_operation>
			    (BINOP_LOGICAL_AND); }
#line 2371 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 60:
#line 798 "ada-exp.y" /* yacc.c:1646  */
    { ada_wrap2<ada_bitwise_ior_operation>
			    (BINOP_BITWISE_IOR); }
#line 2378 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 61:
#line 801 "ada-exp.y" /* yacc.c:1646  */
    { ada_wrap2<ada_bitwise_ior_operation>
			    (BINOP_BITWISE_IOR); }
#line 2385 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 62:
#line 807 "ada-exp.y" /* yacc.c:1646  */
    { ada_wrap2<logical_or_operation> (BINOP_LOGICAL_OR); }
#line 2391 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 63:
#line 809 "ada-exp.y" /* yacc.c:1646  */
    { ada_wrap2<logical_or_operation> (BINOP_LOGICAL_OR); }
#line 2397 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 64:
#line 813 "ada-exp.y" /* yacc.c:1646  */
    { ada_wrap2<ada_bitwise_xor_operation>
			    (BINOP_BITWISE_XOR); }
#line 2404 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 65:
#line 816 "ada-exp.y" /* yacc.c:1646  */
    { ada_wrap2<ada_bitwise_xor_operation>
			    (BINOP_BITWISE_XOR); }
#line 2411 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 66:
#line 829 "ada-exp.y" /* yacc.c:1646  */
    { ada_addrof (); }
#line 2417 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 67:
#line 831 "ada-exp.y" /* yacc.c:1646  */
    { ada_addrof (type_system_address (pstate)); }
#line 2423 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 68:
#line 833 "ada-exp.y" /* yacc.c:1646  */
    {
			  pstate->mark_completion (make_tick_completer ((yyvsp[0].sval)));
			}
#line 2431 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 69:
#line 837 "ada-exp.y" /* yacc.c:1646  */
    {
			  operation_up arg = ada_pop ();
			  pstate->push_new<ada_unop_atr_operation>
			    (std::move (arg), OP_ATR_FIRST, (yyvsp[0].lval));
			}
#line 2441 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 70:
#line 843 "ada-exp.y" /* yacc.c:1646  */
    {
			  operation_up arg = ada_pop ();
			  pstate->push_new<ada_unop_atr_operation>
			    (std::move (arg), OP_ATR_LAST, (yyvsp[0].lval));
			}
#line 2451 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 71:
#line 849 "ada-exp.y" /* yacc.c:1646  */
    {
			  operation_up arg = ada_pop ();
			  pstate->push_new<ada_unop_atr_operation>
			    (std::move (arg), OP_ATR_LENGTH, (yyvsp[0].lval));
			}
#line 2461 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 72:
#line 855 "ada-exp.y" /* yacc.c:1646  */
    { ada_wrap<ada_atr_size_operation> (); }
#line 2467 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 73:
#line 857 "ada-exp.y" /* yacc.c:1646  */
    { ada_wrap<ada_atr_tag_operation> (); }
#line 2473 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 74:
#line 859 "ada-exp.y" /* yacc.c:1646  */
    { ada_wrap2<ada_binop_min_operation> (BINOP_MIN); }
#line 2479 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 75:
#line 861 "ada-exp.y" /* yacc.c:1646  */
    { ada_wrap2<ada_binop_max_operation> (BINOP_MAX); }
#line 2485 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 76:
#line 863 "ada-exp.y" /* yacc.c:1646  */
    { ada_wrap<ada_pos_operation> (); }
#line 2491 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 77:
#line 865 "ada-exp.y" /* yacc.c:1646  */
    {
			  operation_up arg = ada_pop ();
			  pstate->push_new<ada_atr_val_operation>
			    ((yyvsp[-4].tval), std::move (arg));
			}
#line 2501 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 78:
#line 871 "ada-exp.y" /* yacc.c:1646  */
    {
			  struct type *type_arg = check_typedef ((yyvsp[-1].tval));
			  if (!ada_is_modular_type (type_arg))
			    error (_("'modulus must be applied to modular type"));
			  write_int (pstate, ada_modulus (type_arg),
				     type_arg->target_type ());
			}
#line 2513 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 79:
#line 881 "ada-exp.y" /* yacc.c:1646  */
    { (yyval.lval) = 1; }
#line 2519 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 80:
#line 883 "ada-exp.y" /* yacc.c:1646  */
    { (yyval.lval) = (yyvsp[-1].typed_val).val; }
#line 2525 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 81:
#line 888 "ada-exp.y" /* yacc.c:1646  */
    { 
			  if ((yyvsp[0].tval) == NULL)
			    error (_("Prefix must be type"));
			  (yyval.tval) = (yyvsp[0].tval);
			}
#line 2535 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 82:
#line 897 "ada-exp.y" /* yacc.c:1646  */
    { (yyval.tval) = (yyvsp[0].tval); }
#line 2541 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 83:
#line 899 "ada-exp.y" /* yacc.c:1646  */
    { (yyval.tval) = parse_type (pstate)->builtin_void; }
#line 2547 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 84:
#line 904 "ada-exp.y" /* yacc.c:1646  */
    { write_int (pstate, (LONGEST) (yyvsp[0].typed_val).val, (yyvsp[0].typed_val).type); }
#line 2553 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 85:
#line 908 "ada-exp.y" /* yacc.c:1646  */
    {
			  pstate->push_new<ada_char_operation> ((yyvsp[0].typed_val).type, (yyvsp[0].typed_val).val);
			}
#line 2561 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 86:
#line 914 "ada-exp.y" /* yacc.c:1646  */
    {
			  float_data data;
			  std::copy (std::begin ((yyvsp[0].typed_val_float).val), std::end ((yyvsp[0].typed_val_float).val),
				     std::begin (data));
			  pstate->push_new<float_const_operation>
			    ((yyvsp[0].typed_val_float).type, data);
			  ada_wrap<ada_wrapped_operation> ();
			}
#line 2574 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 87:
#line 925 "ada-exp.y" /* yacc.c:1646  */
    {
			  struct type *null_ptr_type
			    = lookup_pointer_type (parse_type (pstate)->builtin_int0);
			  write_int (pstate, 0, null_ptr_type);
			}
#line 2584 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 88:
#line 933 "ada-exp.y" /* yacc.c:1646  */
    { 
			  pstate->push_new<ada_string_operation>
			    (copy_name ((yyvsp[0].sval)));
			}
#line 2593 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 89:
#line 940 "ada-exp.y" /* yacc.c:1646  */
    { write_int (pstate, 1, type_boolean (pstate)); }
#line 2599 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 90:
#line 942 "ada-exp.y" /* yacc.c:1646  */
    { write_int (pstate, 0, type_boolean (pstate)); }
#line 2605 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 91:
#line 946 "ada-exp.y" /* yacc.c:1646  */
    { error (_("NEW not implemented.")); }
#line 2611 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 92:
#line 950 "ada-exp.y" /* yacc.c:1646  */
    { (yyval.tval) = write_var_or_type (pstate, NULL, (yyvsp[0].sval)); }
#line 2617 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 93:
#line 952 "ada-exp.y" /* yacc.c:1646  */
    {
				  (yyval.tval) = write_var_or_type_completion (pstate,
								     NULL,
								     (yyvsp[0].sval));
				}
#line 2627 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 94:
#line 958 "ada-exp.y" /* yacc.c:1646  */
    { (yyval.tval) = write_var_or_type (pstate, (yyvsp[-1].bval), (yyvsp[0].sval)); }
#line 2633 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 95:
#line 960 "ada-exp.y" /* yacc.c:1646  */
    {
				  (yyval.tval) = write_var_or_type_completion (pstate,
								     (yyvsp[-1].bval),
								     (yyvsp[0].sval));
				}
#line 2643 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 96:
#line 966 "ada-exp.y" /* yacc.c:1646  */
    { 
			  (yyval.tval) = write_var_or_type (pstate, NULL, (yyvsp[-1].sval));
			  if ((yyval.tval) == NULL)
			    ada_addrof ();
			  else
			    (yyval.tval) = lookup_pointer_type ((yyval.tval));
			}
#line 2655 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 97:
#line 974 "ada-exp.y" /* yacc.c:1646  */
    { 
			  (yyval.tval) = write_var_or_type (pstate, (yyvsp[-2].bval), (yyvsp[-1].sval));
			  if ((yyval.tval) == NULL)
			    ada_addrof ();
			  else
			    (yyval.tval) = lookup_pointer_type ((yyval.tval));
			}
#line 2667 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 98:
#line 985 "ada-exp.y" /* yacc.c:1646  */
    { (yyval.bval) = block_lookup (NULL, (yyvsp[-1].sval).ptr); }
#line 2673 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 99:
#line 987 "ada-exp.y" /* yacc.c:1646  */
    { (yyval.bval) = block_lookup ((yyvsp[-2].bval), (yyvsp[-1].sval).ptr); }
#line 2679 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 100:
#line 992 "ada-exp.y" /* yacc.c:1646  */
    {
			  std::vector<ada_component_up> components
			    = pop_components ((yyvsp[-1].lval));

			  push_component<ada_aggregate_component>
			    (std::move (components));
			}
#line 2691 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 101:
#line 1002 "ada-exp.y" /* yacc.c:1646  */
    { (yyval.lval) = (yyvsp[0].lval); }
#line 2697 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 102:
#line 1004 "ada-exp.y" /* yacc.c:1646  */
    {
			  push_component<ada_positional_component>
			    ((yyvsp[-1].lval), ada_pop ());
			  (yyval.lval) = (yyvsp[-1].lval) + 1;
			}
#line 2707 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 103:
#line 1010 "ada-exp.y" /* yacc.c:1646  */
    { (yyval.lval) = (yyvsp[-1].lval) + (yyvsp[0].lval); }
#line 2713 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 104:
#line 1015 "ada-exp.y" /* yacc.c:1646  */
    {
			  push_component<ada_positional_component>
			    (0, ada_pop ());
			  (yyval.lval) = 1;
			}
#line 2723 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 105:
#line 1021 "ada-exp.y" /* yacc.c:1646  */
    {
			  push_component<ada_positional_component>
			    ((yyvsp[-2].lval), ada_pop ());
			  (yyval.lval) = (yyvsp[-2].lval) + 1; 
			}
#line 2733 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 106:
#line 1029 "ada-exp.y" /* yacc.c:1646  */
    { (yyval.lval) = 1; }
#line 2739 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 107:
#line 1030 "ada-exp.y" /* yacc.c:1646  */
    { (yyval.lval) = 1; }
#line 2745 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 108:
#line 1032 "ada-exp.y" /* yacc.c:1646  */
    { (yyval.lval) = (yyvsp[0].lval) + 1; }
#line 2751 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 109:
#line 1036 "ada-exp.y" /* yacc.c:1646  */
    {
			  push_component<ada_others_component> (ada_pop ());
			}
#line 2759 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 110:
#line 1043 "ada-exp.y" /* yacc.c:1646  */
    {
			  ada_choices_component *choices = choice_component ();
			  choices->set_associations (pop_associations ((yyvsp[0].lval)));
			}
#line 2768 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 111:
#line 1056 "ada-exp.y" /* yacc.c:1646  */
    {
			  push_component<ada_choices_component> (ada_pop ());
			  write_name_assoc (pstate, (yyvsp[-2].sval));
			  (yyval.lval) = 1;
			}
#line 2778 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 112:
#line 1062 "ada-exp.y" /* yacc.c:1646  */
    {
			  push_component<ada_choices_component> (ada_pop ());
			  push_association<ada_name_association> (ada_pop ());
			  (yyval.lval) = 1;
			}
#line 2788 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 113:
#line 1068 "ada-exp.y" /* yacc.c:1646  */
    {
			  push_component<ada_choices_component> (ada_pop ());
			  operation_up rhs = ada_pop ();
			  operation_up lhs = ada_pop ();
			  push_association<ada_discrete_range_association>
			    (std::move (lhs), std::move (rhs));
			  (yyval.lval) = 1;
			}
#line 2801 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 114:
#line 1077 "ada-exp.y" /* yacc.c:1646  */
    {
			  write_name_assoc (pstate, (yyvsp[-2].sval));
			  (yyval.lval) = (yyvsp[0].lval) + 1;
			}
#line 2810 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 115:
#line 1082 "ada-exp.y" /* yacc.c:1646  */
    {
			  push_association<ada_name_association> (ada_pop ());
			  (yyval.lval) = (yyvsp[0].lval) + 1;
			}
#line 2819 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 116:
#line 1088 "ada-exp.y" /* yacc.c:1646  */
    {
			  operation_up rhs = ada_pop ();
			  operation_up lhs = ada_pop ();
			  push_association<ada_discrete_range_association>
			    (std::move (lhs), std::move (rhs));
			  (yyval.lval) = (yyvsp[0].lval) + 1;
			}
#line 2831 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 117:
#line 1101 "ada-exp.y" /* yacc.c:1646  */
    { ada_wrap<ada_unop_ind_operation> (); }
#line 2837 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 118:
#line 1103 "ada-exp.y" /* yacc.c:1646  */
    { ada_addrof (); }
#line 2843 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;

  case 119:
#line 1105 "ada-exp.y" /* yacc.c:1646  */
    {
			  ada_wrap2<subscript_operation> (BINOP_SUBSCRIPT);
			  ada_wrap<ada_wrapped_operation> ();
			}
#line 2852 "ada-exp.c.tmp" /* yacc.c:1646  */
    break;


#line 2856 "ada-exp.c.tmp" /* yacc.c:1646  */
      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYEMPTY : YYTRANSLATE (yychar);

  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (YY_("syntax error"));
#else
# define YYSYNTAX_ERROR yysyntax_error (&yymsg_alloc, &yymsg, \
                                        yyssp, yytoken)
      {
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = YYSYNTAX_ERROR;
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == 1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = (char *) YYSTACK_ALLOC (yymsg_alloc);
            if (!yymsg)
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = 2;
              }
            else
              {
                yysyntax_error_status = YYSYNTAX_ERROR;
                yymsgp = yymsg;
              }
          }
        yyerror (yymsgp);
        if (yysyntax_error_status == 2)
          goto yyexhaustedlab;
      }
# undef YYSYNTAX_ERROR
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYTERROR;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  yystos[yystate], yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#if !defined yyoverflow || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  yystos[*yyssp], yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  return yyresult;
}
#line 1111 "ada-exp.y" /* yacc.c:1906  */


/* yylex defined in ada-lex.c: Reads one token, getting characters */
/* through lexptr.  */

/* Remap normal flex interface names (yylex) as well as gratuitiously */
/* global symbol names, so we can have multiple flex-generated parsers */
/* in gdb.  */

/* (See note above on previous definitions for YACC.) */

#define yy_create_buffer ada_yy_create_buffer
#define yy_delete_buffer ada_yy_delete_buffer
#define yy_init_buffer ada_yy_init_buffer
#define yy_load_buffer_state ada_yy_load_buffer_state
#define yy_switch_to_buffer ada_yy_switch_to_buffer
#define yyrestart ada_yyrestart
#define yytext ada_yytext

static struct obstack temp_parse_space;

/* The following kludge was found necessary to prevent conflicts between */
/* defs.h and non-standard stdlib.h files.  */
#define qsort __qsort__dummy
#include "ada-lex.c"

int
ada_parse (struct parser_state *par_state)
{
  /* Setting up the parser state.  */
  scoped_restore pstate_restore = make_scoped_restore (&pstate);
  gdb_assert (par_state != NULL);
  pstate = par_state;
  original_expr = par_state->lexptr;

  scoped_restore restore_yydebug = make_scoped_restore (&yydebug,
							parser_debug);

  lexer_init (yyin);		/* (Re-)initialize lexer.  */
  obstack_free (&temp_parse_space, NULL);
  obstack_init (&temp_parse_space);
  components.clear ();
  associations.clear ();

  int result = yyparse ();
  if (!result)
    {
      struct type *context_type = nullptr;
      if (par_state->void_context_p)
	context_type = parse_type (par_state)->builtin_void;
      pstate->set_operation (ada_pop (true, context_type));
    }
  return result;
}

static void
yyerror (const char *msg)
{
  error (_("Error in expression, near `%s'."), pstate->lexptr);
}

/* Emit expression to access an instance of SYM, in block BLOCK (if
   non-NULL).  */

static void
write_var_from_sym (struct parser_state *par_state, block_symbol sym)
{
  if (symbol_read_needs_frame (sym.symbol))
    par_state->block_tracker->update (sym.block, INNERMOST_BLOCK_FOR_SYMBOLS);

  par_state->push_new<ada_var_value_operation> (sym);
}

/* Write integer or boolean constant ARG of type TYPE.  */

static void
write_int (struct parser_state *par_state, LONGEST arg, struct type *type)
{
  pstate->push_new<long_const_operation> (type, arg);
  ada_wrap<ada_wrapped_operation> ();
}

/* Emit expression corresponding to the renamed object named 
   designated by RENAMED_ENTITY[0 .. RENAMED_ENTITY_LEN-1] in the
   context of ORIG_LEFT_CONTEXT, to which is applied the operations
   encoded by RENAMING_EXPR.  MAX_DEPTH is the maximum number of
   cascaded renamings to allow.  If ORIG_LEFT_CONTEXT is null, it
   defaults to the currently selected block. ORIG_SYMBOL is the 
   symbol that originally encoded the renaming.  It is needed only
   because its prefix also qualifies any index variables used to index
   or slice an array.  It should not be necessary once we go to the
   new encoding entirely (FIXME pnh 7/20/2007).  */

static void
write_object_renaming (struct parser_state *par_state,
		       const struct block *orig_left_context,
		       const char *renamed_entity, int renamed_entity_len,
		       const char *renaming_expr, int max_depth)
{
  char *name;
  enum { SIMPLE_INDEX, LOWER_BOUND, UPPER_BOUND } slice_state;
  struct block_symbol sym_info;

  if (max_depth <= 0)
    error (_("Could not find renamed symbol"));

  if (orig_left_context == NULL)
    orig_left_context = get_selected_block (NULL);

  name = obstack_strndup (&temp_parse_space, renamed_entity,
			  renamed_entity_len);
  ada_lookup_encoded_symbol (name, orig_left_context, VAR_DOMAIN, &sym_info);
  if (sym_info.symbol == NULL)
    error (_("Could not find renamed variable: %s"), ada_decode (name).c_str ());
  else if (sym_info.symbol->aclass () == LOC_TYPEDEF)
    /* We have a renaming of an old-style renaming symbol.  Don't
       trust the block information.  */
    sym_info.block = orig_left_context;

  {
    const char *inner_renamed_entity;
    int inner_renamed_entity_len;
    const char *inner_renaming_expr;

    switch (ada_parse_renaming (sym_info.symbol, &inner_renamed_entity,
				&inner_renamed_entity_len,
				&inner_renaming_expr))
      {
      case ADA_NOT_RENAMING:
	write_var_from_sym (par_state, sym_info);
	break;
      case ADA_OBJECT_RENAMING:
	write_object_renaming (par_state, sym_info.block,
			       inner_renamed_entity, inner_renamed_entity_len,
			       inner_renaming_expr, max_depth - 1);
	break;
      default:
	goto BadEncoding;
      }
  }

  slice_state = SIMPLE_INDEX;
  while (*renaming_expr == 'X')
    {
      renaming_expr += 1;

      switch (*renaming_expr) {
      case 'A':
	renaming_expr += 1;
	ada_wrap<ada_unop_ind_operation> ();
	break;
      case 'L':
	slice_state = LOWER_BOUND;
	/* FALLTHROUGH */
      case 'S':
	renaming_expr += 1;
	if (isdigit (*renaming_expr))
	  {
	    char *next;
	    long val = strtol (renaming_expr, &next, 10);
	    if (next == renaming_expr)
	      goto BadEncoding;
	    renaming_expr = next;
	    write_int (par_state, val, type_int (par_state));
	  }
	else
	  {
	    const char *end;
	    char *index_name;
	    struct block_symbol index_sym_info;

	    end = strchr (renaming_expr, 'X');
	    if (end == NULL)
	      end = renaming_expr + strlen (renaming_expr);

	    index_name = obstack_strndup (&temp_parse_space, renaming_expr,
					  end - renaming_expr);
	    renaming_expr = end;

	    ada_lookup_encoded_symbol (index_name, orig_left_context,
				       VAR_DOMAIN, &index_sym_info);
	    if (index_sym_info.symbol == NULL)
	      error (_("Could not find %s"), index_name);
	    else if (index_sym_info.symbol->aclass () == LOC_TYPEDEF)
	      /* Index is an old-style renaming symbol.  */
	      index_sym_info.block = orig_left_context;
	    write_var_from_sym (par_state, index_sym_info);
	  }
	if (slice_state == SIMPLE_INDEX)
	  ada_funcall (1);
	else if (slice_state == LOWER_BOUND)
	  slice_state = UPPER_BOUND;
	else if (slice_state == UPPER_BOUND)
	  {
	    ada_wrap3<ada_ternop_slice_operation> ();
	    slice_state = SIMPLE_INDEX;
	  }
	break;

      case 'R':
	{
	  const char *end;

	  renaming_expr += 1;

	  if (slice_state != SIMPLE_INDEX)
	    goto BadEncoding;
	  end = strchr (renaming_expr, 'X');
	  if (end == NULL)
	    end = renaming_expr + strlen (renaming_expr);

	  operation_up arg = ada_pop ();
	  pstate->push_new<ada_structop_operation>
	    (std::move (arg), std::string (renaming_expr,
					   end - renaming_expr));
	  renaming_expr = end;
	  break;
	}

      default:
	goto BadEncoding;
      }
    }
  if (slice_state == SIMPLE_INDEX)
    return;

 BadEncoding:
  error (_("Internal error in encoding of renaming declaration"));
}

static const struct block*
block_lookup (const struct block *context, const char *raw_name)
{
  const char *name;
  struct symtab *symtab;
  const struct block *result = NULL;

  std::string name_storage;
  if (raw_name[0] == '\'')
    {
      raw_name += 1;
      name = raw_name;
    }
  else
    {
      name_storage = ada_encode (raw_name);
      name = name_storage.c_str ();
    }

  std::vector<struct block_symbol> syms
    = ada_lookup_symbol_list (name, context, VAR_DOMAIN);

  if (context == NULL
      && (syms.empty () || syms[0].symbol->aclass () != LOC_BLOCK))
    symtab = lookup_symtab (name);
  else
    symtab = NULL;

  if (symtab != NULL)
    result = symtab->compunit ()->blockvector ()->static_block ();
  else if (syms.empty () || syms[0].symbol->aclass () != LOC_BLOCK)
    {
      if (context == NULL)
	error (_("No file or function \"%s\"."), raw_name);
      else
	error (_("No function \"%s\" in specified context."), raw_name);
    }
  else
    {
      if (syms.size () > 1)
	warning (_("Function name \"%s\" ambiguous here"), raw_name);
      result = syms[0].symbol->value_block ();
    }

  return result;
}

static struct symbol*
select_possible_type_sym (const std::vector<struct block_symbol> &syms)
{
  int i;
  int preferred_index;
  struct type *preferred_type;
	  
  preferred_index = -1; preferred_type = NULL;
  for (i = 0; i < syms.size (); i += 1)
    switch (syms[i].symbol->aclass ())
      {
      case LOC_TYPEDEF:
	if (ada_prefer_type (syms[i].symbol->type (), preferred_type))
	  {
	    preferred_index = i;
	    preferred_type = syms[i].symbol->type ();
	  }
	break;
      case LOC_REGISTER:
      case LOC_ARG:
      case LOC_REF_ARG:
      case LOC_REGPARM_ADDR:
      case LOC_LOCAL:
      case LOC_COMPUTED:
	return NULL;
      default:
	break;
      }
  if (preferred_type == NULL)
    return NULL;
  return syms[preferred_index].symbol;
}

static struct type*
find_primitive_type (struct parser_state *par_state, const char *name)
{
  struct type *type;
  type = language_lookup_primitive_type (par_state->language (),
					 par_state->gdbarch (),
					 name);
  if (type == NULL && strcmp ("system__address", name) == 0)
    type = type_system_address (par_state);

  if (type != NULL)
    {
      /* Check to see if we have a regular definition of this
	 type that just didn't happen to have been read yet.  */
      struct symbol *sym;
      char *expanded_name = 
	(char *) alloca (strlen (name) + sizeof ("standard__"));
      strcpy (expanded_name, "standard__");
      strcat (expanded_name, name);
      sym = ada_lookup_symbol (expanded_name, NULL, VAR_DOMAIN).symbol;
      if (sym != NULL && sym->aclass () == LOC_TYPEDEF)
	type = sym->type ();
    }

  return type;
}

static int
chop_selector (const char *name, int end)
{
  int i;
  for (i = end - 1; i > 0; i -= 1)
    if (name[i] == '.' || (name[i] == '_' && name[i+1] == '_'))
      return i;
  return -1;
}

/* If NAME is a string beginning with a separator (either '__', or
   '.'), chop this separator and return the result; else, return
   NAME.  */

static const char *
chop_separator (const char *name)
{
  if (*name == '.')
   return name + 1;

  if (name[0] == '_' && name[1] == '_')
    return name + 2;

  return name;
}

/* Given that SELS is a string of the form (<sep><identifier>)*, where
   <sep> is '__' or '.', write the indicated sequence of
   STRUCTOP_STRUCT expression operators.  Returns a pointer to the
   last operation that was pushed.  */
static ada_structop_operation *
write_selectors (struct parser_state *par_state, const char *sels)
{
  ada_structop_operation *result = nullptr;
  while (*sels != '\0')
    {
      const char *p = chop_separator (sels);
      sels = p;
      while (*sels != '\0' && *sels != '.' 
	     && (sels[0] != '_' || sels[1] != '_'))
	sels += 1;
      operation_up arg = ada_pop ();
      result = new ada_structop_operation (std::move (arg),
					   std::string (p, sels - p));
      pstate->push (operation_up (result));
    }
  return result;
}

/* Write a variable access (OP_VAR_VALUE) to ambiguous encoded name
   NAME[0..LEN-1], in block context BLOCK, to be resolved later.  Writes
   a temporary symbol that is valid until the next call to ada_parse.
   */
static void
write_ambiguous_var (struct parser_state *par_state,
		     const struct block *block, const char *name, int len)
{
  struct symbol *sym = new (&temp_parse_space) symbol ();

  sym->set_domain (UNDEF_DOMAIN);
  sym->set_linkage_name (obstack_strndup (&temp_parse_space, name, len));
  sym->set_language (language_ada, nullptr);

  block_symbol bsym { sym, block };
  par_state->push_new<ada_var_value_operation> (bsym);
}

/* A convenient wrapper around ada_get_field_index that takes
   a non NUL-terminated FIELD_NAME0 and a FIELD_NAME_LEN instead
   of a NUL-terminated field name.  */

static int
ada_nget_field_index (const struct type *type, const char *field_name0,
		      int field_name_len, int maybe_missing)
{
  char *field_name = (char *) alloca ((field_name_len + 1) * sizeof (char));

  strncpy (field_name, field_name0, field_name_len);
  field_name[field_name_len] = '\0';
  return ada_get_field_index (type, field_name, maybe_missing);
}

/* If encoded_field_name is the name of a field inside symbol SYM,
   then return the type of that field.  Otherwise, return NULL.

   This function is actually recursive, so if ENCODED_FIELD_NAME
   doesn't match one of the fields of our symbol, then try to see
   if ENCODED_FIELD_NAME could not be a succession of field names
   (in other words, the user entered an expression of the form
   TYPE_NAME.FIELD1.FIELD2.FIELD3), in which case we evaluate
   each field name sequentially to obtain the desired field type.
   In case of failure, we return NULL.  */

static struct type *
get_symbol_field_type (struct symbol *sym, const char *encoded_field_name)
{
  const char *field_name = encoded_field_name;
  const char *subfield_name;
  struct type *type = sym->type ();
  int fieldno;

  if (type == NULL || field_name == NULL)
    return NULL;
  type = check_typedef (type);

  while (field_name[0] != '\0')
    {
      field_name = chop_separator (field_name);

      fieldno = ada_get_field_index (type, field_name, 1);
      if (fieldno >= 0)
	return type->field (fieldno).type ();

      subfield_name = field_name;
      while (*subfield_name != '\0' && *subfield_name != '.' 
	     && (subfield_name[0] != '_' || subfield_name[1] != '_'))
	subfield_name += 1;

      if (subfield_name[0] == '\0')
	return NULL;

      fieldno = ada_nget_field_index (type, field_name,
				      subfield_name - field_name, 1);
      if (fieldno < 0)
	return NULL;

      type = type->field (fieldno).type ();
      field_name = subfield_name;
    }

  return NULL;
}

/* Look up NAME0 (an unencoded identifier or dotted name) in BLOCK (or 
   expression_block_context if NULL).  If it denotes a type, return
   that type.  Otherwise, write expression code to evaluate it as an
   object and return NULL. In this second case, NAME0 will, in general,
   have the form <name>(.<selector_name>)*, where <name> is an object
   or renaming encoded in the debugging data.  Calls error if no
   prefix <name> matches a name in the debugging data (i.e., matches
   either a complete name or, as a wild-card match, the final 
   identifier).  */

static struct type*
write_var_or_type (struct parser_state *par_state,
		   const struct block *block, struct stoken name0)
{
  int depth;
  char *encoded_name;
  int name_len;

  if (block == NULL)
    block = par_state->expression_context_block;

  std::string name_storage = ada_encode (name0.ptr);
  name_len = name_storage.size ();
  encoded_name = obstack_strndup (&temp_parse_space, name_storage.c_str (),
				  name_len);
  for (depth = 0; depth < MAX_RENAMING_CHAIN_LENGTH; depth += 1)
    {
      int tail_index;
      
      tail_index = name_len;
      while (tail_index > 0)
	{
	  struct symbol *type_sym;
	  struct symbol *renaming_sym;
	  const char* renaming;
	  int renaming_len;
	  const char* renaming_expr;
	  int terminator = encoded_name[tail_index];

	  encoded_name[tail_index] = '\0';
	  /* In order to avoid double-encoding, we want to only pass
	     the decoded form to lookup functions.  */
	  std::string decoded_name = ada_decode (encoded_name);
	  encoded_name[tail_index] = terminator;

	  std::vector<struct block_symbol> syms
	    = ada_lookup_symbol_list (decoded_name.c_str (), block, VAR_DOMAIN);

	  type_sym = select_possible_type_sym (syms);

	  if (type_sym != NULL)
	    renaming_sym = type_sym;
	  else if (syms.size () == 1)
	    renaming_sym = syms[0].symbol;
	  else 
	    renaming_sym = NULL;

	  switch (ada_parse_renaming (renaming_sym, &renaming,
				      &renaming_len, &renaming_expr))
	    {
	    case ADA_NOT_RENAMING:
	      break;
	    case ADA_PACKAGE_RENAMING:
	    case ADA_EXCEPTION_RENAMING:
	    case ADA_SUBPROGRAM_RENAMING:
	      {
		int alloc_len = renaming_len + name_len - tail_index + 1;
		char *new_name
		  = (char *) obstack_alloc (&temp_parse_space, alloc_len);
		strncpy (new_name, renaming, renaming_len);
		strcpy (new_name + renaming_len, encoded_name + tail_index);
		encoded_name = new_name;
		name_len = renaming_len + name_len - tail_index;
		goto TryAfterRenaming;
	      }	
	    case ADA_OBJECT_RENAMING:
	      write_object_renaming (par_state, block, renaming, renaming_len,
				     renaming_expr, MAX_RENAMING_CHAIN_LENGTH);
	      write_selectors (par_state, encoded_name + tail_index);
	      return NULL;
	    default:
	      internal_error (_("impossible value from ada_parse_renaming"));
	    }

	  if (type_sym != NULL)
	    {
	      struct type *field_type;
	      
	      if (tail_index == name_len)
		return type_sym->type ();

	      /* We have some extraneous characters after the type name.
		 If this is an expression "TYPE_NAME.FIELD0.[...].FIELDN",
		 then try to get the type of FIELDN.  */
	      field_type
		= get_symbol_field_type (type_sym, encoded_name + tail_index);
	      if (field_type != NULL)
		return field_type;
	      else 
		error (_("Invalid attempt to select from type: \"%s\"."),
		       name0.ptr);
	    }
	  else if (tail_index == name_len && syms.empty ())
	    {
	      struct type *type = find_primitive_type (par_state,
						       encoded_name);

	      if (type != NULL)
		return type;
	    }

	  if (syms.size () == 1)
	    {
	      write_var_from_sym (par_state, syms[0]);
	      write_selectors (par_state, encoded_name + tail_index);
	      return NULL;
	    }
	  else if (syms.empty ())
	    {
	      struct objfile *objfile = nullptr;
	      if (block != nullptr)
		objfile = block_objfile (block);

	      struct bound_minimal_symbol msym
		= ada_lookup_simple_minsym (decoded_name.c_str (), objfile);
	      if (msym.minsym != NULL)
		{
		  par_state->push_new<ada_var_msym_value_operation> (msym);
		  /* Maybe cause error here rather than later? FIXME? */
		  write_selectors (par_state, encoded_name + tail_index);
		  return NULL;
		}

	      if (tail_index == name_len
		  && strncmp (encoded_name, "standard__", 
			      sizeof ("standard__") - 1) == 0)
		error (_("No definition of \"%s\" found."), name0.ptr);

	      tail_index = chop_selector (encoded_name, tail_index);
	    } 
	  else
	    {
	      write_ambiguous_var (par_state, block, encoded_name,
				   tail_index);
	      write_selectors (par_state, encoded_name + tail_index);
	      return NULL;
	    }
	}

      if (!have_full_symbols () && !have_partial_symbols () && block == NULL)
	error (_("No symbol table is loaded.  Use the \"file\" command."));
      if (block == par_state->expression_context_block)
	error (_("No definition of \"%s\" in current context."), name0.ptr);
      else
	error (_("No definition of \"%s\" in specified context."), name0.ptr);
      
    TryAfterRenaming: ;
    }

  error (_("Could not find renamed symbol \"%s\""), name0.ptr);

}

/* Because ada_completer_word_break_characters does not contain '.' --
   and it cannot easily be added, this breaks other completions -- we
   have to recreate the completion word-splitting here, so that we can
   provide a prefix that is then used when completing field names.
   Without this, an attempt like "complete print abc.d" will give a
   result like "print def" rather than "print abc.def".  */

static std::string
find_completion_bounds (struct parser_state *par_state)
{
  const char *end = pstate->lexptr;
  /* First the end of the prefix.  Here we stop at the token start or
     at '.' or space.  */
  for (; end > original_expr && end[-1] != '.' && !isspace (end[-1]); --end)
    {
      /* Nothing.  */
    }
  /* Now find the start of the prefix.  */
  const char *ptr = end;
  /* Here we allow '.'.  */
  for (;
       ptr > original_expr && (ptr[-1] == '.'
			       || ptr[-1] == '_'
			       || (ptr[-1] >= 'a' && ptr[-1] <= 'z')
			       || (ptr[-1] >= 'A' && ptr[-1] <= 'Z')
			       || (ptr[-1] & 0xff) >= 0x80);
       --ptr)
    {
      /* Nothing.  */
    }
  /* ... except, skip leading spaces.  */
  ptr = skip_spaces (ptr);

  return std::string (ptr, end);
}

/* A wrapper for write_var_or_type that is used specifically when
   completion is requested for the last of a sequence of
   identifiers.  */

static struct type *
write_var_or_type_completion (struct parser_state *par_state,
			      const struct block *block, struct stoken name0)
{
  int tail_index = chop_selector (name0.ptr, name0.length);
  /* If there's no separator, just defer to ordinary symbol
     completion.  */
  if (tail_index == -1)
    return write_var_or_type (par_state, block, name0);

  std::string copy (name0.ptr, tail_index);
  struct type *type = write_var_or_type (par_state, block,
					 { copy.c_str (),
					   (int) copy.length () });
  /* For completion purposes, it's enough that we return a type
     here.  */
  if (type != nullptr)
    return type;

  ada_structop_operation *op = write_selectors (par_state,
						name0.ptr + tail_index);
  op->set_prefix (find_completion_bounds (par_state));
  par_state->mark_struct_expression (op);
  return nullptr;
}

/* Write a left side of a component association (e.g., NAME in NAME =>
   exp).  If NAME has the form of a selected component, write it as an
   ordinary expression.  If it is a simple variable that unambiguously
   corresponds to exactly one symbol that does not denote a type or an
   object renaming, also write it normally as an OP_VAR_VALUE.
   Otherwise, write it as an OP_NAME.

   Unfortunately, we don't know at this point whether NAME is supposed
   to denote a record component name or the value of an array index.
   Therefore, it is not appropriate to disambiguate an ambiguous name
   as we normally would, nor to replace a renaming with its referent.
   As a result, in the (one hopes) rare case that one writes an
   aggregate such as (R => 42) where R renames an object or is an
   ambiguous name, one must write instead ((R) => 42). */
   
static void
write_name_assoc (struct parser_state *par_state, struct stoken name)
{
  if (strchr (name.ptr, '.') == NULL)
    {
      std::vector<struct block_symbol> syms
	= ada_lookup_symbol_list (name.ptr,
				  par_state->expression_context_block,
				  VAR_DOMAIN);

      if (syms.size () != 1 || syms[0].symbol->aclass () == LOC_TYPEDEF)
	pstate->push_new<ada_string_operation> (copy_name (name));
      else
	write_var_from_sym (par_state, syms[0]);
    }
  else
    if (write_var_or_type (par_state, NULL, name) != NULL)
      error (_("Invalid use of type."));

  push_association<ada_name_association> (ada_pop ());
}

static struct type *
type_int (struct parser_state *par_state)
{
  return parse_type (par_state)->builtin_int;
}

static struct type *
type_long (struct parser_state *par_state)
{
  return parse_type (par_state)->builtin_long;
}

static struct type *
type_long_long (struct parser_state *par_state)
{
  return parse_type (par_state)->builtin_long_long;
}

static struct type *
type_long_double (struct parser_state *par_state)
{
  return parse_type (par_state)->builtin_long_double;
}

static struct type *
type_for_char (struct parser_state *par_state, ULONGEST value)
{
  if (value <= 0xff)
    return language_string_char_type (par_state->language (),
				      par_state->gdbarch ());
  else if (value <= 0xffff)
    return language_lookup_primitive_type (par_state->language (),
					   par_state->gdbarch (),
					   "wide_character");
  return language_lookup_primitive_type (par_state->language (),
					 par_state->gdbarch (),
					 "wide_wide_character");
}

static struct type *
type_boolean (struct parser_state *par_state)
{
  return parse_type (par_state)->builtin_bool;
}

static struct type *
type_system_address (struct parser_state *par_state)
{
  struct type *type 
    = language_lookup_primitive_type (par_state->language (),
				      par_state->gdbarch (),
				      "system__address");
  return  type != NULL ? type : parse_type (par_state)->builtin_data_ptr;
}

void _initialize_ada_exp ();
void
_initialize_ada_exp ()
{
  obstack_init (&temp_parse_space);
}
