#if defined(USG) && !defined(hpux)

/* SysV version of bcopy from Eric Newton */

void libgxx_bcopy (void *source, void *dest, int count)
{
  /* No overlapping */
  if (source == dest)
    return;
  else if (source < dest && source+count > dest)
  {
     memcpy(dest, source, count);
     return;
  }
  else if (dest < source && dest+count < source)
  {
     memcpy(dest, source, count);
     return;
  }
  else
  {
    char* s = (char*) source;
    char* d = (char*) dest;
    if (s > d)
    {
      while (count-- > 0) *d++ = *s++;
      return;
    }
    else
    {
      count--;
      d = &d[count];
      s = &s[count];
      while (count-- >= 0) *d-- = *s--;
      return;
    }
  }
}

#endif
