/*
 * Author: Heinz Mauelshagen, Germany (mge@ez-darmstadt.telekom.de)
 *
 * May 1998
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

#include <liblvm.h>

char *dirname = NULL;
int lvm_dir_cache_select ( const struct dirent*);


int lvm_dir_cache ( dir_cache_t **dir_cache_ptr) {
   static int cache_size = 0;
   int d = 0;
   int dirent_count = 0;
   int n = 0;
   char name[NAME_LEN] = { 0, };
   static char *devdir[] = {
      "/dev/dsk",
      "/dev",
      NULL
   };
   struct dirent **dirent = NULL;
   struct stat stat_b;
   static dir_cache_t *dir_cache = NULL;
   dir_cache_t *dir_cache_sav = NULL;


#ifdef DEBUG
         debug ( "lvm_dir_cache -- CALLED\n");
#endif
   if ( dir_cache_ptr == NULL) return -LVM_EPARA;

   if ( dir_cache == NULL) {
      for ( d = 0; devdir[d] != NULL; d++) {
         dirname = devdir[d];
#ifdef DEBUG
         debug ( "lvm_dir_cache -- calling scandir() with %s\n",
                 dirname);
#endif
         if ( ( dirent_count = scandir ( dirname, &dirent,
                                         lvm_dir_cache_select,
                                         alphasort)) > 0) {
            for ( n = 0; n < dirent_count; n++) {

               sprintf ( name, "%s/%s%c", dirname, dirent[n]->d_name, 0);
               if ( stat ( name, &stat_b) == -1) continue;
               if ( lvm_check_dev ( &stat_b, TRUE) == FALSE) continue;
         
               dir_cache_sav = dir_cache;
               if ( ( dir_cache =
                         realloc ( dir_cache,
                                   ( cache_size + 1) *
                                     sizeof ( dir_cache_t))) == NULL) {
                  fprintf ( stderr, "realloc error in %s [line %d]\n",
                                    __FILE__, __LINE__);
                  if ( dir_cache_sav != NULL) free ( dir_cache_sav);
                  dir_cache_sav = NULL;
                     return 0;
               }
         
               if ( ( dir_cache[cache_size].dev_name =
                         malloc ( strlen ( name) + 1 )) == NULL) {
                  fprintf ( stderr, "malloc error in %s [line %d]\n",
                                    __FILE__, __LINE__);
                  free ( dir_cache);
                  dir_cache = dir_cache_sav = NULL;
                  return 0;
               }
         
               strcpy ( dir_cache[cache_size].dev_name, name);
               dir_cache[cache_size].st_rdev = stat_b.st_rdev;
               dir_cache[cache_size].st_mode = stat_b.st_mode;
               cache_size++;
            }
            for ( n = 0; n < dirent_count; n++) free ( dirent[n]);
            free ( dirent);
         }
#ifdef DEBUG
         debug ( "lvm_dir_cache -- AFTER calling scandir() "
                 "with %s\n", dirname);
#endif
      }
   }

   *dir_cache_ptr = dir_cache;
#ifdef DEBUG
         debug ( "lvm_dir_cache -- LEAVING wit cache_size: %d\n", cache_size);
#endif
   return cache_size;
}


/* internal selection function for scandir() */
/* gets all c*, sd*, hd* and md* with name adn st_rdev into cache */
int lvm_dir_cache_select ( const struct dirent *dirent) {
   if ( ( strcmp ( dirname, "/dev/dsk") == 0 &&
          dirent->d_name[0] == 'c') ||     /* new /dev/dsk/c#t#d#s# special */
        ( ( dirent->d_name[0] == 's' ||    /* old /dev/sd[a-z]* special */
            dirent->d_name[0] == 'h' ||    /* old /dev/hd[a-z]* special */
            dirent->d_name[0] == 'm') &&   /* old /dev/md[a-z]* special */
            dirent->d_name[1] == 'd')) {   /* the 'd' of the 3 above */
      return 1;
   } else return 0;
}
